# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetRestorableDatabaseAccountsResult',
    'AwaitableGetRestorableDatabaseAccountsResult',
    'get_restorable_database_accounts',
    'get_restorable_database_accounts_output',
]

@pulumi.output_type
class GetRestorableDatabaseAccountsResult:
    """
    A collection of values returned by getRestorableDatabaseAccounts.
    """
    def __init__(__self__, accounts=None, id=None, location=None, name=None):
        if accounts and not isinstance(accounts, list):
            raise TypeError("Expected argument 'accounts' to be a list")
        pulumi.set(__self__, "accounts", accounts)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def accounts(self) -> Sequence['outputs.GetRestorableDatabaseAccountsAccountResult']:
        """
        One or more `accounts` blocks as defined below.
        """
        return pulumi.get(self, "accounts")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def location(self) -> builtins.str:
        """
        The location of the regional Cosmos DB Restorable Database Account.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")


class AwaitableGetRestorableDatabaseAccountsResult(GetRestorableDatabaseAccountsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRestorableDatabaseAccountsResult(
            accounts=self.accounts,
            id=self.id,
            location=self.location,
            name=self.name)


def get_restorable_database_accounts(location: Optional[builtins.str] = None,
                                     name: Optional[builtins.str] = None,
                                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRestorableDatabaseAccountsResult:
    """
    Use this data source to access information about Cosmos DB Restorable Database Accounts.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.cosmosdb.get_restorable_database_accounts(name="example-ca",
        location="West Europe")
    pulumi.export("id", example.id)
    ```


    :param builtins.str location: The location where the Cosmos DB Database Account.
    :param builtins.str name: The name of this Cosmos DB Database Account.
    """
    __args__ = dict()
    __args__['location'] = location
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:cosmosdb/getRestorableDatabaseAccounts:getRestorableDatabaseAccounts', __args__, opts=opts, typ=GetRestorableDatabaseAccountsResult).value

    return AwaitableGetRestorableDatabaseAccountsResult(
        accounts=pulumi.get(__ret__, 'accounts'),
        id=pulumi.get(__ret__, 'id'),
        location=pulumi.get(__ret__, 'location'),
        name=pulumi.get(__ret__, 'name'))
def get_restorable_database_accounts_output(location: Optional[pulumi.Input[builtins.str]] = None,
                                            name: Optional[pulumi.Input[builtins.str]] = None,
                                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRestorableDatabaseAccountsResult]:
    """
    Use this data source to access information about Cosmos DB Restorable Database Accounts.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.cosmosdb.get_restorable_database_accounts(name="example-ca",
        location="West Europe")
    pulumi.export("id", example.id)
    ```


    :param builtins.str location: The location where the Cosmos DB Database Account.
    :param builtins.str name: The name of this Cosmos DB Database Account.
    """
    __args__ = dict()
    __args__['location'] = location
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:cosmosdb/getRestorableDatabaseAccounts:getRestorableDatabaseAccounts', __args__, opts=opts, typ=GetRestorableDatabaseAccountsResult)
    return __ret__.apply(lambda __response__: GetRestorableDatabaseAccountsResult(
        accounts=pulumi.get(__response__, 'accounts'),
        id=pulumi.get(__response__, 'id'),
        location=pulumi.get(__response__, 'location'),
        name=pulumi.get(__response__, 'name')))
