# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MongoCollectionArgs', 'MongoCollection']

@pulumi.input_type
class MongoCollectionArgs:
    def __init__(__self__, *,
                 account_name: pulumi.Input[builtins.str],
                 database_name: pulumi.Input[builtins.str],
                 resource_group_name: pulumi.Input[builtins.str],
                 analytical_storage_ttl: Optional[pulumi.Input[builtins.int]] = None,
                 autoscale_settings: Optional[pulumi.Input['MongoCollectionAutoscaleSettingsArgs']] = None,
                 default_ttl_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 indices: Optional[pulumi.Input[Sequence[pulumi.Input['MongoCollectionIndexArgs']]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 shard_key: Optional[pulumi.Input[builtins.str]] = None,
                 throughput: Optional[pulumi.Input[builtins.int]] = None):
        """
        The set of arguments for constructing a MongoCollection resource.
        :param pulumi.Input[builtins.str] account_name: The name of the Cosmos DB Account in which the Cosmos DB Mongo Collection is created. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] database_name: The name of the Cosmos DB Mongo Database in which the Cosmos DB Mongo Collection is created. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group in which the Cosmos DB Mongo Collection is created. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.int] analytical_storage_ttl: The default time to live of Analytical Storage for this Mongo Collection. If present and the value is set to `-1`, it is equal to infinity, and items don’t expire by default. If present and the value is set to some number `n` – items will expire `n` seconds after their last modified time.
        :param pulumi.Input[builtins.int] default_ttl_seconds: The default Time To Live in seconds. If the value is `-1`, items are not automatically expired.
        :param pulumi.Input[Sequence[pulumi.Input['MongoCollectionIndexArgs']]] indices: One or more `index` blocks as defined below.
        :param pulumi.Input[builtins.str] name: Specifies the name of the Cosmos DB Mongo Collection. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] shard_key: The name of the key to partition on for sharding. There must not be any other unique index keys. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "account_name", account_name)
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if analytical_storage_ttl is not None:
            pulumi.set(__self__, "analytical_storage_ttl", analytical_storage_ttl)
        if autoscale_settings is not None:
            pulumi.set(__self__, "autoscale_settings", autoscale_settings)
        if default_ttl_seconds is not None:
            pulumi.set(__self__, "default_ttl_seconds", default_ttl_seconds)
        if indices is not None:
            pulumi.set(__self__, "indices", indices)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if shard_key is not None:
            pulumi.set(__self__, "shard_key", shard_key)
        if throughput is not None:
            pulumi.set(__self__, "throughput", throughput)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the Cosmos DB Account in which the Cosmos DB Mongo Collection is created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "account_name")

    @account_name.setter
    def account_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "account_name", value)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the Cosmos DB Mongo Database in which the Cosmos DB Mongo Collection is created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "database_name", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the resource group in which the Cosmos DB Mongo Collection is created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="analyticalStorageTtl")
    def analytical_storage_ttl(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The default time to live of Analytical Storage for this Mongo Collection. If present and the value is set to `-1`, it is equal to infinity, and items don’t expire by default. If present and the value is set to some number `n` – items will expire `n` seconds after their last modified time.
        """
        return pulumi.get(self, "analytical_storage_ttl")

    @analytical_storage_ttl.setter
    def analytical_storage_ttl(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "analytical_storage_ttl", value)

    @property
    @pulumi.getter(name="autoscaleSettings")
    def autoscale_settings(self) -> Optional[pulumi.Input['MongoCollectionAutoscaleSettingsArgs']]:
        return pulumi.get(self, "autoscale_settings")

    @autoscale_settings.setter
    def autoscale_settings(self, value: Optional[pulumi.Input['MongoCollectionAutoscaleSettingsArgs']]):
        pulumi.set(self, "autoscale_settings", value)

    @property
    @pulumi.getter(name="defaultTtlSeconds")
    def default_ttl_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The default Time To Live in seconds. If the value is `-1`, items are not automatically expired.
        """
        return pulumi.get(self, "default_ttl_seconds")

    @default_ttl_seconds.setter
    def default_ttl_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "default_ttl_seconds", value)

    @property
    @pulumi.getter
    def indices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MongoCollectionIndexArgs']]]]:
        """
        One or more `index` blocks as defined below.
        """
        return pulumi.get(self, "indices")

    @indices.setter
    def indices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MongoCollectionIndexArgs']]]]):
        pulumi.set(self, "indices", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the Cosmos DB Mongo Collection. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="shardKey")
    def shard_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the key to partition on for sharding. There must not be any other unique index keys. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "shard_key")

    @shard_key.setter
    def shard_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "shard_key", value)

    @property
    @pulumi.getter
    def throughput(self) -> Optional[pulumi.Input[builtins.int]]:
        return pulumi.get(self, "throughput")

    @throughput.setter
    def throughput(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "throughput", value)


@pulumi.input_type
class _MongoCollectionState:
    def __init__(__self__, *,
                 account_name: Optional[pulumi.Input[builtins.str]] = None,
                 analytical_storage_ttl: Optional[pulumi.Input[builtins.int]] = None,
                 autoscale_settings: Optional[pulumi.Input['MongoCollectionAutoscaleSettingsArgs']] = None,
                 database_name: Optional[pulumi.Input[builtins.str]] = None,
                 default_ttl_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 indices: Optional[pulumi.Input[Sequence[pulumi.Input['MongoCollectionIndexArgs']]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 shard_key: Optional[pulumi.Input[builtins.str]] = None,
                 system_indexes: Optional[pulumi.Input[Sequence[pulumi.Input['MongoCollectionSystemIndexArgs']]]] = None,
                 throughput: Optional[pulumi.Input[builtins.int]] = None):
        """
        Input properties used for looking up and filtering MongoCollection resources.
        :param pulumi.Input[builtins.str] account_name: The name of the Cosmos DB Account in which the Cosmos DB Mongo Collection is created. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.int] analytical_storage_ttl: The default time to live of Analytical Storage for this Mongo Collection. If present and the value is set to `-1`, it is equal to infinity, and items don’t expire by default. If present and the value is set to some number `n` – items will expire `n` seconds after their last modified time.
        :param pulumi.Input[builtins.str] database_name: The name of the Cosmos DB Mongo Database in which the Cosmos DB Mongo Collection is created. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.int] default_ttl_seconds: The default Time To Live in seconds. If the value is `-1`, items are not automatically expired.
        :param pulumi.Input[Sequence[pulumi.Input['MongoCollectionIndexArgs']]] indices: One or more `index` blocks as defined below.
        :param pulumi.Input[builtins.str] name: Specifies the name of the Cosmos DB Mongo Collection. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group in which the Cosmos DB Mongo Collection is created. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] shard_key: The name of the key to partition on for sharding. There must not be any other unique index keys. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input['MongoCollectionSystemIndexArgs']]] system_indexes: One or more `system_indexes` blocks as defined below.
        """
        if account_name is not None:
            pulumi.set(__self__, "account_name", account_name)
        if analytical_storage_ttl is not None:
            pulumi.set(__self__, "analytical_storage_ttl", analytical_storage_ttl)
        if autoscale_settings is not None:
            pulumi.set(__self__, "autoscale_settings", autoscale_settings)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if default_ttl_seconds is not None:
            pulumi.set(__self__, "default_ttl_seconds", default_ttl_seconds)
        if indices is not None:
            pulumi.set(__self__, "indices", indices)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if shard_key is not None:
            pulumi.set(__self__, "shard_key", shard_key)
        if system_indexes is not None:
            pulumi.set(__self__, "system_indexes", system_indexes)
        if throughput is not None:
            pulumi.set(__self__, "throughput", throughput)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Cosmos DB Account in which the Cosmos DB Mongo Collection is created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "account_name")

    @account_name.setter
    def account_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "account_name", value)

    @property
    @pulumi.getter(name="analyticalStorageTtl")
    def analytical_storage_ttl(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The default time to live of Analytical Storage for this Mongo Collection. If present and the value is set to `-1`, it is equal to infinity, and items don’t expire by default. If present and the value is set to some number `n` – items will expire `n` seconds after their last modified time.
        """
        return pulumi.get(self, "analytical_storage_ttl")

    @analytical_storage_ttl.setter
    def analytical_storage_ttl(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "analytical_storage_ttl", value)

    @property
    @pulumi.getter(name="autoscaleSettings")
    def autoscale_settings(self) -> Optional[pulumi.Input['MongoCollectionAutoscaleSettingsArgs']]:
        return pulumi.get(self, "autoscale_settings")

    @autoscale_settings.setter
    def autoscale_settings(self, value: Optional[pulumi.Input['MongoCollectionAutoscaleSettingsArgs']]):
        pulumi.set(self, "autoscale_settings", value)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Cosmos DB Mongo Database in which the Cosmos DB Mongo Collection is created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "database_name", value)

    @property
    @pulumi.getter(name="defaultTtlSeconds")
    def default_ttl_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The default Time To Live in seconds. If the value is `-1`, items are not automatically expired.
        """
        return pulumi.get(self, "default_ttl_seconds")

    @default_ttl_seconds.setter
    def default_ttl_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "default_ttl_seconds", value)

    @property
    @pulumi.getter
    def indices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MongoCollectionIndexArgs']]]]:
        """
        One or more `index` blocks as defined below.
        """
        return pulumi.get(self, "indices")

    @indices.setter
    def indices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MongoCollectionIndexArgs']]]]):
        pulumi.set(self, "indices", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the Cosmos DB Mongo Collection. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the resource group in which the Cosmos DB Mongo Collection is created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="shardKey")
    def shard_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the key to partition on for sharding. There must not be any other unique index keys. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "shard_key")

    @shard_key.setter
    def shard_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "shard_key", value)

    @property
    @pulumi.getter(name="systemIndexes")
    def system_indexes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MongoCollectionSystemIndexArgs']]]]:
        """
        One or more `system_indexes` blocks as defined below.
        """
        return pulumi.get(self, "system_indexes")

    @system_indexes.setter
    def system_indexes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MongoCollectionSystemIndexArgs']]]]):
        pulumi.set(self, "system_indexes", value)

    @property
    @pulumi.getter
    def throughput(self) -> Optional[pulumi.Input[builtins.int]]:
        return pulumi.get(self, "throughput")

    @throughput.setter
    def throughput(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "throughput", value)


@pulumi.type_token("azure:cosmosdb/mongoCollection:MongoCollection")
class MongoCollection(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_name: Optional[pulumi.Input[builtins.str]] = None,
                 analytical_storage_ttl: Optional[pulumi.Input[builtins.int]] = None,
                 autoscale_settings: Optional[pulumi.Input[Union['MongoCollectionAutoscaleSettingsArgs', 'MongoCollectionAutoscaleSettingsArgsDict']]] = None,
                 database_name: Optional[pulumi.Input[builtins.str]] = None,
                 default_ttl_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 indices: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MongoCollectionIndexArgs', 'MongoCollectionIndexArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 shard_key: Optional[pulumi.Input[builtins.str]] = None,
                 throughput: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        """
        Manages a Mongo Collection within a Cosmos DB Account.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.cosmosdb.get_account(name="tfex-cosmosdb-account",
            resource_group_name="tfex-cosmosdb-account-rg")
        example_mongo_database = azure.cosmosdb.MongoDatabase("example",
            name="tfex-cosmos-mongo-db",
            resource_group_name=example.resource_group_name,
            account_name=example.name)
        example_mongo_collection = azure.cosmosdb.MongoCollection("example",
            name="tfex-cosmos-mongo-db",
            resource_group_name=example.resource_group_name,
            account_name=example.name,
            database_name=example_mongo_database.name,
            default_ttl_seconds=777,
            shard_key="uniqueKey",
            throughput=400,
            indices=[{
                "keys": ["_id"],
                "unique": True,
            }])
        ```

        ## Import

        CosmosDB Mongo Collection can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:cosmosdb/mongoCollection:MongoCollection collection1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.DocumentDB/databaseAccounts/account1/mongodbDatabases/db1/collections/collection1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] account_name: The name of the Cosmos DB Account in which the Cosmos DB Mongo Collection is created. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.int] analytical_storage_ttl: The default time to live of Analytical Storage for this Mongo Collection. If present and the value is set to `-1`, it is equal to infinity, and items don’t expire by default. If present and the value is set to some number `n` – items will expire `n` seconds after their last modified time.
        :param pulumi.Input[builtins.str] database_name: The name of the Cosmos DB Mongo Database in which the Cosmos DB Mongo Collection is created. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.int] default_ttl_seconds: The default Time To Live in seconds. If the value is `-1`, items are not automatically expired.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MongoCollectionIndexArgs', 'MongoCollectionIndexArgsDict']]]] indices: One or more `index` blocks as defined below.
        :param pulumi.Input[builtins.str] name: Specifies the name of the Cosmos DB Mongo Collection. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group in which the Cosmos DB Mongo Collection is created. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] shard_key: The name of the key to partition on for sharding. There must not be any other unique index keys. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MongoCollectionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Mongo Collection within a Cosmos DB Account.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.cosmosdb.get_account(name="tfex-cosmosdb-account",
            resource_group_name="tfex-cosmosdb-account-rg")
        example_mongo_database = azure.cosmosdb.MongoDatabase("example",
            name="tfex-cosmos-mongo-db",
            resource_group_name=example.resource_group_name,
            account_name=example.name)
        example_mongo_collection = azure.cosmosdb.MongoCollection("example",
            name="tfex-cosmos-mongo-db",
            resource_group_name=example.resource_group_name,
            account_name=example.name,
            database_name=example_mongo_database.name,
            default_ttl_seconds=777,
            shard_key="uniqueKey",
            throughput=400,
            indices=[{
                "keys": ["_id"],
                "unique": True,
            }])
        ```

        ## Import

        CosmosDB Mongo Collection can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:cosmosdb/mongoCollection:MongoCollection collection1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.DocumentDB/databaseAccounts/account1/mongodbDatabases/db1/collections/collection1
        ```

        :param str resource_name: The name of the resource.
        :param MongoCollectionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MongoCollectionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_name: Optional[pulumi.Input[builtins.str]] = None,
                 analytical_storage_ttl: Optional[pulumi.Input[builtins.int]] = None,
                 autoscale_settings: Optional[pulumi.Input[Union['MongoCollectionAutoscaleSettingsArgs', 'MongoCollectionAutoscaleSettingsArgsDict']]] = None,
                 database_name: Optional[pulumi.Input[builtins.str]] = None,
                 default_ttl_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 indices: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MongoCollectionIndexArgs', 'MongoCollectionIndexArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 shard_key: Optional[pulumi.Input[builtins.str]] = None,
                 throughput: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MongoCollectionArgs.__new__(MongoCollectionArgs)

            if account_name is None and not opts.urn:
                raise TypeError("Missing required property 'account_name'")
            __props__.__dict__["account_name"] = account_name
            __props__.__dict__["analytical_storage_ttl"] = analytical_storage_ttl
            __props__.__dict__["autoscale_settings"] = autoscale_settings
            if database_name is None and not opts.urn:
                raise TypeError("Missing required property 'database_name'")
            __props__.__dict__["database_name"] = database_name
            __props__.__dict__["default_ttl_seconds"] = default_ttl_seconds
            __props__.__dict__["indices"] = indices
            __props__.__dict__["name"] = name
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["shard_key"] = shard_key
            __props__.__dict__["throughput"] = throughput
            __props__.__dict__["system_indexes"] = None
        super(MongoCollection, __self__).__init__(
            'azure:cosmosdb/mongoCollection:MongoCollection',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_name: Optional[pulumi.Input[builtins.str]] = None,
            analytical_storage_ttl: Optional[pulumi.Input[builtins.int]] = None,
            autoscale_settings: Optional[pulumi.Input[Union['MongoCollectionAutoscaleSettingsArgs', 'MongoCollectionAutoscaleSettingsArgsDict']]] = None,
            database_name: Optional[pulumi.Input[builtins.str]] = None,
            default_ttl_seconds: Optional[pulumi.Input[builtins.int]] = None,
            indices: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MongoCollectionIndexArgs', 'MongoCollectionIndexArgsDict']]]]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
            shard_key: Optional[pulumi.Input[builtins.str]] = None,
            system_indexes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MongoCollectionSystemIndexArgs', 'MongoCollectionSystemIndexArgsDict']]]]] = None,
            throughput: Optional[pulumi.Input[builtins.int]] = None) -> 'MongoCollection':
        """
        Get an existing MongoCollection resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] account_name: The name of the Cosmos DB Account in which the Cosmos DB Mongo Collection is created. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.int] analytical_storage_ttl: The default time to live of Analytical Storage for this Mongo Collection. If present and the value is set to `-1`, it is equal to infinity, and items don’t expire by default. If present and the value is set to some number `n` – items will expire `n` seconds after their last modified time.
        :param pulumi.Input[builtins.str] database_name: The name of the Cosmos DB Mongo Database in which the Cosmos DB Mongo Collection is created. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.int] default_ttl_seconds: The default Time To Live in seconds. If the value is `-1`, items are not automatically expired.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MongoCollectionIndexArgs', 'MongoCollectionIndexArgsDict']]]] indices: One or more `index` blocks as defined below.
        :param pulumi.Input[builtins.str] name: Specifies the name of the Cosmos DB Mongo Collection. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group in which the Cosmos DB Mongo Collection is created. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] shard_key: The name of the key to partition on for sharding. There must not be any other unique index keys. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MongoCollectionSystemIndexArgs', 'MongoCollectionSystemIndexArgsDict']]]] system_indexes: One or more `system_indexes` blocks as defined below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MongoCollectionState.__new__(_MongoCollectionState)

        __props__.__dict__["account_name"] = account_name
        __props__.__dict__["analytical_storage_ttl"] = analytical_storage_ttl
        __props__.__dict__["autoscale_settings"] = autoscale_settings
        __props__.__dict__["database_name"] = database_name
        __props__.__dict__["default_ttl_seconds"] = default_ttl_seconds
        __props__.__dict__["indices"] = indices
        __props__.__dict__["name"] = name
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["shard_key"] = shard_key
        __props__.__dict__["system_indexes"] = system_indexes
        __props__.__dict__["throughput"] = throughput
        return MongoCollection(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Cosmos DB Account in which the Cosmos DB Mongo Collection is created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "account_name")

    @property
    @pulumi.getter(name="analyticalStorageTtl")
    def analytical_storage_ttl(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The default time to live of Analytical Storage for this Mongo Collection. If present and the value is set to `-1`, it is equal to infinity, and items don’t expire by default. If present and the value is set to some number `n` – items will expire `n` seconds after their last modified time.
        """
        return pulumi.get(self, "analytical_storage_ttl")

    @property
    @pulumi.getter(name="autoscaleSettings")
    def autoscale_settings(self) -> pulumi.Output[Optional['outputs.MongoCollectionAutoscaleSettings']]:
        return pulumi.get(self, "autoscale_settings")

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Cosmos DB Mongo Database in which the Cosmos DB Mongo Collection is created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter(name="defaultTtlSeconds")
    def default_ttl_seconds(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The default Time To Live in seconds. If the value is `-1`, items are not automatically expired.
        """
        return pulumi.get(self, "default_ttl_seconds")

    @property
    @pulumi.getter
    def indices(self) -> pulumi.Output[Optional[Sequence['outputs.MongoCollectionIndex']]]:
        """
        One or more `index` blocks as defined below.
        """
        return pulumi.get(self, "indices")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the name of the Cosmos DB Mongo Collection. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the resource group in which the Cosmos DB Mongo Collection is created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter(name="shardKey")
    def shard_key(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The name of the key to partition on for sharding. There must not be any other unique index keys. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "shard_key")

    @property
    @pulumi.getter(name="systemIndexes")
    def system_indexes(self) -> pulumi.Output[Sequence['outputs.MongoCollectionSystemIndex']]:
        """
        One or more `system_indexes` blocks as defined below.
        """
        return pulumi.get(self, "system_indexes")

    @property
    @pulumi.getter
    def throughput(self) -> pulumi.Output[builtins.int]:
        return pulumi.get(self, "throughput")

