# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'AccountAnalyticalStorage',
    'AccountBackup',
    'AccountCapability',
    'AccountCapacity',
    'AccountConsistencyPolicy',
    'AccountCorsRule',
    'AccountGeoLocation',
    'AccountIdentity',
    'AccountRestore',
    'AccountRestoreDatabase',
    'AccountRestoreGremlinDatabase',
    'AccountVirtualNetworkRule',
    'CassandraClusterIdentity',
    'CassandraKeyspaceAutoscaleSettings',
    'CassandraTableAutoscaleSettings',
    'CassandraTableSchema',
    'CassandraTableSchemaClusterKey',
    'CassandraTableSchemaColumn',
    'CassandraTableSchemaPartitionKey',
    'GremlinDatabaseAutoscaleSettings',
    'GremlinGraphAutoscaleSettings',
    'GremlinGraphConflictResolutionPolicy',
    'GremlinGraphIndexPolicy',
    'GremlinGraphIndexPolicyCompositeIndex',
    'GremlinGraphIndexPolicyCompositeIndexIndex',
    'GremlinGraphIndexPolicySpatialIndex',
    'GremlinGraphUniqueKey',
    'MongoClusterConnectionString',
    'MongoCollectionAutoscaleSettings',
    'MongoCollectionIndex',
    'MongoCollectionSystemIndex',
    'MongoDatabaseAutoscaleSettings',
    'MongoRoleDefinitionPrivilege',
    'MongoRoleDefinitionPrivilegeResource',
    'PostgresqlClusterMaintenanceWindow',
    'PostgresqlClusterServer',
    'SqlContainerAutoscaleSettings',
    'SqlContainerConflictResolutionPolicy',
    'SqlContainerIndexingPolicy',
    'SqlContainerIndexingPolicyCompositeIndex',
    'SqlContainerIndexingPolicyCompositeIndexIndex',
    'SqlContainerIndexingPolicyExcludedPath',
    'SqlContainerIndexingPolicyIncludedPath',
    'SqlContainerIndexingPolicySpatialIndex',
    'SqlContainerUniqueKey',
    'SqlDatabaseAutoscaleSettings',
    'SqlRoleDefinitionPermission',
    'TableAutoscaleSettings',
    'GetAccountCapabilityResult',
    'GetAccountConsistencyPolicyResult',
    'GetAccountGeoLocationResult',
    'GetAccountVirtualNetworkRuleResult',
    'GetRestorableDatabaseAccountsAccountResult',
    'GetRestorableDatabaseAccountsAccountRestorableLocationResult',
    'GetSqlDatabaseAutoscaleSettingResult',
    'GetSqlRoleDefinitionPermissionResult',
]

@pulumi.output_type
class AccountAnalyticalStorage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "schemaType":
            suggest = "schema_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccountAnalyticalStorage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccountAnalyticalStorage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccountAnalyticalStorage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 schema_type: builtins.str):
        """
        :param builtins.str schema_type: The schema type of the Analytical Storage for this Cosmos DB account. Possible values are `FullFidelity` and `WellDefined`.
        """
        pulumi.set(__self__, "schema_type", schema_type)

    @property
    @pulumi.getter(name="schemaType")
    def schema_type(self) -> builtins.str:
        """
        The schema type of the Analytical Storage for this Cosmos DB account. Possible values are `FullFidelity` and `WellDefined`.
        """
        return pulumi.get(self, "schema_type")


@pulumi.output_type
class AccountBackup(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "intervalInMinutes":
            suggest = "interval_in_minutes"
        elif key == "retentionInHours":
            suggest = "retention_in_hours"
        elif key == "storageRedundancy":
            suggest = "storage_redundancy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccountBackup. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccountBackup.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccountBackup.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: builtins.str,
                 interval_in_minutes: Optional[builtins.int] = None,
                 retention_in_hours: Optional[builtins.int] = None,
                 storage_redundancy: Optional[builtins.str] = None,
                 tier: Optional[builtins.str] = None):
        """
        :param builtins.str type: The type of the `backup`. Possible values are `Continuous` and `Periodic`.
               
               > **Note:** Migration of `Periodic` to `Continuous` is one-way, changing `Continuous` to `Periodic` forces a new resource to be created.
        :param builtins.int interval_in_minutes: The interval in minutes between two backups. Possible values are between 60 and 1440. Defaults to `240`.
        :param builtins.int retention_in_hours: The time in hours that each backup is retained. Possible values are between 8 and 720. Defaults to `8`.
        :param builtins.str storage_redundancy: The storage redundancy is used to indicate the type of backup residency. Possible values are `Geo`, `Local` and `Zone`. Defaults to `Geo`.
               
               > **Note:** You can only configure `interval_in_minutes`, `retention_in_hours` and `storage_redundancy` when the `type` field is set to `Periodic`.
        :param builtins.str tier: The continuous backup tier. Possible values are `Continuous7Days` and `Continuous30Days`.
        """
        pulumi.set(__self__, "type", type)
        if interval_in_minutes is not None:
            pulumi.set(__self__, "interval_in_minutes", interval_in_minutes)
        if retention_in_hours is not None:
            pulumi.set(__self__, "retention_in_hours", retention_in_hours)
        if storage_redundancy is not None:
            pulumi.set(__self__, "storage_redundancy", storage_redundancy)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The type of the `backup`. Possible values are `Continuous` and `Periodic`.

        > **Note:** Migration of `Periodic` to `Continuous` is one-way, changing `Continuous` to `Periodic` forces a new resource to be created.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="intervalInMinutes")
    def interval_in_minutes(self) -> Optional[builtins.int]:
        """
        The interval in minutes between two backups. Possible values are between 60 and 1440. Defaults to `240`.
        """
        return pulumi.get(self, "interval_in_minutes")

    @property
    @pulumi.getter(name="retentionInHours")
    def retention_in_hours(self) -> Optional[builtins.int]:
        """
        The time in hours that each backup is retained. Possible values are between 8 and 720. Defaults to `8`.
        """
        return pulumi.get(self, "retention_in_hours")

    @property
    @pulumi.getter(name="storageRedundancy")
    def storage_redundancy(self) -> Optional[builtins.str]:
        """
        The storage redundancy is used to indicate the type of backup residency. Possible values are `Geo`, `Local` and `Zone`. Defaults to `Geo`.

        > **Note:** You can only configure `interval_in_minutes`, `retention_in_hours` and `storage_redundancy` when the `type` field is set to `Periodic`.
        """
        return pulumi.get(self, "storage_redundancy")

    @property
    @pulumi.getter
    def tier(self) -> Optional[builtins.str]:
        """
        The continuous backup tier. Possible values are `Continuous7Days` and `Continuous30Days`.
        """
        return pulumi.get(self, "tier")


@pulumi.output_type
class AccountCapability(dict):
    def __init__(__self__, *,
                 name: builtins.str):
        """
        :param builtins.str name: Specifies the name of the CosmosDB Account. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Specifies the name of the CosmosDB Account. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class AccountCapacity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "totalThroughputLimit":
            suggest = "total_throughput_limit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccountCapacity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccountCapacity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccountCapacity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 total_throughput_limit: builtins.int):
        """
        :param builtins.int total_throughput_limit: The total throughput limit imposed on this Cosmos DB account (RU/s). Possible values are at least `-1`. `-1` means no limit.
        """
        pulumi.set(__self__, "total_throughput_limit", total_throughput_limit)

    @property
    @pulumi.getter(name="totalThroughputLimit")
    def total_throughput_limit(self) -> builtins.int:
        """
        The total throughput limit imposed on this Cosmos DB account (RU/s). Possible values are at least `-1`. `-1` means no limit.
        """
        return pulumi.get(self, "total_throughput_limit")


@pulumi.output_type
class AccountConsistencyPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "consistencyLevel":
            suggest = "consistency_level"
        elif key == "maxIntervalInSeconds":
            suggest = "max_interval_in_seconds"
        elif key == "maxStalenessPrefix":
            suggest = "max_staleness_prefix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccountConsistencyPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccountConsistencyPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccountConsistencyPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 consistency_level: builtins.str,
                 max_interval_in_seconds: Optional[builtins.int] = None,
                 max_staleness_prefix: Optional[builtins.int] = None):
        """
        :param builtins.str consistency_level: The Consistency Level to use for this CosmosDB Account - can be either `BoundedStaleness`, `Eventual`, `Session`, `Strong` or `ConsistentPrefix`.
        :param builtins.int max_interval_in_seconds: When used with the Bounded Staleness consistency level, this value represents the time amount of staleness (in seconds) tolerated. The accepted range for this value is `5` - `86400` (1 day). Defaults to `5`. Required when `consistency_level` is set to `BoundedStaleness`.
        :param builtins.int max_staleness_prefix: When used with the Bounded Staleness consistency level, this value represents the number of stale requests tolerated. The accepted range for this value is `10` – `2147483647`. Defaults to `100`. Required when `consistency_level` is set to `BoundedStaleness`.
               
               > **Note:** `max_interval_in_seconds` and `max_staleness_prefix` can only be set to values other than default when the `consistency_level` is set to `BoundedStaleness`.
        """
        pulumi.set(__self__, "consistency_level", consistency_level)
        if max_interval_in_seconds is not None:
            pulumi.set(__self__, "max_interval_in_seconds", max_interval_in_seconds)
        if max_staleness_prefix is not None:
            pulumi.set(__self__, "max_staleness_prefix", max_staleness_prefix)

    @property
    @pulumi.getter(name="consistencyLevel")
    def consistency_level(self) -> builtins.str:
        """
        The Consistency Level to use for this CosmosDB Account - can be either `BoundedStaleness`, `Eventual`, `Session`, `Strong` or `ConsistentPrefix`.
        """
        return pulumi.get(self, "consistency_level")

    @property
    @pulumi.getter(name="maxIntervalInSeconds")
    def max_interval_in_seconds(self) -> Optional[builtins.int]:
        """
        When used with the Bounded Staleness consistency level, this value represents the time amount of staleness (in seconds) tolerated. The accepted range for this value is `5` - `86400` (1 day). Defaults to `5`. Required when `consistency_level` is set to `BoundedStaleness`.
        """
        return pulumi.get(self, "max_interval_in_seconds")

    @property
    @pulumi.getter(name="maxStalenessPrefix")
    def max_staleness_prefix(self) -> Optional[builtins.int]:
        """
        When used with the Bounded Staleness consistency level, this value represents the number of stale requests tolerated. The accepted range for this value is `10` – `2147483647`. Defaults to `100`. Required when `consistency_level` is set to `BoundedStaleness`.

        > **Note:** `max_interval_in_seconds` and `max_staleness_prefix` can only be set to values other than default when the `consistency_level` is set to `BoundedStaleness`.
        """
        return pulumi.get(self, "max_staleness_prefix")


@pulumi.output_type
class AccountCorsRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedHeaders":
            suggest = "allowed_headers"
        elif key == "allowedMethods":
            suggest = "allowed_methods"
        elif key == "allowedOrigins":
            suggest = "allowed_origins"
        elif key == "exposedHeaders":
            suggest = "exposed_headers"
        elif key == "maxAgeInSeconds":
            suggest = "max_age_in_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccountCorsRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccountCorsRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccountCorsRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_headers: Sequence[builtins.str],
                 allowed_methods: Sequence[builtins.str],
                 allowed_origins: Sequence[builtins.str],
                 exposed_headers: Sequence[builtins.str],
                 max_age_in_seconds: Optional[builtins.int] = None):
        """
        :param Sequence[builtins.str] allowed_headers: A list of headers that are allowed to be a part of the cross-origin request.
        :param Sequence[builtins.str] allowed_methods: A list of HTTP headers that are allowed to be executed by the origin. Valid options are `DELETE`, `GET`, `HEAD`, `MERGE`, `POST`, `OPTIONS`, `PUT` or `PATCH`.
        :param Sequence[builtins.str] allowed_origins: A list of origin domains that will be allowed by CORS.
        :param Sequence[builtins.str] exposed_headers: A list of response headers that are exposed to CORS clients.
        :param builtins.int max_age_in_seconds: The number of seconds the client should cache a preflight response. Possible values are between `1` and `2147483647`.
        """
        pulumi.set(__self__, "allowed_headers", allowed_headers)
        pulumi.set(__self__, "allowed_methods", allowed_methods)
        pulumi.set(__self__, "allowed_origins", allowed_origins)
        pulumi.set(__self__, "exposed_headers", exposed_headers)
        if max_age_in_seconds is not None:
            pulumi.set(__self__, "max_age_in_seconds", max_age_in_seconds)

    @property
    @pulumi.getter(name="allowedHeaders")
    def allowed_headers(self) -> Sequence[builtins.str]:
        """
        A list of headers that are allowed to be a part of the cross-origin request.
        """
        return pulumi.get(self, "allowed_headers")

    @property
    @pulumi.getter(name="allowedMethods")
    def allowed_methods(self) -> Sequence[builtins.str]:
        """
        A list of HTTP headers that are allowed to be executed by the origin. Valid options are `DELETE`, `GET`, `HEAD`, `MERGE`, `POST`, `OPTIONS`, `PUT` or `PATCH`.
        """
        return pulumi.get(self, "allowed_methods")

    @property
    @pulumi.getter(name="allowedOrigins")
    def allowed_origins(self) -> Sequence[builtins.str]:
        """
        A list of origin domains that will be allowed by CORS.
        """
        return pulumi.get(self, "allowed_origins")

    @property
    @pulumi.getter(name="exposedHeaders")
    def exposed_headers(self) -> Sequence[builtins.str]:
        """
        A list of response headers that are exposed to CORS clients.
        """
        return pulumi.get(self, "exposed_headers")

    @property
    @pulumi.getter(name="maxAgeInSeconds")
    def max_age_in_seconds(self) -> Optional[builtins.int]:
        """
        The number of seconds the client should cache a preflight response. Possible values are between `1` and `2147483647`.
        """
        return pulumi.get(self, "max_age_in_seconds")


@pulumi.output_type
class AccountGeoLocation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failoverPriority":
            suggest = "failover_priority"
        elif key == "zoneRedundant":
            suggest = "zone_redundant"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccountGeoLocation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccountGeoLocation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccountGeoLocation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 failover_priority: builtins.int,
                 location: builtins.str,
                 id: Optional[builtins.str] = None,
                 zone_redundant: Optional[builtins.bool] = None):
        """
        :param builtins.int failover_priority: The failover priority of the region. A failover priority of `0` indicates a write region. The maximum value for a failover priority = (total number of regions - 1). Failover priority values must be unique for each of the regions in which the database account exists. Changing this causes the location to be re-provisioned and cannot be changed for the location with failover priority `0`.
        :param builtins.str location: The name of the Azure region to host replicated data.
        :param builtins.str id: The CosmosDB Account ID.
        :param builtins.bool zone_redundant: Should zone redundancy be enabled for this region? Defaults to `false`.
        """
        pulumi.set(__self__, "failover_priority", failover_priority)
        pulumi.set(__self__, "location", location)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if zone_redundant is not None:
            pulumi.set(__self__, "zone_redundant", zone_redundant)

    @property
    @pulumi.getter(name="failoverPriority")
    def failover_priority(self) -> builtins.int:
        """
        The failover priority of the region. A failover priority of `0` indicates a write region. The maximum value for a failover priority = (total number of regions - 1). Failover priority values must be unique for each of the regions in which the database account exists. Changing this causes the location to be re-provisioned and cannot be changed for the location with failover priority `0`.
        """
        return pulumi.get(self, "failover_priority")

    @property
    @pulumi.getter
    def location(self) -> builtins.str:
        """
        The name of the Azure region to host replicated data.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The CosmosDB Account ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="zoneRedundant")
    def zone_redundant(self) -> Optional[builtins.bool]:
        """
        Should zone redundancy be enabled for this region? Defaults to `false`.
        """
        return pulumi.get(self, "zone_redundant")


@pulumi.output_type
class AccountIdentity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "identityIds":
            suggest = "identity_ids"
        elif key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccountIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccountIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccountIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: builtins.str,
                 identity_ids: Optional[Sequence[builtins.str]] = None,
                 principal_id: Optional[builtins.str] = None,
                 tenant_id: Optional[builtins.str] = None):
        """
        :param builtins.str type: The Type of Managed Identity assigned to this Cosmos account. Possible values are `SystemAssigned`, `UserAssigned` and `SystemAssigned, UserAssigned`.
        :param Sequence[builtins.str] identity_ids: Specifies a list of User Assigned Managed Identity IDs to be assigned to this Cosmos Account.
        :param builtins.str principal_id: The Principal ID associated with this Managed Service Identity.
        :param builtins.str tenant_id: The Tenant ID associated with this Managed Service Identity.
        """
        pulumi.set(__self__, "type", type)
        if identity_ids is not None:
            pulumi.set(__self__, "identity_ids", identity_ids)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The Type of Managed Identity assigned to this Cosmos account. Possible values are `SystemAssigned`, `UserAssigned` and `SystemAssigned, UserAssigned`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        Specifies a list of User Assigned Managed Identity IDs to be assigned to this Cosmos Account.
        """
        return pulumi.get(self, "identity_ids")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[builtins.str]:
        """
        The Principal ID associated with this Managed Service Identity.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[builtins.str]:
        """
        The Tenant ID associated with this Managed Service Identity.
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class AccountRestore(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "restoreTimestampInUtc":
            suggest = "restore_timestamp_in_utc"
        elif key == "sourceCosmosdbAccountId":
            suggest = "source_cosmosdb_account_id"
        elif key == "gremlinDatabases":
            suggest = "gremlin_databases"
        elif key == "tablesToRestores":
            suggest = "tables_to_restores"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccountRestore. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccountRestore.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccountRestore.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 restore_timestamp_in_utc: builtins.str,
                 source_cosmosdb_account_id: builtins.str,
                 databases: Optional[Sequence['outputs.AccountRestoreDatabase']] = None,
                 gremlin_databases: Optional[Sequence['outputs.AccountRestoreGremlinDatabase']] = None,
                 tables_to_restores: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.str restore_timestamp_in_utc: The creation time of the database or the collection (Datetime Format `RFC 3339`). Changing this forces a new resource to be created.
        :param builtins.str source_cosmosdb_account_id: The resource ID of the restorable database account from which the restore has to be initiated. The example is `/subscriptions/{subscriptionId}/providers/Microsoft.DocumentDB/locations/{location}/restorableDatabaseAccounts/{restorableDatabaseAccountName}`. Changing this forces a new resource to be created.
               
               > **Note:** Any database account with `Continuous` type (live account or accounts deleted in last 30 days) is a restorable database account and there cannot be Create/Update/Delete operations on the restorable database accounts. They can only be read and retrieved by `cosmosdb_get_restorable_database_accounts`.
        :param Sequence['AccountRestoreDatabaseArgs'] databases: A `database` block as defined below. Changing this forces a new resource to be created.
        :param Sequence['AccountRestoreGremlinDatabaseArgs'] gremlin_databases: One or more `gremlin_database` blocks as defined below. Changing this forces a new resource to be created.
        :param Sequence[builtins.str] tables_to_restores: A list of specific tables available for restore. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "restore_timestamp_in_utc", restore_timestamp_in_utc)
        pulumi.set(__self__, "source_cosmosdb_account_id", source_cosmosdb_account_id)
        if databases is not None:
            pulumi.set(__self__, "databases", databases)
        if gremlin_databases is not None:
            pulumi.set(__self__, "gremlin_databases", gremlin_databases)
        if tables_to_restores is not None:
            pulumi.set(__self__, "tables_to_restores", tables_to_restores)

    @property
    @pulumi.getter(name="restoreTimestampInUtc")
    def restore_timestamp_in_utc(self) -> builtins.str:
        """
        The creation time of the database or the collection (Datetime Format `RFC 3339`). Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "restore_timestamp_in_utc")

    @property
    @pulumi.getter(name="sourceCosmosdbAccountId")
    def source_cosmosdb_account_id(self) -> builtins.str:
        """
        The resource ID of the restorable database account from which the restore has to be initiated. The example is `/subscriptions/{subscriptionId}/providers/Microsoft.DocumentDB/locations/{location}/restorableDatabaseAccounts/{restorableDatabaseAccountName}`. Changing this forces a new resource to be created.

        > **Note:** Any database account with `Continuous` type (live account or accounts deleted in last 30 days) is a restorable database account and there cannot be Create/Update/Delete operations on the restorable database accounts. They can only be read and retrieved by `cosmosdb_get_restorable_database_accounts`.
        """
        return pulumi.get(self, "source_cosmosdb_account_id")

    @property
    @pulumi.getter
    def databases(self) -> Optional[Sequence['outputs.AccountRestoreDatabase']]:
        """
        A `database` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "databases")

    @property
    @pulumi.getter(name="gremlinDatabases")
    def gremlin_databases(self) -> Optional[Sequence['outputs.AccountRestoreGremlinDatabase']]:
        """
        One or more `gremlin_database` blocks as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "gremlin_databases")

    @property
    @pulumi.getter(name="tablesToRestores")
    def tables_to_restores(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of specific tables available for restore. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "tables_to_restores")


@pulumi.output_type
class AccountRestoreDatabase(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "collectionNames":
            suggest = "collection_names"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccountRestoreDatabase. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccountRestoreDatabase.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccountRestoreDatabase.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 collection_names: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.str name: The database name for the restore request. Changing this forces a new resource to be created.
        :param Sequence[builtins.str] collection_names: A list of the collection names for the restore request. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "name", name)
        if collection_names is not None:
            pulumi.set(__self__, "collection_names", collection_names)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The database name for the restore request. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="collectionNames")
    def collection_names(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of the collection names for the restore request. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "collection_names")


@pulumi.output_type
class AccountRestoreGremlinDatabase(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "graphNames":
            suggest = "graph_names"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccountRestoreGremlinDatabase. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccountRestoreGremlinDatabase.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccountRestoreGremlinDatabase.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 graph_names: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.str name: The Gremlin Database name for the restore request. Changing this forces a new resource to be created.
        :param Sequence[builtins.str] graph_names: A list of the Graph names for the restore request. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "name", name)
        if graph_names is not None:
            pulumi.set(__self__, "graph_names", graph_names)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The Gremlin Database name for the restore request. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="graphNames")
    def graph_names(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of the Graph names for the restore request. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "graph_names")


@pulumi.output_type
class AccountVirtualNetworkRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ignoreMissingVnetServiceEndpoint":
            suggest = "ignore_missing_vnet_service_endpoint"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccountVirtualNetworkRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccountVirtualNetworkRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccountVirtualNetworkRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: builtins.str,
                 ignore_missing_vnet_service_endpoint: Optional[builtins.bool] = None):
        """
        :param builtins.str id: The ID of the virtual network subnet.
        :param builtins.bool ignore_missing_vnet_service_endpoint: If set to true, the specified subnet will be added as a virtual network rule even if its CosmosDB service endpoint is not active. Defaults to `false`.
        """
        pulumi.set(__self__, "id", id)
        if ignore_missing_vnet_service_endpoint is not None:
            pulumi.set(__self__, "ignore_missing_vnet_service_endpoint", ignore_missing_vnet_service_endpoint)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The ID of the virtual network subnet.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ignoreMissingVnetServiceEndpoint")
    def ignore_missing_vnet_service_endpoint(self) -> Optional[builtins.bool]:
        """
        If set to true, the specified subnet will be added as a virtual network rule even if its CosmosDB service endpoint is not active. Defaults to `false`.
        """
        return pulumi.get(self, "ignore_missing_vnet_service_endpoint")


@pulumi.output_type
class CassandraClusterIdentity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CassandraClusterIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CassandraClusterIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CassandraClusterIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: builtins.str,
                 principal_id: Optional[builtins.str] = None,
                 tenant_id: Optional[builtins.str] = None):
        """
        :param builtins.str type: Specifies the type of Managed Service Identity that should be configured on this Cassandra Cluster. The only possible value is `SystemAssigned`.
        """
        pulumi.set(__self__, "type", type)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Specifies the type of Managed Service Identity that should be configured on this Cassandra Cluster. The only possible value is `SystemAssigned`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class CassandraKeyspaceAutoscaleSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxThroughput":
            suggest = "max_throughput"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CassandraKeyspaceAutoscaleSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CassandraKeyspaceAutoscaleSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CassandraKeyspaceAutoscaleSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_throughput: Optional[builtins.int] = None):
        """
        :param builtins.int max_throughput: The maximum throughput of the Cassandra KeySpace (RU/s). Must be between `1,000` and `1,000,000`. Must be set in increments of `1,000`. Conflicts with `throughput`.
        """
        if max_throughput is not None:
            pulumi.set(__self__, "max_throughput", max_throughput)

    @property
    @pulumi.getter(name="maxThroughput")
    def max_throughput(self) -> Optional[builtins.int]:
        """
        The maximum throughput of the Cassandra KeySpace (RU/s). Must be between `1,000` and `1,000,000`. Must be set in increments of `1,000`. Conflicts with `throughput`.
        """
        return pulumi.get(self, "max_throughput")


@pulumi.output_type
class CassandraTableAutoscaleSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxThroughput":
            suggest = "max_throughput"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CassandraTableAutoscaleSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CassandraTableAutoscaleSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CassandraTableAutoscaleSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_throughput: Optional[builtins.int] = None):
        """
        :param builtins.int max_throughput: The maximum throughput of the Cassandra Table (RU/s). Must be between `1,000` and `1,000,000`. Must be set in increments of `1,000`. Conflicts with `throughput`.
        """
        if max_throughput is not None:
            pulumi.set(__self__, "max_throughput", max_throughput)

    @property
    @pulumi.getter(name="maxThroughput")
    def max_throughput(self) -> Optional[builtins.int]:
        """
        The maximum throughput of the Cassandra Table (RU/s). Must be between `1,000` and `1,000,000`. Must be set in increments of `1,000`. Conflicts with `throughput`.
        """
        return pulumi.get(self, "max_throughput")


@pulumi.output_type
class CassandraTableSchema(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "partitionKeys":
            suggest = "partition_keys"
        elif key == "clusterKeys":
            suggest = "cluster_keys"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CassandraTableSchema. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CassandraTableSchema.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CassandraTableSchema.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 columns: Sequence['outputs.CassandraTableSchemaColumn'],
                 partition_keys: Sequence['outputs.CassandraTableSchemaPartitionKey'],
                 cluster_keys: Optional[Sequence['outputs.CassandraTableSchemaClusterKey']] = None):
        """
        :param Sequence['CassandraTableSchemaColumnArgs'] columns: One or more `column` blocks as defined below.
        :param Sequence['CassandraTableSchemaPartitionKeyArgs'] partition_keys: One or more `partition_key` blocks as defined below.
        :param Sequence['CassandraTableSchemaClusterKeyArgs'] cluster_keys: One or more `cluster_key` blocks as defined below.
        """
        pulumi.set(__self__, "columns", columns)
        pulumi.set(__self__, "partition_keys", partition_keys)
        if cluster_keys is not None:
            pulumi.set(__self__, "cluster_keys", cluster_keys)

    @property
    @pulumi.getter
    def columns(self) -> Sequence['outputs.CassandraTableSchemaColumn']:
        """
        One or more `column` blocks as defined below.
        """
        return pulumi.get(self, "columns")

    @property
    @pulumi.getter(name="partitionKeys")
    def partition_keys(self) -> Sequence['outputs.CassandraTableSchemaPartitionKey']:
        """
        One or more `partition_key` blocks as defined below.
        """
        return pulumi.get(self, "partition_keys")

    @property
    @pulumi.getter(name="clusterKeys")
    def cluster_keys(self) -> Optional[Sequence['outputs.CassandraTableSchemaClusterKey']]:
        """
        One or more `cluster_key` blocks as defined below.
        """
        return pulumi.get(self, "cluster_keys")


@pulumi.output_type
class CassandraTableSchemaClusterKey(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "orderBy":
            suggest = "order_by"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CassandraTableSchemaClusterKey. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CassandraTableSchemaClusterKey.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CassandraTableSchemaClusterKey.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 order_by: builtins.str):
        """
        :param builtins.str name: Name of the cluster key to be created.
        :param builtins.str order_by: Order of the key. Currently supported values are `Asc` and `Desc`.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "order_by", order_by)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the cluster key to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="orderBy")
    def order_by(self) -> builtins.str:
        """
        Order of the key. Currently supported values are `Asc` and `Desc`.
        """
        return pulumi.get(self, "order_by")


@pulumi.output_type
class CassandraTableSchemaColumn(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 type: builtins.str):
        """
        :param builtins.str name: Name of the column to be created.
        :param builtins.str type: Type of the column to be created.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the column to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Type of the column to be created.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class CassandraTableSchemaPartitionKey(dict):
    def __init__(__self__, *,
                 name: builtins.str):
        """
        :param builtins.str name: Name of the column to partition by.
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the column to partition by.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GremlinDatabaseAutoscaleSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxThroughput":
            suggest = "max_throughput"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GremlinDatabaseAutoscaleSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GremlinDatabaseAutoscaleSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GremlinDatabaseAutoscaleSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_throughput: Optional[builtins.int] = None):
        """
        :param builtins.int max_throughput: The maximum throughput of the Gremlin database (RU/s). Must be between `1,000` and `1,000,000`. Must be set in increments of `1,000`. Conflicts with `throughput`.
        """
        if max_throughput is not None:
            pulumi.set(__self__, "max_throughput", max_throughput)

    @property
    @pulumi.getter(name="maxThroughput")
    def max_throughput(self) -> Optional[builtins.int]:
        """
        The maximum throughput of the Gremlin database (RU/s). Must be between `1,000` and `1,000,000`. Must be set in increments of `1,000`. Conflicts with `throughput`.
        """
        return pulumi.get(self, "max_throughput")


@pulumi.output_type
class GremlinGraphAutoscaleSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxThroughput":
            suggest = "max_throughput"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GremlinGraphAutoscaleSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GremlinGraphAutoscaleSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GremlinGraphAutoscaleSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_throughput: Optional[builtins.int] = None):
        """
        :param builtins.int max_throughput: The maximum throughput of the Gremlin graph (RU/s). Must be between `1,000` and `1,000,000`. Must be set in increments of `1,000`. Conflicts with `throughput`.
        """
        if max_throughput is not None:
            pulumi.set(__self__, "max_throughput", max_throughput)

    @property
    @pulumi.getter(name="maxThroughput")
    def max_throughput(self) -> Optional[builtins.int]:
        """
        The maximum throughput of the Gremlin graph (RU/s). Must be between `1,000` and `1,000,000`. Must be set in increments of `1,000`. Conflicts with `throughput`.
        """
        return pulumi.get(self, "max_throughput")


@pulumi.output_type
class GremlinGraphConflictResolutionPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "conflictResolutionPath":
            suggest = "conflict_resolution_path"
        elif key == "conflictResolutionProcedure":
            suggest = "conflict_resolution_procedure"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GremlinGraphConflictResolutionPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GremlinGraphConflictResolutionPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GremlinGraphConflictResolutionPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mode: builtins.str,
                 conflict_resolution_path: Optional[builtins.str] = None,
                 conflict_resolution_procedure: Optional[builtins.str] = None):
        """
        :param builtins.str mode: Indicates the conflict resolution mode. Possible values include: `LastWriterWins`, `Custom`.
        :param builtins.str conflict_resolution_path: The conflict resolution path in the case of LastWriterWins mode.
        :param builtins.str conflict_resolution_procedure: The procedure to resolve conflicts in the case of custom mode.
        """
        pulumi.set(__self__, "mode", mode)
        if conflict_resolution_path is not None:
            pulumi.set(__self__, "conflict_resolution_path", conflict_resolution_path)
        if conflict_resolution_procedure is not None:
            pulumi.set(__self__, "conflict_resolution_procedure", conflict_resolution_procedure)

    @property
    @pulumi.getter
    def mode(self) -> builtins.str:
        """
        Indicates the conflict resolution mode. Possible values include: `LastWriterWins`, `Custom`.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter(name="conflictResolutionPath")
    def conflict_resolution_path(self) -> Optional[builtins.str]:
        """
        The conflict resolution path in the case of LastWriterWins mode.
        """
        return pulumi.get(self, "conflict_resolution_path")

    @property
    @pulumi.getter(name="conflictResolutionProcedure")
    def conflict_resolution_procedure(self) -> Optional[builtins.str]:
        """
        The procedure to resolve conflicts in the case of custom mode.
        """
        return pulumi.get(self, "conflict_resolution_procedure")


@pulumi.output_type
class GremlinGraphIndexPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "indexingMode":
            suggest = "indexing_mode"
        elif key == "compositeIndices":
            suggest = "composite_indices"
        elif key == "excludedPaths":
            suggest = "excluded_paths"
        elif key == "includedPaths":
            suggest = "included_paths"
        elif key == "spatialIndices":
            suggest = "spatial_indices"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GremlinGraphIndexPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GremlinGraphIndexPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GremlinGraphIndexPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 indexing_mode: builtins.str,
                 automatic: Optional[builtins.bool] = None,
                 composite_indices: Optional[Sequence['outputs.GremlinGraphIndexPolicyCompositeIndex']] = None,
                 excluded_paths: Optional[Sequence[builtins.str]] = None,
                 included_paths: Optional[Sequence[builtins.str]] = None,
                 spatial_indices: Optional[Sequence['outputs.GremlinGraphIndexPolicySpatialIndex']] = None):
        """
        :param builtins.str indexing_mode: Indicates the indexing mode. Possible values include: `Consistent`, `Lazy`, `None`.
        :param builtins.bool automatic: Indicates if the indexing policy is automatic. Defaults to `true`.
        :param Sequence['GremlinGraphIndexPolicyCompositeIndexArgs'] composite_indices: One or more `composite_index` blocks as defined below.
        :param Sequence[builtins.str] excluded_paths: List of paths to exclude from indexing. Required if `indexing_mode` is `Consistent` or `Lazy`.
        :param Sequence[builtins.str] included_paths: List of paths to include in the indexing. Required if `indexing_mode` is `Consistent` or `Lazy`.
        :param Sequence['GremlinGraphIndexPolicySpatialIndexArgs'] spatial_indices: One or more `spatial_index` blocks as defined below.
        """
        pulumi.set(__self__, "indexing_mode", indexing_mode)
        if automatic is not None:
            pulumi.set(__self__, "automatic", automatic)
        if composite_indices is not None:
            pulumi.set(__self__, "composite_indices", composite_indices)
        if excluded_paths is not None:
            pulumi.set(__self__, "excluded_paths", excluded_paths)
        if included_paths is not None:
            pulumi.set(__self__, "included_paths", included_paths)
        if spatial_indices is not None:
            pulumi.set(__self__, "spatial_indices", spatial_indices)

    @property
    @pulumi.getter(name="indexingMode")
    def indexing_mode(self) -> builtins.str:
        """
        Indicates the indexing mode. Possible values include: `Consistent`, `Lazy`, `None`.
        """
        return pulumi.get(self, "indexing_mode")

    @property
    @pulumi.getter
    def automatic(self) -> Optional[builtins.bool]:
        """
        Indicates if the indexing policy is automatic. Defaults to `true`.
        """
        return pulumi.get(self, "automatic")

    @property
    @pulumi.getter(name="compositeIndices")
    def composite_indices(self) -> Optional[Sequence['outputs.GremlinGraphIndexPolicyCompositeIndex']]:
        """
        One or more `composite_index` blocks as defined below.
        """
        return pulumi.get(self, "composite_indices")

    @property
    @pulumi.getter(name="excludedPaths")
    def excluded_paths(self) -> Optional[Sequence[builtins.str]]:
        """
        List of paths to exclude from indexing. Required if `indexing_mode` is `Consistent` or `Lazy`.
        """
        return pulumi.get(self, "excluded_paths")

    @property
    @pulumi.getter(name="includedPaths")
    def included_paths(self) -> Optional[Sequence[builtins.str]]:
        """
        List of paths to include in the indexing. Required if `indexing_mode` is `Consistent` or `Lazy`.
        """
        return pulumi.get(self, "included_paths")

    @property
    @pulumi.getter(name="spatialIndices")
    def spatial_indices(self) -> Optional[Sequence['outputs.GremlinGraphIndexPolicySpatialIndex']]:
        """
        One or more `spatial_index` blocks as defined below.
        """
        return pulumi.get(self, "spatial_indices")


@pulumi.output_type
class GremlinGraphIndexPolicyCompositeIndex(dict):
    def __init__(__self__, *,
                 indices: Sequence['outputs.GremlinGraphIndexPolicyCompositeIndexIndex']):
        """
        :param Sequence['GremlinGraphIndexPolicyCompositeIndexIndexArgs'] indices: One or more `index` blocks as defined below.
        """
        pulumi.set(__self__, "indices", indices)

    @property
    @pulumi.getter
    def indices(self) -> Sequence['outputs.GremlinGraphIndexPolicyCompositeIndexIndex']:
        """
        One or more `index` blocks as defined below.
        """
        return pulumi.get(self, "indices")


@pulumi.output_type
class GremlinGraphIndexPolicyCompositeIndexIndex(dict):
    def __init__(__self__, *,
                 order: builtins.str,
                 path: builtins.str):
        """
        :param builtins.str order: Order of the index. Possible values are `Ascending` or `Descending`.
        :param builtins.str path: Path for which the indexing behaviour applies to.
        """
        pulumi.set(__self__, "order", order)
        pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter
    def order(self) -> builtins.str:
        """
        Order of the index. Possible values are `Ascending` or `Descending`.
        """
        return pulumi.get(self, "order")

    @property
    @pulumi.getter
    def path(self) -> builtins.str:
        """
        Path for which the indexing behaviour applies to.
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class GremlinGraphIndexPolicySpatialIndex(dict):
    def __init__(__self__, *,
                 path: builtins.str,
                 types: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.str path: Path for which the indexing behaviour applies to. According to the service design, all spatial types including `LineString`, `MultiPolygon`, `Point`, and `Polygon` will be applied to the path.
        """
        pulumi.set(__self__, "path", path)
        if types is not None:
            pulumi.set(__self__, "types", types)

    @property
    @pulumi.getter
    def path(self) -> builtins.str:
        """
        Path for which the indexing behaviour applies to. According to the service design, all spatial types including `LineString`, `MultiPolygon`, `Point`, and `Polygon` will be applied to the path.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def types(self) -> Optional[Sequence[builtins.str]]:
        return pulumi.get(self, "types")


@pulumi.output_type
class GremlinGraphUniqueKey(dict):
    def __init__(__self__, *,
                 paths: Sequence[builtins.str]):
        """
        :param Sequence[builtins.str] paths: A list of paths to use for this unique key. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "paths", paths)

    @property
    @pulumi.getter
    def paths(self) -> Sequence[builtins.str]:
        """
        A list of paths to use for this unique key. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "paths")


@pulumi.output_type
class MongoClusterConnectionString(dict):
    def __init__(__self__, *,
                 description: Optional[builtins.str] = None,
                 name: Optional[builtins.str] = None,
                 value: Optional[builtins.str] = None):
        """
        :param builtins.str description: The description of the connection string.
        :param builtins.str name: The name which should be used for the MongoDB Cluster. Changing this forces a new resource to be created.
        :param builtins.str value: The value of the Mongo Cluster connection string. The `<user>:<password>` placeholder returned from API will be replaced by the real `administrator_username` and `administrator_password` if available in the state.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        The description of the connection string.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name which should be used for the MongoDB Cluster. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.str]:
        """
        The value of the Mongo Cluster connection string. The `<user>:<password>` placeholder returned from API will be replaced by the real `administrator_username` and `administrator_password` if available in the state.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class MongoCollectionAutoscaleSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxThroughput":
            suggest = "max_throughput"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MongoCollectionAutoscaleSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MongoCollectionAutoscaleSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MongoCollectionAutoscaleSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_throughput: Optional[builtins.int] = None):
        """
        :param builtins.int max_throughput: The maximum throughput of the MongoDB collection (RU/s). Must be between `1,000` and `1,000,000`. Must be set in increments of `1,000`. Conflicts with `throughput`.
        """
        if max_throughput is not None:
            pulumi.set(__self__, "max_throughput", max_throughput)

    @property
    @pulumi.getter(name="maxThroughput")
    def max_throughput(self) -> Optional[builtins.int]:
        """
        The maximum throughput of the MongoDB collection (RU/s). Must be between `1,000` and `1,000,000`. Must be set in increments of `1,000`. Conflicts with `throughput`.
        """
        return pulumi.get(self, "max_throughput")


@pulumi.output_type
class MongoCollectionIndex(dict):
    def __init__(__self__, *,
                 keys: Sequence[builtins.str],
                 unique: Optional[builtins.bool] = None):
        """
        :param Sequence[builtins.str] keys: Specifies the list of user settable keys for each Cosmos DB Mongo Collection.
        :param builtins.bool unique: Is the index unique or not? Defaults to `false`.
               
               > **Note:** An index with an "_id" key must be specified.
        """
        pulumi.set(__self__, "keys", keys)
        if unique is not None:
            pulumi.set(__self__, "unique", unique)

    @property
    @pulumi.getter
    def keys(self) -> Sequence[builtins.str]:
        """
        Specifies the list of user settable keys for each Cosmos DB Mongo Collection.
        """
        return pulumi.get(self, "keys")

    @property
    @pulumi.getter
    def unique(self) -> Optional[builtins.bool]:
        """
        Is the index unique or not? Defaults to `false`.

        > **Note:** An index with an "_id" key must be specified.
        """
        return pulumi.get(self, "unique")


@pulumi.output_type
class MongoCollectionSystemIndex(dict):
    def __init__(__self__, *,
                 keys: Optional[Sequence[builtins.str]] = None,
                 unique: Optional[builtins.bool] = None):
        """
        :param Sequence[builtins.str] keys: The list of system keys which are not settable for each Cosmos DB Mongo Collection.
        :param builtins.bool unique: Identifies whether the table contains no duplicate values.
        """
        if keys is not None:
            pulumi.set(__self__, "keys", keys)
        if unique is not None:
            pulumi.set(__self__, "unique", unique)

    @property
    @pulumi.getter
    def keys(self) -> Optional[Sequence[builtins.str]]:
        """
        The list of system keys which are not settable for each Cosmos DB Mongo Collection.
        """
        return pulumi.get(self, "keys")

    @property
    @pulumi.getter
    def unique(self) -> Optional[builtins.bool]:
        """
        Identifies whether the table contains no duplicate values.
        """
        return pulumi.get(self, "unique")


@pulumi.output_type
class MongoDatabaseAutoscaleSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxThroughput":
            suggest = "max_throughput"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MongoDatabaseAutoscaleSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MongoDatabaseAutoscaleSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MongoDatabaseAutoscaleSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_throughput: Optional[builtins.int] = None):
        """
        :param builtins.int max_throughput: The maximum throughput of the MongoDB database (RU/s). Must be between `1,000` and `1,000,000`. Must be set in increments of `1,000`. Conflicts with `throughput`.
        """
        if max_throughput is not None:
            pulumi.set(__self__, "max_throughput", max_throughput)

    @property
    @pulumi.getter(name="maxThroughput")
    def max_throughput(self) -> Optional[builtins.int]:
        """
        The maximum throughput of the MongoDB database (RU/s). Must be between `1,000` and `1,000,000`. Must be set in increments of `1,000`. Conflicts with `throughput`.
        """
        return pulumi.get(self, "max_throughput")


@pulumi.output_type
class MongoRoleDefinitionPrivilege(dict):
    def __init__(__self__, *,
                 actions: Sequence[builtins.str],
                 resource: 'outputs.MongoRoleDefinitionPrivilegeResource'):
        """
        :param Sequence[builtins.str] actions: A list of actions that are allowed.
        :param 'MongoRoleDefinitionPrivilegeResourceArgs' resource: A `resource` block as defined below.
        """
        pulumi.set(__self__, "actions", actions)
        pulumi.set(__self__, "resource", resource)

    @property
    @pulumi.getter
    def actions(self) -> Sequence[builtins.str]:
        """
        A list of actions that are allowed.
        """
        return pulumi.get(self, "actions")

    @property
    @pulumi.getter
    def resource(self) -> 'outputs.MongoRoleDefinitionPrivilegeResource':
        """
        A `resource` block as defined below.
        """
        return pulumi.get(self, "resource")


@pulumi.output_type
class MongoRoleDefinitionPrivilegeResource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "collectionName":
            suggest = "collection_name"
        elif key == "dbName":
            suggest = "db_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MongoRoleDefinitionPrivilegeResource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MongoRoleDefinitionPrivilegeResource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MongoRoleDefinitionPrivilegeResource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 collection_name: Optional[builtins.str] = None,
                 db_name: Optional[builtins.str] = None):
        """
        :param builtins.str collection_name: The name of the Mongo DB Collection that the Role Definition is applied.
        :param builtins.str db_name: The name of the Mongo DB that the Role Definition is applied.
        """
        if collection_name is not None:
            pulumi.set(__self__, "collection_name", collection_name)
        if db_name is not None:
            pulumi.set(__self__, "db_name", db_name)

    @property
    @pulumi.getter(name="collectionName")
    def collection_name(self) -> Optional[builtins.str]:
        """
        The name of the Mongo DB Collection that the Role Definition is applied.
        """
        return pulumi.get(self, "collection_name")

    @property
    @pulumi.getter(name="dbName")
    def db_name(self) -> Optional[builtins.str]:
        """
        The name of the Mongo DB that the Role Definition is applied.
        """
        return pulumi.get(self, "db_name")


@pulumi.output_type
class PostgresqlClusterMaintenanceWindow(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dayOfWeek":
            suggest = "day_of_week"
        elif key == "startHour":
            suggest = "start_hour"
        elif key == "startMinute":
            suggest = "start_minute"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PostgresqlClusterMaintenanceWindow. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PostgresqlClusterMaintenanceWindow.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PostgresqlClusterMaintenanceWindow.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 day_of_week: Optional[builtins.int] = None,
                 start_hour: Optional[builtins.int] = None,
                 start_minute: Optional[builtins.int] = None):
        """
        :param builtins.int day_of_week: The day of week for maintenance window, where the week starts on a Sunday, i.e. Sunday = `0`, Monday = `1`. Defaults to `0`.
        :param builtins.int start_hour: The start hour for maintenance window. Defaults to `0`.
        :param builtins.int start_minute: The start minute for maintenance window. Defaults to `0`.
        """
        if day_of_week is not None:
            pulumi.set(__self__, "day_of_week", day_of_week)
        if start_hour is not None:
            pulumi.set(__self__, "start_hour", start_hour)
        if start_minute is not None:
            pulumi.set(__self__, "start_minute", start_minute)

    @property
    @pulumi.getter(name="dayOfWeek")
    def day_of_week(self) -> Optional[builtins.int]:
        """
        The day of week for maintenance window, where the week starts on a Sunday, i.e. Sunday = `0`, Monday = `1`. Defaults to `0`.
        """
        return pulumi.get(self, "day_of_week")

    @property
    @pulumi.getter(name="startHour")
    def start_hour(self) -> Optional[builtins.int]:
        """
        The start hour for maintenance window. Defaults to `0`.
        """
        return pulumi.get(self, "start_hour")

    @property
    @pulumi.getter(name="startMinute")
    def start_minute(self) -> Optional[builtins.int]:
        """
        The start minute for maintenance window. Defaults to `0`.
        """
        return pulumi.get(self, "start_minute")


@pulumi.output_type
class PostgresqlClusterServer(dict):
    def __init__(__self__, *,
                 fqdn: Optional[builtins.str] = None,
                 name: Optional[builtins.str] = None):
        """
        :param builtins.str fqdn: The Fully Qualified Domain Name of the server.
        :param builtins.str name: The name which should be used for this Azure Cosmos DB for PostgreSQL Cluster. Changing this forces a new resource to be created.
        """
        if fqdn is not None:
            pulumi.set(__self__, "fqdn", fqdn)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def fqdn(self) -> Optional[builtins.str]:
        """
        The Fully Qualified Domain Name of the server.
        """
        return pulumi.get(self, "fqdn")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name which should be used for this Azure Cosmos DB for PostgreSQL Cluster. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class SqlContainerAutoscaleSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxThroughput":
            suggest = "max_throughput"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SqlContainerAutoscaleSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SqlContainerAutoscaleSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SqlContainerAutoscaleSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_throughput: Optional[builtins.int] = None):
        """
        :param builtins.int max_throughput: The maximum throughput of the SQL container (RU/s). Must be between `1,000` and `1,000,000`. Must be set in increments of `1,000`. Conflicts with `throughput`.
        """
        if max_throughput is not None:
            pulumi.set(__self__, "max_throughput", max_throughput)

    @property
    @pulumi.getter(name="maxThroughput")
    def max_throughput(self) -> Optional[builtins.int]:
        """
        The maximum throughput of the SQL container (RU/s). Must be between `1,000` and `1,000,000`. Must be set in increments of `1,000`. Conflicts with `throughput`.
        """
        return pulumi.get(self, "max_throughput")


@pulumi.output_type
class SqlContainerConflictResolutionPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "conflictResolutionPath":
            suggest = "conflict_resolution_path"
        elif key == "conflictResolutionProcedure":
            suggest = "conflict_resolution_procedure"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SqlContainerConflictResolutionPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SqlContainerConflictResolutionPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SqlContainerConflictResolutionPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mode: builtins.str,
                 conflict_resolution_path: Optional[builtins.str] = None,
                 conflict_resolution_procedure: Optional[builtins.str] = None):
        """
        :param builtins.str mode: Indicates the conflict resolution mode. Possible values include: `LastWriterWins`, `Custom`.
        :param builtins.str conflict_resolution_path: The conflict resolution path in the case of `LastWriterWins` mode.
        :param builtins.str conflict_resolution_procedure: The procedure to resolve conflicts in the case of `Custom` mode.
        """
        pulumi.set(__self__, "mode", mode)
        if conflict_resolution_path is not None:
            pulumi.set(__self__, "conflict_resolution_path", conflict_resolution_path)
        if conflict_resolution_procedure is not None:
            pulumi.set(__self__, "conflict_resolution_procedure", conflict_resolution_procedure)

    @property
    @pulumi.getter
    def mode(self) -> builtins.str:
        """
        Indicates the conflict resolution mode. Possible values include: `LastWriterWins`, `Custom`.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter(name="conflictResolutionPath")
    def conflict_resolution_path(self) -> Optional[builtins.str]:
        """
        The conflict resolution path in the case of `LastWriterWins` mode.
        """
        return pulumi.get(self, "conflict_resolution_path")

    @property
    @pulumi.getter(name="conflictResolutionProcedure")
    def conflict_resolution_procedure(self) -> Optional[builtins.str]:
        """
        The procedure to resolve conflicts in the case of `Custom` mode.
        """
        return pulumi.get(self, "conflict_resolution_procedure")


@pulumi.output_type
class SqlContainerIndexingPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "compositeIndices":
            suggest = "composite_indices"
        elif key == "excludedPaths":
            suggest = "excluded_paths"
        elif key == "includedPaths":
            suggest = "included_paths"
        elif key == "indexingMode":
            suggest = "indexing_mode"
        elif key == "spatialIndices":
            suggest = "spatial_indices"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SqlContainerIndexingPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SqlContainerIndexingPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SqlContainerIndexingPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 composite_indices: Optional[Sequence['outputs.SqlContainerIndexingPolicyCompositeIndex']] = None,
                 excluded_paths: Optional[Sequence['outputs.SqlContainerIndexingPolicyExcludedPath']] = None,
                 included_paths: Optional[Sequence['outputs.SqlContainerIndexingPolicyIncludedPath']] = None,
                 indexing_mode: Optional[builtins.str] = None,
                 spatial_indices: Optional[Sequence['outputs.SqlContainerIndexingPolicySpatialIndex']] = None):
        """
        :param Sequence['SqlContainerIndexingPolicyCompositeIndexArgs'] composite_indices: One or more `composite_index` blocks as defined below.
        :param Sequence['SqlContainerIndexingPolicyExcludedPathArgs'] excluded_paths: One or more `excluded_path` blocks as defined below. Either `included_path` or `excluded_path` must contain the `path` `/*`
        :param Sequence['SqlContainerIndexingPolicyIncludedPathArgs'] included_paths: One or more `included_path` blocks as defined below. Either `included_path` or `excluded_path` must contain the `path` `/*`
        :param builtins.str indexing_mode: Indicates the indexing mode. Possible values include: `consistent` and `none`. Defaults to `consistent`.
        :param Sequence['SqlContainerIndexingPolicySpatialIndexArgs'] spatial_indices: One or more `spatial_index` blocks as defined below.
        """
        if composite_indices is not None:
            pulumi.set(__self__, "composite_indices", composite_indices)
        if excluded_paths is not None:
            pulumi.set(__self__, "excluded_paths", excluded_paths)
        if included_paths is not None:
            pulumi.set(__self__, "included_paths", included_paths)
        if indexing_mode is not None:
            pulumi.set(__self__, "indexing_mode", indexing_mode)
        if spatial_indices is not None:
            pulumi.set(__self__, "spatial_indices", spatial_indices)

    @property
    @pulumi.getter(name="compositeIndices")
    def composite_indices(self) -> Optional[Sequence['outputs.SqlContainerIndexingPolicyCompositeIndex']]:
        """
        One or more `composite_index` blocks as defined below.
        """
        return pulumi.get(self, "composite_indices")

    @property
    @pulumi.getter(name="excludedPaths")
    def excluded_paths(self) -> Optional[Sequence['outputs.SqlContainerIndexingPolicyExcludedPath']]:
        """
        One or more `excluded_path` blocks as defined below. Either `included_path` or `excluded_path` must contain the `path` `/*`
        """
        return pulumi.get(self, "excluded_paths")

    @property
    @pulumi.getter(name="includedPaths")
    def included_paths(self) -> Optional[Sequence['outputs.SqlContainerIndexingPolicyIncludedPath']]:
        """
        One or more `included_path` blocks as defined below. Either `included_path` or `excluded_path` must contain the `path` `/*`
        """
        return pulumi.get(self, "included_paths")

    @property
    @pulumi.getter(name="indexingMode")
    def indexing_mode(self) -> Optional[builtins.str]:
        """
        Indicates the indexing mode. Possible values include: `consistent` and `none`. Defaults to `consistent`.
        """
        return pulumi.get(self, "indexing_mode")

    @property
    @pulumi.getter(name="spatialIndices")
    def spatial_indices(self) -> Optional[Sequence['outputs.SqlContainerIndexingPolicySpatialIndex']]:
        """
        One or more `spatial_index` blocks as defined below.
        """
        return pulumi.get(self, "spatial_indices")


@pulumi.output_type
class SqlContainerIndexingPolicyCompositeIndex(dict):
    def __init__(__self__, *,
                 indices: Sequence['outputs.SqlContainerIndexingPolicyCompositeIndexIndex']):
        """
        :param Sequence['SqlContainerIndexingPolicyCompositeIndexIndexArgs'] indices: One or more `index` blocks as defined below.
        """
        pulumi.set(__self__, "indices", indices)

    @property
    @pulumi.getter
    def indices(self) -> Sequence['outputs.SqlContainerIndexingPolicyCompositeIndexIndex']:
        """
        One or more `index` blocks as defined below.
        """
        return pulumi.get(self, "indices")


@pulumi.output_type
class SqlContainerIndexingPolicyCompositeIndexIndex(dict):
    def __init__(__self__, *,
                 order: builtins.str,
                 path: builtins.str):
        """
        :param builtins.str order: Order of the index. Possible values are `Ascending` or `Descending`.
        :param builtins.str path: Path for which the indexing behaviour applies to.
        """
        pulumi.set(__self__, "order", order)
        pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter
    def order(self) -> builtins.str:
        """
        Order of the index. Possible values are `Ascending` or `Descending`.
        """
        return pulumi.get(self, "order")

    @property
    @pulumi.getter
    def path(self) -> builtins.str:
        """
        Path for which the indexing behaviour applies to.
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class SqlContainerIndexingPolicyExcludedPath(dict):
    def __init__(__self__, *,
                 path: builtins.str):
        """
        :param builtins.str path: Path that is excluded from indexing.
        """
        pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter
    def path(self) -> builtins.str:
        """
        Path that is excluded from indexing.
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class SqlContainerIndexingPolicyIncludedPath(dict):
    def __init__(__self__, *,
                 path: builtins.str):
        """
        :param builtins.str path: Path for which the indexing behaviour applies to.
        """
        pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter
    def path(self) -> builtins.str:
        """
        Path for which the indexing behaviour applies to.
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class SqlContainerIndexingPolicySpatialIndex(dict):
    def __init__(__self__, *,
                 path: builtins.str,
                 types: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.str path: Path for which the indexing behaviour applies to. According to the service design, all spatial types including `LineString`, `MultiPolygon`, `Point`, and `Polygon` will be applied to the path.
        :param Sequence[builtins.str] types: A set of spatial types of the path.
        """
        pulumi.set(__self__, "path", path)
        if types is not None:
            pulumi.set(__self__, "types", types)

    @property
    @pulumi.getter
    def path(self) -> builtins.str:
        """
        Path for which the indexing behaviour applies to. According to the service design, all spatial types including `LineString`, `MultiPolygon`, `Point`, and `Polygon` will be applied to the path.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def types(self) -> Optional[Sequence[builtins.str]]:
        """
        A set of spatial types of the path.
        """
        return pulumi.get(self, "types")


@pulumi.output_type
class SqlContainerUniqueKey(dict):
    def __init__(__self__, *,
                 paths: Sequence[builtins.str]):
        """
        :param Sequence[builtins.str] paths: A list of paths to use for this unique key. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "paths", paths)

    @property
    @pulumi.getter
    def paths(self) -> Sequence[builtins.str]:
        """
        A list of paths to use for this unique key. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "paths")


@pulumi.output_type
class SqlDatabaseAutoscaleSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxThroughput":
            suggest = "max_throughput"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SqlDatabaseAutoscaleSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SqlDatabaseAutoscaleSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SqlDatabaseAutoscaleSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_throughput: Optional[builtins.int] = None):
        """
        :param builtins.int max_throughput: The maximum throughput of the SQL database (RU/s). Must be between `1,000` and `1,000,000`. Must be set in increments of `1,000`. Conflicts with `throughput`.
        """
        if max_throughput is not None:
            pulumi.set(__self__, "max_throughput", max_throughput)

    @property
    @pulumi.getter(name="maxThroughput")
    def max_throughput(self) -> Optional[builtins.int]:
        """
        The maximum throughput of the SQL database (RU/s). Must be between `1,000` and `1,000,000`. Must be set in increments of `1,000`. Conflicts with `throughput`.
        """
        return pulumi.get(self, "max_throughput")


@pulumi.output_type
class SqlRoleDefinitionPermission(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataActions":
            suggest = "data_actions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SqlRoleDefinitionPermission. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SqlRoleDefinitionPermission.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SqlRoleDefinitionPermission.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_actions: Sequence[builtins.str]):
        """
        :param Sequence[builtins.str] data_actions: A list of data actions that are allowed for the Cosmos DB SQL Role Definition.
        """
        pulumi.set(__self__, "data_actions", data_actions)

    @property
    @pulumi.getter(name="dataActions")
    def data_actions(self) -> Sequence[builtins.str]:
        """
        A list of data actions that are allowed for the Cosmos DB SQL Role Definition.
        """
        return pulumi.get(self, "data_actions")


@pulumi.output_type
class TableAutoscaleSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxThroughput":
            suggest = "max_throughput"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TableAutoscaleSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TableAutoscaleSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TableAutoscaleSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_throughput: Optional[builtins.int] = None):
        """
        :param builtins.int max_throughput: The maximum throughput of the Table (RU/s). Must be between `1,000` and `1,000,000`. Must be set in increments of `1,000`. Conflicts with `throughput`.
        """
        if max_throughput is not None:
            pulumi.set(__self__, "max_throughput", max_throughput)

    @property
    @pulumi.getter(name="maxThroughput")
    def max_throughput(self) -> Optional[builtins.int]:
        """
        The maximum throughput of the Table (RU/s). Must be between `1,000` and `1,000,000`. Must be set in increments of `1,000`. Conflicts with `throughput`.
        """
        return pulumi.get(self, "max_throughput")


@pulumi.output_type
class GetAccountCapabilityResult(dict):
    def __init__(__self__, *,
                 name: builtins.str):
        """
        :param builtins.str name: Specifies the name of the CosmosDB Account.
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Specifies the name of the CosmosDB Account.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetAccountConsistencyPolicyResult(dict):
    def __init__(__self__, *,
                 consistency_level: builtins.str,
                 max_interval_in_seconds: builtins.int,
                 max_staleness_prefix: builtins.int):
        """
        :param builtins.str consistency_level: The Consistency Level used by this CosmosDB Account.
        :param builtins.int max_interval_in_seconds: The amount of staleness (in seconds) tolerated when the consistency level is Bounded Staleness.
        :param builtins.int max_staleness_prefix: The number of stale requests tolerated when the consistency level is Bounded Staleness.
        """
        pulumi.set(__self__, "consistency_level", consistency_level)
        pulumi.set(__self__, "max_interval_in_seconds", max_interval_in_seconds)
        pulumi.set(__self__, "max_staleness_prefix", max_staleness_prefix)

    @property
    @pulumi.getter(name="consistencyLevel")
    def consistency_level(self) -> builtins.str:
        """
        The Consistency Level used by this CosmosDB Account.
        """
        return pulumi.get(self, "consistency_level")

    @property
    @pulumi.getter(name="maxIntervalInSeconds")
    def max_interval_in_seconds(self) -> builtins.int:
        """
        The amount of staleness (in seconds) tolerated when the consistency level is Bounded Staleness.
        """
        return pulumi.get(self, "max_interval_in_seconds")

    @property
    @pulumi.getter(name="maxStalenessPrefix")
    def max_staleness_prefix(self) -> builtins.int:
        """
        The number of stale requests tolerated when the consistency level is Bounded Staleness.
        """
        return pulumi.get(self, "max_staleness_prefix")


@pulumi.output_type
class GetAccountGeoLocationResult(dict):
    def __init__(__self__, *,
                 failover_priority: builtins.int,
                 id: builtins.str,
                 location: builtins.str):
        """
        :param builtins.str id: The ID of the virtual network subnet.
        :param builtins.str location: The name of the Azure region hosting replicated data.
        """
        pulumi.set(__self__, "failover_priority", failover_priority)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "location", location)

    @property
    @pulumi.getter(name="failoverPriority")
    def failover_priority(self) -> builtins.int:
        return pulumi.get(self, "failover_priority")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The ID of the virtual network subnet.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def location(self) -> builtins.str:
        """
        The name of the Azure region hosting replicated data.
        """
        return pulumi.get(self, "location")


@pulumi.output_type
class GetAccountVirtualNetworkRuleResult(dict):
    def __init__(__self__, *,
                 id: builtins.str):
        """
        :param builtins.str id: The ID of the virtual network subnet.
        """
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The ID of the virtual network subnet.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class GetRestorableDatabaseAccountsAccountResult(dict):
    def __init__(__self__, *,
                 api_type: builtins.str,
                 creation_time: builtins.str,
                 deletion_time: builtins.str,
                 id: builtins.str,
                 restorable_locations: Sequence['outputs.GetRestorableDatabaseAccountsAccountRestorableLocationResult']):
        """
        :param builtins.str api_type: The API type of the Cosmos DB Restorable Database Account.
        :param builtins.str creation_time: The creation time of the regional Cosmos DB Restorable Database Account.
        :param builtins.str deletion_time: The deletion time of the regional Cosmos DB Restorable Database Account.
        :param builtins.str id: The ID of the Cosmos DB Restorable Database Account.
        :param Sequence['GetRestorableDatabaseAccountsAccountRestorableLocationArgs'] restorable_locations: One or more `restorable_locations` blocks as defined below.
        """
        pulumi.set(__self__, "api_type", api_type)
        pulumi.set(__self__, "creation_time", creation_time)
        pulumi.set(__self__, "deletion_time", deletion_time)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "restorable_locations", restorable_locations)

    @property
    @pulumi.getter(name="apiType")
    def api_type(self) -> builtins.str:
        """
        The API type of the Cosmos DB Restorable Database Account.
        """
        return pulumi.get(self, "api_type")

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> builtins.str:
        """
        The creation time of the regional Cosmos DB Restorable Database Account.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter(name="deletionTime")
    def deletion_time(self) -> builtins.str:
        """
        The deletion time of the regional Cosmos DB Restorable Database Account.
        """
        return pulumi.get(self, "deletion_time")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The ID of the Cosmos DB Restorable Database Account.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="restorableLocations")
    def restorable_locations(self) -> Sequence['outputs.GetRestorableDatabaseAccountsAccountRestorableLocationResult']:
        """
        One or more `restorable_locations` blocks as defined below.
        """
        return pulumi.get(self, "restorable_locations")


@pulumi.output_type
class GetRestorableDatabaseAccountsAccountRestorableLocationResult(dict):
    def __init__(__self__, *,
                 creation_time: builtins.str,
                 deletion_time: builtins.str,
                 location: builtins.str,
                 regional_database_account_instance_id: builtins.str):
        """
        :param builtins.str creation_time: The creation time of the regional Cosmos DB Restorable Database Account.
        :param builtins.str deletion_time: The deletion time of the regional Cosmos DB Restorable Database Account.
        :param builtins.str location: The location where the Cosmos DB Database Account.
        :param builtins.str regional_database_account_instance_id: The instance ID of the regional Cosmos DB Restorable Database Account.
        """
        pulumi.set(__self__, "creation_time", creation_time)
        pulumi.set(__self__, "deletion_time", deletion_time)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "regional_database_account_instance_id", regional_database_account_instance_id)

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> builtins.str:
        """
        The creation time of the regional Cosmos DB Restorable Database Account.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter(name="deletionTime")
    def deletion_time(self) -> builtins.str:
        """
        The deletion time of the regional Cosmos DB Restorable Database Account.
        """
        return pulumi.get(self, "deletion_time")

    @property
    @pulumi.getter
    def location(self) -> builtins.str:
        """
        The location where the Cosmos DB Database Account.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="regionalDatabaseAccountInstanceId")
    def regional_database_account_instance_id(self) -> builtins.str:
        """
        The instance ID of the regional Cosmos DB Restorable Database Account.
        """
        return pulumi.get(self, "regional_database_account_instance_id")


@pulumi.output_type
class GetSqlDatabaseAutoscaleSettingResult(dict):
    def __init__(__self__, *,
                 max_throughput: builtins.int):
        """
        :param builtins.int max_throughput: The maximum throughput of the SQL database (RU/s).
        """
        pulumi.set(__self__, "max_throughput", max_throughput)

    @property
    @pulumi.getter(name="maxThroughput")
    def max_throughput(self) -> builtins.int:
        """
        The maximum throughput of the SQL database (RU/s).
        """
        return pulumi.get(self, "max_throughput")


@pulumi.output_type
class GetSqlRoleDefinitionPermissionResult(dict):
    def __init__(__self__, *,
                 data_actions: Sequence[builtins.str]):
        """
        :param Sequence[builtins.str] data_actions: A list of data actions that are allowed for the Cosmos DB SQL Role Definition.
        """
        pulumi.set(__self__, "data_actions", data_actions)

    @property
    @pulumi.getter(name="dataActions")
    def data_actions(self) -> Sequence[builtins.str]:
        """
        A list of data actions that are allowed for the Cosmos DB SQL Role Definition.
        """
        return pulumi.get(self, "data_actions")


