# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PostgresqlClusterArgs', 'PostgresqlCluster']

@pulumi.input_type
class PostgresqlClusterArgs:
    def __init__(__self__, *,
                 node_count: pulumi.Input[builtins.int],
                 resource_group_name: pulumi.Input[builtins.str],
                 administrator_login_password: Optional[pulumi.Input[builtins.str]] = None,
                 citus_version: Optional[pulumi.Input[builtins.str]] = None,
                 coordinator_public_ip_access_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 coordinator_server_edition: Optional[pulumi.Input[builtins.str]] = None,
                 coordinator_storage_quota_in_mb: Optional[pulumi.Input[builtins.int]] = None,
                 coordinator_vcore_count: Optional[pulumi.Input[builtins.int]] = None,
                 ha_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 maintenance_window: Optional[pulumi.Input['PostgresqlClusterMaintenanceWindowArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 node_public_ip_access_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 node_server_edition: Optional[pulumi.Input[builtins.str]] = None,
                 node_storage_quota_in_mb: Optional[pulumi.Input[builtins.int]] = None,
                 node_vcores: Optional[pulumi.Input[builtins.int]] = None,
                 point_in_time_in_utc: Optional[pulumi.Input[builtins.str]] = None,
                 preferred_primary_zone: Optional[pulumi.Input[builtins.str]] = None,
                 shards_on_coordinator_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 source_location: Optional[pulumi.Input[builtins.str]] = None,
                 source_resource_id: Optional[pulumi.Input[builtins.str]] = None,
                 sql_version: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a PostgresqlCluster resource.
        :param pulumi.Input[builtins.int] node_count: The worker node count of the Azure Cosmos DB for PostgreSQL Cluster. Possible value is between `0` and `20` except `1`.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group where the Azure Cosmos DB for PostgreSQL Cluster should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] administrator_login_password: The password of the administrator login. This is required when `source_resource_id` is not set.
        :param pulumi.Input[builtins.str] citus_version: The citus extension version on the Azure Cosmos DB for PostgreSQL Cluster. Possible values are `8.3`, `9.0`, `9.1`, `9.2`, `9.3`, `9.4`, `9.5`, `10.0`, `10.1`, `10.2`, `11.0`, `11.1`, `11.2`, `11.3` and `12.1`.
        :param pulumi.Input[builtins.bool] coordinator_public_ip_access_enabled: Is public access enabled on coordinator? Defaults to `true`.
        :param pulumi.Input[builtins.str] coordinator_server_edition: The edition of the coordinator server. Possible values are `BurstableGeneralPurpose`, `BurstableMemoryOptimized`, `GeneralPurpose` and `MemoryOptimized`. Defaults to `GeneralPurpose`.
        :param pulumi.Input[builtins.int] coordinator_storage_quota_in_mb: The coordinator storage allowed for the Azure Cosmos DB for PostgreSQL Cluster. Possible values are `32768`, `65536`, `131072`, `262144`, `524288`, `1048576`, `2097152`, `4194304`, `8388608`, `16777216`, and `33554432`.
               
               > **Note:** More information on [the types of compute resources available for CosmosDB can be found in the product documentation](https://learn.microsoft.com/azure/cosmos-db/postgresql/resources-compute)
        :param pulumi.Input[builtins.int] coordinator_vcore_count: The coordinator vCore count for the Azure Cosmos DB for PostgreSQL Cluster. Possible values are `1`, `2`, `4`, `8`, `16`, `32`, `64` and `96`.
        :param pulumi.Input[builtins.bool] ha_enabled: Is high availability enabled for the Azure Cosmos DB for PostgreSQL cluster? Defaults to `false`.
        :param pulumi.Input[builtins.str] location: The Azure Region where the Azure Cosmos DB for PostgreSQL Cluster should exist. Changing this forces a new resource to be created.
        :param pulumi.Input['PostgresqlClusterMaintenanceWindowArgs'] maintenance_window: A `maintenance_window` block as defined below.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Azure Cosmos DB for PostgreSQL Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] node_public_ip_access_enabled: Is public access enabled on worker nodes. Defaults to `false`.
        :param pulumi.Input[builtins.str] node_server_edition: The edition of the node server. Possible values are `BurstableGeneralPurpose`, `BurstableMemoryOptimized`, `GeneralPurpose` and `MemoryOptimized`. Defaults to `MemoryOptimized`.
        :param pulumi.Input[builtins.int] node_storage_quota_in_mb: The storage quota in MB on each worker node. Possible values are `32768`, `65536`, `131072`, `262144`, `524288`, `1048576`, `2097152`, `4194304`, `8388608` and `16777216`.
        :param pulumi.Input[builtins.int] node_vcores: The vCores count on each worker node. Possible values are `1`, `2`, `4`, `8`, `16`, `32`, `64`, `96` and `104`.
        :param pulumi.Input[builtins.str] point_in_time_in_utc: The date and time in UTC (ISO8601 format) for the Azure Cosmos DB for PostgreSQL cluster restore. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] preferred_primary_zone: The preferred primary availability zone for the Azure Cosmos DB for PostgreSQL cluster.
        :param pulumi.Input[builtins.bool] shards_on_coordinator_enabled: Is shards on coordinator enabled for the Azure Cosmos DB for PostgreSQL cluster.
        :param pulumi.Input[builtins.str] source_location: The Azure region of the source Azure Cosmos DB for PostgreSQL cluster for read replica clusters. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] source_resource_id: The resource ID of the source Azure Cosmos DB for PostgreSQL cluster for read replica clusters. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] sql_version: The major PostgreSQL version on the Azure Cosmos DB for PostgreSQL cluster. Possible values are `11`, `12`, `13`, `14`, `15` and `16`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the Azure Cosmos DB for PostgreSQL Cluster.
        """
        pulumi.set(__self__, "node_count", node_count)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if administrator_login_password is not None:
            pulumi.set(__self__, "administrator_login_password", administrator_login_password)
        if citus_version is not None:
            pulumi.set(__self__, "citus_version", citus_version)
        if coordinator_public_ip_access_enabled is not None:
            pulumi.set(__self__, "coordinator_public_ip_access_enabled", coordinator_public_ip_access_enabled)
        if coordinator_server_edition is not None:
            pulumi.set(__self__, "coordinator_server_edition", coordinator_server_edition)
        if coordinator_storage_quota_in_mb is not None:
            pulumi.set(__self__, "coordinator_storage_quota_in_mb", coordinator_storage_quota_in_mb)
        if coordinator_vcore_count is not None:
            pulumi.set(__self__, "coordinator_vcore_count", coordinator_vcore_count)
        if ha_enabled is not None:
            pulumi.set(__self__, "ha_enabled", ha_enabled)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if maintenance_window is not None:
            pulumi.set(__self__, "maintenance_window", maintenance_window)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_public_ip_access_enabled is not None:
            pulumi.set(__self__, "node_public_ip_access_enabled", node_public_ip_access_enabled)
        if node_server_edition is not None:
            pulumi.set(__self__, "node_server_edition", node_server_edition)
        if node_storage_quota_in_mb is not None:
            pulumi.set(__self__, "node_storage_quota_in_mb", node_storage_quota_in_mb)
        if node_vcores is not None:
            pulumi.set(__self__, "node_vcores", node_vcores)
        if point_in_time_in_utc is not None:
            pulumi.set(__self__, "point_in_time_in_utc", point_in_time_in_utc)
        if preferred_primary_zone is not None:
            pulumi.set(__self__, "preferred_primary_zone", preferred_primary_zone)
        if shards_on_coordinator_enabled is not None:
            pulumi.set(__self__, "shards_on_coordinator_enabled", shards_on_coordinator_enabled)
        if source_location is not None:
            pulumi.set(__self__, "source_location", source_location)
        if source_resource_id is not None:
            pulumi.set(__self__, "source_resource_id", source_resource_id)
        if sql_version is not None:
            pulumi.set(__self__, "sql_version", sql_version)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> pulumi.Input[builtins.int]:
        """
        The worker node count of the Azure Cosmos DB for PostgreSQL Cluster. Possible value is between `0` and `20` except `1`.
        """
        return pulumi.get(self, "node_count")

    @node_count.setter
    def node_count(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "node_count", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the Resource Group where the Azure Cosmos DB for PostgreSQL Cluster should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="administratorLoginPassword")
    def administrator_login_password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The password of the administrator login. This is required when `source_resource_id` is not set.
        """
        return pulumi.get(self, "administrator_login_password")

    @administrator_login_password.setter
    def administrator_login_password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "administrator_login_password", value)

    @property
    @pulumi.getter(name="citusVersion")
    def citus_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The citus extension version on the Azure Cosmos DB for PostgreSQL Cluster. Possible values are `8.3`, `9.0`, `9.1`, `9.2`, `9.3`, `9.4`, `9.5`, `10.0`, `10.1`, `10.2`, `11.0`, `11.1`, `11.2`, `11.3` and `12.1`.
        """
        return pulumi.get(self, "citus_version")

    @citus_version.setter
    def citus_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "citus_version", value)

    @property
    @pulumi.getter(name="coordinatorPublicIpAccessEnabled")
    def coordinator_public_ip_access_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Is public access enabled on coordinator? Defaults to `true`.
        """
        return pulumi.get(self, "coordinator_public_ip_access_enabled")

    @coordinator_public_ip_access_enabled.setter
    def coordinator_public_ip_access_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "coordinator_public_ip_access_enabled", value)

    @property
    @pulumi.getter(name="coordinatorServerEdition")
    def coordinator_server_edition(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The edition of the coordinator server. Possible values are `BurstableGeneralPurpose`, `BurstableMemoryOptimized`, `GeneralPurpose` and `MemoryOptimized`. Defaults to `GeneralPurpose`.
        """
        return pulumi.get(self, "coordinator_server_edition")

    @coordinator_server_edition.setter
    def coordinator_server_edition(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "coordinator_server_edition", value)

    @property
    @pulumi.getter(name="coordinatorStorageQuotaInMb")
    def coordinator_storage_quota_in_mb(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The coordinator storage allowed for the Azure Cosmos DB for PostgreSQL Cluster. Possible values are `32768`, `65536`, `131072`, `262144`, `524288`, `1048576`, `2097152`, `4194304`, `8388608`, `16777216`, and `33554432`.

        > **Note:** More information on [the types of compute resources available for CosmosDB can be found in the product documentation](https://learn.microsoft.com/azure/cosmos-db/postgresql/resources-compute)
        """
        return pulumi.get(self, "coordinator_storage_quota_in_mb")

    @coordinator_storage_quota_in_mb.setter
    def coordinator_storage_quota_in_mb(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "coordinator_storage_quota_in_mb", value)

    @property
    @pulumi.getter(name="coordinatorVcoreCount")
    def coordinator_vcore_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The coordinator vCore count for the Azure Cosmos DB for PostgreSQL Cluster. Possible values are `1`, `2`, `4`, `8`, `16`, `32`, `64` and `96`.
        """
        return pulumi.get(self, "coordinator_vcore_count")

    @coordinator_vcore_count.setter
    def coordinator_vcore_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "coordinator_vcore_count", value)

    @property
    @pulumi.getter(name="haEnabled")
    def ha_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Is high availability enabled for the Azure Cosmos DB for PostgreSQL cluster? Defaults to `false`.
        """
        return pulumi.get(self, "ha_enabled")

    @ha_enabled.setter
    def ha_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "ha_enabled", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Azure Region where the Azure Cosmos DB for PostgreSQL Cluster should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> Optional[pulumi.Input['PostgresqlClusterMaintenanceWindowArgs']]:
        """
        A `maintenance_window` block as defined below.
        """
        return pulumi.get(self, "maintenance_window")

    @maintenance_window.setter
    def maintenance_window(self, value: Optional[pulumi.Input['PostgresqlClusterMaintenanceWindowArgs']]):
        pulumi.set(self, "maintenance_window", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name which should be used for this Azure Cosmos DB for PostgreSQL Cluster. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nodePublicIpAccessEnabled")
    def node_public_ip_access_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Is public access enabled on worker nodes. Defaults to `false`.
        """
        return pulumi.get(self, "node_public_ip_access_enabled")

    @node_public_ip_access_enabled.setter
    def node_public_ip_access_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "node_public_ip_access_enabled", value)

    @property
    @pulumi.getter(name="nodeServerEdition")
    def node_server_edition(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The edition of the node server. Possible values are `BurstableGeneralPurpose`, `BurstableMemoryOptimized`, `GeneralPurpose` and `MemoryOptimized`. Defaults to `MemoryOptimized`.
        """
        return pulumi.get(self, "node_server_edition")

    @node_server_edition.setter
    def node_server_edition(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "node_server_edition", value)

    @property
    @pulumi.getter(name="nodeStorageQuotaInMb")
    def node_storage_quota_in_mb(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The storage quota in MB on each worker node. Possible values are `32768`, `65536`, `131072`, `262144`, `524288`, `1048576`, `2097152`, `4194304`, `8388608` and `16777216`.
        """
        return pulumi.get(self, "node_storage_quota_in_mb")

    @node_storage_quota_in_mb.setter
    def node_storage_quota_in_mb(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "node_storage_quota_in_mb", value)

    @property
    @pulumi.getter(name="nodeVcores")
    def node_vcores(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The vCores count on each worker node. Possible values are `1`, `2`, `4`, `8`, `16`, `32`, `64`, `96` and `104`.
        """
        return pulumi.get(self, "node_vcores")

    @node_vcores.setter
    def node_vcores(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "node_vcores", value)

    @property
    @pulumi.getter(name="pointInTimeInUtc")
    def point_in_time_in_utc(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time in UTC (ISO8601 format) for the Azure Cosmos DB for PostgreSQL cluster restore. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "point_in_time_in_utc")

    @point_in_time_in_utc.setter
    def point_in_time_in_utc(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "point_in_time_in_utc", value)

    @property
    @pulumi.getter(name="preferredPrimaryZone")
    def preferred_primary_zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The preferred primary availability zone for the Azure Cosmos DB for PostgreSQL cluster.
        """
        return pulumi.get(self, "preferred_primary_zone")

    @preferred_primary_zone.setter
    def preferred_primary_zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "preferred_primary_zone", value)

    @property
    @pulumi.getter(name="shardsOnCoordinatorEnabled")
    def shards_on_coordinator_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Is shards on coordinator enabled for the Azure Cosmos DB for PostgreSQL cluster.
        """
        return pulumi.get(self, "shards_on_coordinator_enabled")

    @shards_on_coordinator_enabled.setter
    def shards_on_coordinator_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "shards_on_coordinator_enabled", value)

    @property
    @pulumi.getter(name="sourceLocation")
    def source_location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Azure region of the source Azure Cosmos DB for PostgreSQL cluster for read replica clusters. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "source_location")

    @source_location.setter
    def source_location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_location", value)

    @property
    @pulumi.getter(name="sourceResourceId")
    def source_resource_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource ID of the source Azure Cosmos DB for PostgreSQL cluster for read replica clusters. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "source_resource_id")

    @source_resource_id.setter
    def source_resource_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_resource_id", value)

    @property
    @pulumi.getter(name="sqlVersion")
    def sql_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The major PostgreSQL version on the Azure Cosmos DB for PostgreSQL cluster. Possible values are `11`, `12`, `13`, `14`, `15` and `16`.
        """
        return pulumi.get(self, "sql_version")

    @sql_version.setter
    def sql_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sql_version", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Azure Cosmos DB for PostgreSQL Cluster.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _PostgresqlClusterState:
    def __init__(__self__, *,
                 administrator_login_password: Optional[pulumi.Input[builtins.str]] = None,
                 citus_version: Optional[pulumi.Input[builtins.str]] = None,
                 coordinator_public_ip_access_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 coordinator_server_edition: Optional[pulumi.Input[builtins.str]] = None,
                 coordinator_storage_quota_in_mb: Optional[pulumi.Input[builtins.int]] = None,
                 coordinator_vcore_count: Optional[pulumi.Input[builtins.int]] = None,
                 earliest_restore_time: Optional[pulumi.Input[builtins.str]] = None,
                 ha_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 maintenance_window: Optional[pulumi.Input['PostgresqlClusterMaintenanceWindowArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 node_count: Optional[pulumi.Input[builtins.int]] = None,
                 node_public_ip_access_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 node_server_edition: Optional[pulumi.Input[builtins.str]] = None,
                 node_storage_quota_in_mb: Optional[pulumi.Input[builtins.int]] = None,
                 node_vcores: Optional[pulumi.Input[builtins.int]] = None,
                 point_in_time_in_utc: Optional[pulumi.Input[builtins.str]] = None,
                 preferred_primary_zone: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 servers: Optional[pulumi.Input[Sequence[pulumi.Input['PostgresqlClusterServerArgs']]]] = None,
                 shards_on_coordinator_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 source_location: Optional[pulumi.Input[builtins.str]] = None,
                 source_resource_id: Optional[pulumi.Input[builtins.str]] = None,
                 sql_version: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering PostgresqlCluster resources.
        :param pulumi.Input[builtins.str] administrator_login_password: The password of the administrator login. This is required when `source_resource_id` is not set.
        :param pulumi.Input[builtins.str] citus_version: The citus extension version on the Azure Cosmos DB for PostgreSQL Cluster. Possible values are `8.3`, `9.0`, `9.1`, `9.2`, `9.3`, `9.4`, `9.5`, `10.0`, `10.1`, `10.2`, `11.0`, `11.1`, `11.2`, `11.3` and `12.1`.
        :param pulumi.Input[builtins.bool] coordinator_public_ip_access_enabled: Is public access enabled on coordinator? Defaults to `true`.
        :param pulumi.Input[builtins.str] coordinator_server_edition: The edition of the coordinator server. Possible values are `BurstableGeneralPurpose`, `BurstableMemoryOptimized`, `GeneralPurpose` and `MemoryOptimized`. Defaults to `GeneralPurpose`.
        :param pulumi.Input[builtins.int] coordinator_storage_quota_in_mb: The coordinator storage allowed for the Azure Cosmos DB for PostgreSQL Cluster. Possible values are `32768`, `65536`, `131072`, `262144`, `524288`, `1048576`, `2097152`, `4194304`, `8388608`, `16777216`, and `33554432`.
               
               > **Note:** More information on [the types of compute resources available for CosmosDB can be found in the product documentation](https://learn.microsoft.com/azure/cosmos-db/postgresql/resources-compute)
        :param pulumi.Input[builtins.int] coordinator_vcore_count: The coordinator vCore count for the Azure Cosmos DB for PostgreSQL Cluster. Possible values are `1`, `2`, `4`, `8`, `16`, `32`, `64` and `96`.
        :param pulumi.Input[builtins.str] earliest_restore_time: The earliest restore point time (ISO8601 format) for the Azure Cosmos DB for PostgreSQL Cluster.
        :param pulumi.Input[builtins.bool] ha_enabled: Is high availability enabled for the Azure Cosmos DB for PostgreSQL cluster? Defaults to `false`.
        :param pulumi.Input[builtins.str] location: The Azure Region where the Azure Cosmos DB for PostgreSQL Cluster should exist. Changing this forces a new resource to be created.
        :param pulumi.Input['PostgresqlClusterMaintenanceWindowArgs'] maintenance_window: A `maintenance_window` block as defined below.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Azure Cosmos DB for PostgreSQL Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.int] node_count: The worker node count of the Azure Cosmos DB for PostgreSQL Cluster. Possible value is between `0` and `20` except `1`.
        :param pulumi.Input[builtins.bool] node_public_ip_access_enabled: Is public access enabled on worker nodes. Defaults to `false`.
        :param pulumi.Input[builtins.str] node_server_edition: The edition of the node server. Possible values are `BurstableGeneralPurpose`, `BurstableMemoryOptimized`, `GeneralPurpose` and `MemoryOptimized`. Defaults to `MemoryOptimized`.
        :param pulumi.Input[builtins.int] node_storage_quota_in_mb: The storage quota in MB on each worker node. Possible values are `32768`, `65536`, `131072`, `262144`, `524288`, `1048576`, `2097152`, `4194304`, `8388608` and `16777216`.
        :param pulumi.Input[builtins.int] node_vcores: The vCores count on each worker node. Possible values are `1`, `2`, `4`, `8`, `16`, `32`, `64`, `96` and `104`.
        :param pulumi.Input[builtins.str] point_in_time_in_utc: The date and time in UTC (ISO8601 format) for the Azure Cosmos DB for PostgreSQL cluster restore. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] preferred_primary_zone: The preferred primary availability zone for the Azure Cosmos DB for PostgreSQL cluster.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group where the Azure Cosmos DB for PostgreSQL Cluster should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input['PostgresqlClusterServerArgs']]] servers: A `servers` block as defined below.
        :param pulumi.Input[builtins.bool] shards_on_coordinator_enabled: Is shards on coordinator enabled for the Azure Cosmos DB for PostgreSQL cluster.
        :param pulumi.Input[builtins.str] source_location: The Azure region of the source Azure Cosmos DB for PostgreSQL cluster for read replica clusters. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] source_resource_id: The resource ID of the source Azure Cosmos DB for PostgreSQL cluster for read replica clusters. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] sql_version: The major PostgreSQL version on the Azure Cosmos DB for PostgreSQL cluster. Possible values are `11`, `12`, `13`, `14`, `15` and `16`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the Azure Cosmos DB for PostgreSQL Cluster.
        """
        if administrator_login_password is not None:
            pulumi.set(__self__, "administrator_login_password", administrator_login_password)
        if citus_version is not None:
            pulumi.set(__self__, "citus_version", citus_version)
        if coordinator_public_ip_access_enabled is not None:
            pulumi.set(__self__, "coordinator_public_ip_access_enabled", coordinator_public_ip_access_enabled)
        if coordinator_server_edition is not None:
            pulumi.set(__self__, "coordinator_server_edition", coordinator_server_edition)
        if coordinator_storage_quota_in_mb is not None:
            pulumi.set(__self__, "coordinator_storage_quota_in_mb", coordinator_storage_quota_in_mb)
        if coordinator_vcore_count is not None:
            pulumi.set(__self__, "coordinator_vcore_count", coordinator_vcore_count)
        if earliest_restore_time is not None:
            pulumi.set(__self__, "earliest_restore_time", earliest_restore_time)
        if ha_enabled is not None:
            pulumi.set(__self__, "ha_enabled", ha_enabled)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if maintenance_window is not None:
            pulumi.set(__self__, "maintenance_window", maintenance_window)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_count is not None:
            pulumi.set(__self__, "node_count", node_count)
        if node_public_ip_access_enabled is not None:
            pulumi.set(__self__, "node_public_ip_access_enabled", node_public_ip_access_enabled)
        if node_server_edition is not None:
            pulumi.set(__self__, "node_server_edition", node_server_edition)
        if node_storage_quota_in_mb is not None:
            pulumi.set(__self__, "node_storage_quota_in_mb", node_storage_quota_in_mb)
        if node_vcores is not None:
            pulumi.set(__self__, "node_vcores", node_vcores)
        if point_in_time_in_utc is not None:
            pulumi.set(__self__, "point_in_time_in_utc", point_in_time_in_utc)
        if preferred_primary_zone is not None:
            pulumi.set(__self__, "preferred_primary_zone", preferred_primary_zone)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if servers is not None:
            pulumi.set(__self__, "servers", servers)
        if shards_on_coordinator_enabled is not None:
            pulumi.set(__self__, "shards_on_coordinator_enabled", shards_on_coordinator_enabled)
        if source_location is not None:
            pulumi.set(__self__, "source_location", source_location)
        if source_resource_id is not None:
            pulumi.set(__self__, "source_resource_id", source_resource_id)
        if sql_version is not None:
            pulumi.set(__self__, "sql_version", sql_version)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="administratorLoginPassword")
    def administrator_login_password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The password of the administrator login. This is required when `source_resource_id` is not set.
        """
        return pulumi.get(self, "administrator_login_password")

    @administrator_login_password.setter
    def administrator_login_password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "administrator_login_password", value)

    @property
    @pulumi.getter(name="citusVersion")
    def citus_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The citus extension version on the Azure Cosmos DB for PostgreSQL Cluster. Possible values are `8.3`, `9.0`, `9.1`, `9.2`, `9.3`, `9.4`, `9.5`, `10.0`, `10.1`, `10.2`, `11.0`, `11.1`, `11.2`, `11.3` and `12.1`.
        """
        return pulumi.get(self, "citus_version")

    @citus_version.setter
    def citus_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "citus_version", value)

    @property
    @pulumi.getter(name="coordinatorPublicIpAccessEnabled")
    def coordinator_public_ip_access_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Is public access enabled on coordinator? Defaults to `true`.
        """
        return pulumi.get(self, "coordinator_public_ip_access_enabled")

    @coordinator_public_ip_access_enabled.setter
    def coordinator_public_ip_access_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "coordinator_public_ip_access_enabled", value)

    @property
    @pulumi.getter(name="coordinatorServerEdition")
    def coordinator_server_edition(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The edition of the coordinator server. Possible values are `BurstableGeneralPurpose`, `BurstableMemoryOptimized`, `GeneralPurpose` and `MemoryOptimized`. Defaults to `GeneralPurpose`.
        """
        return pulumi.get(self, "coordinator_server_edition")

    @coordinator_server_edition.setter
    def coordinator_server_edition(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "coordinator_server_edition", value)

    @property
    @pulumi.getter(name="coordinatorStorageQuotaInMb")
    def coordinator_storage_quota_in_mb(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The coordinator storage allowed for the Azure Cosmos DB for PostgreSQL Cluster. Possible values are `32768`, `65536`, `131072`, `262144`, `524288`, `1048576`, `2097152`, `4194304`, `8388608`, `16777216`, and `33554432`.

        > **Note:** More information on [the types of compute resources available for CosmosDB can be found in the product documentation](https://learn.microsoft.com/azure/cosmos-db/postgresql/resources-compute)
        """
        return pulumi.get(self, "coordinator_storage_quota_in_mb")

    @coordinator_storage_quota_in_mb.setter
    def coordinator_storage_quota_in_mb(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "coordinator_storage_quota_in_mb", value)

    @property
    @pulumi.getter(name="coordinatorVcoreCount")
    def coordinator_vcore_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The coordinator vCore count for the Azure Cosmos DB for PostgreSQL Cluster. Possible values are `1`, `2`, `4`, `8`, `16`, `32`, `64` and `96`.
        """
        return pulumi.get(self, "coordinator_vcore_count")

    @coordinator_vcore_count.setter
    def coordinator_vcore_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "coordinator_vcore_count", value)

    @property
    @pulumi.getter(name="earliestRestoreTime")
    def earliest_restore_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The earliest restore point time (ISO8601 format) for the Azure Cosmos DB for PostgreSQL Cluster.
        """
        return pulumi.get(self, "earliest_restore_time")

    @earliest_restore_time.setter
    def earliest_restore_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "earliest_restore_time", value)

    @property
    @pulumi.getter(name="haEnabled")
    def ha_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Is high availability enabled for the Azure Cosmos DB for PostgreSQL cluster? Defaults to `false`.
        """
        return pulumi.get(self, "ha_enabled")

    @ha_enabled.setter
    def ha_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "ha_enabled", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Azure Region where the Azure Cosmos DB for PostgreSQL Cluster should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> Optional[pulumi.Input['PostgresqlClusterMaintenanceWindowArgs']]:
        """
        A `maintenance_window` block as defined below.
        """
        return pulumi.get(self, "maintenance_window")

    @maintenance_window.setter
    def maintenance_window(self, value: Optional[pulumi.Input['PostgresqlClusterMaintenanceWindowArgs']]):
        pulumi.set(self, "maintenance_window", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name which should be used for this Azure Cosmos DB for PostgreSQL Cluster. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The worker node count of the Azure Cosmos DB for PostgreSQL Cluster. Possible value is between `0` and `20` except `1`.
        """
        return pulumi.get(self, "node_count")

    @node_count.setter
    def node_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "node_count", value)

    @property
    @pulumi.getter(name="nodePublicIpAccessEnabled")
    def node_public_ip_access_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Is public access enabled on worker nodes. Defaults to `false`.
        """
        return pulumi.get(self, "node_public_ip_access_enabled")

    @node_public_ip_access_enabled.setter
    def node_public_ip_access_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "node_public_ip_access_enabled", value)

    @property
    @pulumi.getter(name="nodeServerEdition")
    def node_server_edition(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The edition of the node server. Possible values are `BurstableGeneralPurpose`, `BurstableMemoryOptimized`, `GeneralPurpose` and `MemoryOptimized`. Defaults to `MemoryOptimized`.
        """
        return pulumi.get(self, "node_server_edition")

    @node_server_edition.setter
    def node_server_edition(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "node_server_edition", value)

    @property
    @pulumi.getter(name="nodeStorageQuotaInMb")
    def node_storage_quota_in_mb(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The storage quota in MB on each worker node. Possible values are `32768`, `65536`, `131072`, `262144`, `524288`, `1048576`, `2097152`, `4194304`, `8388608` and `16777216`.
        """
        return pulumi.get(self, "node_storage_quota_in_mb")

    @node_storage_quota_in_mb.setter
    def node_storage_quota_in_mb(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "node_storage_quota_in_mb", value)

    @property
    @pulumi.getter(name="nodeVcores")
    def node_vcores(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The vCores count on each worker node. Possible values are `1`, `2`, `4`, `8`, `16`, `32`, `64`, `96` and `104`.
        """
        return pulumi.get(self, "node_vcores")

    @node_vcores.setter
    def node_vcores(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "node_vcores", value)

    @property
    @pulumi.getter(name="pointInTimeInUtc")
    def point_in_time_in_utc(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time in UTC (ISO8601 format) for the Azure Cosmos DB for PostgreSQL cluster restore. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "point_in_time_in_utc")

    @point_in_time_in_utc.setter
    def point_in_time_in_utc(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "point_in_time_in_utc", value)

    @property
    @pulumi.getter(name="preferredPrimaryZone")
    def preferred_primary_zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The preferred primary availability zone for the Azure Cosmos DB for PostgreSQL cluster.
        """
        return pulumi.get(self, "preferred_primary_zone")

    @preferred_primary_zone.setter
    def preferred_primary_zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "preferred_primary_zone", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Resource Group where the Azure Cosmos DB for PostgreSQL Cluster should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter
    def servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PostgresqlClusterServerArgs']]]]:
        """
        A `servers` block as defined below.
        """
        return pulumi.get(self, "servers")

    @servers.setter
    def servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PostgresqlClusterServerArgs']]]]):
        pulumi.set(self, "servers", value)

    @property
    @pulumi.getter(name="shardsOnCoordinatorEnabled")
    def shards_on_coordinator_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Is shards on coordinator enabled for the Azure Cosmos DB for PostgreSQL cluster.
        """
        return pulumi.get(self, "shards_on_coordinator_enabled")

    @shards_on_coordinator_enabled.setter
    def shards_on_coordinator_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "shards_on_coordinator_enabled", value)

    @property
    @pulumi.getter(name="sourceLocation")
    def source_location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Azure region of the source Azure Cosmos DB for PostgreSQL cluster for read replica clusters. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "source_location")

    @source_location.setter
    def source_location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_location", value)

    @property
    @pulumi.getter(name="sourceResourceId")
    def source_resource_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource ID of the source Azure Cosmos DB for PostgreSQL cluster for read replica clusters. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "source_resource_id")

    @source_resource_id.setter
    def source_resource_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_resource_id", value)

    @property
    @pulumi.getter(name="sqlVersion")
    def sql_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The major PostgreSQL version on the Azure Cosmos DB for PostgreSQL cluster. Possible values are `11`, `12`, `13`, `14`, `15` and `16`.
        """
        return pulumi.get(self, "sql_version")

    @sql_version.setter
    def sql_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sql_version", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Azure Cosmos DB for PostgreSQL Cluster.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("azure:cosmosdb/postgresqlCluster:PostgresqlCluster")
class PostgresqlCluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 administrator_login_password: Optional[pulumi.Input[builtins.str]] = None,
                 citus_version: Optional[pulumi.Input[builtins.str]] = None,
                 coordinator_public_ip_access_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 coordinator_server_edition: Optional[pulumi.Input[builtins.str]] = None,
                 coordinator_storage_quota_in_mb: Optional[pulumi.Input[builtins.int]] = None,
                 coordinator_vcore_count: Optional[pulumi.Input[builtins.int]] = None,
                 ha_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 maintenance_window: Optional[pulumi.Input[Union['PostgresqlClusterMaintenanceWindowArgs', 'PostgresqlClusterMaintenanceWindowArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 node_count: Optional[pulumi.Input[builtins.int]] = None,
                 node_public_ip_access_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 node_server_edition: Optional[pulumi.Input[builtins.str]] = None,
                 node_storage_quota_in_mb: Optional[pulumi.Input[builtins.int]] = None,
                 node_vcores: Optional[pulumi.Input[builtins.int]] = None,
                 point_in_time_in_utc: Optional[pulumi.Input[builtins.str]] = None,
                 preferred_primary_zone: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 shards_on_coordinator_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 source_location: Optional[pulumi.Input[builtins.str]] = None,
                 source_resource_id: Optional[pulumi.Input[builtins.str]] = None,
                 sql_version: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        Manages an Azure Cosmos DB for PostgreSQL Cluster.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_postgresql_cluster = azure.cosmosdb.PostgresqlCluster("example",
            name="example-cluster",
            resource_group_name=example.name,
            location=example.location,
            administrator_login_password="H@Sh1CoR3!",
            coordinator_storage_quota_in_mb=131072,
            coordinator_vcore_count=2,
            node_count=0)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.DBforPostgreSQL`: 2022-11-08

        ## Import

        Azure Cosmos DB for PostgreSQL Clusters can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:cosmosdb/postgresqlCluster:PostgresqlCluster example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.DBforPostgreSQL/serverGroupsv2/cluster1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] administrator_login_password: The password of the administrator login. This is required when `source_resource_id` is not set.
        :param pulumi.Input[builtins.str] citus_version: The citus extension version on the Azure Cosmos DB for PostgreSQL Cluster. Possible values are `8.3`, `9.0`, `9.1`, `9.2`, `9.3`, `9.4`, `9.5`, `10.0`, `10.1`, `10.2`, `11.0`, `11.1`, `11.2`, `11.3` and `12.1`.
        :param pulumi.Input[builtins.bool] coordinator_public_ip_access_enabled: Is public access enabled on coordinator? Defaults to `true`.
        :param pulumi.Input[builtins.str] coordinator_server_edition: The edition of the coordinator server. Possible values are `BurstableGeneralPurpose`, `BurstableMemoryOptimized`, `GeneralPurpose` and `MemoryOptimized`. Defaults to `GeneralPurpose`.
        :param pulumi.Input[builtins.int] coordinator_storage_quota_in_mb: The coordinator storage allowed for the Azure Cosmos DB for PostgreSQL Cluster. Possible values are `32768`, `65536`, `131072`, `262144`, `524288`, `1048576`, `2097152`, `4194304`, `8388608`, `16777216`, and `33554432`.
               
               > **Note:** More information on [the types of compute resources available for CosmosDB can be found in the product documentation](https://learn.microsoft.com/azure/cosmos-db/postgresql/resources-compute)
        :param pulumi.Input[builtins.int] coordinator_vcore_count: The coordinator vCore count for the Azure Cosmos DB for PostgreSQL Cluster. Possible values are `1`, `2`, `4`, `8`, `16`, `32`, `64` and `96`.
        :param pulumi.Input[builtins.bool] ha_enabled: Is high availability enabled for the Azure Cosmos DB for PostgreSQL cluster? Defaults to `false`.
        :param pulumi.Input[builtins.str] location: The Azure Region where the Azure Cosmos DB for PostgreSQL Cluster should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['PostgresqlClusterMaintenanceWindowArgs', 'PostgresqlClusterMaintenanceWindowArgsDict']] maintenance_window: A `maintenance_window` block as defined below.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Azure Cosmos DB for PostgreSQL Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.int] node_count: The worker node count of the Azure Cosmos DB for PostgreSQL Cluster. Possible value is between `0` and `20` except `1`.
        :param pulumi.Input[builtins.bool] node_public_ip_access_enabled: Is public access enabled on worker nodes. Defaults to `false`.
        :param pulumi.Input[builtins.str] node_server_edition: The edition of the node server. Possible values are `BurstableGeneralPurpose`, `BurstableMemoryOptimized`, `GeneralPurpose` and `MemoryOptimized`. Defaults to `MemoryOptimized`.
        :param pulumi.Input[builtins.int] node_storage_quota_in_mb: The storage quota in MB on each worker node. Possible values are `32768`, `65536`, `131072`, `262144`, `524288`, `1048576`, `2097152`, `4194304`, `8388608` and `16777216`.
        :param pulumi.Input[builtins.int] node_vcores: The vCores count on each worker node. Possible values are `1`, `2`, `4`, `8`, `16`, `32`, `64`, `96` and `104`.
        :param pulumi.Input[builtins.str] point_in_time_in_utc: The date and time in UTC (ISO8601 format) for the Azure Cosmos DB for PostgreSQL cluster restore. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] preferred_primary_zone: The preferred primary availability zone for the Azure Cosmos DB for PostgreSQL cluster.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group where the Azure Cosmos DB for PostgreSQL Cluster should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] shards_on_coordinator_enabled: Is shards on coordinator enabled for the Azure Cosmos DB for PostgreSQL cluster.
        :param pulumi.Input[builtins.str] source_location: The Azure region of the source Azure Cosmos DB for PostgreSQL cluster for read replica clusters. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] source_resource_id: The resource ID of the source Azure Cosmos DB for PostgreSQL cluster for read replica clusters. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] sql_version: The major PostgreSQL version on the Azure Cosmos DB for PostgreSQL cluster. Possible values are `11`, `12`, `13`, `14`, `15` and `16`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the Azure Cosmos DB for PostgreSQL Cluster.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PostgresqlClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Azure Cosmos DB for PostgreSQL Cluster.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_postgresql_cluster = azure.cosmosdb.PostgresqlCluster("example",
            name="example-cluster",
            resource_group_name=example.name,
            location=example.location,
            administrator_login_password="H@Sh1CoR3!",
            coordinator_storage_quota_in_mb=131072,
            coordinator_vcore_count=2,
            node_count=0)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.DBforPostgreSQL`: 2022-11-08

        ## Import

        Azure Cosmos DB for PostgreSQL Clusters can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:cosmosdb/postgresqlCluster:PostgresqlCluster example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.DBforPostgreSQL/serverGroupsv2/cluster1
        ```

        :param str resource_name: The name of the resource.
        :param PostgresqlClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PostgresqlClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 administrator_login_password: Optional[pulumi.Input[builtins.str]] = None,
                 citus_version: Optional[pulumi.Input[builtins.str]] = None,
                 coordinator_public_ip_access_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 coordinator_server_edition: Optional[pulumi.Input[builtins.str]] = None,
                 coordinator_storage_quota_in_mb: Optional[pulumi.Input[builtins.int]] = None,
                 coordinator_vcore_count: Optional[pulumi.Input[builtins.int]] = None,
                 ha_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 maintenance_window: Optional[pulumi.Input[Union['PostgresqlClusterMaintenanceWindowArgs', 'PostgresqlClusterMaintenanceWindowArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 node_count: Optional[pulumi.Input[builtins.int]] = None,
                 node_public_ip_access_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 node_server_edition: Optional[pulumi.Input[builtins.str]] = None,
                 node_storage_quota_in_mb: Optional[pulumi.Input[builtins.int]] = None,
                 node_vcores: Optional[pulumi.Input[builtins.int]] = None,
                 point_in_time_in_utc: Optional[pulumi.Input[builtins.str]] = None,
                 preferred_primary_zone: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 shards_on_coordinator_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 source_location: Optional[pulumi.Input[builtins.str]] = None,
                 source_resource_id: Optional[pulumi.Input[builtins.str]] = None,
                 sql_version: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PostgresqlClusterArgs.__new__(PostgresqlClusterArgs)

            __props__.__dict__["administrator_login_password"] = None if administrator_login_password is None else pulumi.Output.secret(administrator_login_password)
            __props__.__dict__["citus_version"] = citus_version
            __props__.__dict__["coordinator_public_ip_access_enabled"] = coordinator_public_ip_access_enabled
            __props__.__dict__["coordinator_server_edition"] = coordinator_server_edition
            __props__.__dict__["coordinator_storage_quota_in_mb"] = coordinator_storage_quota_in_mb
            __props__.__dict__["coordinator_vcore_count"] = coordinator_vcore_count
            __props__.__dict__["ha_enabled"] = ha_enabled
            __props__.__dict__["location"] = location
            __props__.__dict__["maintenance_window"] = maintenance_window
            __props__.__dict__["name"] = name
            if node_count is None and not opts.urn:
                raise TypeError("Missing required property 'node_count'")
            __props__.__dict__["node_count"] = node_count
            __props__.__dict__["node_public_ip_access_enabled"] = node_public_ip_access_enabled
            __props__.__dict__["node_server_edition"] = node_server_edition
            __props__.__dict__["node_storage_quota_in_mb"] = node_storage_quota_in_mb
            __props__.__dict__["node_vcores"] = node_vcores
            __props__.__dict__["point_in_time_in_utc"] = point_in_time_in_utc
            __props__.__dict__["preferred_primary_zone"] = preferred_primary_zone
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["shards_on_coordinator_enabled"] = shards_on_coordinator_enabled
            __props__.__dict__["source_location"] = source_location
            __props__.__dict__["source_resource_id"] = source_resource_id
            __props__.__dict__["sql_version"] = sql_version
            __props__.__dict__["tags"] = tags
            __props__.__dict__["earliest_restore_time"] = None
            __props__.__dict__["servers"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["administratorLoginPassword"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(PostgresqlCluster, __self__).__init__(
            'azure:cosmosdb/postgresqlCluster:PostgresqlCluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            administrator_login_password: Optional[pulumi.Input[builtins.str]] = None,
            citus_version: Optional[pulumi.Input[builtins.str]] = None,
            coordinator_public_ip_access_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            coordinator_server_edition: Optional[pulumi.Input[builtins.str]] = None,
            coordinator_storage_quota_in_mb: Optional[pulumi.Input[builtins.int]] = None,
            coordinator_vcore_count: Optional[pulumi.Input[builtins.int]] = None,
            earliest_restore_time: Optional[pulumi.Input[builtins.str]] = None,
            ha_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            maintenance_window: Optional[pulumi.Input[Union['PostgresqlClusterMaintenanceWindowArgs', 'PostgresqlClusterMaintenanceWindowArgsDict']]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            node_count: Optional[pulumi.Input[builtins.int]] = None,
            node_public_ip_access_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            node_server_edition: Optional[pulumi.Input[builtins.str]] = None,
            node_storage_quota_in_mb: Optional[pulumi.Input[builtins.int]] = None,
            node_vcores: Optional[pulumi.Input[builtins.int]] = None,
            point_in_time_in_utc: Optional[pulumi.Input[builtins.str]] = None,
            preferred_primary_zone: Optional[pulumi.Input[builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
            servers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PostgresqlClusterServerArgs', 'PostgresqlClusterServerArgsDict']]]]] = None,
            shards_on_coordinator_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            source_location: Optional[pulumi.Input[builtins.str]] = None,
            source_resource_id: Optional[pulumi.Input[builtins.str]] = None,
            sql_version: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None) -> 'PostgresqlCluster':
        """
        Get an existing PostgresqlCluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] administrator_login_password: The password of the administrator login. This is required when `source_resource_id` is not set.
        :param pulumi.Input[builtins.str] citus_version: The citus extension version on the Azure Cosmos DB for PostgreSQL Cluster. Possible values are `8.3`, `9.0`, `9.1`, `9.2`, `9.3`, `9.4`, `9.5`, `10.0`, `10.1`, `10.2`, `11.0`, `11.1`, `11.2`, `11.3` and `12.1`.
        :param pulumi.Input[builtins.bool] coordinator_public_ip_access_enabled: Is public access enabled on coordinator? Defaults to `true`.
        :param pulumi.Input[builtins.str] coordinator_server_edition: The edition of the coordinator server. Possible values are `BurstableGeneralPurpose`, `BurstableMemoryOptimized`, `GeneralPurpose` and `MemoryOptimized`. Defaults to `GeneralPurpose`.
        :param pulumi.Input[builtins.int] coordinator_storage_quota_in_mb: The coordinator storage allowed for the Azure Cosmos DB for PostgreSQL Cluster. Possible values are `32768`, `65536`, `131072`, `262144`, `524288`, `1048576`, `2097152`, `4194304`, `8388608`, `16777216`, and `33554432`.
               
               > **Note:** More information on [the types of compute resources available for CosmosDB can be found in the product documentation](https://learn.microsoft.com/azure/cosmos-db/postgresql/resources-compute)
        :param pulumi.Input[builtins.int] coordinator_vcore_count: The coordinator vCore count for the Azure Cosmos DB for PostgreSQL Cluster. Possible values are `1`, `2`, `4`, `8`, `16`, `32`, `64` and `96`.
        :param pulumi.Input[builtins.str] earliest_restore_time: The earliest restore point time (ISO8601 format) for the Azure Cosmos DB for PostgreSQL Cluster.
        :param pulumi.Input[builtins.bool] ha_enabled: Is high availability enabled for the Azure Cosmos DB for PostgreSQL cluster? Defaults to `false`.
        :param pulumi.Input[builtins.str] location: The Azure Region where the Azure Cosmos DB for PostgreSQL Cluster should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['PostgresqlClusterMaintenanceWindowArgs', 'PostgresqlClusterMaintenanceWindowArgsDict']] maintenance_window: A `maintenance_window` block as defined below.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Azure Cosmos DB for PostgreSQL Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.int] node_count: The worker node count of the Azure Cosmos DB for PostgreSQL Cluster. Possible value is between `0` and `20` except `1`.
        :param pulumi.Input[builtins.bool] node_public_ip_access_enabled: Is public access enabled on worker nodes. Defaults to `false`.
        :param pulumi.Input[builtins.str] node_server_edition: The edition of the node server. Possible values are `BurstableGeneralPurpose`, `BurstableMemoryOptimized`, `GeneralPurpose` and `MemoryOptimized`. Defaults to `MemoryOptimized`.
        :param pulumi.Input[builtins.int] node_storage_quota_in_mb: The storage quota in MB on each worker node. Possible values are `32768`, `65536`, `131072`, `262144`, `524288`, `1048576`, `2097152`, `4194304`, `8388608` and `16777216`.
        :param pulumi.Input[builtins.int] node_vcores: The vCores count on each worker node. Possible values are `1`, `2`, `4`, `8`, `16`, `32`, `64`, `96` and `104`.
        :param pulumi.Input[builtins.str] point_in_time_in_utc: The date and time in UTC (ISO8601 format) for the Azure Cosmos DB for PostgreSQL cluster restore. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] preferred_primary_zone: The preferred primary availability zone for the Azure Cosmos DB for PostgreSQL cluster.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group where the Azure Cosmos DB for PostgreSQL Cluster should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PostgresqlClusterServerArgs', 'PostgresqlClusterServerArgsDict']]]] servers: A `servers` block as defined below.
        :param pulumi.Input[builtins.bool] shards_on_coordinator_enabled: Is shards on coordinator enabled for the Azure Cosmos DB for PostgreSQL cluster.
        :param pulumi.Input[builtins.str] source_location: The Azure region of the source Azure Cosmos DB for PostgreSQL cluster for read replica clusters. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] source_resource_id: The resource ID of the source Azure Cosmos DB for PostgreSQL cluster for read replica clusters. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] sql_version: The major PostgreSQL version on the Azure Cosmos DB for PostgreSQL cluster. Possible values are `11`, `12`, `13`, `14`, `15` and `16`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the Azure Cosmos DB for PostgreSQL Cluster.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PostgresqlClusterState.__new__(_PostgresqlClusterState)

        __props__.__dict__["administrator_login_password"] = administrator_login_password
        __props__.__dict__["citus_version"] = citus_version
        __props__.__dict__["coordinator_public_ip_access_enabled"] = coordinator_public_ip_access_enabled
        __props__.__dict__["coordinator_server_edition"] = coordinator_server_edition
        __props__.__dict__["coordinator_storage_quota_in_mb"] = coordinator_storage_quota_in_mb
        __props__.__dict__["coordinator_vcore_count"] = coordinator_vcore_count
        __props__.__dict__["earliest_restore_time"] = earliest_restore_time
        __props__.__dict__["ha_enabled"] = ha_enabled
        __props__.__dict__["location"] = location
        __props__.__dict__["maintenance_window"] = maintenance_window
        __props__.__dict__["name"] = name
        __props__.__dict__["node_count"] = node_count
        __props__.__dict__["node_public_ip_access_enabled"] = node_public_ip_access_enabled
        __props__.__dict__["node_server_edition"] = node_server_edition
        __props__.__dict__["node_storage_quota_in_mb"] = node_storage_quota_in_mb
        __props__.__dict__["node_vcores"] = node_vcores
        __props__.__dict__["point_in_time_in_utc"] = point_in_time_in_utc
        __props__.__dict__["preferred_primary_zone"] = preferred_primary_zone
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["servers"] = servers
        __props__.__dict__["shards_on_coordinator_enabled"] = shards_on_coordinator_enabled
        __props__.__dict__["source_location"] = source_location
        __props__.__dict__["source_resource_id"] = source_resource_id
        __props__.__dict__["sql_version"] = sql_version
        __props__.__dict__["tags"] = tags
        return PostgresqlCluster(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="administratorLoginPassword")
    def administrator_login_password(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The password of the administrator login. This is required when `source_resource_id` is not set.
        """
        return pulumi.get(self, "administrator_login_password")

    @property
    @pulumi.getter(name="citusVersion")
    def citus_version(self) -> pulumi.Output[builtins.str]:
        """
        The citus extension version on the Azure Cosmos DB for PostgreSQL Cluster. Possible values are `8.3`, `9.0`, `9.1`, `9.2`, `9.3`, `9.4`, `9.5`, `10.0`, `10.1`, `10.2`, `11.0`, `11.1`, `11.2`, `11.3` and `12.1`.
        """
        return pulumi.get(self, "citus_version")

    @property
    @pulumi.getter(name="coordinatorPublicIpAccessEnabled")
    def coordinator_public_ip_access_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Is public access enabled on coordinator? Defaults to `true`.
        """
        return pulumi.get(self, "coordinator_public_ip_access_enabled")

    @property
    @pulumi.getter(name="coordinatorServerEdition")
    def coordinator_server_edition(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The edition of the coordinator server. Possible values are `BurstableGeneralPurpose`, `BurstableMemoryOptimized`, `GeneralPurpose` and `MemoryOptimized`. Defaults to `GeneralPurpose`.
        """
        return pulumi.get(self, "coordinator_server_edition")

    @property
    @pulumi.getter(name="coordinatorStorageQuotaInMb")
    def coordinator_storage_quota_in_mb(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The coordinator storage allowed for the Azure Cosmos DB for PostgreSQL Cluster. Possible values are `32768`, `65536`, `131072`, `262144`, `524288`, `1048576`, `2097152`, `4194304`, `8388608`, `16777216`, and `33554432`.

        > **Note:** More information on [the types of compute resources available for CosmosDB can be found in the product documentation](https://learn.microsoft.com/azure/cosmos-db/postgresql/resources-compute)
        """
        return pulumi.get(self, "coordinator_storage_quota_in_mb")

    @property
    @pulumi.getter(name="coordinatorVcoreCount")
    def coordinator_vcore_count(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The coordinator vCore count for the Azure Cosmos DB for PostgreSQL Cluster. Possible values are `1`, `2`, `4`, `8`, `16`, `32`, `64` and `96`.
        """
        return pulumi.get(self, "coordinator_vcore_count")

    @property
    @pulumi.getter(name="earliestRestoreTime")
    def earliest_restore_time(self) -> pulumi.Output[builtins.str]:
        """
        The earliest restore point time (ISO8601 format) for the Azure Cosmos DB for PostgreSQL Cluster.
        """
        return pulumi.get(self, "earliest_restore_time")

    @property
    @pulumi.getter(name="haEnabled")
    def ha_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Is high availability enabled for the Azure Cosmos DB for PostgreSQL cluster? Defaults to `false`.
        """
        return pulumi.get(self, "ha_enabled")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        The Azure Region where the Azure Cosmos DB for PostgreSQL Cluster should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> pulumi.Output[Optional['outputs.PostgresqlClusterMaintenanceWindow']]:
        """
        A `maintenance_window` block as defined below.
        """
        return pulumi.get(self, "maintenance_window")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name which should be used for this Azure Cosmos DB for PostgreSQL Cluster. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> pulumi.Output[builtins.int]:
        """
        The worker node count of the Azure Cosmos DB for PostgreSQL Cluster. Possible value is between `0` and `20` except `1`.
        """
        return pulumi.get(self, "node_count")

    @property
    @pulumi.getter(name="nodePublicIpAccessEnabled")
    def node_public_ip_access_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Is public access enabled on worker nodes. Defaults to `false`.
        """
        return pulumi.get(self, "node_public_ip_access_enabled")

    @property
    @pulumi.getter(name="nodeServerEdition")
    def node_server_edition(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The edition of the node server. Possible values are `BurstableGeneralPurpose`, `BurstableMemoryOptimized`, `GeneralPurpose` and `MemoryOptimized`. Defaults to `MemoryOptimized`.
        """
        return pulumi.get(self, "node_server_edition")

    @property
    @pulumi.getter(name="nodeStorageQuotaInMb")
    def node_storage_quota_in_mb(self) -> pulumi.Output[builtins.int]:
        """
        The storage quota in MB on each worker node. Possible values are `32768`, `65536`, `131072`, `262144`, `524288`, `1048576`, `2097152`, `4194304`, `8388608` and `16777216`.
        """
        return pulumi.get(self, "node_storage_quota_in_mb")

    @property
    @pulumi.getter(name="nodeVcores")
    def node_vcores(self) -> pulumi.Output[builtins.int]:
        """
        The vCores count on each worker node. Possible values are `1`, `2`, `4`, `8`, `16`, `32`, `64`, `96` and `104`.
        """
        return pulumi.get(self, "node_vcores")

    @property
    @pulumi.getter(name="pointInTimeInUtc")
    def point_in_time_in_utc(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The date and time in UTC (ISO8601 format) for the Azure Cosmos DB for PostgreSQL cluster restore. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "point_in_time_in_utc")

    @property
    @pulumi.getter(name="preferredPrimaryZone")
    def preferred_primary_zone(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The preferred primary availability zone for the Azure Cosmos DB for PostgreSQL cluster.
        """
        return pulumi.get(self, "preferred_primary_zone")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Resource Group where the Azure Cosmos DB for PostgreSQL Cluster should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter
    def servers(self) -> pulumi.Output[Sequence['outputs.PostgresqlClusterServer']]:
        """
        A `servers` block as defined below.
        """
        return pulumi.get(self, "servers")

    @property
    @pulumi.getter(name="shardsOnCoordinatorEnabled")
    def shards_on_coordinator_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        Is shards on coordinator enabled for the Azure Cosmos DB for PostgreSQL cluster.
        """
        return pulumi.get(self, "shards_on_coordinator_enabled")

    @property
    @pulumi.getter(name="sourceLocation")
    def source_location(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Azure region of the source Azure Cosmos DB for PostgreSQL cluster for read replica clusters. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "source_location")

    @property
    @pulumi.getter(name="sourceResourceId")
    def source_resource_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The resource ID of the source Azure Cosmos DB for PostgreSQL cluster for read replica clusters. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "source_resource_id")

    @property
    @pulumi.getter(name="sqlVersion")
    def sql_version(self) -> pulumi.Output[builtins.str]:
        """
        The major PostgreSQL version on the Azure Cosmos DB for PostgreSQL cluster. Possible values are `11`, `12`, `13`, `14`, `15` and `16`.
        """
        return pulumi.get(self, "sql_version")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A mapping of tags which should be assigned to the Azure Cosmos DB for PostgreSQL Cluster.
        """
        return pulumi.get(self, "tags")

