# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['PrefixArgs', 'Prefix']

@pulumi.input_type
class PrefixArgs:
    def __init__(__self__, *,
                 cidr: pulumi.Input[builtins.str],
                 resource_group_name: pulumi.Input[builtins.str],
                 commissioning_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 internet_advertising_disabled: Optional[pulumi.Input[builtins.bool]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 parent_custom_ip_prefix_id: Optional[pulumi.Input[builtins.str]] = None,
                 roa_validity_end_date: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 wan_validation_signed_message: Optional[pulumi.Input[builtins.str]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a Prefix resource.
        :param pulumi.Input[builtins.str] cidr: The `cidr` of the Custom IP Prefix, either IPv4 or IPv6. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group in which to create the Custom IP Prefix. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] commissioning_enabled: Specifies that the custom IP prefix should be commissioned after provisioning in Azure. Defaults to `false`.
               
               !> **Note:** Changing the value of `commissioning_enabled` from `true` to `false` causes the IP prefix to stop being advertised by Azure and is functionally equivalent to deleting it when used in a production setting.
        :param pulumi.Input[builtins.bool] internet_advertising_disabled: Specifies that the custom IP prefix should not be publicly advertised on the Internet when commissioned (regional commissioning feature). Defaults to `false`.
               
               !> **Note:** Changing the value of `internet_advertising_disabled` from `true` to `false` causes the IP prefix to stop being advertised by Azure and is functionally equivalent to deleting it when used in a production setting.
        :param pulumi.Input[builtins.str] location: The location where the Custom IP Prefix should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: The name of the Custom IP Prefix. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] parent_custom_ip_prefix_id: Specifies the ID of the parent prefix. Only needed when creating a regional/child IPv6 prefix. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] roa_validity_end_date: The expiration date of the Route Origin Authorization (ROA) document which has been filed with the Routing Internet Registry (RIR) for this prefix. The expected format is `YYYY-MM-DD`. Required when provisioning an IPv4 prefix or IPv6 global prefix. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the Custom IP Prefix.
        :param pulumi.Input[builtins.str] wan_validation_signed_message: The signed base64-encoded authorization message, which will be sent to Microsoft for WAN verification. Required when provisioning an IPv4 prefix or IPv6 global prefix. Refer to [Azure documentation](https://learn.microsoft.com/en-us/azure/virtual-network/ip-services/create-custom-ip-address-prefix-cli#certificate-readiness) for more details about the process for your RIR. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] zones: Specifies a list of Availability Zones in which this Custom IP Prefix should be located. Should not be specified when creating an IPv6 global prefix. Changing this forces a new resource to be created.
               
               > **Note:** In regions with [availability zones](https://docs.microsoft.com/en-us/azure/availability-zones/az-overview), the Custom IP Prefix must be specified as either `Zone-redundant` or assigned to a specific zone. It can't be created with no zone specified in these regions. All IPs from the prefix must have the same zonal properties.
        """
        pulumi.set(__self__, "cidr", cidr)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if commissioning_enabled is not None:
            pulumi.set(__self__, "commissioning_enabled", commissioning_enabled)
        if internet_advertising_disabled is not None:
            pulumi.set(__self__, "internet_advertising_disabled", internet_advertising_disabled)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parent_custom_ip_prefix_id is not None:
            pulumi.set(__self__, "parent_custom_ip_prefix_id", parent_custom_ip_prefix_id)
        if roa_validity_end_date is not None:
            pulumi.set(__self__, "roa_validity_end_date", roa_validity_end_date)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if wan_validation_signed_message is not None:
            pulumi.set(__self__, "wan_validation_signed_message", wan_validation_signed_message)
        if zones is not None:
            pulumi.set(__self__, "zones", zones)

    @property
    @pulumi.getter
    def cidr(self) -> pulumi.Input[builtins.str]:
        """
        The `cidr` of the Custom IP Prefix, either IPv4 or IPv6. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "cidr")

    @cidr.setter
    def cidr(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "cidr", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the Resource Group in which to create the Custom IP Prefix. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="commissioningEnabled")
    def commissioning_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies that the custom IP prefix should be commissioned after provisioning in Azure. Defaults to `false`.

        !> **Note:** Changing the value of `commissioning_enabled` from `true` to `false` causes the IP prefix to stop being advertised by Azure and is functionally equivalent to deleting it when used in a production setting.
        """
        return pulumi.get(self, "commissioning_enabled")

    @commissioning_enabled.setter
    def commissioning_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "commissioning_enabled", value)

    @property
    @pulumi.getter(name="internetAdvertisingDisabled")
    def internet_advertising_disabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies that the custom IP prefix should not be publicly advertised on the Internet when commissioned (regional commissioning feature). Defaults to `false`.

        !> **Note:** Changing the value of `internet_advertising_disabled` from `true` to `false` causes the IP prefix to stop being advertised by Azure and is functionally equivalent to deleting it when used in a production setting.
        """
        return pulumi.get(self, "internet_advertising_disabled")

    @internet_advertising_disabled.setter
    def internet_advertising_disabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "internet_advertising_disabled", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The location where the Custom IP Prefix should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Custom IP Prefix. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="parentCustomIpPrefixId")
    def parent_custom_ip_prefix_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the ID of the parent prefix. Only needed when creating a regional/child IPv6 prefix. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "parent_custom_ip_prefix_id")

    @parent_custom_ip_prefix_id.setter
    def parent_custom_ip_prefix_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "parent_custom_ip_prefix_id", value)

    @property
    @pulumi.getter(name="roaValidityEndDate")
    def roa_validity_end_date(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The expiration date of the Route Origin Authorization (ROA) document which has been filed with the Routing Internet Registry (RIR) for this prefix. The expected format is `YYYY-MM-DD`. Required when provisioning an IPv4 prefix or IPv6 global prefix. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "roa_validity_end_date")

    @roa_validity_end_date.setter
    def roa_validity_end_date(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "roa_validity_end_date", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags to assign to the Custom IP Prefix.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="wanValidationSignedMessage")
    def wan_validation_signed_message(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The signed base64-encoded authorization message, which will be sent to Microsoft for WAN verification. Required when provisioning an IPv4 prefix or IPv6 global prefix. Refer to [Azure documentation](https://learn.microsoft.com/en-us/azure/virtual-network/ip-services/create-custom-ip-address-prefix-cli#certificate-readiness) for more details about the process for your RIR. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "wan_validation_signed_message")

    @wan_validation_signed_message.setter
    def wan_validation_signed_message(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "wan_validation_signed_message", value)

    @property
    @pulumi.getter
    def zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Specifies a list of Availability Zones in which this Custom IP Prefix should be located. Should not be specified when creating an IPv6 global prefix. Changing this forces a new resource to be created.

        > **Note:** In regions with [availability zones](https://docs.microsoft.com/en-us/azure/availability-zones/az-overview), the Custom IP Prefix must be specified as either `Zone-redundant` or assigned to a specific zone. It can't be created with no zone specified in these regions. All IPs from the prefix must have the same zonal properties.
        """
        return pulumi.get(self, "zones")

    @zones.setter
    def zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "zones", value)


@pulumi.input_type
class _PrefixState:
    def __init__(__self__, *,
                 cidr: Optional[pulumi.Input[builtins.str]] = None,
                 commissioning_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 internet_advertising_disabled: Optional[pulumi.Input[builtins.bool]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 parent_custom_ip_prefix_id: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 roa_validity_end_date: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 wan_validation_signed_message: Optional[pulumi.Input[builtins.str]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Prefix resources.
        :param pulumi.Input[builtins.str] cidr: The `cidr` of the Custom IP Prefix, either IPv4 or IPv6. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] commissioning_enabled: Specifies that the custom IP prefix should be commissioned after provisioning in Azure. Defaults to `false`.
               
               !> **Note:** Changing the value of `commissioning_enabled` from `true` to `false` causes the IP prefix to stop being advertised by Azure and is functionally equivalent to deleting it when used in a production setting.
        :param pulumi.Input[builtins.bool] internet_advertising_disabled: Specifies that the custom IP prefix should not be publicly advertised on the Internet when commissioned (regional commissioning feature). Defaults to `false`.
               
               !> **Note:** Changing the value of `internet_advertising_disabled` from `true` to `false` causes the IP prefix to stop being advertised by Azure and is functionally equivalent to deleting it when used in a production setting.
        :param pulumi.Input[builtins.str] location: The location where the Custom IP Prefix should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: The name of the Custom IP Prefix. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] parent_custom_ip_prefix_id: Specifies the ID of the parent prefix. Only needed when creating a regional/child IPv6 prefix. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group in which to create the Custom IP Prefix. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] roa_validity_end_date: The expiration date of the Route Origin Authorization (ROA) document which has been filed with the Routing Internet Registry (RIR) for this prefix. The expected format is `YYYY-MM-DD`. Required when provisioning an IPv4 prefix or IPv6 global prefix. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the Custom IP Prefix.
        :param pulumi.Input[builtins.str] wan_validation_signed_message: The signed base64-encoded authorization message, which will be sent to Microsoft for WAN verification. Required when provisioning an IPv4 prefix or IPv6 global prefix. Refer to [Azure documentation](https://learn.microsoft.com/en-us/azure/virtual-network/ip-services/create-custom-ip-address-prefix-cli#certificate-readiness) for more details about the process for your RIR. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] zones: Specifies a list of Availability Zones in which this Custom IP Prefix should be located. Should not be specified when creating an IPv6 global prefix. Changing this forces a new resource to be created.
               
               > **Note:** In regions with [availability zones](https://docs.microsoft.com/en-us/azure/availability-zones/az-overview), the Custom IP Prefix must be specified as either `Zone-redundant` or assigned to a specific zone. It can't be created with no zone specified in these regions. All IPs from the prefix must have the same zonal properties.
        """
        if cidr is not None:
            pulumi.set(__self__, "cidr", cidr)
        if commissioning_enabled is not None:
            pulumi.set(__self__, "commissioning_enabled", commissioning_enabled)
        if internet_advertising_disabled is not None:
            pulumi.set(__self__, "internet_advertising_disabled", internet_advertising_disabled)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parent_custom_ip_prefix_id is not None:
            pulumi.set(__self__, "parent_custom_ip_prefix_id", parent_custom_ip_prefix_id)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if roa_validity_end_date is not None:
            pulumi.set(__self__, "roa_validity_end_date", roa_validity_end_date)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if wan_validation_signed_message is not None:
            pulumi.set(__self__, "wan_validation_signed_message", wan_validation_signed_message)
        if zones is not None:
            pulumi.set(__self__, "zones", zones)

    @property
    @pulumi.getter
    def cidr(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The `cidr` of the Custom IP Prefix, either IPv4 or IPv6. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "cidr")

    @cidr.setter
    def cidr(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cidr", value)

    @property
    @pulumi.getter(name="commissioningEnabled")
    def commissioning_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies that the custom IP prefix should be commissioned after provisioning in Azure. Defaults to `false`.

        !> **Note:** Changing the value of `commissioning_enabled` from `true` to `false` causes the IP prefix to stop being advertised by Azure and is functionally equivalent to deleting it when used in a production setting.
        """
        return pulumi.get(self, "commissioning_enabled")

    @commissioning_enabled.setter
    def commissioning_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "commissioning_enabled", value)

    @property
    @pulumi.getter(name="internetAdvertisingDisabled")
    def internet_advertising_disabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies that the custom IP prefix should not be publicly advertised on the Internet when commissioned (regional commissioning feature). Defaults to `false`.

        !> **Note:** Changing the value of `internet_advertising_disabled` from `true` to `false` causes the IP prefix to stop being advertised by Azure and is functionally equivalent to deleting it when used in a production setting.
        """
        return pulumi.get(self, "internet_advertising_disabled")

    @internet_advertising_disabled.setter
    def internet_advertising_disabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "internet_advertising_disabled", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The location where the Custom IP Prefix should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Custom IP Prefix. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="parentCustomIpPrefixId")
    def parent_custom_ip_prefix_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the ID of the parent prefix. Only needed when creating a regional/child IPv6 prefix. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "parent_custom_ip_prefix_id")

    @parent_custom_ip_prefix_id.setter
    def parent_custom_ip_prefix_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "parent_custom_ip_prefix_id", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Resource Group in which to create the Custom IP Prefix. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="roaValidityEndDate")
    def roa_validity_end_date(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The expiration date of the Route Origin Authorization (ROA) document which has been filed with the Routing Internet Registry (RIR) for this prefix. The expected format is `YYYY-MM-DD`. Required when provisioning an IPv4 prefix or IPv6 global prefix. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "roa_validity_end_date")

    @roa_validity_end_date.setter
    def roa_validity_end_date(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "roa_validity_end_date", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags to assign to the Custom IP Prefix.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="wanValidationSignedMessage")
    def wan_validation_signed_message(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The signed base64-encoded authorization message, which will be sent to Microsoft for WAN verification. Required when provisioning an IPv4 prefix or IPv6 global prefix. Refer to [Azure documentation](https://learn.microsoft.com/en-us/azure/virtual-network/ip-services/create-custom-ip-address-prefix-cli#certificate-readiness) for more details about the process for your RIR. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "wan_validation_signed_message")

    @wan_validation_signed_message.setter
    def wan_validation_signed_message(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "wan_validation_signed_message", value)

    @property
    @pulumi.getter
    def zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Specifies a list of Availability Zones in which this Custom IP Prefix should be located. Should not be specified when creating an IPv6 global prefix. Changing this forces a new resource to be created.

        > **Note:** In regions with [availability zones](https://docs.microsoft.com/en-us/azure/availability-zones/az-overview), the Custom IP Prefix must be specified as either `Zone-redundant` or assigned to a specific zone. It can't be created with no zone specified in these regions. All IPs from the prefix must have the same zonal properties.
        """
        return pulumi.get(self, "zones")

    @zones.setter
    def zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "zones", value)


@pulumi.type_token("azure:customip/prefix:Prefix")
class Prefix(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cidr: Optional[pulumi.Input[builtins.str]] = None,
                 commissioning_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 internet_advertising_disabled: Optional[pulumi.Input[builtins.bool]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 parent_custom_ip_prefix_id: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 roa_validity_end_date: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 wan_validation_signed_message: Optional[pulumi.Input[builtins.str]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        Manages a custom IPv4 prefix or custom IPv6 prefix.

        ## Example Usage

        *IPv4 custom prefix*
        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_prefix = azure.customip.Prefix("example",
            name="example-CustomIPPrefix",
            location=example.location,
            resource_group_name=example.name,
            cidr="1.2.3.4/22",
            zones=[
                "1",
                "2",
                "3",
            ],
            commissioning_enabled=True,
            roa_validity_end_date="2099-12-12",
            wan_validation_signed_message="signed message for WAN validation",
            tags={
                "env": "test",
            })
        ```

        *IPv6 custom prefix*
        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_std as std

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        global_ = azure.customip.Prefix("global",
            name="example-Global-CustomIPPrefix",
            location=test["location"],
            resource_group_name=test["name"],
            cidr="2001:db8:1::/48",
            roa_validity_end_date="2199-12-12",
            wan_validation_signed_message="signed message for WAN validation")
        regional = azure.customip.Prefix("regional",
            name="example-Regional-CustomIPPrefix",
            location=test["location"],
            resource_group_name=test["name"],
            parent_custom_ip_prefix_id=global_.id,
            cidr=global_.cidr.apply(lambda cidr: std.cidrsubnet_output(input=cidr,
                newbits=16,
                netnum=1)).apply(lambda invoke: invoke.result),
            zones=["1"])
        ```

        ## Import

        A Custom IP Prefix can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:customip/prefix:Prefix example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Network/customIPPrefixes/customIPPrefix1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] cidr: The `cidr` of the Custom IP Prefix, either IPv4 or IPv6. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] commissioning_enabled: Specifies that the custom IP prefix should be commissioned after provisioning in Azure. Defaults to `false`.
               
               !> **Note:** Changing the value of `commissioning_enabled` from `true` to `false` causes the IP prefix to stop being advertised by Azure and is functionally equivalent to deleting it when used in a production setting.
        :param pulumi.Input[builtins.bool] internet_advertising_disabled: Specifies that the custom IP prefix should not be publicly advertised on the Internet when commissioned (regional commissioning feature). Defaults to `false`.
               
               !> **Note:** Changing the value of `internet_advertising_disabled` from `true` to `false` causes the IP prefix to stop being advertised by Azure and is functionally equivalent to deleting it when used in a production setting.
        :param pulumi.Input[builtins.str] location: The location where the Custom IP Prefix should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: The name of the Custom IP Prefix. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] parent_custom_ip_prefix_id: Specifies the ID of the parent prefix. Only needed when creating a regional/child IPv6 prefix. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group in which to create the Custom IP Prefix. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] roa_validity_end_date: The expiration date of the Route Origin Authorization (ROA) document which has been filed with the Routing Internet Registry (RIR) for this prefix. The expected format is `YYYY-MM-DD`. Required when provisioning an IPv4 prefix or IPv6 global prefix. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the Custom IP Prefix.
        :param pulumi.Input[builtins.str] wan_validation_signed_message: The signed base64-encoded authorization message, which will be sent to Microsoft for WAN verification. Required when provisioning an IPv4 prefix or IPv6 global prefix. Refer to [Azure documentation](https://learn.microsoft.com/en-us/azure/virtual-network/ip-services/create-custom-ip-address-prefix-cli#certificate-readiness) for more details about the process for your RIR. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] zones: Specifies a list of Availability Zones in which this Custom IP Prefix should be located. Should not be specified when creating an IPv6 global prefix. Changing this forces a new resource to be created.
               
               > **Note:** In regions with [availability zones](https://docs.microsoft.com/en-us/azure/availability-zones/az-overview), the Custom IP Prefix must be specified as either `Zone-redundant` or assigned to a specific zone. It can't be created with no zone specified in these regions. All IPs from the prefix must have the same zonal properties.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PrefixArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a custom IPv4 prefix or custom IPv6 prefix.

        ## Example Usage

        *IPv4 custom prefix*
        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_prefix = azure.customip.Prefix("example",
            name="example-CustomIPPrefix",
            location=example.location,
            resource_group_name=example.name,
            cidr="1.2.3.4/22",
            zones=[
                "1",
                "2",
                "3",
            ],
            commissioning_enabled=True,
            roa_validity_end_date="2099-12-12",
            wan_validation_signed_message="signed message for WAN validation",
            tags={
                "env": "test",
            })
        ```

        *IPv6 custom prefix*
        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_std as std

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        global_ = azure.customip.Prefix("global",
            name="example-Global-CustomIPPrefix",
            location=test["location"],
            resource_group_name=test["name"],
            cidr="2001:db8:1::/48",
            roa_validity_end_date="2199-12-12",
            wan_validation_signed_message="signed message for WAN validation")
        regional = azure.customip.Prefix("regional",
            name="example-Regional-CustomIPPrefix",
            location=test["location"],
            resource_group_name=test["name"],
            parent_custom_ip_prefix_id=global_.id,
            cidr=global_.cidr.apply(lambda cidr: std.cidrsubnet_output(input=cidr,
                newbits=16,
                netnum=1)).apply(lambda invoke: invoke.result),
            zones=["1"])
        ```

        ## Import

        A Custom IP Prefix can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:customip/prefix:Prefix example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Network/customIPPrefixes/customIPPrefix1
        ```

        :param str resource_name: The name of the resource.
        :param PrefixArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PrefixArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cidr: Optional[pulumi.Input[builtins.str]] = None,
                 commissioning_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 internet_advertising_disabled: Optional[pulumi.Input[builtins.bool]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 parent_custom_ip_prefix_id: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 roa_validity_end_date: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 wan_validation_signed_message: Optional[pulumi.Input[builtins.str]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PrefixArgs.__new__(PrefixArgs)

            if cidr is None and not opts.urn:
                raise TypeError("Missing required property 'cidr'")
            __props__.__dict__["cidr"] = cidr
            __props__.__dict__["commissioning_enabled"] = commissioning_enabled
            __props__.__dict__["internet_advertising_disabled"] = internet_advertising_disabled
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["parent_custom_ip_prefix_id"] = parent_custom_ip_prefix_id
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["roa_validity_end_date"] = roa_validity_end_date
            __props__.__dict__["tags"] = tags
            __props__.__dict__["wan_validation_signed_message"] = wan_validation_signed_message
            __props__.__dict__["zones"] = zones
        super(Prefix, __self__).__init__(
            'azure:customip/prefix:Prefix',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cidr: Optional[pulumi.Input[builtins.str]] = None,
            commissioning_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            internet_advertising_disabled: Optional[pulumi.Input[builtins.bool]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            parent_custom_ip_prefix_id: Optional[pulumi.Input[builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
            roa_validity_end_date: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            wan_validation_signed_message: Optional[pulumi.Input[builtins.str]] = None,
            zones: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None) -> 'Prefix':
        """
        Get an existing Prefix resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] cidr: The `cidr` of the Custom IP Prefix, either IPv4 or IPv6. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] commissioning_enabled: Specifies that the custom IP prefix should be commissioned after provisioning in Azure. Defaults to `false`.
               
               !> **Note:** Changing the value of `commissioning_enabled` from `true` to `false` causes the IP prefix to stop being advertised by Azure and is functionally equivalent to deleting it when used in a production setting.
        :param pulumi.Input[builtins.bool] internet_advertising_disabled: Specifies that the custom IP prefix should not be publicly advertised on the Internet when commissioned (regional commissioning feature). Defaults to `false`.
               
               !> **Note:** Changing the value of `internet_advertising_disabled` from `true` to `false` causes the IP prefix to stop being advertised by Azure and is functionally equivalent to deleting it when used in a production setting.
        :param pulumi.Input[builtins.str] location: The location where the Custom IP Prefix should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: The name of the Custom IP Prefix. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] parent_custom_ip_prefix_id: Specifies the ID of the parent prefix. Only needed when creating a regional/child IPv6 prefix. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group in which to create the Custom IP Prefix. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] roa_validity_end_date: The expiration date of the Route Origin Authorization (ROA) document which has been filed with the Routing Internet Registry (RIR) for this prefix. The expected format is `YYYY-MM-DD`. Required when provisioning an IPv4 prefix or IPv6 global prefix. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the Custom IP Prefix.
        :param pulumi.Input[builtins.str] wan_validation_signed_message: The signed base64-encoded authorization message, which will be sent to Microsoft for WAN verification. Required when provisioning an IPv4 prefix or IPv6 global prefix. Refer to [Azure documentation](https://learn.microsoft.com/en-us/azure/virtual-network/ip-services/create-custom-ip-address-prefix-cli#certificate-readiness) for more details about the process for your RIR. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] zones: Specifies a list of Availability Zones in which this Custom IP Prefix should be located. Should not be specified when creating an IPv6 global prefix. Changing this forces a new resource to be created.
               
               > **Note:** In regions with [availability zones](https://docs.microsoft.com/en-us/azure/availability-zones/az-overview), the Custom IP Prefix must be specified as either `Zone-redundant` or assigned to a specific zone. It can't be created with no zone specified in these regions. All IPs from the prefix must have the same zonal properties.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PrefixState.__new__(_PrefixState)

        __props__.__dict__["cidr"] = cidr
        __props__.__dict__["commissioning_enabled"] = commissioning_enabled
        __props__.__dict__["internet_advertising_disabled"] = internet_advertising_disabled
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["parent_custom_ip_prefix_id"] = parent_custom_ip_prefix_id
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["roa_validity_end_date"] = roa_validity_end_date
        __props__.__dict__["tags"] = tags
        __props__.__dict__["wan_validation_signed_message"] = wan_validation_signed_message
        __props__.__dict__["zones"] = zones
        return Prefix(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def cidr(self) -> pulumi.Output[builtins.str]:
        """
        The `cidr` of the Custom IP Prefix, either IPv4 or IPv6. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "cidr")

    @property
    @pulumi.getter(name="commissioningEnabled")
    def commissioning_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Specifies that the custom IP prefix should be commissioned after provisioning in Azure. Defaults to `false`.

        !> **Note:** Changing the value of `commissioning_enabled` from `true` to `false` causes the IP prefix to stop being advertised by Azure and is functionally equivalent to deleting it when used in a production setting.
        """
        return pulumi.get(self, "commissioning_enabled")

    @property
    @pulumi.getter(name="internetAdvertisingDisabled")
    def internet_advertising_disabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Specifies that the custom IP prefix should not be publicly advertised on the Internet when commissioned (regional commissioning feature). Defaults to `false`.

        !> **Note:** Changing the value of `internet_advertising_disabled` from `true` to `false` causes the IP prefix to stop being advertised by Azure and is functionally equivalent to deleting it when used in a production setting.
        """
        return pulumi.get(self, "internet_advertising_disabled")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        The location where the Custom IP Prefix should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Custom IP Prefix. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="parentCustomIpPrefixId")
    def parent_custom_ip_prefix_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies the ID of the parent prefix. Only needed when creating a regional/child IPv6 prefix. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "parent_custom_ip_prefix_id")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Resource Group in which to create the Custom IP Prefix. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter(name="roaValidityEndDate")
    def roa_validity_end_date(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The expiration date of the Route Origin Authorization (ROA) document which has been filed with the Routing Internet Registry (RIR) for this prefix. The expected format is `YYYY-MM-DD`. Required when provisioning an IPv4 prefix or IPv6 global prefix. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "roa_validity_end_date")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A mapping of tags to assign to the Custom IP Prefix.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="wanValidationSignedMessage")
    def wan_validation_signed_message(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The signed base64-encoded authorization message, which will be sent to Microsoft for WAN verification. Required when provisioning an IPv4 prefix or IPv6 global prefix. Refer to [Azure documentation](https://learn.microsoft.com/en-us/azure/virtual-network/ip-services/create-custom-ip-address-prefix-cli#certificate-readiness) for more details about the process for your RIR. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "wan_validation_signed_message")

    @property
    @pulumi.getter
    def zones(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        Specifies a list of Availability Zones in which this Custom IP Prefix should be located. Should not be specified when creating an IPv6 global prefix. Changing this forces a new resource to be created.

        > **Note:** In regions with [availability zones](https://docs.microsoft.com/en-us/azure/availability-zones/az-overview), the Custom IP Prefix must be specified as either `Zone-redundant` or assigned to a specific zone. It can't be created with no zone specified in these regions. All IPs from the prefix must have the same zonal properties.
        """
        return pulumi.get(self, "zones")

