# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetGrafanaResult',
    'AwaitableGetGrafanaResult',
    'get_grafana',
    'get_grafana_output',
]

@pulumi.output_type
class GetGrafanaResult:
    """
    A collection of values returned by getGrafana.
    """
    def __init__(__self__, api_key_enabled=None, auto_generated_domain_name_label_scope=None, azure_monitor_workspace_integrations=None, deterministic_outbound_ip_enabled=None, endpoint=None, grafana_major_version=None, grafana_version=None, id=None, identity=None, location=None, name=None, outbound_ips=None, public_network_access_enabled=None, resource_group_name=None, sku=None, tags=None, zone_redundancy_enabled=None):
        if api_key_enabled and not isinstance(api_key_enabled, bool):
            raise TypeError("Expected argument 'api_key_enabled' to be a bool")
        pulumi.set(__self__, "api_key_enabled", api_key_enabled)
        if auto_generated_domain_name_label_scope and not isinstance(auto_generated_domain_name_label_scope, str):
            raise TypeError("Expected argument 'auto_generated_domain_name_label_scope' to be a str")
        pulumi.set(__self__, "auto_generated_domain_name_label_scope", auto_generated_domain_name_label_scope)
        if azure_monitor_workspace_integrations and not isinstance(azure_monitor_workspace_integrations, list):
            raise TypeError("Expected argument 'azure_monitor_workspace_integrations' to be a list")
        pulumi.set(__self__, "azure_monitor_workspace_integrations", azure_monitor_workspace_integrations)
        if deterministic_outbound_ip_enabled and not isinstance(deterministic_outbound_ip_enabled, bool):
            raise TypeError("Expected argument 'deterministic_outbound_ip_enabled' to be a bool")
        pulumi.set(__self__, "deterministic_outbound_ip_enabled", deterministic_outbound_ip_enabled)
        if endpoint and not isinstance(endpoint, str):
            raise TypeError("Expected argument 'endpoint' to be a str")
        pulumi.set(__self__, "endpoint", endpoint)
        if grafana_major_version and not isinstance(grafana_major_version, str):
            raise TypeError("Expected argument 'grafana_major_version' to be a str")
        pulumi.set(__self__, "grafana_major_version", grafana_major_version)
        if grafana_version and not isinstance(grafana_version, str):
            raise TypeError("Expected argument 'grafana_version' to be a str")
        pulumi.set(__self__, "grafana_version", grafana_version)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identity and not isinstance(identity, dict):
            raise TypeError("Expected argument 'identity' to be a dict")
        pulumi.set(__self__, "identity", identity)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if outbound_ips and not isinstance(outbound_ips, list):
            raise TypeError("Expected argument 'outbound_ips' to be a list")
        pulumi.set(__self__, "outbound_ips", outbound_ips)
        if public_network_access_enabled and not isinstance(public_network_access_enabled, bool):
            raise TypeError("Expected argument 'public_network_access_enabled' to be a bool")
        pulumi.set(__self__, "public_network_access_enabled", public_network_access_enabled)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if sku and not isinstance(sku, str):
            raise TypeError("Expected argument 'sku' to be a str")
        pulumi.set(__self__, "sku", sku)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if zone_redundancy_enabled and not isinstance(zone_redundancy_enabled, bool):
            raise TypeError("Expected argument 'zone_redundancy_enabled' to be a bool")
        pulumi.set(__self__, "zone_redundancy_enabled", zone_redundancy_enabled)

    @property
    @pulumi.getter(name="apiKeyEnabled")
    def api_key_enabled(self) -> builtins.bool:
        """
        Whether the api key setting of the Grafana instance is enabled.
        """
        return pulumi.get(self, "api_key_enabled")

    @property
    @pulumi.getter(name="autoGeneratedDomainNameLabelScope")
    def auto_generated_domain_name_label_scope(self) -> builtins.str:
        """
        Scope for dns deterministic name hash calculation.
        """
        return pulumi.get(self, "auto_generated_domain_name_label_scope")

    @property
    @pulumi.getter(name="azureMonitorWorkspaceIntegrations")
    def azure_monitor_workspace_integrations(self) -> Sequence['outputs.GetGrafanaAzureMonitorWorkspaceIntegrationResult']:
        """
        Integrations for Azure Monitor Workspace.
        """
        return pulumi.get(self, "azure_monitor_workspace_integrations")

    @property
    @pulumi.getter(name="deterministicOutboundIpEnabled")
    def deterministic_outbound_ip_enabled(self) -> builtins.bool:
        """
        Whether the Grafana instance uses deterministic outbound IPs.
        """
        return pulumi.get(self, "deterministic_outbound_ip_enabled")

    @property
    @pulumi.getter
    def endpoint(self) -> builtins.str:
        """
        The endpoint of the Grafana instance.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter(name="grafanaMajorVersion")
    def grafana_major_version(self) -> builtins.str:
        """
        Major version of Grafana instance.
        """
        return pulumi.get(self, "grafana_major_version")

    @property
    @pulumi.getter(name="grafanaVersion")
    def grafana_version(self) -> builtins.str:
        """
        The full Grafana software semantic version deployed.
        """
        return pulumi.get(self, "grafana_version")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def identity(self) -> Optional['outputs.GetGrafanaIdentityResult']:
        """
        The managed identity of the grafana resource.
        """
        return pulumi.get(self, "identity")

    @property
    @pulumi.getter
    def location(self) -> builtins.str:
        """
        Azure location where the resource exists.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="outboundIps")
    def outbound_ips(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "outbound_ips")

    @property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> builtins.bool:
        """
        Whether or not public endpoint access is allowed for this server.
        """
        return pulumi.get(self, "public_network_access_enabled")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> builtins.str:
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter
    def sku(self) -> builtins.str:
        """
        The name of the SKU used for the Grafana instance.
        """
        return pulumi.get(self, "sku")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, builtins.str]:
        """
        A mapping of tags to assigned to the resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="zoneRedundancyEnabled")
    def zone_redundancy_enabled(self) -> builtins.bool:
        """
        The zone redundancy setting of the Grafana instance.
        """
        return pulumi.get(self, "zone_redundancy_enabled")


class AwaitableGetGrafanaResult(GetGrafanaResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetGrafanaResult(
            api_key_enabled=self.api_key_enabled,
            auto_generated_domain_name_label_scope=self.auto_generated_domain_name_label_scope,
            azure_monitor_workspace_integrations=self.azure_monitor_workspace_integrations,
            deterministic_outbound_ip_enabled=self.deterministic_outbound_ip_enabled,
            endpoint=self.endpoint,
            grafana_major_version=self.grafana_major_version,
            grafana_version=self.grafana_version,
            id=self.id,
            identity=self.identity,
            location=self.location,
            name=self.name,
            outbound_ips=self.outbound_ips,
            public_network_access_enabled=self.public_network_access_enabled,
            resource_group_name=self.resource_group_name,
            sku=self.sku,
            tags=self.tags,
            zone_redundancy_enabled=self.zone_redundancy_enabled)


def get_grafana(identity: Optional[Union['GetGrafanaIdentityArgs', 'GetGrafanaIdentityArgsDict']] = None,
                name: Optional[builtins.str] = None,
                resource_group_name: Optional[builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetGrafanaResult:
    """
    Use this data source to access information about an existing Grafana Dashboard.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.dashboard.get_grafana(name="example-grafana-dashboard",
        resource_group_name="example-rg")
    pulumi.export("name", example.name)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Dashboard`: 2023-09-01


    :param Union['GetGrafanaIdentityArgs', 'GetGrafanaIdentityArgsDict'] identity: The managed identity of the grafana resource.
    :param builtins.str name: Name of the grafana dashboard.
    :param builtins.str resource_group_name: Name of the resource group where resource belongs to.
    """
    __args__ = dict()
    __args__['identity'] = identity
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:dashboard/getGrafana:getGrafana', __args__, opts=opts, typ=GetGrafanaResult).value

    return AwaitableGetGrafanaResult(
        api_key_enabled=pulumi.get(__ret__, 'api_key_enabled'),
        auto_generated_domain_name_label_scope=pulumi.get(__ret__, 'auto_generated_domain_name_label_scope'),
        azure_monitor_workspace_integrations=pulumi.get(__ret__, 'azure_monitor_workspace_integrations'),
        deterministic_outbound_ip_enabled=pulumi.get(__ret__, 'deterministic_outbound_ip_enabled'),
        endpoint=pulumi.get(__ret__, 'endpoint'),
        grafana_major_version=pulumi.get(__ret__, 'grafana_major_version'),
        grafana_version=pulumi.get(__ret__, 'grafana_version'),
        id=pulumi.get(__ret__, 'id'),
        identity=pulumi.get(__ret__, 'identity'),
        location=pulumi.get(__ret__, 'location'),
        name=pulumi.get(__ret__, 'name'),
        outbound_ips=pulumi.get(__ret__, 'outbound_ips'),
        public_network_access_enabled=pulumi.get(__ret__, 'public_network_access_enabled'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'),
        sku=pulumi.get(__ret__, 'sku'),
        tags=pulumi.get(__ret__, 'tags'),
        zone_redundancy_enabled=pulumi.get(__ret__, 'zone_redundancy_enabled'))
def get_grafana_output(identity: Optional[pulumi.Input[Optional[Union['GetGrafanaIdentityArgs', 'GetGrafanaIdentityArgsDict']]]] = None,
                       name: Optional[pulumi.Input[builtins.str]] = None,
                       resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetGrafanaResult]:
    """
    Use this data source to access information about an existing Grafana Dashboard.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.dashboard.get_grafana(name="example-grafana-dashboard",
        resource_group_name="example-rg")
    pulumi.export("name", example.name)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Dashboard`: 2023-09-01


    :param Union['GetGrafanaIdentityArgs', 'GetGrafanaIdentityArgsDict'] identity: The managed identity of the grafana resource.
    :param builtins.str name: Name of the grafana dashboard.
    :param builtins.str resource_group_name: Name of the resource group where resource belongs to.
    """
    __args__ = dict()
    __args__['identity'] = identity
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:dashboard/getGrafana:getGrafana', __args__, opts=opts, typ=GetGrafanaResult)
    return __ret__.apply(lambda __response__: GetGrafanaResult(
        api_key_enabled=pulumi.get(__response__, 'api_key_enabled'),
        auto_generated_domain_name_label_scope=pulumi.get(__response__, 'auto_generated_domain_name_label_scope'),
        azure_monitor_workspace_integrations=pulumi.get(__response__, 'azure_monitor_workspace_integrations'),
        deterministic_outbound_ip_enabled=pulumi.get(__response__, 'deterministic_outbound_ip_enabled'),
        endpoint=pulumi.get(__response__, 'endpoint'),
        grafana_major_version=pulumi.get(__response__, 'grafana_major_version'),
        grafana_version=pulumi.get(__response__, 'grafana_version'),
        id=pulumi.get(__response__, 'id'),
        identity=pulumi.get(__response__, 'identity'),
        location=pulumi.get(__response__, 'location'),
        name=pulumi.get(__response__, 'name'),
        outbound_ips=pulumi.get(__response__, 'outbound_ips'),
        public_network_access_enabled=pulumi.get(__response__, 'public_network_access_enabled'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name'),
        sku=pulumi.get(__response__, 'sku'),
        tags=pulumi.get(__response__, 'tags'),
        zone_redundancy_enabled=pulumi.get(__response__, 'zone_redundancy_enabled')))
