# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GrafanaAzureMonitorWorkspaceIntegration',
    'GrafanaIdentity',
    'GrafanaSmtp',
    'GetGrafanaAzureMonitorWorkspaceIntegrationResult',
    'GetGrafanaIdentityResult',
]

@pulumi.output_type
class GrafanaAzureMonitorWorkspaceIntegration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceId":
            suggest = "resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GrafanaAzureMonitorWorkspaceIntegration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GrafanaAzureMonitorWorkspaceIntegration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GrafanaAzureMonitorWorkspaceIntegration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_id: builtins.str):
        """
        :param builtins.str resource_id: Specifies the resource ID of the connected Azure Monitor Workspace.
        """
        pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> builtins.str:
        """
        Specifies the resource ID of the connected Azure Monitor Workspace.
        """
        return pulumi.get(self, "resource_id")


@pulumi.output_type
class GrafanaIdentity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "identityIds":
            suggest = "identity_ids"
        elif key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GrafanaIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GrafanaIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GrafanaIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: builtins.str,
                 identity_ids: Optional[Sequence[builtins.str]] = None,
                 principal_id: Optional[builtins.str] = None,
                 tenant_id: Optional[builtins.str] = None):
        """
        :param builtins.str type: Specifies the type of Managed Service Identity. Possible values are `SystemAssigned`, `UserAssigned`. Changing this forces a new resource to be created.
        :param Sequence[builtins.str] identity_ids: Specifies the list of User Assigned Managed Service Identity IDs which should be assigned to this Dashboard Grafana. Changing this forces a new resource to be created.
        :param builtins.str principal_id: The Principal ID associated with this Managed Service Identity.
        :param builtins.str tenant_id: The Tenant ID associated with this Managed Service Identity.
        """
        pulumi.set(__self__, "type", type)
        if identity_ids is not None:
            pulumi.set(__self__, "identity_ids", identity_ids)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Specifies the type of Managed Service Identity. Possible values are `SystemAssigned`, `UserAssigned`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        Specifies the list of User Assigned Managed Service Identity IDs which should be assigned to this Dashboard Grafana. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "identity_ids")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[builtins.str]:
        """
        The Principal ID associated with this Managed Service Identity.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[builtins.str]:
        """
        The Tenant ID associated with this Managed Service Identity.
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class GrafanaSmtp(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fromAddress":
            suggest = "from_address"
        elif key == "startTlsPolicy":
            suggest = "start_tls_policy"
        elif key == "fromName":
            suggest = "from_name"
        elif key == "verificationSkipEnabled":
            suggest = "verification_skip_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GrafanaSmtp. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GrafanaSmtp.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GrafanaSmtp.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 from_address: builtins.str,
                 host: builtins.str,
                 password: builtins.str,
                 start_tls_policy: builtins.str,
                 user: builtins.str,
                 enabled: Optional[builtins.bool] = None,
                 from_name: Optional[builtins.str] = None,
                 verification_skip_enabled: Optional[builtins.bool] = None):
        """
        :param builtins.str from_address: Address used when sending emails.
        :param builtins.str host: SMTP server hostname with port, e.g. test.email.net:587
        :param builtins.str password: Password of SMTP authentication.
        :param builtins.str start_tls_policy: Whether to use TLS when connecting to SMTP server. Possible values are `OpportunisticStartTLS`, `NoStartTLS`, `MandatoryStartTLS`.
        :param builtins.str user: User of SMTP authentication.
        :param builtins.bool enabled: Whether to enable the smtp setting of the Grafana instance. Defaults to `false`.
        :param builtins.str from_name: Name used when sending emails. Defaults to `Azure Managed Grafana Notification`.
        :param builtins.bool verification_skip_enabled: Whether verify SSL for SMTP server. Defaults to `false`.
        """
        pulumi.set(__self__, "from_address", from_address)
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "start_tls_policy", start_tls_policy)
        pulumi.set(__self__, "user", user)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if from_name is not None:
            pulumi.set(__self__, "from_name", from_name)
        if verification_skip_enabled is not None:
            pulumi.set(__self__, "verification_skip_enabled", verification_skip_enabled)

    @property
    @pulumi.getter(name="fromAddress")
    def from_address(self) -> builtins.str:
        """
        Address used when sending emails.
        """
        return pulumi.get(self, "from_address")

    @property
    @pulumi.getter
    def host(self) -> builtins.str:
        """
        SMTP server hostname with port, e.g. test.email.net:587
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def password(self) -> builtins.str:
        """
        Password of SMTP authentication.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="startTlsPolicy")
    def start_tls_policy(self) -> builtins.str:
        """
        Whether to use TLS when connecting to SMTP server. Possible values are `OpportunisticStartTLS`, `NoStartTLS`, `MandatoryStartTLS`.
        """
        return pulumi.get(self, "start_tls_policy")

    @property
    @pulumi.getter
    def user(self) -> builtins.str:
        """
        User of SMTP authentication.
        """
        return pulumi.get(self, "user")

    @property
    @pulumi.getter
    def enabled(self) -> Optional[builtins.bool]:
        """
        Whether to enable the smtp setting of the Grafana instance. Defaults to `false`.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="fromName")
    def from_name(self) -> Optional[builtins.str]:
        """
        Name used when sending emails. Defaults to `Azure Managed Grafana Notification`.
        """
        return pulumi.get(self, "from_name")

    @property
    @pulumi.getter(name="verificationSkipEnabled")
    def verification_skip_enabled(self) -> Optional[builtins.bool]:
        """
        Whether verify SSL for SMTP server. Defaults to `false`.
        """
        return pulumi.get(self, "verification_skip_enabled")


@pulumi.output_type
class GetGrafanaAzureMonitorWorkspaceIntegrationResult(dict):
    def __init__(__self__, *,
                 resource_id: builtins.str):
        pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> builtins.str:
        return pulumi.get(self, "resource_id")


@pulumi.output_type
class GetGrafanaIdentityResult(dict):
    def __init__(__self__, *,
                 principal_id: builtins.str,
                 tenant_id: builtins.str,
                 type: builtins.str,
                 identity_ids: Optional[Sequence[builtins.str]] = None):
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        pulumi.set(__self__, "type", type)
        if identity_ids is not None:
            pulumi.set(__self__, "identity_ids", identity_ids)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> builtins.str:
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> builtins.str:
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Optional[Sequence[builtins.str]]:
        return pulumi.get(self, "identity_ids")


