# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'DeviceDeviceProperty',
    'GetDeviceDevicePropertyResult',
]

@pulumi.output_type
class DeviceDeviceProperty(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "configuredRoleTypes":
            suggest = "configured_role_types"
        elif key == "hcsVersion":
            suggest = "hcs_version"
        elif key == "nodeCount":
            suggest = "node_count"
        elif key == "serialNumber":
            suggest = "serial_number"
        elif key == "softwareVersion":
            suggest = "software_version"
        elif key == "timeZone":
            suggest = "time_zone"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeviceDeviceProperty. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeviceDeviceProperty.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeviceDeviceProperty.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 capacity: Optional[builtins.int] = None,
                 configured_role_types: Optional[Sequence[builtins.str]] = None,
                 culture: Optional[builtins.str] = None,
                 hcs_version: Optional[builtins.str] = None,
                 model: Optional[builtins.str] = None,
                 node_count: Optional[builtins.int] = None,
                 serial_number: Optional[builtins.str] = None,
                 software_version: Optional[builtins.str] = None,
                 status: Optional[builtins.str] = None,
                 time_zone: Optional[builtins.str] = None,
                 type: Optional[builtins.str] = None):
        """
        :param builtins.int capacity: The Data Box Edge/Gateway device local capacity in MB.
        :param Sequence[builtins.str] configured_role_types: Type of compute roles configured.
        :param builtins.str culture: The Data Box Edge/Gateway device culture.
        :param builtins.str hcs_version: The device software version number of the device (e.g. 1.2.18105.6).
        :param builtins.str model: The Data Box Edge/Gateway device model.
        :param builtins.int node_count: The number of nodes in the cluster.
        :param builtins.str serial_number: The Serial Number of Data Box Edge/Gateway device.
        :param builtins.str software_version: The Data Box Edge/Gateway device software version.
        :param builtins.str status: The status of the Data Box Edge/Gateway device.
        :param builtins.str time_zone: The Data Box Edge/Gateway device timezone.
        :param builtins.str type: The type of the Data Box Edge/Gateway device.
        """
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if configured_role_types is not None:
            pulumi.set(__self__, "configured_role_types", configured_role_types)
        if culture is not None:
            pulumi.set(__self__, "culture", culture)
        if hcs_version is not None:
            pulumi.set(__self__, "hcs_version", hcs_version)
        if model is not None:
            pulumi.set(__self__, "model", model)
        if node_count is not None:
            pulumi.set(__self__, "node_count", node_count)
        if serial_number is not None:
            pulumi.set(__self__, "serial_number", serial_number)
        if software_version is not None:
            pulumi.set(__self__, "software_version", software_version)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def capacity(self) -> Optional[builtins.int]:
        """
        The Data Box Edge/Gateway device local capacity in MB.
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter(name="configuredRoleTypes")
    def configured_role_types(self) -> Optional[Sequence[builtins.str]]:
        """
        Type of compute roles configured.
        """
        return pulumi.get(self, "configured_role_types")

    @property
    @pulumi.getter
    def culture(self) -> Optional[builtins.str]:
        """
        The Data Box Edge/Gateway device culture.
        """
        return pulumi.get(self, "culture")

    @property
    @pulumi.getter(name="hcsVersion")
    def hcs_version(self) -> Optional[builtins.str]:
        """
        The device software version number of the device (e.g. 1.2.18105.6).
        """
        return pulumi.get(self, "hcs_version")

    @property
    @pulumi.getter
    def model(self) -> Optional[builtins.str]:
        """
        The Data Box Edge/Gateway device model.
        """
        return pulumi.get(self, "model")

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> Optional[builtins.int]:
        """
        The number of nodes in the cluster.
        """
        return pulumi.get(self, "node_count")

    @property
    @pulumi.getter(name="serialNumber")
    def serial_number(self) -> Optional[builtins.str]:
        """
        The Serial Number of Data Box Edge/Gateway device.
        """
        return pulumi.get(self, "serial_number")

    @property
    @pulumi.getter(name="softwareVersion")
    def software_version(self) -> Optional[builtins.str]:
        """
        The Data Box Edge/Gateway device software version.
        """
        return pulumi.get(self, "software_version")

    @property
    @pulumi.getter
    def status(self) -> Optional[builtins.str]:
        """
        The status of the Data Box Edge/Gateway device.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[builtins.str]:
        """
        The Data Box Edge/Gateway device timezone.
        """
        return pulumi.get(self, "time_zone")

    @property
    @pulumi.getter
    def type(self) -> Optional[builtins.str]:
        """
        The type of the Data Box Edge/Gateway device.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetDeviceDevicePropertyResult(dict):
    def __init__(__self__, *,
                 capacity: builtins.int,
                 configured_role_types: Sequence[builtins.str],
                 culture: builtins.str,
                 hcs_version: builtins.str,
                 model: builtins.str,
                 node_count: builtins.int,
                 serial_number: builtins.str,
                 software_version: builtins.str,
                 status: builtins.str,
                 time_zone: builtins.str,
                 type: builtins.str):
        """
        :param builtins.int capacity: The Data Box Edge/Gateway device local capacity in MB.
        :param Sequence[builtins.str] configured_role_types: Type of compute roles configured.
        :param builtins.str culture: The Data Box Edge/Gateway device culture.
        :param builtins.str hcs_version: The device software version number of the device (e.g. 1.2.18105.6).
        :param builtins.str model: The Data Box Edge/Gateway device model.
        :param builtins.int node_count: The number of nodes in the cluster.
        :param builtins.str serial_number: The Serial Number of Data Box Edge/Gateway device.
        :param builtins.str software_version: The Data Box Edge/Gateway device software version.
        :param builtins.str status: The status of the Data Box Edge/Gateway device.
        :param builtins.str time_zone: The Data Box Edge/Gateway device timezone.
        :param builtins.str type: The type of the Data Box Edge/Gateway device.
        """
        pulumi.set(__self__, "capacity", capacity)
        pulumi.set(__self__, "configured_role_types", configured_role_types)
        pulumi.set(__self__, "culture", culture)
        pulumi.set(__self__, "hcs_version", hcs_version)
        pulumi.set(__self__, "model", model)
        pulumi.set(__self__, "node_count", node_count)
        pulumi.set(__self__, "serial_number", serial_number)
        pulumi.set(__self__, "software_version", software_version)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "time_zone", time_zone)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def capacity(self) -> builtins.int:
        """
        The Data Box Edge/Gateway device local capacity in MB.
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter(name="configuredRoleTypes")
    def configured_role_types(self) -> Sequence[builtins.str]:
        """
        Type of compute roles configured.
        """
        return pulumi.get(self, "configured_role_types")

    @property
    @pulumi.getter
    def culture(self) -> builtins.str:
        """
        The Data Box Edge/Gateway device culture.
        """
        return pulumi.get(self, "culture")

    @property
    @pulumi.getter(name="hcsVersion")
    def hcs_version(self) -> builtins.str:
        """
        The device software version number of the device (e.g. 1.2.18105.6).
        """
        return pulumi.get(self, "hcs_version")

    @property
    @pulumi.getter
    def model(self) -> builtins.str:
        """
        The Data Box Edge/Gateway device model.
        """
        return pulumi.get(self, "model")

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> builtins.int:
        """
        The number of nodes in the cluster.
        """
        return pulumi.get(self, "node_count")

    @property
    @pulumi.getter(name="serialNumber")
    def serial_number(self) -> builtins.str:
        """
        The Serial Number of Data Box Edge/Gateway device.
        """
        return pulumi.get(self, "serial_number")

    @property
    @pulumi.getter(name="softwareVersion")
    def software_version(self) -> builtins.str:
        """
        The Data Box Edge/Gateway device software version.
        """
        return pulumi.get(self, "software_version")

    @property
    @pulumi.getter
    def status(self) -> builtins.str:
        """
        The status of the Data Box Edge/Gateway device.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> builtins.str:
        """
        The Data Box Edge/Gateway device timezone.
        """
        return pulumi.get(self, "time_zone")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The type of the Data Box Edge/Gateway device.
        """
        return pulumi.get(self, "type")


