# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetWorkspaceResult',
    'AwaitableGetWorkspaceResult',
    'get_workspace',
    'get_workspace_output',
]

@pulumi.output_type
class GetWorkspaceResult:
    """
    A collection of values returned by getWorkspace.
    """
    def __init__(__self__, enhanced_security_compliances=None, id=None, location=None, managed_disk_identities=None, name=None, resource_group_name=None, sku=None, storage_account_identities=None, tags=None, workspace_id=None, workspace_url=None):
        if enhanced_security_compliances and not isinstance(enhanced_security_compliances, list):
            raise TypeError("Expected argument 'enhanced_security_compliances' to be a list")
        pulumi.set(__self__, "enhanced_security_compliances", enhanced_security_compliances)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if managed_disk_identities and not isinstance(managed_disk_identities, list):
            raise TypeError("Expected argument 'managed_disk_identities' to be a list")
        pulumi.set(__self__, "managed_disk_identities", managed_disk_identities)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if sku and not isinstance(sku, str):
            raise TypeError("Expected argument 'sku' to be a str")
        pulumi.set(__self__, "sku", sku)
        if storage_account_identities and not isinstance(storage_account_identities, list):
            raise TypeError("Expected argument 'storage_account_identities' to be a list")
        pulumi.set(__self__, "storage_account_identities", storage_account_identities)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if workspace_id and not isinstance(workspace_id, str):
            raise TypeError("Expected argument 'workspace_id' to be a str")
        pulumi.set(__self__, "workspace_id", workspace_id)
        if workspace_url and not isinstance(workspace_url, str):
            raise TypeError("Expected argument 'workspace_url' to be a str")
        pulumi.set(__self__, "workspace_url", workspace_url)

    @property
    @pulumi.getter(name="enhancedSecurityCompliances")
    def enhanced_security_compliances(self) -> Sequence['outputs.GetWorkspaceEnhancedSecurityComplianceResult']:
        """
        An `enhanced_security_compliance` block as documented below.
        """
        return pulumi.get(self, "enhanced_security_compliances")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def location(self) -> builtins.str:
        """
        The Azure location where the Databricks Workspace exists.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="managedDiskIdentities")
    def managed_disk_identities(self) -> Sequence['outputs.GetWorkspaceManagedDiskIdentityResult']:
        """
        A `managed_disk_identity` block as documented below.
        """
        return pulumi.get(self, "managed_disk_identities")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> builtins.str:
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter
    def sku(self) -> builtins.str:
        """
        SKU of this Databricks Workspace.
        """
        return pulumi.get(self, "sku")

    @property
    @pulumi.getter(name="storageAccountIdentities")
    def storage_account_identities(self) -> Sequence['outputs.GetWorkspaceStorageAccountIdentityResult']:
        """
        A `storage_account_identity` block as documented below.
        """
        return pulumi.get(self, "storage_account_identities")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, builtins.str]]:
        """
        A mapping of tags to assign to the Databricks Workspace.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> builtins.str:
        """
        Unique ID of this Databricks Workspace in Databricks management plane.
        """
        return pulumi.get(self, "workspace_id")

    @property
    @pulumi.getter(name="workspaceUrl")
    def workspace_url(self) -> builtins.str:
        """
        URL this Databricks Workspace is accessible on.
        """
        return pulumi.get(self, "workspace_url")


class AwaitableGetWorkspaceResult(GetWorkspaceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetWorkspaceResult(
            enhanced_security_compliances=self.enhanced_security_compliances,
            id=self.id,
            location=self.location,
            managed_disk_identities=self.managed_disk_identities,
            name=self.name,
            resource_group_name=self.resource_group_name,
            sku=self.sku,
            storage_account_identities=self.storage_account_identities,
            tags=self.tags,
            workspace_id=self.workspace_id,
            workspace_url=self.workspace_url)


def get_workspace(name: Optional[builtins.str] = None,
                  resource_group_name: Optional[builtins.str] = None,
                  tags: Optional[Mapping[str, builtins.str]] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetWorkspaceResult:
    """
    Use this data source to access information about an existing Databricks workspace.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.databricks.get_workspace(name="example-workspace",
        resource_group_name="example-rg")
    pulumi.export("databricksWorkspaceId", example.workspace_id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Databricks`: 2024-05-01


    :param builtins.str name: The name of the Databricks Workspace.
    :param builtins.str resource_group_name: The Name of the Resource Group where the Databricks Workspace exists.
    :param Mapping[str, builtins.str] tags: A mapping of tags to assign to the Databricks Workspace.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:databricks/getWorkspace:getWorkspace', __args__, opts=opts, typ=GetWorkspaceResult).value

    return AwaitableGetWorkspaceResult(
        enhanced_security_compliances=pulumi.get(__ret__, 'enhanced_security_compliances'),
        id=pulumi.get(__ret__, 'id'),
        location=pulumi.get(__ret__, 'location'),
        managed_disk_identities=pulumi.get(__ret__, 'managed_disk_identities'),
        name=pulumi.get(__ret__, 'name'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'),
        sku=pulumi.get(__ret__, 'sku'),
        storage_account_identities=pulumi.get(__ret__, 'storage_account_identities'),
        tags=pulumi.get(__ret__, 'tags'),
        workspace_id=pulumi.get(__ret__, 'workspace_id'),
        workspace_url=pulumi.get(__ret__, 'workspace_url'))
def get_workspace_output(name: Optional[pulumi.Input[builtins.str]] = None,
                         resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                         tags: Optional[pulumi.Input[Optional[Mapping[str, builtins.str]]]] = None,
                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetWorkspaceResult]:
    """
    Use this data source to access information about an existing Databricks workspace.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.databricks.get_workspace(name="example-workspace",
        resource_group_name="example-rg")
    pulumi.export("databricksWorkspaceId", example.workspace_id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Databricks`: 2024-05-01


    :param builtins.str name: The name of the Databricks Workspace.
    :param builtins.str resource_group_name: The Name of the Resource Group where the Databricks Workspace exists.
    :param Mapping[str, builtins.str] tags: A mapping of tags to assign to the Databricks Workspace.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    __args__['tags'] = tags
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:databricks/getWorkspace:getWorkspace', __args__, opts=opts, typ=GetWorkspaceResult)
    return __ret__.apply(lambda __response__: GetWorkspaceResult(
        enhanced_security_compliances=pulumi.get(__response__, 'enhanced_security_compliances'),
        id=pulumi.get(__response__, 'id'),
        location=pulumi.get(__response__, 'location'),
        managed_disk_identities=pulumi.get(__response__, 'managed_disk_identities'),
        name=pulumi.get(__response__, 'name'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name'),
        sku=pulumi.get(__response__, 'sku'),
        storage_account_identities=pulumi.get(__response__, 'storage_account_identities'),
        tags=pulumi.get(__response__, 'tags'),
        workspace_id=pulumi.get(__response__, 'workspace_id'),
        workspace_url=pulumi.get(__response__, 'workspace_url')))
