# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'AccessConnectorIdentity',
    'WorkspaceCustomParameters',
    'WorkspaceEnhancedSecurityCompliance',
    'WorkspaceManagedDiskIdentity',
    'WorkspaceStorageAccountIdentity',
    'GetAccessConnectorIdentityResult',
    'GetWorkspaceEnhancedSecurityComplianceResult',
    'GetWorkspaceManagedDiskIdentityResult',
    'GetWorkspacePrivateEndpointConnectionConnectionResult',
    'GetWorkspaceStorageAccountIdentityResult',
]

@pulumi.output_type
class AccessConnectorIdentity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "identityIds":
            suggest = "identity_ids"
        elif key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccessConnectorIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccessConnectorIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccessConnectorIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: builtins.str,
                 identity_ids: Optional[Sequence[builtins.str]] = None,
                 principal_id: Optional[builtins.str] = None,
                 tenant_id: Optional[builtins.str] = None):
        """
        :param builtins.str type: Specifies the type of Managed Service Identity that should be configured on the Databricks Access Connector. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned`.
        :param Sequence[builtins.str] identity_ids: Specifies a list of User Assigned Managed Identity IDs to be assigned to the Databricks Access Connector. Only one User Assigned Managed Identity ID is supported per Databricks Access Connector resource.
               
               > **Note:** `identity_ids` are required when `type` is set to `UserAssigned`.
        :param builtins.str principal_id: The Principal ID of the System Assigned Managed Service Identity that is configured on this Access Connector.
        :param builtins.str tenant_id: The Tenant ID of the System Assigned Managed Service Identity that is configured on this Access Connector.
        """
        pulumi.set(__self__, "type", type)
        if identity_ids is not None:
            pulumi.set(__self__, "identity_ids", identity_ids)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Specifies the type of Managed Service Identity that should be configured on the Databricks Access Connector. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        Specifies a list of User Assigned Managed Identity IDs to be assigned to the Databricks Access Connector. Only one User Assigned Managed Identity ID is supported per Databricks Access Connector resource.

        > **Note:** `identity_ids` are required when `type` is set to `UserAssigned`.
        """
        return pulumi.get(self, "identity_ids")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[builtins.str]:
        """
        The Principal ID of the System Assigned Managed Service Identity that is configured on this Access Connector.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[builtins.str]:
        """
        The Tenant ID of the System Assigned Managed Service Identity that is configured on this Access Connector.
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class WorkspaceCustomParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "machineLearningWorkspaceId":
            suggest = "machine_learning_workspace_id"
        elif key == "natGatewayName":
            suggest = "nat_gateway_name"
        elif key == "noPublicIp":
            suggest = "no_public_ip"
        elif key == "privateSubnetName":
            suggest = "private_subnet_name"
        elif key == "privateSubnetNetworkSecurityGroupAssociationId":
            suggest = "private_subnet_network_security_group_association_id"
        elif key == "publicIpName":
            suggest = "public_ip_name"
        elif key == "publicSubnetName":
            suggest = "public_subnet_name"
        elif key == "publicSubnetNetworkSecurityGroupAssociationId":
            suggest = "public_subnet_network_security_group_association_id"
        elif key == "storageAccountName":
            suggest = "storage_account_name"
        elif key == "storageAccountSkuName":
            suggest = "storage_account_sku_name"
        elif key == "virtualNetworkId":
            suggest = "virtual_network_id"
        elif key == "vnetAddressPrefix":
            suggest = "vnet_address_prefix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkspaceCustomParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkspaceCustomParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkspaceCustomParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 machine_learning_workspace_id: Optional[builtins.str] = None,
                 nat_gateway_name: Optional[builtins.str] = None,
                 no_public_ip: Optional[builtins.bool] = None,
                 private_subnet_name: Optional[builtins.str] = None,
                 private_subnet_network_security_group_association_id: Optional[builtins.str] = None,
                 public_ip_name: Optional[builtins.str] = None,
                 public_subnet_name: Optional[builtins.str] = None,
                 public_subnet_network_security_group_association_id: Optional[builtins.str] = None,
                 storage_account_name: Optional[builtins.str] = None,
                 storage_account_sku_name: Optional[builtins.str] = None,
                 virtual_network_id: Optional[builtins.str] = None,
                 vnet_address_prefix: Optional[builtins.str] = None):
        """
        :param builtins.str machine_learning_workspace_id: The ID of a Azure Machine Learning workspace to link with Databricks workspace. Changing this forces a new resource to be created.
        :param builtins.str nat_gateway_name: Name of the NAT gateway for Secure Cluster Connectivity (No Public IP) workspace subnets (only for workspace with managed virtual network). Defaults to `nat-gateway`. Changing this forces a new resource to be created.
        :param builtins.bool no_public_ip: Are public IP Addresses not allowed? Possible values are `true` or `false`. Defaults to `true`.
               
               > **Note:** Updating `no_public_ip` parameter is only allowed if the value is changing from `false` to `true` and only for VNet-injected workspaces.
               
               > **Note:** In `v3.104.0` and higher of the provider the `no_public_ip` parameter will now default to `true` instead of `false`.
        :param builtins.str private_subnet_name: The name of the Private Subnet within the Virtual Network. Required if `virtual_network_id` is set. Changing this forces a new resource to be created.
        :param builtins.str private_subnet_network_security_group_association_id: The resource ID of the `network.SubnetNetworkSecurityGroupAssociation` resource which is referred to by the `private_subnet_name` field. This is the same as the ID of the subnet referred to by the `private_subnet_name` field. Required if `virtual_network_id` is set.
        :param builtins.str public_ip_name: Name of the Public IP for No Public IP workspace with managed virtual network. Defaults to `nat-gw-public-ip`. Changing this forces a new resource to be created.
        :param builtins.str public_subnet_name: The name of the Public Subnet within the Virtual Network. Required if `virtual_network_id` is set. Changing this forces a new resource to be created.
        :param builtins.str public_subnet_network_security_group_association_id: The resource ID of the `network.SubnetNetworkSecurityGroupAssociation` resource which is referred to by the `public_subnet_name` field. This is the same as the ID of the subnet referred to by the `public_subnet_name` field. Required if `virtual_network_id` is set.
        :param builtins.str storage_account_name: Default Databricks File Storage account name. Defaults to a randomized name(e.g. `dbstoragel6mfeghoe5kxu`). Changing this forces a new resource to be created.
        :param builtins.str storage_account_sku_name: Storage account SKU name. Possible values include `Standard_LRS`, `Standard_GRS`, `Standard_RAGRS`, `Standard_GZRS`, `Standard_RAGZRS`, `Standard_ZRS`, `Premium_LRS` or `Premium_ZRS`. Defaults to `Standard_GRS`.
        :param builtins.str virtual_network_id: The ID of a Virtual Network where this Databricks Cluster should be created. Changing this forces a new resource to be created.
        :param builtins.str vnet_address_prefix: Address prefix for Managed virtual network. Defaults to `10.139`. Changing this forces a new resource to be created.
               
               > **Note:** Databricks requires that a network security group is associated with the `public` and `private` subnets when a `virtual_network_id` has been defined. Both `public` and `private` subnets must be delegated to `Microsoft.Databricks/workspaces`. For more information about subnet delegation see the [product documentation](https://docs.microsoft.com/azure/virtual-network/subnet-delegation-overview).
        """
        if machine_learning_workspace_id is not None:
            pulumi.set(__self__, "machine_learning_workspace_id", machine_learning_workspace_id)
        if nat_gateway_name is not None:
            pulumi.set(__self__, "nat_gateway_name", nat_gateway_name)
        if no_public_ip is not None:
            pulumi.set(__self__, "no_public_ip", no_public_ip)
        if private_subnet_name is not None:
            pulumi.set(__self__, "private_subnet_name", private_subnet_name)
        if private_subnet_network_security_group_association_id is not None:
            pulumi.set(__self__, "private_subnet_network_security_group_association_id", private_subnet_network_security_group_association_id)
        if public_ip_name is not None:
            pulumi.set(__self__, "public_ip_name", public_ip_name)
        if public_subnet_name is not None:
            pulumi.set(__self__, "public_subnet_name", public_subnet_name)
        if public_subnet_network_security_group_association_id is not None:
            pulumi.set(__self__, "public_subnet_network_security_group_association_id", public_subnet_network_security_group_association_id)
        if storage_account_name is not None:
            pulumi.set(__self__, "storage_account_name", storage_account_name)
        if storage_account_sku_name is not None:
            pulumi.set(__self__, "storage_account_sku_name", storage_account_sku_name)
        if virtual_network_id is not None:
            pulumi.set(__self__, "virtual_network_id", virtual_network_id)
        if vnet_address_prefix is not None:
            pulumi.set(__self__, "vnet_address_prefix", vnet_address_prefix)

    @property
    @pulumi.getter(name="machineLearningWorkspaceId")
    def machine_learning_workspace_id(self) -> Optional[builtins.str]:
        """
        The ID of a Azure Machine Learning workspace to link with Databricks workspace. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "machine_learning_workspace_id")

    @property
    @pulumi.getter(name="natGatewayName")
    def nat_gateway_name(self) -> Optional[builtins.str]:
        """
        Name of the NAT gateway for Secure Cluster Connectivity (No Public IP) workspace subnets (only for workspace with managed virtual network). Defaults to `nat-gateway`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "nat_gateway_name")

    @property
    @pulumi.getter(name="noPublicIp")
    def no_public_ip(self) -> Optional[builtins.bool]:
        """
        Are public IP Addresses not allowed? Possible values are `true` or `false`. Defaults to `true`.

        > **Note:** Updating `no_public_ip` parameter is only allowed if the value is changing from `false` to `true` and only for VNet-injected workspaces.

        > **Note:** In `v3.104.0` and higher of the provider the `no_public_ip` parameter will now default to `true` instead of `false`.
        """
        return pulumi.get(self, "no_public_ip")

    @property
    @pulumi.getter(name="privateSubnetName")
    def private_subnet_name(self) -> Optional[builtins.str]:
        """
        The name of the Private Subnet within the Virtual Network. Required if `virtual_network_id` is set. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "private_subnet_name")

    @property
    @pulumi.getter(name="privateSubnetNetworkSecurityGroupAssociationId")
    def private_subnet_network_security_group_association_id(self) -> Optional[builtins.str]:
        """
        The resource ID of the `network.SubnetNetworkSecurityGroupAssociation` resource which is referred to by the `private_subnet_name` field. This is the same as the ID of the subnet referred to by the `private_subnet_name` field. Required if `virtual_network_id` is set.
        """
        return pulumi.get(self, "private_subnet_network_security_group_association_id")

    @property
    @pulumi.getter(name="publicIpName")
    def public_ip_name(self) -> Optional[builtins.str]:
        """
        Name of the Public IP for No Public IP workspace with managed virtual network. Defaults to `nat-gw-public-ip`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "public_ip_name")

    @property
    @pulumi.getter(name="publicSubnetName")
    def public_subnet_name(self) -> Optional[builtins.str]:
        """
        The name of the Public Subnet within the Virtual Network. Required if `virtual_network_id` is set. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "public_subnet_name")

    @property
    @pulumi.getter(name="publicSubnetNetworkSecurityGroupAssociationId")
    def public_subnet_network_security_group_association_id(self) -> Optional[builtins.str]:
        """
        The resource ID of the `network.SubnetNetworkSecurityGroupAssociation` resource which is referred to by the `public_subnet_name` field. This is the same as the ID of the subnet referred to by the `public_subnet_name` field. Required if `virtual_network_id` is set.
        """
        return pulumi.get(self, "public_subnet_network_security_group_association_id")

    @property
    @pulumi.getter(name="storageAccountName")
    def storage_account_name(self) -> Optional[builtins.str]:
        """
        Default Databricks File Storage account name. Defaults to a randomized name(e.g. `dbstoragel6mfeghoe5kxu`). Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "storage_account_name")

    @property
    @pulumi.getter(name="storageAccountSkuName")
    def storage_account_sku_name(self) -> Optional[builtins.str]:
        """
        Storage account SKU name. Possible values include `Standard_LRS`, `Standard_GRS`, `Standard_RAGRS`, `Standard_GZRS`, `Standard_RAGZRS`, `Standard_ZRS`, `Premium_LRS` or `Premium_ZRS`. Defaults to `Standard_GRS`.
        """
        return pulumi.get(self, "storage_account_sku_name")

    @property
    @pulumi.getter(name="virtualNetworkId")
    def virtual_network_id(self) -> Optional[builtins.str]:
        """
        The ID of a Virtual Network where this Databricks Cluster should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "virtual_network_id")

    @property
    @pulumi.getter(name="vnetAddressPrefix")
    def vnet_address_prefix(self) -> Optional[builtins.str]:
        """
        Address prefix for Managed virtual network. Defaults to `10.139`. Changing this forces a new resource to be created.

        > **Note:** Databricks requires that a network security group is associated with the `public` and `private` subnets when a `virtual_network_id` has been defined. Both `public` and `private` subnets must be delegated to `Microsoft.Databricks/workspaces`. For more information about subnet delegation see the [product documentation](https://docs.microsoft.com/azure/virtual-network/subnet-delegation-overview).
        """
        return pulumi.get(self, "vnet_address_prefix")


@pulumi.output_type
class WorkspaceEnhancedSecurityCompliance(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "automaticClusterUpdateEnabled":
            suggest = "automatic_cluster_update_enabled"
        elif key == "complianceSecurityProfileEnabled":
            suggest = "compliance_security_profile_enabled"
        elif key == "complianceSecurityProfileStandards":
            suggest = "compliance_security_profile_standards"
        elif key == "enhancedSecurityMonitoringEnabled":
            suggest = "enhanced_security_monitoring_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkspaceEnhancedSecurityCompliance. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkspaceEnhancedSecurityCompliance.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkspaceEnhancedSecurityCompliance.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 automatic_cluster_update_enabled: Optional[builtins.bool] = None,
                 compliance_security_profile_enabled: Optional[builtins.bool] = None,
                 compliance_security_profile_standards: Optional[Sequence[builtins.str]] = None,
                 enhanced_security_monitoring_enabled: Optional[builtins.bool] = None):
        """
        :param builtins.bool automatic_cluster_update_enabled: Enables automatic cluster updates for this workspace. Defaults to `false`.
        :param builtins.bool compliance_security_profile_enabled: Enables compliance security profile for this workspace. Defaults to `false`.
               
               > **Note:** Changing the value of `compliance_security_profile_enabled` from `true` to `false` forces a replacement of the Databricks workspace.
               
               > **Note:** The attributes `automatic_cluster_update_enabled` and `enhanced_security_monitoring_enabled` must be set to `true` in order to set `compliance_security_profile_enabled` to `true`.
        :param Sequence[builtins.str] compliance_security_profile_standards: A list of standards to enforce on this workspace. Possible values include `HIPAA` and `PCI_DSS`.
               
               > **Note:** `compliance_security_profile_enabled` must be set to `true` in order to use `compliance_security_profile_standards`.
               
               > **Note:** Removing a standard from the `compliance_security_profile_standards` list forces a replacement of the Databricks workspace.
        :param builtins.bool enhanced_security_monitoring_enabled: Enables enhanced security monitoring for this workspace. Defaults to `false`.
        """
        if automatic_cluster_update_enabled is not None:
            pulumi.set(__self__, "automatic_cluster_update_enabled", automatic_cluster_update_enabled)
        if compliance_security_profile_enabled is not None:
            pulumi.set(__self__, "compliance_security_profile_enabled", compliance_security_profile_enabled)
        if compliance_security_profile_standards is not None:
            pulumi.set(__self__, "compliance_security_profile_standards", compliance_security_profile_standards)
        if enhanced_security_monitoring_enabled is not None:
            pulumi.set(__self__, "enhanced_security_monitoring_enabled", enhanced_security_monitoring_enabled)

    @property
    @pulumi.getter(name="automaticClusterUpdateEnabled")
    def automatic_cluster_update_enabled(self) -> Optional[builtins.bool]:
        """
        Enables automatic cluster updates for this workspace. Defaults to `false`.
        """
        return pulumi.get(self, "automatic_cluster_update_enabled")

    @property
    @pulumi.getter(name="complianceSecurityProfileEnabled")
    def compliance_security_profile_enabled(self) -> Optional[builtins.bool]:
        """
        Enables compliance security profile for this workspace. Defaults to `false`.

        > **Note:** Changing the value of `compliance_security_profile_enabled` from `true` to `false` forces a replacement of the Databricks workspace.

        > **Note:** The attributes `automatic_cluster_update_enabled` and `enhanced_security_monitoring_enabled` must be set to `true` in order to set `compliance_security_profile_enabled` to `true`.
        """
        return pulumi.get(self, "compliance_security_profile_enabled")

    @property
    @pulumi.getter(name="complianceSecurityProfileStandards")
    def compliance_security_profile_standards(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of standards to enforce on this workspace. Possible values include `HIPAA` and `PCI_DSS`.

        > **Note:** `compliance_security_profile_enabled` must be set to `true` in order to use `compliance_security_profile_standards`.

        > **Note:** Removing a standard from the `compliance_security_profile_standards` list forces a replacement of the Databricks workspace.
        """
        return pulumi.get(self, "compliance_security_profile_standards")

    @property
    @pulumi.getter(name="enhancedSecurityMonitoringEnabled")
    def enhanced_security_monitoring_enabled(self) -> Optional[builtins.bool]:
        """
        Enables enhanced security monitoring for this workspace. Defaults to `false`.
        """
        return pulumi.get(self, "enhanced_security_monitoring_enabled")


@pulumi.output_type
class WorkspaceManagedDiskIdentity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkspaceManagedDiskIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkspaceManagedDiskIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkspaceManagedDiskIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 principal_id: Optional[builtins.str] = None,
                 tenant_id: Optional[builtins.str] = None,
                 type: Optional[builtins.str] = None):
        """
        :param builtins.str principal_id: The principal UUID for the internal databricks storage account needed to provide access to the workspace for enabling Customer Managed Keys.
        :param builtins.str tenant_id: The UUID of the tenant where the internal databricks storage account was created.
        :param builtins.str type: The type of the internal databricks storage account.
        """
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[builtins.str]:
        """
        The principal UUID for the internal databricks storage account needed to provide access to the workspace for enabling Customer Managed Keys.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[builtins.str]:
        """
        The UUID of the tenant where the internal databricks storage account was created.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> Optional[builtins.str]:
        """
        The type of the internal databricks storage account.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class WorkspaceStorageAccountIdentity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkspaceStorageAccountIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkspaceStorageAccountIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkspaceStorageAccountIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 principal_id: Optional[builtins.str] = None,
                 tenant_id: Optional[builtins.str] = None,
                 type: Optional[builtins.str] = None):
        """
        :param builtins.str principal_id: The principal UUID for the internal databricks storage account needed to provide access to the workspace for enabling Customer Managed Keys.
        :param builtins.str tenant_id: The UUID of the tenant where the internal databricks storage account was created.
        :param builtins.str type: The type of the internal databricks storage account.
        """
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[builtins.str]:
        """
        The principal UUID for the internal databricks storage account needed to provide access to the workspace for enabling Customer Managed Keys.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[builtins.str]:
        """
        The UUID of the tenant where the internal databricks storage account was created.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> Optional[builtins.str]:
        """
        The type of the internal databricks storage account.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetAccessConnectorIdentityResult(dict):
    def __init__(__self__, *,
                 identity_ids: Sequence[builtins.str],
                 principal_id: builtins.str,
                 tenant_id: builtins.str,
                 type: builtins.str):
        """
        :param Sequence[builtins.str] identity_ids: The list of User Assigned Managed Identity IDs assigned to this Access Connector.
        :param builtins.str principal_id: The Principal ID of the System Assigned Managed Service Identity that is configured on this Access Connector.
        :param builtins.str tenant_id: The Tenant ID of the System Assigned Managed Service Identity that is configured on this Access Connector.
        :param builtins.str type: The type of Managed Service Identity that is configured on this Access Connector.
        """
        pulumi.set(__self__, "identity_ids", identity_ids)
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Sequence[builtins.str]:
        """
        The list of User Assigned Managed Identity IDs assigned to this Access Connector.
        """
        return pulumi.get(self, "identity_ids")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> builtins.str:
        """
        The Principal ID of the System Assigned Managed Service Identity that is configured on this Access Connector.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> builtins.str:
        """
        The Tenant ID of the System Assigned Managed Service Identity that is configured on this Access Connector.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The type of Managed Service Identity that is configured on this Access Connector.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetWorkspaceEnhancedSecurityComplianceResult(dict):
    def __init__(__self__, *,
                 automatic_cluster_update_enabled: builtins.bool,
                 compliance_security_profile_enabled: builtins.bool,
                 compliance_security_profile_standards: Sequence[builtins.str],
                 enhanced_security_monitoring_enabled: builtins.bool):
        """
        :param builtins.bool automatic_cluster_update_enabled: Whether automatic cluster updates for this workspace is enabled.
        :param builtins.bool compliance_security_profile_enabled: Whether compliance security profile for this workspace is enabled.
        :param Sequence[builtins.str] compliance_security_profile_standards: A list of standards enforced on this workspace.
        :param builtins.bool enhanced_security_monitoring_enabled: Whether enhanced security monitoring for this workspace is enabled.
        """
        pulumi.set(__self__, "automatic_cluster_update_enabled", automatic_cluster_update_enabled)
        pulumi.set(__self__, "compliance_security_profile_enabled", compliance_security_profile_enabled)
        pulumi.set(__self__, "compliance_security_profile_standards", compliance_security_profile_standards)
        pulumi.set(__self__, "enhanced_security_monitoring_enabled", enhanced_security_monitoring_enabled)

    @property
    @pulumi.getter(name="automaticClusterUpdateEnabled")
    def automatic_cluster_update_enabled(self) -> builtins.bool:
        """
        Whether automatic cluster updates for this workspace is enabled.
        """
        return pulumi.get(self, "automatic_cluster_update_enabled")

    @property
    @pulumi.getter(name="complianceSecurityProfileEnabled")
    def compliance_security_profile_enabled(self) -> builtins.bool:
        """
        Whether compliance security profile for this workspace is enabled.
        """
        return pulumi.get(self, "compliance_security_profile_enabled")

    @property
    @pulumi.getter(name="complianceSecurityProfileStandards")
    def compliance_security_profile_standards(self) -> Sequence[builtins.str]:
        """
        A list of standards enforced on this workspace.
        """
        return pulumi.get(self, "compliance_security_profile_standards")

    @property
    @pulumi.getter(name="enhancedSecurityMonitoringEnabled")
    def enhanced_security_monitoring_enabled(self) -> builtins.bool:
        """
        Whether enhanced security monitoring for this workspace is enabled.
        """
        return pulumi.get(self, "enhanced_security_monitoring_enabled")


@pulumi.output_type
class GetWorkspaceManagedDiskIdentityResult(dict):
    def __init__(__self__, *,
                 principal_id: builtins.str,
                 tenant_id: builtins.str,
                 type: builtins.str):
        """
        :param builtins.str principal_id: The principal UUID for the internal databricks storage account needed to provide access to the workspace for enabling Customer Managed Keys.
        :param builtins.str tenant_id: The UUID of the tenant where the internal databricks storage account was created.
        :param builtins.str type: The type of the internal databricks storage account.
        """
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> builtins.str:
        """
        The principal UUID for the internal databricks storage account needed to provide access to the workspace for enabling Customer Managed Keys.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> builtins.str:
        """
        The UUID of the tenant where the internal databricks storage account was created.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The type of the internal databricks storage account.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetWorkspacePrivateEndpointConnectionConnectionResult(dict):
    def __init__(__self__, *,
                 action_required: builtins.str,
                 description: builtins.str,
                 name: builtins.str,
                 status: builtins.str,
                 workspace_private_endpoint_id: builtins.str):
        """
        :param builtins.str action_required: Actions required for a private endpoint connection.
        :param builtins.str description: The description for the current state of a private endpoint connection.
        :param builtins.str name: The name of the Databricks Workspace.
        :param builtins.str status: The status of a private endpoint connection. Possible values are `Pending`, `Approved`, `Rejected` or `Disconnected`.
        :param builtins.str workspace_private_endpoint_id: The Databricks Workspace resource ID for the private link endpoint.
        """
        pulumi.set(__self__, "action_required", action_required)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "workspace_private_endpoint_id", workspace_private_endpoint_id)

    @property
    @pulumi.getter(name="actionRequired")
    def action_required(self) -> builtins.str:
        """
        Actions required for a private endpoint connection.
        """
        return pulumi.get(self, "action_required")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        The description for the current state of a private endpoint connection.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the Databricks Workspace.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def status(self) -> builtins.str:
        """
        The status of a private endpoint connection. Possible values are `Pending`, `Approved`, `Rejected` or `Disconnected`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="workspacePrivateEndpointId")
    def workspace_private_endpoint_id(self) -> builtins.str:
        """
        The Databricks Workspace resource ID for the private link endpoint.
        """
        return pulumi.get(self, "workspace_private_endpoint_id")


@pulumi.output_type
class GetWorkspaceStorageAccountIdentityResult(dict):
    def __init__(__self__, *,
                 principal_id: builtins.str,
                 tenant_id: builtins.str,
                 type: builtins.str):
        """
        :param builtins.str principal_id: The principal UUID for the internal databricks storage account needed to provide access to the workspace for enabling Customer Managed Keys.
        :param builtins.str tenant_id: The UUID of the tenant where the internal databricks storage account was created.
        :param builtins.str type: The type of the internal databricks storage account.
        """
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> builtins.str:
        """
        The principal UUID for the internal databricks storage account needed to provide access to the workspace for enabling Customer Managed Keys.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> builtins.str:
        """
        The UUID of the tenant where the internal databricks storage account was created.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The type of the internal databricks storage account.
        """
        return pulumi.get(self, "type")


