# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'MonitorDatadogOrganizationArgs',
    'MonitorDatadogOrganizationArgsDict',
    'MonitorIdentityArgs',
    'MonitorIdentityArgsDict',
    'MonitorTagRuleLogArgs',
    'MonitorTagRuleLogArgsDict',
    'MonitorTagRuleLogFilterArgs',
    'MonitorTagRuleLogFilterArgsDict',
    'MonitorTagRuleMetricArgs',
    'MonitorTagRuleMetricArgsDict',
    'MonitorTagRuleMetricFilterArgs',
    'MonitorTagRuleMetricFilterArgsDict',
    'MonitorUserArgs',
    'MonitorUserArgsDict',
]

MYPY = False

if not MYPY:
    class MonitorDatadogOrganizationArgsDict(TypedDict):
        api_key: pulumi.Input[builtins.str]
        """
        Api key associated to the Datadog organization. Changing this forces a new Datadog Monitor to be created.
        """
        application_key: pulumi.Input[builtins.str]
        """
        Application key associated to the Datadog organization. Changing this forces a new Datadog Monitor to be created.
        """
        enterprise_app_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The ID of the enterprise_app. Changing this forces a new resource to be created.
        """
        id: NotRequired[pulumi.Input[builtins.str]]
        """
        The ID of the Datadog Monitor.
        """
        linking_auth_code: NotRequired[pulumi.Input[builtins.str]]
        """
        The auth code used to linking to an existing Datadog organization. Changing this forces a new Datadog Monitor to be created.
        """
        linking_client_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The ID of the linking_client. Changing this forces a new Datadog Monitor to be created.
        """
        name: NotRequired[pulumi.Input[builtins.str]]
        """
        The name of the user that will be associated with the Datadog Monitor. Changing this forces a new Datadog Monitor to be created.
        """
        redirect_uri: NotRequired[pulumi.Input[builtins.str]]
        """
        The redirect uri for linking. Changing this forces a new Datadog Monitor to be created.
        """
elif False:
    MonitorDatadogOrganizationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MonitorDatadogOrganizationArgs:
    def __init__(__self__, *,
                 api_key: pulumi.Input[builtins.str],
                 application_key: pulumi.Input[builtins.str],
                 enterprise_app_id: Optional[pulumi.Input[builtins.str]] = None,
                 id: Optional[pulumi.Input[builtins.str]] = None,
                 linking_auth_code: Optional[pulumi.Input[builtins.str]] = None,
                 linking_client_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 redirect_uri: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] api_key: Api key associated to the Datadog organization. Changing this forces a new Datadog Monitor to be created.
        :param pulumi.Input[builtins.str] application_key: Application key associated to the Datadog organization. Changing this forces a new Datadog Monitor to be created.
        :param pulumi.Input[builtins.str] enterprise_app_id: The ID of the enterprise_app. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] id: The ID of the Datadog Monitor.
        :param pulumi.Input[builtins.str] linking_auth_code: The auth code used to linking to an existing Datadog organization. Changing this forces a new Datadog Monitor to be created.
        :param pulumi.Input[builtins.str] linking_client_id: The ID of the linking_client. Changing this forces a new Datadog Monitor to be created.
        :param pulumi.Input[builtins.str] name: The name of the user that will be associated with the Datadog Monitor. Changing this forces a new Datadog Monitor to be created.
        :param pulumi.Input[builtins.str] redirect_uri: The redirect uri for linking. Changing this forces a new Datadog Monitor to be created.
        """
        pulumi.set(__self__, "api_key", api_key)
        pulumi.set(__self__, "application_key", application_key)
        if enterprise_app_id is not None:
            pulumi.set(__self__, "enterprise_app_id", enterprise_app_id)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if linking_auth_code is not None:
            pulumi.set(__self__, "linking_auth_code", linking_auth_code)
        if linking_client_id is not None:
            pulumi.set(__self__, "linking_client_id", linking_client_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if redirect_uri is not None:
            pulumi.set(__self__, "redirect_uri", redirect_uri)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> pulumi.Input[builtins.str]:
        """
        Api key associated to the Datadog organization. Changing this forces a new Datadog Monitor to be created.
        """
        return pulumi.get(self, "api_key")

    @api_key.setter
    def api_key(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "api_key", value)

    @property
    @pulumi.getter(name="applicationKey")
    def application_key(self) -> pulumi.Input[builtins.str]:
        """
        Application key associated to the Datadog organization. Changing this forces a new Datadog Monitor to be created.
        """
        return pulumi.get(self, "application_key")

    @application_key.setter
    def application_key(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "application_key", value)

    @property
    @pulumi.getter(name="enterpriseAppId")
    def enterprise_app_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the enterprise_app. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "enterprise_app_id")

    @enterprise_app_id.setter
    def enterprise_app_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "enterprise_app_id", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Datadog Monitor.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="linkingAuthCode")
    def linking_auth_code(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The auth code used to linking to an existing Datadog organization. Changing this forces a new Datadog Monitor to be created.
        """
        return pulumi.get(self, "linking_auth_code")

    @linking_auth_code.setter
    def linking_auth_code(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "linking_auth_code", value)

    @property
    @pulumi.getter(name="linkingClientId")
    def linking_client_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the linking_client. Changing this forces a new Datadog Monitor to be created.
        """
        return pulumi.get(self, "linking_client_id")

    @linking_client_id.setter
    def linking_client_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "linking_client_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the user that will be associated with the Datadog Monitor. Changing this forces a new Datadog Monitor to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="redirectUri")
    def redirect_uri(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The redirect uri for linking. Changing this forces a new Datadog Monitor to be created.
        """
        return pulumi.get(self, "redirect_uri")

    @redirect_uri.setter
    def redirect_uri(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "redirect_uri", value)


if not MYPY:
    class MonitorIdentityArgsDict(TypedDict):
        type: pulumi.Input[builtins.str]
        """
        Specifies the identity type of the Datadog Monitor. At this time the only allowed value is `SystemAssigned`.

        > **Note:** The assigned `principal_id` and `tenant_id` can be retrieved after the identity `type` has been set to `SystemAssigned` and the Datadog Monitor has been created. More details are available below.
        """
        principal_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The Principal ID for the Service Principal associated with the Identity of this Datadog Monitor.
        """
        tenant_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The Tenant ID for the Service Principal associated with the Identity of this Datadog Monitor.
        """
elif False:
    MonitorIdentityArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MonitorIdentityArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[builtins.str],
                 principal_id: Optional[pulumi.Input[builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] type: Specifies the identity type of the Datadog Monitor. At this time the only allowed value is `SystemAssigned`.
               
               > **Note:** The assigned `principal_id` and `tenant_id` can be retrieved after the identity `type` has been set to `SystemAssigned` and the Datadog Monitor has been created. More details are available below.
        :param pulumi.Input[builtins.str] principal_id: The Principal ID for the Service Principal associated with the Identity of this Datadog Monitor.
        :param pulumi.Input[builtins.str] tenant_id: The Tenant ID for the Service Principal associated with the Identity of this Datadog Monitor.
        """
        pulumi.set(__self__, "type", type)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the identity type of the Datadog Monitor. At this time the only allowed value is `SystemAssigned`.

        > **Note:** The assigned `principal_id` and `tenant_id` can be retrieved after the identity `type` has been set to `SystemAssigned` and the Datadog Monitor has been created. More details are available below.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Principal ID for the Service Principal associated with the Identity of this Datadog Monitor.
        """
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "principal_id", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Tenant ID for the Service Principal associated with the Identity of this Datadog Monitor.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tenant_id", value)


if not MYPY:
    class MonitorTagRuleLogArgsDict(TypedDict):
        aad_log_enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        Whether AAD logs should be sent for the Monitor resource?
        """
        filters: NotRequired[pulumi.Input[Sequence[pulumi.Input['MonitorTagRuleLogFilterArgsDict']]]]
        """
        A `filter` block as defined below.

        > **Note:** List of filtering tags to be used for capturing logs. This only takes effect if `resource_log_enabled` flag is enabled. If empty, all resources will be captured. If only Exclude action is specified, the rules will apply to the list of all available resources. If Include actions are specified, the rules will only include resources with the associated tags.
        """
        resource_log_enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        Whether Azure resource logs should be sent for the Monitor resource?
        """
        subscription_log_enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        Whether Azure subscription logs should be sent for the Monitor resource?
        """
elif False:
    MonitorTagRuleLogArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MonitorTagRuleLogArgs:
    def __init__(__self__, *,
                 aad_log_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 filters: Optional[pulumi.Input[Sequence[pulumi.Input['MonitorTagRuleLogFilterArgs']]]] = None,
                 resource_log_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 subscription_log_enabled: Optional[pulumi.Input[builtins.bool]] = None):
        """
        :param pulumi.Input[builtins.bool] aad_log_enabled: Whether AAD logs should be sent for the Monitor resource?
        :param pulumi.Input[Sequence[pulumi.Input['MonitorTagRuleLogFilterArgs']]] filters: A `filter` block as defined below.
               
               > **Note:** List of filtering tags to be used for capturing logs. This only takes effect if `resource_log_enabled` flag is enabled. If empty, all resources will be captured. If only Exclude action is specified, the rules will apply to the list of all available resources. If Include actions are specified, the rules will only include resources with the associated tags.
        :param pulumi.Input[builtins.bool] resource_log_enabled: Whether Azure resource logs should be sent for the Monitor resource?
        :param pulumi.Input[builtins.bool] subscription_log_enabled: Whether Azure subscription logs should be sent for the Monitor resource?
        """
        if aad_log_enabled is not None:
            pulumi.set(__self__, "aad_log_enabled", aad_log_enabled)
        if filters is not None:
            pulumi.set(__self__, "filters", filters)
        if resource_log_enabled is not None:
            pulumi.set(__self__, "resource_log_enabled", resource_log_enabled)
        if subscription_log_enabled is not None:
            pulumi.set(__self__, "subscription_log_enabled", subscription_log_enabled)

    @property
    @pulumi.getter(name="aadLogEnabled")
    def aad_log_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether AAD logs should be sent for the Monitor resource?
        """
        return pulumi.get(self, "aad_log_enabled")

    @aad_log_enabled.setter
    def aad_log_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "aad_log_enabled", value)

    @property
    @pulumi.getter
    def filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MonitorTagRuleLogFilterArgs']]]]:
        """
        A `filter` block as defined below.

        > **Note:** List of filtering tags to be used for capturing logs. This only takes effect if `resource_log_enabled` flag is enabled. If empty, all resources will be captured. If only Exclude action is specified, the rules will apply to the list of all available resources. If Include actions are specified, the rules will only include resources with the associated tags.
        """
        return pulumi.get(self, "filters")

    @filters.setter
    def filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MonitorTagRuleLogFilterArgs']]]]):
        pulumi.set(self, "filters", value)

    @property
    @pulumi.getter(name="resourceLogEnabled")
    def resource_log_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether Azure resource logs should be sent for the Monitor resource?
        """
        return pulumi.get(self, "resource_log_enabled")

    @resource_log_enabled.setter
    def resource_log_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "resource_log_enabled", value)

    @property
    @pulumi.getter(name="subscriptionLogEnabled")
    def subscription_log_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether Azure subscription logs should be sent for the Monitor resource?
        """
        return pulumi.get(self, "subscription_log_enabled")

    @subscription_log_enabled.setter
    def subscription_log_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "subscription_log_enabled", value)


if not MYPY:
    class MonitorTagRuleLogFilterArgsDict(TypedDict):
        action: pulumi.Input[builtins.str]
        """
        Allowed values Include or Exclude.
        """
        name: pulumi.Input[builtins.str]
        """
        Name of the Tag.
        """
        value: pulumi.Input[builtins.str]
        """
        Value of the Tag.
        """
elif False:
    MonitorTagRuleLogFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MonitorTagRuleLogFilterArgs:
    def __init__(__self__, *,
                 action: pulumi.Input[builtins.str],
                 name: pulumi.Input[builtins.str],
                 value: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] action: Allowed values Include or Exclude.
        :param pulumi.Input[builtins.str] name: Name of the Tag.
        :param pulumi.Input[builtins.str] value: Value of the Tag.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Input[builtins.str]:
        """
        Allowed values Include or Exclude.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        Name of the Tag.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[builtins.str]:
        """
        Value of the Tag.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "value", value)


if not MYPY:
    class MonitorTagRuleMetricArgsDict(TypedDict):
        filters: NotRequired[pulumi.Input[Sequence[pulumi.Input['MonitorTagRuleMetricFilterArgsDict']]]]
        """
        A `filter` block as defined below.

        > **Note:** List of filtering tags to be used for capturing metrics. If empty, all resources will be captured. If only Exclude action is specified, the rules will apply to the list of all available resources. If Include actions are specified, the rules will only include resources with the associated tags.
        """
elif False:
    MonitorTagRuleMetricArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MonitorTagRuleMetricArgs:
    def __init__(__self__, *,
                 filters: Optional[pulumi.Input[Sequence[pulumi.Input['MonitorTagRuleMetricFilterArgs']]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['MonitorTagRuleMetricFilterArgs']]] filters: A `filter` block as defined below.
               
               > **Note:** List of filtering tags to be used for capturing metrics. If empty, all resources will be captured. If only Exclude action is specified, the rules will apply to the list of all available resources. If Include actions are specified, the rules will only include resources with the associated tags.
        """
        if filters is not None:
            pulumi.set(__self__, "filters", filters)

    @property
    @pulumi.getter
    def filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MonitorTagRuleMetricFilterArgs']]]]:
        """
        A `filter` block as defined below.

        > **Note:** List of filtering tags to be used for capturing metrics. If empty, all resources will be captured. If only Exclude action is specified, the rules will apply to the list of all available resources. If Include actions are specified, the rules will only include resources with the associated tags.
        """
        return pulumi.get(self, "filters")

    @filters.setter
    def filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MonitorTagRuleMetricFilterArgs']]]]):
        pulumi.set(self, "filters", value)


if not MYPY:
    class MonitorTagRuleMetricFilterArgsDict(TypedDict):
        action: pulumi.Input[builtins.str]
        """
        Allowed values Include or Exclude.
        """
        name: pulumi.Input[builtins.str]
        """
        Name of the Tag.
        """
        value: pulumi.Input[builtins.str]
        """
        Value of the Tag.
        """
elif False:
    MonitorTagRuleMetricFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MonitorTagRuleMetricFilterArgs:
    def __init__(__self__, *,
                 action: pulumi.Input[builtins.str],
                 name: pulumi.Input[builtins.str],
                 value: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] action: Allowed values Include or Exclude.
        :param pulumi.Input[builtins.str] name: Name of the Tag.
        :param pulumi.Input[builtins.str] value: Value of the Tag.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Input[builtins.str]:
        """
        Allowed values Include or Exclude.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        Name of the Tag.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[builtins.str]:
        """
        Value of the Tag.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "value", value)


if not MYPY:
    class MonitorUserArgsDict(TypedDict):
        email: pulumi.Input[builtins.str]
        """
        Email of the user used by Datadog for contacting them if needed. Changing this forces a new Datadog Monitor to be created.
        """
        name: pulumi.Input[builtins.str]
        """
        The name which should be used for this user_info. Changing this forces a new resource to be created.
        """
        phone_number: NotRequired[pulumi.Input[builtins.str]]
        """
        Phone number of the user used by Datadog for contacting them if needed. Changing this forces a new resource to be created.
        """
elif False:
    MonitorUserArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MonitorUserArgs:
    def __init__(__self__, *,
                 email: pulumi.Input[builtins.str],
                 name: pulumi.Input[builtins.str],
                 phone_number: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] email: Email of the user used by Datadog for contacting them if needed. Changing this forces a new Datadog Monitor to be created.
        :param pulumi.Input[builtins.str] name: The name which should be used for this user_info. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] phone_number: Phone number of the user used by Datadog for contacting them if needed. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "email", email)
        pulumi.set(__self__, "name", name)
        if phone_number is not None:
            pulumi.set(__self__, "phone_number", phone_number)

    @property
    @pulumi.getter
    def email(self) -> pulumi.Input[builtins.str]:
        """
        Email of the user used by Datadog for contacting them if needed. Changing this forces a new Datadog Monitor to be created.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        The name which should be used for this user_info. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="phoneNumber")
    def phone_number(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Phone number of the user used by Datadog for contacting them if needed. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "phone_number")

    @phone_number.setter
    def phone_number(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "phone_number", value)


