# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DatasetBinaryArgs', 'DatasetBinary']

@pulumi.input_type
class DatasetBinaryArgs:
    def __init__(__self__, *,
                 data_factory_id: pulumi.Input[builtins.str],
                 linked_service_name: pulumi.Input[builtins.str],
                 additional_properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 annotations: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 azure_blob_storage_location: Optional[pulumi.Input['DatasetBinaryAzureBlobStorageLocationArgs']] = None,
                 compression: Optional[pulumi.Input['DatasetBinaryCompressionArgs']] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 folder: Optional[pulumi.Input[builtins.str]] = None,
                 http_server_location: Optional[pulumi.Input['DatasetBinaryHttpServerLocationArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 sftp_server_location: Optional[pulumi.Input['DatasetBinarySftpServerLocationArgs']] = None):
        """
        The set of arguments for constructing a DatasetBinary resource.
        :param pulumi.Input[builtins.str] data_factory_id: The Data Factory ID in which to associate the Linked Service with. Changing this forces a new resource.
        :param pulumi.Input[builtins.str] linked_service_name: The Data Factory Linked Service name in which to associate the Binary Dataset with.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] additional_properties: A map of additional properties to associate with the Data Factory Binary Dataset.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] annotations: List of tags that can be used for describing the Data Factory Binary Dataset.
        :param pulumi.Input['DatasetBinaryAzureBlobStorageLocationArgs'] azure_blob_storage_location: A `azure_blob_storage_location` block as defined below.
        :param pulumi.Input['DatasetBinaryCompressionArgs'] compression: A `compression` block as defined below.
        :param pulumi.Input[builtins.str] description: The description for the Data Factory Dataset.
        :param pulumi.Input[builtins.str] folder: The folder that this Dataset is in. If not specified, the Dataset will appear at the root level.
        :param pulumi.Input['DatasetBinaryHttpServerLocationArgs'] http_server_location: A `http_server_location` block as defined below.
        :param pulumi.Input[builtins.str] name: Specifies the name of the Data Factory Binary Dataset. Changing this forces a new resource to be created. Must be globally unique. See the [Microsoft documentation](https://docs.microsoft.com/azure/data-factory/naming-rules) for all restrictions.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] parameters: Specifies a list of parameters to associate with the Data Factory Binary Dataset.
               
               The following supported locations for a Binary Dataset. One of these should be specified:
        :param pulumi.Input['DatasetBinarySftpServerLocationArgs'] sftp_server_location: A `sftp_server_location` block as defined below.
        """
        pulumi.set(__self__, "data_factory_id", data_factory_id)
        pulumi.set(__self__, "linked_service_name", linked_service_name)
        if additional_properties is not None:
            pulumi.set(__self__, "additional_properties", additional_properties)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if azure_blob_storage_location is not None:
            pulumi.set(__self__, "azure_blob_storage_location", azure_blob_storage_location)
        if compression is not None:
            pulumi.set(__self__, "compression", compression)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if folder is not None:
            pulumi.set(__self__, "folder", folder)
        if http_server_location is not None:
            pulumi.set(__self__, "http_server_location", http_server_location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if sftp_server_location is not None:
            pulumi.set(__self__, "sftp_server_location", sftp_server_location)

    @property
    @pulumi.getter(name="dataFactoryId")
    def data_factory_id(self) -> pulumi.Input[builtins.str]:
        """
        The Data Factory ID in which to associate the Linked Service with. Changing this forces a new resource.
        """
        return pulumi.get(self, "data_factory_id")

    @data_factory_id.setter
    def data_factory_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "data_factory_id", value)

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> pulumi.Input[builtins.str]:
        """
        The Data Factory Linked Service name in which to associate the Binary Dataset with.
        """
        return pulumi.get(self, "linked_service_name")

    @linked_service_name.setter
    def linked_service_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "linked_service_name", value)

    @property
    @pulumi.getter(name="additionalProperties")
    def additional_properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of additional properties to associate with the Data Factory Binary Dataset.
        """
        return pulumi.get(self, "additional_properties")

    @additional_properties.setter
    def additional_properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "additional_properties", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of tags that can be used for describing the Data Factory Binary Dataset.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="azureBlobStorageLocation")
    def azure_blob_storage_location(self) -> Optional[pulumi.Input['DatasetBinaryAzureBlobStorageLocationArgs']]:
        """
        A `azure_blob_storage_location` block as defined below.
        """
        return pulumi.get(self, "azure_blob_storage_location")

    @azure_blob_storage_location.setter
    def azure_blob_storage_location(self, value: Optional[pulumi.Input['DatasetBinaryAzureBlobStorageLocationArgs']]):
        pulumi.set(self, "azure_blob_storage_location", value)

    @property
    @pulumi.getter
    def compression(self) -> Optional[pulumi.Input['DatasetBinaryCompressionArgs']]:
        """
        A `compression` block as defined below.
        """
        return pulumi.get(self, "compression")

    @compression.setter
    def compression(self, value: Optional[pulumi.Input['DatasetBinaryCompressionArgs']]):
        pulumi.set(self, "compression", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description for the Data Factory Dataset.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def folder(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The folder that this Dataset is in. If not specified, the Dataset will appear at the root level.
        """
        return pulumi.get(self, "folder")

    @folder.setter
    def folder(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "folder", value)

    @property
    @pulumi.getter(name="httpServerLocation")
    def http_server_location(self) -> Optional[pulumi.Input['DatasetBinaryHttpServerLocationArgs']]:
        """
        A `http_server_location` block as defined below.
        """
        return pulumi.get(self, "http_server_location")

    @http_server_location.setter
    def http_server_location(self, value: Optional[pulumi.Input['DatasetBinaryHttpServerLocationArgs']]):
        pulumi.set(self, "http_server_location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the Data Factory Binary Dataset. Changing this forces a new resource to be created. Must be globally unique. See the [Microsoft documentation](https://docs.microsoft.com/azure/data-factory/naming-rules) for all restrictions.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Specifies a list of parameters to associate with the Data Factory Binary Dataset.

        The following supported locations for a Binary Dataset. One of these should be specified:
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter(name="sftpServerLocation")
    def sftp_server_location(self) -> Optional[pulumi.Input['DatasetBinarySftpServerLocationArgs']]:
        """
        A `sftp_server_location` block as defined below.
        """
        return pulumi.get(self, "sftp_server_location")

    @sftp_server_location.setter
    def sftp_server_location(self, value: Optional[pulumi.Input['DatasetBinarySftpServerLocationArgs']]):
        pulumi.set(self, "sftp_server_location", value)


@pulumi.input_type
class _DatasetBinaryState:
    def __init__(__self__, *,
                 additional_properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 annotations: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 azure_blob_storage_location: Optional[pulumi.Input['DatasetBinaryAzureBlobStorageLocationArgs']] = None,
                 compression: Optional[pulumi.Input['DatasetBinaryCompressionArgs']] = None,
                 data_factory_id: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 folder: Optional[pulumi.Input[builtins.str]] = None,
                 http_server_location: Optional[pulumi.Input['DatasetBinaryHttpServerLocationArgs']] = None,
                 linked_service_name: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 sftp_server_location: Optional[pulumi.Input['DatasetBinarySftpServerLocationArgs']] = None):
        """
        Input properties used for looking up and filtering DatasetBinary resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] additional_properties: A map of additional properties to associate with the Data Factory Binary Dataset.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] annotations: List of tags that can be used for describing the Data Factory Binary Dataset.
        :param pulumi.Input['DatasetBinaryAzureBlobStorageLocationArgs'] azure_blob_storage_location: A `azure_blob_storage_location` block as defined below.
        :param pulumi.Input['DatasetBinaryCompressionArgs'] compression: A `compression` block as defined below.
        :param pulumi.Input[builtins.str] data_factory_id: The Data Factory ID in which to associate the Linked Service with. Changing this forces a new resource.
        :param pulumi.Input[builtins.str] description: The description for the Data Factory Dataset.
        :param pulumi.Input[builtins.str] folder: The folder that this Dataset is in. If not specified, the Dataset will appear at the root level.
        :param pulumi.Input['DatasetBinaryHttpServerLocationArgs'] http_server_location: A `http_server_location` block as defined below.
        :param pulumi.Input[builtins.str] linked_service_name: The Data Factory Linked Service name in which to associate the Binary Dataset with.
        :param pulumi.Input[builtins.str] name: Specifies the name of the Data Factory Binary Dataset. Changing this forces a new resource to be created. Must be globally unique. See the [Microsoft documentation](https://docs.microsoft.com/azure/data-factory/naming-rules) for all restrictions.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] parameters: Specifies a list of parameters to associate with the Data Factory Binary Dataset.
               
               The following supported locations for a Binary Dataset. One of these should be specified:
        :param pulumi.Input['DatasetBinarySftpServerLocationArgs'] sftp_server_location: A `sftp_server_location` block as defined below.
        """
        if additional_properties is not None:
            pulumi.set(__self__, "additional_properties", additional_properties)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if azure_blob_storage_location is not None:
            pulumi.set(__self__, "azure_blob_storage_location", azure_blob_storage_location)
        if compression is not None:
            pulumi.set(__self__, "compression", compression)
        if data_factory_id is not None:
            pulumi.set(__self__, "data_factory_id", data_factory_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if folder is not None:
            pulumi.set(__self__, "folder", folder)
        if http_server_location is not None:
            pulumi.set(__self__, "http_server_location", http_server_location)
        if linked_service_name is not None:
            pulumi.set(__self__, "linked_service_name", linked_service_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if sftp_server_location is not None:
            pulumi.set(__self__, "sftp_server_location", sftp_server_location)

    @property
    @pulumi.getter(name="additionalProperties")
    def additional_properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of additional properties to associate with the Data Factory Binary Dataset.
        """
        return pulumi.get(self, "additional_properties")

    @additional_properties.setter
    def additional_properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "additional_properties", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of tags that can be used for describing the Data Factory Binary Dataset.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="azureBlobStorageLocation")
    def azure_blob_storage_location(self) -> Optional[pulumi.Input['DatasetBinaryAzureBlobStorageLocationArgs']]:
        """
        A `azure_blob_storage_location` block as defined below.
        """
        return pulumi.get(self, "azure_blob_storage_location")

    @azure_blob_storage_location.setter
    def azure_blob_storage_location(self, value: Optional[pulumi.Input['DatasetBinaryAzureBlobStorageLocationArgs']]):
        pulumi.set(self, "azure_blob_storage_location", value)

    @property
    @pulumi.getter
    def compression(self) -> Optional[pulumi.Input['DatasetBinaryCompressionArgs']]:
        """
        A `compression` block as defined below.
        """
        return pulumi.get(self, "compression")

    @compression.setter
    def compression(self, value: Optional[pulumi.Input['DatasetBinaryCompressionArgs']]):
        pulumi.set(self, "compression", value)

    @property
    @pulumi.getter(name="dataFactoryId")
    def data_factory_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Data Factory ID in which to associate the Linked Service with. Changing this forces a new resource.
        """
        return pulumi.get(self, "data_factory_id")

    @data_factory_id.setter
    def data_factory_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "data_factory_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description for the Data Factory Dataset.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def folder(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The folder that this Dataset is in. If not specified, the Dataset will appear at the root level.
        """
        return pulumi.get(self, "folder")

    @folder.setter
    def folder(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "folder", value)

    @property
    @pulumi.getter(name="httpServerLocation")
    def http_server_location(self) -> Optional[pulumi.Input['DatasetBinaryHttpServerLocationArgs']]:
        """
        A `http_server_location` block as defined below.
        """
        return pulumi.get(self, "http_server_location")

    @http_server_location.setter
    def http_server_location(self, value: Optional[pulumi.Input['DatasetBinaryHttpServerLocationArgs']]):
        pulumi.set(self, "http_server_location", value)

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Data Factory Linked Service name in which to associate the Binary Dataset with.
        """
        return pulumi.get(self, "linked_service_name")

    @linked_service_name.setter
    def linked_service_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "linked_service_name", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the Data Factory Binary Dataset. Changing this forces a new resource to be created. Must be globally unique. See the [Microsoft documentation](https://docs.microsoft.com/azure/data-factory/naming-rules) for all restrictions.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Specifies a list of parameters to associate with the Data Factory Binary Dataset.

        The following supported locations for a Binary Dataset. One of these should be specified:
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter(name="sftpServerLocation")
    def sftp_server_location(self) -> Optional[pulumi.Input['DatasetBinarySftpServerLocationArgs']]:
        """
        A `sftp_server_location` block as defined below.
        """
        return pulumi.get(self, "sftp_server_location")

    @sftp_server_location.setter
    def sftp_server_location(self, value: Optional[pulumi.Input['DatasetBinarySftpServerLocationArgs']]):
        pulumi.set(self, "sftp_server_location", value)


@pulumi.type_token("azure:datafactory/datasetBinary:DatasetBinary")
class DatasetBinary(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 annotations: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 azure_blob_storage_location: Optional[pulumi.Input[Union['DatasetBinaryAzureBlobStorageLocationArgs', 'DatasetBinaryAzureBlobStorageLocationArgsDict']]] = None,
                 compression: Optional[pulumi.Input[Union['DatasetBinaryCompressionArgs', 'DatasetBinaryCompressionArgsDict']]] = None,
                 data_factory_id: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 folder: Optional[pulumi.Input[builtins.str]] = None,
                 http_server_location: Optional[pulumi.Input[Union['DatasetBinaryHttpServerLocationArgs', 'DatasetBinaryHttpServerLocationArgsDict']]] = None,
                 linked_service_name: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 sftp_server_location: Optional[pulumi.Input[Union['DatasetBinarySftpServerLocationArgs', 'DatasetBinarySftpServerLocationArgsDict']]] = None,
                 __props__=None):
        """
        Manages a Data Factory Binary Dataset inside an Azure Data Factory.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example",
            location="West Europe")
        example_factory = azure.datafactory.Factory("example",
            name="example",
            location=example.location,
            resource_group_name=example.name)
        example_linked_service_sftp = azure.datafactory.LinkedServiceSftp("example",
            name="example",
            data_factory_id=example_factory.id,
            authentication_type="Basic",
            host="http://www.bing.com",
            port=22,
            username="foo",
            password="bar")
        example_dataset_binary = azure.datafactory.DatasetBinary("example",
            name="example",
            data_factory_id=example_factory.id,
            linked_service_name=example_linked_service_sftp.name,
            sftp_server_location={
                "path": "/test/",
                "filename": "**",
            })
        ```

        ## Import

        Data Factory Binary Datasets can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:datafactory/datasetBinary:DatasetBinary example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/example/providers/Microsoft.DataFactory/factories/example/datasets/example
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] additional_properties: A map of additional properties to associate with the Data Factory Binary Dataset.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] annotations: List of tags that can be used for describing the Data Factory Binary Dataset.
        :param pulumi.Input[Union['DatasetBinaryAzureBlobStorageLocationArgs', 'DatasetBinaryAzureBlobStorageLocationArgsDict']] azure_blob_storage_location: A `azure_blob_storage_location` block as defined below.
        :param pulumi.Input[Union['DatasetBinaryCompressionArgs', 'DatasetBinaryCompressionArgsDict']] compression: A `compression` block as defined below.
        :param pulumi.Input[builtins.str] data_factory_id: The Data Factory ID in which to associate the Linked Service with. Changing this forces a new resource.
        :param pulumi.Input[builtins.str] description: The description for the Data Factory Dataset.
        :param pulumi.Input[builtins.str] folder: The folder that this Dataset is in. If not specified, the Dataset will appear at the root level.
        :param pulumi.Input[Union['DatasetBinaryHttpServerLocationArgs', 'DatasetBinaryHttpServerLocationArgsDict']] http_server_location: A `http_server_location` block as defined below.
        :param pulumi.Input[builtins.str] linked_service_name: The Data Factory Linked Service name in which to associate the Binary Dataset with.
        :param pulumi.Input[builtins.str] name: Specifies the name of the Data Factory Binary Dataset. Changing this forces a new resource to be created. Must be globally unique. See the [Microsoft documentation](https://docs.microsoft.com/azure/data-factory/naming-rules) for all restrictions.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] parameters: Specifies a list of parameters to associate with the Data Factory Binary Dataset.
               
               The following supported locations for a Binary Dataset. One of these should be specified:
        :param pulumi.Input[Union['DatasetBinarySftpServerLocationArgs', 'DatasetBinarySftpServerLocationArgsDict']] sftp_server_location: A `sftp_server_location` block as defined below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DatasetBinaryArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Data Factory Binary Dataset inside an Azure Data Factory.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example",
            location="West Europe")
        example_factory = azure.datafactory.Factory("example",
            name="example",
            location=example.location,
            resource_group_name=example.name)
        example_linked_service_sftp = azure.datafactory.LinkedServiceSftp("example",
            name="example",
            data_factory_id=example_factory.id,
            authentication_type="Basic",
            host="http://www.bing.com",
            port=22,
            username="foo",
            password="bar")
        example_dataset_binary = azure.datafactory.DatasetBinary("example",
            name="example",
            data_factory_id=example_factory.id,
            linked_service_name=example_linked_service_sftp.name,
            sftp_server_location={
                "path": "/test/",
                "filename": "**",
            })
        ```

        ## Import

        Data Factory Binary Datasets can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:datafactory/datasetBinary:DatasetBinary example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/example/providers/Microsoft.DataFactory/factories/example/datasets/example
        ```

        :param str resource_name: The name of the resource.
        :param DatasetBinaryArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DatasetBinaryArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 annotations: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 azure_blob_storage_location: Optional[pulumi.Input[Union['DatasetBinaryAzureBlobStorageLocationArgs', 'DatasetBinaryAzureBlobStorageLocationArgsDict']]] = None,
                 compression: Optional[pulumi.Input[Union['DatasetBinaryCompressionArgs', 'DatasetBinaryCompressionArgsDict']]] = None,
                 data_factory_id: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 folder: Optional[pulumi.Input[builtins.str]] = None,
                 http_server_location: Optional[pulumi.Input[Union['DatasetBinaryHttpServerLocationArgs', 'DatasetBinaryHttpServerLocationArgsDict']]] = None,
                 linked_service_name: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 sftp_server_location: Optional[pulumi.Input[Union['DatasetBinarySftpServerLocationArgs', 'DatasetBinarySftpServerLocationArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DatasetBinaryArgs.__new__(DatasetBinaryArgs)

            __props__.__dict__["additional_properties"] = additional_properties
            __props__.__dict__["annotations"] = annotations
            __props__.__dict__["azure_blob_storage_location"] = azure_blob_storage_location
            __props__.__dict__["compression"] = compression
            if data_factory_id is None and not opts.urn:
                raise TypeError("Missing required property 'data_factory_id'")
            __props__.__dict__["data_factory_id"] = data_factory_id
            __props__.__dict__["description"] = description
            __props__.__dict__["folder"] = folder
            __props__.__dict__["http_server_location"] = http_server_location
            if linked_service_name is None and not opts.urn:
                raise TypeError("Missing required property 'linked_service_name'")
            __props__.__dict__["linked_service_name"] = linked_service_name
            __props__.__dict__["name"] = name
            __props__.__dict__["parameters"] = parameters
            __props__.__dict__["sftp_server_location"] = sftp_server_location
        super(DatasetBinary, __self__).__init__(
            'azure:datafactory/datasetBinary:DatasetBinary',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            additional_properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            annotations: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            azure_blob_storage_location: Optional[pulumi.Input[Union['DatasetBinaryAzureBlobStorageLocationArgs', 'DatasetBinaryAzureBlobStorageLocationArgsDict']]] = None,
            compression: Optional[pulumi.Input[Union['DatasetBinaryCompressionArgs', 'DatasetBinaryCompressionArgsDict']]] = None,
            data_factory_id: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            folder: Optional[pulumi.Input[builtins.str]] = None,
            http_server_location: Optional[pulumi.Input[Union['DatasetBinaryHttpServerLocationArgs', 'DatasetBinaryHttpServerLocationArgsDict']]] = None,
            linked_service_name: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            sftp_server_location: Optional[pulumi.Input[Union['DatasetBinarySftpServerLocationArgs', 'DatasetBinarySftpServerLocationArgsDict']]] = None) -> 'DatasetBinary':
        """
        Get an existing DatasetBinary resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] additional_properties: A map of additional properties to associate with the Data Factory Binary Dataset.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] annotations: List of tags that can be used for describing the Data Factory Binary Dataset.
        :param pulumi.Input[Union['DatasetBinaryAzureBlobStorageLocationArgs', 'DatasetBinaryAzureBlobStorageLocationArgsDict']] azure_blob_storage_location: A `azure_blob_storage_location` block as defined below.
        :param pulumi.Input[Union['DatasetBinaryCompressionArgs', 'DatasetBinaryCompressionArgsDict']] compression: A `compression` block as defined below.
        :param pulumi.Input[builtins.str] data_factory_id: The Data Factory ID in which to associate the Linked Service with. Changing this forces a new resource.
        :param pulumi.Input[builtins.str] description: The description for the Data Factory Dataset.
        :param pulumi.Input[builtins.str] folder: The folder that this Dataset is in. If not specified, the Dataset will appear at the root level.
        :param pulumi.Input[Union['DatasetBinaryHttpServerLocationArgs', 'DatasetBinaryHttpServerLocationArgsDict']] http_server_location: A `http_server_location` block as defined below.
        :param pulumi.Input[builtins.str] linked_service_name: The Data Factory Linked Service name in which to associate the Binary Dataset with.
        :param pulumi.Input[builtins.str] name: Specifies the name of the Data Factory Binary Dataset. Changing this forces a new resource to be created. Must be globally unique. See the [Microsoft documentation](https://docs.microsoft.com/azure/data-factory/naming-rules) for all restrictions.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] parameters: Specifies a list of parameters to associate with the Data Factory Binary Dataset.
               
               The following supported locations for a Binary Dataset. One of these should be specified:
        :param pulumi.Input[Union['DatasetBinarySftpServerLocationArgs', 'DatasetBinarySftpServerLocationArgsDict']] sftp_server_location: A `sftp_server_location` block as defined below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DatasetBinaryState.__new__(_DatasetBinaryState)

        __props__.__dict__["additional_properties"] = additional_properties
        __props__.__dict__["annotations"] = annotations
        __props__.__dict__["azure_blob_storage_location"] = azure_blob_storage_location
        __props__.__dict__["compression"] = compression
        __props__.__dict__["data_factory_id"] = data_factory_id
        __props__.__dict__["description"] = description
        __props__.__dict__["folder"] = folder
        __props__.__dict__["http_server_location"] = http_server_location
        __props__.__dict__["linked_service_name"] = linked_service_name
        __props__.__dict__["name"] = name
        __props__.__dict__["parameters"] = parameters
        __props__.__dict__["sftp_server_location"] = sftp_server_location
        return DatasetBinary(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="additionalProperties")
    def additional_properties(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A map of additional properties to associate with the Data Factory Binary Dataset.
        """
        return pulumi.get(self, "additional_properties")

    @property
    @pulumi.getter
    def annotations(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        List of tags that can be used for describing the Data Factory Binary Dataset.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter(name="azureBlobStorageLocation")
    def azure_blob_storage_location(self) -> pulumi.Output[Optional['outputs.DatasetBinaryAzureBlobStorageLocation']]:
        """
        A `azure_blob_storage_location` block as defined below.
        """
        return pulumi.get(self, "azure_blob_storage_location")

    @property
    @pulumi.getter
    def compression(self) -> pulumi.Output[Optional['outputs.DatasetBinaryCompression']]:
        """
        A `compression` block as defined below.
        """
        return pulumi.get(self, "compression")

    @property
    @pulumi.getter(name="dataFactoryId")
    def data_factory_id(self) -> pulumi.Output[builtins.str]:
        """
        The Data Factory ID in which to associate the Linked Service with. Changing this forces a new resource.
        """
        return pulumi.get(self, "data_factory_id")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The description for the Data Factory Dataset.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def folder(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The folder that this Dataset is in. If not specified, the Dataset will appear at the root level.
        """
        return pulumi.get(self, "folder")

    @property
    @pulumi.getter(name="httpServerLocation")
    def http_server_location(self) -> pulumi.Output[Optional['outputs.DatasetBinaryHttpServerLocation']]:
        """
        A `http_server_location` block as defined below.
        """
        return pulumi.get(self, "http_server_location")

    @property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> pulumi.Output[builtins.str]:
        """
        The Data Factory Linked Service name in which to associate the Binary Dataset with.
        """
        return pulumi.get(self, "linked_service_name")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the name of the Data Factory Binary Dataset. Changing this forces a new resource to be created. Must be globally unique. See the [Microsoft documentation](https://docs.microsoft.com/azure/data-factory/naming-rules) for all restrictions.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parameters(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Specifies a list of parameters to associate with the Data Factory Binary Dataset.

        The following supported locations for a Binary Dataset. One of these should be specified:
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter(name="sftpServerLocation")
    def sftp_server_location(self) -> pulumi.Output[Optional['outputs.DatasetBinarySftpServerLocation']]:
        """
        A `sftp_server_location` block as defined below.
        """
        return pulumi.get(self, "sftp_server_location")

