# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['LinkedServiceAzureSqlDatabaseArgs', 'LinkedServiceAzureSqlDatabase']

@pulumi.input_type
class LinkedServiceAzureSqlDatabaseArgs:
    def __init__(__self__, *,
                 data_factory_id: pulumi.Input[builtins.str],
                 additional_properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 annotations: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 connection_string: Optional[pulumi.Input[builtins.str]] = None,
                 credential_name: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 integration_runtime_name: Optional[pulumi.Input[builtins.str]] = None,
                 key_vault_connection_string: Optional[pulumi.Input['LinkedServiceAzureSqlDatabaseKeyVaultConnectionStringArgs']] = None,
                 key_vault_password: Optional[pulumi.Input['LinkedServiceAzureSqlDatabaseKeyVaultPasswordArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 service_principal_id: Optional[pulumi.Input[builtins.str]] = None,
                 service_principal_key: Optional[pulumi.Input[builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[builtins.str]] = None,
                 use_managed_identity: Optional[pulumi.Input[builtins.bool]] = None):
        """
        The set of arguments for constructing a LinkedServiceAzureSqlDatabase resource.
        :param pulumi.Input[builtins.str] data_factory_id: The Data Factory ID in which to associate the Linked Service with. Changing this forces a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] additional_properties: A map of additional properties to associate with the Data Factory Linked Service Azure SQL Database.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] annotations: List of tags that can be used for describing the Data Factory Linked Service Azure SQL Database.
        :param pulumi.Input[builtins.str] connection_string: The connection string in which to authenticate with Azure SQL Database. Exactly one of either `connection_string` or `key_vault_connection_string` is required.
        :param pulumi.Input[builtins.str] credential_name: The name of a User-assigned Managed Identity. Use this argument to authenticate against the linked resource using a User-assigned Managed Identity.
        :param pulumi.Input[builtins.str] description: The description for the Data Factory Linked Service Azure SQL Database.
        :param pulumi.Input[builtins.str] integration_runtime_name: The integration runtime reference to associate with the Data Factory Linked Service Azure SQL Database.
        :param pulumi.Input['LinkedServiceAzureSqlDatabaseKeyVaultConnectionStringArgs'] key_vault_connection_string: A `key_vault_connection_string` block as defined below. Use this argument to store Azure SQL Database connection string in an existing Key Vault. It needs an existing Key Vault Data Factory Linked Service. Exactly one of either `connection_string` or `key_vault_connection_string` is required.
        :param pulumi.Input['LinkedServiceAzureSqlDatabaseKeyVaultPasswordArgs'] key_vault_password: A `key_vault_password` block as defined below. Use this argument to store SQL Server password in an existing Key Vault. It needs an existing Key Vault Data Factory Linked Service.
        :param pulumi.Input[builtins.str] name: Specifies the name of the Data Factory Linked Service Azure SQL Database. Changing this forces a new resource to be created. Must be unique within a data factory. See the [Microsoft documentation](https://docs.microsoft.com/azure/data-factory/naming-rules) for all restrictions.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] parameters: A map of parameters to associate with the Data Factory Linked Service Azure SQL Database.
        :param pulumi.Input[builtins.str] service_principal_id: The service principal id in which to authenticate against the Azure SQL Database. Required if `service_principal_key` is set.
        :param pulumi.Input[builtins.str] service_principal_key: The service principal key in which to authenticate against the Azure SQL Database. Required if `service_principal_id` is set.
        :param pulumi.Input[builtins.str] tenant_id: The tenant id or name in which to authenticate against the Azure SQL Database.
        :param pulumi.Input[builtins.bool] use_managed_identity: Whether to use the Data Factory's managed identity to authenticate against the Azure SQL Database. Incompatible with `service_principal_id` and `service_principal_key`
        """
        pulumi.set(__self__, "data_factory_id", data_factory_id)
        if additional_properties is not None:
            pulumi.set(__self__, "additional_properties", additional_properties)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if connection_string is not None:
            pulumi.set(__self__, "connection_string", connection_string)
        if credential_name is not None:
            pulumi.set(__self__, "credential_name", credential_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if integration_runtime_name is not None:
            pulumi.set(__self__, "integration_runtime_name", integration_runtime_name)
        if key_vault_connection_string is not None:
            pulumi.set(__self__, "key_vault_connection_string", key_vault_connection_string)
        if key_vault_password is not None:
            pulumi.set(__self__, "key_vault_password", key_vault_password)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if service_principal_id is not None:
            pulumi.set(__self__, "service_principal_id", service_principal_id)
        if service_principal_key is not None:
            pulumi.set(__self__, "service_principal_key", service_principal_key)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if use_managed_identity is not None:
            pulumi.set(__self__, "use_managed_identity", use_managed_identity)

    @property
    @pulumi.getter(name="dataFactoryId")
    def data_factory_id(self) -> pulumi.Input[builtins.str]:
        """
        The Data Factory ID in which to associate the Linked Service with. Changing this forces a new resource.
        """
        return pulumi.get(self, "data_factory_id")

    @data_factory_id.setter
    def data_factory_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "data_factory_id", value)

    @property
    @pulumi.getter(name="additionalProperties")
    def additional_properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of additional properties to associate with the Data Factory Linked Service Azure SQL Database.
        """
        return pulumi.get(self, "additional_properties")

    @additional_properties.setter
    def additional_properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "additional_properties", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of tags that can be used for describing the Data Factory Linked Service Azure SQL Database.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The connection string in which to authenticate with Azure SQL Database. Exactly one of either `connection_string` or `key_vault_connection_string` is required.
        """
        return pulumi.get(self, "connection_string")

    @connection_string.setter
    def connection_string(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "connection_string", value)

    @property
    @pulumi.getter(name="credentialName")
    def credential_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of a User-assigned Managed Identity. Use this argument to authenticate against the linked resource using a User-assigned Managed Identity.
        """
        return pulumi.get(self, "credential_name")

    @credential_name.setter
    def credential_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "credential_name", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description for the Data Factory Linked Service Azure SQL Database.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="integrationRuntimeName")
    def integration_runtime_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The integration runtime reference to associate with the Data Factory Linked Service Azure SQL Database.
        """
        return pulumi.get(self, "integration_runtime_name")

    @integration_runtime_name.setter
    def integration_runtime_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "integration_runtime_name", value)

    @property
    @pulumi.getter(name="keyVaultConnectionString")
    def key_vault_connection_string(self) -> Optional[pulumi.Input['LinkedServiceAzureSqlDatabaseKeyVaultConnectionStringArgs']]:
        """
        A `key_vault_connection_string` block as defined below. Use this argument to store Azure SQL Database connection string in an existing Key Vault. It needs an existing Key Vault Data Factory Linked Service. Exactly one of either `connection_string` or `key_vault_connection_string` is required.
        """
        return pulumi.get(self, "key_vault_connection_string")

    @key_vault_connection_string.setter
    def key_vault_connection_string(self, value: Optional[pulumi.Input['LinkedServiceAzureSqlDatabaseKeyVaultConnectionStringArgs']]):
        pulumi.set(self, "key_vault_connection_string", value)

    @property
    @pulumi.getter(name="keyVaultPassword")
    def key_vault_password(self) -> Optional[pulumi.Input['LinkedServiceAzureSqlDatabaseKeyVaultPasswordArgs']]:
        """
        A `key_vault_password` block as defined below. Use this argument to store SQL Server password in an existing Key Vault. It needs an existing Key Vault Data Factory Linked Service.
        """
        return pulumi.get(self, "key_vault_password")

    @key_vault_password.setter
    def key_vault_password(self, value: Optional[pulumi.Input['LinkedServiceAzureSqlDatabaseKeyVaultPasswordArgs']]):
        pulumi.set(self, "key_vault_password", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the Data Factory Linked Service Azure SQL Database. Changing this forces a new resource to be created. Must be unique within a data factory. See the [Microsoft documentation](https://docs.microsoft.com/azure/data-factory/naming-rules) for all restrictions.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of parameters to associate with the Data Factory Linked Service Azure SQL Database.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter(name="servicePrincipalId")
    def service_principal_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The service principal id in which to authenticate against the Azure SQL Database. Required if `service_principal_key` is set.
        """
        return pulumi.get(self, "service_principal_id")

    @service_principal_id.setter
    def service_principal_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_principal_id", value)

    @property
    @pulumi.getter(name="servicePrincipalKey")
    def service_principal_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The service principal key in which to authenticate against the Azure SQL Database. Required if `service_principal_id` is set.
        """
        return pulumi.get(self, "service_principal_key")

    @service_principal_key.setter
    def service_principal_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_principal_key", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The tenant id or name in which to authenticate against the Azure SQL Database.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="useManagedIdentity")
    def use_managed_identity(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to use the Data Factory's managed identity to authenticate against the Azure SQL Database. Incompatible with `service_principal_id` and `service_principal_key`
        """
        return pulumi.get(self, "use_managed_identity")

    @use_managed_identity.setter
    def use_managed_identity(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "use_managed_identity", value)


@pulumi.input_type
class _LinkedServiceAzureSqlDatabaseState:
    def __init__(__self__, *,
                 additional_properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 annotations: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 connection_string: Optional[pulumi.Input[builtins.str]] = None,
                 credential_name: Optional[pulumi.Input[builtins.str]] = None,
                 data_factory_id: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 integration_runtime_name: Optional[pulumi.Input[builtins.str]] = None,
                 key_vault_connection_string: Optional[pulumi.Input['LinkedServiceAzureSqlDatabaseKeyVaultConnectionStringArgs']] = None,
                 key_vault_password: Optional[pulumi.Input['LinkedServiceAzureSqlDatabaseKeyVaultPasswordArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 service_principal_id: Optional[pulumi.Input[builtins.str]] = None,
                 service_principal_key: Optional[pulumi.Input[builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[builtins.str]] = None,
                 use_managed_identity: Optional[pulumi.Input[builtins.bool]] = None):
        """
        Input properties used for looking up and filtering LinkedServiceAzureSqlDatabase resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] additional_properties: A map of additional properties to associate with the Data Factory Linked Service Azure SQL Database.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] annotations: List of tags that can be used for describing the Data Factory Linked Service Azure SQL Database.
        :param pulumi.Input[builtins.str] connection_string: The connection string in which to authenticate with Azure SQL Database. Exactly one of either `connection_string` or `key_vault_connection_string` is required.
        :param pulumi.Input[builtins.str] credential_name: The name of a User-assigned Managed Identity. Use this argument to authenticate against the linked resource using a User-assigned Managed Identity.
        :param pulumi.Input[builtins.str] data_factory_id: The Data Factory ID in which to associate the Linked Service with. Changing this forces a new resource.
        :param pulumi.Input[builtins.str] description: The description for the Data Factory Linked Service Azure SQL Database.
        :param pulumi.Input[builtins.str] integration_runtime_name: The integration runtime reference to associate with the Data Factory Linked Service Azure SQL Database.
        :param pulumi.Input['LinkedServiceAzureSqlDatabaseKeyVaultConnectionStringArgs'] key_vault_connection_string: A `key_vault_connection_string` block as defined below. Use this argument to store Azure SQL Database connection string in an existing Key Vault. It needs an existing Key Vault Data Factory Linked Service. Exactly one of either `connection_string` or `key_vault_connection_string` is required.
        :param pulumi.Input['LinkedServiceAzureSqlDatabaseKeyVaultPasswordArgs'] key_vault_password: A `key_vault_password` block as defined below. Use this argument to store SQL Server password in an existing Key Vault. It needs an existing Key Vault Data Factory Linked Service.
        :param pulumi.Input[builtins.str] name: Specifies the name of the Data Factory Linked Service Azure SQL Database. Changing this forces a new resource to be created. Must be unique within a data factory. See the [Microsoft documentation](https://docs.microsoft.com/azure/data-factory/naming-rules) for all restrictions.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] parameters: A map of parameters to associate with the Data Factory Linked Service Azure SQL Database.
        :param pulumi.Input[builtins.str] service_principal_id: The service principal id in which to authenticate against the Azure SQL Database. Required if `service_principal_key` is set.
        :param pulumi.Input[builtins.str] service_principal_key: The service principal key in which to authenticate against the Azure SQL Database. Required if `service_principal_id` is set.
        :param pulumi.Input[builtins.str] tenant_id: The tenant id or name in which to authenticate against the Azure SQL Database.
        :param pulumi.Input[builtins.bool] use_managed_identity: Whether to use the Data Factory's managed identity to authenticate against the Azure SQL Database. Incompatible with `service_principal_id` and `service_principal_key`
        """
        if additional_properties is not None:
            pulumi.set(__self__, "additional_properties", additional_properties)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if connection_string is not None:
            pulumi.set(__self__, "connection_string", connection_string)
        if credential_name is not None:
            pulumi.set(__self__, "credential_name", credential_name)
        if data_factory_id is not None:
            pulumi.set(__self__, "data_factory_id", data_factory_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if integration_runtime_name is not None:
            pulumi.set(__self__, "integration_runtime_name", integration_runtime_name)
        if key_vault_connection_string is not None:
            pulumi.set(__self__, "key_vault_connection_string", key_vault_connection_string)
        if key_vault_password is not None:
            pulumi.set(__self__, "key_vault_password", key_vault_password)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if service_principal_id is not None:
            pulumi.set(__self__, "service_principal_id", service_principal_id)
        if service_principal_key is not None:
            pulumi.set(__self__, "service_principal_key", service_principal_key)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if use_managed_identity is not None:
            pulumi.set(__self__, "use_managed_identity", use_managed_identity)

    @property
    @pulumi.getter(name="additionalProperties")
    def additional_properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of additional properties to associate with the Data Factory Linked Service Azure SQL Database.
        """
        return pulumi.get(self, "additional_properties")

    @additional_properties.setter
    def additional_properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "additional_properties", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of tags that can be used for describing the Data Factory Linked Service Azure SQL Database.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The connection string in which to authenticate with Azure SQL Database. Exactly one of either `connection_string` or `key_vault_connection_string` is required.
        """
        return pulumi.get(self, "connection_string")

    @connection_string.setter
    def connection_string(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "connection_string", value)

    @property
    @pulumi.getter(name="credentialName")
    def credential_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of a User-assigned Managed Identity. Use this argument to authenticate against the linked resource using a User-assigned Managed Identity.
        """
        return pulumi.get(self, "credential_name")

    @credential_name.setter
    def credential_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "credential_name", value)

    @property
    @pulumi.getter(name="dataFactoryId")
    def data_factory_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Data Factory ID in which to associate the Linked Service with. Changing this forces a new resource.
        """
        return pulumi.get(self, "data_factory_id")

    @data_factory_id.setter
    def data_factory_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "data_factory_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description for the Data Factory Linked Service Azure SQL Database.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="integrationRuntimeName")
    def integration_runtime_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The integration runtime reference to associate with the Data Factory Linked Service Azure SQL Database.
        """
        return pulumi.get(self, "integration_runtime_name")

    @integration_runtime_name.setter
    def integration_runtime_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "integration_runtime_name", value)

    @property
    @pulumi.getter(name="keyVaultConnectionString")
    def key_vault_connection_string(self) -> Optional[pulumi.Input['LinkedServiceAzureSqlDatabaseKeyVaultConnectionStringArgs']]:
        """
        A `key_vault_connection_string` block as defined below. Use this argument to store Azure SQL Database connection string in an existing Key Vault. It needs an existing Key Vault Data Factory Linked Service. Exactly one of either `connection_string` or `key_vault_connection_string` is required.
        """
        return pulumi.get(self, "key_vault_connection_string")

    @key_vault_connection_string.setter
    def key_vault_connection_string(self, value: Optional[pulumi.Input['LinkedServiceAzureSqlDatabaseKeyVaultConnectionStringArgs']]):
        pulumi.set(self, "key_vault_connection_string", value)

    @property
    @pulumi.getter(name="keyVaultPassword")
    def key_vault_password(self) -> Optional[pulumi.Input['LinkedServiceAzureSqlDatabaseKeyVaultPasswordArgs']]:
        """
        A `key_vault_password` block as defined below. Use this argument to store SQL Server password in an existing Key Vault. It needs an existing Key Vault Data Factory Linked Service.
        """
        return pulumi.get(self, "key_vault_password")

    @key_vault_password.setter
    def key_vault_password(self, value: Optional[pulumi.Input['LinkedServiceAzureSqlDatabaseKeyVaultPasswordArgs']]):
        pulumi.set(self, "key_vault_password", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the Data Factory Linked Service Azure SQL Database. Changing this forces a new resource to be created. Must be unique within a data factory. See the [Microsoft documentation](https://docs.microsoft.com/azure/data-factory/naming-rules) for all restrictions.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of parameters to associate with the Data Factory Linked Service Azure SQL Database.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter(name="servicePrincipalId")
    def service_principal_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The service principal id in which to authenticate against the Azure SQL Database. Required if `service_principal_key` is set.
        """
        return pulumi.get(self, "service_principal_id")

    @service_principal_id.setter
    def service_principal_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_principal_id", value)

    @property
    @pulumi.getter(name="servicePrincipalKey")
    def service_principal_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The service principal key in which to authenticate against the Azure SQL Database. Required if `service_principal_id` is set.
        """
        return pulumi.get(self, "service_principal_key")

    @service_principal_key.setter
    def service_principal_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_principal_key", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The tenant id or name in which to authenticate against the Azure SQL Database.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="useManagedIdentity")
    def use_managed_identity(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to use the Data Factory's managed identity to authenticate against the Azure SQL Database. Incompatible with `service_principal_id` and `service_principal_key`
        """
        return pulumi.get(self, "use_managed_identity")

    @use_managed_identity.setter
    def use_managed_identity(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "use_managed_identity", value)


@pulumi.type_token("azure:datafactory/linkedServiceAzureSqlDatabase:LinkedServiceAzureSqlDatabase")
class LinkedServiceAzureSqlDatabase(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 annotations: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 connection_string: Optional[pulumi.Input[builtins.str]] = None,
                 credential_name: Optional[pulumi.Input[builtins.str]] = None,
                 data_factory_id: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 integration_runtime_name: Optional[pulumi.Input[builtins.str]] = None,
                 key_vault_connection_string: Optional[pulumi.Input[Union['LinkedServiceAzureSqlDatabaseKeyVaultConnectionStringArgs', 'LinkedServiceAzureSqlDatabaseKeyVaultConnectionStringArgsDict']]] = None,
                 key_vault_password: Optional[pulumi.Input[Union['LinkedServiceAzureSqlDatabaseKeyVaultPasswordArgs', 'LinkedServiceAzureSqlDatabaseKeyVaultPasswordArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 service_principal_id: Optional[pulumi.Input[builtins.str]] = None,
                 service_principal_key: Optional[pulumi.Input[builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[builtins.str]] = None,
                 use_managed_identity: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        """
        Manages a Linked Service (connection) between Azure SQL Database and Azure Data Factory.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_factory = azure.datafactory.Factory("example",
            name="example",
            location=example.location,
            resource_group_name=example.name)
        example_linked_service_azure_sql_database = azure.datafactory.LinkedServiceAzureSqlDatabase("example",
            name="example",
            data_factory_id=example_factory.id,
            connection_string="data source=serverhostname;initial catalog=master;user id=testUser;Password=test;integrated security=False;encrypt=True;connection timeout=30")
        ```

        ## Import

        Data Factory Azure SQL Database Linked Service's can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:datafactory/linkedServiceAzureSqlDatabase:LinkedServiceAzureSqlDatabase example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/example/providers/Microsoft.DataFactory/factories/example/linkedservices/example
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] additional_properties: A map of additional properties to associate with the Data Factory Linked Service Azure SQL Database.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] annotations: List of tags that can be used for describing the Data Factory Linked Service Azure SQL Database.
        :param pulumi.Input[builtins.str] connection_string: The connection string in which to authenticate with Azure SQL Database. Exactly one of either `connection_string` or `key_vault_connection_string` is required.
        :param pulumi.Input[builtins.str] credential_name: The name of a User-assigned Managed Identity. Use this argument to authenticate against the linked resource using a User-assigned Managed Identity.
        :param pulumi.Input[builtins.str] data_factory_id: The Data Factory ID in which to associate the Linked Service with. Changing this forces a new resource.
        :param pulumi.Input[builtins.str] description: The description for the Data Factory Linked Service Azure SQL Database.
        :param pulumi.Input[builtins.str] integration_runtime_name: The integration runtime reference to associate with the Data Factory Linked Service Azure SQL Database.
        :param pulumi.Input[Union['LinkedServiceAzureSqlDatabaseKeyVaultConnectionStringArgs', 'LinkedServiceAzureSqlDatabaseKeyVaultConnectionStringArgsDict']] key_vault_connection_string: A `key_vault_connection_string` block as defined below. Use this argument to store Azure SQL Database connection string in an existing Key Vault. It needs an existing Key Vault Data Factory Linked Service. Exactly one of either `connection_string` or `key_vault_connection_string` is required.
        :param pulumi.Input[Union['LinkedServiceAzureSqlDatabaseKeyVaultPasswordArgs', 'LinkedServiceAzureSqlDatabaseKeyVaultPasswordArgsDict']] key_vault_password: A `key_vault_password` block as defined below. Use this argument to store SQL Server password in an existing Key Vault. It needs an existing Key Vault Data Factory Linked Service.
        :param pulumi.Input[builtins.str] name: Specifies the name of the Data Factory Linked Service Azure SQL Database. Changing this forces a new resource to be created. Must be unique within a data factory. See the [Microsoft documentation](https://docs.microsoft.com/azure/data-factory/naming-rules) for all restrictions.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] parameters: A map of parameters to associate with the Data Factory Linked Service Azure SQL Database.
        :param pulumi.Input[builtins.str] service_principal_id: The service principal id in which to authenticate against the Azure SQL Database. Required if `service_principal_key` is set.
        :param pulumi.Input[builtins.str] service_principal_key: The service principal key in which to authenticate against the Azure SQL Database. Required if `service_principal_id` is set.
        :param pulumi.Input[builtins.str] tenant_id: The tenant id or name in which to authenticate against the Azure SQL Database.
        :param pulumi.Input[builtins.bool] use_managed_identity: Whether to use the Data Factory's managed identity to authenticate against the Azure SQL Database. Incompatible with `service_principal_id` and `service_principal_key`
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LinkedServiceAzureSqlDatabaseArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Linked Service (connection) between Azure SQL Database and Azure Data Factory.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_factory = azure.datafactory.Factory("example",
            name="example",
            location=example.location,
            resource_group_name=example.name)
        example_linked_service_azure_sql_database = azure.datafactory.LinkedServiceAzureSqlDatabase("example",
            name="example",
            data_factory_id=example_factory.id,
            connection_string="data source=serverhostname;initial catalog=master;user id=testUser;Password=test;integrated security=False;encrypt=True;connection timeout=30")
        ```

        ## Import

        Data Factory Azure SQL Database Linked Service's can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:datafactory/linkedServiceAzureSqlDatabase:LinkedServiceAzureSqlDatabase example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/example/providers/Microsoft.DataFactory/factories/example/linkedservices/example
        ```

        :param str resource_name: The name of the resource.
        :param LinkedServiceAzureSqlDatabaseArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LinkedServiceAzureSqlDatabaseArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 annotations: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 connection_string: Optional[pulumi.Input[builtins.str]] = None,
                 credential_name: Optional[pulumi.Input[builtins.str]] = None,
                 data_factory_id: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 integration_runtime_name: Optional[pulumi.Input[builtins.str]] = None,
                 key_vault_connection_string: Optional[pulumi.Input[Union['LinkedServiceAzureSqlDatabaseKeyVaultConnectionStringArgs', 'LinkedServiceAzureSqlDatabaseKeyVaultConnectionStringArgsDict']]] = None,
                 key_vault_password: Optional[pulumi.Input[Union['LinkedServiceAzureSqlDatabaseKeyVaultPasswordArgs', 'LinkedServiceAzureSqlDatabaseKeyVaultPasswordArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 service_principal_id: Optional[pulumi.Input[builtins.str]] = None,
                 service_principal_key: Optional[pulumi.Input[builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[builtins.str]] = None,
                 use_managed_identity: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LinkedServiceAzureSqlDatabaseArgs.__new__(LinkedServiceAzureSqlDatabaseArgs)

            __props__.__dict__["additional_properties"] = additional_properties
            __props__.__dict__["annotations"] = annotations
            __props__.__dict__["connection_string"] = connection_string
            __props__.__dict__["credential_name"] = credential_name
            if data_factory_id is None and not opts.urn:
                raise TypeError("Missing required property 'data_factory_id'")
            __props__.__dict__["data_factory_id"] = data_factory_id
            __props__.__dict__["description"] = description
            __props__.__dict__["integration_runtime_name"] = integration_runtime_name
            __props__.__dict__["key_vault_connection_string"] = key_vault_connection_string
            __props__.__dict__["key_vault_password"] = key_vault_password
            __props__.__dict__["name"] = name
            __props__.__dict__["parameters"] = parameters
            __props__.__dict__["service_principal_id"] = service_principal_id
            __props__.__dict__["service_principal_key"] = service_principal_key
            __props__.__dict__["tenant_id"] = tenant_id
            __props__.__dict__["use_managed_identity"] = use_managed_identity
        super(LinkedServiceAzureSqlDatabase, __self__).__init__(
            'azure:datafactory/linkedServiceAzureSqlDatabase:LinkedServiceAzureSqlDatabase',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            additional_properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            annotations: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            connection_string: Optional[pulumi.Input[builtins.str]] = None,
            credential_name: Optional[pulumi.Input[builtins.str]] = None,
            data_factory_id: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            integration_runtime_name: Optional[pulumi.Input[builtins.str]] = None,
            key_vault_connection_string: Optional[pulumi.Input[Union['LinkedServiceAzureSqlDatabaseKeyVaultConnectionStringArgs', 'LinkedServiceAzureSqlDatabaseKeyVaultConnectionStringArgsDict']]] = None,
            key_vault_password: Optional[pulumi.Input[Union['LinkedServiceAzureSqlDatabaseKeyVaultPasswordArgs', 'LinkedServiceAzureSqlDatabaseKeyVaultPasswordArgsDict']]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            service_principal_id: Optional[pulumi.Input[builtins.str]] = None,
            service_principal_key: Optional[pulumi.Input[builtins.str]] = None,
            tenant_id: Optional[pulumi.Input[builtins.str]] = None,
            use_managed_identity: Optional[pulumi.Input[builtins.bool]] = None) -> 'LinkedServiceAzureSqlDatabase':
        """
        Get an existing LinkedServiceAzureSqlDatabase resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] additional_properties: A map of additional properties to associate with the Data Factory Linked Service Azure SQL Database.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] annotations: List of tags that can be used for describing the Data Factory Linked Service Azure SQL Database.
        :param pulumi.Input[builtins.str] connection_string: The connection string in which to authenticate with Azure SQL Database. Exactly one of either `connection_string` or `key_vault_connection_string` is required.
        :param pulumi.Input[builtins.str] credential_name: The name of a User-assigned Managed Identity. Use this argument to authenticate against the linked resource using a User-assigned Managed Identity.
        :param pulumi.Input[builtins.str] data_factory_id: The Data Factory ID in which to associate the Linked Service with. Changing this forces a new resource.
        :param pulumi.Input[builtins.str] description: The description for the Data Factory Linked Service Azure SQL Database.
        :param pulumi.Input[builtins.str] integration_runtime_name: The integration runtime reference to associate with the Data Factory Linked Service Azure SQL Database.
        :param pulumi.Input[Union['LinkedServiceAzureSqlDatabaseKeyVaultConnectionStringArgs', 'LinkedServiceAzureSqlDatabaseKeyVaultConnectionStringArgsDict']] key_vault_connection_string: A `key_vault_connection_string` block as defined below. Use this argument to store Azure SQL Database connection string in an existing Key Vault. It needs an existing Key Vault Data Factory Linked Service. Exactly one of either `connection_string` or `key_vault_connection_string` is required.
        :param pulumi.Input[Union['LinkedServiceAzureSqlDatabaseKeyVaultPasswordArgs', 'LinkedServiceAzureSqlDatabaseKeyVaultPasswordArgsDict']] key_vault_password: A `key_vault_password` block as defined below. Use this argument to store SQL Server password in an existing Key Vault. It needs an existing Key Vault Data Factory Linked Service.
        :param pulumi.Input[builtins.str] name: Specifies the name of the Data Factory Linked Service Azure SQL Database. Changing this forces a new resource to be created. Must be unique within a data factory. See the [Microsoft documentation](https://docs.microsoft.com/azure/data-factory/naming-rules) for all restrictions.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] parameters: A map of parameters to associate with the Data Factory Linked Service Azure SQL Database.
        :param pulumi.Input[builtins.str] service_principal_id: The service principal id in which to authenticate against the Azure SQL Database. Required if `service_principal_key` is set.
        :param pulumi.Input[builtins.str] service_principal_key: The service principal key in which to authenticate against the Azure SQL Database. Required if `service_principal_id` is set.
        :param pulumi.Input[builtins.str] tenant_id: The tenant id or name in which to authenticate against the Azure SQL Database.
        :param pulumi.Input[builtins.bool] use_managed_identity: Whether to use the Data Factory's managed identity to authenticate against the Azure SQL Database. Incompatible with `service_principal_id` and `service_principal_key`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LinkedServiceAzureSqlDatabaseState.__new__(_LinkedServiceAzureSqlDatabaseState)

        __props__.__dict__["additional_properties"] = additional_properties
        __props__.__dict__["annotations"] = annotations
        __props__.__dict__["connection_string"] = connection_string
        __props__.__dict__["credential_name"] = credential_name
        __props__.__dict__["data_factory_id"] = data_factory_id
        __props__.__dict__["description"] = description
        __props__.__dict__["integration_runtime_name"] = integration_runtime_name
        __props__.__dict__["key_vault_connection_string"] = key_vault_connection_string
        __props__.__dict__["key_vault_password"] = key_vault_password
        __props__.__dict__["name"] = name
        __props__.__dict__["parameters"] = parameters
        __props__.__dict__["service_principal_id"] = service_principal_id
        __props__.__dict__["service_principal_key"] = service_principal_key
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["use_managed_identity"] = use_managed_identity
        return LinkedServiceAzureSqlDatabase(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="additionalProperties")
    def additional_properties(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A map of additional properties to associate with the Data Factory Linked Service Azure SQL Database.
        """
        return pulumi.get(self, "additional_properties")

    @property
    @pulumi.getter
    def annotations(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        List of tags that can be used for describing the Data Factory Linked Service Azure SQL Database.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The connection string in which to authenticate with Azure SQL Database. Exactly one of either `connection_string` or `key_vault_connection_string` is required.
        """
        return pulumi.get(self, "connection_string")

    @property
    @pulumi.getter(name="credentialName")
    def credential_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The name of a User-assigned Managed Identity. Use this argument to authenticate against the linked resource using a User-assigned Managed Identity.
        """
        return pulumi.get(self, "credential_name")

    @property
    @pulumi.getter(name="dataFactoryId")
    def data_factory_id(self) -> pulumi.Output[builtins.str]:
        """
        The Data Factory ID in which to associate the Linked Service with. Changing this forces a new resource.
        """
        return pulumi.get(self, "data_factory_id")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The description for the Data Factory Linked Service Azure SQL Database.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="integrationRuntimeName")
    def integration_runtime_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The integration runtime reference to associate with the Data Factory Linked Service Azure SQL Database.
        """
        return pulumi.get(self, "integration_runtime_name")

    @property
    @pulumi.getter(name="keyVaultConnectionString")
    def key_vault_connection_string(self) -> pulumi.Output[Optional['outputs.LinkedServiceAzureSqlDatabaseKeyVaultConnectionString']]:
        """
        A `key_vault_connection_string` block as defined below. Use this argument to store Azure SQL Database connection string in an existing Key Vault. It needs an existing Key Vault Data Factory Linked Service. Exactly one of either `connection_string` or `key_vault_connection_string` is required.
        """
        return pulumi.get(self, "key_vault_connection_string")

    @property
    @pulumi.getter(name="keyVaultPassword")
    def key_vault_password(self) -> pulumi.Output[Optional['outputs.LinkedServiceAzureSqlDatabaseKeyVaultPassword']]:
        """
        A `key_vault_password` block as defined below. Use this argument to store SQL Server password in an existing Key Vault. It needs an existing Key Vault Data Factory Linked Service.
        """
        return pulumi.get(self, "key_vault_password")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the name of the Data Factory Linked Service Azure SQL Database. Changing this forces a new resource to be created. Must be unique within a data factory. See the [Microsoft documentation](https://docs.microsoft.com/azure/data-factory/naming-rules) for all restrictions.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parameters(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A map of parameters to associate with the Data Factory Linked Service Azure SQL Database.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter(name="servicePrincipalId")
    def service_principal_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The service principal id in which to authenticate against the Azure SQL Database. Required if `service_principal_key` is set.
        """
        return pulumi.get(self, "service_principal_id")

    @property
    @pulumi.getter(name="servicePrincipalKey")
    def service_principal_key(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The service principal key in which to authenticate against the Azure SQL Database. Required if `service_principal_id` is set.
        """
        return pulumi.get(self, "service_principal_key")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The tenant id or name in which to authenticate against the Azure SQL Database.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter(name="useManagedIdentity")
    def use_managed_identity(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether to use the Data Factory's managed identity to authenticate against the Azure SQL Database. Incompatible with `service_principal_id` and `service_principal_key`
        """
        return pulumi.get(self, "use_managed_identity")

