# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['TriggerScheduleArgs', 'TriggerSchedule']

@pulumi.input_type
class TriggerScheduleArgs:
    def __init__(__self__, *,
                 data_factory_id: pulumi.Input[builtins.str],
                 activated: Optional[pulumi.Input[builtins.bool]] = None,
                 annotations: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 end_time: Optional[pulumi.Input[builtins.str]] = None,
                 frequency: Optional[pulumi.Input[builtins.str]] = None,
                 interval: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 pipeline_name: Optional[pulumi.Input[builtins.str]] = None,
                 pipeline_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 pipelines: Optional[pulumi.Input[Sequence[pulumi.Input['TriggerSchedulePipelineArgs']]]] = None,
                 schedule: Optional[pulumi.Input['TriggerScheduleScheduleArgs']] = None,
                 start_time: Optional[pulumi.Input[builtins.str]] = None,
                 time_zone: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a TriggerSchedule resource.
        :param pulumi.Input[builtins.str] data_factory_id: The Data Factory ID in which to associate the Linked Service with. Changing this forces a new resource.
        :param pulumi.Input[builtins.bool] activated: Specifies if the Data Factory Schedule Trigger is activated. Defaults to `true`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] annotations: List of tags that can be used for describing the Data Factory Schedule Trigger.
        :param pulumi.Input[builtins.str] description: The Schedule Trigger's description.
        :param pulumi.Input[builtins.str] end_time: The time the Schedule Trigger should end. The time will be represented in UTC.
        :param pulumi.Input[builtins.str] frequency: The trigger frequency. Valid values include `Minute`, `Hour`, `Day`, `Week`, `Month`. Defaults to `Minute`.
        :param pulumi.Input[builtins.int] interval: The interval for how often the trigger occurs. This defaults to `1`.
        :param pulumi.Input[builtins.str] name: Specifies the name of the Data Factory Schedule Trigger. Changing this forces a new resource to be created. Must be globally unique. See the [Microsoft documentation](https://docs.microsoft.com/azure/data-factory/naming-rules) for all restrictions.
        :param pulumi.Input[builtins.str] pipeline_name: The Data Factory Pipeline name that the trigger will act on.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pipeline_parameters: The pipeline parameters that the trigger will act upon.
        :param pulumi.Input[Sequence[pulumi.Input['TriggerSchedulePipelineArgs']]] pipelines: A `pipeline` block as defined below.
        :param pulumi.Input['TriggerScheduleScheduleArgs'] schedule: A `schedule` block as defined below, which further specifies the recurrence schedule for the trigger. A schedule is capable of limiting or increasing the number of trigger executions specified by the `frequency` and `interval` properties.
        :param pulumi.Input[builtins.str] start_time: The time the Schedule Trigger will start. This defaults to the current time. The time will be represented in UTC.
        :param pulumi.Input[builtins.str] time_zone: The timezone of the start/end time.
        """
        pulumi.set(__self__, "data_factory_id", data_factory_id)
        if activated is not None:
            pulumi.set(__self__, "activated", activated)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if frequency is not None:
            pulumi.set(__self__, "frequency", frequency)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if pipeline_name is not None:
            pulumi.set(__self__, "pipeline_name", pipeline_name)
        if pipeline_parameters is not None:
            pulumi.set(__self__, "pipeline_parameters", pipeline_parameters)
        if pipelines is not None:
            pulumi.set(__self__, "pipelines", pipelines)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)

    @property
    @pulumi.getter(name="dataFactoryId")
    def data_factory_id(self) -> pulumi.Input[builtins.str]:
        """
        The Data Factory ID in which to associate the Linked Service with. Changing this forces a new resource.
        """
        return pulumi.get(self, "data_factory_id")

    @data_factory_id.setter
    def data_factory_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "data_factory_id", value)

    @property
    @pulumi.getter
    def activated(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies if the Data Factory Schedule Trigger is activated. Defaults to `true`.
        """
        return pulumi.get(self, "activated")

    @activated.setter
    def activated(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "activated", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of tags that can be used for describing the Data Factory Schedule Trigger.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Schedule Trigger's description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time the Schedule Trigger should end. The time will be represented in UTC.
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "end_time", value)

    @property
    @pulumi.getter
    def frequency(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The trigger frequency. Valid values include `Minute`, `Hour`, `Day`, `Week`, `Month`. Defaults to `Minute`.
        """
        return pulumi.get(self, "frequency")

    @frequency.setter
    def frequency(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "frequency", value)

    @property
    @pulumi.getter
    def interval(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The interval for how often the trigger occurs. This defaults to `1`.
        """
        return pulumi.get(self, "interval")

    @interval.setter
    def interval(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "interval", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the Data Factory Schedule Trigger. Changing this forces a new resource to be created. Must be globally unique. See the [Microsoft documentation](https://docs.microsoft.com/azure/data-factory/naming-rules) for all restrictions.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="pipelineName")
    def pipeline_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Data Factory Pipeline name that the trigger will act on.
        """
        return pulumi.get(self, "pipeline_name")

    @pipeline_name.setter
    def pipeline_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "pipeline_name", value)

    @property
    @pulumi.getter(name="pipelineParameters")
    def pipeline_parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The pipeline parameters that the trigger will act upon.
        """
        return pulumi.get(self, "pipeline_parameters")

    @pipeline_parameters.setter
    def pipeline_parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "pipeline_parameters", value)

    @property
    @pulumi.getter
    def pipelines(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TriggerSchedulePipelineArgs']]]]:
        """
        A `pipeline` block as defined below.
        """
        return pulumi.get(self, "pipelines")

    @pipelines.setter
    def pipelines(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TriggerSchedulePipelineArgs']]]]):
        pulumi.set(self, "pipelines", value)

    @property
    @pulumi.getter
    def schedule(self) -> Optional[pulumi.Input['TriggerScheduleScheduleArgs']]:
        """
        A `schedule` block as defined below, which further specifies the recurrence schedule for the trigger. A schedule is capable of limiting or increasing the number of trigger executions specified by the `frequency` and `interval` properties.
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: Optional[pulumi.Input['TriggerScheduleScheduleArgs']]):
        pulumi.set(self, "schedule", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time the Schedule Trigger will start. This defaults to the current time. The time will be represented in UTC.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "start_time", value)

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The timezone of the start/end time.
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_zone", value)


@pulumi.input_type
class _TriggerScheduleState:
    def __init__(__self__, *,
                 activated: Optional[pulumi.Input[builtins.bool]] = None,
                 annotations: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 data_factory_id: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 end_time: Optional[pulumi.Input[builtins.str]] = None,
                 frequency: Optional[pulumi.Input[builtins.str]] = None,
                 interval: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 pipeline_name: Optional[pulumi.Input[builtins.str]] = None,
                 pipeline_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 pipelines: Optional[pulumi.Input[Sequence[pulumi.Input['TriggerSchedulePipelineArgs']]]] = None,
                 schedule: Optional[pulumi.Input['TriggerScheduleScheduleArgs']] = None,
                 start_time: Optional[pulumi.Input[builtins.str]] = None,
                 time_zone: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering TriggerSchedule resources.
        :param pulumi.Input[builtins.bool] activated: Specifies if the Data Factory Schedule Trigger is activated. Defaults to `true`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] annotations: List of tags that can be used for describing the Data Factory Schedule Trigger.
        :param pulumi.Input[builtins.str] data_factory_id: The Data Factory ID in which to associate the Linked Service with. Changing this forces a new resource.
        :param pulumi.Input[builtins.str] description: The Schedule Trigger's description.
        :param pulumi.Input[builtins.str] end_time: The time the Schedule Trigger should end. The time will be represented in UTC.
        :param pulumi.Input[builtins.str] frequency: The trigger frequency. Valid values include `Minute`, `Hour`, `Day`, `Week`, `Month`. Defaults to `Minute`.
        :param pulumi.Input[builtins.int] interval: The interval for how often the trigger occurs. This defaults to `1`.
        :param pulumi.Input[builtins.str] name: Specifies the name of the Data Factory Schedule Trigger. Changing this forces a new resource to be created. Must be globally unique. See the [Microsoft documentation](https://docs.microsoft.com/azure/data-factory/naming-rules) for all restrictions.
        :param pulumi.Input[builtins.str] pipeline_name: The Data Factory Pipeline name that the trigger will act on.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pipeline_parameters: The pipeline parameters that the trigger will act upon.
        :param pulumi.Input[Sequence[pulumi.Input['TriggerSchedulePipelineArgs']]] pipelines: A `pipeline` block as defined below.
        :param pulumi.Input['TriggerScheduleScheduleArgs'] schedule: A `schedule` block as defined below, which further specifies the recurrence schedule for the trigger. A schedule is capable of limiting or increasing the number of trigger executions specified by the `frequency` and `interval` properties.
        :param pulumi.Input[builtins.str] start_time: The time the Schedule Trigger will start. This defaults to the current time. The time will be represented in UTC.
        :param pulumi.Input[builtins.str] time_zone: The timezone of the start/end time.
        """
        if activated is not None:
            pulumi.set(__self__, "activated", activated)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if data_factory_id is not None:
            pulumi.set(__self__, "data_factory_id", data_factory_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if frequency is not None:
            pulumi.set(__self__, "frequency", frequency)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if pipeline_name is not None:
            pulumi.set(__self__, "pipeline_name", pipeline_name)
        if pipeline_parameters is not None:
            pulumi.set(__self__, "pipeline_parameters", pipeline_parameters)
        if pipelines is not None:
            pulumi.set(__self__, "pipelines", pipelines)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)

    @property
    @pulumi.getter
    def activated(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies if the Data Factory Schedule Trigger is activated. Defaults to `true`.
        """
        return pulumi.get(self, "activated")

    @activated.setter
    def activated(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "activated", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of tags that can be used for describing the Data Factory Schedule Trigger.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="dataFactoryId")
    def data_factory_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Data Factory ID in which to associate the Linked Service with. Changing this forces a new resource.
        """
        return pulumi.get(self, "data_factory_id")

    @data_factory_id.setter
    def data_factory_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "data_factory_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Schedule Trigger's description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time the Schedule Trigger should end. The time will be represented in UTC.
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "end_time", value)

    @property
    @pulumi.getter
    def frequency(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The trigger frequency. Valid values include `Minute`, `Hour`, `Day`, `Week`, `Month`. Defaults to `Minute`.
        """
        return pulumi.get(self, "frequency")

    @frequency.setter
    def frequency(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "frequency", value)

    @property
    @pulumi.getter
    def interval(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The interval for how often the trigger occurs. This defaults to `1`.
        """
        return pulumi.get(self, "interval")

    @interval.setter
    def interval(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "interval", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the Data Factory Schedule Trigger. Changing this forces a new resource to be created. Must be globally unique. See the [Microsoft documentation](https://docs.microsoft.com/azure/data-factory/naming-rules) for all restrictions.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="pipelineName")
    def pipeline_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Data Factory Pipeline name that the trigger will act on.
        """
        return pulumi.get(self, "pipeline_name")

    @pipeline_name.setter
    def pipeline_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "pipeline_name", value)

    @property
    @pulumi.getter(name="pipelineParameters")
    def pipeline_parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The pipeline parameters that the trigger will act upon.
        """
        return pulumi.get(self, "pipeline_parameters")

    @pipeline_parameters.setter
    def pipeline_parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "pipeline_parameters", value)

    @property
    @pulumi.getter
    def pipelines(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TriggerSchedulePipelineArgs']]]]:
        """
        A `pipeline` block as defined below.
        """
        return pulumi.get(self, "pipelines")

    @pipelines.setter
    def pipelines(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TriggerSchedulePipelineArgs']]]]):
        pulumi.set(self, "pipelines", value)

    @property
    @pulumi.getter
    def schedule(self) -> Optional[pulumi.Input['TriggerScheduleScheduleArgs']]:
        """
        A `schedule` block as defined below, which further specifies the recurrence schedule for the trigger. A schedule is capable of limiting or increasing the number of trigger executions specified by the `frequency` and `interval` properties.
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: Optional[pulumi.Input['TriggerScheduleScheduleArgs']]):
        pulumi.set(self, "schedule", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time the Schedule Trigger will start. This defaults to the current time. The time will be represented in UTC.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "start_time", value)

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The timezone of the start/end time.
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_zone", value)


@pulumi.type_token("azure:datafactory/triggerSchedule:TriggerSchedule")
class TriggerSchedule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 activated: Optional[pulumi.Input[builtins.bool]] = None,
                 annotations: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 data_factory_id: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 end_time: Optional[pulumi.Input[builtins.str]] = None,
                 frequency: Optional[pulumi.Input[builtins.str]] = None,
                 interval: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 pipeline_name: Optional[pulumi.Input[builtins.str]] = None,
                 pipeline_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 pipelines: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TriggerSchedulePipelineArgs', 'TriggerSchedulePipelineArgsDict']]]]] = None,
                 schedule: Optional[pulumi.Input[Union['TriggerScheduleScheduleArgs', 'TriggerScheduleScheduleArgsDict']]] = None,
                 start_time: Optional[pulumi.Input[builtins.str]] = None,
                 time_zone: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages a Trigger Schedule inside a Azure Data Factory.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_factory = azure.datafactory.Factory("example",
            name="example",
            location=example.location,
            resource_group_name=example.name)
        example_pipeline = azure.datafactory.Pipeline("example",
            name="example",
            data_factory_id=example_factory.id)
        example_trigger_schedule = azure.datafactory.TriggerSchedule("example",
            name="example",
            data_factory_id=example_factory.id,
            pipeline_name=example_pipeline.name,
            interval=5,
            frequency="Day")
        ```

        ## Import

        Data Factory Schedule Trigger can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:datafactory/triggerSchedule:TriggerSchedule example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/example/providers/Microsoft.DataFactory/factories/example/triggers/example
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] activated: Specifies if the Data Factory Schedule Trigger is activated. Defaults to `true`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] annotations: List of tags that can be used for describing the Data Factory Schedule Trigger.
        :param pulumi.Input[builtins.str] data_factory_id: The Data Factory ID in which to associate the Linked Service with. Changing this forces a new resource.
        :param pulumi.Input[builtins.str] description: The Schedule Trigger's description.
        :param pulumi.Input[builtins.str] end_time: The time the Schedule Trigger should end. The time will be represented in UTC.
        :param pulumi.Input[builtins.str] frequency: The trigger frequency. Valid values include `Minute`, `Hour`, `Day`, `Week`, `Month`. Defaults to `Minute`.
        :param pulumi.Input[builtins.int] interval: The interval for how often the trigger occurs. This defaults to `1`.
        :param pulumi.Input[builtins.str] name: Specifies the name of the Data Factory Schedule Trigger. Changing this forces a new resource to be created. Must be globally unique. See the [Microsoft documentation](https://docs.microsoft.com/azure/data-factory/naming-rules) for all restrictions.
        :param pulumi.Input[builtins.str] pipeline_name: The Data Factory Pipeline name that the trigger will act on.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pipeline_parameters: The pipeline parameters that the trigger will act upon.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TriggerSchedulePipelineArgs', 'TriggerSchedulePipelineArgsDict']]]] pipelines: A `pipeline` block as defined below.
        :param pulumi.Input[Union['TriggerScheduleScheduleArgs', 'TriggerScheduleScheduleArgsDict']] schedule: A `schedule` block as defined below, which further specifies the recurrence schedule for the trigger. A schedule is capable of limiting or increasing the number of trigger executions specified by the `frequency` and `interval` properties.
        :param pulumi.Input[builtins.str] start_time: The time the Schedule Trigger will start. This defaults to the current time. The time will be represented in UTC.
        :param pulumi.Input[builtins.str] time_zone: The timezone of the start/end time.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TriggerScheduleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Trigger Schedule inside a Azure Data Factory.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_factory = azure.datafactory.Factory("example",
            name="example",
            location=example.location,
            resource_group_name=example.name)
        example_pipeline = azure.datafactory.Pipeline("example",
            name="example",
            data_factory_id=example_factory.id)
        example_trigger_schedule = azure.datafactory.TriggerSchedule("example",
            name="example",
            data_factory_id=example_factory.id,
            pipeline_name=example_pipeline.name,
            interval=5,
            frequency="Day")
        ```

        ## Import

        Data Factory Schedule Trigger can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:datafactory/triggerSchedule:TriggerSchedule example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/example/providers/Microsoft.DataFactory/factories/example/triggers/example
        ```

        :param str resource_name: The name of the resource.
        :param TriggerScheduleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TriggerScheduleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 activated: Optional[pulumi.Input[builtins.bool]] = None,
                 annotations: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 data_factory_id: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 end_time: Optional[pulumi.Input[builtins.str]] = None,
                 frequency: Optional[pulumi.Input[builtins.str]] = None,
                 interval: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 pipeline_name: Optional[pulumi.Input[builtins.str]] = None,
                 pipeline_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 pipelines: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TriggerSchedulePipelineArgs', 'TriggerSchedulePipelineArgsDict']]]]] = None,
                 schedule: Optional[pulumi.Input[Union['TriggerScheduleScheduleArgs', 'TriggerScheduleScheduleArgsDict']]] = None,
                 start_time: Optional[pulumi.Input[builtins.str]] = None,
                 time_zone: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TriggerScheduleArgs.__new__(TriggerScheduleArgs)

            __props__.__dict__["activated"] = activated
            __props__.__dict__["annotations"] = annotations
            if data_factory_id is None and not opts.urn:
                raise TypeError("Missing required property 'data_factory_id'")
            __props__.__dict__["data_factory_id"] = data_factory_id
            __props__.__dict__["description"] = description
            __props__.__dict__["end_time"] = end_time
            __props__.__dict__["frequency"] = frequency
            __props__.__dict__["interval"] = interval
            __props__.__dict__["name"] = name
            __props__.__dict__["pipeline_name"] = pipeline_name
            __props__.__dict__["pipeline_parameters"] = pipeline_parameters
            __props__.__dict__["pipelines"] = pipelines
            __props__.__dict__["schedule"] = schedule
            __props__.__dict__["start_time"] = start_time
            __props__.__dict__["time_zone"] = time_zone
        super(TriggerSchedule, __self__).__init__(
            'azure:datafactory/triggerSchedule:TriggerSchedule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            activated: Optional[pulumi.Input[builtins.bool]] = None,
            annotations: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            data_factory_id: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            end_time: Optional[pulumi.Input[builtins.str]] = None,
            frequency: Optional[pulumi.Input[builtins.str]] = None,
            interval: Optional[pulumi.Input[builtins.int]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            pipeline_name: Optional[pulumi.Input[builtins.str]] = None,
            pipeline_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            pipelines: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TriggerSchedulePipelineArgs', 'TriggerSchedulePipelineArgsDict']]]]] = None,
            schedule: Optional[pulumi.Input[Union['TriggerScheduleScheduleArgs', 'TriggerScheduleScheduleArgsDict']]] = None,
            start_time: Optional[pulumi.Input[builtins.str]] = None,
            time_zone: Optional[pulumi.Input[builtins.str]] = None) -> 'TriggerSchedule':
        """
        Get an existing TriggerSchedule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] activated: Specifies if the Data Factory Schedule Trigger is activated. Defaults to `true`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] annotations: List of tags that can be used for describing the Data Factory Schedule Trigger.
        :param pulumi.Input[builtins.str] data_factory_id: The Data Factory ID in which to associate the Linked Service with. Changing this forces a new resource.
        :param pulumi.Input[builtins.str] description: The Schedule Trigger's description.
        :param pulumi.Input[builtins.str] end_time: The time the Schedule Trigger should end. The time will be represented in UTC.
        :param pulumi.Input[builtins.str] frequency: The trigger frequency. Valid values include `Minute`, `Hour`, `Day`, `Week`, `Month`. Defaults to `Minute`.
        :param pulumi.Input[builtins.int] interval: The interval for how often the trigger occurs. This defaults to `1`.
        :param pulumi.Input[builtins.str] name: Specifies the name of the Data Factory Schedule Trigger. Changing this forces a new resource to be created. Must be globally unique. See the [Microsoft documentation](https://docs.microsoft.com/azure/data-factory/naming-rules) for all restrictions.
        :param pulumi.Input[builtins.str] pipeline_name: The Data Factory Pipeline name that the trigger will act on.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pipeline_parameters: The pipeline parameters that the trigger will act upon.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TriggerSchedulePipelineArgs', 'TriggerSchedulePipelineArgsDict']]]] pipelines: A `pipeline` block as defined below.
        :param pulumi.Input[Union['TriggerScheduleScheduleArgs', 'TriggerScheduleScheduleArgsDict']] schedule: A `schedule` block as defined below, which further specifies the recurrence schedule for the trigger. A schedule is capable of limiting or increasing the number of trigger executions specified by the `frequency` and `interval` properties.
        :param pulumi.Input[builtins.str] start_time: The time the Schedule Trigger will start. This defaults to the current time. The time will be represented in UTC.
        :param pulumi.Input[builtins.str] time_zone: The timezone of the start/end time.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TriggerScheduleState.__new__(_TriggerScheduleState)

        __props__.__dict__["activated"] = activated
        __props__.__dict__["annotations"] = annotations
        __props__.__dict__["data_factory_id"] = data_factory_id
        __props__.__dict__["description"] = description
        __props__.__dict__["end_time"] = end_time
        __props__.__dict__["frequency"] = frequency
        __props__.__dict__["interval"] = interval
        __props__.__dict__["name"] = name
        __props__.__dict__["pipeline_name"] = pipeline_name
        __props__.__dict__["pipeline_parameters"] = pipeline_parameters
        __props__.__dict__["pipelines"] = pipelines
        __props__.__dict__["schedule"] = schedule
        __props__.__dict__["start_time"] = start_time
        __props__.__dict__["time_zone"] = time_zone
        return TriggerSchedule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def activated(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Specifies if the Data Factory Schedule Trigger is activated. Defaults to `true`.
        """
        return pulumi.get(self, "activated")

    @property
    @pulumi.getter
    def annotations(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        List of tags that can be used for describing the Data Factory Schedule Trigger.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter(name="dataFactoryId")
    def data_factory_id(self) -> pulumi.Output[builtins.str]:
        """
        The Data Factory ID in which to associate the Linked Service with. Changing this forces a new resource.
        """
        return pulumi.get(self, "data_factory_id")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Schedule Trigger's description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The time the Schedule Trigger should end. The time will be represented in UTC.
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter
    def frequency(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The trigger frequency. Valid values include `Minute`, `Hour`, `Day`, `Week`, `Month`. Defaults to `Minute`.
        """
        return pulumi.get(self, "frequency")

    @property
    @pulumi.getter
    def interval(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The interval for how often the trigger occurs. This defaults to `1`.
        """
        return pulumi.get(self, "interval")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the name of the Data Factory Schedule Trigger. Changing this forces a new resource to be created. Must be globally unique. See the [Microsoft documentation](https://docs.microsoft.com/azure/data-factory/naming-rules) for all restrictions.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="pipelineName")
    def pipeline_name(self) -> pulumi.Output[builtins.str]:
        """
        The Data Factory Pipeline name that the trigger will act on.
        """
        return pulumi.get(self, "pipeline_name")

    @property
    @pulumi.getter(name="pipelineParameters")
    def pipeline_parameters(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        The pipeline parameters that the trigger will act upon.
        """
        return pulumi.get(self, "pipeline_parameters")

    @property
    @pulumi.getter
    def pipelines(self) -> pulumi.Output[Sequence['outputs.TriggerSchedulePipeline']]:
        """
        A `pipeline` block as defined below.
        """
        return pulumi.get(self, "pipelines")

    @property
    @pulumi.getter
    def schedule(self) -> pulumi.Output[Optional['outputs.TriggerScheduleSchedule']]:
        """
        A `schedule` block as defined below, which further specifies the recurrence schedule for the trigger. A schedule is capable of limiting or increasing the number of trigger executions specified by the `frequency` and `interval` properties.
        """
        return pulumi.get(self, "schedule")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> pulumi.Output[builtins.str]:
        """
        The time the Schedule Trigger will start. This defaults to the current time. The time will be represented in UTC.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The timezone of the start/end time.
        """
        return pulumi.get(self, "time_zone")

