# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['TriggerTumblingWindowArgs', 'TriggerTumblingWindow']

@pulumi.input_type
class TriggerTumblingWindowArgs:
    def __init__(__self__, *,
                 data_factory_id: pulumi.Input[builtins.str],
                 frequency: pulumi.Input[builtins.str],
                 interval: pulumi.Input[builtins.int],
                 pipeline: pulumi.Input['TriggerTumblingWindowPipelineArgs'],
                 start_time: pulumi.Input[builtins.str],
                 activated: Optional[pulumi.Input[builtins.bool]] = None,
                 additional_properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 annotations: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 delay: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 end_time: Optional[pulumi.Input[builtins.str]] = None,
                 max_concurrency: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 retry: Optional[pulumi.Input['TriggerTumblingWindowRetryArgs']] = None,
                 trigger_dependencies: Optional[pulumi.Input[Sequence[pulumi.Input['TriggerTumblingWindowTriggerDependencyArgs']]]] = None):
        """
        The set of arguments for constructing a TriggerTumblingWindow resource.
        :param pulumi.Input[builtins.str] data_factory_id: The ID of Data Factory in which to associate the Trigger with. Changing this forces a new resource.
        :param pulumi.Input[builtins.str] frequency: Specifies the frequency of Tumbling Window. Possible values are `Hour`, `Minute` and `Month`. Changing this forces a new resource.
        :param pulumi.Input[builtins.int] interval: Specifies the interval of Tumbling Window. Changing this forces a new resource.
        :param pulumi.Input['TriggerTumblingWindowPipelineArgs'] pipeline: A `pipeline` block as defined below.
        :param pulumi.Input[builtins.str] start_time: Specifies the start time of Tumbling Window, formatted as an RFC3339 string. Changing this forces a new resource.
        :param pulumi.Input[builtins.bool] activated: Specifies if the Data Factory Tumbling Window Trigger is activated. Defaults to `true`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] additional_properties: A map of additional properties to associate with the Data Factory Tumbling Window Trigger.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] annotations: List of tags that can be used for describing the Data Factory Tumbling Window Trigger.
        :param pulumi.Input[builtins.str] delay: Specifies how long the trigger waits before triggering new run. formatted as an `D.HH:MM:SS`.
        :param pulumi.Input[builtins.str] description: The description for the Data Factory Tumbling Window Trigger.
        :param pulumi.Input[builtins.str] end_time: Specifies the end time of Tumbling Window, formatted as an RFC3339 string.
        :param pulumi.Input[builtins.int] max_concurrency: The max number for simultaneous trigger run fired by Tumbling Window. Possible values are between `1` and `50`. Defaults to `50`.
        :param pulumi.Input[builtins.str] name: Specifies the name of the Data Factory Tumbling Window Trigger. Changing this forces a new resource to be created.
        :param pulumi.Input['TriggerTumblingWindowRetryArgs'] retry: A `retry` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['TriggerTumblingWindowTriggerDependencyArgs']]] trigger_dependencies: One or more `trigger_dependency` block as defined below.
        """
        pulumi.set(__self__, "data_factory_id", data_factory_id)
        pulumi.set(__self__, "frequency", frequency)
        pulumi.set(__self__, "interval", interval)
        pulumi.set(__self__, "pipeline", pipeline)
        pulumi.set(__self__, "start_time", start_time)
        if activated is not None:
            pulumi.set(__self__, "activated", activated)
        if additional_properties is not None:
            pulumi.set(__self__, "additional_properties", additional_properties)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if delay is not None:
            pulumi.set(__self__, "delay", delay)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if max_concurrency is not None:
            pulumi.set(__self__, "max_concurrency", max_concurrency)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if retry is not None:
            pulumi.set(__self__, "retry", retry)
        if trigger_dependencies is not None:
            pulumi.set(__self__, "trigger_dependencies", trigger_dependencies)

    @property
    @pulumi.getter(name="dataFactoryId")
    def data_factory_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of Data Factory in which to associate the Trigger with. Changing this forces a new resource.
        """
        return pulumi.get(self, "data_factory_id")

    @data_factory_id.setter
    def data_factory_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "data_factory_id", value)

    @property
    @pulumi.getter
    def frequency(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the frequency of Tumbling Window. Possible values are `Hour`, `Minute` and `Month`. Changing this forces a new resource.
        """
        return pulumi.get(self, "frequency")

    @frequency.setter
    def frequency(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "frequency", value)

    @property
    @pulumi.getter
    def interval(self) -> pulumi.Input[builtins.int]:
        """
        Specifies the interval of Tumbling Window. Changing this forces a new resource.
        """
        return pulumi.get(self, "interval")

    @interval.setter
    def interval(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "interval", value)

    @property
    @pulumi.getter
    def pipeline(self) -> pulumi.Input['TriggerTumblingWindowPipelineArgs']:
        """
        A `pipeline` block as defined below.
        """
        return pulumi.get(self, "pipeline")

    @pipeline.setter
    def pipeline(self, value: pulumi.Input['TriggerTumblingWindowPipelineArgs']):
        pulumi.set(self, "pipeline", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the start time of Tumbling Window, formatted as an RFC3339 string. Changing this forces a new resource.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "start_time", value)

    @property
    @pulumi.getter
    def activated(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies if the Data Factory Tumbling Window Trigger is activated. Defaults to `true`.
        """
        return pulumi.get(self, "activated")

    @activated.setter
    def activated(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "activated", value)

    @property
    @pulumi.getter(name="additionalProperties")
    def additional_properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of additional properties to associate with the Data Factory Tumbling Window Trigger.
        """
        return pulumi.get(self, "additional_properties")

    @additional_properties.setter
    def additional_properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "additional_properties", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of tags that can be used for describing the Data Factory Tumbling Window Trigger.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter
    def delay(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies how long the trigger waits before triggering new run. formatted as an `D.HH:MM:SS`.
        """
        return pulumi.get(self, "delay")

    @delay.setter
    def delay(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "delay", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description for the Data Factory Tumbling Window Trigger.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the end time of Tumbling Window, formatted as an RFC3339 string.
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "end_time", value)

    @property
    @pulumi.getter(name="maxConcurrency")
    def max_concurrency(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The max number for simultaneous trigger run fired by Tumbling Window. Possible values are between `1` and `50`. Defaults to `50`.
        """
        return pulumi.get(self, "max_concurrency")

    @max_concurrency.setter
    def max_concurrency(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_concurrency", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the Data Factory Tumbling Window Trigger. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def retry(self) -> Optional[pulumi.Input['TriggerTumblingWindowRetryArgs']]:
        """
        A `retry` block as defined below.
        """
        return pulumi.get(self, "retry")

    @retry.setter
    def retry(self, value: Optional[pulumi.Input['TriggerTumblingWindowRetryArgs']]):
        pulumi.set(self, "retry", value)

    @property
    @pulumi.getter(name="triggerDependencies")
    def trigger_dependencies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TriggerTumblingWindowTriggerDependencyArgs']]]]:
        """
        One or more `trigger_dependency` block as defined below.
        """
        return pulumi.get(self, "trigger_dependencies")

    @trigger_dependencies.setter
    def trigger_dependencies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TriggerTumblingWindowTriggerDependencyArgs']]]]):
        pulumi.set(self, "trigger_dependencies", value)


@pulumi.input_type
class _TriggerTumblingWindowState:
    def __init__(__self__, *,
                 activated: Optional[pulumi.Input[builtins.bool]] = None,
                 additional_properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 annotations: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 data_factory_id: Optional[pulumi.Input[builtins.str]] = None,
                 delay: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 end_time: Optional[pulumi.Input[builtins.str]] = None,
                 frequency: Optional[pulumi.Input[builtins.str]] = None,
                 interval: Optional[pulumi.Input[builtins.int]] = None,
                 max_concurrency: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 pipeline: Optional[pulumi.Input['TriggerTumblingWindowPipelineArgs']] = None,
                 retry: Optional[pulumi.Input['TriggerTumblingWindowRetryArgs']] = None,
                 start_time: Optional[pulumi.Input[builtins.str]] = None,
                 trigger_dependencies: Optional[pulumi.Input[Sequence[pulumi.Input['TriggerTumblingWindowTriggerDependencyArgs']]]] = None):
        """
        Input properties used for looking up and filtering TriggerTumblingWindow resources.
        :param pulumi.Input[builtins.bool] activated: Specifies if the Data Factory Tumbling Window Trigger is activated. Defaults to `true`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] additional_properties: A map of additional properties to associate with the Data Factory Tumbling Window Trigger.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] annotations: List of tags that can be used for describing the Data Factory Tumbling Window Trigger.
        :param pulumi.Input[builtins.str] data_factory_id: The ID of Data Factory in which to associate the Trigger with. Changing this forces a new resource.
        :param pulumi.Input[builtins.str] delay: Specifies how long the trigger waits before triggering new run. formatted as an `D.HH:MM:SS`.
        :param pulumi.Input[builtins.str] description: The description for the Data Factory Tumbling Window Trigger.
        :param pulumi.Input[builtins.str] end_time: Specifies the end time of Tumbling Window, formatted as an RFC3339 string.
        :param pulumi.Input[builtins.str] frequency: Specifies the frequency of Tumbling Window. Possible values are `Hour`, `Minute` and `Month`. Changing this forces a new resource.
        :param pulumi.Input[builtins.int] interval: Specifies the interval of Tumbling Window. Changing this forces a new resource.
        :param pulumi.Input[builtins.int] max_concurrency: The max number for simultaneous trigger run fired by Tumbling Window. Possible values are between `1` and `50`. Defaults to `50`.
        :param pulumi.Input[builtins.str] name: Specifies the name of the Data Factory Tumbling Window Trigger. Changing this forces a new resource to be created.
        :param pulumi.Input['TriggerTumblingWindowPipelineArgs'] pipeline: A `pipeline` block as defined below.
        :param pulumi.Input['TriggerTumblingWindowRetryArgs'] retry: A `retry` block as defined below.
        :param pulumi.Input[builtins.str] start_time: Specifies the start time of Tumbling Window, formatted as an RFC3339 string. Changing this forces a new resource.
        :param pulumi.Input[Sequence[pulumi.Input['TriggerTumblingWindowTriggerDependencyArgs']]] trigger_dependencies: One or more `trigger_dependency` block as defined below.
        """
        if activated is not None:
            pulumi.set(__self__, "activated", activated)
        if additional_properties is not None:
            pulumi.set(__self__, "additional_properties", additional_properties)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if data_factory_id is not None:
            pulumi.set(__self__, "data_factory_id", data_factory_id)
        if delay is not None:
            pulumi.set(__self__, "delay", delay)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if frequency is not None:
            pulumi.set(__self__, "frequency", frequency)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if max_concurrency is not None:
            pulumi.set(__self__, "max_concurrency", max_concurrency)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if pipeline is not None:
            pulumi.set(__self__, "pipeline", pipeline)
        if retry is not None:
            pulumi.set(__self__, "retry", retry)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if trigger_dependencies is not None:
            pulumi.set(__self__, "trigger_dependencies", trigger_dependencies)

    @property
    @pulumi.getter
    def activated(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies if the Data Factory Tumbling Window Trigger is activated. Defaults to `true`.
        """
        return pulumi.get(self, "activated")

    @activated.setter
    def activated(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "activated", value)

    @property
    @pulumi.getter(name="additionalProperties")
    def additional_properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of additional properties to associate with the Data Factory Tumbling Window Trigger.
        """
        return pulumi.get(self, "additional_properties")

    @additional_properties.setter
    def additional_properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "additional_properties", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of tags that can be used for describing the Data Factory Tumbling Window Trigger.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="dataFactoryId")
    def data_factory_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of Data Factory in which to associate the Trigger with. Changing this forces a new resource.
        """
        return pulumi.get(self, "data_factory_id")

    @data_factory_id.setter
    def data_factory_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "data_factory_id", value)

    @property
    @pulumi.getter
    def delay(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies how long the trigger waits before triggering new run. formatted as an `D.HH:MM:SS`.
        """
        return pulumi.get(self, "delay")

    @delay.setter
    def delay(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "delay", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description for the Data Factory Tumbling Window Trigger.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the end time of Tumbling Window, formatted as an RFC3339 string.
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "end_time", value)

    @property
    @pulumi.getter
    def frequency(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the frequency of Tumbling Window. Possible values are `Hour`, `Minute` and `Month`. Changing this forces a new resource.
        """
        return pulumi.get(self, "frequency")

    @frequency.setter
    def frequency(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "frequency", value)

    @property
    @pulumi.getter
    def interval(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the interval of Tumbling Window. Changing this forces a new resource.
        """
        return pulumi.get(self, "interval")

    @interval.setter
    def interval(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "interval", value)

    @property
    @pulumi.getter(name="maxConcurrency")
    def max_concurrency(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The max number for simultaneous trigger run fired by Tumbling Window. Possible values are between `1` and `50`. Defaults to `50`.
        """
        return pulumi.get(self, "max_concurrency")

    @max_concurrency.setter
    def max_concurrency(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_concurrency", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the Data Factory Tumbling Window Trigger. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def pipeline(self) -> Optional[pulumi.Input['TriggerTumblingWindowPipelineArgs']]:
        """
        A `pipeline` block as defined below.
        """
        return pulumi.get(self, "pipeline")

    @pipeline.setter
    def pipeline(self, value: Optional[pulumi.Input['TriggerTumblingWindowPipelineArgs']]):
        pulumi.set(self, "pipeline", value)

    @property
    @pulumi.getter
    def retry(self) -> Optional[pulumi.Input['TriggerTumblingWindowRetryArgs']]:
        """
        A `retry` block as defined below.
        """
        return pulumi.get(self, "retry")

    @retry.setter
    def retry(self, value: Optional[pulumi.Input['TriggerTumblingWindowRetryArgs']]):
        pulumi.set(self, "retry", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the start time of Tumbling Window, formatted as an RFC3339 string. Changing this forces a new resource.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "start_time", value)

    @property
    @pulumi.getter(name="triggerDependencies")
    def trigger_dependencies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TriggerTumblingWindowTriggerDependencyArgs']]]]:
        """
        One or more `trigger_dependency` block as defined below.
        """
        return pulumi.get(self, "trigger_dependencies")

    @trigger_dependencies.setter
    def trigger_dependencies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TriggerTumblingWindowTriggerDependencyArgs']]]]):
        pulumi.set(self, "trigger_dependencies", value)


@pulumi.type_token("azure:datafactory/triggerTumblingWindow:TriggerTumblingWindow")
class TriggerTumblingWindow(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 activated: Optional[pulumi.Input[builtins.bool]] = None,
                 additional_properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 annotations: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 data_factory_id: Optional[pulumi.Input[builtins.str]] = None,
                 delay: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 end_time: Optional[pulumi.Input[builtins.str]] = None,
                 frequency: Optional[pulumi.Input[builtins.str]] = None,
                 interval: Optional[pulumi.Input[builtins.int]] = None,
                 max_concurrency: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 pipeline: Optional[pulumi.Input[Union['TriggerTumblingWindowPipelineArgs', 'TriggerTumblingWindowPipelineArgsDict']]] = None,
                 retry: Optional[pulumi.Input[Union['TriggerTumblingWindowRetryArgs', 'TriggerTumblingWindowRetryArgsDict']]] = None,
                 start_time: Optional[pulumi.Input[builtins.str]] = None,
                 trigger_dependencies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TriggerTumblingWindowTriggerDependencyArgs', 'TriggerTumblingWindowTriggerDependencyArgsDict']]]]] = None,
                 __props__=None):
        """
        Manages a Tumbling Window Trigger inside an Azure Data Factory.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_factory = azure.datafactory.Factory("example",
            name="example",
            location=example.location,
            resource_group_name=example.name)
        example_pipeline = azure.datafactory.Pipeline("example",
            name="example",
            data_factory_id=example_factory.id)
        example_trigger_tumbling_window = azure.datafactory.TriggerTumblingWindow("example",
            name="example",
            data_factory_id=example_factory.id,
            start_time="2022-09-21T00:00:00Z",
            end_time="2022-09-21T08:00:00Z",
            frequency="Minute",
            interval=15,
            delay="16:00:00",
            annotations=[
                "example1",
                "example2",
                "example3",
            ],
            description="example description",
            retry={
                "count": 1,
                "interval": 30,
            },
            pipeline={
                "name": example_pipeline.name,
                "parameters": {
                    "Env": "Prod",
                },
            },
            trigger_dependencies=[{
                "size": "24:00:00",
                "offset": "-24:00:00",
            }],
            additional_properties={
                "foo": "value1",
                "bar": "value2",
            })
        ```

        ## Import

        Data Factory Tumbling Window Trigger can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:datafactory/triggerTumblingWindow:TriggerTumblingWindow example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/example/providers/Microsoft.DataFactory/factories/example/triggers/example
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] activated: Specifies if the Data Factory Tumbling Window Trigger is activated. Defaults to `true`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] additional_properties: A map of additional properties to associate with the Data Factory Tumbling Window Trigger.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] annotations: List of tags that can be used for describing the Data Factory Tumbling Window Trigger.
        :param pulumi.Input[builtins.str] data_factory_id: The ID of Data Factory in which to associate the Trigger with. Changing this forces a new resource.
        :param pulumi.Input[builtins.str] delay: Specifies how long the trigger waits before triggering new run. formatted as an `D.HH:MM:SS`.
        :param pulumi.Input[builtins.str] description: The description for the Data Factory Tumbling Window Trigger.
        :param pulumi.Input[builtins.str] end_time: Specifies the end time of Tumbling Window, formatted as an RFC3339 string.
        :param pulumi.Input[builtins.str] frequency: Specifies the frequency of Tumbling Window. Possible values are `Hour`, `Minute` and `Month`. Changing this forces a new resource.
        :param pulumi.Input[builtins.int] interval: Specifies the interval of Tumbling Window. Changing this forces a new resource.
        :param pulumi.Input[builtins.int] max_concurrency: The max number for simultaneous trigger run fired by Tumbling Window. Possible values are between `1` and `50`. Defaults to `50`.
        :param pulumi.Input[builtins.str] name: Specifies the name of the Data Factory Tumbling Window Trigger. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['TriggerTumblingWindowPipelineArgs', 'TriggerTumblingWindowPipelineArgsDict']] pipeline: A `pipeline` block as defined below.
        :param pulumi.Input[Union['TriggerTumblingWindowRetryArgs', 'TriggerTumblingWindowRetryArgsDict']] retry: A `retry` block as defined below.
        :param pulumi.Input[builtins.str] start_time: Specifies the start time of Tumbling Window, formatted as an RFC3339 string. Changing this forces a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TriggerTumblingWindowTriggerDependencyArgs', 'TriggerTumblingWindowTriggerDependencyArgsDict']]]] trigger_dependencies: One or more `trigger_dependency` block as defined below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TriggerTumblingWindowArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Tumbling Window Trigger inside an Azure Data Factory.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_factory = azure.datafactory.Factory("example",
            name="example",
            location=example.location,
            resource_group_name=example.name)
        example_pipeline = azure.datafactory.Pipeline("example",
            name="example",
            data_factory_id=example_factory.id)
        example_trigger_tumbling_window = azure.datafactory.TriggerTumblingWindow("example",
            name="example",
            data_factory_id=example_factory.id,
            start_time="2022-09-21T00:00:00Z",
            end_time="2022-09-21T08:00:00Z",
            frequency="Minute",
            interval=15,
            delay="16:00:00",
            annotations=[
                "example1",
                "example2",
                "example3",
            ],
            description="example description",
            retry={
                "count": 1,
                "interval": 30,
            },
            pipeline={
                "name": example_pipeline.name,
                "parameters": {
                    "Env": "Prod",
                },
            },
            trigger_dependencies=[{
                "size": "24:00:00",
                "offset": "-24:00:00",
            }],
            additional_properties={
                "foo": "value1",
                "bar": "value2",
            })
        ```

        ## Import

        Data Factory Tumbling Window Trigger can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:datafactory/triggerTumblingWindow:TriggerTumblingWindow example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/example/providers/Microsoft.DataFactory/factories/example/triggers/example
        ```

        :param str resource_name: The name of the resource.
        :param TriggerTumblingWindowArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TriggerTumblingWindowArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 activated: Optional[pulumi.Input[builtins.bool]] = None,
                 additional_properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 annotations: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 data_factory_id: Optional[pulumi.Input[builtins.str]] = None,
                 delay: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 end_time: Optional[pulumi.Input[builtins.str]] = None,
                 frequency: Optional[pulumi.Input[builtins.str]] = None,
                 interval: Optional[pulumi.Input[builtins.int]] = None,
                 max_concurrency: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 pipeline: Optional[pulumi.Input[Union['TriggerTumblingWindowPipelineArgs', 'TriggerTumblingWindowPipelineArgsDict']]] = None,
                 retry: Optional[pulumi.Input[Union['TriggerTumblingWindowRetryArgs', 'TriggerTumblingWindowRetryArgsDict']]] = None,
                 start_time: Optional[pulumi.Input[builtins.str]] = None,
                 trigger_dependencies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TriggerTumblingWindowTriggerDependencyArgs', 'TriggerTumblingWindowTriggerDependencyArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TriggerTumblingWindowArgs.__new__(TriggerTumblingWindowArgs)

            __props__.__dict__["activated"] = activated
            __props__.__dict__["additional_properties"] = additional_properties
            __props__.__dict__["annotations"] = annotations
            if data_factory_id is None and not opts.urn:
                raise TypeError("Missing required property 'data_factory_id'")
            __props__.__dict__["data_factory_id"] = data_factory_id
            __props__.__dict__["delay"] = delay
            __props__.__dict__["description"] = description
            __props__.__dict__["end_time"] = end_time
            if frequency is None and not opts.urn:
                raise TypeError("Missing required property 'frequency'")
            __props__.__dict__["frequency"] = frequency
            if interval is None and not opts.urn:
                raise TypeError("Missing required property 'interval'")
            __props__.__dict__["interval"] = interval
            __props__.__dict__["max_concurrency"] = max_concurrency
            __props__.__dict__["name"] = name
            if pipeline is None and not opts.urn:
                raise TypeError("Missing required property 'pipeline'")
            __props__.__dict__["pipeline"] = pipeline
            __props__.__dict__["retry"] = retry
            if start_time is None and not opts.urn:
                raise TypeError("Missing required property 'start_time'")
            __props__.__dict__["start_time"] = start_time
            __props__.__dict__["trigger_dependencies"] = trigger_dependencies
        super(TriggerTumblingWindow, __self__).__init__(
            'azure:datafactory/triggerTumblingWindow:TriggerTumblingWindow',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            activated: Optional[pulumi.Input[builtins.bool]] = None,
            additional_properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            annotations: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            data_factory_id: Optional[pulumi.Input[builtins.str]] = None,
            delay: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            end_time: Optional[pulumi.Input[builtins.str]] = None,
            frequency: Optional[pulumi.Input[builtins.str]] = None,
            interval: Optional[pulumi.Input[builtins.int]] = None,
            max_concurrency: Optional[pulumi.Input[builtins.int]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            pipeline: Optional[pulumi.Input[Union['TriggerTumblingWindowPipelineArgs', 'TriggerTumblingWindowPipelineArgsDict']]] = None,
            retry: Optional[pulumi.Input[Union['TriggerTumblingWindowRetryArgs', 'TriggerTumblingWindowRetryArgsDict']]] = None,
            start_time: Optional[pulumi.Input[builtins.str]] = None,
            trigger_dependencies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TriggerTumblingWindowTriggerDependencyArgs', 'TriggerTumblingWindowTriggerDependencyArgsDict']]]]] = None) -> 'TriggerTumblingWindow':
        """
        Get an existing TriggerTumblingWindow resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] activated: Specifies if the Data Factory Tumbling Window Trigger is activated. Defaults to `true`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] additional_properties: A map of additional properties to associate with the Data Factory Tumbling Window Trigger.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] annotations: List of tags that can be used for describing the Data Factory Tumbling Window Trigger.
        :param pulumi.Input[builtins.str] data_factory_id: The ID of Data Factory in which to associate the Trigger with. Changing this forces a new resource.
        :param pulumi.Input[builtins.str] delay: Specifies how long the trigger waits before triggering new run. formatted as an `D.HH:MM:SS`.
        :param pulumi.Input[builtins.str] description: The description for the Data Factory Tumbling Window Trigger.
        :param pulumi.Input[builtins.str] end_time: Specifies the end time of Tumbling Window, formatted as an RFC3339 string.
        :param pulumi.Input[builtins.str] frequency: Specifies the frequency of Tumbling Window. Possible values are `Hour`, `Minute` and `Month`. Changing this forces a new resource.
        :param pulumi.Input[builtins.int] interval: Specifies the interval of Tumbling Window. Changing this forces a new resource.
        :param pulumi.Input[builtins.int] max_concurrency: The max number for simultaneous trigger run fired by Tumbling Window. Possible values are between `1` and `50`. Defaults to `50`.
        :param pulumi.Input[builtins.str] name: Specifies the name of the Data Factory Tumbling Window Trigger. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['TriggerTumblingWindowPipelineArgs', 'TriggerTumblingWindowPipelineArgsDict']] pipeline: A `pipeline` block as defined below.
        :param pulumi.Input[Union['TriggerTumblingWindowRetryArgs', 'TriggerTumblingWindowRetryArgsDict']] retry: A `retry` block as defined below.
        :param pulumi.Input[builtins.str] start_time: Specifies the start time of Tumbling Window, formatted as an RFC3339 string. Changing this forces a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TriggerTumblingWindowTriggerDependencyArgs', 'TriggerTumblingWindowTriggerDependencyArgsDict']]]] trigger_dependencies: One or more `trigger_dependency` block as defined below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TriggerTumblingWindowState.__new__(_TriggerTumblingWindowState)

        __props__.__dict__["activated"] = activated
        __props__.__dict__["additional_properties"] = additional_properties
        __props__.__dict__["annotations"] = annotations
        __props__.__dict__["data_factory_id"] = data_factory_id
        __props__.__dict__["delay"] = delay
        __props__.__dict__["description"] = description
        __props__.__dict__["end_time"] = end_time
        __props__.__dict__["frequency"] = frequency
        __props__.__dict__["interval"] = interval
        __props__.__dict__["max_concurrency"] = max_concurrency
        __props__.__dict__["name"] = name
        __props__.__dict__["pipeline"] = pipeline
        __props__.__dict__["retry"] = retry
        __props__.__dict__["start_time"] = start_time
        __props__.__dict__["trigger_dependencies"] = trigger_dependencies
        return TriggerTumblingWindow(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def activated(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Specifies if the Data Factory Tumbling Window Trigger is activated. Defaults to `true`.
        """
        return pulumi.get(self, "activated")

    @property
    @pulumi.getter(name="additionalProperties")
    def additional_properties(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A map of additional properties to associate with the Data Factory Tumbling Window Trigger.
        """
        return pulumi.get(self, "additional_properties")

    @property
    @pulumi.getter
    def annotations(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        List of tags that can be used for describing the Data Factory Tumbling Window Trigger.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter(name="dataFactoryId")
    def data_factory_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of Data Factory in which to associate the Trigger with. Changing this forces a new resource.
        """
        return pulumi.get(self, "data_factory_id")

    @property
    @pulumi.getter
    def delay(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies how long the trigger waits before triggering new run. formatted as an `D.HH:MM:SS`.
        """
        return pulumi.get(self, "delay")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The description for the Data Factory Tumbling Window Trigger.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies the end time of Tumbling Window, formatted as an RFC3339 string.
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter
    def frequency(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the frequency of Tumbling Window. Possible values are `Hour`, `Minute` and `Month`. Changing this forces a new resource.
        """
        return pulumi.get(self, "frequency")

    @property
    @pulumi.getter
    def interval(self) -> pulumi.Output[builtins.int]:
        """
        Specifies the interval of Tumbling Window. Changing this forces a new resource.
        """
        return pulumi.get(self, "interval")

    @property
    @pulumi.getter(name="maxConcurrency")
    def max_concurrency(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The max number for simultaneous trigger run fired by Tumbling Window. Possible values are between `1` and `50`. Defaults to `50`.
        """
        return pulumi.get(self, "max_concurrency")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the name of the Data Factory Tumbling Window Trigger. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def pipeline(self) -> pulumi.Output['outputs.TriggerTumblingWindowPipeline']:
        """
        A `pipeline` block as defined below.
        """
        return pulumi.get(self, "pipeline")

    @property
    @pulumi.getter
    def retry(self) -> pulumi.Output[Optional['outputs.TriggerTumblingWindowRetry']]:
        """
        A `retry` block as defined below.
        """
        return pulumi.get(self, "retry")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the start time of Tumbling Window, formatted as an RFC3339 string. Changing this forces a new resource.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter(name="triggerDependencies")
    def trigger_dependencies(self) -> pulumi.Output[Optional[Sequence['outputs.TriggerTumblingWindowTriggerDependency']]]:
        """
        One or more `trigger_dependency` block as defined below.
        """
        return pulumi.get(self, "trigger_dependencies")

