# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['BackupPolicyMysqlFlexibleServerArgs', 'BackupPolicyMysqlFlexibleServer']

@pulumi.input_type
class BackupPolicyMysqlFlexibleServerArgs:
    def __init__(__self__, *,
                 backup_repeating_time_intervals: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 default_retention_rule: pulumi.Input['BackupPolicyMysqlFlexibleServerDefaultRetentionRuleArgs'],
                 vault_id: pulumi.Input[builtins.str],
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 retention_rules: Optional[pulumi.Input[Sequence[pulumi.Input['BackupPolicyMysqlFlexibleServerRetentionRuleArgs']]]] = None,
                 time_zone: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a BackupPolicyMysqlFlexibleServer resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] backup_repeating_time_intervals: Specifies a list of repeating time interval. It supports weekly back. It should follow `ISO 8601` repeating time interval format. Changing this forces a new resource to be created.
        :param pulumi.Input['BackupPolicyMysqlFlexibleServerDefaultRetentionRuleArgs'] default_retention_rule: A `default_retention_rule` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] vault_id: The ID of the Backup Vault where the Backup Policy MySQL Flexible Server should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name of the Backup Policy for the MySQL Flexible Server. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input['BackupPolicyMysqlFlexibleServerRetentionRuleArgs']]] retention_rules: One or more `retention_rule` blocks as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] time_zone: Specifies the Time Zone which should be used by the backup schedule. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "backup_repeating_time_intervals", backup_repeating_time_intervals)
        pulumi.set(__self__, "default_retention_rule", default_retention_rule)
        pulumi.set(__self__, "vault_id", vault_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if retention_rules is not None:
            pulumi.set(__self__, "retention_rules", retention_rules)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)

    @property
    @pulumi.getter(name="backupRepeatingTimeIntervals")
    def backup_repeating_time_intervals(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        Specifies a list of repeating time interval. It supports weekly back. It should follow `ISO 8601` repeating time interval format. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "backup_repeating_time_intervals")

    @backup_repeating_time_intervals.setter
    def backup_repeating_time_intervals(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "backup_repeating_time_intervals", value)

    @property
    @pulumi.getter(name="defaultRetentionRule")
    def default_retention_rule(self) -> pulumi.Input['BackupPolicyMysqlFlexibleServerDefaultRetentionRuleArgs']:
        """
        A `default_retention_rule` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "default_retention_rule")

    @default_retention_rule.setter
    def default_retention_rule(self, value: pulumi.Input['BackupPolicyMysqlFlexibleServerDefaultRetentionRuleArgs']):
        pulumi.set(self, "default_retention_rule", value)

    @property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the Backup Vault where the Backup Policy MySQL Flexible Server should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "vault_id")

    @vault_id.setter
    def vault_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "vault_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the Backup Policy for the MySQL Flexible Server. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="retentionRules")
    def retention_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BackupPolicyMysqlFlexibleServerRetentionRuleArgs']]]]:
        """
        One or more `retention_rule` blocks as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "retention_rules")

    @retention_rules.setter
    def retention_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BackupPolicyMysqlFlexibleServerRetentionRuleArgs']]]]):
        pulumi.set(self, "retention_rules", value)

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the Time Zone which should be used by the backup schedule. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_zone", value)


@pulumi.input_type
class _BackupPolicyMysqlFlexibleServerState:
    def __init__(__self__, *,
                 backup_repeating_time_intervals: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 default_retention_rule: Optional[pulumi.Input['BackupPolicyMysqlFlexibleServerDefaultRetentionRuleArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 retention_rules: Optional[pulumi.Input[Sequence[pulumi.Input['BackupPolicyMysqlFlexibleServerRetentionRuleArgs']]]] = None,
                 time_zone: Optional[pulumi.Input[builtins.str]] = None,
                 vault_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering BackupPolicyMysqlFlexibleServer resources.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] backup_repeating_time_intervals: Specifies a list of repeating time interval. It supports weekly back. It should follow `ISO 8601` repeating time interval format. Changing this forces a new resource to be created.
        :param pulumi.Input['BackupPolicyMysqlFlexibleServerDefaultRetentionRuleArgs'] default_retention_rule: A `default_retention_rule` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name of the Backup Policy for the MySQL Flexible Server. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input['BackupPolicyMysqlFlexibleServerRetentionRuleArgs']]] retention_rules: One or more `retention_rule` blocks as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] time_zone: Specifies the Time Zone which should be used by the backup schedule. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] vault_id: The ID of the Backup Vault where the Backup Policy MySQL Flexible Server should exist. Changing this forces a new resource to be created.
        """
        if backup_repeating_time_intervals is not None:
            pulumi.set(__self__, "backup_repeating_time_intervals", backup_repeating_time_intervals)
        if default_retention_rule is not None:
            pulumi.set(__self__, "default_retention_rule", default_retention_rule)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if retention_rules is not None:
            pulumi.set(__self__, "retention_rules", retention_rules)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)
        if vault_id is not None:
            pulumi.set(__self__, "vault_id", vault_id)

    @property
    @pulumi.getter(name="backupRepeatingTimeIntervals")
    def backup_repeating_time_intervals(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Specifies a list of repeating time interval. It supports weekly back. It should follow `ISO 8601` repeating time interval format. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "backup_repeating_time_intervals")

    @backup_repeating_time_intervals.setter
    def backup_repeating_time_intervals(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "backup_repeating_time_intervals", value)

    @property
    @pulumi.getter(name="defaultRetentionRule")
    def default_retention_rule(self) -> Optional[pulumi.Input['BackupPolicyMysqlFlexibleServerDefaultRetentionRuleArgs']]:
        """
        A `default_retention_rule` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "default_retention_rule")

    @default_retention_rule.setter
    def default_retention_rule(self, value: Optional[pulumi.Input['BackupPolicyMysqlFlexibleServerDefaultRetentionRuleArgs']]):
        pulumi.set(self, "default_retention_rule", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the Backup Policy for the MySQL Flexible Server. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="retentionRules")
    def retention_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BackupPolicyMysqlFlexibleServerRetentionRuleArgs']]]]:
        """
        One or more `retention_rule` blocks as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "retention_rules")

    @retention_rules.setter
    def retention_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BackupPolicyMysqlFlexibleServerRetentionRuleArgs']]]]):
        pulumi.set(self, "retention_rules", value)

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the Time Zone which should be used by the backup schedule. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_zone", value)

    @property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Backup Vault where the Backup Policy MySQL Flexible Server should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "vault_id")

    @vault_id.setter
    def vault_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "vault_id", value)


@pulumi.type_token("azure:dataprotection/backupPolicyMysqlFlexibleServer:BackupPolicyMysqlFlexibleServer")
class BackupPolicyMysqlFlexibleServer(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup_repeating_time_intervals: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 default_retention_rule: Optional[pulumi.Input[Union['BackupPolicyMysqlFlexibleServerDefaultRetentionRuleArgs', 'BackupPolicyMysqlFlexibleServerDefaultRetentionRuleArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 retention_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BackupPolicyMysqlFlexibleServerRetentionRuleArgs', 'BackupPolicyMysqlFlexibleServerRetentionRuleArgsDict']]]]] = None,
                 time_zone: Optional[pulumi.Input[builtins.str]] = None,
                 vault_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages a Backup Policy to back up MySQL Flexible Server.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_backup_vault = azure.dataprotection.BackupVault("example",
            name="example-backup-vault",
            resource_group_name=example.name,
            location=example.location,
            datastore_type="VaultStore",
            redundancy="LocallyRedundant",
            identity={
                "type": "SystemAssigned",
            })
        example_backup_policy_mysql_flexible_server = azure.dataprotection.BackupPolicyMysqlFlexibleServer("example",
            name="example-backup-policy",
            vault_id=example_backup_vault.id,
            backup_repeating_time_intervals=["R/2021-05-23T02:30:00+00:00/P1W"],
            time_zone="India Standard Time",
            default_retention_rule={
                "life_cycles": [{
                    "duration": "P4M",
                    "data_store_type": "VaultStore",
                }],
            },
            retention_rules=[
                {
                    "name": "weekly",
                    "life_cycles": [{
                        "duration": "P6M",
                        "data_store_type": "VaultStore",
                    }],
                    "priority": 20,
                    "criteria": {
                        "absolute_criteria": "FirstOfWeek",
                    },
                },
                {
                    "name": "thursday",
                    "life_cycles": [{
                        "duration": "P1W",
                        "data_store_type": "VaultStore",
                    }],
                    "priority": 25,
                    "criteria": {
                        "days_of_weeks": ["Thursday"],
                        "scheduled_backup_times": ["2021-05-23T02:30:00Z"],
                    },
                },
                {
                    "name": "monthly",
                    "life_cycles": [{
                        "duration": "P1D",
                        "data_store_type": "VaultStore",
                    }],
                    "priority": 15,
                    "criteria": {
                        "weeks_of_months": [
                            "First",
                            "Last",
                        ],
                        "days_of_weeks": ["Tuesday"],
                        "scheduled_backup_times": ["2021-05-23T02:30:00Z"],
                    },
                },
            ])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.DataProtection`: 2024-04-01

        ## Import

        Backup Policy MySQL Flexible Server's can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:dataprotection/backupPolicyMysqlFlexibleServer:BackupPolicyMysqlFlexibleServer example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.DataProtection/backupVaults/vault1/backupPolicies/backupPolicy1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] backup_repeating_time_intervals: Specifies a list of repeating time interval. It supports weekly back. It should follow `ISO 8601` repeating time interval format. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['BackupPolicyMysqlFlexibleServerDefaultRetentionRuleArgs', 'BackupPolicyMysqlFlexibleServerDefaultRetentionRuleArgsDict']] default_retention_rule: A `default_retention_rule` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name of the Backup Policy for the MySQL Flexible Server. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['BackupPolicyMysqlFlexibleServerRetentionRuleArgs', 'BackupPolicyMysqlFlexibleServerRetentionRuleArgsDict']]]] retention_rules: One or more `retention_rule` blocks as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] time_zone: Specifies the Time Zone which should be used by the backup schedule. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] vault_id: The ID of the Backup Vault where the Backup Policy MySQL Flexible Server should exist. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BackupPolicyMysqlFlexibleServerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Backup Policy to back up MySQL Flexible Server.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_backup_vault = azure.dataprotection.BackupVault("example",
            name="example-backup-vault",
            resource_group_name=example.name,
            location=example.location,
            datastore_type="VaultStore",
            redundancy="LocallyRedundant",
            identity={
                "type": "SystemAssigned",
            })
        example_backup_policy_mysql_flexible_server = azure.dataprotection.BackupPolicyMysqlFlexibleServer("example",
            name="example-backup-policy",
            vault_id=example_backup_vault.id,
            backup_repeating_time_intervals=["R/2021-05-23T02:30:00+00:00/P1W"],
            time_zone="India Standard Time",
            default_retention_rule={
                "life_cycles": [{
                    "duration": "P4M",
                    "data_store_type": "VaultStore",
                }],
            },
            retention_rules=[
                {
                    "name": "weekly",
                    "life_cycles": [{
                        "duration": "P6M",
                        "data_store_type": "VaultStore",
                    }],
                    "priority": 20,
                    "criteria": {
                        "absolute_criteria": "FirstOfWeek",
                    },
                },
                {
                    "name": "thursday",
                    "life_cycles": [{
                        "duration": "P1W",
                        "data_store_type": "VaultStore",
                    }],
                    "priority": 25,
                    "criteria": {
                        "days_of_weeks": ["Thursday"],
                        "scheduled_backup_times": ["2021-05-23T02:30:00Z"],
                    },
                },
                {
                    "name": "monthly",
                    "life_cycles": [{
                        "duration": "P1D",
                        "data_store_type": "VaultStore",
                    }],
                    "priority": 15,
                    "criteria": {
                        "weeks_of_months": [
                            "First",
                            "Last",
                        ],
                        "days_of_weeks": ["Tuesday"],
                        "scheduled_backup_times": ["2021-05-23T02:30:00Z"],
                    },
                },
            ])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.DataProtection`: 2024-04-01

        ## Import

        Backup Policy MySQL Flexible Server's can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:dataprotection/backupPolicyMysqlFlexibleServer:BackupPolicyMysqlFlexibleServer example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.DataProtection/backupVaults/vault1/backupPolicies/backupPolicy1
        ```

        :param str resource_name: The name of the resource.
        :param BackupPolicyMysqlFlexibleServerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BackupPolicyMysqlFlexibleServerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup_repeating_time_intervals: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 default_retention_rule: Optional[pulumi.Input[Union['BackupPolicyMysqlFlexibleServerDefaultRetentionRuleArgs', 'BackupPolicyMysqlFlexibleServerDefaultRetentionRuleArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 retention_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BackupPolicyMysqlFlexibleServerRetentionRuleArgs', 'BackupPolicyMysqlFlexibleServerRetentionRuleArgsDict']]]]] = None,
                 time_zone: Optional[pulumi.Input[builtins.str]] = None,
                 vault_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BackupPolicyMysqlFlexibleServerArgs.__new__(BackupPolicyMysqlFlexibleServerArgs)

            if backup_repeating_time_intervals is None and not opts.urn:
                raise TypeError("Missing required property 'backup_repeating_time_intervals'")
            __props__.__dict__["backup_repeating_time_intervals"] = backup_repeating_time_intervals
            if default_retention_rule is None and not opts.urn:
                raise TypeError("Missing required property 'default_retention_rule'")
            __props__.__dict__["default_retention_rule"] = default_retention_rule
            __props__.__dict__["name"] = name
            __props__.__dict__["retention_rules"] = retention_rules
            __props__.__dict__["time_zone"] = time_zone
            if vault_id is None and not opts.urn:
                raise TypeError("Missing required property 'vault_id'")
            __props__.__dict__["vault_id"] = vault_id
        super(BackupPolicyMysqlFlexibleServer, __self__).__init__(
            'azure:dataprotection/backupPolicyMysqlFlexibleServer:BackupPolicyMysqlFlexibleServer',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            backup_repeating_time_intervals: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            default_retention_rule: Optional[pulumi.Input[Union['BackupPolicyMysqlFlexibleServerDefaultRetentionRuleArgs', 'BackupPolicyMysqlFlexibleServerDefaultRetentionRuleArgsDict']]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            retention_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BackupPolicyMysqlFlexibleServerRetentionRuleArgs', 'BackupPolicyMysqlFlexibleServerRetentionRuleArgsDict']]]]] = None,
            time_zone: Optional[pulumi.Input[builtins.str]] = None,
            vault_id: Optional[pulumi.Input[builtins.str]] = None) -> 'BackupPolicyMysqlFlexibleServer':
        """
        Get an existing BackupPolicyMysqlFlexibleServer resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] backup_repeating_time_intervals: Specifies a list of repeating time interval. It supports weekly back. It should follow `ISO 8601` repeating time interval format. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['BackupPolicyMysqlFlexibleServerDefaultRetentionRuleArgs', 'BackupPolicyMysqlFlexibleServerDefaultRetentionRuleArgsDict']] default_retention_rule: A `default_retention_rule` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name of the Backup Policy for the MySQL Flexible Server. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['BackupPolicyMysqlFlexibleServerRetentionRuleArgs', 'BackupPolicyMysqlFlexibleServerRetentionRuleArgsDict']]]] retention_rules: One or more `retention_rule` blocks as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] time_zone: Specifies the Time Zone which should be used by the backup schedule. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] vault_id: The ID of the Backup Vault where the Backup Policy MySQL Flexible Server should exist. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BackupPolicyMysqlFlexibleServerState.__new__(_BackupPolicyMysqlFlexibleServerState)

        __props__.__dict__["backup_repeating_time_intervals"] = backup_repeating_time_intervals
        __props__.__dict__["default_retention_rule"] = default_retention_rule
        __props__.__dict__["name"] = name
        __props__.__dict__["retention_rules"] = retention_rules
        __props__.__dict__["time_zone"] = time_zone
        __props__.__dict__["vault_id"] = vault_id
        return BackupPolicyMysqlFlexibleServer(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="backupRepeatingTimeIntervals")
    def backup_repeating_time_intervals(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        Specifies a list of repeating time interval. It supports weekly back. It should follow `ISO 8601` repeating time interval format. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "backup_repeating_time_intervals")

    @property
    @pulumi.getter(name="defaultRetentionRule")
    def default_retention_rule(self) -> pulumi.Output['outputs.BackupPolicyMysqlFlexibleServerDefaultRetentionRule']:
        """
        A `default_retention_rule` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "default_retention_rule")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the name of the Backup Policy for the MySQL Flexible Server. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="retentionRules")
    def retention_rules(self) -> pulumi.Output[Optional[Sequence['outputs.BackupPolicyMysqlFlexibleServerRetentionRule']]]:
        """
        One or more `retention_rule` blocks as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "retention_rules")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies the Time Zone which should be used by the backup schedule. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "time_zone")

    @property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the Backup Vault where the Backup Policy MySQL Flexible Server should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "vault_id")

