# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetDatasetKustoDatabaseResult',
    'AwaitableGetDatasetKustoDatabaseResult',
    'get_dataset_kusto_database',
    'get_dataset_kusto_database_output',
]

@pulumi.output_type
class GetDatasetKustoDatabaseResult:
    """
    A collection of values returned by getDatasetKustoDatabase.
    """
    def __init__(__self__, display_name=None, id=None, kusto_cluster_location=None, kusto_database_id=None, name=None, share_id=None):
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if kusto_cluster_location and not isinstance(kusto_cluster_location, str):
            raise TypeError("Expected argument 'kusto_cluster_location' to be a str")
        pulumi.set(__self__, "kusto_cluster_location", kusto_cluster_location)
        if kusto_database_id and not isinstance(kusto_database_id, str):
            raise TypeError("Expected argument 'kusto_database_id' to be a str")
        pulumi.set(__self__, "kusto_database_id", kusto_database_id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if share_id and not isinstance(share_id, str):
            raise TypeError("Expected argument 'share_id' to be a str")
        pulumi.set(__self__, "share_id", share_id)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        The name of the Data Share Dataset.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="kustoClusterLocation")
    def kusto_cluster_location(self) -> builtins.str:
        """
        The location of the Kusto Cluster.
        """
        return pulumi.get(self, "kusto_cluster_location")

    @property
    @pulumi.getter(name="kustoDatabaseId")
    def kusto_database_id(self) -> builtins.str:
        """
        The resource ID of the Kusto Cluster Database to be shared with the receiver.
        """
        return pulumi.get(self, "kusto_database_id")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="shareId")
    def share_id(self) -> builtins.str:
        return pulumi.get(self, "share_id")


class AwaitableGetDatasetKustoDatabaseResult(GetDatasetKustoDatabaseResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDatasetKustoDatabaseResult(
            display_name=self.display_name,
            id=self.id,
            kusto_cluster_location=self.kusto_cluster_location,
            kusto_database_id=self.kusto_database_id,
            name=self.name,
            share_id=self.share_id)


def get_dataset_kusto_database(name: Optional[builtins.str] = None,
                               share_id: Optional[builtins.str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDatasetKustoDatabaseResult:
    """
    Use this data source to access information about an existing Data Share Kusto Database Dataset.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.datashare.get_dataset_kusto_database(name="example-dskdds",
        share_id="example-share-id")
    pulumi.export("id", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.DataShare`: 2019-11-01


    :param builtins.str name: The name of this Data Share Kusto Database Dataset.
    :param builtins.str share_id: The resource ID of the Data Share where this Data Share Kusto Database Dataset should be created.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['shareId'] = share_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:datashare/getDatasetKustoDatabase:getDatasetKustoDatabase', __args__, opts=opts, typ=GetDatasetKustoDatabaseResult).value

    return AwaitableGetDatasetKustoDatabaseResult(
        display_name=pulumi.get(__ret__, 'display_name'),
        id=pulumi.get(__ret__, 'id'),
        kusto_cluster_location=pulumi.get(__ret__, 'kusto_cluster_location'),
        kusto_database_id=pulumi.get(__ret__, 'kusto_database_id'),
        name=pulumi.get(__ret__, 'name'),
        share_id=pulumi.get(__ret__, 'share_id'))
def get_dataset_kusto_database_output(name: Optional[pulumi.Input[builtins.str]] = None,
                                      share_id: Optional[pulumi.Input[builtins.str]] = None,
                                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDatasetKustoDatabaseResult]:
    """
    Use this data source to access information about an existing Data Share Kusto Database Dataset.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.datashare.get_dataset_kusto_database(name="example-dskdds",
        share_id="example-share-id")
    pulumi.export("id", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.DataShare`: 2019-11-01


    :param builtins.str name: The name of this Data Share Kusto Database Dataset.
    :param builtins.str share_id: The resource ID of the Data Share where this Data Share Kusto Database Dataset should be created.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['shareId'] = share_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:datashare/getDatasetKustoDatabase:getDatasetKustoDatabase', __args__, opts=opts, typ=GetDatasetKustoDatabaseResult)
    return __ret__.apply(lambda __response__: GetDatasetKustoDatabaseResult(
        display_name=pulumi.get(__response__, 'display_name'),
        id=pulumi.get(__response__, 'id'),
        kusto_cluster_location=pulumi.get(__response__, 'kusto_cluster_location'),
        kusto_database_id=pulumi.get(__response__, 'kusto_database_id'),
        name=pulumi.get(__response__, 'name'),
        share_id=pulumi.get(__response__, 'share_id')))
