# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ShareArgs', 'Share']

@pulumi.input_type
class ShareArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[builtins.str],
                 kind: pulumi.Input[builtins.str],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 snapshot_schedule: Optional[pulumi.Input['ShareSnapshotScheduleArgs']] = None,
                 terms: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Share resource.
        :param pulumi.Input[builtins.str] account_id: The ID of the Data Share account in which the Data Share is created. Changing this forces a new Data Share to be created.
        :param pulumi.Input[builtins.str] kind: The kind of the Data Share. Possible values are `CopyBased` and `InPlace`. Changing this forces a new Data Share to be created.
        :param pulumi.Input[builtins.str] description: The Data Share's description.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Data Share. Changing this forces a new Data Share to be created.
        :param pulumi.Input['ShareSnapshotScheduleArgs'] snapshot_schedule: A `snapshot_schedule` block as defined below.
        :param pulumi.Input[builtins.str] terms: The terms of the Data Share.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "kind", kind)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if snapshot_schedule is not None:
            pulumi.set(__self__, "snapshot_schedule", snapshot_schedule)
        if terms is not None:
            pulumi.set(__self__, "terms", terms)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the Data Share account in which the Data Share is created. Changing this forces a new Data Share to be created.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter
    def kind(self) -> pulumi.Input[builtins.str]:
        """
        The kind of the Data Share. Possible values are `CopyBased` and `InPlace`. Changing this forces a new Data Share to be created.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Data Share's description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name which should be used for this Data Share. Changing this forces a new Data Share to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="snapshotSchedule")
    def snapshot_schedule(self) -> Optional[pulumi.Input['ShareSnapshotScheduleArgs']]:
        """
        A `snapshot_schedule` block as defined below.
        """
        return pulumi.get(self, "snapshot_schedule")

    @snapshot_schedule.setter
    def snapshot_schedule(self, value: Optional[pulumi.Input['ShareSnapshotScheduleArgs']]):
        pulumi.set(self, "snapshot_schedule", value)

    @property
    @pulumi.getter
    def terms(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The terms of the Data Share.
        """
        return pulumi.get(self, "terms")

    @terms.setter
    def terms(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "terms", value)


@pulumi.input_type
class _ShareState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 kind: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 snapshot_schedule: Optional[pulumi.Input['ShareSnapshotScheduleArgs']] = None,
                 terms: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Share resources.
        :param pulumi.Input[builtins.str] account_id: The ID of the Data Share account in which the Data Share is created. Changing this forces a new Data Share to be created.
        :param pulumi.Input[builtins.str] description: The Data Share's description.
        :param pulumi.Input[builtins.str] kind: The kind of the Data Share. Possible values are `CopyBased` and `InPlace`. Changing this forces a new Data Share to be created.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Data Share. Changing this forces a new Data Share to be created.
        :param pulumi.Input['ShareSnapshotScheduleArgs'] snapshot_schedule: A `snapshot_schedule` block as defined below.
        :param pulumi.Input[builtins.str] terms: The terms of the Data Share.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if snapshot_schedule is not None:
            pulumi.set(__self__, "snapshot_schedule", snapshot_schedule)
        if terms is not None:
            pulumi.set(__self__, "terms", terms)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Data Share account in which the Data Share is created. Changing this forces a new Data Share to be created.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Data Share's description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The kind of the Data Share. Possible values are `CopyBased` and `InPlace`. Changing this forces a new Data Share to be created.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name which should be used for this Data Share. Changing this forces a new Data Share to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="snapshotSchedule")
    def snapshot_schedule(self) -> Optional[pulumi.Input['ShareSnapshotScheduleArgs']]:
        """
        A `snapshot_schedule` block as defined below.
        """
        return pulumi.get(self, "snapshot_schedule")

    @snapshot_schedule.setter
    def snapshot_schedule(self, value: Optional[pulumi.Input['ShareSnapshotScheduleArgs']]):
        pulumi.set(self, "snapshot_schedule", value)

    @property
    @pulumi.getter
    def terms(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The terms of the Data Share.
        """
        return pulumi.get(self, "terms")

    @terms.setter
    def terms(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "terms", value)


@pulumi.type_token("azure:datashare/share:Share")
class Share(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 kind: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 snapshot_schedule: Optional[pulumi.Input[Union['ShareSnapshotScheduleArgs', 'ShareSnapshotScheduleArgsDict']]] = None,
                 terms: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages a Data Share.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_account = azure.datashare.Account("example",
            name="example-dsa",
            location=example.location,
            resource_group_name=example.name,
            identity={
                "type": "SystemAssigned",
            },
            tags={
                "foo": "bar",
            })
        example_share = azure.datashare.Share("example",
            name="example_dss",
            account_id=example_account.id,
            kind="CopyBased",
            description="example desc",
            terms="example terms",
            snapshot_schedule={
                "name": "example-ss",
                "recurrence": "Day",
                "start_time": "2020-04-17T04:47:52.9614956Z",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.DataShare`: 2019-11-01

        ## Import

        Data Shares can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:datashare/share:Share example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.DataShare/accounts/account1/shares/share1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] account_id: The ID of the Data Share account in which the Data Share is created. Changing this forces a new Data Share to be created.
        :param pulumi.Input[builtins.str] description: The Data Share's description.
        :param pulumi.Input[builtins.str] kind: The kind of the Data Share. Possible values are `CopyBased` and `InPlace`. Changing this forces a new Data Share to be created.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Data Share. Changing this forces a new Data Share to be created.
        :param pulumi.Input[Union['ShareSnapshotScheduleArgs', 'ShareSnapshotScheduleArgsDict']] snapshot_schedule: A `snapshot_schedule` block as defined below.
        :param pulumi.Input[builtins.str] terms: The terms of the Data Share.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ShareArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Data Share.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_account = azure.datashare.Account("example",
            name="example-dsa",
            location=example.location,
            resource_group_name=example.name,
            identity={
                "type": "SystemAssigned",
            },
            tags={
                "foo": "bar",
            })
        example_share = azure.datashare.Share("example",
            name="example_dss",
            account_id=example_account.id,
            kind="CopyBased",
            description="example desc",
            terms="example terms",
            snapshot_schedule={
                "name": "example-ss",
                "recurrence": "Day",
                "start_time": "2020-04-17T04:47:52.9614956Z",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.DataShare`: 2019-11-01

        ## Import

        Data Shares can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:datashare/share:Share example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.DataShare/accounts/account1/shares/share1
        ```

        :param str resource_name: The name of the resource.
        :param ShareArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ShareArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 kind: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 snapshot_schedule: Optional[pulumi.Input[Union['ShareSnapshotScheduleArgs', 'ShareSnapshotScheduleArgsDict']]] = None,
                 terms: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ShareArgs.__new__(ShareArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["description"] = description
            if kind is None and not opts.urn:
                raise TypeError("Missing required property 'kind'")
            __props__.__dict__["kind"] = kind
            __props__.__dict__["name"] = name
            __props__.__dict__["snapshot_schedule"] = snapshot_schedule
            __props__.__dict__["terms"] = terms
        super(Share, __self__).__init__(
            'azure:datashare/share:Share',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            kind: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            snapshot_schedule: Optional[pulumi.Input[Union['ShareSnapshotScheduleArgs', 'ShareSnapshotScheduleArgsDict']]] = None,
            terms: Optional[pulumi.Input[builtins.str]] = None) -> 'Share':
        """
        Get an existing Share resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] account_id: The ID of the Data Share account in which the Data Share is created. Changing this forces a new Data Share to be created.
        :param pulumi.Input[builtins.str] description: The Data Share's description.
        :param pulumi.Input[builtins.str] kind: The kind of the Data Share. Possible values are `CopyBased` and `InPlace`. Changing this forces a new Data Share to be created.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Data Share. Changing this forces a new Data Share to be created.
        :param pulumi.Input[Union['ShareSnapshotScheduleArgs', 'ShareSnapshotScheduleArgsDict']] snapshot_schedule: A `snapshot_schedule` block as defined below.
        :param pulumi.Input[builtins.str] terms: The terms of the Data Share.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ShareState.__new__(_ShareState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["description"] = description
        __props__.__dict__["kind"] = kind
        __props__.__dict__["name"] = name
        __props__.__dict__["snapshot_schedule"] = snapshot_schedule
        __props__.__dict__["terms"] = terms
        return Share(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the Data Share account in which the Data Share is created. Changing this forces a new Data Share to be created.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Data Share's description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def kind(self) -> pulumi.Output[builtins.str]:
        """
        The kind of the Data Share. Possible values are `CopyBased` and `InPlace`. Changing this forces a new Data Share to be created.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name which should be used for this Data Share. Changing this forces a new Data Share to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="snapshotSchedule")
    def snapshot_schedule(self) -> pulumi.Output[Optional['outputs.ShareSnapshotSchedule']]:
        """
        A `snapshot_schedule` block as defined below.
        """
        return pulumi.get(self, "snapshot_schedule")

    @property
    @pulumi.getter
    def terms(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The terms of the Data Share.
        """
        return pulumi.get(self, "terms")

