# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'HostPoolScheduledAgentUpdatesArgs',
    'HostPoolScheduledAgentUpdatesArgsDict',
    'HostPoolScheduledAgentUpdatesScheduleArgs',
    'HostPoolScheduledAgentUpdatesScheduleArgsDict',
    'ScalingPlanHostPoolArgs',
    'ScalingPlanHostPoolArgsDict',
    'ScalingPlanScheduleArgs',
    'ScalingPlanScheduleArgsDict',
]

MYPY = False

if not MYPY:
    class HostPoolScheduledAgentUpdatesArgsDict(TypedDict):
        enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        Enables or disables scheduled updates of the AVD agent components (RDAgent, Geneva Monitoring agent, and side-by-side stack) on session hosts. If this is enabled then up to two `schedule` blocks must be defined. Default is `false`.

        > **Note:** if `enabled` is set to `true` then at least one and a maximum of two `schedule` blocks must be provided.
        """
        schedules: NotRequired[pulumi.Input[Sequence[pulumi.Input['HostPoolScheduledAgentUpdatesScheduleArgsDict']]]]
        """
        A `schedule` block as defined below. A maximum of two blocks can be added.
        """
        timezone: NotRequired[pulumi.Input[builtins.str]]
        """
        Specifies the time zone in which the agent update schedule will apply, [the possible values are defined here](https://jackstromberg.com/2017/01/list-of-time-zones-consumed-by-azure/). If `use_session_host_timezone` is enabled then it will override this setting. Default is `UTC`
        """
        use_session_host_timezone: NotRequired[pulumi.Input[builtins.bool]]
        """
        Specifies whether scheduled agent updates should be applied based on the timezone of the affected session host. If configured then this setting overrides `timezone`. Default is `false`.
        """
elif False:
    HostPoolScheduledAgentUpdatesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class HostPoolScheduledAgentUpdatesArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 schedules: Optional[pulumi.Input[Sequence[pulumi.Input['HostPoolScheduledAgentUpdatesScheduleArgs']]]] = None,
                 timezone: Optional[pulumi.Input[builtins.str]] = None,
                 use_session_host_timezone: Optional[pulumi.Input[builtins.bool]] = None):
        """
        :param pulumi.Input[builtins.bool] enabled: Enables or disables scheduled updates of the AVD agent components (RDAgent, Geneva Monitoring agent, and side-by-side stack) on session hosts. If this is enabled then up to two `schedule` blocks must be defined. Default is `false`.
               
               > **Note:** if `enabled` is set to `true` then at least one and a maximum of two `schedule` blocks must be provided.
        :param pulumi.Input[Sequence[pulumi.Input['HostPoolScheduledAgentUpdatesScheduleArgs']]] schedules: A `schedule` block as defined below. A maximum of two blocks can be added.
        :param pulumi.Input[builtins.str] timezone: Specifies the time zone in which the agent update schedule will apply, [the possible values are defined here](https://jackstromberg.com/2017/01/list-of-time-zones-consumed-by-azure/). If `use_session_host_timezone` is enabled then it will override this setting. Default is `UTC`
        :param pulumi.Input[builtins.bool] use_session_host_timezone: Specifies whether scheduled agent updates should be applied based on the timezone of the affected session host. If configured then this setting overrides `timezone`. Default is `false`.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if schedules is not None:
            pulumi.set(__self__, "schedules", schedules)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)
        if use_session_host_timezone is not None:
            pulumi.set(__self__, "use_session_host_timezone", use_session_host_timezone)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enables or disables scheduled updates of the AVD agent components (RDAgent, Geneva Monitoring agent, and side-by-side stack) on session hosts. If this is enabled then up to two `schedule` blocks must be defined. Default is `false`.

        > **Note:** if `enabled` is set to `true` then at least one and a maximum of two `schedule` blocks must be provided.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def schedules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['HostPoolScheduledAgentUpdatesScheduleArgs']]]]:
        """
        A `schedule` block as defined below. A maximum of two blocks can be added.
        """
        return pulumi.get(self, "schedules")

    @schedules.setter
    def schedules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['HostPoolScheduledAgentUpdatesScheduleArgs']]]]):
        pulumi.set(self, "schedules", value)

    @property
    @pulumi.getter
    def timezone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the time zone in which the agent update schedule will apply, [the possible values are defined here](https://jackstromberg.com/2017/01/list-of-time-zones-consumed-by-azure/). If `use_session_host_timezone` is enabled then it will override this setting. Default is `UTC`
        """
        return pulumi.get(self, "timezone")

    @timezone.setter
    def timezone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "timezone", value)

    @property
    @pulumi.getter(name="useSessionHostTimezone")
    def use_session_host_timezone(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether scheduled agent updates should be applied based on the timezone of the affected session host. If configured then this setting overrides `timezone`. Default is `false`.
        """
        return pulumi.get(self, "use_session_host_timezone")

    @use_session_host_timezone.setter
    def use_session_host_timezone(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "use_session_host_timezone", value)


if not MYPY:
    class HostPoolScheduledAgentUpdatesScheduleArgsDict(TypedDict):
        day_of_week: pulumi.Input[builtins.str]
        """
        The day of the week on which agent updates should be performed. Possible values are `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday`, `Saturday`, and `Sunday`
        """
        hour_of_day: pulumi.Input[builtins.int]
        """
        The hour of day the update window should start. The update is a 2 hour period following the hour provided. The value should be provided as a number between 0 and 23, with 0 being midnight and 23 being 11pm. A leading zero should not be used.
        """
elif False:
    HostPoolScheduledAgentUpdatesScheduleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class HostPoolScheduledAgentUpdatesScheduleArgs:
    def __init__(__self__, *,
                 day_of_week: pulumi.Input[builtins.str],
                 hour_of_day: pulumi.Input[builtins.int]):
        """
        :param pulumi.Input[builtins.str] day_of_week: The day of the week on which agent updates should be performed. Possible values are `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday`, `Saturday`, and `Sunday`
        :param pulumi.Input[builtins.int] hour_of_day: The hour of day the update window should start. The update is a 2 hour period following the hour provided. The value should be provided as a number between 0 and 23, with 0 being midnight and 23 being 11pm. A leading zero should not be used.
        """
        pulumi.set(__self__, "day_of_week", day_of_week)
        pulumi.set(__self__, "hour_of_day", hour_of_day)

    @property
    @pulumi.getter(name="dayOfWeek")
    def day_of_week(self) -> pulumi.Input[builtins.str]:
        """
        The day of the week on which agent updates should be performed. Possible values are `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday`, `Saturday`, and `Sunday`
        """
        return pulumi.get(self, "day_of_week")

    @day_of_week.setter
    def day_of_week(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "day_of_week", value)

    @property
    @pulumi.getter(name="hourOfDay")
    def hour_of_day(self) -> pulumi.Input[builtins.int]:
        """
        The hour of day the update window should start. The update is a 2 hour period following the hour provided. The value should be provided as a number between 0 and 23, with 0 being midnight and 23 being 11pm. A leading zero should not be used.
        """
        return pulumi.get(self, "hour_of_day")

    @hour_of_day.setter
    def hour_of_day(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "hour_of_day", value)


if not MYPY:
    class ScalingPlanHostPoolArgsDict(TypedDict):
        hostpool_id: pulumi.Input[builtins.str]
        """
        The ID of the HostPool to assign the Scaling Plan to.
        """
        scaling_plan_enabled: pulumi.Input[builtins.bool]
        """
        Specifies if the scaling plan is enabled or disabled for the HostPool.
        """
elif False:
    ScalingPlanHostPoolArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ScalingPlanHostPoolArgs:
    def __init__(__self__, *,
                 hostpool_id: pulumi.Input[builtins.str],
                 scaling_plan_enabled: pulumi.Input[builtins.bool]):
        """
        :param pulumi.Input[builtins.str] hostpool_id: The ID of the HostPool to assign the Scaling Plan to.
        :param pulumi.Input[builtins.bool] scaling_plan_enabled: Specifies if the scaling plan is enabled or disabled for the HostPool.
        """
        pulumi.set(__self__, "hostpool_id", hostpool_id)
        pulumi.set(__self__, "scaling_plan_enabled", scaling_plan_enabled)

    @property
    @pulumi.getter(name="hostpoolId")
    def hostpool_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the HostPool to assign the Scaling Plan to.
        """
        return pulumi.get(self, "hostpool_id")

    @hostpool_id.setter
    def hostpool_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "hostpool_id", value)

    @property
    @pulumi.getter(name="scalingPlanEnabled")
    def scaling_plan_enabled(self) -> pulumi.Input[builtins.bool]:
        """
        Specifies if the scaling plan is enabled or disabled for the HostPool.
        """
        return pulumi.get(self, "scaling_plan_enabled")

    @scaling_plan_enabled.setter
    def scaling_plan_enabled(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "scaling_plan_enabled", value)


if not MYPY:
    class ScalingPlanScheduleArgsDict(TypedDict):
        days_of_weeks: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]
        """
        A list of Days of the Week on which this schedule will be used. Possible values are `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday`, `Saturday`, and `Sunday`
        """
        name: pulumi.Input[builtins.str]
        """
        The name of the schedule.
        """
        off_peak_load_balancing_algorithm: pulumi.Input[builtins.str]
        """
        The load Balancing Algorithm to use during Off-Peak Hours. Possible values are `DepthFirst` and `BreadthFirst`.
        """
        off_peak_start_time: pulumi.Input[builtins.str]
        """
        The time at which Off-Peak scaling will begin. This is also the end-time for the Ramp-Down period. The time must be specified in "HH:MM" format.
        """
        peak_load_balancing_algorithm: pulumi.Input[builtins.str]
        """
        The load Balancing Algorithm to use during Peak Hours. Possible values are `DepthFirst` and `BreadthFirst`.
        """
        peak_start_time: pulumi.Input[builtins.str]
        """
        The time at which Peak scaling will begin. This is also the end-time for the Ramp-Up period. The time must be specified in "HH:MM" format.
        """
        ramp_down_capacity_threshold_percent: pulumi.Input[builtins.int]
        """
        This is the value in percentage of used host pool capacity that will be considered to evaluate whether to turn on/off virtual machines during the ramp-down and off-peak hours. For example, if capacity threshold is specified as 60% and your total host pool capacity is 100 sessions, autoscale will turn on additional session hosts once the host pool exceeds a load of 60 sessions.
        """
        ramp_down_force_logoff_users: pulumi.Input[builtins.bool]
        """
        Whether users will be forced to log-off session hosts once the `ramp_down_wait_time_minutes` value has been exceeded during the Ramp-Down period. Possible values are `true` and `false`.
        """
        ramp_down_load_balancing_algorithm: pulumi.Input[builtins.str]
        """
        The load Balancing Algorithm to use during the Ramp-Down period. Possible values are `DepthFirst` and `BreadthFirst`.
        """
        ramp_down_minimum_hosts_percent: pulumi.Input[builtins.int]
        """
        The minimum percentage of session host virtual machines that you would like to get to for ramp-down and off-peak hours. For example, if Minimum percentage of hosts is specified as 10% and total number of session hosts in your host pool is 10, autoscale will ensure a minimum of 1 session host is available to take user connections.
        """
        ramp_down_notification_message: pulumi.Input[builtins.str]
        """
        The notification message to send to users during Ramp-Down period when they are required to log-off.
        """
        ramp_down_start_time: pulumi.Input[builtins.str]
        """
        The time at which Ramp-Down scaling will begin. This is also the end-time for the Ramp-Up period. The time must be specified in "HH:MM" format.
        """
        ramp_down_stop_hosts_when: pulumi.Input[builtins.str]
        """
        Controls Session Host shutdown behaviour during Ramp-Down period. Session Hosts can either be shutdown when all sessions on the Session Host have ended, or when there are no Active sessions left on the Session Host. Possible values are `ZeroSessions` and `ZeroActiveSessions`.
        """
        ramp_down_wait_time_minutes: pulumi.Input[builtins.int]
        """
        The number of minutes during Ramp-Down period that autoscale will wait after setting the session host VMs to drain mode, notifying any currently signed in users to save their work before forcing the users to logoff. Once all user sessions on the session host VM have been logged off, Autoscale will shut down the VM.
        """
        ramp_up_load_balancing_algorithm: pulumi.Input[builtins.str]
        """
        The load Balancing Algorithm to use during the Ramp-Up period. Possible values are `DepthFirst` and `BreadthFirst`.
        """
        ramp_up_start_time: pulumi.Input[builtins.str]
        """
        The time at which Ramp-Up scaling will begin. This is also the end-time for the Ramp-Up period. The time must be specified in "HH:MM" format.
        """
        ramp_up_capacity_threshold_percent: NotRequired[pulumi.Input[builtins.int]]
        """
        This is the value of percentage of used host pool capacity that will be considered to evaluate whether to turn on/off virtual machines during the ramp-up and peak hours. For example, if capacity threshold is specified as `60%` and your total host pool capacity is `100` sessions, autoscale will turn on additional session hosts once the host pool exceeds a load of `60` sessions.
        """
        ramp_up_minimum_hosts_percent: NotRequired[pulumi.Input[builtins.int]]
        """
        Specifies the minimum percentage of session host virtual machines to start during ramp-up for peak hours. For example, if Minimum percentage of hosts is specified as `10%` and total number of session hosts in your host pool is `10`, autoscale will ensure a minimum of `1` session host is available to take user connections.
        """
elif False:
    ScalingPlanScheduleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ScalingPlanScheduleArgs:
    def __init__(__self__, *,
                 days_of_weeks: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 name: pulumi.Input[builtins.str],
                 off_peak_load_balancing_algorithm: pulumi.Input[builtins.str],
                 off_peak_start_time: pulumi.Input[builtins.str],
                 peak_load_balancing_algorithm: pulumi.Input[builtins.str],
                 peak_start_time: pulumi.Input[builtins.str],
                 ramp_down_capacity_threshold_percent: pulumi.Input[builtins.int],
                 ramp_down_force_logoff_users: pulumi.Input[builtins.bool],
                 ramp_down_load_balancing_algorithm: pulumi.Input[builtins.str],
                 ramp_down_minimum_hosts_percent: pulumi.Input[builtins.int],
                 ramp_down_notification_message: pulumi.Input[builtins.str],
                 ramp_down_start_time: pulumi.Input[builtins.str],
                 ramp_down_stop_hosts_when: pulumi.Input[builtins.str],
                 ramp_down_wait_time_minutes: pulumi.Input[builtins.int],
                 ramp_up_load_balancing_algorithm: pulumi.Input[builtins.str],
                 ramp_up_start_time: pulumi.Input[builtins.str],
                 ramp_up_capacity_threshold_percent: Optional[pulumi.Input[builtins.int]] = None,
                 ramp_up_minimum_hosts_percent: Optional[pulumi.Input[builtins.int]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] days_of_weeks: A list of Days of the Week on which this schedule will be used. Possible values are `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday`, `Saturday`, and `Sunday`
        :param pulumi.Input[builtins.str] name: The name of the schedule.
        :param pulumi.Input[builtins.str] off_peak_load_balancing_algorithm: The load Balancing Algorithm to use during Off-Peak Hours. Possible values are `DepthFirst` and `BreadthFirst`.
        :param pulumi.Input[builtins.str] off_peak_start_time: The time at which Off-Peak scaling will begin. This is also the end-time for the Ramp-Down period. The time must be specified in "HH:MM" format.
        :param pulumi.Input[builtins.str] peak_load_balancing_algorithm: The load Balancing Algorithm to use during Peak Hours. Possible values are `DepthFirst` and `BreadthFirst`.
        :param pulumi.Input[builtins.str] peak_start_time: The time at which Peak scaling will begin. This is also the end-time for the Ramp-Up period. The time must be specified in "HH:MM" format.
        :param pulumi.Input[builtins.int] ramp_down_capacity_threshold_percent: This is the value in percentage of used host pool capacity that will be considered to evaluate whether to turn on/off virtual machines during the ramp-down and off-peak hours. For example, if capacity threshold is specified as 60% and your total host pool capacity is 100 sessions, autoscale will turn on additional session hosts once the host pool exceeds a load of 60 sessions.
        :param pulumi.Input[builtins.bool] ramp_down_force_logoff_users: Whether users will be forced to log-off session hosts once the `ramp_down_wait_time_minutes` value has been exceeded during the Ramp-Down period. Possible values are `true` and `false`.
        :param pulumi.Input[builtins.str] ramp_down_load_balancing_algorithm: The load Balancing Algorithm to use during the Ramp-Down period. Possible values are `DepthFirst` and `BreadthFirst`.
        :param pulumi.Input[builtins.int] ramp_down_minimum_hosts_percent: The minimum percentage of session host virtual machines that you would like to get to for ramp-down and off-peak hours. For example, if Minimum percentage of hosts is specified as 10% and total number of session hosts in your host pool is 10, autoscale will ensure a minimum of 1 session host is available to take user connections.
        :param pulumi.Input[builtins.str] ramp_down_notification_message: The notification message to send to users during Ramp-Down period when they are required to log-off.
        :param pulumi.Input[builtins.str] ramp_down_start_time: The time at which Ramp-Down scaling will begin. This is also the end-time for the Ramp-Up period. The time must be specified in "HH:MM" format.
        :param pulumi.Input[builtins.str] ramp_down_stop_hosts_when: Controls Session Host shutdown behaviour during Ramp-Down period. Session Hosts can either be shutdown when all sessions on the Session Host have ended, or when there are no Active sessions left on the Session Host. Possible values are `ZeroSessions` and `ZeroActiveSessions`.
        :param pulumi.Input[builtins.int] ramp_down_wait_time_minutes: The number of minutes during Ramp-Down period that autoscale will wait after setting the session host VMs to drain mode, notifying any currently signed in users to save their work before forcing the users to logoff. Once all user sessions on the session host VM have been logged off, Autoscale will shut down the VM.
        :param pulumi.Input[builtins.str] ramp_up_load_balancing_algorithm: The load Balancing Algorithm to use during the Ramp-Up period. Possible values are `DepthFirst` and `BreadthFirst`.
        :param pulumi.Input[builtins.str] ramp_up_start_time: The time at which Ramp-Up scaling will begin. This is also the end-time for the Ramp-Up period. The time must be specified in "HH:MM" format.
        :param pulumi.Input[builtins.int] ramp_up_capacity_threshold_percent: This is the value of percentage of used host pool capacity that will be considered to evaluate whether to turn on/off virtual machines during the ramp-up and peak hours. For example, if capacity threshold is specified as `60%` and your total host pool capacity is `100` sessions, autoscale will turn on additional session hosts once the host pool exceeds a load of `60` sessions.
        :param pulumi.Input[builtins.int] ramp_up_minimum_hosts_percent: Specifies the minimum percentage of session host virtual machines to start during ramp-up for peak hours. For example, if Minimum percentage of hosts is specified as `10%` and total number of session hosts in your host pool is `10`, autoscale will ensure a minimum of `1` session host is available to take user connections.
        """
        pulumi.set(__self__, "days_of_weeks", days_of_weeks)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "off_peak_load_balancing_algorithm", off_peak_load_balancing_algorithm)
        pulumi.set(__self__, "off_peak_start_time", off_peak_start_time)
        pulumi.set(__self__, "peak_load_balancing_algorithm", peak_load_balancing_algorithm)
        pulumi.set(__self__, "peak_start_time", peak_start_time)
        pulumi.set(__self__, "ramp_down_capacity_threshold_percent", ramp_down_capacity_threshold_percent)
        pulumi.set(__self__, "ramp_down_force_logoff_users", ramp_down_force_logoff_users)
        pulumi.set(__self__, "ramp_down_load_balancing_algorithm", ramp_down_load_balancing_algorithm)
        pulumi.set(__self__, "ramp_down_minimum_hosts_percent", ramp_down_minimum_hosts_percent)
        pulumi.set(__self__, "ramp_down_notification_message", ramp_down_notification_message)
        pulumi.set(__self__, "ramp_down_start_time", ramp_down_start_time)
        pulumi.set(__self__, "ramp_down_stop_hosts_when", ramp_down_stop_hosts_when)
        pulumi.set(__self__, "ramp_down_wait_time_minutes", ramp_down_wait_time_minutes)
        pulumi.set(__self__, "ramp_up_load_balancing_algorithm", ramp_up_load_balancing_algorithm)
        pulumi.set(__self__, "ramp_up_start_time", ramp_up_start_time)
        if ramp_up_capacity_threshold_percent is not None:
            pulumi.set(__self__, "ramp_up_capacity_threshold_percent", ramp_up_capacity_threshold_percent)
        if ramp_up_minimum_hosts_percent is not None:
            pulumi.set(__self__, "ramp_up_minimum_hosts_percent", ramp_up_minimum_hosts_percent)

    @property
    @pulumi.getter(name="daysOfWeeks")
    def days_of_weeks(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        A list of Days of the Week on which this schedule will be used. Possible values are `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday`, `Saturday`, and `Sunday`
        """
        return pulumi.get(self, "days_of_weeks")

    @days_of_weeks.setter
    def days_of_weeks(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "days_of_weeks", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the schedule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="offPeakLoadBalancingAlgorithm")
    def off_peak_load_balancing_algorithm(self) -> pulumi.Input[builtins.str]:
        """
        The load Balancing Algorithm to use during Off-Peak Hours. Possible values are `DepthFirst` and `BreadthFirst`.
        """
        return pulumi.get(self, "off_peak_load_balancing_algorithm")

    @off_peak_load_balancing_algorithm.setter
    def off_peak_load_balancing_algorithm(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "off_peak_load_balancing_algorithm", value)

    @property
    @pulumi.getter(name="offPeakStartTime")
    def off_peak_start_time(self) -> pulumi.Input[builtins.str]:
        """
        The time at which Off-Peak scaling will begin. This is also the end-time for the Ramp-Down period. The time must be specified in "HH:MM" format.
        """
        return pulumi.get(self, "off_peak_start_time")

    @off_peak_start_time.setter
    def off_peak_start_time(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "off_peak_start_time", value)

    @property
    @pulumi.getter(name="peakLoadBalancingAlgorithm")
    def peak_load_balancing_algorithm(self) -> pulumi.Input[builtins.str]:
        """
        The load Balancing Algorithm to use during Peak Hours. Possible values are `DepthFirst` and `BreadthFirst`.
        """
        return pulumi.get(self, "peak_load_balancing_algorithm")

    @peak_load_balancing_algorithm.setter
    def peak_load_balancing_algorithm(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "peak_load_balancing_algorithm", value)

    @property
    @pulumi.getter(name="peakStartTime")
    def peak_start_time(self) -> pulumi.Input[builtins.str]:
        """
        The time at which Peak scaling will begin. This is also the end-time for the Ramp-Up period. The time must be specified in "HH:MM" format.
        """
        return pulumi.get(self, "peak_start_time")

    @peak_start_time.setter
    def peak_start_time(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "peak_start_time", value)

    @property
    @pulumi.getter(name="rampDownCapacityThresholdPercent")
    def ramp_down_capacity_threshold_percent(self) -> pulumi.Input[builtins.int]:
        """
        This is the value in percentage of used host pool capacity that will be considered to evaluate whether to turn on/off virtual machines during the ramp-down and off-peak hours. For example, if capacity threshold is specified as 60% and your total host pool capacity is 100 sessions, autoscale will turn on additional session hosts once the host pool exceeds a load of 60 sessions.
        """
        return pulumi.get(self, "ramp_down_capacity_threshold_percent")

    @ramp_down_capacity_threshold_percent.setter
    def ramp_down_capacity_threshold_percent(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "ramp_down_capacity_threshold_percent", value)

    @property
    @pulumi.getter(name="rampDownForceLogoffUsers")
    def ramp_down_force_logoff_users(self) -> pulumi.Input[builtins.bool]:
        """
        Whether users will be forced to log-off session hosts once the `ramp_down_wait_time_minutes` value has been exceeded during the Ramp-Down period. Possible values are `true` and `false`.
        """
        return pulumi.get(self, "ramp_down_force_logoff_users")

    @ramp_down_force_logoff_users.setter
    def ramp_down_force_logoff_users(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "ramp_down_force_logoff_users", value)

    @property
    @pulumi.getter(name="rampDownLoadBalancingAlgorithm")
    def ramp_down_load_balancing_algorithm(self) -> pulumi.Input[builtins.str]:
        """
        The load Balancing Algorithm to use during the Ramp-Down period. Possible values are `DepthFirst` and `BreadthFirst`.
        """
        return pulumi.get(self, "ramp_down_load_balancing_algorithm")

    @ramp_down_load_balancing_algorithm.setter
    def ramp_down_load_balancing_algorithm(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "ramp_down_load_balancing_algorithm", value)

    @property
    @pulumi.getter(name="rampDownMinimumHostsPercent")
    def ramp_down_minimum_hosts_percent(self) -> pulumi.Input[builtins.int]:
        """
        The minimum percentage of session host virtual machines that you would like to get to for ramp-down and off-peak hours. For example, if Minimum percentage of hosts is specified as 10% and total number of session hosts in your host pool is 10, autoscale will ensure a minimum of 1 session host is available to take user connections.
        """
        return pulumi.get(self, "ramp_down_minimum_hosts_percent")

    @ramp_down_minimum_hosts_percent.setter
    def ramp_down_minimum_hosts_percent(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "ramp_down_minimum_hosts_percent", value)

    @property
    @pulumi.getter(name="rampDownNotificationMessage")
    def ramp_down_notification_message(self) -> pulumi.Input[builtins.str]:
        """
        The notification message to send to users during Ramp-Down period when they are required to log-off.
        """
        return pulumi.get(self, "ramp_down_notification_message")

    @ramp_down_notification_message.setter
    def ramp_down_notification_message(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "ramp_down_notification_message", value)

    @property
    @pulumi.getter(name="rampDownStartTime")
    def ramp_down_start_time(self) -> pulumi.Input[builtins.str]:
        """
        The time at which Ramp-Down scaling will begin. This is also the end-time for the Ramp-Up period. The time must be specified in "HH:MM" format.
        """
        return pulumi.get(self, "ramp_down_start_time")

    @ramp_down_start_time.setter
    def ramp_down_start_time(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "ramp_down_start_time", value)

    @property
    @pulumi.getter(name="rampDownStopHostsWhen")
    def ramp_down_stop_hosts_when(self) -> pulumi.Input[builtins.str]:
        """
        Controls Session Host shutdown behaviour during Ramp-Down period. Session Hosts can either be shutdown when all sessions on the Session Host have ended, or when there are no Active sessions left on the Session Host. Possible values are `ZeroSessions` and `ZeroActiveSessions`.
        """
        return pulumi.get(self, "ramp_down_stop_hosts_when")

    @ramp_down_stop_hosts_when.setter
    def ramp_down_stop_hosts_when(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "ramp_down_stop_hosts_when", value)

    @property
    @pulumi.getter(name="rampDownWaitTimeMinutes")
    def ramp_down_wait_time_minutes(self) -> pulumi.Input[builtins.int]:
        """
        The number of minutes during Ramp-Down period that autoscale will wait after setting the session host VMs to drain mode, notifying any currently signed in users to save their work before forcing the users to logoff. Once all user sessions on the session host VM have been logged off, Autoscale will shut down the VM.
        """
        return pulumi.get(self, "ramp_down_wait_time_minutes")

    @ramp_down_wait_time_minutes.setter
    def ramp_down_wait_time_minutes(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "ramp_down_wait_time_minutes", value)

    @property
    @pulumi.getter(name="rampUpLoadBalancingAlgorithm")
    def ramp_up_load_balancing_algorithm(self) -> pulumi.Input[builtins.str]:
        """
        The load Balancing Algorithm to use during the Ramp-Up period. Possible values are `DepthFirst` and `BreadthFirst`.
        """
        return pulumi.get(self, "ramp_up_load_balancing_algorithm")

    @ramp_up_load_balancing_algorithm.setter
    def ramp_up_load_balancing_algorithm(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "ramp_up_load_balancing_algorithm", value)

    @property
    @pulumi.getter(name="rampUpStartTime")
    def ramp_up_start_time(self) -> pulumi.Input[builtins.str]:
        """
        The time at which Ramp-Up scaling will begin. This is also the end-time for the Ramp-Up period. The time must be specified in "HH:MM" format.
        """
        return pulumi.get(self, "ramp_up_start_time")

    @ramp_up_start_time.setter
    def ramp_up_start_time(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "ramp_up_start_time", value)

    @property
    @pulumi.getter(name="rampUpCapacityThresholdPercent")
    def ramp_up_capacity_threshold_percent(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        This is the value of percentage of used host pool capacity that will be considered to evaluate whether to turn on/off virtual machines during the ramp-up and peak hours. For example, if capacity threshold is specified as `60%` and your total host pool capacity is `100` sessions, autoscale will turn on additional session hosts once the host pool exceeds a load of `60` sessions.
        """
        return pulumi.get(self, "ramp_up_capacity_threshold_percent")

    @ramp_up_capacity_threshold_percent.setter
    def ramp_up_capacity_threshold_percent(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "ramp_up_capacity_threshold_percent", value)

    @property
    @pulumi.getter(name="rampUpMinimumHostsPercent")
    def ramp_up_minimum_hosts_percent(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the minimum percentage of session host virtual machines to start during ramp-up for peak hours. For example, if Minimum percentage of hosts is specified as `10%` and total number of session hosts in your host pool is `10`, autoscale will ensure a minimum of `1` session host is available to take user connections.
        """
        return pulumi.get(self, "ramp_up_minimum_hosts_percent")

    @ramp_up_minimum_hosts_percent.setter
    def ramp_up_minimum_hosts_percent(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "ramp_up_minimum_hosts_percent", value)


