# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetApplicationGroupResult',
    'AwaitableGetApplicationGroupResult',
    'get_application_group',
    'get_application_group_output',
]

@pulumi.output_type
class GetApplicationGroupResult:
    """
    A collection of values returned by getApplicationGroup.
    """
    def __init__(__self__, description=None, friendly_name=None, host_pool_id=None, id=None, location=None, name=None, resource_group_name=None, tags=None, type=None, workspace_id=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if friendly_name and not isinstance(friendly_name, str):
            raise TypeError("Expected argument 'friendly_name' to be a str")
        pulumi.set(__self__, "friendly_name", friendly_name)
        if host_pool_id and not isinstance(host_pool_id, str):
            raise TypeError("Expected argument 'host_pool_id' to be a str")
        pulumi.set(__self__, "host_pool_id", host_pool_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if workspace_id and not isinstance(workspace_id, str):
            raise TypeError("Expected argument 'workspace_id' to be a str")
        pulumi.set(__self__, "workspace_id", workspace_id)

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        The description of the Application Group.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> builtins.str:
        """
        The friendly name of the Application Group.
        """
        return pulumi.get(self, "friendly_name")

    @property
    @pulumi.getter(name="hostPoolId")
    def host_pool_id(self) -> builtins.str:
        """
        The Virtual Desktop Host Pool ID the Application Group is associated to.
        """
        return pulumi.get(self, "host_pool_id")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def location(self) -> builtins.str:
        """
        The Azure Region where the Application Group exists.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> builtins.str:
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, builtins.str]:
        """
        A mapping of tags assigned to the Application Group.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The type of Application Group (`RemoteApp` or `Desktop`).
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> builtins.str:
        """
        The Virtual Desktop Workspace ID the Application Group is associated to.
        """
        return pulumi.get(self, "workspace_id")


class AwaitableGetApplicationGroupResult(GetApplicationGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetApplicationGroupResult(
            description=self.description,
            friendly_name=self.friendly_name,
            host_pool_id=self.host_pool_id,
            id=self.id,
            location=self.location,
            name=self.name,
            resource_group_name=self.resource_group_name,
            tags=self.tags,
            type=self.type,
            workspace_id=self.workspace_id)


def get_application_group(name: Optional[builtins.str] = None,
                          resource_group_name: Optional[builtins.str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetApplicationGroupResult:
    """
    Use this data source to access information about an existing Application Group.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.desktopvirtualization.get_application_group(name="existing",
        resource_group_name="existing")
    pulumi.export("id", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.DesktopVirtualization`: 2024-04-03


    :param builtins.str name: The name of this Application Group.
    :param builtins.str resource_group_name: The name of the Resource Group where the Application Group exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:desktopvirtualization/getApplicationGroup:getApplicationGroup', __args__, opts=opts, typ=GetApplicationGroupResult).value

    return AwaitableGetApplicationGroupResult(
        description=pulumi.get(__ret__, 'description'),
        friendly_name=pulumi.get(__ret__, 'friendly_name'),
        host_pool_id=pulumi.get(__ret__, 'host_pool_id'),
        id=pulumi.get(__ret__, 'id'),
        location=pulumi.get(__ret__, 'location'),
        name=pulumi.get(__ret__, 'name'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'),
        tags=pulumi.get(__ret__, 'tags'),
        type=pulumi.get(__ret__, 'type'),
        workspace_id=pulumi.get(__ret__, 'workspace_id'))
def get_application_group_output(name: Optional[pulumi.Input[builtins.str]] = None,
                                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetApplicationGroupResult]:
    """
    Use this data source to access information about an existing Application Group.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.desktopvirtualization.get_application_group(name="existing",
        resource_group_name="existing")
    pulumi.export("id", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.DesktopVirtualization`: 2024-04-03


    :param builtins.str name: The name of this Application Group.
    :param builtins.str resource_group_name: The name of the Resource Group where the Application Group exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:desktopvirtualization/getApplicationGroup:getApplicationGroup', __args__, opts=opts, typ=GetApplicationGroupResult)
    return __ret__.apply(lambda __response__: GetApplicationGroupResult(
        description=pulumi.get(__response__, 'description'),
        friendly_name=pulumi.get(__response__, 'friendly_name'),
        host_pool_id=pulumi.get(__response__, 'host_pool_id'),
        id=pulumi.get(__response__, 'id'),
        location=pulumi.get(__response__, 'location'),
        name=pulumi.get(__response__, 'name'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name'),
        tags=pulumi.get(__response__, 'tags'),
        type=pulumi.get(__response__, 'type'),
        workspace_id=pulumi.get(__response__, 'workspace_id')))
