# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['GetHostPoolRegistrationInfoArgs', 'GetHostPoolRegistrationInfo']

@pulumi.input_type
class GetHostPoolRegistrationInfoArgs:
    def __init__(__self__, *,
                 expiration_date: pulumi.Input[builtins.str],
                 hostpool_id: pulumi.Input[builtins.str]):
        """
        The set of arguments for constructing a GetHostPoolRegistrationInfo resource.
        :param pulumi.Input[builtins.str] expiration_date: A valid `RFC3339Time` for the expiration of the token..
        :param pulumi.Input[builtins.str] hostpool_id: The ID of the Virtual Desktop Host Pool to link the Registration Info to. Changing this forces a new Registration Info resource to be created. Only a single virtual_desktop_host_pool_registration_info resource should be associated with a given hostpool. Assigning multiple resources will produce inconsistent results.
        """
        pulumi.set(__self__, "expiration_date", expiration_date)
        pulumi.set(__self__, "hostpool_id", hostpool_id)

    @property
    @pulumi.getter(name="expirationDate")
    def expiration_date(self) -> pulumi.Input[builtins.str]:
        """
        A valid `RFC3339Time` for the expiration of the token..
        """
        return pulumi.get(self, "expiration_date")

    @expiration_date.setter
    def expiration_date(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "expiration_date", value)

    @property
    @pulumi.getter(name="hostpoolId")
    def hostpool_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the Virtual Desktop Host Pool to link the Registration Info to. Changing this forces a new Registration Info resource to be created. Only a single virtual_desktop_host_pool_registration_info resource should be associated with a given hostpool. Assigning multiple resources will produce inconsistent results.
        """
        return pulumi.get(self, "hostpool_id")

    @hostpool_id.setter
    def hostpool_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "hostpool_id", value)


@pulumi.input_type
class _GetHostPoolRegistrationInfoState:
    def __init__(__self__, *,
                 expiration_date: Optional[pulumi.Input[builtins.str]] = None,
                 hostpool_id: Optional[pulumi.Input[builtins.str]] = None,
                 token: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering GetHostPoolRegistrationInfo resources.
        :param pulumi.Input[builtins.str] expiration_date: A valid `RFC3339Time` for the expiration of the token..
        :param pulumi.Input[builtins.str] hostpool_id: The ID of the Virtual Desktop Host Pool to link the Registration Info to. Changing this forces a new Registration Info resource to be created. Only a single virtual_desktop_host_pool_registration_info resource should be associated with a given hostpool. Assigning multiple resources will produce inconsistent results.
        :param pulumi.Input[builtins.str] token: The registration token generated by the Virtual Desktop Host Pool for registration of session hosts.
        """
        if expiration_date is not None:
            pulumi.set(__self__, "expiration_date", expiration_date)
        if hostpool_id is not None:
            pulumi.set(__self__, "hostpool_id", hostpool_id)
        if token is not None:
            pulumi.set(__self__, "token", token)

    @property
    @pulumi.getter(name="expirationDate")
    def expiration_date(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A valid `RFC3339Time` for the expiration of the token..
        """
        return pulumi.get(self, "expiration_date")

    @expiration_date.setter
    def expiration_date(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "expiration_date", value)

    @property
    @pulumi.getter(name="hostpoolId")
    def hostpool_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Virtual Desktop Host Pool to link the Registration Info to. Changing this forces a new Registration Info resource to be created. Only a single virtual_desktop_host_pool_registration_info resource should be associated with a given hostpool. Assigning multiple resources will produce inconsistent results.
        """
        return pulumi.get(self, "hostpool_id")

    @hostpool_id.setter
    def hostpool_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "hostpool_id", value)

    @property
    @pulumi.getter
    def token(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The registration token generated by the Virtual Desktop Host Pool for registration of session hosts.
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "token", value)


@pulumi.type_token("azure:desktopvirtualization/getHostPoolRegistrationInfo:getHostPoolRegistrationInfo")
class GetHostPoolRegistrationInfo(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 expiration_date: Optional[pulumi.Input[builtins.str]] = None,
                 hostpool_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages the Registration Info for a Virtual Desktop Host Pool.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-hostpool",
            location="westeurope")
        example_host_pool = azure.desktopvirtualization.HostPool("example",
            name="example-HP",
            location=example.location,
            resource_group_name=example.name,
            type="Pooled",
            validate_environment=True,
            load_balancer_type="BreadthFirst")
        example_get_host_pool_registration_info = azure.desktopvirtualization.GetHostPoolRegistrationInfo("example",
            hostpool_id=example_host_pool.id,
            expiration_date="2022-01-01T23:40:52Z")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.DesktopVirtualization`: 2024-04-03

        ## Import

        AVD Registration Infos can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:desktopvirtualization/getHostPoolRegistrationInfo:getHostPoolRegistrationInfo example /subscriptions/12345678-1234-9876-4563-123456789012/resourceGroups/resGroup1/providers/Microsoft.DesktopVirtualization/hostPools/pool1/registrationInfo/default
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] expiration_date: A valid `RFC3339Time` for the expiration of the token..
        :param pulumi.Input[builtins.str] hostpool_id: The ID of the Virtual Desktop Host Pool to link the Registration Info to. Changing this forces a new Registration Info resource to be created. Only a single virtual_desktop_host_pool_registration_info resource should be associated with a given hostpool. Assigning multiple resources will produce inconsistent results.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GetHostPoolRegistrationInfoArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages the Registration Info for a Virtual Desktop Host Pool.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-hostpool",
            location="westeurope")
        example_host_pool = azure.desktopvirtualization.HostPool("example",
            name="example-HP",
            location=example.location,
            resource_group_name=example.name,
            type="Pooled",
            validate_environment=True,
            load_balancer_type="BreadthFirst")
        example_get_host_pool_registration_info = azure.desktopvirtualization.GetHostPoolRegistrationInfo("example",
            hostpool_id=example_host_pool.id,
            expiration_date="2022-01-01T23:40:52Z")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.DesktopVirtualization`: 2024-04-03

        ## Import

        AVD Registration Infos can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:desktopvirtualization/getHostPoolRegistrationInfo:getHostPoolRegistrationInfo example /subscriptions/12345678-1234-9876-4563-123456789012/resourceGroups/resGroup1/providers/Microsoft.DesktopVirtualization/hostPools/pool1/registrationInfo/default
        ```

        :param str resource_name: The name of the resource.
        :param GetHostPoolRegistrationInfoArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GetHostPoolRegistrationInfoArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 expiration_date: Optional[pulumi.Input[builtins.str]] = None,
                 hostpool_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GetHostPoolRegistrationInfoArgs.__new__(GetHostPoolRegistrationInfoArgs)

            if expiration_date is None and not opts.urn:
                raise TypeError("Missing required property 'expiration_date'")
            __props__.__dict__["expiration_date"] = expiration_date
            if hostpool_id is None and not opts.urn:
                raise TypeError("Missing required property 'hostpool_id'")
            __props__.__dict__["hostpool_id"] = hostpool_id
            __props__.__dict__["token"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["token"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(GetHostPoolRegistrationInfo, __self__).__init__(
            'azure:desktopvirtualization/getHostPoolRegistrationInfo:getHostPoolRegistrationInfo',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            expiration_date: Optional[pulumi.Input[builtins.str]] = None,
            hostpool_id: Optional[pulumi.Input[builtins.str]] = None,
            token: Optional[pulumi.Input[builtins.str]] = None) -> 'GetHostPoolRegistrationInfo':
        """
        Get an existing GetHostPoolRegistrationInfo resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] expiration_date: A valid `RFC3339Time` for the expiration of the token..
        :param pulumi.Input[builtins.str] hostpool_id: The ID of the Virtual Desktop Host Pool to link the Registration Info to. Changing this forces a new Registration Info resource to be created. Only a single virtual_desktop_host_pool_registration_info resource should be associated with a given hostpool. Assigning multiple resources will produce inconsistent results.
        :param pulumi.Input[builtins.str] token: The registration token generated by the Virtual Desktop Host Pool for registration of session hosts.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GetHostPoolRegistrationInfoState.__new__(_GetHostPoolRegistrationInfoState)

        __props__.__dict__["expiration_date"] = expiration_date
        __props__.__dict__["hostpool_id"] = hostpool_id
        __props__.__dict__["token"] = token
        return GetHostPoolRegistrationInfo(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="expirationDate")
    def expiration_date(self) -> pulumi.Output[builtins.str]:
        """
        A valid `RFC3339Time` for the expiration of the token..
        """
        return pulumi.get(self, "expiration_date")

    @property
    @pulumi.getter(name="hostpoolId")
    def hostpool_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the Virtual Desktop Host Pool to link the Registration Info to. Changing this forces a new Registration Info resource to be created. Only a single virtual_desktop_host_pool_registration_info resource should be associated with a given hostpool. Assigning multiple resources will produce inconsistent results.
        """
        return pulumi.get(self, "hostpool_id")

    @property
    @pulumi.getter
    def token(self) -> pulumi.Output[builtins.str]:
        """
        The registration token generated by the Virtual Desktop Host Pool for registration of session hosts.
        """
        return pulumi.get(self, "token")

