# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ScalingPlanHostPoolAssociationArgs', 'ScalingPlanHostPoolAssociation']

@pulumi.input_type
class ScalingPlanHostPoolAssociationArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[builtins.bool],
                 host_pool_id: pulumi.Input[builtins.str],
                 scaling_plan_id: pulumi.Input[builtins.str]):
        """
        The set of arguments for constructing a ScalingPlanHostPoolAssociation resource.
        :param pulumi.Input[builtins.bool] enabled: Should the Scaling Plan be enabled on this Host Pool.
        :param pulumi.Input[builtins.str] host_pool_id: The resource ID for the Virtual Desktop Host Pool. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] scaling_plan_id: The resource ID for the Virtual Desktop Scaling Plan. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "host_pool_id", host_pool_id)
        pulumi.set(__self__, "scaling_plan_id", scaling_plan_id)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[builtins.bool]:
        """
        Should the Scaling Plan be enabled on this Host Pool.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="hostPoolId")
    def host_pool_id(self) -> pulumi.Input[builtins.str]:
        """
        The resource ID for the Virtual Desktop Host Pool. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "host_pool_id")

    @host_pool_id.setter
    def host_pool_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "host_pool_id", value)

    @property
    @pulumi.getter(name="scalingPlanId")
    def scaling_plan_id(self) -> pulumi.Input[builtins.str]:
        """
        The resource ID for the Virtual Desktop Scaling Plan. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "scaling_plan_id")

    @scaling_plan_id.setter
    def scaling_plan_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "scaling_plan_id", value)


@pulumi.input_type
class _ScalingPlanHostPoolAssociationState:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 host_pool_id: Optional[pulumi.Input[builtins.str]] = None,
                 scaling_plan_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ScalingPlanHostPoolAssociation resources.
        :param pulumi.Input[builtins.bool] enabled: Should the Scaling Plan be enabled on this Host Pool.
        :param pulumi.Input[builtins.str] host_pool_id: The resource ID for the Virtual Desktop Host Pool. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] scaling_plan_id: The resource ID for the Virtual Desktop Scaling Plan. Changing this forces a new resource to be created.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if host_pool_id is not None:
            pulumi.set(__self__, "host_pool_id", host_pool_id)
        if scaling_plan_id is not None:
            pulumi.set(__self__, "scaling_plan_id", scaling_plan_id)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Should the Scaling Plan be enabled on this Host Pool.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="hostPoolId")
    def host_pool_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource ID for the Virtual Desktop Host Pool. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "host_pool_id")

    @host_pool_id.setter
    def host_pool_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "host_pool_id", value)

    @property
    @pulumi.getter(name="scalingPlanId")
    def scaling_plan_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource ID for the Virtual Desktop Scaling Plan. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "scaling_plan_id")

    @scaling_plan_id.setter
    def scaling_plan_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "scaling_plan_id", value)


@pulumi.type_token("azure:desktopvirtualization/scalingPlanHostPoolAssociation:ScalingPlanHostPoolAssociation")
class ScalingPlanHostPoolAssociation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 host_pool_id: Optional[pulumi.Input[builtins.str]] = None,
                 scaling_plan_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages a Virtual Desktop Scaling Plan Host Pool Association.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_azuread as azuread

        example_resource_group = azure.core.ResourceGroup("example",
            name="rg-example-virtualdesktop",
            location="West Europe")
        example = azuread.get_service_principal(display_name="Windows Virtual Desktop")
        example_assignment = azure.authorization.Assignment("example",
            scope=example_resource_group.id,
            role_definition_name="Desktop Virtualization Power On Off Contributor",
            principal_id=example.object_id)
        example_host_pool = azure.desktopvirtualization.HostPool("example",
            name="example-hostpool",
            location=example_resource_group.location,
            resource_group_name=example_resource_group.name,
            type="Pooled",
            validate_environment=True,
            load_balancer_type="BreadthFirst")
        example_scaling_plan = azure.desktopvirtualization.ScalingPlan("example",
            name="example-scaling-plan",
            location=example_resource_group.location,
            resource_group_name=example_resource_group.name,
            friendly_name="Scaling Plan Test",
            description="Test Scaling Plan",
            time_zone="GMT Standard Time",
            schedules=[{
                "name": "Weekdays",
                "days_of_weeks": [
                    "Monday",
                    "Tuesday",
                    "Wednesday",
                    "Thursday",
                    "Friday",
                ],
                "ramp_up_start_time": "06:00",
                "ramp_up_load_balancing_algorithm": "BreadthFirst",
                "ramp_up_minimum_hosts_percent": 20,
                "ramp_up_capacity_threshold_percent": 10,
                "peak_start_time": "09:00",
                "peak_load_balancing_algorithm": "BreadthFirst",
                "ramp_down_start_time": "18:00",
                "ramp_down_load_balancing_algorithm": "BreadthFirst",
                "ramp_down_minimum_hosts_percent": 10,
                "ramp_down_force_logoff_users": False,
                "ramp_down_wait_time_minutes": 45,
                "ramp_down_notification_message": "Please log of in the next 45 minutes...",
                "ramp_down_capacity_threshold_percent": 5,
                "ramp_down_stop_hosts_when": "ZeroSessions",
                "off_peak_start_time": "22:00",
                "off_peak_load_balancing_algorithm": "BreadthFirst",
            }],
            opts = pulumi.ResourceOptions(depends_on=[example_assignment]))
        example_scaling_plan_host_pool_association = azure.desktopvirtualization.ScalingPlanHostPoolAssociation("example",
            host_pool_id=example_host_pool.id,
            scaling_plan_id=example_scaling_plan.id,
            enabled=True,
            opts = pulumi.ResourceOptions(depends_on=[example_assignment]))
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.DesktopVirtualization`: 2024-04-03

        ## Import

        Associations between Virtual Desktop Scaling Plans and Virtual Desktop Host Pools can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:desktopvirtualization/scalingPlanHostPoolAssociation:ScalingPlanHostPoolAssociation example "/subscriptions/12345678-1234-9876-4563-123456789012/resourceGroups/resGroup1/providers/Microsoft.DesktopVirtualization/scalingPlans/plan1|/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myGroup1/providers/Microsoft.DesktopVirtualization/hostPools/myhostpool"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] enabled: Should the Scaling Plan be enabled on this Host Pool.
        :param pulumi.Input[builtins.str] host_pool_id: The resource ID for the Virtual Desktop Host Pool. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] scaling_plan_id: The resource ID for the Virtual Desktop Scaling Plan. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ScalingPlanHostPoolAssociationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Virtual Desktop Scaling Plan Host Pool Association.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_azuread as azuread

        example_resource_group = azure.core.ResourceGroup("example",
            name="rg-example-virtualdesktop",
            location="West Europe")
        example = azuread.get_service_principal(display_name="Windows Virtual Desktop")
        example_assignment = azure.authorization.Assignment("example",
            scope=example_resource_group.id,
            role_definition_name="Desktop Virtualization Power On Off Contributor",
            principal_id=example.object_id)
        example_host_pool = azure.desktopvirtualization.HostPool("example",
            name="example-hostpool",
            location=example_resource_group.location,
            resource_group_name=example_resource_group.name,
            type="Pooled",
            validate_environment=True,
            load_balancer_type="BreadthFirst")
        example_scaling_plan = azure.desktopvirtualization.ScalingPlan("example",
            name="example-scaling-plan",
            location=example_resource_group.location,
            resource_group_name=example_resource_group.name,
            friendly_name="Scaling Plan Test",
            description="Test Scaling Plan",
            time_zone="GMT Standard Time",
            schedules=[{
                "name": "Weekdays",
                "days_of_weeks": [
                    "Monday",
                    "Tuesday",
                    "Wednesday",
                    "Thursday",
                    "Friday",
                ],
                "ramp_up_start_time": "06:00",
                "ramp_up_load_balancing_algorithm": "BreadthFirst",
                "ramp_up_minimum_hosts_percent": 20,
                "ramp_up_capacity_threshold_percent": 10,
                "peak_start_time": "09:00",
                "peak_load_balancing_algorithm": "BreadthFirst",
                "ramp_down_start_time": "18:00",
                "ramp_down_load_balancing_algorithm": "BreadthFirst",
                "ramp_down_minimum_hosts_percent": 10,
                "ramp_down_force_logoff_users": False,
                "ramp_down_wait_time_minutes": 45,
                "ramp_down_notification_message": "Please log of in the next 45 minutes...",
                "ramp_down_capacity_threshold_percent": 5,
                "ramp_down_stop_hosts_when": "ZeroSessions",
                "off_peak_start_time": "22:00",
                "off_peak_load_balancing_algorithm": "BreadthFirst",
            }],
            opts = pulumi.ResourceOptions(depends_on=[example_assignment]))
        example_scaling_plan_host_pool_association = azure.desktopvirtualization.ScalingPlanHostPoolAssociation("example",
            host_pool_id=example_host_pool.id,
            scaling_plan_id=example_scaling_plan.id,
            enabled=True,
            opts = pulumi.ResourceOptions(depends_on=[example_assignment]))
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.DesktopVirtualization`: 2024-04-03

        ## Import

        Associations between Virtual Desktop Scaling Plans and Virtual Desktop Host Pools can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:desktopvirtualization/scalingPlanHostPoolAssociation:ScalingPlanHostPoolAssociation example "/subscriptions/12345678-1234-9876-4563-123456789012/resourceGroups/resGroup1/providers/Microsoft.DesktopVirtualization/scalingPlans/plan1|/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myGroup1/providers/Microsoft.DesktopVirtualization/hostPools/myhostpool"
        ```

        :param str resource_name: The name of the resource.
        :param ScalingPlanHostPoolAssociationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ScalingPlanHostPoolAssociationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 host_pool_id: Optional[pulumi.Input[builtins.str]] = None,
                 scaling_plan_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ScalingPlanHostPoolAssociationArgs.__new__(ScalingPlanHostPoolAssociationArgs)

            if enabled is None and not opts.urn:
                raise TypeError("Missing required property 'enabled'")
            __props__.__dict__["enabled"] = enabled
            if host_pool_id is None and not opts.urn:
                raise TypeError("Missing required property 'host_pool_id'")
            __props__.__dict__["host_pool_id"] = host_pool_id
            if scaling_plan_id is None and not opts.urn:
                raise TypeError("Missing required property 'scaling_plan_id'")
            __props__.__dict__["scaling_plan_id"] = scaling_plan_id
        super(ScalingPlanHostPoolAssociation, __self__).__init__(
            'azure:desktopvirtualization/scalingPlanHostPoolAssociation:ScalingPlanHostPoolAssociation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            enabled: Optional[pulumi.Input[builtins.bool]] = None,
            host_pool_id: Optional[pulumi.Input[builtins.str]] = None,
            scaling_plan_id: Optional[pulumi.Input[builtins.str]] = None) -> 'ScalingPlanHostPoolAssociation':
        """
        Get an existing ScalingPlanHostPoolAssociation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] enabled: Should the Scaling Plan be enabled on this Host Pool.
        :param pulumi.Input[builtins.str] host_pool_id: The resource ID for the Virtual Desktop Host Pool. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] scaling_plan_id: The resource ID for the Virtual Desktop Scaling Plan. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ScalingPlanHostPoolAssociationState.__new__(_ScalingPlanHostPoolAssociationState)

        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["host_pool_id"] = host_pool_id
        __props__.__dict__["scaling_plan_id"] = scaling_plan_id
        return ScalingPlanHostPoolAssociation(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[builtins.bool]:
        """
        Should the Scaling Plan be enabled on this Host Pool.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="hostPoolId")
    def host_pool_id(self) -> pulumi.Output[builtins.str]:
        """
        The resource ID for the Virtual Desktop Host Pool. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "host_pool_id")

    @property
    @pulumi.getter(name="scalingPlanId")
    def scaling_plan_id(self) -> pulumi.Output[builtins.str]:
        """
        The resource ID for the Virtual Desktop Scaling Plan. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "scaling_plan_id")

