# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['WorkspaceApplicationGroupAssociationArgs', 'WorkspaceApplicationGroupAssociation']

@pulumi.input_type
class WorkspaceApplicationGroupAssociationArgs:
    def __init__(__self__, *,
                 application_group_id: pulumi.Input[builtins.str],
                 workspace_id: pulumi.Input[builtins.str]):
        """
        The set of arguments for constructing a WorkspaceApplicationGroupAssociation resource.
        :param pulumi.Input[builtins.str] application_group_id: The resource ID for the Virtual Desktop Application Group. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] workspace_id: The resource ID for the Virtual Desktop Workspace. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "application_group_id", application_group_id)
        pulumi.set(__self__, "workspace_id", workspace_id)

    @property
    @pulumi.getter(name="applicationGroupId")
    def application_group_id(self) -> pulumi.Input[builtins.str]:
        """
        The resource ID for the Virtual Desktop Application Group. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "application_group_id")

    @application_group_id.setter
    def application_group_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "application_group_id", value)

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Input[builtins.str]:
        """
        The resource ID for the Virtual Desktop Workspace. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "workspace_id", value)


@pulumi.input_type
class _WorkspaceApplicationGroupAssociationState:
    def __init__(__self__, *,
                 application_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 workspace_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering WorkspaceApplicationGroupAssociation resources.
        :param pulumi.Input[builtins.str] application_group_id: The resource ID for the Virtual Desktop Application Group. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] workspace_id: The resource ID for the Virtual Desktop Workspace. Changing this forces a new resource to be created.
        """
        if application_group_id is not None:
            pulumi.set(__self__, "application_group_id", application_group_id)
        if workspace_id is not None:
            pulumi.set(__self__, "workspace_id", workspace_id)

    @property
    @pulumi.getter(name="applicationGroupId")
    def application_group_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource ID for the Virtual Desktop Application Group. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "application_group_id")

    @application_group_id.setter
    def application_group_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "application_group_id", value)

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource ID for the Virtual Desktop Workspace. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "workspace_id", value)


@pulumi.type_token("azure:desktopvirtualization/workspaceApplicationGroupAssociation:WorkspaceApplicationGroupAssociation")
class WorkspaceApplicationGroupAssociation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 workspace_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages a Virtual Desktop Workspace Application Group Association.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="rg-example-virtualdesktop",
            location="West Europe")
        pooledbreadthfirst = azure.desktopvirtualization.HostPool("pooledbreadthfirst",
            name="pooledbreadthfirst",
            location=example.location,
            resource_group_name=example.name,
            type="Pooled",
            load_balancer_type="BreadthFirst")
        remoteapp = azure.desktopvirtualization.ApplicationGroup("remoteapp",
            name="remoteapp",
            location=example.location,
            resource_group_name=example.name,
            type="RemoteApp",
            host_pool_id=pooledbreadthfirst.id)
        workspace = azure.desktopvirtualization.Workspace("workspace",
            name="workspace",
            location=example.location,
            resource_group_name=example.name)
        workspaceremoteapp = azure.desktopvirtualization.WorkspaceApplicationGroupAssociation("workspaceremoteapp",
            workspace_id=workspace.id,
            application_group_id=remoteapp.id)
        ```

        ## Import

        Associations between Virtual Desktop Workspaces and Virtual Desktop Application Groups can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:desktopvirtualization/workspaceApplicationGroupAssociation:WorkspaceApplicationGroupAssociation association1 "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myGroup1/providers/Microsoft.DesktopVirtualization/workspaces/myworkspace|/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myGroup1/providers/Microsoft.DesktopVirtualization/applicationGroups/myapplicationgroup"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] application_group_id: The resource ID for the Virtual Desktop Application Group. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] workspace_id: The resource ID for the Virtual Desktop Workspace. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WorkspaceApplicationGroupAssociationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Virtual Desktop Workspace Application Group Association.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="rg-example-virtualdesktop",
            location="West Europe")
        pooledbreadthfirst = azure.desktopvirtualization.HostPool("pooledbreadthfirst",
            name="pooledbreadthfirst",
            location=example.location,
            resource_group_name=example.name,
            type="Pooled",
            load_balancer_type="BreadthFirst")
        remoteapp = azure.desktopvirtualization.ApplicationGroup("remoteapp",
            name="remoteapp",
            location=example.location,
            resource_group_name=example.name,
            type="RemoteApp",
            host_pool_id=pooledbreadthfirst.id)
        workspace = azure.desktopvirtualization.Workspace("workspace",
            name="workspace",
            location=example.location,
            resource_group_name=example.name)
        workspaceremoteapp = azure.desktopvirtualization.WorkspaceApplicationGroupAssociation("workspaceremoteapp",
            workspace_id=workspace.id,
            application_group_id=remoteapp.id)
        ```

        ## Import

        Associations between Virtual Desktop Workspaces and Virtual Desktop Application Groups can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:desktopvirtualization/workspaceApplicationGroupAssociation:WorkspaceApplicationGroupAssociation association1 "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myGroup1/providers/Microsoft.DesktopVirtualization/workspaces/myworkspace|/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myGroup1/providers/Microsoft.DesktopVirtualization/applicationGroups/myapplicationgroup"
        ```

        :param str resource_name: The name of the resource.
        :param WorkspaceApplicationGroupAssociationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WorkspaceApplicationGroupAssociationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 workspace_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WorkspaceApplicationGroupAssociationArgs.__new__(WorkspaceApplicationGroupAssociationArgs)

            if application_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'application_group_id'")
            __props__.__dict__["application_group_id"] = application_group_id
            if workspace_id is None and not opts.urn:
                raise TypeError("Missing required property 'workspace_id'")
            __props__.__dict__["workspace_id"] = workspace_id
        super(WorkspaceApplicationGroupAssociation, __self__).__init__(
            'azure:desktopvirtualization/workspaceApplicationGroupAssociation:WorkspaceApplicationGroupAssociation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            application_group_id: Optional[pulumi.Input[builtins.str]] = None,
            workspace_id: Optional[pulumi.Input[builtins.str]] = None) -> 'WorkspaceApplicationGroupAssociation':
        """
        Get an existing WorkspaceApplicationGroupAssociation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] application_group_id: The resource ID for the Virtual Desktop Application Group. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] workspace_id: The resource ID for the Virtual Desktop Workspace. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WorkspaceApplicationGroupAssociationState.__new__(_WorkspaceApplicationGroupAssociationState)

        __props__.__dict__["application_group_id"] = application_group_id
        __props__.__dict__["workspace_id"] = workspace_id
        return WorkspaceApplicationGroupAssociation(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="applicationGroupId")
    def application_group_id(self) -> pulumi.Output[builtins.str]:
        """
        The resource ID for the Virtual Desktop Application Group. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "application_group_id")

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Output[builtins.str]:
        """
        The resource ID for the Virtual Desktop Workspace. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "workspace_id")

