# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetCatalogResult',
    'AwaitableGetCatalogResult',
    'get_catalog',
    'get_catalog_output',
]

@pulumi.output_type
class GetCatalogResult:
    """
    A collection of values returned by getCatalog.
    """
    def __init__(__self__, catalog_adogits=None, catalog_githubs=None, dev_center_id=None, id=None, name=None):
        if catalog_adogits and not isinstance(catalog_adogits, list):
            raise TypeError("Expected argument 'catalog_adogits' to be a list")
        pulumi.set(__self__, "catalog_adogits", catalog_adogits)
        if catalog_githubs and not isinstance(catalog_githubs, list):
            raise TypeError("Expected argument 'catalog_githubs' to be a list")
        pulumi.set(__self__, "catalog_githubs", catalog_githubs)
        if dev_center_id and not isinstance(dev_center_id, str):
            raise TypeError("Expected argument 'dev_center_id' to be a str")
        pulumi.set(__self__, "dev_center_id", dev_center_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="catalogAdogits")
    def catalog_adogits(self) -> Sequence['outputs.GetCatalogCatalogAdogitResult']:
        """
        A `catalog_adogit` block as defined below.
        """
        return pulumi.get(self, "catalog_adogits")

    @property
    @pulumi.getter(name="catalogGithubs")
    def catalog_githubs(self) -> Sequence['outputs.GetCatalogCatalogGithubResult']:
        """
        A `catalog_github` block as defined below.
        """
        return pulumi.get(self, "catalog_githubs")

    @property
    @pulumi.getter(name="devCenterId")
    def dev_center_id(self) -> builtins.str:
        return pulumi.get(self, "dev_center_id")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")


class AwaitableGetCatalogResult(GetCatalogResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCatalogResult(
            catalog_adogits=self.catalog_adogits,
            catalog_githubs=self.catalog_githubs,
            dev_center_id=self.dev_center_id,
            id=self.id,
            name=self.name)


def get_catalog(dev_center_id: Optional[builtins.str] = None,
                name: Optional[builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCatalogResult:
    """
    Use this data source to access information about an existing Dev Center Catalog.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.devcenter.get_catalog(name=example_azurerm_dev_center_catalog["name"],
        dev_center_id=example_azurerm_dev_center_catalog["devCenterId"])
    pulumi.export("id", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.DevCenter`: 2025-02-01


    :param builtins.str dev_center_id: Specifies the Dev Center Id within which this Dev Center Catalog should exist.
    :param builtins.str name: The name of this Dev Center Catalog.
    """
    __args__ = dict()
    __args__['devCenterId'] = dev_center_id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:devcenter/getCatalog:getCatalog', __args__, opts=opts, typ=GetCatalogResult).value

    return AwaitableGetCatalogResult(
        catalog_adogits=pulumi.get(__ret__, 'catalog_adogits'),
        catalog_githubs=pulumi.get(__ret__, 'catalog_githubs'),
        dev_center_id=pulumi.get(__ret__, 'dev_center_id'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'))
def get_catalog_output(dev_center_id: Optional[pulumi.Input[builtins.str]] = None,
                       name: Optional[pulumi.Input[builtins.str]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCatalogResult]:
    """
    Use this data source to access information about an existing Dev Center Catalog.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.devcenter.get_catalog(name=example_azurerm_dev_center_catalog["name"],
        dev_center_id=example_azurerm_dev_center_catalog["devCenterId"])
    pulumi.export("id", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.DevCenter`: 2025-02-01


    :param builtins.str dev_center_id: Specifies the Dev Center Id within which this Dev Center Catalog should exist.
    :param builtins.str name: The name of this Dev Center Catalog.
    """
    __args__ = dict()
    __args__['devCenterId'] = dev_center_id
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:devcenter/getCatalog:getCatalog', __args__, opts=opts, typ=GetCatalogResult)
    return __ret__.apply(lambda __response__: GetCatalogResult(
        catalog_adogits=pulumi.get(__response__, 'catalog_adogits'),
        catalog_githubs=pulumi.get(__response__, 'catalog_githubs'),
        dev_center_id=pulumi.get(__response__, 'dev_center_id'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name')))
