# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetDevBoxDefinitionResult',
    'AwaitableGetDevBoxDefinitionResult',
    'get_dev_box_definition',
    'get_dev_box_definition_output',
]

@pulumi.output_type
class GetDevBoxDefinitionResult:
    """
    A collection of values returned by getDevBoxDefinition.
    """
    def __init__(__self__, dev_center_id=None, id=None, image_reference_id=None, location=None, name=None, sku_name=None, tags=None):
        if dev_center_id and not isinstance(dev_center_id, str):
            raise TypeError("Expected argument 'dev_center_id' to be a str")
        pulumi.set(__self__, "dev_center_id", dev_center_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if image_reference_id and not isinstance(image_reference_id, str):
            raise TypeError("Expected argument 'image_reference_id' to be a str")
        pulumi.set(__self__, "image_reference_id", image_reference_id)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if sku_name and not isinstance(sku_name, str):
            raise TypeError("Expected argument 'sku_name' to be a str")
        pulumi.set(__self__, "sku_name", sku_name)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="devCenterId")
    def dev_center_id(self) -> builtins.str:
        return pulumi.get(self, "dev_center_id")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="imageReferenceId")
    def image_reference_id(self) -> builtins.str:
        """
        The ID of the image for the Dev Center Dev Box Definition.
        """
        return pulumi.get(self, "image_reference_id")

    @property
    @pulumi.getter
    def location(self) -> builtins.str:
        """
        The Azure Region where the Dev Center Dev Box Definition exists.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> builtins.str:
        """
        The name of the SKU for the Dev Center Dev Box Definition.
        """
        return pulumi.get(self, "sku_name")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, builtins.str]:
        """
        A mapping of tags assigned to the Dev Center Dev Box Definition.
        """
        return pulumi.get(self, "tags")


class AwaitableGetDevBoxDefinitionResult(GetDevBoxDefinitionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDevBoxDefinitionResult(
            dev_center_id=self.dev_center_id,
            id=self.id,
            image_reference_id=self.image_reference_id,
            location=self.location,
            name=self.name,
            sku_name=self.sku_name,
            tags=self.tags)


def get_dev_box_definition(dev_center_id: Optional[builtins.str] = None,
                           name: Optional[builtins.str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDevBoxDefinitionResult:
    """
    Use this data source to access information about an existing Dev Center Dev Box Definition.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.devcenter.get_dev_box_definition(name=example_azurerm_dev_center_dev_box_definition["name"],
        dev_center_id=example_azurerm_dev_center_dev_box_definition["devCenterId"])
    pulumi.export("id", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.DevCenter`: 2025-02-01


    :param builtins.str dev_center_id: The ID of the associated Dev Center.
    :param builtins.str name: The name of this Dev Center Dev Box Definition.
    """
    __args__ = dict()
    __args__['devCenterId'] = dev_center_id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:devcenter/getDevBoxDefinition:getDevBoxDefinition', __args__, opts=opts, typ=GetDevBoxDefinitionResult).value

    return AwaitableGetDevBoxDefinitionResult(
        dev_center_id=pulumi.get(__ret__, 'dev_center_id'),
        id=pulumi.get(__ret__, 'id'),
        image_reference_id=pulumi.get(__ret__, 'image_reference_id'),
        location=pulumi.get(__ret__, 'location'),
        name=pulumi.get(__ret__, 'name'),
        sku_name=pulumi.get(__ret__, 'sku_name'),
        tags=pulumi.get(__ret__, 'tags'))
def get_dev_box_definition_output(dev_center_id: Optional[pulumi.Input[builtins.str]] = None,
                                  name: Optional[pulumi.Input[builtins.str]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDevBoxDefinitionResult]:
    """
    Use this data source to access information about an existing Dev Center Dev Box Definition.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.devcenter.get_dev_box_definition(name=example_azurerm_dev_center_dev_box_definition["name"],
        dev_center_id=example_azurerm_dev_center_dev_box_definition["devCenterId"])
    pulumi.export("id", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.DevCenter`: 2025-02-01


    :param builtins.str dev_center_id: The ID of the associated Dev Center.
    :param builtins.str name: The name of this Dev Center Dev Box Definition.
    """
    __args__ = dict()
    __args__['devCenterId'] = dev_center_id
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:devcenter/getDevBoxDefinition:getDevBoxDefinition', __args__, opts=opts, typ=GetDevBoxDefinitionResult)
    return __ret__.apply(lambda __response__: GetDevBoxDefinitionResult(
        dev_center_id=pulumi.get(__response__, 'dev_center_id'),
        id=pulumi.get(__response__, 'id'),
        image_reference_id=pulumi.get(__response__, 'image_reference_id'),
        location=pulumi.get(__response__, 'location'),
        name=pulumi.get(__response__, 'name'),
        sku_name=pulumi.get(__response__, 'sku_name'),
        tags=pulumi.get(__response__, 'tags')))
