# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetGalleryResult',
    'AwaitableGetGalleryResult',
    'get_gallery',
    'get_gallery_output',
]

@pulumi.output_type
class GetGalleryResult:
    """
    A collection of values returned by getGallery.
    """
    def __init__(__self__, dev_center_id=None, id=None, name=None, shared_gallery_id=None):
        if dev_center_id and not isinstance(dev_center_id, str):
            raise TypeError("Expected argument 'dev_center_id' to be a str")
        pulumi.set(__self__, "dev_center_id", dev_center_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if shared_gallery_id and not isinstance(shared_gallery_id, str):
            raise TypeError("Expected argument 'shared_gallery_id' to be a str")
        pulumi.set(__self__, "shared_gallery_id", shared_gallery_id)

    @property
    @pulumi.getter(name="devCenterId")
    def dev_center_id(self) -> builtins.str:
        return pulumi.get(self, "dev_center_id")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="sharedGalleryId")
    def shared_gallery_id(self) -> builtins.str:
        """
        The ID of the Shared Gallery connected to the Dev Center Gallery.
        """
        return pulumi.get(self, "shared_gallery_id")


class AwaitableGetGalleryResult(GetGalleryResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetGalleryResult(
            dev_center_id=self.dev_center_id,
            id=self.id,
            name=self.name,
            shared_gallery_id=self.shared_gallery_id)


def get_gallery(dev_center_id: Optional[builtins.str] = None,
                name: Optional[builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetGalleryResult:
    """
    Use this data source to access information about an existing Dev Center Gallery.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.devcenter.get_gallery(name=example_azurerm_dev_center_gallery["name"],
        dev_center_id=example_azurerm_dev_center_gallery["devCenterId"])
    pulumi.export("id", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.DevCenter`: 2025-02-01


    :param builtins.str dev_center_id: The ID of the Dev Center which contains the Dev Center Gallery.
    :param builtins.str name: The name of this Dev Center Gallery.
    """
    __args__ = dict()
    __args__['devCenterId'] = dev_center_id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:devcenter/getGallery:getGallery', __args__, opts=opts, typ=GetGalleryResult).value

    return AwaitableGetGalleryResult(
        dev_center_id=pulumi.get(__ret__, 'dev_center_id'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        shared_gallery_id=pulumi.get(__ret__, 'shared_gallery_id'))
def get_gallery_output(dev_center_id: Optional[pulumi.Input[builtins.str]] = None,
                       name: Optional[pulumi.Input[builtins.str]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetGalleryResult]:
    """
    Use this data source to access information about an existing Dev Center Gallery.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.devcenter.get_gallery(name=example_azurerm_dev_center_gallery["name"],
        dev_center_id=example_azurerm_dev_center_gallery["devCenterId"])
    pulumi.export("id", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.DevCenter`: 2025-02-01


    :param builtins.str dev_center_id: The ID of the Dev Center which contains the Dev Center Gallery.
    :param builtins.str name: The name of this Dev Center Gallery.
    """
    __args__ = dict()
    __args__['devCenterId'] = dev_center_id
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:devcenter/getGallery:getGallery', __args__, opts=opts, typ=GetGalleryResult)
    return __ret__.apply(lambda __response__: GetGalleryResult(
        dev_center_id=pulumi.get(__response__, 'dev_center_id'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        shared_gallery_id=pulumi.get(__response__, 'shared_gallery_id')))
