# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['GlobalVMShutdownScheduleArgs', 'GlobalVMShutdownSchedule']

@pulumi.input_type
class GlobalVMShutdownScheduleArgs:
    def __init__(__self__, *,
                 daily_recurrence_time: pulumi.Input[builtins.str],
                 notification_settings: pulumi.Input['GlobalVMShutdownScheduleNotificationSettingsArgs'],
                 timezone: pulumi.Input[builtins.str],
                 virtual_machine_id: pulumi.Input[builtins.str],
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a GlobalVMShutdownSchedule resource.
        :param pulumi.Input[builtins.str] daily_recurrence_time: The time each day when the schedule takes effect. Must match the format HHmm where HH is 00-23 and mm is 00-59 (e.g. 0930, 2300, etc.)
        :param pulumi.Input['GlobalVMShutdownScheduleNotificationSettingsArgs'] notification_settings: The notification setting of a schedule. A `notification_settings` block as defined below.
        :param pulumi.Input[builtins.str] timezone: The time zone ID (e.g. Pacific Standard time). Refer to this guide for a [full list of accepted time zone names](https://jackstromberg.com/2017/01/list-of-time-zones-consumed-by-azure/).
        :param pulumi.Input[builtins.str] virtual_machine_id: The resource ID of the target ARM-based Virtual Machine. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] enabled: Whether to enable the schedule. Possible values are `true` and `false`. Defaults to `true`.
        :param pulumi.Input[builtins.str] location: The location where the schedule is created. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        pulumi.set(__self__, "daily_recurrence_time", daily_recurrence_time)
        pulumi.set(__self__, "notification_settings", notification_settings)
        pulumi.set(__self__, "timezone", timezone)
        pulumi.set(__self__, "virtual_machine_id", virtual_machine_id)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="dailyRecurrenceTime")
    def daily_recurrence_time(self) -> pulumi.Input[builtins.str]:
        """
        The time each day when the schedule takes effect. Must match the format HHmm where HH is 00-23 and mm is 00-59 (e.g. 0930, 2300, etc.)
        """
        return pulumi.get(self, "daily_recurrence_time")

    @daily_recurrence_time.setter
    def daily_recurrence_time(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "daily_recurrence_time", value)

    @property
    @pulumi.getter(name="notificationSettings")
    def notification_settings(self) -> pulumi.Input['GlobalVMShutdownScheduleNotificationSettingsArgs']:
        """
        The notification setting of a schedule. A `notification_settings` block as defined below.
        """
        return pulumi.get(self, "notification_settings")

    @notification_settings.setter
    def notification_settings(self, value: pulumi.Input['GlobalVMShutdownScheduleNotificationSettingsArgs']):
        pulumi.set(self, "notification_settings", value)

    @property
    @pulumi.getter
    def timezone(self) -> pulumi.Input[builtins.str]:
        """
        The time zone ID (e.g. Pacific Standard time). Refer to this guide for a [full list of accepted time zone names](https://jackstromberg.com/2017/01/list-of-time-zones-consumed-by-azure/).
        """
        return pulumi.get(self, "timezone")

    @timezone.setter
    def timezone(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "timezone", value)

    @property
    @pulumi.getter(name="virtualMachineId")
    def virtual_machine_id(self) -> pulumi.Input[builtins.str]:
        """
        The resource ID of the target ARM-based Virtual Machine. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "virtual_machine_id")

    @virtual_machine_id.setter
    def virtual_machine_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "virtual_machine_id", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to enable the schedule. Possible values are `true` and `false`. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The location where the schedule is created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _GlobalVMShutdownScheduleState:
    def __init__(__self__, *,
                 daily_recurrence_time: Optional[pulumi.Input[builtins.str]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 notification_settings: Optional[pulumi.Input['GlobalVMShutdownScheduleNotificationSettingsArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 timezone: Optional[pulumi.Input[builtins.str]] = None,
                 virtual_machine_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering GlobalVMShutdownSchedule resources.
        :param pulumi.Input[builtins.str] daily_recurrence_time: The time each day when the schedule takes effect. Must match the format HHmm where HH is 00-23 and mm is 00-59 (e.g. 0930, 2300, etc.)
        :param pulumi.Input[builtins.bool] enabled: Whether to enable the schedule. Possible values are `true` and `false`. Defaults to `true`.
        :param pulumi.Input[builtins.str] location: The location where the schedule is created. Changing this forces a new resource to be created.
        :param pulumi.Input['GlobalVMShutdownScheduleNotificationSettingsArgs'] notification_settings: The notification setting of a schedule. A `notification_settings` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[builtins.str] timezone: The time zone ID (e.g. Pacific Standard time). Refer to this guide for a [full list of accepted time zone names](https://jackstromberg.com/2017/01/list-of-time-zones-consumed-by-azure/).
        :param pulumi.Input[builtins.str] virtual_machine_id: The resource ID of the target ARM-based Virtual Machine. Changing this forces a new resource to be created.
        """
        if daily_recurrence_time is not None:
            pulumi.set(__self__, "daily_recurrence_time", daily_recurrence_time)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if notification_settings is not None:
            pulumi.set(__self__, "notification_settings", notification_settings)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)
        if virtual_machine_id is not None:
            pulumi.set(__self__, "virtual_machine_id", virtual_machine_id)

    @property
    @pulumi.getter(name="dailyRecurrenceTime")
    def daily_recurrence_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time each day when the schedule takes effect. Must match the format HHmm where HH is 00-23 and mm is 00-59 (e.g. 0930, 2300, etc.)
        """
        return pulumi.get(self, "daily_recurrence_time")

    @daily_recurrence_time.setter
    def daily_recurrence_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "daily_recurrence_time", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to enable the schedule. Possible values are `true` and `false`. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The location where the schedule is created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="notificationSettings")
    def notification_settings(self) -> Optional[pulumi.Input['GlobalVMShutdownScheduleNotificationSettingsArgs']]:
        """
        The notification setting of a schedule. A `notification_settings` block as defined below.
        """
        return pulumi.get(self, "notification_settings")

    @notification_settings.setter
    def notification_settings(self, value: Optional[pulumi.Input['GlobalVMShutdownScheduleNotificationSettingsArgs']]):
        pulumi.set(self, "notification_settings", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def timezone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time zone ID (e.g. Pacific Standard time). Refer to this guide for a [full list of accepted time zone names](https://jackstromberg.com/2017/01/list-of-time-zones-consumed-by-azure/).
        """
        return pulumi.get(self, "timezone")

    @timezone.setter
    def timezone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "timezone", value)

    @property
    @pulumi.getter(name="virtualMachineId")
    def virtual_machine_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource ID of the target ARM-based Virtual Machine. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "virtual_machine_id")

    @virtual_machine_id.setter
    def virtual_machine_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "virtual_machine_id", value)


@pulumi.type_token("azure:devtest/globalVMShutdownSchedule:GlobalVMShutdownSchedule")
class GlobalVMShutdownSchedule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 daily_recurrence_time: Optional[pulumi.Input[builtins.str]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 notification_settings: Optional[pulumi.Input[Union['GlobalVMShutdownScheduleNotificationSettingsArgs', 'GlobalVMShutdownScheduleNotificationSettingsArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 timezone: Optional[pulumi.Input[builtins.str]] = None,
                 virtual_machine_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages automated shutdown schedules for Azure VMs that are not within an Azure DevTest Lab. While this is part of the DevTest Labs service in Azure,
        this resource applies only to standard VMs, not DevTest Lab VMs. To manage automated shutdown schedules for DevTest Lab VMs, reference the
        `devtest.Schedule` resource

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="sample-rg",
            location="West Europe")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="sample-vnet",
            address_spaces=["10.0.0.0/16"],
            location=example.location,
            resource_group_name=example.name)
        example_subnet = azure.network.Subnet("example",
            name="sample-subnet",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.2.0/24"])
        example_network_interface = azure.network.NetworkInterface("example",
            name="sample-nic",
            location=example.location,
            resource_group_name=example.name,
            ip_configurations=[{
                "name": "testconfiguration1",
                "subnet_id": example_subnet.id,
                "private_ip_address_allocation": "Dynamic",
            }])
        example_linux_virtual_machine = azure.compute.LinuxVirtualMachine("example",
            name="SampleVM",
            location=example.location,
            resource_group_name=example.name,
            network_interface_ids=[example_network_interface.id],
            size="Standard_B2s",
            source_image_reference={
                "publisher": "Canonical",
                "offer": "0001-com-ubuntu-server-jammy",
                "sku": "22_04-lts",
                "version": "latest",
            },
            os_disk={
                "name": "myosdisk-example",
                "caching": "ReadWrite",
                "storage_account_type": "Standard_LRS",
            },
            admin_username="testadmin",
            admin_password="Password1234!",
            disable_password_authentication=False)
        example_global_vm_shutdown_schedule = azure.devtest.GlobalVMShutdownSchedule("example",
            virtual_machine_id=example_linux_virtual_machine.id,
            location=example.location,
            enabled=True,
            daily_recurrence_time="1100",
            timezone="Pacific Standard Time",
            notification_settings={
                "enabled": True,
                "time_in_minutes": 60,
                "webhook_url": "https://sample-webhook-url.example.com",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.DevTestLab`: 2018-09-15

        ## Import

        An existing Dev Test Global Shutdown Schedule can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:devtest/globalVMShutdownSchedule:GlobalVMShutdownSchedule example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/sample-rg/providers/Microsoft.DevTestLab/schedules/shutdown-computevm-SampleVM
        ```

        The name of the resource within the `resource id` will always follow the format `shutdown-computevm-<VM Name>` where `<VM Name>` is replaced by the name of the target Virtual Machine

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] daily_recurrence_time: The time each day when the schedule takes effect. Must match the format HHmm where HH is 00-23 and mm is 00-59 (e.g. 0930, 2300, etc.)
        :param pulumi.Input[builtins.bool] enabled: Whether to enable the schedule. Possible values are `true` and `false`. Defaults to `true`.
        :param pulumi.Input[builtins.str] location: The location where the schedule is created. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['GlobalVMShutdownScheduleNotificationSettingsArgs', 'GlobalVMShutdownScheduleNotificationSettingsArgsDict']] notification_settings: The notification setting of a schedule. A `notification_settings` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[builtins.str] timezone: The time zone ID (e.g. Pacific Standard time). Refer to this guide for a [full list of accepted time zone names](https://jackstromberg.com/2017/01/list-of-time-zones-consumed-by-azure/).
        :param pulumi.Input[builtins.str] virtual_machine_id: The resource ID of the target ARM-based Virtual Machine. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GlobalVMShutdownScheduleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages automated shutdown schedules for Azure VMs that are not within an Azure DevTest Lab. While this is part of the DevTest Labs service in Azure,
        this resource applies only to standard VMs, not DevTest Lab VMs. To manage automated shutdown schedules for DevTest Lab VMs, reference the
        `devtest.Schedule` resource

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="sample-rg",
            location="West Europe")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="sample-vnet",
            address_spaces=["10.0.0.0/16"],
            location=example.location,
            resource_group_name=example.name)
        example_subnet = azure.network.Subnet("example",
            name="sample-subnet",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.2.0/24"])
        example_network_interface = azure.network.NetworkInterface("example",
            name="sample-nic",
            location=example.location,
            resource_group_name=example.name,
            ip_configurations=[{
                "name": "testconfiguration1",
                "subnet_id": example_subnet.id,
                "private_ip_address_allocation": "Dynamic",
            }])
        example_linux_virtual_machine = azure.compute.LinuxVirtualMachine("example",
            name="SampleVM",
            location=example.location,
            resource_group_name=example.name,
            network_interface_ids=[example_network_interface.id],
            size="Standard_B2s",
            source_image_reference={
                "publisher": "Canonical",
                "offer": "0001-com-ubuntu-server-jammy",
                "sku": "22_04-lts",
                "version": "latest",
            },
            os_disk={
                "name": "myosdisk-example",
                "caching": "ReadWrite",
                "storage_account_type": "Standard_LRS",
            },
            admin_username="testadmin",
            admin_password="Password1234!",
            disable_password_authentication=False)
        example_global_vm_shutdown_schedule = azure.devtest.GlobalVMShutdownSchedule("example",
            virtual_machine_id=example_linux_virtual_machine.id,
            location=example.location,
            enabled=True,
            daily_recurrence_time="1100",
            timezone="Pacific Standard Time",
            notification_settings={
                "enabled": True,
                "time_in_minutes": 60,
                "webhook_url": "https://sample-webhook-url.example.com",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.DevTestLab`: 2018-09-15

        ## Import

        An existing Dev Test Global Shutdown Schedule can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:devtest/globalVMShutdownSchedule:GlobalVMShutdownSchedule example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/sample-rg/providers/Microsoft.DevTestLab/schedules/shutdown-computevm-SampleVM
        ```

        The name of the resource within the `resource id` will always follow the format `shutdown-computevm-<VM Name>` where `<VM Name>` is replaced by the name of the target Virtual Machine

        :param str resource_name: The name of the resource.
        :param GlobalVMShutdownScheduleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GlobalVMShutdownScheduleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 daily_recurrence_time: Optional[pulumi.Input[builtins.str]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 notification_settings: Optional[pulumi.Input[Union['GlobalVMShutdownScheduleNotificationSettingsArgs', 'GlobalVMShutdownScheduleNotificationSettingsArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 timezone: Optional[pulumi.Input[builtins.str]] = None,
                 virtual_machine_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GlobalVMShutdownScheduleArgs.__new__(GlobalVMShutdownScheduleArgs)

            if daily_recurrence_time is None and not opts.urn:
                raise TypeError("Missing required property 'daily_recurrence_time'")
            __props__.__dict__["daily_recurrence_time"] = daily_recurrence_time
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["location"] = location
            if notification_settings is None and not opts.urn:
                raise TypeError("Missing required property 'notification_settings'")
            __props__.__dict__["notification_settings"] = notification_settings
            __props__.__dict__["tags"] = tags
            if timezone is None and not opts.urn:
                raise TypeError("Missing required property 'timezone'")
            __props__.__dict__["timezone"] = timezone
            if virtual_machine_id is None and not opts.urn:
                raise TypeError("Missing required property 'virtual_machine_id'")
            __props__.__dict__["virtual_machine_id"] = virtual_machine_id
        super(GlobalVMShutdownSchedule, __self__).__init__(
            'azure:devtest/globalVMShutdownSchedule:GlobalVMShutdownSchedule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            daily_recurrence_time: Optional[pulumi.Input[builtins.str]] = None,
            enabled: Optional[pulumi.Input[builtins.bool]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            notification_settings: Optional[pulumi.Input[Union['GlobalVMShutdownScheduleNotificationSettingsArgs', 'GlobalVMShutdownScheduleNotificationSettingsArgsDict']]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            timezone: Optional[pulumi.Input[builtins.str]] = None,
            virtual_machine_id: Optional[pulumi.Input[builtins.str]] = None) -> 'GlobalVMShutdownSchedule':
        """
        Get an existing GlobalVMShutdownSchedule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] daily_recurrence_time: The time each day when the schedule takes effect. Must match the format HHmm where HH is 00-23 and mm is 00-59 (e.g. 0930, 2300, etc.)
        :param pulumi.Input[builtins.bool] enabled: Whether to enable the schedule. Possible values are `true` and `false`. Defaults to `true`.
        :param pulumi.Input[builtins.str] location: The location where the schedule is created. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['GlobalVMShutdownScheduleNotificationSettingsArgs', 'GlobalVMShutdownScheduleNotificationSettingsArgsDict']] notification_settings: The notification setting of a schedule. A `notification_settings` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[builtins.str] timezone: The time zone ID (e.g. Pacific Standard time). Refer to this guide for a [full list of accepted time zone names](https://jackstromberg.com/2017/01/list-of-time-zones-consumed-by-azure/).
        :param pulumi.Input[builtins.str] virtual_machine_id: The resource ID of the target ARM-based Virtual Machine. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GlobalVMShutdownScheduleState.__new__(_GlobalVMShutdownScheduleState)

        __props__.__dict__["daily_recurrence_time"] = daily_recurrence_time
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["location"] = location
        __props__.__dict__["notification_settings"] = notification_settings
        __props__.__dict__["tags"] = tags
        __props__.__dict__["timezone"] = timezone
        __props__.__dict__["virtual_machine_id"] = virtual_machine_id
        return GlobalVMShutdownSchedule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="dailyRecurrenceTime")
    def daily_recurrence_time(self) -> pulumi.Output[builtins.str]:
        """
        The time each day when the schedule takes effect. Must match the format HHmm where HH is 00-23 and mm is 00-59 (e.g. 0930, 2300, etc.)
        """
        return pulumi.get(self, "daily_recurrence_time")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether to enable the schedule. Possible values are `true` and `false`. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        The location where the schedule is created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="notificationSettings")
    def notification_settings(self) -> pulumi.Output['outputs.GlobalVMShutdownScheduleNotificationSettings']:
        """
        The notification setting of a schedule. A `notification_settings` block as defined below.
        """
        return pulumi.get(self, "notification_settings")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def timezone(self) -> pulumi.Output[builtins.str]:
        """
        The time zone ID (e.g. Pacific Standard time). Refer to this guide for a [full list of accepted time zone names](https://jackstromberg.com/2017/01/list-of-time-zones-consumed-by-azure/).
        """
        return pulumi.get(self, "timezone")

    @property
    @pulumi.getter(name="virtualMachineId")
    def virtual_machine_id(self) -> pulumi.Output[builtins.str]:
        """
        The resource ID of the target ARM-based Virtual Machine. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "virtual_machine_id")

