# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetServiceResult',
    'AwaitableGetServiceResult',
    'get_service',
    'get_service_output',
]

@pulumi.output_type
class GetServiceResult:
    """
    A collection of values returned by getService.
    """
    def __init__(__self__, deployment_id=None, domain_configuration_type=None, domain_name=None, filtered_sync_enabled=None, id=None, location=None, name=None, notifications=None, replica_sets=None, resource_group_name=None, resource_id=None, secure_ldaps=None, securities=None, sku=None, sync_owner=None, tags=None, tenant_id=None, version=None):
        if deployment_id and not isinstance(deployment_id, str):
            raise TypeError("Expected argument 'deployment_id' to be a str")
        pulumi.set(__self__, "deployment_id", deployment_id)
        if domain_configuration_type and not isinstance(domain_configuration_type, str):
            raise TypeError("Expected argument 'domain_configuration_type' to be a str")
        pulumi.set(__self__, "domain_configuration_type", domain_configuration_type)
        if domain_name and not isinstance(domain_name, str):
            raise TypeError("Expected argument 'domain_name' to be a str")
        pulumi.set(__self__, "domain_name", domain_name)
        if filtered_sync_enabled and not isinstance(filtered_sync_enabled, bool):
            raise TypeError("Expected argument 'filtered_sync_enabled' to be a bool")
        pulumi.set(__self__, "filtered_sync_enabled", filtered_sync_enabled)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if notifications and not isinstance(notifications, list):
            raise TypeError("Expected argument 'notifications' to be a list")
        pulumi.set(__self__, "notifications", notifications)
        if replica_sets and not isinstance(replica_sets, list):
            raise TypeError("Expected argument 'replica_sets' to be a list")
        pulumi.set(__self__, "replica_sets", replica_sets)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if resource_id and not isinstance(resource_id, str):
            raise TypeError("Expected argument 'resource_id' to be a str")
        pulumi.set(__self__, "resource_id", resource_id)
        if secure_ldaps and not isinstance(secure_ldaps, list):
            raise TypeError("Expected argument 'secure_ldaps' to be a list")
        pulumi.set(__self__, "secure_ldaps", secure_ldaps)
        if securities and not isinstance(securities, list):
            raise TypeError("Expected argument 'securities' to be a list")
        pulumi.set(__self__, "securities", securities)
        if sku and not isinstance(sku, str):
            raise TypeError("Expected argument 'sku' to be a str")
        pulumi.set(__self__, "sku", sku)
        if sync_owner and not isinstance(sync_owner, str):
            raise TypeError("Expected argument 'sync_owner' to be a str")
        pulumi.set(__self__, "sync_owner", sync_owner)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if tenant_id and not isinstance(tenant_id, str):
            raise TypeError("Expected argument 'tenant_id' to be a str")
        pulumi.set(__self__, "tenant_id", tenant_id)
        if version and not isinstance(version, int):
            raise TypeError("Expected argument 'version' to be a int")
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="deploymentId")
    def deployment_id(self) -> builtins.str:
        """
        A unique ID for the managed domain deployment.
        """
        return pulumi.get(self, "deployment_id")

    @property
    @pulumi.getter(name="domainConfigurationType")
    def domain_configuration_type(self) -> builtins.str:
        """
        The forest type used by the managed domain. One of `ResourceTrusting`, for a _Resource Forest_, or blank, for a _User Forest_.
        """
        return pulumi.get(self, "domain_configuration_type")

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> builtins.str:
        """
        The Active Directory domain of the Domain Service. See [official documentation](https://docs.microsoft.com/azure/active-directory-domain-services/tutorial-create-instance#create-a-managed-domain) for constraints and recommendations.
        """
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter(name="filteredSyncEnabled")
    def filtered_sync_enabled(self) -> builtins.bool:
        """
        Whether group-based filtered sync (also called scoped synchronisation) is enabled.
        """
        return pulumi.get(self, "filtered_sync_enabled")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def location(self) -> builtins.str:
        """
        The Azure location in which the replica set resides.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def notifications(self) -> Sequence['outputs.GetServiceNotificationResult']:
        """
        A `notifications` block as defined below.
        """
        return pulumi.get(self, "notifications")

    @property
    @pulumi.getter(name="replicaSets")
    def replica_sets(self) -> Sequence['outputs.GetServiceReplicaSetResult']:
        """
        One or more `replica_set` blocks as defined below.
        """
        return pulumi.get(self, "replica_sets")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> builtins.str:
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> builtins.str:
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter(name="secureLdaps")
    def secure_ldaps(self) -> Sequence['outputs.GetServiceSecureLdapResult']:
        """
        A `secure_ldap` block as defined below.
        """
        return pulumi.get(self, "secure_ldaps")

    @property
    @pulumi.getter
    def securities(self) -> Sequence['outputs.GetServiceSecurityResult']:
        """
        A `security` block as defined below.
        """
        return pulumi.get(self, "securities")

    @property
    @pulumi.getter
    def sku(self) -> builtins.str:
        """
        The SKU of the Domain Service resource. One of `Standard`, `Enterprise` or `Premium`.
        """
        return pulumi.get(self, "sku")

    @property
    @pulumi.getter(name="syncOwner")
    def sync_owner(self) -> builtins.str:
        return pulumi.get(self, "sync_owner")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, builtins.str]]:
        """
        A mapping of tags assigned to the resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> builtins.str:
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def version(self) -> builtins.int:
        return pulumi.get(self, "version")


class AwaitableGetServiceResult(GetServiceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetServiceResult(
            deployment_id=self.deployment_id,
            domain_configuration_type=self.domain_configuration_type,
            domain_name=self.domain_name,
            filtered_sync_enabled=self.filtered_sync_enabled,
            id=self.id,
            location=self.location,
            name=self.name,
            notifications=self.notifications,
            replica_sets=self.replica_sets,
            resource_group_name=self.resource_group_name,
            resource_id=self.resource_id,
            secure_ldaps=self.secure_ldaps,
            securities=self.securities,
            sku=self.sku,
            sync_owner=self.sync_owner,
            tags=self.tags,
            tenant_id=self.tenant_id,
            version=self.version)


def get_service(name: Optional[builtins.str] = None,
                resource_group_name: Optional[builtins.str] = None,
                tags: Optional[Mapping[str, builtins.str]] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetServiceResult:
    """
    Gets information about an Active Directory Domain Service.

    > **Note:** At present this data source only supports **User Forest** mode and _not_ **Resource Forest** mode. [Read more](https://docs.microsoft.com/azure/active-directory-domain-services/concepts-resource-forest) about the different operation modes for this service.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.domainservices.get_service(name="example-aadds",
        resource_group_name="example-aadds-rg")
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.AAD`: 2021-05-01


    :param builtins.str name: The display name for your managed Active Directory Domain Service resource. Changing this forces a new resource to be created.
    :param builtins.str resource_group_name: The name of the Resource Group in which the Domain Service should exist. Changing this forces a new resource to be created.
    :param Mapping[str, builtins.str] tags: A mapping of tags assigned to the resource.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:domainservices/getService:getService', __args__, opts=opts, typ=GetServiceResult).value

    return AwaitableGetServiceResult(
        deployment_id=pulumi.get(__ret__, 'deployment_id'),
        domain_configuration_type=pulumi.get(__ret__, 'domain_configuration_type'),
        domain_name=pulumi.get(__ret__, 'domain_name'),
        filtered_sync_enabled=pulumi.get(__ret__, 'filtered_sync_enabled'),
        id=pulumi.get(__ret__, 'id'),
        location=pulumi.get(__ret__, 'location'),
        name=pulumi.get(__ret__, 'name'),
        notifications=pulumi.get(__ret__, 'notifications'),
        replica_sets=pulumi.get(__ret__, 'replica_sets'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'),
        resource_id=pulumi.get(__ret__, 'resource_id'),
        secure_ldaps=pulumi.get(__ret__, 'secure_ldaps'),
        securities=pulumi.get(__ret__, 'securities'),
        sku=pulumi.get(__ret__, 'sku'),
        sync_owner=pulumi.get(__ret__, 'sync_owner'),
        tags=pulumi.get(__ret__, 'tags'),
        tenant_id=pulumi.get(__ret__, 'tenant_id'),
        version=pulumi.get(__ret__, 'version'))
def get_service_output(name: Optional[pulumi.Input[builtins.str]] = None,
                       resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                       tags: Optional[pulumi.Input[Optional[Mapping[str, builtins.str]]]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetServiceResult]:
    """
    Gets information about an Active Directory Domain Service.

    > **Note:** At present this data source only supports **User Forest** mode and _not_ **Resource Forest** mode. [Read more](https://docs.microsoft.com/azure/active-directory-domain-services/concepts-resource-forest) about the different operation modes for this service.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.domainservices.get_service(name="example-aadds",
        resource_group_name="example-aadds-rg")
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.AAD`: 2021-05-01


    :param builtins.str name: The display name for your managed Active Directory Domain Service resource. Changing this forces a new resource to be created.
    :param builtins.str resource_group_name: The name of the Resource Group in which the Domain Service should exist. Changing this forces a new resource to be created.
    :param Mapping[str, builtins.str] tags: A mapping of tags assigned to the resource.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    __args__['tags'] = tags
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:domainservices/getService:getService', __args__, opts=opts, typ=GetServiceResult)
    return __ret__.apply(lambda __response__: GetServiceResult(
        deployment_id=pulumi.get(__response__, 'deployment_id'),
        domain_configuration_type=pulumi.get(__response__, 'domain_configuration_type'),
        domain_name=pulumi.get(__response__, 'domain_name'),
        filtered_sync_enabled=pulumi.get(__response__, 'filtered_sync_enabled'),
        id=pulumi.get(__response__, 'id'),
        location=pulumi.get(__response__, 'location'),
        name=pulumi.get(__response__, 'name'),
        notifications=pulumi.get(__response__, 'notifications'),
        replica_sets=pulumi.get(__response__, 'replica_sets'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name'),
        resource_id=pulumi.get(__response__, 'resource_id'),
        secure_ldaps=pulumi.get(__response__, 'secure_ldaps'),
        securities=pulumi.get(__response__, 'securities'),
        sku=pulumi.get(__response__, 'sku'),
        sync_owner=pulumi.get(__response__, 'sync_owner'),
        tags=pulumi.get(__response__, 'tags'),
        tenant_id=pulumi.get(__response__, 'tenant_id'),
        version=pulumi.get(__response__, 'version')))
