# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'ServiceInitialReplicaSet',
    'ServiceNotifications',
    'ServiceSecureLdap',
    'ServiceSecurity',
    'GetServiceNotificationResult',
    'GetServiceReplicaSetResult',
    'GetServiceSecureLdapResult',
    'GetServiceSecurityResult',
]

@pulumi.output_type
class ServiceInitialReplicaSet(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "subnetId":
            suggest = "subnet_id"
        elif key == "domainControllerIpAddresses":
            suggest = "domain_controller_ip_addresses"
        elif key == "externalAccessIpAddress":
            suggest = "external_access_ip_address"
        elif key == "serviceStatus":
            suggest = "service_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceInitialReplicaSet. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceInitialReplicaSet.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceInitialReplicaSet.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 subnet_id: builtins.str,
                 domain_controller_ip_addresses: Optional[Sequence[builtins.str]] = None,
                 external_access_ip_address: Optional[builtins.str] = None,
                 id: Optional[builtins.str] = None,
                 location: Optional[builtins.str] = None,
                 service_status: Optional[builtins.str] = None):
        """
        :param builtins.str subnet_id: The ID of the subnet in which to place the initial replica set. Changing this forces a new resource to be created.
        :param Sequence[builtins.str] domain_controller_ip_addresses: A list of subnet IP addresses for the domain controllers in the initial replica set, typically two.
        :param builtins.str external_access_ip_address: The publicly routable IP address for the domain controllers in the initial replica set.
        :param builtins.str id: A unique ID for the replica set.
        :param builtins.str location: The Azure location where the Domain Service exists. Changing this forces a new resource to be created.
        :param builtins.str service_status: The current service status for the initial replica set.
        """
        pulumi.set(__self__, "subnet_id", subnet_id)
        if domain_controller_ip_addresses is not None:
            pulumi.set(__self__, "domain_controller_ip_addresses", domain_controller_ip_addresses)
        if external_access_ip_address is not None:
            pulumi.set(__self__, "external_access_ip_address", external_access_ip_address)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if service_status is not None:
            pulumi.set(__self__, "service_status", service_status)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> builtins.str:
        """
        The ID of the subnet in which to place the initial replica set. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="domainControllerIpAddresses")
    def domain_controller_ip_addresses(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of subnet IP addresses for the domain controllers in the initial replica set, typically two.
        """
        return pulumi.get(self, "domain_controller_ip_addresses")

    @property
    @pulumi.getter(name="externalAccessIpAddress")
    def external_access_ip_address(self) -> Optional[builtins.str]:
        """
        The publicly routable IP address for the domain controllers in the initial replica set.
        """
        return pulumi.get(self, "external_access_ip_address")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        A unique ID for the replica set.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def location(self) -> Optional[builtins.str]:
        """
        The Azure location where the Domain Service exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="serviceStatus")
    def service_status(self) -> Optional[builtins.str]:
        """
        The current service status for the initial replica set.
        """
        return pulumi.get(self, "service_status")


@pulumi.output_type
class ServiceNotifications(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "additionalRecipients":
            suggest = "additional_recipients"
        elif key == "notifyDcAdmins":
            suggest = "notify_dc_admins"
        elif key == "notifyGlobalAdmins":
            suggest = "notify_global_admins"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceNotifications. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceNotifications.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceNotifications.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 additional_recipients: Optional[Sequence[builtins.str]] = None,
                 notify_dc_admins: Optional[builtins.bool] = None,
                 notify_global_admins: Optional[builtins.bool] = None):
        """
        :param Sequence[builtins.str] additional_recipients: A list of additional email addresses to notify when there are alerts in the managed domain.
        :param builtins.bool notify_dc_admins: Whether to notify members of the _AAD DC Administrators_ group when there are alerts in the managed domain.
        :param builtins.bool notify_global_admins: Whether to notify all Global Administrators when there are alerts in the managed domain.
        """
        if additional_recipients is not None:
            pulumi.set(__self__, "additional_recipients", additional_recipients)
        if notify_dc_admins is not None:
            pulumi.set(__self__, "notify_dc_admins", notify_dc_admins)
        if notify_global_admins is not None:
            pulumi.set(__self__, "notify_global_admins", notify_global_admins)

    @property
    @pulumi.getter(name="additionalRecipients")
    def additional_recipients(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of additional email addresses to notify when there are alerts in the managed domain.
        """
        return pulumi.get(self, "additional_recipients")

    @property
    @pulumi.getter(name="notifyDcAdmins")
    def notify_dc_admins(self) -> Optional[builtins.bool]:
        """
        Whether to notify members of the _AAD DC Administrators_ group when there are alerts in the managed domain.
        """
        return pulumi.get(self, "notify_dc_admins")

    @property
    @pulumi.getter(name="notifyGlobalAdmins")
    def notify_global_admins(self) -> Optional[builtins.bool]:
        """
        Whether to notify all Global Administrators when there are alerts in the managed domain.
        """
        return pulumi.get(self, "notify_global_admins")


@pulumi.output_type
class ServiceSecureLdap(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pfxCertificate":
            suggest = "pfx_certificate"
        elif key == "pfxCertificatePassword":
            suggest = "pfx_certificate_password"
        elif key == "certificateExpiry":
            suggest = "certificate_expiry"
        elif key == "certificateThumbprint":
            suggest = "certificate_thumbprint"
        elif key == "externalAccessEnabled":
            suggest = "external_access_enabled"
        elif key == "publicCertificate":
            suggest = "public_certificate"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceSecureLdap. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceSecureLdap.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceSecureLdap.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: builtins.bool,
                 pfx_certificate: builtins.str,
                 pfx_certificate_password: builtins.str,
                 certificate_expiry: Optional[builtins.str] = None,
                 certificate_thumbprint: Optional[builtins.str] = None,
                 external_access_enabled: Optional[builtins.bool] = None,
                 public_certificate: Optional[builtins.str] = None):
        """
        :param builtins.bool enabled: Whether to enable secure LDAP for the managed domain. For more information, please see [official documentation on enabling LDAPS](https://docs.microsoft.com/azure/active-directory-domain-services/tutorial-configure-ldaps), paying particular attention to the section on network security to avoid unnecessarily exposing your service to Internet-borne bruteforce attacks.
        :param builtins.str pfx_certificate: The certificate/private key to use for LDAPS, as a base64-encoded TripleDES-SHA1 encrypted PKCS#12 bundle (PFX file).
        :param builtins.str pfx_certificate_password: The password to use for decrypting the PKCS#12 bundle (PFX file).
        :param builtins.str certificate_expiry: The expiry time of the certificate.
        :param builtins.str certificate_thumbprint: The thumbprint of the certificate.
        :param builtins.bool external_access_enabled: Whether to enable external access to LDAPS over the Internet. Defaults to `false`.
        :param builtins.str public_certificate: The public certificate.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "pfx_certificate", pfx_certificate)
        pulumi.set(__self__, "pfx_certificate_password", pfx_certificate_password)
        if certificate_expiry is not None:
            pulumi.set(__self__, "certificate_expiry", certificate_expiry)
        if certificate_thumbprint is not None:
            pulumi.set(__self__, "certificate_thumbprint", certificate_thumbprint)
        if external_access_enabled is not None:
            pulumi.set(__self__, "external_access_enabled", external_access_enabled)
        if public_certificate is not None:
            pulumi.set(__self__, "public_certificate", public_certificate)

    @property
    @pulumi.getter
    def enabled(self) -> builtins.bool:
        """
        Whether to enable secure LDAP for the managed domain. For more information, please see [official documentation on enabling LDAPS](https://docs.microsoft.com/azure/active-directory-domain-services/tutorial-configure-ldaps), paying particular attention to the section on network security to avoid unnecessarily exposing your service to Internet-borne bruteforce attacks.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="pfxCertificate")
    def pfx_certificate(self) -> builtins.str:
        """
        The certificate/private key to use for LDAPS, as a base64-encoded TripleDES-SHA1 encrypted PKCS#12 bundle (PFX file).
        """
        return pulumi.get(self, "pfx_certificate")

    @property
    @pulumi.getter(name="pfxCertificatePassword")
    def pfx_certificate_password(self) -> builtins.str:
        """
        The password to use for decrypting the PKCS#12 bundle (PFX file).
        """
        return pulumi.get(self, "pfx_certificate_password")

    @property
    @pulumi.getter(name="certificateExpiry")
    def certificate_expiry(self) -> Optional[builtins.str]:
        """
        The expiry time of the certificate.
        """
        return pulumi.get(self, "certificate_expiry")

    @property
    @pulumi.getter(name="certificateThumbprint")
    def certificate_thumbprint(self) -> Optional[builtins.str]:
        """
        The thumbprint of the certificate.
        """
        return pulumi.get(self, "certificate_thumbprint")

    @property
    @pulumi.getter(name="externalAccessEnabled")
    def external_access_enabled(self) -> Optional[builtins.bool]:
        """
        Whether to enable external access to LDAPS over the Internet. Defaults to `false`.
        """
        return pulumi.get(self, "external_access_enabled")

    @property
    @pulumi.getter(name="publicCertificate")
    def public_certificate(self) -> Optional[builtins.str]:
        """
        The public certificate.
        """
        return pulumi.get(self, "public_certificate")


@pulumi.output_type
class ServiceSecurity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kerberosArmoringEnabled":
            suggest = "kerberos_armoring_enabled"
        elif key == "kerberosRc4EncryptionEnabled":
            suggest = "kerberos_rc4_encryption_enabled"
        elif key == "ntlmV1Enabled":
            suggest = "ntlm_v1_enabled"
        elif key == "syncKerberosPasswords":
            suggest = "sync_kerberos_passwords"
        elif key == "syncNtlmPasswords":
            suggest = "sync_ntlm_passwords"
        elif key == "syncOnPremPasswords":
            suggest = "sync_on_prem_passwords"
        elif key == "tlsV1Enabled":
            suggest = "tls_v1_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceSecurity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceSecurity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceSecurity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kerberos_armoring_enabled: Optional[builtins.bool] = None,
                 kerberos_rc4_encryption_enabled: Optional[builtins.bool] = None,
                 ntlm_v1_enabled: Optional[builtins.bool] = None,
                 sync_kerberos_passwords: Optional[builtins.bool] = None,
                 sync_ntlm_passwords: Optional[builtins.bool] = None,
                 sync_on_prem_passwords: Optional[builtins.bool] = None,
                 tls_v1_enabled: Optional[builtins.bool] = None):
        """
        :param builtins.bool kerberos_armoring_enabled: Whether to enable Kerberos Armoring. Defaults to `false`.
        :param builtins.bool kerberos_rc4_encryption_enabled: Whether to enable Kerberos RC4 Encryption. Defaults to `false`.
        :param builtins.bool ntlm_v1_enabled: Whether to enable legacy NTLM v1 support. Defaults to `false`.
        :param builtins.bool sync_kerberos_passwords: Whether to synchronize Kerberos password hashes to the managed domain. Defaults to `false`.
        :param builtins.bool sync_ntlm_passwords: Whether to synchronize NTLM password hashes to the managed domain. Defaults to `false`.
        :param builtins.bool sync_on_prem_passwords: Whether to synchronize on-premises password hashes to the managed domain. Defaults to `false`.
        :param builtins.bool tls_v1_enabled: Whether to enable legacy TLS v1 support. Defaults to `false`.
        """
        if kerberos_armoring_enabled is not None:
            pulumi.set(__self__, "kerberos_armoring_enabled", kerberos_armoring_enabled)
        if kerberos_rc4_encryption_enabled is not None:
            pulumi.set(__self__, "kerberos_rc4_encryption_enabled", kerberos_rc4_encryption_enabled)
        if ntlm_v1_enabled is not None:
            pulumi.set(__self__, "ntlm_v1_enabled", ntlm_v1_enabled)
        if sync_kerberos_passwords is not None:
            pulumi.set(__self__, "sync_kerberos_passwords", sync_kerberos_passwords)
        if sync_ntlm_passwords is not None:
            pulumi.set(__self__, "sync_ntlm_passwords", sync_ntlm_passwords)
        if sync_on_prem_passwords is not None:
            pulumi.set(__self__, "sync_on_prem_passwords", sync_on_prem_passwords)
        if tls_v1_enabled is not None:
            pulumi.set(__self__, "tls_v1_enabled", tls_v1_enabled)

    @property
    @pulumi.getter(name="kerberosArmoringEnabled")
    def kerberos_armoring_enabled(self) -> Optional[builtins.bool]:
        """
        Whether to enable Kerberos Armoring. Defaults to `false`.
        """
        return pulumi.get(self, "kerberos_armoring_enabled")

    @property
    @pulumi.getter(name="kerberosRc4EncryptionEnabled")
    def kerberos_rc4_encryption_enabled(self) -> Optional[builtins.bool]:
        """
        Whether to enable Kerberos RC4 Encryption. Defaults to `false`.
        """
        return pulumi.get(self, "kerberos_rc4_encryption_enabled")

    @property
    @pulumi.getter(name="ntlmV1Enabled")
    def ntlm_v1_enabled(self) -> Optional[builtins.bool]:
        """
        Whether to enable legacy NTLM v1 support. Defaults to `false`.
        """
        return pulumi.get(self, "ntlm_v1_enabled")

    @property
    @pulumi.getter(name="syncKerberosPasswords")
    def sync_kerberos_passwords(self) -> Optional[builtins.bool]:
        """
        Whether to synchronize Kerberos password hashes to the managed domain. Defaults to `false`.
        """
        return pulumi.get(self, "sync_kerberos_passwords")

    @property
    @pulumi.getter(name="syncNtlmPasswords")
    def sync_ntlm_passwords(self) -> Optional[builtins.bool]:
        """
        Whether to synchronize NTLM password hashes to the managed domain. Defaults to `false`.
        """
        return pulumi.get(self, "sync_ntlm_passwords")

    @property
    @pulumi.getter(name="syncOnPremPasswords")
    def sync_on_prem_passwords(self) -> Optional[builtins.bool]:
        """
        Whether to synchronize on-premises password hashes to the managed domain. Defaults to `false`.
        """
        return pulumi.get(self, "sync_on_prem_passwords")

    @property
    @pulumi.getter(name="tlsV1Enabled")
    def tls_v1_enabled(self) -> Optional[builtins.bool]:
        """
        Whether to enable legacy TLS v1 support. Defaults to `false`.
        """
        return pulumi.get(self, "tls_v1_enabled")


@pulumi.output_type
class GetServiceNotificationResult(dict):
    def __init__(__self__, *,
                 additional_recipients: Sequence[builtins.str],
                 notify_dc_admins: builtins.bool,
                 notify_global_admins: builtins.bool):
        """
        :param Sequence[builtins.str] additional_recipients: A list of additional email addresses to notify when there are alerts in the managed domain.
        :param builtins.bool notify_dc_admins: Whethermembers of the _AAD DC Administrators_ group are notified when there are alerts in the managed domain.
        :param builtins.bool notify_global_admins: Whether all Global Administrators are notified when there are alerts in the managed domain.
        """
        pulumi.set(__self__, "additional_recipients", additional_recipients)
        pulumi.set(__self__, "notify_dc_admins", notify_dc_admins)
        pulumi.set(__self__, "notify_global_admins", notify_global_admins)

    @property
    @pulumi.getter(name="additionalRecipients")
    def additional_recipients(self) -> Sequence[builtins.str]:
        """
        A list of additional email addresses to notify when there are alerts in the managed domain.
        """
        return pulumi.get(self, "additional_recipients")

    @property
    @pulumi.getter(name="notifyDcAdmins")
    def notify_dc_admins(self) -> builtins.bool:
        """
        Whethermembers of the _AAD DC Administrators_ group are notified when there are alerts in the managed domain.
        """
        return pulumi.get(self, "notify_dc_admins")

    @property
    @pulumi.getter(name="notifyGlobalAdmins")
    def notify_global_admins(self) -> builtins.bool:
        """
        Whether all Global Administrators are notified when there are alerts in the managed domain.
        """
        return pulumi.get(self, "notify_global_admins")


@pulumi.output_type
class GetServiceReplicaSetResult(dict):
    def __init__(__self__, *,
                 domain_controller_ip_addresses: Sequence[builtins.str],
                 external_access_ip_address: builtins.str,
                 id: builtins.str,
                 location: builtins.str,
                 service_status: builtins.str,
                 subnet_id: builtins.str):
        """
        :param Sequence[builtins.str] domain_controller_ip_addresses: A list of subnet IP addresses for the domain controllers in the replica set, typically two.
        :param builtins.str external_access_ip_address: The publicly routable IP address for the domain controllers in the replica set.
        :param builtins.str id: The ID of the Domain Service.
        :param builtins.str location: The Azure location in which the replica set resides.
        :param builtins.str service_status: The current service status for the replica set.
        :param builtins.str subnet_id: The ID of the subnet in which the replica set resides.
        """
        pulumi.set(__self__, "domain_controller_ip_addresses", domain_controller_ip_addresses)
        pulumi.set(__self__, "external_access_ip_address", external_access_ip_address)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "service_status", service_status)
        pulumi.set(__self__, "subnet_id", subnet_id)

    @property
    @pulumi.getter(name="domainControllerIpAddresses")
    def domain_controller_ip_addresses(self) -> Sequence[builtins.str]:
        """
        A list of subnet IP addresses for the domain controllers in the replica set, typically two.
        """
        return pulumi.get(self, "domain_controller_ip_addresses")

    @property
    @pulumi.getter(name="externalAccessIpAddress")
    def external_access_ip_address(self) -> builtins.str:
        """
        The publicly routable IP address for the domain controllers in the replica set.
        """
        return pulumi.get(self, "external_access_ip_address")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The ID of the Domain Service.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def location(self) -> builtins.str:
        """
        The Azure location in which the replica set resides.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="serviceStatus")
    def service_status(self) -> builtins.str:
        """
        The current service status for the replica set.
        """
        return pulumi.get(self, "service_status")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> builtins.str:
        """
        The ID of the subnet in which the replica set resides.
        """
        return pulumi.get(self, "subnet_id")


@pulumi.output_type
class GetServiceSecureLdapResult(dict):
    def __init__(__self__, *,
                 certificate_expiry: builtins.str,
                 certificate_thumbprint: builtins.str,
                 enabled: builtins.bool,
                 external_access_enabled: builtins.bool,
                 public_certificate: builtins.str):
        """
        :param builtins.bool enabled: Whether secure LDAP is enabled for the managed domain.
        :param builtins.bool external_access_enabled: Whether external access to LDAPS over the Internet, is enabled.
        """
        pulumi.set(__self__, "certificate_expiry", certificate_expiry)
        pulumi.set(__self__, "certificate_thumbprint", certificate_thumbprint)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "external_access_enabled", external_access_enabled)
        pulumi.set(__self__, "public_certificate", public_certificate)

    @property
    @pulumi.getter(name="certificateExpiry")
    def certificate_expiry(self) -> builtins.str:
        return pulumi.get(self, "certificate_expiry")

    @property
    @pulumi.getter(name="certificateThumbprint")
    def certificate_thumbprint(self) -> builtins.str:
        return pulumi.get(self, "certificate_thumbprint")

    @property
    @pulumi.getter
    def enabled(self) -> builtins.bool:
        """
        Whether secure LDAP is enabled for the managed domain.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="externalAccessEnabled")
    def external_access_enabled(self) -> builtins.bool:
        """
        Whether external access to LDAPS over the Internet, is enabled.
        """
        return pulumi.get(self, "external_access_enabled")

    @property
    @pulumi.getter(name="publicCertificate")
    def public_certificate(self) -> builtins.str:
        return pulumi.get(self, "public_certificate")


@pulumi.output_type
class GetServiceSecurityResult(dict):
    def __init__(__self__, *,
                 kerberos_armoring_enabled: builtins.bool,
                 kerberos_rc4_encryption_enabled: builtins.bool,
                 ntlm_v1_enabled: builtins.bool,
                 sync_kerberos_passwords: builtins.bool,
                 sync_ntlm_passwords: builtins.bool,
                 sync_on_prem_passwords: builtins.bool,
                 tls_v1_enabled: builtins.bool):
        """
        :param builtins.bool kerberos_armoring_enabled: (Optional) Whether the Kerberos Armoring is enabled.
        :param builtins.bool kerberos_rc4_encryption_enabled: (Optional) Whether the Kerberos RC4 Encryption is enabled.
        :param builtins.bool ntlm_v1_enabled: Whether legacy NTLM v1 support is enabled.
        :param builtins.bool sync_kerberos_passwords: Whether Kerberos password hashes are synchronized to the managed domain.
        :param builtins.bool sync_ntlm_passwords: Whether NTLM password hashes are synchronized to the managed domain.
        :param builtins.bool sync_on_prem_passwords: Whether on-premises password hashes are synchronized to the managed domain.
        :param builtins.bool tls_v1_enabled: Whether legacy TLS v1 support is enabled.
        """
        pulumi.set(__self__, "kerberos_armoring_enabled", kerberos_armoring_enabled)
        pulumi.set(__self__, "kerberos_rc4_encryption_enabled", kerberos_rc4_encryption_enabled)
        pulumi.set(__self__, "ntlm_v1_enabled", ntlm_v1_enabled)
        pulumi.set(__self__, "sync_kerberos_passwords", sync_kerberos_passwords)
        pulumi.set(__self__, "sync_ntlm_passwords", sync_ntlm_passwords)
        pulumi.set(__self__, "sync_on_prem_passwords", sync_on_prem_passwords)
        pulumi.set(__self__, "tls_v1_enabled", tls_v1_enabled)

    @property
    @pulumi.getter(name="kerberosArmoringEnabled")
    def kerberos_armoring_enabled(self) -> builtins.bool:
        """
        (Optional) Whether the Kerberos Armoring is enabled.
        """
        return pulumi.get(self, "kerberos_armoring_enabled")

    @property
    @pulumi.getter(name="kerberosRc4EncryptionEnabled")
    def kerberos_rc4_encryption_enabled(self) -> builtins.bool:
        """
        (Optional) Whether the Kerberos RC4 Encryption is enabled.
        """
        return pulumi.get(self, "kerberos_rc4_encryption_enabled")

    @property
    @pulumi.getter(name="ntlmV1Enabled")
    def ntlm_v1_enabled(self) -> builtins.bool:
        """
        Whether legacy NTLM v1 support is enabled.
        """
        return pulumi.get(self, "ntlm_v1_enabled")

    @property
    @pulumi.getter(name="syncKerberosPasswords")
    def sync_kerberos_passwords(self) -> builtins.bool:
        """
        Whether Kerberos password hashes are synchronized to the managed domain.
        """
        return pulumi.get(self, "sync_kerberos_passwords")

    @property
    @pulumi.getter(name="syncNtlmPasswords")
    def sync_ntlm_passwords(self) -> builtins.bool:
        """
        Whether NTLM password hashes are synchronized to the managed domain.
        """
        return pulumi.get(self, "sync_ntlm_passwords")

    @property
    @pulumi.getter(name="syncOnPremPasswords")
    def sync_on_prem_passwords(self) -> builtins.bool:
        """
        Whether on-premises password hashes are synchronized to the managed domain.
        """
        return pulumi.get(self, "sync_on_prem_passwords")

    @property
    @pulumi.getter(name="tlsV1Enabled")
    def tls_v1_enabled(self) -> builtins.bool:
        """
        Whether legacy TLS v1 support is enabled.
        """
        return pulumi.get(self, "tls_v1_enabled")


