# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'MonitorIdentity',
    'MonitorPlan',
    'MonitorUser',
    'TagRulesLogRule',
    'TagRulesLogRuleFilteringTag',
    'TagRulesMetricRule',
    'TagRulesMetricRuleFilteringTag',
    'GetMonitorEnvironmentPropertyResult',
    'GetMonitorEnvironmentPropertyEnvironmentInfoResult',
    'GetMonitorIdentityResult',
    'GetMonitorPlanResult',
    'GetMonitorUserResult',
]

@pulumi.output_type
class MonitorIdentity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MonitorIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MonitorIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MonitorIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: builtins.str,
                 principal_id: Optional[builtins.str] = None,
                 tenant_id: Optional[builtins.str] = None):
        """
        :param builtins.str type: The type of identity used for the resource. Only possible value is `SystemAssigned`.
        """
        pulumi.set(__self__, "type", type)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The type of identity used for the resource. Only possible value is `SystemAssigned`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class MonitorPlan(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "billingCycle":
            suggest = "billing_cycle"
        elif key == "effectiveDate":
            suggest = "effective_date"
        elif key == "usageType":
            suggest = "usage_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MonitorPlan. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MonitorPlan.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MonitorPlan.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 plan: builtins.str,
                 billing_cycle: Optional[builtins.str] = None,
                 effective_date: Optional[builtins.str] = None,
                 usage_type: Optional[builtins.str] = None):
        """
        :param builtins.str plan: Plan id as published by Dynatrace.
        :param builtins.str billing_cycle: Different billing cycles. Possible values are `MONTHLY` and `WEEKLY`.
        :param builtins.str effective_date: Date when plan was applied.
        :param builtins.str usage_type: Different usage type. Possible values are `PAYG` and `COMMITTED`.
        """
        pulumi.set(__self__, "plan", plan)
        if billing_cycle is not None:
            pulumi.set(__self__, "billing_cycle", billing_cycle)
        if effective_date is not None:
            pulumi.set(__self__, "effective_date", effective_date)
        if usage_type is not None:
            pulumi.set(__self__, "usage_type", usage_type)

    @property
    @pulumi.getter
    def plan(self) -> builtins.str:
        """
        Plan id as published by Dynatrace.
        """
        return pulumi.get(self, "plan")

    @property
    @pulumi.getter(name="billingCycle")
    def billing_cycle(self) -> Optional[builtins.str]:
        """
        Different billing cycles. Possible values are `MONTHLY` and `WEEKLY`.
        """
        return pulumi.get(self, "billing_cycle")

    @property
    @pulumi.getter(name="effectiveDate")
    def effective_date(self) -> Optional[builtins.str]:
        """
        Date when plan was applied.
        """
        return pulumi.get(self, "effective_date")

    @property
    @pulumi.getter(name="usageType")
    def usage_type(self) -> Optional[builtins.str]:
        """
        Different usage type. Possible values are `PAYG` and `COMMITTED`.
        """
        return pulumi.get(self, "usage_type")


@pulumi.output_type
class MonitorUser(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "firstName":
            suggest = "first_name"
        elif key == "lastName":
            suggest = "last_name"
        elif key == "phoneNumber":
            suggest = "phone_number"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MonitorUser. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MonitorUser.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MonitorUser.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 country: builtins.str,
                 email: builtins.str,
                 first_name: builtins.str,
                 last_name: builtins.str,
                 phone_number: builtins.str):
        """
        :param builtins.str country: Country of the user.
        :param builtins.str email: Email of the user used by Dynatrace for contacting them if needed.
        :param builtins.str first_name: First name of the user.
        :param builtins.str last_name: Last name of the user.
        :param builtins.str phone_number: phone number of the user by Dynatrace for contacting them if needed.
        """
        pulumi.set(__self__, "country", country)
        pulumi.set(__self__, "email", email)
        pulumi.set(__self__, "first_name", first_name)
        pulumi.set(__self__, "last_name", last_name)
        pulumi.set(__self__, "phone_number", phone_number)

    @property
    @pulumi.getter
    def country(self) -> builtins.str:
        """
        Country of the user.
        """
        return pulumi.get(self, "country")

    @property
    @pulumi.getter
    def email(self) -> builtins.str:
        """
        Email of the user used by Dynatrace for contacting them if needed.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter(name="firstName")
    def first_name(self) -> builtins.str:
        """
        First name of the user.
        """
        return pulumi.get(self, "first_name")

    @property
    @pulumi.getter(name="lastName")
    def last_name(self) -> builtins.str:
        """
        Last name of the user.
        """
        return pulumi.get(self, "last_name")

    @property
    @pulumi.getter(name="phoneNumber")
    def phone_number(self) -> builtins.str:
        """
        phone number of the user by Dynatrace for contacting them if needed.
        """
        return pulumi.get(self, "phone_number")


@pulumi.output_type
class TagRulesLogRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "filteringTags":
            suggest = "filtering_tags"
        elif key == "sendActivityLogsEnabled":
            suggest = "send_activity_logs_enabled"
        elif key == "sendAzureActiveDirectoryLogsEnabled":
            suggest = "send_azure_active_directory_logs_enabled"
        elif key == "sendSubscriptionLogsEnabled":
            suggest = "send_subscription_logs_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TagRulesLogRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TagRulesLogRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TagRulesLogRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 filtering_tags: Sequence['outputs.TagRulesLogRuleFilteringTag'],
                 send_activity_logs_enabled: Optional[builtins.bool] = None,
                 send_azure_active_directory_logs_enabled: Optional[builtins.bool] = None,
                 send_subscription_logs_enabled: Optional[builtins.bool] = None):
        """
        :param Sequence['TagRulesLogRuleFilteringTagArgs'] filtering_tags: Filtering tag for the log rule. A `filtering_tag` block as defined below.
        :param builtins.bool send_activity_logs_enabled: Send Activity logs. The default value is `false`.
        :param builtins.bool send_azure_active_directory_logs_enabled: Send Azure Active Directory logs. The default value is `false`.
        :param builtins.bool send_subscription_logs_enabled: Send Subscription logs. The default value is `false`.
        """
        pulumi.set(__self__, "filtering_tags", filtering_tags)
        if send_activity_logs_enabled is not None:
            pulumi.set(__self__, "send_activity_logs_enabled", send_activity_logs_enabled)
        if send_azure_active_directory_logs_enabled is not None:
            pulumi.set(__self__, "send_azure_active_directory_logs_enabled", send_azure_active_directory_logs_enabled)
        if send_subscription_logs_enabled is not None:
            pulumi.set(__self__, "send_subscription_logs_enabled", send_subscription_logs_enabled)

    @property
    @pulumi.getter(name="filteringTags")
    def filtering_tags(self) -> Sequence['outputs.TagRulesLogRuleFilteringTag']:
        """
        Filtering tag for the log rule. A `filtering_tag` block as defined below.
        """
        return pulumi.get(self, "filtering_tags")

    @property
    @pulumi.getter(name="sendActivityLogsEnabled")
    def send_activity_logs_enabled(self) -> Optional[builtins.bool]:
        """
        Send Activity logs. The default value is `false`.
        """
        return pulumi.get(self, "send_activity_logs_enabled")

    @property
    @pulumi.getter(name="sendAzureActiveDirectoryLogsEnabled")
    def send_azure_active_directory_logs_enabled(self) -> Optional[builtins.bool]:
        """
        Send Azure Active Directory logs. The default value is `false`.
        """
        return pulumi.get(self, "send_azure_active_directory_logs_enabled")

    @property
    @pulumi.getter(name="sendSubscriptionLogsEnabled")
    def send_subscription_logs_enabled(self) -> Optional[builtins.bool]:
        """
        Send Subscription logs. The default value is `false`.
        """
        return pulumi.get(self, "send_subscription_logs_enabled")


@pulumi.output_type
class TagRulesLogRuleFilteringTag(dict):
    def __init__(__self__, *,
                 action: builtins.str,
                 name: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str action: Action of the filtering tag. Possible values are `Include` and `Exclude`.
        :param builtins.str name: Name of the filtering tag.
        :param builtins.str value: Value of the filtering tag.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def action(self) -> builtins.str:
        """
        Action of the filtering tag. Possible values are `Include` and `Exclude`.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the filtering tag.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        Value of the filtering tag.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class TagRulesMetricRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "filteringTags":
            suggest = "filtering_tags"
        elif key == "sendingMetricsEnabled":
            suggest = "sending_metrics_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TagRulesMetricRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TagRulesMetricRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TagRulesMetricRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 filtering_tags: Sequence['outputs.TagRulesMetricRuleFilteringTag'],
                 sending_metrics_enabled: Optional[builtins.bool] = None):
        """
        :param Sequence['TagRulesMetricRuleFilteringTagArgs'] filtering_tags: Filtering tag for the metric rule. A `filtering_tag` block as defined below.
        :param builtins.bool sending_metrics_enabled: If sending metrics is enabled. The default value is `false`.
        """
        pulumi.set(__self__, "filtering_tags", filtering_tags)
        if sending_metrics_enabled is not None:
            pulumi.set(__self__, "sending_metrics_enabled", sending_metrics_enabled)

    @property
    @pulumi.getter(name="filteringTags")
    def filtering_tags(self) -> Sequence['outputs.TagRulesMetricRuleFilteringTag']:
        """
        Filtering tag for the metric rule. A `filtering_tag` block as defined below.
        """
        return pulumi.get(self, "filtering_tags")

    @property
    @pulumi.getter(name="sendingMetricsEnabled")
    def sending_metrics_enabled(self) -> Optional[builtins.bool]:
        """
        If sending metrics is enabled. The default value is `false`.
        """
        return pulumi.get(self, "sending_metrics_enabled")


@pulumi.output_type
class TagRulesMetricRuleFilteringTag(dict):
    def __init__(__self__, *,
                 action: builtins.str,
                 name: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str action: Action of the filtering tag. Possible values are `Include` and `Exclude`.
        :param builtins.str name: Name of the filtering tag.
        :param builtins.str value: Value of the filtering tag.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def action(self) -> builtins.str:
        """
        Action of the filtering tag. Possible values are `Include` and `Exclude`.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the filtering tag.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        Value of the filtering tag.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetMonitorEnvironmentPropertyResult(dict):
    def __init__(__self__, *,
                 environment_infos: Sequence['outputs.GetMonitorEnvironmentPropertyEnvironmentInfoResult']):
        pulumi.set(__self__, "environment_infos", environment_infos)

    @property
    @pulumi.getter(name="environmentInfos")
    def environment_infos(self) -> Sequence['outputs.GetMonitorEnvironmentPropertyEnvironmentInfoResult']:
        return pulumi.get(self, "environment_infos")


@pulumi.output_type
class GetMonitorEnvironmentPropertyEnvironmentInfoResult(dict):
    def __init__(__self__, *,
                 environment_id: builtins.str):
        pulumi.set(__self__, "environment_id", environment_id)

    @property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> builtins.str:
        return pulumi.get(self, "environment_id")


@pulumi.output_type
class GetMonitorIdentityResult(dict):
    def __init__(__self__, *,
                 principal_id: builtins.str,
                 tenant_id: builtins.str,
                 type: builtins.str):
        """
        :param builtins.str type: The type of identity used for the resource.
        """
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> builtins.str:
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> builtins.str:
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The type of identity used for the resource.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetMonitorPlanResult(dict):
    def __init__(__self__, *,
                 billing_cycle: builtins.str,
                 effective_date: builtins.str,
                 plan: builtins.str,
                 usage_type: builtins.str):
        """
        :param builtins.str billing_cycle: Different billing cycles.
        :param builtins.str effective_date: Date when plan was applied.
        :param builtins.str plan: Plan id as published by Dynatrace.
        :param builtins.str usage_type: Different usage type.
        """
        pulumi.set(__self__, "billing_cycle", billing_cycle)
        pulumi.set(__self__, "effective_date", effective_date)
        pulumi.set(__self__, "plan", plan)
        pulumi.set(__self__, "usage_type", usage_type)

    @property
    @pulumi.getter(name="billingCycle")
    def billing_cycle(self) -> builtins.str:
        """
        Different billing cycles.
        """
        return pulumi.get(self, "billing_cycle")

    @property
    @pulumi.getter(name="effectiveDate")
    def effective_date(self) -> builtins.str:
        """
        Date when plan was applied.
        """
        return pulumi.get(self, "effective_date")

    @property
    @pulumi.getter
    def plan(self) -> builtins.str:
        """
        Plan id as published by Dynatrace.
        """
        return pulumi.get(self, "plan")

    @property
    @pulumi.getter(name="usageType")
    def usage_type(self) -> builtins.str:
        """
        Different usage type.
        """
        return pulumi.get(self, "usage_type")


@pulumi.output_type
class GetMonitorUserResult(dict):
    def __init__(__self__, *,
                 country: builtins.str,
                 email: builtins.str,
                 first_name: builtins.str,
                 last_name: builtins.str,
                 phone_number: builtins.str):
        """
        :param builtins.str country: Country of the user.
        :param builtins.str email: Email of the user used by Dynatrace for contacting them if needed.
        :param builtins.str first_name: First name of the user.
        :param builtins.str last_name: Last name of the user.
        :param builtins.str phone_number: phone number of the user by Dynatrace for contacting them if needed.
        """
        pulumi.set(__self__, "country", country)
        pulumi.set(__self__, "email", email)
        pulumi.set(__self__, "first_name", first_name)
        pulumi.set(__self__, "last_name", last_name)
        pulumi.set(__self__, "phone_number", phone_number)

    @property
    @pulumi.getter
    def country(self) -> builtins.str:
        """
        Country of the user.
        """
        return pulumi.get(self, "country")

    @property
    @pulumi.getter
    def email(self) -> builtins.str:
        """
        Email of the user used by Dynatrace for contacting them if needed.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter(name="firstName")
    def first_name(self) -> builtins.str:
        """
        First name of the user.
        """
        return pulumi.get(self, "first_name")

    @property
    @pulumi.getter(name="lastName")
    def last_name(self) -> builtins.str:
        """
        Last name of the user.
        """
        return pulumi.get(self, "last_name")

    @property
    @pulumi.getter(name="phoneNumber")
    def phone_number(self) -> builtins.str:
        """
        phone number of the user by Dynatrace for contacting them if needed.
        """
        return pulumi.get(self, "phone_number")


