# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'ElasticSanSkuArgs',
    'ElasticSanSkuArgsDict',
    'VolumeCreateSourceArgs',
    'VolumeCreateSourceArgsDict',
    'VolumeGroupEncryptionArgs',
    'VolumeGroupEncryptionArgsDict',
    'VolumeGroupIdentityArgs',
    'VolumeGroupIdentityArgsDict',
    'VolumeGroupNetworkRuleArgs',
    'VolumeGroupNetworkRuleArgsDict',
]

MYPY = False

if not MYPY:
    class ElasticSanSkuArgsDict(TypedDict):
        name: pulumi.Input[builtins.str]
        """
        The SKU name. Possible values are `Premium_LRS` and `Premium_ZRS`. Changing this forces a new resource to be created.

        > **Note:** `Premium_ZRS` SKU is only available in limited Azure regions including `France Central`, `North Europe`, `West Europe`, and `West US 2`. Please refer to this [document](https://azure.microsoft.com/updates/regional-expansion-azure-elastic-san-public-preview-is-now-available-in-more-regions) for more details.
        """
        tier: NotRequired[pulumi.Input[builtins.str]]
        """
        The SKU tier. The only possible value is `Premium`. Defaults to `Premium`.
        """
elif False:
    ElasticSanSkuArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ElasticSanSkuArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[builtins.str],
                 tier: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] name: The SKU name. Possible values are `Premium_LRS` and `Premium_ZRS`. Changing this forces a new resource to be created.
               
               > **Note:** `Premium_ZRS` SKU is only available in limited Azure regions including `France Central`, `North Europe`, `West Europe`, and `West US 2`. Please refer to this [document](https://azure.microsoft.com/updates/regional-expansion-azure-elastic-san-public-preview-is-now-available-in-more-regions) for more details.
        :param pulumi.Input[builtins.str] tier: The SKU tier. The only possible value is `Premium`. Defaults to `Premium`.
        """
        pulumi.set(__self__, "name", name)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        The SKU name. Possible values are `Premium_LRS` and `Premium_ZRS`. Changing this forces a new resource to be created.

        > **Note:** `Premium_ZRS` SKU is only available in limited Azure regions including `France Central`, `North Europe`, `West Europe`, and `West US 2`. Please refer to this [document](https://azure.microsoft.com/updates/regional-expansion-azure-elastic-san-public-preview-is-now-available-in-more-regions) for more details.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The SKU tier. The only possible value is `Premium`. Defaults to `Premium`.
        """
        return pulumi.get(self, "tier")

    @tier.setter
    def tier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tier", value)


if not MYPY:
    class VolumeCreateSourceArgsDict(TypedDict):
        source_id: pulumi.Input[builtins.str]
        """
        Specifies the ID of the source to create the Elastic SAN Volume from. Changing this forces a new resource to be created.
        """
        source_type: pulumi.Input[builtins.str]
        """
        Specifies the type of the source to create the Elastic SAN Volume from. Possible values are `Disk`, `DiskRestorePoint`, `DiskSnapshot` and `VolumeSnapshot`. Changing this forces a new resource to be created.
        """
elif False:
    VolumeCreateSourceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VolumeCreateSourceArgs:
    def __init__(__self__, *,
                 source_id: pulumi.Input[builtins.str],
                 source_type: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] source_id: Specifies the ID of the source to create the Elastic SAN Volume from. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] source_type: Specifies the type of the source to create the Elastic SAN Volume from. Possible values are `Disk`, `DiskRestorePoint`, `DiskSnapshot` and `VolumeSnapshot`. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "source_id", source_id)
        pulumi.set(__self__, "source_type", source_type)

    @property
    @pulumi.getter(name="sourceId")
    def source_id(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the ID of the source to create the Elastic SAN Volume from. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "source_id")

    @source_id.setter
    def source_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "source_id", value)

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the type of the source to create the Elastic SAN Volume from. Possible values are `Disk`, `DiskRestorePoint`, `DiskSnapshot` and `VolumeSnapshot`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "source_type")

    @source_type.setter
    def source_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "source_type", value)


if not MYPY:
    class VolumeGroupEncryptionArgsDict(TypedDict):
        key_vault_key_id: pulumi.Input[builtins.str]
        """
        The Key Vault key URI for Customer Managed Key encryption, which can be either a full URI or a versionless URI.
        """
        current_versioned_key_expiration_timestamp: NotRequired[pulumi.Input[builtins.str]]
        """
        The timestamp of the expiration time for the current version of the customer managed key.
        """
        current_versioned_key_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The ID of the current versioned Key Vault Key in use.
        """
        last_key_rotation_timestamp: NotRequired[pulumi.Input[builtins.str]]
        """
        The timestamp of the last rotation of the Key Vault Key.
        """
        user_assigned_identity_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The ID of the User Assigned Identity used by this Elastic SAN Volume Group.
        """
elif False:
    VolumeGroupEncryptionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VolumeGroupEncryptionArgs:
    def __init__(__self__, *,
                 key_vault_key_id: pulumi.Input[builtins.str],
                 current_versioned_key_expiration_timestamp: Optional[pulumi.Input[builtins.str]] = None,
                 current_versioned_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 last_key_rotation_timestamp: Optional[pulumi.Input[builtins.str]] = None,
                 user_assigned_identity_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] key_vault_key_id: The Key Vault key URI for Customer Managed Key encryption, which can be either a full URI or a versionless URI.
        :param pulumi.Input[builtins.str] current_versioned_key_expiration_timestamp: The timestamp of the expiration time for the current version of the customer managed key.
        :param pulumi.Input[builtins.str] current_versioned_key_id: The ID of the current versioned Key Vault Key in use.
        :param pulumi.Input[builtins.str] last_key_rotation_timestamp: The timestamp of the last rotation of the Key Vault Key.
        :param pulumi.Input[builtins.str] user_assigned_identity_id: The ID of the User Assigned Identity used by this Elastic SAN Volume Group.
        """
        pulumi.set(__self__, "key_vault_key_id", key_vault_key_id)
        if current_versioned_key_expiration_timestamp is not None:
            pulumi.set(__self__, "current_versioned_key_expiration_timestamp", current_versioned_key_expiration_timestamp)
        if current_versioned_key_id is not None:
            pulumi.set(__self__, "current_versioned_key_id", current_versioned_key_id)
        if last_key_rotation_timestamp is not None:
            pulumi.set(__self__, "last_key_rotation_timestamp", last_key_rotation_timestamp)
        if user_assigned_identity_id is not None:
            pulumi.set(__self__, "user_assigned_identity_id", user_assigned_identity_id)

    @property
    @pulumi.getter(name="keyVaultKeyId")
    def key_vault_key_id(self) -> pulumi.Input[builtins.str]:
        """
        The Key Vault key URI for Customer Managed Key encryption, which can be either a full URI or a versionless URI.
        """
        return pulumi.get(self, "key_vault_key_id")

    @key_vault_key_id.setter
    def key_vault_key_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "key_vault_key_id", value)

    @property
    @pulumi.getter(name="currentVersionedKeyExpirationTimestamp")
    def current_versioned_key_expiration_timestamp(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The timestamp of the expiration time for the current version of the customer managed key.
        """
        return pulumi.get(self, "current_versioned_key_expiration_timestamp")

    @current_versioned_key_expiration_timestamp.setter
    def current_versioned_key_expiration_timestamp(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "current_versioned_key_expiration_timestamp", value)

    @property
    @pulumi.getter(name="currentVersionedKeyId")
    def current_versioned_key_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the current versioned Key Vault Key in use.
        """
        return pulumi.get(self, "current_versioned_key_id")

    @current_versioned_key_id.setter
    def current_versioned_key_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "current_versioned_key_id", value)

    @property
    @pulumi.getter(name="lastKeyRotationTimestamp")
    def last_key_rotation_timestamp(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The timestamp of the last rotation of the Key Vault Key.
        """
        return pulumi.get(self, "last_key_rotation_timestamp")

    @last_key_rotation_timestamp.setter
    def last_key_rotation_timestamp(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "last_key_rotation_timestamp", value)

    @property
    @pulumi.getter(name="userAssignedIdentityId")
    def user_assigned_identity_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the User Assigned Identity used by this Elastic SAN Volume Group.
        """
        return pulumi.get(self, "user_assigned_identity_id")

    @user_assigned_identity_id.setter
    def user_assigned_identity_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "user_assigned_identity_id", value)


if not MYPY:
    class VolumeGroupIdentityArgsDict(TypedDict):
        type: pulumi.Input[builtins.str]
        """
        Specifies the type of Managed Identity that should be assigned to this Elastic SAN Volume Group. Possible values are `SystemAssigned` and `UserAssigned`.
        """
        identity_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        A list of the User Assigned Identity IDs that should be assigned to this Elastic SAN Volume Group.
        """
        principal_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The Principal ID associated with the Managed Service Identity assigned to this Elastic SAN Volume Group.
        """
        tenant_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The Tenant ID associated with this Managed Service Identity assigned to this Elastic SAN Volume Group.
        """
elif False:
    VolumeGroupIdentityArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VolumeGroupIdentityArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[builtins.str],
                 identity_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 principal_id: Optional[pulumi.Input[builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] type: Specifies the type of Managed Identity that should be assigned to this Elastic SAN Volume Group. Possible values are `SystemAssigned` and `UserAssigned`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] identity_ids: A list of the User Assigned Identity IDs that should be assigned to this Elastic SAN Volume Group.
        :param pulumi.Input[builtins.str] principal_id: The Principal ID associated with the Managed Service Identity assigned to this Elastic SAN Volume Group.
        :param pulumi.Input[builtins.str] tenant_id: The Tenant ID associated with this Managed Service Identity assigned to this Elastic SAN Volume Group.
        """
        pulumi.set(__self__, "type", type)
        if identity_ids is not None:
            pulumi.set(__self__, "identity_ids", identity_ids)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the type of Managed Identity that should be assigned to this Elastic SAN Volume Group. Possible values are `SystemAssigned` and `UserAssigned`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of the User Assigned Identity IDs that should be assigned to this Elastic SAN Volume Group.
        """
        return pulumi.get(self, "identity_ids")

    @identity_ids.setter
    def identity_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "identity_ids", value)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Principal ID associated with the Managed Service Identity assigned to this Elastic SAN Volume Group.
        """
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "principal_id", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Tenant ID associated with this Managed Service Identity assigned to this Elastic SAN Volume Group.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tenant_id", value)


if not MYPY:
    class VolumeGroupNetworkRuleArgsDict(TypedDict):
        subnet_id: pulumi.Input[builtins.str]
        """
        The ID of the Subnet which should be allowed to access this Elastic SAN Volume Group.
        """
        action: NotRequired[pulumi.Input[builtins.str]]
        """
        The action to take when the Subnet attempts to access this Elastic SAN Volume Group. The only possible value is `Allow`. Defaults to `Allow`.
        """
elif False:
    VolumeGroupNetworkRuleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VolumeGroupNetworkRuleArgs:
    def __init__(__self__, *,
                 subnet_id: pulumi.Input[builtins.str],
                 action: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] subnet_id: The ID of the Subnet which should be allowed to access this Elastic SAN Volume Group.
        :param pulumi.Input[builtins.str] action: The action to take when the Subnet attempts to access this Elastic SAN Volume Group. The only possible value is `Allow`. Defaults to `Allow`.
        """
        pulumi.set(__self__, "subnet_id", subnet_id)
        if action is not None:
            pulumi.set(__self__, "action", action)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the Subnet which should be allowed to access this Elastic SAN Volume Group.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The action to take when the Subnet attempts to access this Elastic SAN Volume Group. The only possible value is `Allow`. Defaults to `Allow`.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "action", value)


