# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetResult',
    'AwaitableGetResult',
    'get',
    'get_output',
]

@pulumi.output_type
class GetResult:
    """
    A collection of values returned by get.
    """
    def __init__(__self__, base_size_in_tib=None, extended_size_in_tib=None, id=None, location=None, name=None, resource_group_name=None, skus=None, tags=None, total_iops=None, total_mbps=None, total_size_in_tib=None, total_volume_size_in_gib=None, volume_group_count=None, zones=None):
        if base_size_in_tib and not isinstance(base_size_in_tib, int):
            raise TypeError("Expected argument 'base_size_in_tib' to be a int")
        pulumi.set(__self__, "base_size_in_tib", base_size_in_tib)
        if extended_size_in_tib and not isinstance(extended_size_in_tib, int):
            raise TypeError("Expected argument 'extended_size_in_tib' to be a int")
        pulumi.set(__self__, "extended_size_in_tib", extended_size_in_tib)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if skus and not isinstance(skus, list):
            raise TypeError("Expected argument 'skus' to be a list")
        pulumi.set(__self__, "skus", skus)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if total_iops and not isinstance(total_iops, int):
            raise TypeError("Expected argument 'total_iops' to be a int")
        pulumi.set(__self__, "total_iops", total_iops)
        if total_mbps and not isinstance(total_mbps, int):
            raise TypeError("Expected argument 'total_mbps' to be a int")
        pulumi.set(__self__, "total_mbps", total_mbps)
        if total_size_in_tib and not isinstance(total_size_in_tib, int):
            raise TypeError("Expected argument 'total_size_in_tib' to be a int")
        pulumi.set(__self__, "total_size_in_tib", total_size_in_tib)
        if total_volume_size_in_gib and not isinstance(total_volume_size_in_gib, int):
            raise TypeError("Expected argument 'total_volume_size_in_gib' to be a int")
        pulumi.set(__self__, "total_volume_size_in_gib", total_volume_size_in_gib)
        if volume_group_count and not isinstance(volume_group_count, int):
            raise TypeError("Expected argument 'volume_group_count' to be a int")
        pulumi.set(__self__, "volume_group_count", volume_group_count)
        if zones and not isinstance(zones, list):
            raise TypeError("Expected argument 'zones' to be a list")
        pulumi.set(__self__, "zones", zones)

    @property
    @pulumi.getter(name="baseSizeInTib")
    def base_size_in_tib(self) -> builtins.int:
        """
        The base size of the Elastic SAN resource in TiB.
        """
        return pulumi.get(self, "base_size_in_tib")

    @property
    @pulumi.getter(name="extendedSizeInTib")
    def extended_size_in_tib(self) -> builtins.int:
        """
        The base size of the Elastic SAN resource in TiB.
        """
        return pulumi.get(self, "extended_size_in_tib")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def location(self) -> builtins.str:
        """
        The Azure Region where the Elastic SAN exists.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The SKU name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> builtins.str:
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter
    def skus(self) -> Sequence['outputs.GetSkusResult']:
        """
        A `sku` block as defined below.
        """
        return pulumi.get(self, "skus")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, builtins.str]:
        """
        A mapping of tags assigned to the Elastic SAN.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="totalIops")
    def total_iops(self) -> builtins.int:
        """
        Total Provisioned IOps of the Elastic SAN resource.
        """
        return pulumi.get(self, "total_iops")

    @property
    @pulumi.getter(name="totalMbps")
    def total_mbps(self) -> builtins.int:
        """
        Total Provisioned MBps Elastic SAN resource.
        """
        return pulumi.get(self, "total_mbps")

    @property
    @pulumi.getter(name="totalSizeInTib")
    def total_size_in_tib(self) -> builtins.int:
        """
        Total size of the Elastic SAN resource in TB.
        """
        return pulumi.get(self, "total_size_in_tib")

    @property
    @pulumi.getter(name="totalVolumeSizeInGib")
    def total_volume_size_in_gib(self) -> builtins.int:
        """
        Total size of the provisioned Volumes in GiB.
        """
        return pulumi.get(self, "total_volume_size_in_gib")

    @property
    @pulumi.getter(name="volumeGroupCount")
    def volume_group_count(self) -> builtins.int:
        """
        Total number of volume groups in this Elastic SAN resource.
        """
        return pulumi.get(self, "volume_group_count")

    @property
    @pulumi.getter
    def zones(self) -> Sequence[builtins.str]:
        """
        Logical zone for the Elastic SAN resource.
        """
        return pulumi.get(self, "zones")


class AwaitableGetResult(GetResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetResult(
            base_size_in_tib=self.base_size_in_tib,
            extended_size_in_tib=self.extended_size_in_tib,
            id=self.id,
            location=self.location,
            name=self.name,
            resource_group_name=self.resource_group_name,
            skus=self.skus,
            tags=self.tags,
            total_iops=self.total_iops,
            total_mbps=self.total_mbps,
            total_size_in_tib=self.total_size_in_tib,
            total_volume_size_in_gib=self.total_volume_size_in_gib,
            volume_group_count=self.volume_group_count,
            zones=self.zones)


def get(name: Optional[builtins.str] = None,
        resource_group_name: Optional[builtins.str] = None,
        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetResult:
    """
    Use this data source to access information about an existing Elastic SAN.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.elasticsan.get(name="existing",
        resource_group_name="existing")
    pulumi.export("id", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.ElasticSan`: 2023-01-01


    :param builtins.str name: The name of this Elastic SAN.
    :param builtins.str resource_group_name: The name of the Resource Group where the Elastic SAN exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:elasticsan/get:get', __args__, opts=opts, typ=GetResult).value

    return AwaitableGetResult(
        base_size_in_tib=pulumi.get(__ret__, 'base_size_in_tib'),
        extended_size_in_tib=pulumi.get(__ret__, 'extended_size_in_tib'),
        id=pulumi.get(__ret__, 'id'),
        location=pulumi.get(__ret__, 'location'),
        name=pulumi.get(__ret__, 'name'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'),
        skus=pulumi.get(__ret__, 'skus'),
        tags=pulumi.get(__ret__, 'tags'),
        total_iops=pulumi.get(__ret__, 'total_iops'),
        total_mbps=pulumi.get(__ret__, 'total_mbps'),
        total_size_in_tib=pulumi.get(__ret__, 'total_size_in_tib'),
        total_volume_size_in_gib=pulumi.get(__ret__, 'total_volume_size_in_gib'),
        volume_group_count=pulumi.get(__ret__, 'volume_group_count'),
        zones=pulumi.get(__ret__, 'zones'))
def get_output(name: Optional[pulumi.Input[builtins.str]] = None,
               resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetResult]:
    """
    Use this data source to access information about an existing Elastic SAN.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.elasticsan.get(name="existing",
        resource_group_name="existing")
    pulumi.export("id", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.ElasticSan`: 2023-01-01


    :param builtins.str name: The name of this Elastic SAN.
    :param builtins.str resource_group_name: The name of the Resource Group where the Elastic SAN exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:elasticsan/get:get', __args__, opts=opts, typ=GetResult)
    return __ret__.apply(lambda __response__: GetResult(
        base_size_in_tib=pulumi.get(__response__, 'base_size_in_tib'),
        extended_size_in_tib=pulumi.get(__response__, 'extended_size_in_tib'),
        id=pulumi.get(__response__, 'id'),
        location=pulumi.get(__response__, 'location'),
        name=pulumi.get(__response__, 'name'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name'),
        skus=pulumi.get(__response__, 'skus'),
        tags=pulumi.get(__response__, 'tags'),
        total_iops=pulumi.get(__response__, 'total_iops'),
        total_mbps=pulumi.get(__response__, 'total_mbps'),
        total_size_in_tib=pulumi.get(__response__, 'total_size_in_tib'),
        total_volume_size_in_gib=pulumi.get(__response__, 'total_volume_size_in_gib'),
        volume_group_count=pulumi.get(__response__, 'volume_group_count'),
        zones=pulumi.get(__response__, 'zones')))
