# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'DomainIdentity',
    'DomainInboundIpRule',
    'DomainInputMappingDefaultValues',
    'DomainInputMappingFields',
    'EventSubscriptionAdvancedFilter',
    'EventSubscriptionAdvancedFilterBoolEqual',
    'EventSubscriptionAdvancedFilterIsNotNull',
    'EventSubscriptionAdvancedFilterIsNullOrUndefined',
    'EventSubscriptionAdvancedFilterNumberGreaterThan',
    'EventSubscriptionAdvancedFilterNumberGreaterThanOrEqual',
    'EventSubscriptionAdvancedFilterNumberIn',
    'EventSubscriptionAdvancedFilterNumberInRange',
    'EventSubscriptionAdvancedFilterNumberLessThan',
    'EventSubscriptionAdvancedFilterNumberLessThanOrEqual',
    'EventSubscriptionAdvancedFilterNumberNotIn',
    'EventSubscriptionAdvancedFilterNumberNotInRange',
    'EventSubscriptionAdvancedFilterStringBeginsWith',
    'EventSubscriptionAdvancedFilterStringContain',
    'EventSubscriptionAdvancedFilterStringEndsWith',
    'EventSubscriptionAdvancedFilterStringIn',
    'EventSubscriptionAdvancedFilterStringNotBeginsWith',
    'EventSubscriptionAdvancedFilterStringNotContain',
    'EventSubscriptionAdvancedFilterStringNotEndsWith',
    'EventSubscriptionAdvancedFilterStringNotIn',
    'EventSubscriptionAzureFunctionEndpoint',
    'EventSubscriptionDeadLetterIdentity',
    'EventSubscriptionDeliveryIdentity',
    'EventSubscriptionDeliveryProperty',
    'EventSubscriptionRetryPolicy',
    'EventSubscriptionStorageBlobDeadLetterDestination',
    'EventSubscriptionStorageQueueEndpoint',
    'EventSubscriptionSubjectFilter',
    'EventSubscriptionWebhookEndpoint',
    'NamespaceIdentity',
    'NamespaceInboundIpRule',
    'NamespaceTopicSpacesConfiguration',
    'NamespaceTopicSpacesConfigurationDynamicRoutingEnrichment',
    'NamespaceTopicSpacesConfigurationStaticRoutingEnrichment',
    'PartnerConfigurationPartnerAuthorization',
    'SystemTopicEventSubscriptionAdvancedFilter',
    'SystemTopicEventSubscriptionAdvancedFilterBoolEqual',
    'SystemTopicEventSubscriptionAdvancedFilterIsNotNull',
    'SystemTopicEventSubscriptionAdvancedFilterIsNullOrUndefined',
    'SystemTopicEventSubscriptionAdvancedFilterNumberGreaterThan',
    'SystemTopicEventSubscriptionAdvancedFilterNumberGreaterThanOrEqual',
    'SystemTopicEventSubscriptionAdvancedFilterNumberIn',
    'SystemTopicEventSubscriptionAdvancedFilterNumberInRange',
    'SystemTopicEventSubscriptionAdvancedFilterNumberLessThan',
    'SystemTopicEventSubscriptionAdvancedFilterNumberLessThanOrEqual',
    'SystemTopicEventSubscriptionAdvancedFilterNumberNotIn',
    'SystemTopicEventSubscriptionAdvancedFilterNumberNotInRange',
    'SystemTopicEventSubscriptionAdvancedFilterStringBeginsWith',
    'SystemTopicEventSubscriptionAdvancedFilterStringContain',
    'SystemTopicEventSubscriptionAdvancedFilterStringEndsWith',
    'SystemTopicEventSubscriptionAdvancedFilterStringIn',
    'SystemTopicEventSubscriptionAdvancedFilterStringNotBeginsWith',
    'SystemTopicEventSubscriptionAdvancedFilterStringNotContain',
    'SystemTopicEventSubscriptionAdvancedFilterStringNotEndsWith',
    'SystemTopicEventSubscriptionAdvancedFilterStringNotIn',
    'SystemTopicEventSubscriptionAzureFunctionEndpoint',
    'SystemTopicEventSubscriptionDeadLetterIdentity',
    'SystemTopicEventSubscriptionDeliveryIdentity',
    'SystemTopicEventSubscriptionDeliveryProperty',
    'SystemTopicEventSubscriptionRetryPolicy',
    'SystemTopicEventSubscriptionStorageBlobDeadLetterDestination',
    'SystemTopicEventSubscriptionStorageQueueEndpoint',
    'SystemTopicEventSubscriptionSubjectFilter',
    'SystemTopicEventSubscriptionWebhookEndpoint',
    'SystemTopicIdentity',
    'TopicIdentity',
    'TopicInboundIpRule',
    'TopicInputMappingDefaultValues',
    'TopicInputMappingFields',
    'GetDomainIdentityResult',
    'GetDomainInboundIpRuleResult',
    'GetDomainInputMappingDefaultValueResult',
    'GetDomainInputMappingFieldResult',
    'GetSystemTopicIdentityResult',
]

@pulumi.output_type
class DomainIdentity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "identityIds":
            suggest = "identity_ids"
        elif key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: builtins.str,
                 identity_ids: Optional[Sequence[builtins.str]] = None,
                 principal_id: Optional[builtins.str] = None,
                 tenant_id: Optional[builtins.str] = None):
        """
        :param builtins.str type: Specifies the type of Managed Service Identity that should be configured on this Event Grid Domain. Possible values are `SystemAssigned`, `UserAssigned`.
        :param Sequence[builtins.str] identity_ids: Specifies a list of User Assigned Managed Identity IDs to be assigned to this Event Grid Domain.
               
               > **Note:** This is required when `type` is set to `UserAssigned`
               
               > **Note:** When `type` is set to `SystemAssigned`, The assigned `principal_id` and `tenant_id` can be retrieved after the Event Grid Domain has been created. More details are available below.
        :param builtins.str principal_id: The Principal ID associated with this Managed Service Identity.
        :param builtins.str tenant_id: The Tenant ID associated with this Managed Service Identity.
        """
        pulumi.set(__self__, "type", type)
        if identity_ids is not None:
            pulumi.set(__self__, "identity_ids", identity_ids)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Specifies the type of Managed Service Identity that should be configured on this Event Grid Domain. Possible values are `SystemAssigned`, `UserAssigned`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        Specifies a list of User Assigned Managed Identity IDs to be assigned to this Event Grid Domain.

        > **Note:** This is required when `type` is set to `UserAssigned`

        > **Note:** When `type` is set to `SystemAssigned`, The assigned `principal_id` and `tenant_id` can be retrieved after the Event Grid Domain has been created. More details are available below.
        """
        return pulumi.get(self, "identity_ids")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[builtins.str]:
        """
        The Principal ID associated with this Managed Service Identity.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[builtins.str]:
        """
        The Tenant ID associated with this Managed Service Identity.
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class DomainInboundIpRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipMask":
            suggest = "ip_mask"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainInboundIpRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainInboundIpRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainInboundIpRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_mask: builtins.str,
                 action: Optional[builtins.str] = None):
        """
        :param builtins.str ip_mask: The IP mask (CIDR) to match on.
        :param builtins.str action: The action to take when the rule is matched. Possible values are `Allow`. Defaults to `Allow`.
        """
        pulumi.set(__self__, "ip_mask", ip_mask)
        if action is not None:
            pulumi.set(__self__, "action", action)

    @property
    @pulumi.getter(name="ipMask")
    def ip_mask(self) -> builtins.str:
        """
        The IP mask (CIDR) to match on.
        """
        return pulumi.get(self, "ip_mask")

    @property
    @pulumi.getter
    def action(self) -> Optional[builtins.str]:
        """
        The action to take when the rule is matched. Possible values are `Allow`. Defaults to `Allow`.
        """
        return pulumi.get(self, "action")


@pulumi.output_type
class DomainInputMappingDefaultValues(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataVersion":
            suggest = "data_version"
        elif key == "eventType":
            suggest = "event_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainInputMappingDefaultValues. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainInputMappingDefaultValues.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainInputMappingDefaultValues.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_version: Optional[builtins.str] = None,
                 event_type: Optional[builtins.str] = None,
                 subject: Optional[builtins.str] = None):
        """
        :param builtins.str data_version: Specifies the default data version of the EventGrid Event to associate with the domain. Changing this forces a new resource to be created.
        :param builtins.str event_type: Specifies the default event type of the EventGrid Event to associate with the domain. Changing this forces a new resource to be created.
        :param builtins.str subject: Specifies the default subject of the EventGrid Event to associate with the domain. Changing this forces a new resource to be created.
        """
        if data_version is not None:
            pulumi.set(__self__, "data_version", data_version)
        if event_type is not None:
            pulumi.set(__self__, "event_type", event_type)
        if subject is not None:
            pulumi.set(__self__, "subject", subject)

    @property
    @pulumi.getter(name="dataVersion")
    def data_version(self) -> Optional[builtins.str]:
        """
        Specifies the default data version of the EventGrid Event to associate with the domain. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "data_version")

    @property
    @pulumi.getter(name="eventType")
    def event_type(self) -> Optional[builtins.str]:
        """
        Specifies the default event type of the EventGrid Event to associate with the domain. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "event_type")

    @property
    @pulumi.getter
    def subject(self) -> Optional[builtins.str]:
        """
        Specifies the default subject of the EventGrid Event to associate with the domain. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "subject")


@pulumi.output_type
class DomainInputMappingFields(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataVersion":
            suggest = "data_version"
        elif key == "eventTime":
            suggest = "event_time"
        elif key == "eventType":
            suggest = "event_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainInputMappingFields. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainInputMappingFields.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainInputMappingFields.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_version: Optional[builtins.str] = None,
                 event_time: Optional[builtins.str] = None,
                 event_type: Optional[builtins.str] = None,
                 id: Optional[builtins.str] = None,
                 subject: Optional[builtins.str] = None,
                 topic: Optional[builtins.str] = None):
        """
        :param builtins.str data_version: Specifies the data version of the EventGrid Event to associate with the domain. Changing this forces a new resource to be created.
        :param builtins.str event_time: Specifies the event time of the EventGrid Event to associate with the domain. Changing this forces a new resource to be created.
        :param builtins.str event_type: Specifies the event type of the EventGrid Event to associate with the domain. Changing this forces a new resource to be created.
        :param builtins.str id: Specifies the id of the EventGrid Event to associate with the domain. Changing this forces a new resource to be created.
        :param builtins.str subject: Specifies the subject of the EventGrid Event to associate with the domain. Changing this forces a new resource to be created.
        :param builtins.str topic: Specifies the topic of the EventGrid Event to associate with the domain. Changing this forces a new resource to be created.
        """
        if data_version is not None:
            pulumi.set(__self__, "data_version", data_version)
        if event_time is not None:
            pulumi.set(__self__, "event_time", event_time)
        if event_type is not None:
            pulumi.set(__self__, "event_type", event_type)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if subject is not None:
            pulumi.set(__self__, "subject", subject)
        if topic is not None:
            pulumi.set(__self__, "topic", topic)

    @property
    @pulumi.getter(name="dataVersion")
    def data_version(self) -> Optional[builtins.str]:
        """
        Specifies the data version of the EventGrid Event to associate with the domain. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "data_version")

    @property
    @pulumi.getter(name="eventTime")
    def event_time(self) -> Optional[builtins.str]:
        """
        Specifies the event time of the EventGrid Event to associate with the domain. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "event_time")

    @property
    @pulumi.getter(name="eventType")
    def event_type(self) -> Optional[builtins.str]:
        """
        Specifies the event type of the EventGrid Event to associate with the domain. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "event_type")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        Specifies the id of the EventGrid Event to associate with the domain. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def subject(self) -> Optional[builtins.str]:
        """
        Specifies the subject of the EventGrid Event to associate with the domain. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "subject")

    @property
    @pulumi.getter
    def topic(self) -> Optional[builtins.str]:
        """
        Specifies the topic of the EventGrid Event to associate with the domain. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "topic")


@pulumi.output_type
class EventSubscriptionAdvancedFilter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "boolEquals":
            suggest = "bool_equals"
        elif key == "isNotNulls":
            suggest = "is_not_nulls"
        elif key == "isNullOrUndefineds":
            suggest = "is_null_or_undefineds"
        elif key == "numberGreaterThanOrEquals":
            suggest = "number_greater_than_or_equals"
        elif key == "numberGreaterThans":
            suggest = "number_greater_thans"
        elif key == "numberInRanges":
            suggest = "number_in_ranges"
        elif key == "numberIns":
            suggest = "number_ins"
        elif key == "numberLessThanOrEquals":
            suggest = "number_less_than_or_equals"
        elif key == "numberLessThans":
            suggest = "number_less_thans"
        elif key == "numberNotInRanges":
            suggest = "number_not_in_ranges"
        elif key == "numberNotIns":
            suggest = "number_not_ins"
        elif key == "stringBeginsWiths":
            suggest = "string_begins_withs"
        elif key == "stringContains":
            suggest = "string_contains"
        elif key == "stringEndsWiths":
            suggest = "string_ends_withs"
        elif key == "stringIns":
            suggest = "string_ins"
        elif key == "stringNotBeginsWiths":
            suggest = "string_not_begins_withs"
        elif key == "stringNotContains":
            suggest = "string_not_contains"
        elif key == "stringNotEndsWiths":
            suggest = "string_not_ends_withs"
        elif key == "stringNotIns":
            suggest = "string_not_ins"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventSubscriptionAdvancedFilter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventSubscriptionAdvancedFilter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventSubscriptionAdvancedFilter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bool_equals: Optional[Sequence['outputs.EventSubscriptionAdvancedFilterBoolEqual']] = None,
                 is_not_nulls: Optional[Sequence['outputs.EventSubscriptionAdvancedFilterIsNotNull']] = None,
                 is_null_or_undefineds: Optional[Sequence['outputs.EventSubscriptionAdvancedFilterIsNullOrUndefined']] = None,
                 number_greater_than_or_equals: Optional[Sequence['outputs.EventSubscriptionAdvancedFilterNumberGreaterThanOrEqual']] = None,
                 number_greater_thans: Optional[Sequence['outputs.EventSubscriptionAdvancedFilterNumberGreaterThan']] = None,
                 number_in_ranges: Optional[Sequence['outputs.EventSubscriptionAdvancedFilterNumberInRange']] = None,
                 number_ins: Optional[Sequence['outputs.EventSubscriptionAdvancedFilterNumberIn']] = None,
                 number_less_than_or_equals: Optional[Sequence['outputs.EventSubscriptionAdvancedFilterNumberLessThanOrEqual']] = None,
                 number_less_thans: Optional[Sequence['outputs.EventSubscriptionAdvancedFilterNumberLessThan']] = None,
                 number_not_in_ranges: Optional[Sequence['outputs.EventSubscriptionAdvancedFilterNumberNotInRange']] = None,
                 number_not_ins: Optional[Sequence['outputs.EventSubscriptionAdvancedFilterNumberNotIn']] = None,
                 string_begins_withs: Optional[Sequence['outputs.EventSubscriptionAdvancedFilterStringBeginsWith']] = None,
                 string_contains: Optional[Sequence['outputs.EventSubscriptionAdvancedFilterStringContain']] = None,
                 string_ends_withs: Optional[Sequence['outputs.EventSubscriptionAdvancedFilterStringEndsWith']] = None,
                 string_ins: Optional[Sequence['outputs.EventSubscriptionAdvancedFilterStringIn']] = None,
                 string_not_begins_withs: Optional[Sequence['outputs.EventSubscriptionAdvancedFilterStringNotBeginsWith']] = None,
                 string_not_contains: Optional[Sequence['outputs.EventSubscriptionAdvancedFilterStringNotContain']] = None,
                 string_not_ends_withs: Optional[Sequence['outputs.EventSubscriptionAdvancedFilterStringNotEndsWith']] = None,
                 string_not_ins: Optional[Sequence['outputs.EventSubscriptionAdvancedFilterStringNotIn']] = None):
        """
        :param Sequence['EventSubscriptionAdvancedFilterBoolEqualArgs'] bool_equals: Compares a value of an event using a single boolean value.
        :param Sequence['EventSubscriptionAdvancedFilterIsNotNullArgs'] is_not_nulls: Evaluates if a value of an event isn't NULL or undefined.
        :param Sequence['EventSubscriptionAdvancedFilterIsNullOrUndefinedArgs'] is_null_or_undefineds: Evaluates if a value of an event is NULL or undefined.
               
               Each nested block consists of a key and a value(s) element.
        :param Sequence['EventSubscriptionAdvancedFilterNumberGreaterThanOrEqualArgs'] number_greater_than_or_equals: Compares a value of an event using a single floating point number.
        :param Sequence['EventSubscriptionAdvancedFilterNumberGreaterThanArgs'] number_greater_thans: Compares a value of an event using a single floating point number.
        :param Sequence['EventSubscriptionAdvancedFilterNumberInRangeArgs'] number_in_ranges: Compares a value of an event using multiple floating point number ranges.
        :param Sequence['EventSubscriptionAdvancedFilterNumberInArgs'] number_ins: Compares a value of an event using multiple floating point numbers.
        :param Sequence['EventSubscriptionAdvancedFilterNumberLessThanOrEqualArgs'] number_less_than_or_equals: Compares a value of an event using a single floating point number.
        :param Sequence['EventSubscriptionAdvancedFilterNumberLessThanArgs'] number_less_thans: Compares a value of an event using a single floating point number.
        :param Sequence['EventSubscriptionAdvancedFilterNumberNotInRangeArgs'] number_not_in_ranges: Compares a value of an event using multiple floating point number ranges.
        :param Sequence['EventSubscriptionAdvancedFilterNumberNotInArgs'] number_not_ins: Compares a value of an event using multiple floating point numbers.
        :param Sequence['EventSubscriptionAdvancedFilterStringBeginsWithArgs'] string_begins_withs: Compares a value of an event using multiple string values.
        :param Sequence['EventSubscriptionAdvancedFilterStringContainArgs'] string_contains: Compares a value of an event using multiple string values.
        :param Sequence['EventSubscriptionAdvancedFilterStringEndsWithArgs'] string_ends_withs: Compares a value of an event using multiple string values.
        :param Sequence['EventSubscriptionAdvancedFilterStringInArgs'] string_ins: Compares a value of an event using multiple string values.
        :param Sequence['EventSubscriptionAdvancedFilterStringNotBeginsWithArgs'] string_not_begins_withs: Compares a value of an event using multiple string values.
        :param Sequence['EventSubscriptionAdvancedFilterStringNotContainArgs'] string_not_contains: Compares a value of an event using multiple string values.
        :param Sequence['EventSubscriptionAdvancedFilterStringNotEndsWithArgs'] string_not_ends_withs: Compares a value of an event using multiple string values.
        :param Sequence['EventSubscriptionAdvancedFilterStringNotInArgs'] string_not_ins: Compares a value of an event using multiple string values.
        """
        if bool_equals is not None:
            pulumi.set(__self__, "bool_equals", bool_equals)
        if is_not_nulls is not None:
            pulumi.set(__self__, "is_not_nulls", is_not_nulls)
        if is_null_or_undefineds is not None:
            pulumi.set(__self__, "is_null_or_undefineds", is_null_or_undefineds)
        if number_greater_than_or_equals is not None:
            pulumi.set(__self__, "number_greater_than_or_equals", number_greater_than_or_equals)
        if number_greater_thans is not None:
            pulumi.set(__self__, "number_greater_thans", number_greater_thans)
        if number_in_ranges is not None:
            pulumi.set(__self__, "number_in_ranges", number_in_ranges)
        if number_ins is not None:
            pulumi.set(__self__, "number_ins", number_ins)
        if number_less_than_or_equals is not None:
            pulumi.set(__self__, "number_less_than_or_equals", number_less_than_or_equals)
        if number_less_thans is not None:
            pulumi.set(__self__, "number_less_thans", number_less_thans)
        if number_not_in_ranges is not None:
            pulumi.set(__self__, "number_not_in_ranges", number_not_in_ranges)
        if number_not_ins is not None:
            pulumi.set(__self__, "number_not_ins", number_not_ins)
        if string_begins_withs is not None:
            pulumi.set(__self__, "string_begins_withs", string_begins_withs)
        if string_contains is not None:
            pulumi.set(__self__, "string_contains", string_contains)
        if string_ends_withs is not None:
            pulumi.set(__self__, "string_ends_withs", string_ends_withs)
        if string_ins is not None:
            pulumi.set(__self__, "string_ins", string_ins)
        if string_not_begins_withs is not None:
            pulumi.set(__self__, "string_not_begins_withs", string_not_begins_withs)
        if string_not_contains is not None:
            pulumi.set(__self__, "string_not_contains", string_not_contains)
        if string_not_ends_withs is not None:
            pulumi.set(__self__, "string_not_ends_withs", string_not_ends_withs)
        if string_not_ins is not None:
            pulumi.set(__self__, "string_not_ins", string_not_ins)

    @property
    @pulumi.getter(name="boolEquals")
    def bool_equals(self) -> Optional[Sequence['outputs.EventSubscriptionAdvancedFilterBoolEqual']]:
        """
        Compares a value of an event using a single boolean value.
        """
        return pulumi.get(self, "bool_equals")

    @property
    @pulumi.getter(name="isNotNulls")
    def is_not_nulls(self) -> Optional[Sequence['outputs.EventSubscriptionAdvancedFilterIsNotNull']]:
        """
        Evaluates if a value of an event isn't NULL or undefined.
        """
        return pulumi.get(self, "is_not_nulls")

    @property
    @pulumi.getter(name="isNullOrUndefineds")
    def is_null_or_undefineds(self) -> Optional[Sequence['outputs.EventSubscriptionAdvancedFilterIsNullOrUndefined']]:
        """
        Evaluates if a value of an event is NULL or undefined.

        Each nested block consists of a key and a value(s) element.
        """
        return pulumi.get(self, "is_null_or_undefineds")

    @property
    @pulumi.getter(name="numberGreaterThanOrEquals")
    def number_greater_than_or_equals(self) -> Optional[Sequence['outputs.EventSubscriptionAdvancedFilterNumberGreaterThanOrEqual']]:
        """
        Compares a value of an event using a single floating point number.
        """
        return pulumi.get(self, "number_greater_than_or_equals")

    @property
    @pulumi.getter(name="numberGreaterThans")
    def number_greater_thans(self) -> Optional[Sequence['outputs.EventSubscriptionAdvancedFilterNumberGreaterThan']]:
        """
        Compares a value of an event using a single floating point number.
        """
        return pulumi.get(self, "number_greater_thans")

    @property
    @pulumi.getter(name="numberInRanges")
    def number_in_ranges(self) -> Optional[Sequence['outputs.EventSubscriptionAdvancedFilterNumberInRange']]:
        """
        Compares a value of an event using multiple floating point number ranges.
        """
        return pulumi.get(self, "number_in_ranges")

    @property
    @pulumi.getter(name="numberIns")
    def number_ins(self) -> Optional[Sequence['outputs.EventSubscriptionAdvancedFilterNumberIn']]:
        """
        Compares a value of an event using multiple floating point numbers.
        """
        return pulumi.get(self, "number_ins")

    @property
    @pulumi.getter(name="numberLessThanOrEquals")
    def number_less_than_or_equals(self) -> Optional[Sequence['outputs.EventSubscriptionAdvancedFilterNumberLessThanOrEqual']]:
        """
        Compares a value of an event using a single floating point number.
        """
        return pulumi.get(self, "number_less_than_or_equals")

    @property
    @pulumi.getter(name="numberLessThans")
    def number_less_thans(self) -> Optional[Sequence['outputs.EventSubscriptionAdvancedFilterNumberLessThan']]:
        """
        Compares a value of an event using a single floating point number.
        """
        return pulumi.get(self, "number_less_thans")

    @property
    @pulumi.getter(name="numberNotInRanges")
    def number_not_in_ranges(self) -> Optional[Sequence['outputs.EventSubscriptionAdvancedFilterNumberNotInRange']]:
        """
        Compares a value of an event using multiple floating point number ranges.
        """
        return pulumi.get(self, "number_not_in_ranges")

    @property
    @pulumi.getter(name="numberNotIns")
    def number_not_ins(self) -> Optional[Sequence['outputs.EventSubscriptionAdvancedFilterNumberNotIn']]:
        """
        Compares a value of an event using multiple floating point numbers.
        """
        return pulumi.get(self, "number_not_ins")

    @property
    @pulumi.getter(name="stringBeginsWiths")
    def string_begins_withs(self) -> Optional[Sequence['outputs.EventSubscriptionAdvancedFilterStringBeginsWith']]:
        """
        Compares a value of an event using multiple string values.
        """
        return pulumi.get(self, "string_begins_withs")

    @property
    @pulumi.getter(name="stringContains")
    def string_contains(self) -> Optional[Sequence['outputs.EventSubscriptionAdvancedFilterStringContain']]:
        """
        Compares a value of an event using multiple string values.
        """
        return pulumi.get(self, "string_contains")

    @property
    @pulumi.getter(name="stringEndsWiths")
    def string_ends_withs(self) -> Optional[Sequence['outputs.EventSubscriptionAdvancedFilterStringEndsWith']]:
        """
        Compares a value of an event using multiple string values.
        """
        return pulumi.get(self, "string_ends_withs")

    @property
    @pulumi.getter(name="stringIns")
    def string_ins(self) -> Optional[Sequence['outputs.EventSubscriptionAdvancedFilterStringIn']]:
        """
        Compares a value of an event using multiple string values.
        """
        return pulumi.get(self, "string_ins")

    @property
    @pulumi.getter(name="stringNotBeginsWiths")
    def string_not_begins_withs(self) -> Optional[Sequence['outputs.EventSubscriptionAdvancedFilterStringNotBeginsWith']]:
        """
        Compares a value of an event using multiple string values.
        """
        return pulumi.get(self, "string_not_begins_withs")

    @property
    @pulumi.getter(name="stringNotContains")
    def string_not_contains(self) -> Optional[Sequence['outputs.EventSubscriptionAdvancedFilterStringNotContain']]:
        """
        Compares a value of an event using multiple string values.
        """
        return pulumi.get(self, "string_not_contains")

    @property
    @pulumi.getter(name="stringNotEndsWiths")
    def string_not_ends_withs(self) -> Optional[Sequence['outputs.EventSubscriptionAdvancedFilterStringNotEndsWith']]:
        """
        Compares a value of an event using multiple string values.
        """
        return pulumi.get(self, "string_not_ends_withs")

    @property
    @pulumi.getter(name="stringNotIns")
    def string_not_ins(self) -> Optional[Sequence['outputs.EventSubscriptionAdvancedFilterStringNotIn']]:
        """
        Compares a value of an event using multiple string values.
        """
        return pulumi.get(self, "string_not_ins")


@pulumi.output_type
class EventSubscriptionAdvancedFilterBoolEqual(dict):
    def __init__(__self__, *,
                 key: builtins.str,
                 value: builtins.bool):
        """
        :param builtins.str key: Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> builtins.bool:
        return pulumi.get(self, "value")


@pulumi.output_type
class EventSubscriptionAdvancedFilterIsNotNull(dict):
    def __init__(__self__, *,
                 key: builtins.str):
        """
        :param builtins.str key: Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        """
        pulumi.set(__self__, "key", key)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        """
        return pulumi.get(self, "key")


@pulumi.output_type
class EventSubscriptionAdvancedFilterIsNullOrUndefined(dict):
    def __init__(__self__, *,
                 key: builtins.str):
        """
        :param builtins.str key: Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        """
        pulumi.set(__self__, "key", key)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        """
        return pulumi.get(self, "key")


@pulumi.output_type
class EventSubscriptionAdvancedFilterNumberGreaterThan(dict):
    def __init__(__self__, *,
                 key: builtins.str,
                 value: builtins.float):
        """
        :param builtins.str key: Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> builtins.float:
        return pulumi.get(self, "value")


@pulumi.output_type
class EventSubscriptionAdvancedFilterNumberGreaterThanOrEqual(dict):
    def __init__(__self__, *,
                 key: builtins.str,
                 value: builtins.float):
        """
        :param builtins.str key: Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> builtins.float:
        return pulumi.get(self, "value")


@pulumi.output_type
class EventSubscriptionAdvancedFilterNumberIn(dict):
    def __init__(__self__, *,
                 key: builtins.str,
                 values: Sequence[builtins.float]):
        """
        :param builtins.str key: Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        :param Sequence[builtins.float] values: Specifies an array of values to compare to when using a multiple values operator.
               
               > **Note:** A maximum of total number of advanced filter values allowed on event subscription is 25.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.float]:
        """
        Specifies an array of values to compare to when using a multiple values operator.

        > **Note:** A maximum of total number of advanced filter values allowed on event subscription is 25.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class EventSubscriptionAdvancedFilterNumberInRange(dict):
    def __init__(__self__, *,
                 key: builtins.str,
                 values: Sequence[Sequence[builtins.float]]):
        """
        :param builtins.str key: Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        :param Sequence[Sequence[builtins.float]] values: Specifies an array of values to compare to when using a multiple values operator.
               
               > **Note:** A maximum of total number of advanced filter values allowed on event subscription is 25.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Sequence[Sequence[builtins.float]]:
        """
        Specifies an array of values to compare to when using a multiple values operator.

        > **Note:** A maximum of total number of advanced filter values allowed on event subscription is 25.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class EventSubscriptionAdvancedFilterNumberLessThan(dict):
    def __init__(__self__, *,
                 key: builtins.str,
                 value: builtins.float):
        """
        :param builtins.str key: Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> builtins.float:
        return pulumi.get(self, "value")


@pulumi.output_type
class EventSubscriptionAdvancedFilterNumberLessThanOrEqual(dict):
    def __init__(__self__, *,
                 key: builtins.str,
                 value: builtins.float):
        """
        :param builtins.str key: Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> builtins.float:
        return pulumi.get(self, "value")


@pulumi.output_type
class EventSubscriptionAdvancedFilterNumberNotIn(dict):
    def __init__(__self__, *,
                 key: builtins.str,
                 values: Sequence[builtins.float]):
        """
        :param builtins.str key: Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        :param Sequence[builtins.float] values: Specifies an array of values to compare to when using a multiple values operator.
               
               > **Note:** A maximum of total number of advanced filter values allowed on event subscription is 25.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.float]:
        """
        Specifies an array of values to compare to when using a multiple values operator.

        > **Note:** A maximum of total number of advanced filter values allowed on event subscription is 25.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class EventSubscriptionAdvancedFilterNumberNotInRange(dict):
    def __init__(__self__, *,
                 key: builtins.str,
                 values: Sequence[Sequence[builtins.float]]):
        """
        :param builtins.str key: Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        :param Sequence[Sequence[builtins.float]] values: Specifies an array of values to compare to when using a multiple values operator.
               
               > **Note:** A maximum of total number of advanced filter values allowed on event subscription is 25.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Sequence[Sequence[builtins.float]]:
        """
        Specifies an array of values to compare to when using a multiple values operator.

        > **Note:** A maximum of total number of advanced filter values allowed on event subscription is 25.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class EventSubscriptionAdvancedFilterStringBeginsWith(dict):
    def __init__(__self__, *,
                 key: builtins.str,
                 values: Sequence[builtins.str]):
        """
        :param builtins.str key: Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        :param Sequence[builtins.str] values: Specifies an array of values to compare to when using a multiple values operator.
               
               > **Note:** A maximum of total number of advanced filter values allowed on event subscription is 25.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        """
        Specifies an array of values to compare to when using a multiple values operator.

        > **Note:** A maximum of total number of advanced filter values allowed on event subscription is 25.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class EventSubscriptionAdvancedFilterStringContain(dict):
    def __init__(__self__, *,
                 key: builtins.str,
                 values: Sequence[builtins.str]):
        """
        :param builtins.str key: Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        :param Sequence[builtins.str] values: Specifies an array of values to compare to when using a multiple values operator.
               
               > **Note:** A maximum of total number of advanced filter values allowed on event subscription is 25.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        """
        Specifies an array of values to compare to when using a multiple values operator.

        > **Note:** A maximum of total number of advanced filter values allowed on event subscription is 25.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class EventSubscriptionAdvancedFilterStringEndsWith(dict):
    def __init__(__self__, *,
                 key: builtins.str,
                 values: Sequence[builtins.str]):
        """
        :param builtins.str key: Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        :param Sequence[builtins.str] values: Specifies an array of values to compare to when using a multiple values operator.
               
               > **Note:** A maximum of total number of advanced filter values allowed on event subscription is 25.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        """
        Specifies an array of values to compare to when using a multiple values operator.

        > **Note:** A maximum of total number of advanced filter values allowed on event subscription is 25.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class EventSubscriptionAdvancedFilterStringIn(dict):
    def __init__(__self__, *,
                 key: builtins.str,
                 values: Sequence[builtins.str]):
        """
        :param builtins.str key: Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        :param Sequence[builtins.str] values: Specifies an array of values to compare to when using a multiple values operator.
               
               > **Note:** A maximum of total number of advanced filter values allowed on event subscription is 25.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        """
        Specifies an array of values to compare to when using a multiple values operator.

        > **Note:** A maximum of total number of advanced filter values allowed on event subscription is 25.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class EventSubscriptionAdvancedFilterStringNotBeginsWith(dict):
    def __init__(__self__, *,
                 key: builtins.str,
                 values: Sequence[builtins.str]):
        """
        :param builtins.str key: Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        :param Sequence[builtins.str] values: Specifies an array of values to compare to when using a multiple values operator.
               
               > **Note:** A maximum of total number of advanced filter values allowed on event subscription is 25.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        """
        Specifies an array of values to compare to when using a multiple values operator.

        > **Note:** A maximum of total number of advanced filter values allowed on event subscription is 25.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class EventSubscriptionAdvancedFilterStringNotContain(dict):
    def __init__(__self__, *,
                 key: builtins.str,
                 values: Sequence[builtins.str]):
        """
        :param builtins.str key: Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        :param Sequence[builtins.str] values: Specifies an array of values to compare to when using a multiple values operator.
               
               > **Note:** A maximum of total number of advanced filter values allowed on event subscription is 25.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        """
        Specifies an array of values to compare to when using a multiple values operator.

        > **Note:** A maximum of total number of advanced filter values allowed on event subscription is 25.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class EventSubscriptionAdvancedFilterStringNotEndsWith(dict):
    def __init__(__self__, *,
                 key: builtins.str,
                 values: Sequence[builtins.str]):
        """
        :param builtins.str key: Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        :param Sequence[builtins.str] values: Specifies an array of values to compare to when using a multiple values operator.
               
               > **Note:** A maximum of total number of advanced filter values allowed on event subscription is 25.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        """
        Specifies an array of values to compare to when using a multiple values operator.

        > **Note:** A maximum of total number of advanced filter values allowed on event subscription is 25.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class EventSubscriptionAdvancedFilterStringNotIn(dict):
    def __init__(__self__, *,
                 key: builtins.str,
                 values: Sequence[builtins.str]):
        """
        :param builtins.str key: Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        :param Sequence[builtins.str] values: Specifies an array of values to compare to when using a multiple values operator.
               
               > **Note:** A maximum of total number of advanced filter values allowed on event subscription is 25.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        """
        Specifies an array of values to compare to when using a multiple values operator.

        > **Note:** A maximum of total number of advanced filter values allowed on event subscription is 25.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class EventSubscriptionAzureFunctionEndpoint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "functionId":
            suggest = "function_id"
        elif key == "maxEventsPerBatch":
            suggest = "max_events_per_batch"
        elif key == "preferredBatchSizeInKilobytes":
            suggest = "preferred_batch_size_in_kilobytes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventSubscriptionAzureFunctionEndpoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventSubscriptionAzureFunctionEndpoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventSubscriptionAzureFunctionEndpoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 function_id: builtins.str,
                 max_events_per_batch: Optional[builtins.int] = None,
                 preferred_batch_size_in_kilobytes: Optional[builtins.int] = None):
        """
        :param builtins.str function_id: Specifies the ID of the Function where the Event Subscription will receive events. This must be the functions ID in format {function_app.id}/functions/{name}.
        :param builtins.int max_events_per_batch: Maximum number of events per batch.
        :param builtins.int preferred_batch_size_in_kilobytes: Preferred batch size in Kilobytes.
        """
        pulumi.set(__self__, "function_id", function_id)
        if max_events_per_batch is not None:
            pulumi.set(__self__, "max_events_per_batch", max_events_per_batch)
        if preferred_batch_size_in_kilobytes is not None:
            pulumi.set(__self__, "preferred_batch_size_in_kilobytes", preferred_batch_size_in_kilobytes)

    @property
    @pulumi.getter(name="functionId")
    def function_id(self) -> builtins.str:
        """
        Specifies the ID of the Function where the Event Subscription will receive events. This must be the functions ID in format {function_app.id}/functions/{name}.
        """
        return pulumi.get(self, "function_id")

    @property
    @pulumi.getter(name="maxEventsPerBatch")
    def max_events_per_batch(self) -> Optional[builtins.int]:
        """
        Maximum number of events per batch.
        """
        return pulumi.get(self, "max_events_per_batch")

    @property
    @pulumi.getter(name="preferredBatchSizeInKilobytes")
    def preferred_batch_size_in_kilobytes(self) -> Optional[builtins.int]:
        """
        Preferred batch size in Kilobytes.
        """
        return pulumi.get(self, "preferred_batch_size_in_kilobytes")


@pulumi.output_type
class EventSubscriptionDeadLetterIdentity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "userAssignedIdentity":
            suggest = "user_assigned_identity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventSubscriptionDeadLetterIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventSubscriptionDeadLetterIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventSubscriptionDeadLetterIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: builtins.str,
                 user_assigned_identity: Optional[builtins.str] = None):
        """
        :param builtins.str type: Specifies the type of Managed Service Identity that is used for dead lettering. Allowed value is `SystemAssigned`, `UserAssigned`.
        :param builtins.str user_assigned_identity: The user identity associated with the resource.
        """
        pulumi.set(__self__, "type", type)
        if user_assigned_identity is not None:
            pulumi.set(__self__, "user_assigned_identity", user_assigned_identity)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Specifies the type of Managed Service Identity that is used for dead lettering. Allowed value is `SystemAssigned`, `UserAssigned`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="userAssignedIdentity")
    def user_assigned_identity(self) -> Optional[builtins.str]:
        """
        The user identity associated with the resource.
        """
        return pulumi.get(self, "user_assigned_identity")


@pulumi.output_type
class EventSubscriptionDeliveryIdentity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "userAssignedIdentity":
            suggest = "user_assigned_identity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventSubscriptionDeliveryIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventSubscriptionDeliveryIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventSubscriptionDeliveryIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: builtins.str,
                 user_assigned_identity: Optional[builtins.str] = None):
        """
        :param builtins.str type: Specifies the type of Managed Service Identity that is used for event delivery. Allowed value is `SystemAssigned`, `UserAssigned`.
        :param builtins.str user_assigned_identity: The user identity associated with the resource.
        """
        pulumi.set(__self__, "type", type)
        if user_assigned_identity is not None:
            pulumi.set(__self__, "user_assigned_identity", user_assigned_identity)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Specifies the type of Managed Service Identity that is used for event delivery. Allowed value is `SystemAssigned`, `UserAssigned`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="userAssignedIdentity")
    def user_assigned_identity(self) -> Optional[builtins.str]:
        """
        The user identity associated with the resource.
        """
        return pulumi.get(self, "user_assigned_identity")


@pulumi.output_type
class EventSubscriptionDeliveryProperty(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "headerName":
            suggest = "header_name"
        elif key == "sourceField":
            suggest = "source_field"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventSubscriptionDeliveryProperty. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventSubscriptionDeliveryProperty.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventSubscriptionDeliveryProperty.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 header_name: builtins.str,
                 type: builtins.str,
                 secret: Optional[builtins.bool] = None,
                 source_field: Optional[builtins.str] = None,
                 value: Optional[builtins.str] = None):
        """
        :param builtins.str header_name: The name of the header to send on to the destination
        :param builtins.str type: Either `Static` or `Dynamic`
        :param builtins.bool secret: True if the `value` is a secret and should be protected, otherwise false. If True, then this value won't be returned from Azure API calls
        :param builtins.str source_field: If the `type` is `Dynamic`, then provide the payload field to be used as the value. Valid source fields differ by subscription type.
        :param builtins.str value: If the `type` is `Static`, then provide the value to use
        """
        pulumi.set(__self__, "header_name", header_name)
        pulumi.set(__self__, "type", type)
        if secret is not None:
            pulumi.set(__self__, "secret", secret)
        if source_field is not None:
            pulumi.set(__self__, "source_field", source_field)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="headerName")
    def header_name(self) -> builtins.str:
        """
        The name of the header to send on to the destination
        """
        return pulumi.get(self, "header_name")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Either `Static` or `Dynamic`
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def secret(self) -> Optional[builtins.bool]:
        """
        True if the `value` is a secret and should be protected, otherwise false. If True, then this value won't be returned from Azure API calls
        """
        return pulumi.get(self, "secret")

    @property
    @pulumi.getter(name="sourceField")
    def source_field(self) -> Optional[builtins.str]:
        """
        If the `type` is `Dynamic`, then provide the payload field to be used as the value. Valid source fields differ by subscription type.
        """
        return pulumi.get(self, "source_field")

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.str]:
        """
        If the `type` is `Static`, then provide the value to use
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class EventSubscriptionRetryPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "eventTimeToLive":
            suggest = "event_time_to_live"
        elif key == "maxDeliveryAttempts":
            suggest = "max_delivery_attempts"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventSubscriptionRetryPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventSubscriptionRetryPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventSubscriptionRetryPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 event_time_to_live: builtins.int,
                 max_delivery_attempts: builtins.int):
        """
        :param builtins.int event_time_to_live: Specifies the time to live (in minutes) for events. Supported range is `1` to `1440`. See [official documentation](https://docs.microsoft.com/azure/event-grid/manage-event-delivery#set-retry-policy) for more details.
        :param builtins.int max_delivery_attempts: Specifies the maximum number of delivery retry attempts for events.
        """
        pulumi.set(__self__, "event_time_to_live", event_time_to_live)
        pulumi.set(__self__, "max_delivery_attempts", max_delivery_attempts)

    @property
    @pulumi.getter(name="eventTimeToLive")
    def event_time_to_live(self) -> builtins.int:
        """
        Specifies the time to live (in minutes) for events. Supported range is `1` to `1440`. See [official documentation](https://docs.microsoft.com/azure/event-grid/manage-event-delivery#set-retry-policy) for more details.
        """
        return pulumi.get(self, "event_time_to_live")

    @property
    @pulumi.getter(name="maxDeliveryAttempts")
    def max_delivery_attempts(self) -> builtins.int:
        """
        Specifies the maximum number of delivery retry attempts for events.
        """
        return pulumi.get(self, "max_delivery_attempts")


@pulumi.output_type
class EventSubscriptionStorageBlobDeadLetterDestination(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storageAccountId":
            suggest = "storage_account_id"
        elif key == "storageBlobContainerName":
            suggest = "storage_blob_container_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventSubscriptionStorageBlobDeadLetterDestination. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventSubscriptionStorageBlobDeadLetterDestination.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventSubscriptionStorageBlobDeadLetterDestination.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 storage_account_id: builtins.str,
                 storage_blob_container_name: builtins.str):
        """
        :param builtins.str storage_account_id: Specifies the id of the storage account id where the storage blob is located.
        :param builtins.str storage_blob_container_name: Specifies the name of the Storage blob container that is the destination of the deadletter events.
        """
        pulumi.set(__self__, "storage_account_id", storage_account_id)
        pulumi.set(__self__, "storage_blob_container_name", storage_blob_container_name)

    @property
    @pulumi.getter(name="storageAccountId")
    def storage_account_id(self) -> builtins.str:
        """
        Specifies the id of the storage account id where the storage blob is located.
        """
        return pulumi.get(self, "storage_account_id")

    @property
    @pulumi.getter(name="storageBlobContainerName")
    def storage_blob_container_name(self) -> builtins.str:
        """
        Specifies the name of the Storage blob container that is the destination of the deadletter events.
        """
        return pulumi.get(self, "storage_blob_container_name")


@pulumi.output_type
class EventSubscriptionStorageQueueEndpoint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "queueName":
            suggest = "queue_name"
        elif key == "storageAccountId":
            suggest = "storage_account_id"
        elif key == "queueMessageTimeToLiveInSeconds":
            suggest = "queue_message_time_to_live_in_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventSubscriptionStorageQueueEndpoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventSubscriptionStorageQueueEndpoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventSubscriptionStorageQueueEndpoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 queue_name: builtins.str,
                 storage_account_id: builtins.str,
                 queue_message_time_to_live_in_seconds: Optional[builtins.int] = None):
        """
        :param builtins.str queue_name: Specifies the name of the storage queue where the Event Subscription will receive events.
        :param builtins.str storage_account_id: Specifies the id of the storage account id where the storage queue is located.
        :param builtins.int queue_message_time_to_live_in_seconds: Storage queue message time to live in seconds.
        """
        pulumi.set(__self__, "queue_name", queue_name)
        pulumi.set(__self__, "storage_account_id", storage_account_id)
        if queue_message_time_to_live_in_seconds is not None:
            pulumi.set(__self__, "queue_message_time_to_live_in_seconds", queue_message_time_to_live_in_seconds)

    @property
    @pulumi.getter(name="queueName")
    def queue_name(self) -> builtins.str:
        """
        Specifies the name of the storage queue where the Event Subscription will receive events.
        """
        return pulumi.get(self, "queue_name")

    @property
    @pulumi.getter(name="storageAccountId")
    def storage_account_id(self) -> builtins.str:
        """
        Specifies the id of the storage account id where the storage queue is located.
        """
        return pulumi.get(self, "storage_account_id")

    @property
    @pulumi.getter(name="queueMessageTimeToLiveInSeconds")
    def queue_message_time_to_live_in_seconds(self) -> Optional[builtins.int]:
        """
        Storage queue message time to live in seconds.
        """
        return pulumi.get(self, "queue_message_time_to_live_in_seconds")


@pulumi.output_type
class EventSubscriptionSubjectFilter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "caseSensitive":
            suggest = "case_sensitive"
        elif key == "subjectBeginsWith":
            suggest = "subject_begins_with"
        elif key == "subjectEndsWith":
            suggest = "subject_ends_with"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventSubscriptionSubjectFilter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventSubscriptionSubjectFilter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventSubscriptionSubjectFilter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 case_sensitive: Optional[builtins.bool] = None,
                 subject_begins_with: Optional[builtins.str] = None,
                 subject_ends_with: Optional[builtins.str] = None):
        """
        :param builtins.bool case_sensitive: Specifies if `subject_begins_with` and `subject_ends_with` case sensitive. This value
        :param builtins.str subject_begins_with: A string to filter events for an event subscription based on a resource path prefix.
        :param builtins.str subject_ends_with: A string to filter events for an event subscription based on a resource path suffix.
        """
        if case_sensitive is not None:
            pulumi.set(__self__, "case_sensitive", case_sensitive)
        if subject_begins_with is not None:
            pulumi.set(__self__, "subject_begins_with", subject_begins_with)
        if subject_ends_with is not None:
            pulumi.set(__self__, "subject_ends_with", subject_ends_with)

    @property
    @pulumi.getter(name="caseSensitive")
    def case_sensitive(self) -> Optional[builtins.bool]:
        """
        Specifies if `subject_begins_with` and `subject_ends_with` case sensitive. This value
        """
        return pulumi.get(self, "case_sensitive")

    @property
    @pulumi.getter(name="subjectBeginsWith")
    def subject_begins_with(self) -> Optional[builtins.str]:
        """
        A string to filter events for an event subscription based on a resource path prefix.
        """
        return pulumi.get(self, "subject_begins_with")

    @property
    @pulumi.getter(name="subjectEndsWith")
    def subject_ends_with(self) -> Optional[builtins.str]:
        """
        A string to filter events for an event subscription based on a resource path suffix.
        """
        return pulumi.get(self, "subject_ends_with")


@pulumi.output_type
class EventSubscriptionWebhookEndpoint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "activeDirectoryAppIdOrUri":
            suggest = "active_directory_app_id_or_uri"
        elif key == "activeDirectoryTenantId":
            suggest = "active_directory_tenant_id"
        elif key == "baseUrl":
            suggest = "base_url"
        elif key == "maxEventsPerBatch":
            suggest = "max_events_per_batch"
        elif key == "preferredBatchSizeInKilobytes":
            suggest = "preferred_batch_size_in_kilobytes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventSubscriptionWebhookEndpoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventSubscriptionWebhookEndpoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventSubscriptionWebhookEndpoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 url: builtins.str,
                 active_directory_app_id_or_uri: Optional[builtins.str] = None,
                 active_directory_tenant_id: Optional[builtins.str] = None,
                 base_url: Optional[builtins.str] = None,
                 max_events_per_batch: Optional[builtins.int] = None,
                 preferred_batch_size_in_kilobytes: Optional[builtins.int] = None):
        """
        :param builtins.str url: Specifies the url of the webhook where the Event Subscription will receive events.
        :param builtins.str active_directory_app_id_or_uri: The Azure Active Directory Application ID or URI to get the access token that will be included as the bearer token in delivery requests.
        :param builtins.str active_directory_tenant_id: The Azure Active Directory Tenant ID to get the access token that will be included as the bearer token in delivery requests.
        :param builtins.str base_url: The base url of the webhook where the Event Subscription will receive events.
        :param builtins.int max_events_per_batch: Maximum number of events per batch.
        :param builtins.int preferred_batch_size_in_kilobytes: Preferred batch size in Kilobytes.
        """
        pulumi.set(__self__, "url", url)
        if active_directory_app_id_or_uri is not None:
            pulumi.set(__self__, "active_directory_app_id_or_uri", active_directory_app_id_or_uri)
        if active_directory_tenant_id is not None:
            pulumi.set(__self__, "active_directory_tenant_id", active_directory_tenant_id)
        if base_url is not None:
            pulumi.set(__self__, "base_url", base_url)
        if max_events_per_batch is not None:
            pulumi.set(__self__, "max_events_per_batch", max_events_per_batch)
        if preferred_batch_size_in_kilobytes is not None:
            pulumi.set(__self__, "preferred_batch_size_in_kilobytes", preferred_batch_size_in_kilobytes)

    @property
    @pulumi.getter
    def url(self) -> builtins.str:
        """
        Specifies the url of the webhook where the Event Subscription will receive events.
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter(name="activeDirectoryAppIdOrUri")
    def active_directory_app_id_or_uri(self) -> Optional[builtins.str]:
        """
        The Azure Active Directory Application ID or URI to get the access token that will be included as the bearer token in delivery requests.
        """
        return pulumi.get(self, "active_directory_app_id_or_uri")

    @property
    @pulumi.getter(name="activeDirectoryTenantId")
    def active_directory_tenant_id(self) -> Optional[builtins.str]:
        """
        The Azure Active Directory Tenant ID to get the access token that will be included as the bearer token in delivery requests.
        """
        return pulumi.get(self, "active_directory_tenant_id")

    @property
    @pulumi.getter(name="baseUrl")
    def base_url(self) -> Optional[builtins.str]:
        """
        The base url of the webhook where the Event Subscription will receive events.
        """
        return pulumi.get(self, "base_url")

    @property
    @pulumi.getter(name="maxEventsPerBatch")
    def max_events_per_batch(self) -> Optional[builtins.int]:
        """
        Maximum number of events per batch.
        """
        return pulumi.get(self, "max_events_per_batch")

    @property
    @pulumi.getter(name="preferredBatchSizeInKilobytes")
    def preferred_batch_size_in_kilobytes(self) -> Optional[builtins.int]:
        """
        Preferred batch size in Kilobytes.
        """
        return pulumi.get(self, "preferred_batch_size_in_kilobytes")


@pulumi.output_type
class NamespaceIdentity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "identityIds":
            suggest = "identity_ids"
        elif key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NamespaceIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NamespaceIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NamespaceIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: builtins.str,
                 identity_ids: Optional[Sequence[builtins.str]] = None,
                 principal_id: Optional[builtins.str] = None,
                 tenant_id: Optional[builtins.str] = None):
        """
        :param builtins.str type: Specifies the type of Managed Service Identity that should be configured on this Event Grid Namespace. Possible values are `SystemAssigned`, `UserAssigned`.
        :param Sequence[builtins.str] identity_ids: Specifies a list of User Assigned Managed Identity IDs to be assigned to this Event Grid Namespace.
               
               > **Note:** This is required when `type` is set to `UserAssigned`
        """
        pulumi.set(__self__, "type", type)
        if identity_ids is not None:
            pulumi.set(__self__, "identity_ids", identity_ids)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Specifies the type of Managed Service Identity that should be configured on this Event Grid Namespace. Possible values are `SystemAssigned`, `UserAssigned`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        Specifies a list of User Assigned Managed Identity IDs to be assigned to this Event Grid Namespace.

        > **Note:** This is required when `type` is set to `UserAssigned`
        """
        return pulumi.get(self, "identity_ids")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class NamespaceInboundIpRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipMask":
            suggest = "ip_mask"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NamespaceInboundIpRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NamespaceInboundIpRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NamespaceInboundIpRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_mask: builtins.str,
                 action: Optional[builtins.str] = None):
        """
        :param builtins.str ip_mask: The IP mask (CIDR) to match on.
        :param builtins.str action: The action to take when the rule is matched. Possible values are `Allow`. Defaults to `Allow`.
        """
        pulumi.set(__self__, "ip_mask", ip_mask)
        if action is not None:
            pulumi.set(__self__, "action", action)

    @property
    @pulumi.getter(name="ipMask")
    def ip_mask(self) -> builtins.str:
        """
        The IP mask (CIDR) to match on.
        """
        return pulumi.get(self, "ip_mask")

    @property
    @pulumi.getter
    def action(self) -> Optional[builtins.str]:
        """
        The action to take when the rule is matched. Possible values are `Allow`. Defaults to `Allow`.
        """
        return pulumi.get(self, "action")


@pulumi.output_type
class NamespaceTopicSpacesConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "alternativeAuthenticationNameSources":
            suggest = "alternative_authentication_name_sources"
        elif key == "dynamicRoutingEnrichments":
            suggest = "dynamic_routing_enrichments"
        elif key == "maximumClientSessionsPerAuthenticationName":
            suggest = "maximum_client_sessions_per_authentication_name"
        elif key == "maximumSessionExpiryInHours":
            suggest = "maximum_session_expiry_in_hours"
        elif key == "routeTopicId":
            suggest = "route_topic_id"
        elif key == "staticRoutingEnrichments":
            suggest = "static_routing_enrichments"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NamespaceTopicSpacesConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NamespaceTopicSpacesConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NamespaceTopicSpacesConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 alternative_authentication_name_sources: Optional[Sequence[builtins.str]] = None,
                 dynamic_routing_enrichments: Optional[Sequence['outputs.NamespaceTopicSpacesConfigurationDynamicRoutingEnrichment']] = None,
                 maximum_client_sessions_per_authentication_name: Optional[builtins.int] = None,
                 maximum_session_expiry_in_hours: Optional[builtins.int] = None,
                 route_topic_id: Optional[builtins.str] = None,
                 static_routing_enrichments: Optional[Sequence['outputs.NamespaceTopicSpacesConfigurationStaticRoutingEnrichment']] = None):
        """
        :param Sequence[builtins.str] alternative_authentication_name_sources: Specifies a list of alternative sources for the client authentication name from the client certificate. Possible values are `ClientCertificateDns`, `ClientCertificateEmail`, `ClientCertificateIp`, `ClientCertificateSubject` and `ClientCertificateUri`.
        :param Sequence['NamespaceTopicSpacesConfigurationDynamicRoutingEnrichmentArgs'] dynamic_routing_enrichments: One or more `dynamic_routing_enrichment` blocks as defined below.
        :param builtins.int maximum_client_sessions_per_authentication_name: Specifies the maximum number of client sessions per authentication name. Valid values can be between `1` and `100`.
        :param builtins.int maximum_session_expiry_in_hours: Specifies the maximum session expiry interval allowed for all MQTT clients connecting to the Event Grid namespace. Valid values can be between `1` and `8`.
        :param builtins.str route_topic_id: Specifies the Event Grid topic resource ID to route messages to.
        :param Sequence['NamespaceTopicSpacesConfigurationStaticRoutingEnrichmentArgs'] static_routing_enrichments: One or more `static_routing_enrichment` blocks as defined below.
        """
        if alternative_authentication_name_sources is not None:
            pulumi.set(__self__, "alternative_authentication_name_sources", alternative_authentication_name_sources)
        if dynamic_routing_enrichments is not None:
            pulumi.set(__self__, "dynamic_routing_enrichments", dynamic_routing_enrichments)
        if maximum_client_sessions_per_authentication_name is not None:
            pulumi.set(__self__, "maximum_client_sessions_per_authentication_name", maximum_client_sessions_per_authentication_name)
        if maximum_session_expiry_in_hours is not None:
            pulumi.set(__self__, "maximum_session_expiry_in_hours", maximum_session_expiry_in_hours)
        if route_topic_id is not None:
            pulumi.set(__self__, "route_topic_id", route_topic_id)
        if static_routing_enrichments is not None:
            pulumi.set(__self__, "static_routing_enrichments", static_routing_enrichments)

    @property
    @pulumi.getter(name="alternativeAuthenticationNameSources")
    def alternative_authentication_name_sources(self) -> Optional[Sequence[builtins.str]]:
        """
        Specifies a list of alternative sources for the client authentication name from the client certificate. Possible values are `ClientCertificateDns`, `ClientCertificateEmail`, `ClientCertificateIp`, `ClientCertificateSubject` and `ClientCertificateUri`.
        """
        return pulumi.get(self, "alternative_authentication_name_sources")

    @property
    @pulumi.getter(name="dynamicRoutingEnrichments")
    def dynamic_routing_enrichments(self) -> Optional[Sequence['outputs.NamespaceTopicSpacesConfigurationDynamicRoutingEnrichment']]:
        """
        One or more `dynamic_routing_enrichment` blocks as defined below.
        """
        return pulumi.get(self, "dynamic_routing_enrichments")

    @property
    @pulumi.getter(name="maximumClientSessionsPerAuthenticationName")
    def maximum_client_sessions_per_authentication_name(self) -> Optional[builtins.int]:
        """
        Specifies the maximum number of client sessions per authentication name. Valid values can be between `1` and `100`.
        """
        return pulumi.get(self, "maximum_client_sessions_per_authentication_name")

    @property
    @pulumi.getter(name="maximumSessionExpiryInHours")
    def maximum_session_expiry_in_hours(self) -> Optional[builtins.int]:
        """
        Specifies the maximum session expiry interval allowed for all MQTT clients connecting to the Event Grid namespace. Valid values can be between `1` and `8`.
        """
        return pulumi.get(self, "maximum_session_expiry_in_hours")

    @property
    @pulumi.getter(name="routeTopicId")
    def route_topic_id(self) -> Optional[builtins.str]:
        """
        Specifies the Event Grid topic resource ID to route messages to.
        """
        return pulumi.get(self, "route_topic_id")

    @property
    @pulumi.getter(name="staticRoutingEnrichments")
    def static_routing_enrichments(self) -> Optional[Sequence['outputs.NamespaceTopicSpacesConfigurationStaticRoutingEnrichment']]:
        """
        One or more `static_routing_enrichment` blocks as defined below.
        """
        return pulumi.get(self, "static_routing_enrichments")


@pulumi.output_type
class NamespaceTopicSpacesConfigurationDynamicRoutingEnrichment(dict):
    def __init__(__self__, *,
                 key: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str key: The enrichment key.
        :param builtins.str value: The enrichment value.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        The enrichment key.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The enrichment value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class NamespaceTopicSpacesConfigurationStaticRoutingEnrichment(dict):
    def __init__(__self__, *,
                 key: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str key: The enrichment key.
        :param builtins.str value: The enrichment value.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        The enrichment key.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The enrichment value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class PartnerConfigurationPartnerAuthorization(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "partnerName":
            suggest = "partner_name"
        elif key == "partnerRegistrationId":
            suggest = "partner_registration_id"
        elif key == "authorizationExpirationTimeInUtc":
            suggest = "authorization_expiration_time_in_utc"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PartnerConfigurationPartnerAuthorization. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PartnerConfigurationPartnerAuthorization.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PartnerConfigurationPartnerAuthorization.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 partner_name: builtins.str,
                 partner_registration_id: builtins.str,
                 authorization_expiration_time_in_utc: Optional[builtins.str] = None):
        """
        :param builtins.str partner_name: The partner name.
        :param builtins.str partner_registration_id: The immutable id of the corresponding partner registration.
        :param builtins.str authorization_expiration_time_in_utc: Expiration time of the partner authorization. Value should be in RFC 3339 format in UTC time zone, for example: "2025-02-04T00:00:00Z".
               
               > **Note:** If the time from `authorization_expiration_time_in_utc` expires, any request from this partner to create, update or delete resources in the subscriber's context will fail. If not specified, the authorization will expire after `default_maximum_expiration_time_in_days`.
        """
        pulumi.set(__self__, "partner_name", partner_name)
        pulumi.set(__self__, "partner_registration_id", partner_registration_id)
        if authorization_expiration_time_in_utc is not None:
            pulumi.set(__self__, "authorization_expiration_time_in_utc", authorization_expiration_time_in_utc)

    @property
    @pulumi.getter(name="partnerName")
    def partner_name(self) -> builtins.str:
        """
        The partner name.
        """
        return pulumi.get(self, "partner_name")

    @property
    @pulumi.getter(name="partnerRegistrationId")
    def partner_registration_id(self) -> builtins.str:
        """
        The immutable id of the corresponding partner registration.
        """
        return pulumi.get(self, "partner_registration_id")

    @property
    @pulumi.getter(name="authorizationExpirationTimeInUtc")
    def authorization_expiration_time_in_utc(self) -> Optional[builtins.str]:
        """
        Expiration time of the partner authorization. Value should be in RFC 3339 format in UTC time zone, for example: "2025-02-04T00:00:00Z".

        > **Note:** If the time from `authorization_expiration_time_in_utc` expires, any request from this partner to create, update or delete resources in the subscriber's context will fail. If not specified, the authorization will expire after `default_maximum_expiration_time_in_days`.
        """
        return pulumi.get(self, "authorization_expiration_time_in_utc")


@pulumi.output_type
class SystemTopicEventSubscriptionAdvancedFilter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "boolEquals":
            suggest = "bool_equals"
        elif key == "isNotNulls":
            suggest = "is_not_nulls"
        elif key == "isNullOrUndefineds":
            suggest = "is_null_or_undefineds"
        elif key == "numberGreaterThanOrEquals":
            suggest = "number_greater_than_or_equals"
        elif key == "numberGreaterThans":
            suggest = "number_greater_thans"
        elif key == "numberInRanges":
            suggest = "number_in_ranges"
        elif key == "numberIns":
            suggest = "number_ins"
        elif key == "numberLessThanOrEquals":
            suggest = "number_less_than_or_equals"
        elif key == "numberLessThans":
            suggest = "number_less_thans"
        elif key == "numberNotInRanges":
            suggest = "number_not_in_ranges"
        elif key == "numberNotIns":
            suggest = "number_not_ins"
        elif key == "stringBeginsWiths":
            suggest = "string_begins_withs"
        elif key == "stringContains":
            suggest = "string_contains"
        elif key == "stringEndsWiths":
            suggest = "string_ends_withs"
        elif key == "stringIns":
            suggest = "string_ins"
        elif key == "stringNotBeginsWiths":
            suggest = "string_not_begins_withs"
        elif key == "stringNotContains":
            suggest = "string_not_contains"
        elif key == "stringNotEndsWiths":
            suggest = "string_not_ends_withs"
        elif key == "stringNotIns":
            suggest = "string_not_ins"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SystemTopicEventSubscriptionAdvancedFilter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SystemTopicEventSubscriptionAdvancedFilter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SystemTopicEventSubscriptionAdvancedFilter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bool_equals: Optional[Sequence['outputs.SystemTopicEventSubscriptionAdvancedFilterBoolEqual']] = None,
                 is_not_nulls: Optional[Sequence['outputs.SystemTopicEventSubscriptionAdvancedFilterIsNotNull']] = None,
                 is_null_or_undefineds: Optional[Sequence['outputs.SystemTopicEventSubscriptionAdvancedFilterIsNullOrUndefined']] = None,
                 number_greater_than_or_equals: Optional[Sequence['outputs.SystemTopicEventSubscriptionAdvancedFilterNumberGreaterThanOrEqual']] = None,
                 number_greater_thans: Optional[Sequence['outputs.SystemTopicEventSubscriptionAdvancedFilterNumberGreaterThan']] = None,
                 number_in_ranges: Optional[Sequence['outputs.SystemTopicEventSubscriptionAdvancedFilterNumberInRange']] = None,
                 number_ins: Optional[Sequence['outputs.SystemTopicEventSubscriptionAdvancedFilterNumberIn']] = None,
                 number_less_than_or_equals: Optional[Sequence['outputs.SystemTopicEventSubscriptionAdvancedFilterNumberLessThanOrEqual']] = None,
                 number_less_thans: Optional[Sequence['outputs.SystemTopicEventSubscriptionAdvancedFilterNumberLessThan']] = None,
                 number_not_in_ranges: Optional[Sequence['outputs.SystemTopicEventSubscriptionAdvancedFilterNumberNotInRange']] = None,
                 number_not_ins: Optional[Sequence['outputs.SystemTopicEventSubscriptionAdvancedFilterNumberNotIn']] = None,
                 string_begins_withs: Optional[Sequence['outputs.SystemTopicEventSubscriptionAdvancedFilterStringBeginsWith']] = None,
                 string_contains: Optional[Sequence['outputs.SystemTopicEventSubscriptionAdvancedFilterStringContain']] = None,
                 string_ends_withs: Optional[Sequence['outputs.SystemTopicEventSubscriptionAdvancedFilterStringEndsWith']] = None,
                 string_ins: Optional[Sequence['outputs.SystemTopicEventSubscriptionAdvancedFilterStringIn']] = None,
                 string_not_begins_withs: Optional[Sequence['outputs.SystemTopicEventSubscriptionAdvancedFilterStringNotBeginsWith']] = None,
                 string_not_contains: Optional[Sequence['outputs.SystemTopicEventSubscriptionAdvancedFilterStringNotContain']] = None,
                 string_not_ends_withs: Optional[Sequence['outputs.SystemTopicEventSubscriptionAdvancedFilterStringNotEndsWith']] = None,
                 string_not_ins: Optional[Sequence['outputs.SystemTopicEventSubscriptionAdvancedFilterStringNotIn']] = None):
        """
        :param Sequence['SystemTopicEventSubscriptionAdvancedFilterBoolEqualArgs'] bool_equals: Compares a value of an event using a single boolean value.
        :param Sequence['SystemTopicEventSubscriptionAdvancedFilterIsNotNullArgs'] is_not_nulls: Evaluates if a value of an event isn't NULL or undefined.
        :param Sequence['SystemTopicEventSubscriptionAdvancedFilterIsNullOrUndefinedArgs'] is_null_or_undefineds: Evaluates if a value of an event is NULL or undefined.
               
               Each nested block consists of a key and a value(s) element.
        :param Sequence['SystemTopicEventSubscriptionAdvancedFilterNumberGreaterThanOrEqualArgs'] number_greater_than_or_equals: Compares a value of an event using a single floating point number.
        :param Sequence['SystemTopicEventSubscriptionAdvancedFilterNumberGreaterThanArgs'] number_greater_thans: Compares a value of an event using a single floating point number.
        :param Sequence['SystemTopicEventSubscriptionAdvancedFilterNumberInRangeArgs'] number_in_ranges: Compares a value of an event using multiple floating point number ranges.
        :param Sequence['SystemTopicEventSubscriptionAdvancedFilterNumberInArgs'] number_ins: Compares a value of an event using multiple floating point numbers.
        :param Sequence['SystemTopicEventSubscriptionAdvancedFilterNumberLessThanOrEqualArgs'] number_less_than_or_equals: Compares a value of an event using a single floating point number.
        :param Sequence['SystemTopicEventSubscriptionAdvancedFilterNumberLessThanArgs'] number_less_thans: Compares a value of an event using a single floating point number.
        :param Sequence['SystemTopicEventSubscriptionAdvancedFilterNumberNotInRangeArgs'] number_not_in_ranges: Compares a value of an event using multiple floating point number ranges.
        :param Sequence['SystemTopicEventSubscriptionAdvancedFilterNumberNotInArgs'] number_not_ins: Compares a value of an event using multiple floating point numbers.
        :param Sequence['SystemTopicEventSubscriptionAdvancedFilterStringBeginsWithArgs'] string_begins_withs: Compares a value of an event using multiple string values.
        :param Sequence['SystemTopicEventSubscriptionAdvancedFilterStringContainArgs'] string_contains: Compares a value of an event using multiple string values.
        :param Sequence['SystemTopicEventSubscriptionAdvancedFilterStringEndsWithArgs'] string_ends_withs: Compares a value of an event using multiple string values.
        :param Sequence['SystemTopicEventSubscriptionAdvancedFilterStringInArgs'] string_ins: Compares a value of an event using multiple string values.
        :param Sequence['SystemTopicEventSubscriptionAdvancedFilterStringNotBeginsWithArgs'] string_not_begins_withs: Compares a value of an event using multiple string values.
        :param Sequence['SystemTopicEventSubscriptionAdvancedFilterStringNotContainArgs'] string_not_contains: Compares a value of an event using multiple string values.
        :param Sequence['SystemTopicEventSubscriptionAdvancedFilterStringNotEndsWithArgs'] string_not_ends_withs: Compares a value of an event using multiple string values.
        :param Sequence['SystemTopicEventSubscriptionAdvancedFilterStringNotInArgs'] string_not_ins: Compares a value of an event using multiple string values.
        """
        if bool_equals is not None:
            pulumi.set(__self__, "bool_equals", bool_equals)
        if is_not_nulls is not None:
            pulumi.set(__self__, "is_not_nulls", is_not_nulls)
        if is_null_or_undefineds is not None:
            pulumi.set(__self__, "is_null_or_undefineds", is_null_or_undefineds)
        if number_greater_than_or_equals is not None:
            pulumi.set(__self__, "number_greater_than_or_equals", number_greater_than_or_equals)
        if number_greater_thans is not None:
            pulumi.set(__self__, "number_greater_thans", number_greater_thans)
        if number_in_ranges is not None:
            pulumi.set(__self__, "number_in_ranges", number_in_ranges)
        if number_ins is not None:
            pulumi.set(__self__, "number_ins", number_ins)
        if number_less_than_or_equals is not None:
            pulumi.set(__self__, "number_less_than_or_equals", number_less_than_or_equals)
        if number_less_thans is not None:
            pulumi.set(__self__, "number_less_thans", number_less_thans)
        if number_not_in_ranges is not None:
            pulumi.set(__self__, "number_not_in_ranges", number_not_in_ranges)
        if number_not_ins is not None:
            pulumi.set(__self__, "number_not_ins", number_not_ins)
        if string_begins_withs is not None:
            pulumi.set(__self__, "string_begins_withs", string_begins_withs)
        if string_contains is not None:
            pulumi.set(__self__, "string_contains", string_contains)
        if string_ends_withs is not None:
            pulumi.set(__self__, "string_ends_withs", string_ends_withs)
        if string_ins is not None:
            pulumi.set(__self__, "string_ins", string_ins)
        if string_not_begins_withs is not None:
            pulumi.set(__self__, "string_not_begins_withs", string_not_begins_withs)
        if string_not_contains is not None:
            pulumi.set(__self__, "string_not_contains", string_not_contains)
        if string_not_ends_withs is not None:
            pulumi.set(__self__, "string_not_ends_withs", string_not_ends_withs)
        if string_not_ins is not None:
            pulumi.set(__self__, "string_not_ins", string_not_ins)

    @property
    @pulumi.getter(name="boolEquals")
    def bool_equals(self) -> Optional[Sequence['outputs.SystemTopicEventSubscriptionAdvancedFilterBoolEqual']]:
        """
        Compares a value of an event using a single boolean value.
        """
        return pulumi.get(self, "bool_equals")

    @property
    @pulumi.getter(name="isNotNulls")
    def is_not_nulls(self) -> Optional[Sequence['outputs.SystemTopicEventSubscriptionAdvancedFilterIsNotNull']]:
        """
        Evaluates if a value of an event isn't NULL or undefined.
        """
        return pulumi.get(self, "is_not_nulls")

    @property
    @pulumi.getter(name="isNullOrUndefineds")
    def is_null_or_undefineds(self) -> Optional[Sequence['outputs.SystemTopicEventSubscriptionAdvancedFilterIsNullOrUndefined']]:
        """
        Evaluates if a value of an event is NULL or undefined.

        Each nested block consists of a key and a value(s) element.
        """
        return pulumi.get(self, "is_null_or_undefineds")

    @property
    @pulumi.getter(name="numberGreaterThanOrEquals")
    def number_greater_than_or_equals(self) -> Optional[Sequence['outputs.SystemTopicEventSubscriptionAdvancedFilterNumberGreaterThanOrEqual']]:
        """
        Compares a value of an event using a single floating point number.
        """
        return pulumi.get(self, "number_greater_than_or_equals")

    @property
    @pulumi.getter(name="numberGreaterThans")
    def number_greater_thans(self) -> Optional[Sequence['outputs.SystemTopicEventSubscriptionAdvancedFilterNumberGreaterThan']]:
        """
        Compares a value of an event using a single floating point number.
        """
        return pulumi.get(self, "number_greater_thans")

    @property
    @pulumi.getter(name="numberInRanges")
    def number_in_ranges(self) -> Optional[Sequence['outputs.SystemTopicEventSubscriptionAdvancedFilterNumberInRange']]:
        """
        Compares a value of an event using multiple floating point number ranges.
        """
        return pulumi.get(self, "number_in_ranges")

    @property
    @pulumi.getter(name="numberIns")
    def number_ins(self) -> Optional[Sequence['outputs.SystemTopicEventSubscriptionAdvancedFilterNumberIn']]:
        """
        Compares a value of an event using multiple floating point numbers.
        """
        return pulumi.get(self, "number_ins")

    @property
    @pulumi.getter(name="numberLessThanOrEquals")
    def number_less_than_or_equals(self) -> Optional[Sequence['outputs.SystemTopicEventSubscriptionAdvancedFilterNumberLessThanOrEqual']]:
        """
        Compares a value of an event using a single floating point number.
        """
        return pulumi.get(self, "number_less_than_or_equals")

    @property
    @pulumi.getter(name="numberLessThans")
    def number_less_thans(self) -> Optional[Sequence['outputs.SystemTopicEventSubscriptionAdvancedFilterNumberLessThan']]:
        """
        Compares a value of an event using a single floating point number.
        """
        return pulumi.get(self, "number_less_thans")

    @property
    @pulumi.getter(name="numberNotInRanges")
    def number_not_in_ranges(self) -> Optional[Sequence['outputs.SystemTopicEventSubscriptionAdvancedFilterNumberNotInRange']]:
        """
        Compares a value of an event using multiple floating point number ranges.
        """
        return pulumi.get(self, "number_not_in_ranges")

    @property
    @pulumi.getter(name="numberNotIns")
    def number_not_ins(self) -> Optional[Sequence['outputs.SystemTopicEventSubscriptionAdvancedFilterNumberNotIn']]:
        """
        Compares a value of an event using multiple floating point numbers.
        """
        return pulumi.get(self, "number_not_ins")

    @property
    @pulumi.getter(name="stringBeginsWiths")
    def string_begins_withs(self) -> Optional[Sequence['outputs.SystemTopicEventSubscriptionAdvancedFilterStringBeginsWith']]:
        """
        Compares a value of an event using multiple string values.
        """
        return pulumi.get(self, "string_begins_withs")

    @property
    @pulumi.getter(name="stringContains")
    def string_contains(self) -> Optional[Sequence['outputs.SystemTopicEventSubscriptionAdvancedFilterStringContain']]:
        """
        Compares a value of an event using multiple string values.
        """
        return pulumi.get(self, "string_contains")

    @property
    @pulumi.getter(name="stringEndsWiths")
    def string_ends_withs(self) -> Optional[Sequence['outputs.SystemTopicEventSubscriptionAdvancedFilterStringEndsWith']]:
        """
        Compares a value of an event using multiple string values.
        """
        return pulumi.get(self, "string_ends_withs")

    @property
    @pulumi.getter(name="stringIns")
    def string_ins(self) -> Optional[Sequence['outputs.SystemTopicEventSubscriptionAdvancedFilterStringIn']]:
        """
        Compares a value of an event using multiple string values.
        """
        return pulumi.get(self, "string_ins")

    @property
    @pulumi.getter(name="stringNotBeginsWiths")
    def string_not_begins_withs(self) -> Optional[Sequence['outputs.SystemTopicEventSubscriptionAdvancedFilterStringNotBeginsWith']]:
        """
        Compares a value of an event using multiple string values.
        """
        return pulumi.get(self, "string_not_begins_withs")

    @property
    @pulumi.getter(name="stringNotContains")
    def string_not_contains(self) -> Optional[Sequence['outputs.SystemTopicEventSubscriptionAdvancedFilterStringNotContain']]:
        """
        Compares a value of an event using multiple string values.
        """
        return pulumi.get(self, "string_not_contains")

    @property
    @pulumi.getter(name="stringNotEndsWiths")
    def string_not_ends_withs(self) -> Optional[Sequence['outputs.SystemTopicEventSubscriptionAdvancedFilterStringNotEndsWith']]:
        """
        Compares a value of an event using multiple string values.
        """
        return pulumi.get(self, "string_not_ends_withs")

    @property
    @pulumi.getter(name="stringNotIns")
    def string_not_ins(self) -> Optional[Sequence['outputs.SystemTopicEventSubscriptionAdvancedFilterStringNotIn']]:
        """
        Compares a value of an event using multiple string values.
        """
        return pulumi.get(self, "string_not_ins")


@pulumi.output_type
class SystemTopicEventSubscriptionAdvancedFilterBoolEqual(dict):
    def __init__(__self__, *,
                 key: builtins.str,
                 value: builtins.bool):
        """
        :param builtins.str key: Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> builtins.bool:
        return pulumi.get(self, "value")


@pulumi.output_type
class SystemTopicEventSubscriptionAdvancedFilterIsNotNull(dict):
    def __init__(__self__, *,
                 key: builtins.str):
        """
        :param builtins.str key: Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        """
        pulumi.set(__self__, "key", key)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        """
        return pulumi.get(self, "key")


@pulumi.output_type
class SystemTopicEventSubscriptionAdvancedFilterIsNullOrUndefined(dict):
    def __init__(__self__, *,
                 key: builtins.str):
        """
        :param builtins.str key: Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        """
        pulumi.set(__self__, "key", key)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        """
        return pulumi.get(self, "key")


@pulumi.output_type
class SystemTopicEventSubscriptionAdvancedFilterNumberGreaterThan(dict):
    def __init__(__self__, *,
                 key: builtins.str,
                 value: builtins.float):
        """
        :param builtins.str key: Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> builtins.float:
        return pulumi.get(self, "value")


@pulumi.output_type
class SystemTopicEventSubscriptionAdvancedFilterNumberGreaterThanOrEqual(dict):
    def __init__(__self__, *,
                 key: builtins.str,
                 value: builtins.float):
        """
        :param builtins.str key: Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> builtins.float:
        return pulumi.get(self, "value")


@pulumi.output_type
class SystemTopicEventSubscriptionAdvancedFilterNumberIn(dict):
    def __init__(__self__, *,
                 key: builtins.str,
                 values: Sequence[builtins.float]):
        """
        :param builtins.str key: Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        :param Sequence[builtins.float] values: Specifies an array of values to compare to when using a multiple values operator.
               
               > **Note:** A maximum of total number of advanced filter values allowed on event subscription is 25.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.float]:
        """
        Specifies an array of values to compare to when using a multiple values operator.

        > **Note:** A maximum of total number of advanced filter values allowed on event subscription is 25.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class SystemTopicEventSubscriptionAdvancedFilterNumberInRange(dict):
    def __init__(__self__, *,
                 key: builtins.str,
                 values: Sequence[Sequence[builtins.float]]):
        """
        :param builtins.str key: Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        :param Sequence[Sequence[builtins.float]] values: Specifies an array of values to compare to when using a multiple values operator.
               
               > **Note:** A maximum of total number of advanced filter values allowed on event subscription is 25.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Sequence[Sequence[builtins.float]]:
        """
        Specifies an array of values to compare to when using a multiple values operator.

        > **Note:** A maximum of total number of advanced filter values allowed on event subscription is 25.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class SystemTopicEventSubscriptionAdvancedFilterNumberLessThan(dict):
    def __init__(__self__, *,
                 key: builtins.str,
                 value: builtins.float):
        """
        :param builtins.str key: Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> builtins.float:
        return pulumi.get(self, "value")


@pulumi.output_type
class SystemTopicEventSubscriptionAdvancedFilterNumberLessThanOrEqual(dict):
    def __init__(__self__, *,
                 key: builtins.str,
                 value: builtins.float):
        """
        :param builtins.str key: Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> builtins.float:
        return pulumi.get(self, "value")


@pulumi.output_type
class SystemTopicEventSubscriptionAdvancedFilterNumberNotIn(dict):
    def __init__(__self__, *,
                 key: builtins.str,
                 values: Sequence[builtins.float]):
        """
        :param builtins.str key: Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        :param Sequence[builtins.float] values: Specifies an array of values to compare to when using a multiple values operator.
               
               > **Note:** A maximum of total number of advanced filter values allowed on event subscription is 25.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.float]:
        """
        Specifies an array of values to compare to when using a multiple values operator.

        > **Note:** A maximum of total number of advanced filter values allowed on event subscription is 25.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class SystemTopicEventSubscriptionAdvancedFilterNumberNotInRange(dict):
    def __init__(__self__, *,
                 key: builtins.str,
                 values: Sequence[Sequence[builtins.float]]):
        """
        :param builtins.str key: Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        :param Sequence[Sequence[builtins.float]] values: Specifies an array of values to compare to when using a multiple values operator.
               
               > **Note:** A maximum of total number of advanced filter values allowed on event subscription is 25.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Sequence[Sequence[builtins.float]]:
        """
        Specifies an array of values to compare to when using a multiple values operator.

        > **Note:** A maximum of total number of advanced filter values allowed on event subscription is 25.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class SystemTopicEventSubscriptionAdvancedFilterStringBeginsWith(dict):
    def __init__(__self__, *,
                 key: builtins.str,
                 values: Sequence[builtins.str]):
        """
        :param builtins.str key: Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        :param Sequence[builtins.str] values: Specifies an array of values to compare to when using a multiple values operator.
               
               > **Note:** A maximum of total number of advanced filter values allowed on event subscription is 25.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        """
        Specifies an array of values to compare to when using a multiple values operator.

        > **Note:** A maximum of total number of advanced filter values allowed on event subscription is 25.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class SystemTopicEventSubscriptionAdvancedFilterStringContain(dict):
    def __init__(__self__, *,
                 key: builtins.str,
                 values: Sequence[builtins.str]):
        """
        :param builtins.str key: Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        :param Sequence[builtins.str] values: Specifies an array of values to compare to when using a multiple values operator.
               
               > **Note:** A maximum of total number of advanced filter values allowed on event subscription is 25.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        """
        Specifies an array of values to compare to when using a multiple values operator.

        > **Note:** A maximum of total number of advanced filter values allowed on event subscription is 25.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class SystemTopicEventSubscriptionAdvancedFilterStringEndsWith(dict):
    def __init__(__self__, *,
                 key: builtins.str,
                 values: Sequence[builtins.str]):
        """
        :param builtins.str key: Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        :param Sequence[builtins.str] values: Specifies an array of values to compare to when using a multiple values operator.
               
               > **Note:** A maximum of total number of advanced filter values allowed on event subscription is 25.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        """
        Specifies an array of values to compare to when using a multiple values operator.

        > **Note:** A maximum of total number of advanced filter values allowed on event subscription is 25.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class SystemTopicEventSubscriptionAdvancedFilterStringIn(dict):
    def __init__(__self__, *,
                 key: builtins.str,
                 values: Sequence[builtins.str]):
        """
        :param builtins.str key: Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        :param Sequence[builtins.str] values: Specifies an array of values to compare to when using a multiple values operator.
               
               > **Note:** A maximum of total number of advanced filter values allowed on event subscription is 25.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        """
        Specifies an array of values to compare to when using a multiple values operator.

        > **Note:** A maximum of total number of advanced filter values allowed on event subscription is 25.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class SystemTopicEventSubscriptionAdvancedFilterStringNotBeginsWith(dict):
    def __init__(__self__, *,
                 key: builtins.str,
                 values: Sequence[builtins.str]):
        """
        :param builtins.str key: Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        :param Sequence[builtins.str] values: Specifies an array of values to compare to when using a multiple values operator.
               
               > **Note:** A maximum of total number of advanced filter values allowed on event subscription is 25.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        """
        Specifies an array of values to compare to when using a multiple values operator.

        > **Note:** A maximum of total number of advanced filter values allowed on event subscription is 25.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class SystemTopicEventSubscriptionAdvancedFilterStringNotContain(dict):
    def __init__(__self__, *,
                 key: builtins.str,
                 values: Sequence[builtins.str]):
        """
        :param builtins.str key: Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        :param Sequence[builtins.str] values: Specifies an array of values to compare to when using a multiple values operator.
               
               > **Note:** A maximum of total number of advanced filter values allowed on event subscription is 25.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        """
        Specifies an array of values to compare to when using a multiple values operator.

        > **Note:** A maximum of total number of advanced filter values allowed on event subscription is 25.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class SystemTopicEventSubscriptionAdvancedFilterStringNotEndsWith(dict):
    def __init__(__self__, *,
                 key: builtins.str,
                 values: Sequence[builtins.str]):
        """
        :param builtins.str key: Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        :param Sequence[builtins.str] values: Specifies an array of values to compare to when using a multiple values operator.
               
               > **Note:** A maximum of total number of advanced filter values allowed on event subscription is 25.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        """
        Specifies an array of values to compare to when using a multiple values operator.

        > **Note:** A maximum of total number of advanced filter values allowed on event subscription is 25.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class SystemTopicEventSubscriptionAdvancedFilterStringNotIn(dict):
    def __init__(__self__, *,
                 key: builtins.str,
                 values: Sequence[builtins.str]):
        """
        :param builtins.str key: Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        :param Sequence[builtins.str] values: Specifies an array of values to compare to when using a multiple values operator.
               
               > **Note:** A maximum of total number of advanced filter values allowed on event subscription is 25.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        """
        Specifies an array of values to compare to when using a multiple values operator.

        > **Note:** A maximum of total number of advanced filter values allowed on event subscription is 25.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class SystemTopicEventSubscriptionAzureFunctionEndpoint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "functionId":
            suggest = "function_id"
        elif key == "maxEventsPerBatch":
            suggest = "max_events_per_batch"
        elif key == "preferredBatchSizeInKilobytes":
            suggest = "preferred_batch_size_in_kilobytes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SystemTopicEventSubscriptionAzureFunctionEndpoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SystemTopicEventSubscriptionAzureFunctionEndpoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SystemTopicEventSubscriptionAzureFunctionEndpoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 function_id: builtins.str,
                 max_events_per_batch: Optional[builtins.int] = None,
                 preferred_batch_size_in_kilobytes: Optional[builtins.int] = None):
        """
        :param builtins.str function_id: Specifies the ID of the Function where the Event Subscription will receive events. This must be the functions ID in format {function_app.id}/functions/{name}.
        :param builtins.int max_events_per_batch: Maximum number of events per batch.
        :param builtins.int preferred_batch_size_in_kilobytes: Preferred batch size in Kilobytes.
        """
        pulumi.set(__self__, "function_id", function_id)
        if max_events_per_batch is not None:
            pulumi.set(__self__, "max_events_per_batch", max_events_per_batch)
        if preferred_batch_size_in_kilobytes is not None:
            pulumi.set(__self__, "preferred_batch_size_in_kilobytes", preferred_batch_size_in_kilobytes)

    @property
    @pulumi.getter(name="functionId")
    def function_id(self) -> builtins.str:
        """
        Specifies the ID of the Function where the Event Subscription will receive events. This must be the functions ID in format {function_app.id}/functions/{name}.
        """
        return pulumi.get(self, "function_id")

    @property
    @pulumi.getter(name="maxEventsPerBatch")
    def max_events_per_batch(self) -> Optional[builtins.int]:
        """
        Maximum number of events per batch.
        """
        return pulumi.get(self, "max_events_per_batch")

    @property
    @pulumi.getter(name="preferredBatchSizeInKilobytes")
    def preferred_batch_size_in_kilobytes(self) -> Optional[builtins.int]:
        """
        Preferred batch size in Kilobytes.
        """
        return pulumi.get(self, "preferred_batch_size_in_kilobytes")


@pulumi.output_type
class SystemTopicEventSubscriptionDeadLetterIdentity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "userAssignedIdentity":
            suggest = "user_assigned_identity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SystemTopicEventSubscriptionDeadLetterIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SystemTopicEventSubscriptionDeadLetterIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SystemTopicEventSubscriptionDeadLetterIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: builtins.str,
                 user_assigned_identity: Optional[builtins.str] = None):
        """
        :param builtins.str type: Specifies the type of Managed Service Identity that is used for dead lettering. Allowed value is `SystemAssigned`, `UserAssigned`.
        :param builtins.str user_assigned_identity: The user identity associated with the resource.
        """
        pulumi.set(__self__, "type", type)
        if user_assigned_identity is not None:
            pulumi.set(__self__, "user_assigned_identity", user_assigned_identity)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Specifies the type of Managed Service Identity that is used for dead lettering. Allowed value is `SystemAssigned`, `UserAssigned`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="userAssignedIdentity")
    def user_assigned_identity(self) -> Optional[builtins.str]:
        """
        The user identity associated with the resource.
        """
        return pulumi.get(self, "user_assigned_identity")


@pulumi.output_type
class SystemTopicEventSubscriptionDeliveryIdentity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "userAssignedIdentity":
            suggest = "user_assigned_identity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SystemTopicEventSubscriptionDeliveryIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SystemTopicEventSubscriptionDeliveryIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SystemTopicEventSubscriptionDeliveryIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: builtins.str,
                 user_assigned_identity: Optional[builtins.str] = None):
        """
        :param builtins.str type: Specifies the type of Managed Service Identity that is used for event delivery. Allowed value is `SystemAssigned`, `UserAssigned`.
        :param builtins.str user_assigned_identity: The user identity associated with the resource.
        """
        pulumi.set(__self__, "type", type)
        if user_assigned_identity is not None:
            pulumi.set(__self__, "user_assigned_identity", user_assigned_identity)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Specifies the type of Managed Service Identity that is used for event delivery. Allowed value is `SystemAssigned`, `UserAssigned`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="userAssignedIdentity")
    def user_assigned_identity(self) -> Optional[builtins.str]:
        """
        The user identity associated with the resource.
        """
        return pulumi.get(self, "user_assigned_identity")


@pulumi.output_type
class SystemTopicEventSubscriptionDeliveryProperty(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "headerName":
            suggest = "header_name"
        elif key == "sourceField":
            suggest = "source_field"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SystemTopicEventSubscriptionDeliveryProperty. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SystemTopicEventSubscriptionDeliveryProperty.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SystemTopicEventSubscriptionDeliveryProperty.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 header_name: builtins.str,
                 type: builtins.str,
                 secret: Optional[builtins.bool] = None,
                 source_field: Optional[builtins.str] = None,
                 value: Optional[builtins.str] = None):
        """
        :param builtins.str header_name: The name of the header to send on to the destination.
        :param builtins.str type: Either `Static` or `Dynamic`.
        :param builtins.bool secret: Set to `true` if the `value` is a secret and should be protected, otherwise `false`. If `true` then this value won't be returned from Azure API calls.
        :param builtins.str source_field: If the `type` is `Dynamic`, then provide the payload field to be used as the value. Valid source fields differ by subscription type.
        :param builtins.str value: If the `type` is `Static`, then provide the value to use.
        """
        pulumi.set(__self__, "header_name", header_name)
        pulumi.set(__self__, "type", type)
        if secret is not None:
            pulumi.set(__self__, "secret", secret)
        if source_field is not None:
            pulumi.set(__self__, "source_field", source_field)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="headerName")
    def header_name(self) -> builtins.str:
        """
        The name of the header to send on to the destination.
        """
        return pulumi.get(self, "header_name")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Either `Static` or `Dynamic`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def secret(self) -> Optional[builtins.bool]:
        """
        Set to `true` if the `value` is a secret and should be protected, otherwise `false`. If `true` then this value won't be returned from Azure API calls.
        """
        return pulumi.get(self, "secret")

    @property
    @pulumi.getter(name="sourceField")
    def source_field(self) -> Optional[builtins.str]:
        """
        If the `type` is `Dynamic`, then provide the payload field to be used as the value. Valid source fields differ by subscription type.
        """
        return pulumi.get(self, "source_field")

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.str]:
        """
        If the `type` is `Static`, then provide the value to use.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class SystemTopicEventSubscriptionRetryPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "eventTimeToLive":
            suggest = "event_time_to_live"
        elif key == "maxDeliveryAttempts":
            suggest = "max_delivery_attempts"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SystemTopicEventSubscriptionRetryPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SystemTopicEventSubscriptionRetryPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SystemTopicEventSubscriptionRetryPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 event_time_to_live: builtins.int,
                 max_delivery_attempts: builtins.int):
        """
        :param builtins.int event_time_to_live: Specifies the time to live (in minutes) for events. Supported range is `1` to `1440`. See [official documentation](https://docs.microsoft.com/azure/event-grid/manage-event-delivery#set-retry-policy) for more details.
        :param builtins.int max_delivery_attempts: Specifies the maximum number of delivery retry attempts for events.
        """
        pulumi.set(__self__, "event_time_to_live", event_time_to_live)
        pulumi.set(__self__, "max_delivery_attempts", max_delivery_attempts)

    @property
    @pulumi.getter(name="eventTimeToLive")
    def event_time_to_live(self) -> builtins.int:
        """
        Specifies the time to live (in minutes) for events. Supported range is `1` to `1440`. See [official documentation](https://docs.microsoft.com/azure/event-grid/manage-event-delivery#set-retry-policy) for more details.
        """
        return pulumi.get(self, "event_time_to_live")

    @property
    @pulumi.getter(name="maxDeliveryAttempts")
    def max_delivery_attempts(self) -> builtins.int:
        """
        Specifies the maximum number of delivery retry attempts for events.
        """
        return pulumi.get(self, "max_delivery_attempts")


@pulumi.output_type
class SystemTopicEventSubscriptionStorageBlobDeadLetterDestination(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storageAccountId":
            suggest = "storage_account_id"
        elif key == "storageBlobContainerName":
            suggest = "storage_blob_container_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SystemTopicEventSubscriptionStorageBlobDeadLetterDestination. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SystemTopicEventSubscriptionStorageBlobDeadLetterDestination.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SystemTopicEventSubscriptionStorageBlobDeadLetterDestination.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 storage_account_id: builtins.str,
                 storage_blob_container_name: builtins.str):
        """
        :param builtins.str storage_account_id: Specifies the id of the storage account id where the storage blob is located.
        :param builtins.str storage_blob_container_name: Specifies the name of the Storage blob container that is the destination of the deadletter events.
        """
        pulumi.set(__self__, "storage_account_id", storage_account_id)
        pulumi.set(__self__, "storage_blob_container_name", storage_blob_container_name)

    @property
    @pulumi.getter(name="storageAccountId")
    def storage_account_id(self) -> builtins.str:
        """
        Specifies the id of the storage account id where the storage blob is located.
        """
        return pulumi.get(self, "storage_account_id")

    @property
    @pulumi.getter(name="storageBlobContainerName")
    def storage_blob_container_name(self) -> builtins.str:
        """
        Specifies the name of the Storage blob container that is the destination of the deadletter events.
        """
        return pulumi.get(self, "storage_blob_container_name")


@pulumi.output_type
class SystemTopicEventSubscriptionStorageQueueEndpoint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "queueName":
            suggest = "queue_name"
        elif key == "storageAccountId":
            suggest = "storage_account_id"
        elif key == "queueMessageTimeToLiveInSeconds":
            suggest = "queue_message_time_to_live_in_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SystemTopicEventSubscriptionStorageQueueEndpoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SystemTopicEventSubscriptionStorageQueueEndpoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SystemTopicEventSubscriptionStorageQueueEndpoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 queue_name: builtins.str,
                 storage_account_id: builtins.str,
                 queue_message_time_to_live_in_seconds: Optional[builtins.int] = None):
        """
        :param builtins.str queue_name: Specifies the name of the storage queue where the Event Subscription will receive events.
        :param builtins.str storage_account_id: Specifies the id of the storage account id where the storage queue is located.
        :param builtins.int queue_message_time_to_live_in_seconds: Storage queue message time to live in seconds.
        """
        pulumi.set(__self__, "queue_name", queue_name)
        pulumi.set(__self__, "storage_account_id", storage_account_id)
        if queue_message_time_to_live_in_seconds is not None:
            pulumi.set(__self__, "queue_message_time_to_live_in_seconds", queue_message_time_to_live_in_seconds)

    @property
    @pulumi.getter(name="queueName")
    def queue_name(self) -> builtins.str:
        """
        Specifies the name of the storage queue where the Event Subscription will receive events.
        """
        return pulumi.get(self, "queue_name")

    @property
    @pulumi.getter(name="storageAccountId")
    def storage_account_id(self) -> builtins.str:
        """
        Specifies the id of the storage account id where the storage queue is located.
        """
        return pulumi.get(self, "storage_account_id")

    @property
    @pulumi.getter(name="queueMessageTimeToLiveInSeconds")
    def queue_message_time_to_live_in_seconds(self) -> Optional[builtins.int]:
        """
        Storage queue message time to live in seconds.
        """
        return pulumi.get(self, "queue_message_time_to_live_in_seconds")


@pulumi.output_type
class SystemTopicEventSubscriptionSubjectFilter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "caseSensitive":
            suggest = "case_sensitive"
        elif key == "subjectBeginsWith":
            suggest = "subject_begins_with"
        elif key == "subjectEndsWith":
            suggest = "subject_ends_with"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SystemTopicEventSubscriptionSubjectFilter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SystemTopicEventSubscriptionSubjectFilter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SystemTopicEventSubscriptionSubjectFilter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 case_sensitive: Optional[builtins.bool] = None,
                 subject_begins_with: Optional[builtins.str] = None,
                 subject_ends_with: Optional[builtins.str] = None):
        """
        :param builtins.bool case_sensitive: Specifies if `subject_begins_with` and `subject_ends_with` case sensitive. This value
        :param builtins.str subject_begins_with: A string to filter events for an event subscription based on a resource path prefix.
        :param builtins.str subject_ends_with: A string to filter events for an event subscription based on a resource path suffix.
        """
        if case_sensitive is not None:
            pulumi.set(__self__, "case_sensitive", case_sensitive)
        if subject_begins_with is not None:
            pulumi.set(__self__, "subject_begins_with", subject_begins_with)
        if subject_ends_with is not None:
            pulumi.set(__self__, "subject_ends_with", subject_ends_with)

    @property
    @pulumi.getter(name="caseSensitive")
    def case_sensitive(self) -> Optional[builtins.bool]:
        """
        Specifies if `subject_begins_with` and `subject_ends_with` case sensitive. This value
        """
        return pulumi.get(self, "case_sensitive")

    @property
    @pulumi.getter(name="subjectBeginsWith")
    def subject_begins_with(self) -> Optional[builtins.str]:
        """
        A string to filter events for an event subscription based on a resource path prefix.
        """
        return pulumi.get(self, "subject_begins_with")

    @property
    @pulumi.getter(name="subjectEndsWith")
    def subject_ends_with(self) -> Optional[builtins.str]:
        """
        A string to filter events for an event subscription based on a resource path suffix.
        """
        return pulumi.get(self, "subject_ends_with")


@pulumi.output_type
class SystemTopicEventSubscriptionWebhookEndpoint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "activeDirectoryAppIdOrUri":
            suggest = "active_directory_app_id_or_uri"
        elif key == "activeDirectoryTenantId":
            suggest = "active_directory_tenant_id"
        elif key == "baseUrl":
            suggest = "base_url"
        elif key == "maxEventsPerBatch":
            suggest = "max_events_per_batch"
        elif key == "preferredBatchSizeInKilobytes":
            suggest = "preferred_batch_size_in_kilobytes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SystemTopicEventSubscriptionWebhookEndpoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SystemTopicEventSubscriptionWebhookEndpoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SystemTopicEventSubscriptionWebhookEndpoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 url: builtins.str,
                 active_directory_app_id_or_uri: Optional[builtins.str] = None,
                 active_directory_tenant_id: Optional[builtins.str] = None,
                 base_url: Optional[builtins.str] = None,
                 max_events_per_batch: Optional[builtins.int] = None,
                 preferred_batch_size_in_kilobytes: Optional[builtins.int] = None):
        """
        :param builtins.str url: Specifies the url of the webhook where the Event Subscription will receive events.
        :param builtins.str active_directory_app_id_or_uri: The Azure Active Directory Application ID or URI to get the access token that will be included as the bearer token in delivery requests.
        :param builtins.str active_directory_tenant_id: The Azure Active Directory Tenant ID to get the access token that will be included as the bearer token in delivery requests.
        :param builtins.str base_url: The base url of the webhook where the Event Subscription will receive events.
        :param builtins.int max_events_per_batch: Maximum number of events per batch.
        :param builtins.int preferred_batch_size_in_kilobytes: Preferred batch size in Kilobytes.
        """
        pulumi.set(__self__, "url", url)
        if active_directory_app_id_or_uri is not None:
            pulumi.set(__self__, "active_directory_app_id_or_uri", active_directory_app_id_or_uri)
        if active_directory_tenant_id is not None:
            pulumi.set(__self__, "active_directory_tenant_id", active_directory_tenant_id)
        if base_url is not None:
            pulumi.set(__self__, "base_url", base_url)
        if max_events_per_batch is not None:
            pulumi.set(__self__, "max_events_per_batch", max_events_per_batch)
        if preferred_batch_size_in_kilobytes is not None:
            pulumi.set(__self__, "preferred_batch_size_in_kilobytes", preferred_batch_size_in_kilobytes)

    @property
    @pulumi.getter
    def url(self) -> builtins.str:
        """
        Specifies the url of the webhook where the Event Subscription will receive events.
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter(name="activeDirectoryAppIdOrUri")
    def active_directory_app_id_or_uri(self) -> Optional[builtins.str]:
        """
        The Azure Active Directory Application ID or URI to get the access token that will be included as the bearer token in delivery requests.
        """
        return pulumi.get(self, "active_directory_app_id_or_uri")

    @property
    @pulumi.getter(name="activeDirectoryTenantId")
    def active_directory_tenant_id(self) -> Optional[builtins.str]:
        """
        The Azure Active Directory Tenant ID to get the access token that will be included as the bearer token in delivery requests.
        """
        return pulumi.get(self, "active_directory_tenant_id")

    @property
    @pulumi.getter(name="baseUrl")
    def base_url(self) -> Optional[builtins.str]:
        """
        The base url of the webhook where the Event Subscription will receive events.
        """
        return pulumi.get(self, "base_url")

    @property
    @pulumi.getter(name="maxEventsPerBatch")
    def max_events_per_batch(self) -> Optional[builtins.int]:
        """
        Maximum number of events per batch.
        """
        return pulumi.get(self, "max_events_per_batch")

    @property
    @pulumi.getter(name="preferredBatchSizeInKilobytes")
    def preferred_batch_size_in_kilobytes(self) -> Optional[builtins.int]:
        """
        Preferred batch size in Kilobytes.
        """
        return pulumi.get(self, "preferred_batch_size_in_kilobytes")


@pulumi.output_type
class SystemTopicIdentity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "identityIds":
            suggest = "identity_ids"
        elif key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SystemTopicIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SystemTopicIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SystemTopicIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: builtins.str,
                 identity_ids: Optional[Sequence[builtins.str]] = None,
                 principal_id: Optional[builtins.str] = None,
                 tenant_id: Optional[builtins.str] = None):
        """
        :param builtins.str type: Specifies the type of Managed Service Identity that should be configured on this Event Grid System Topic. Possible values are `SystemAssigned`, `UserAssigned`.
        :param Sequence[builtins.str] identity_ids: Specifies a list of User Assigned Managed Identity IDs to be assigned to this Event Grid System Topic.
               
               > **Note:** This is required when `type` is set to `UserAssigned`
               
               > **Note:** When `type` is set to `SystemAssigned`, The assigned `principal_id` and `tenant_id` can be retrieved after the Event Grid System Topic has been created. More details are available below.
        :param builtins.str principal_id: The Principal ID associated with this Managed Service Identity.
        :param builtins.str tenant_id: The Tenant ID associated with this Managed Service Identity.
        """
        pulumi.set(__self__, "type", type)
        if identity_ids is not None:
            pulumi.set(__self__, "identity_ids", identity_ids)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Specifies the type of Managed Service Identity that should be configured on this Event Grid System Topic. Possible values are `SystemAssigned`, `UserAssigned`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        Specifies a list of User Assigned Managed Identity IDs to be assigned to this Event Grid System Topic.

        > **Note:** This is required when `type` is set to `UserAssigned`

        > **Note:** When `type` is set to `SystemAssigned`, The assigned `principal_id` and `tenant_id` can be retrieved after the Event Grid System Topic has been created. More details are available below.
        """
        return pulumi.get(self, "identity_ids")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[builtins.str]:
        """
        The Principal ID associated with this Managed Service Identity.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[builtins.str]:
        """
        The Tenant ID associated with this Managed Service Identity.
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class TopicIdentity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "identityIds":
            suggest = "identity_ids"
        elif key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TopicIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TopicIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TopicIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: builtins.str,
                 identity_ids: Optional[Sequence[builtins.str]] = None,
                 principal_id: Optional[builtins.str] = None,
                 tenant_id: Optional[builtins.str] = None):
        """
        :param builtins.str type: Specifies the type of Managed Service Identity that should be configured on this Event Grid Topic. Possible values are `SystemAssigned`, `UserAssigned`.
        :param Sequence[builtins.str] identity_ids: Specifies a list of User Assigned Managed Identity IDs to be assigned to this Event Grid Topic.
               
               > **Note:** This is required when `type` is set to `UserAssigned`
               
               > **Note:** When `type` is set to `SystemAssigned`, The assigned `principal_id` and `tenant_id` can be retrieved after the Event Grid Topic has been created. More details are available below.
        :param builtins.str principal_id: The Principal ID associated with this Managed Service Identity.
        :param builtins.str tenant_id: The Tenant ID associated with this Managed Service Identity.
        """
        pulumi.set(__self__, "type", type)
        if identity_ids is not None:
            pulumi.set(__self__, "identity_ids", identity_ids)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Specifies the type of Managed Service Identity that should be configured on this Event Grid Topic. Possible values are `SystemAssigned`, `UserAssigned`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        Specifies a list of User Assigned Managed Identity IDs to be assigned to this Event Grid Topic.

        > **Note:** This is required when `type` is set to `UserAssigned`

        > **Note:** When `type` is set to `SystemAssigned`, The assigned `principal_id` and `tenant_id` can be retrieved after the Event Grid Topic has been created. More details are available below.
        """
        return pulumi.get(self, "identity_ids")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[builtins.str]:
        """
        The Principal ID associated with this Managed Service Identity.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[builtins.str]:
        """
        The Tenant ID associated with this Managed Service Identity.
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class TopicInboundIpRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipMask":
            suggest = "ip_mask"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TopicInboundIpRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TopicInboundIpRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TopicInboundIpRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_mask: builtins.str,
                 action: Optional[builtins.str] = None):
        """
        :param builtins.str ip_mask: The IP mask (CIDR) to match on.
        :param builtins.str action: The action to take when the rule is matched. Possible values are `Allow`. Defaults to `Allow`.
        """
        pulumi.set(__self__, "ip_mask", ip_mask)
        if action is not None:
            pulumi.set(__self__, "action", action)

    @property
    @pulumi.getter(name="ipMask")
    def ip_mask(self) -> builtins.str:
        """
        The IP mask (CIDR) to match on.
        """
        return pulumi.get(self, "ip_mask")

    @property
    @pulumi.getter
    def action(self) -> Optional[builtins.str]:
        """
        The action to take when the rule is matched. Possible values are `Allow`. Defaults to `Allow`.
        """
        return pulumi.get(self, "action")


@pulumi.output_type
class TopicInputMappingDefaultValues(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataVersion":
            suggest = "data_version"
        elif key == "eventType":
            suggest = "event_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TopicInputMappingDefaultValues. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TopicInputMappingDefaultValues.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TopicInputMappingDefaultValues.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_version: Optional[builtins.str] = None,
                 event_type: Optional[builtins.str] = None,
                 subject: Optional[builtins.str] = None):
        """
        :param builtins.str data_version: Specifies the default data version of the EventGrid Event to associate with the domain. Changing this forces a new resource to be created.
        :param builtins.str event_type: Specifies the default event type of the EventGrid Event to associate with the domain. Changing this forces a new resource to be created.
        :param builtins.str subject: Specifies the default subject of the EventGrid Event to associate with the domain. Changing this forces a new resource to be created.
        """
        if data_version is not None:
            pulumi.set(__self__, "data_version", data_version)
        if event_type is not None:
            pulumi.set(__self__, "event_type", event_type)
        if subject is not None:
            pulumi.set(__self__, "subject", subject)

    @property
    @pulumi.getter(name="dataVersion")
    def data_version(self) -> Optional[builtins.str]:
        """
        Specifies the default data version of the EventGrid Event to associate with the domain. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "data_version")

    @property
    @pulumi.getter(name="eventType")
    def event_type(self) -> Optional[builtins.str]:
        """
        Specifies the default event type of the EventGrid Event to associate with the domain. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "event_type")

    @property
    @pulumi.getter
    def subject(self) -> Optional[builtins.str]:
        """
        Specifies the default subject of the EventGrid Event to associate with the domain. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "subject")


@pulumi.output_type
class TopicInputMappingFields(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataVersion":
            suggest = "data_version"
        elif key == "eventTime":
            suggest = "event_time"
        elif key == "eventType":
            suggest = "event_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TopicInputMappingFields. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TopicInputMappingFields.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TopicInputMappingFields.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_version: Optional[builtins.str] = None,
                 event_time: Optional[builtins.str] = None,
                 event_type: Optional[builtins.str] = None,
                 id: Optional[builtins.str] = None,
                 subject: Optional[builtins.str] = None,
                 topic: Optional[builtins.str] = None):
        """
        :param builtins.str data_version: Specifies the data version of the EventGrid Event to associate with the domain. Changing this forces a new resource to be created.
        :param builtins.str event_time: Specifies the event time of the EventGrid Event to associate with the domain. Changing this forces a new resource to be created.
        :param builtins.str event_type: Specifies the event type of the EventGrid Event to associate with the domain. Changing this forces a new resource to be created.
        :param builtins.str id: Specifies the id of the EventGrid Event to associate with the domain. Changing this forces a new resource to be created.
        :param builtins.str subject: Specifies the subject of the EventGrid Event to associate with the domain. Changing this forces a new resource to be created.
        :param builtins.str topic: Specifies the topic of the EventGrid Event to associate with the domain. Changing this forces a new resource to be created.
        """
        if data_version is not None:
            pulumi.set(__self__, "data_version", data_version)
        if event_time is not None:
            pulumi.set(__self__, "event_time", event_time)
        if event_type is not None:
            pulumi.set(__self__, "event_type", event_type)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if subject is not None:
            pulumi.set(__self__, "subject", subject)
        if topic is not None:
            pulumi.set(__self__, "topic", topic)

    @property
    @pulumi.getter(name="dataVersion")
    def data_version(self) -> Optional[builtins.str]:
        """
        Specifies the data version of the EventGrid Event to associate with the domain. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "data_version")

    @property
    @pulumi.getter(name="eventTime")
    def event_time(self) -> Optional[builtins.str]:
        """
        Specifies the event time of the EventGrid Event to associate with the domain. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "event_time")

    @property
    @pulumi.getter(name="eventType")
    def event_type(self) -> Optional[builtins.str]:
        """
        Specifies the event type of the EventGrid Event to associate with the domain. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "event_type")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        Specifies the id of the EventGrid Event to associate with the domain. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def subject(self) -> Optional[builtins.str]:
        """
        Specifies the subject of the EventGrid Event to associate with the domain. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "subject")

    @property
    @pulumi.getter
    def topic(self) -> Optional[builtins.str]:
        """
        Specifies the topic of the EventGrid Event to associate with the domain. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "topic")


@pulumi.output_type
class GetDomainIdentityResult(dict):
    def __init__(__self__, *,
                 identity_ids: Sequence[builtins.str],
                 principal_id: builtins.str,
                 tenant_id: builtins.str,
                 type: builtins.str):
        """
        :param Sequence[builtins.str] identity_ids: The list of User Assigned Managed Identity IDs assigned to this EventGrid Domain.
        :param builtins.str principal_id: The Principal ID of the System Assigned Managed Service Identity.
        :param builtins.str tenant_id: The Tenant ID of the System Assigned Managed Service Identity.
        :param builtins.str type: The type of Managed Service Identity that is configured on this EventGrid Domain.
        """
        pulumi.set(__self__, "identity_ids", identity_ids)
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Sequence[builtins.str]:
        """
        The list of User Assigned Managed Identity IDs assigned to this EventGrid Domain.
        """
        return pulumi.get(self, "identity_ids")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> builtins.str:
        """
        The Principal ID of the System Assigned Managed Service Identity.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> builtins.str:
        """
        The Tenant ID of the System Assigned Managed Service Identity.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The type of Managed Service Identity that is configured on this EventGrid Domain.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetDomainInboundIpRuleResult(dict):
    def __init__(__self__, *,
                 action: builtins.str,
                 ip_mask: builtins.str):
        """
        :param builtins.str action: The action to take when the rule is matched. Possible values are `Allow`.
        :param builtins.str ip_mask: The IP mask (CIDR) to match on.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "ip_mask", ip_mask)

    @property
    @pulumi.getter
    def action(self) -> builtins.str:
        """
        The action to take when the rule is matched. Possible values are `Allow`.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter(name="ipMask")
    def ip_mask(self) -> builtins.str:
        """
        The IP mask (CIDR) to match on.
        """
        return pulumi.get(self, "ip_mask")


@pulumi.output_type
class GetDomainInputMappingDefaultValueResult(dict):
    def __init__(__self__, *,
                 data_version: builtins.str,
                 event_type: builtins.str,
                 subject: builtins.str):
        """
        :param builtins.str data_version: Specifies the default data version of the EventGrid Event associated with the domain.
        :param builtins.str event_type: Specifies the default event type of the EventGrid Event associated with the domain.
        :param builtins.str subject: Specifies the default subject of the EventGrid Event associated with the domain.
        """
        pulumi.set(__self__, "data_version", data_version)
        pulumi.set(__self__, "event_type", event_type)
        pulumi.set(__self__, "subject", subject)

    @property
    @pulumi.getter(name="dataVersion")
    def data_version(self) -> builtins.str:
        """
        Specifies the default data version of the EventGrid Event associated with the domain.
        """
        return pulumi.get(self, "data_version")

    @property
    @pulumi.getter(name="eventType")
    def event_type(self) -> builtins.str:
        """
        Specifies the default event type of the EventGrid Event associated with the domain.
        """
        return pulumi.get(self, "event_type")

    @property
    @pulumi.getter
    def subject(self) -> builtins.str:
        """
        Specifies the default subject of the EventGrid Event associated with the domain.
        """
        return pulumi.get(self, "subject")


@pulumi.output_type
class GetDomainInputMappingFieldResult(dict):
    def __init__(__self__, *,
                 data_version: builtins.str,
                 event_time: builtins.str,
                 event_type: builtins.str,
                 id: builtins.str,
                 subject: builtins.str,
                 topic: builtins.str):
        """
        :param builtins.str data_version: Specifies the default data version of the EventGrid Event associated with the domain.
        :param builtins.str event_time: Specifies the event time of the EventGrid Event associated with the domain.
        :param builtins.str event_type: Specifies the default event type of the EventGrid Event associated with the domain.
        :param builtins.str id: Specifies the id of the EventGrid Event associated with the domain.
        :param builtins.str subject: Specifies the default subject of the EventGrid Event associated with the domain.
        :param builtins.str topic: Specifies the topic of the EventGrid Event associated with the domain.
        """
        pulumi.set(__self__, "data_version", data_version)
        pulumi.set(__self__, "event_time", event_time)
        pulumi.set(__self__, "event_type", event_type)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "subject", subject)
        pulumi.set(__self__, "topic", topic)

    @property
    @pulumi.getter(name="dataVersion")
    def data_version(self) -> builtins.str:
        """
        Specifies the default data version of the EventGrid Event associated with the domain.
        """
        return pulumi.get(self, "data_version")

    @property
    @pulumi.getter(name="eventTime")
    def event_time(self) -> builtins.str:
        """
        Specifies the event time of the EventGrid Event associated with the domain.
        """
        return pulumi.get(self, "event_time")

    @property
    @pulumi.getter(name="eventType")
    def event_type(self) -> builtins.str:
        """
        Specifies the default event type of the EventGrid Event associated with the domain.
        """
        return pulumi.get(self, "event_type")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        Specifies the id of the EventGrid Event associated with the domain.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def subject(self) -> builtins.str:
        """
        Specifies the default subject of the EventGrid Event associated with the domain.
        """
        return pulumi.get(self, "subject")

    @property
    @pulumi.getter
    def topic(self) -> builtins.str:
        """
        Specifies the topic of the EventGrid Event associated with the domain.
        """
        return pulumi.get(self, "topic")


@pulumi.output_type
class GetSystemTopicIdentityResult(dict):
    def __init__(__self__, *,
                 identity_ids: Sequence[builtins.str],
                 principal_id: builtins.str,
                 tenant_id: builtins.str,
                 type: builtins.str):
        """
        :param Sequence[builtins.str] identity_ids: The list of User Assigned Managed Identity IDs assigned to this Event Grid System Topic.
        :param builtins.str principal_id: The Principal ID of the System Assigned Managed Service Identity that is configured on this Event Grid System Topic.
        :param builtins.str tenant_id: The Tenant ID of the System Assigned Managed Service Identity that is configured on this Event Grid System Topic.
        :param builtins.str type: The type of Managed Service Identity that is configured on this Event Grid System Topic.
        """
        pulumi.set(__self__, "identity_ids", identity_ids)
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Sequence[builtins.str]:
        """
        The list of User Assigned Managed Identity IDs assigned to this Event Grid System Topic.
        """
        return pulumi.get(self, "identity_ids")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> builtins.str:
        """
        The Principal ID of the System Assigned Managed Service Identity that is configured on this Event Grid System Topic.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> builtins.str:
        """
        The Tenant ID of the System Assigned Managed Service Identity that is configured on this Event Grid System Topic.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The type of Managed Service Identity that is configured on this Event Grid System Topic.
        """
        return pulumi.get(self, "type")


