# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PartnerConfigurationArgs', 'PartnerConfiguration']

@pulumi.input_type
class PartnerConfigurationArgs:
    def __init__(__self__, *,
                 resource_group_name: pulumi.Input[builtins.str],
                 default_maximum_expiration_time_in_days: Optional[pulumi.Input[builtins.int]] = None,
                 partner_authorizations: Optional[pulumi.Input[Sequence[pulumi.Input['PartnerConfigurationPartnerAuthorizationArgs']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a PartnerConfiguration resource.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group where the Event Grid Partner Configuration should exist. Changing this forces a new Event Grid Partner Configuration to be created.
        :param pulumi.Input[builtins.int] default_maximum_expiration_time_in_days: Time used to validate the authorization expiration time for each authorized partner. Defaults to `7`.
        :param pulumi.Input[Sequence[pulumi.Input['PartnerConfigurationPartnerAuthorizationArgs']]] partner_authorizations: One or more `partner_authorization` blocks as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the Event Grid Partner Configuration.
        """
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if default_maximum_expiration_time_in_days is not None:
            pulumi.set(__self__, "default_maximum_expiration_time_in_days", default_maximum_expiration_time_in_days)
        if partner_authorizations is not None:
            pulumi.set(__self__, "partner_authorizations", partner_authorizations)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the Resource Group where the Event Grid Partner Configuration should exist. Changing this forces a new Event Grid Partner Configuration to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="defaultMaximumExpirationTimeInDays")
    def default_maximum_expiration_time_in_days(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Time used to validate the authorization expiration time for each authorized partner. Defaults to `7`.
        """
        return pulumi.get(self, "default_maximum_expiration_time_in_days")

    @default_maximum_expiration_time_in_days.setter
    def default_maximum_expiration_time_in_days(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "default_maximum_expiration_time_in_days", value)

    @property
    @pulumi.getter(name="partnerAuthorizations")
    def partner_authorizations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PartnerConfigurationPartnerAuthorizationArgs']]]]:
        """
        One or more `partner_authorization` blocks as defined below.
        """
        return pulumi.get(self, "partner_authorizations")

    @partner_authorizations.setter
    def partner_authorizations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PartnerConfigurationPartnerAuthorizationArgs']]]]):
        pulumi.set(self, "partner_authorizations", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Event Grid Partner Configuration.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _PartnerConfigurationState:
    def __init__(__self__, *,
                 default_maximum_expiration_time_in_days: Optional[pulumi.Input[builtins.int]] = None,
                 partner_authorizations: Optional[pulumi.Input[Sequence[pulumi.Input['PartnerConfigurationPartnerAuthorizationArgs']]]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering PartnerConfiguration resources.
        :param pulumi.Input[builtins.int] default_maximum_expiration_time_in_days: Time used to validate the authorization expiration time for each authorized partner. Defaults to `7`.
        :param pulumi.Input[Sequence[pulumi.Input['PartnerConfigurationPartnerAuthorizationArgs']]] partner_authorizations: One or more `partner_authorization` blocks as defined below.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group where the Event Grid Partner Configuration should exist. Changing this forces a new Event Grid Partner Configuration to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the Event Grid Partner Configuration.
        """
        if default_maximum_expiration_time_in_days is not None:
            pulumi.set(__self__, "default_maximum_expiration_time_in_days", default_maximum_expiration_time_in_days)
        if partner_authorizations is not None:
            pulumi.set(__self__, "partner_authorizations", partner_authorizations)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="defaultMaximumExpirationTimeInDays")
    def default_maximum_expiration_time_in_days(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Time used to validate the authorization expiration time for each authorized partner. Defaults to `7`.
        """
        return pulumi.get(self, "default_maximum_expiration_time_in_days")

    @default_maximum_expiration_time_in_days.setter
    def default_maximum_expiration_time_in_days(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "default_maximum_expiration_time_in_days", value)

    @property
    @pulumi.getter(name="partnerAuthorizations")
    def partner_authorizations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PartnerConfigurationPartnerAuthorizationArgs']]]]:
        """
        One or more `partner_authorization` blocks as defined below.
        """
        return pulumi.get(self, "partner_authorizations")

    @partner_authorizations.setter
    def partner_authorizations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PartnerConfigurationPartnerAuthorizationArgs']]]]):
        pulumi.set(self, "partner_authorizations", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Resource Group where the Event Grid Partner Configuration should exist. Changing this forces a new Event Grid Partner Configuration to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Event Grid Partner Configuration.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("azure:eventgrid/partnerConfiguration:PartnerConfiguration")
class PartnerConfiguration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default_maximum_expiration_time_in_days: Optional[pulumi.Input[builtins.int]] = None,
                 partner_authorizations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PartnerConfigurationPartnerAuthorizationArgs', 'PartnerConfigurationPartnerAuthorizationArgsDict']]]]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        Manages an Event Grid Partner Configuration.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_partner_configuration = azure.eventgrid.PartnerConfiguration("example",
            resource_group_name=example.name,
            default_maximum_expiration_time_in_days=14,
            partner_authorizations=[{
                "partner_registration_id": "804a11ca-ce9b-4158-8e94-3c8dc7a072ec",
                "partner_name": "Auth0",
                "authorization_expiration_time_in_utc": "2025-02-05T00:00:00Z",
            }],
            tags={
                "environment": "Production",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.EventGrid`: 2022-06-15

        ## Import

        Event Grid Partner Configurations can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:eventgrid/partnerConfiguration:PartnerConfiguration example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.int] default_maximum_expiration_time_in_days: Time used to validate the authorization expiration time for each authorized partner. Defaults to `7`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PartnerConfigurationPartnerAuthorizationArgs', 'PartnerConfigurationPartnerAuthorizationArgsDict']]]] partner_authorizations: One or more `partner_authorization` blocks as defined below.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group where the Event Grid Partner Configuration should exist. Changing this forces a new Event Grid Partner Configuration to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the Event Grid Partner Configuration.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PartnerConfigurationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Event Grid Partner Configuration.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_partner_configuration = azure.eventgrid.PartnerConfiguration("example",
            resource_group_name=example.name,
            default_maximum_expiration_time_in_days=14,
            partner_authorizations=[{
                "partner_registration_id": "804a11ca-ce9b-4158-8e94-3c8dc7a072ec",
                "partner_name": "Auth0",
                "authorization_expiration_time_in_utc": "2025-02-05T00:00:00Z",
            }],
            tags={
                "environment": "Production",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.EventGrid`: 2022-06-15

        ## Import

        Event Grid Partner Configurations can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:eventgrid/partnerConfiguration:PartnerConfiguration example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1
        ```

        :param str resource_name: The name of the resource.
        :param PartnerConfigurationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PartnerConfigurationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default_maximum_expiration_time_in_days: Optional[pulumi.Input[builtins.int]] = None,
                 partner_authorizations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PartnerConfigurationPartnerAuthorizationArgs', 'PartnerConfigurationPartnerAuthorizationArgsDict']]]]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PartnerConfigurationArgs.__new__(PartnerConfigurationArgs)

            __props__.__dict__["default_maximum_expiration_time_in_days"] = default_maximum_expiration_time_in_days
            __props__.__dict__["partner_authorizations"] = partner_authorizations
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["tags"] = tags
        super(PartnerConfiguration, __self__).__init__(
            'azure:eventgrid/partnerConfiguration:PartnerConfiguration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            default_maximum_expiration_time_in_days: Optional[pulumi.Input[builtins.int]] = None,
            partner_authorizations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PartnerConfigurationPartnerAuthorizationArgs', 'PartnerConfigurationPartnerAuthorizationArgsDict']]]]] = None,
            resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None) -> 'PartnerConfiguration':
        """
        Get an existing PartnerConfiguration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.int] default_maximum_expiration_time_in_days: Time used to validate the authorization expiration time for each authorized partner. Defaults to `7`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PartnerConfigurationPartnerAuthorizationArgs', 'PartnerConfigurationPartnerAuthorizationArgsDict']]]] partner_authorizations: One or more `partner_authorization` blocks as defined below.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group where the Event Grid Partner Configuration should exist. Changing this forces a new Event Grid Partner Configuration to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the Event Grid Partner Configuration.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PartnerConfigurationState.__new__(_PartnerConfigurationState)

        __props__.__dict__["default_maximum_expiration_time_in_days"] = default_maximum_expiration_time_in_days
        __props__.__dict__["partner_authorizations"] = partner_authorizations
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["tags"] = tags
        return PartnerConfiguration(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="defaultMaximumExpirationTimeInDays")
    def default_maximum_expiration_time_in_days(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Time used to validate the authorization expiration time for each authorized partner. Defaults to `7`.
        """
        return pulumi.get(self, "default_maximum_expiration_time_in_days")

    @property
    @pulumi.getter(name="partnerAuthorizations")
    def partner_authorizations(self) -> pulumi.Output[Optional[Sequence['outputs.PartnerConfigurationPartnerAuthorization']]]:
        """
        One or more `partner_authorization` blocks as defined below.
        """
        return pulumi.get(self, "partner_authorizations")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Resource Group where the Event Grid Partner Configuration should exist. Changing this forces a new Event Grid Partner Configuration to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A mapping of tags which should be assigned to the Event Grid Partner Configuration.
        """
        return pulumi.get(self, "tags")

