# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetServiceBusNamespaceResult',
    'AwaitableGetServiceBusNamespaceResult',
    'get_service_bus_namespace',
    'get_service_bus_namespace_output',
]

warnings.warn("""azure.eventhub.getServiceBusNamespace has been deprecated in favor of azure.servicebus.getNamespace""", DeprecationWarning)

@pulumi.output_type
class GetServiceBusNamespaceResult:
    """
    A collection of values returned by getServiceBusNamespace.
    """
    def __init__(__self__, capacity=None, default_primary_connection_string=None, default_primary_key=None, default_secondary_connection_string=None, default_secondary_key=None, endpoint=None, id=None, location=None, name=None, premium_messaging_partitions=None, resource_group_name=None, sku=None, tags=None):
        if capacity and not isinstance(capacity, int):
            raise TypeError("Expected argument 'capacity' to be a int")
        pulumi.set(__self__, "capacity", capacity)
        if default_primary_connection_string and not isinstance(default_primary_connection_string, str):
            raise TypeError("Expected argument 'default_primary_connection_string' to be a str")
        pulumi.set(__self__, "default_primary_connection_string", default_primary_connection_string)
        if default_primary_key and not isinstance(default_primary_key, str):
            raise TypeError("Expected argument 'default_primary_key' to be a str")
        pulumi.set(__self__, "default_primary_key", default_primary_key)
        if default_secondary_connection_string and not isinstance(default_secondary_connection_string, str):
            raise TypeError("Expected argument 'default_secondary_connection_string' to be a str")
        pulumi.set(__self__, "default_secondary_connection_string", default_secondary_connection_string)
        if default_secondary_key and not isinstance(default_secondary_key, str):
            raise TypeError("Expected argument 'default_secondary_key' to be a str")
        pulumi.set(__self__, "default_secondary_key", default_secondary_key)
        if endpoint and not isinstance(endpoint, str):
            raise TypeError("Expected argument 'endpoint' to be a str")
        pulumi.set(__self__, "endpoint", endpoint)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if premium_messaging_partitions and not isinstance(premium_messaging_partitions, int):
            raise TypeError("Expected argument 'premium_messaging_partitions' to be a int")
        pulumi.set(__self__, "premium_messaging_partitions", premium_messaging_partitions)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if sku and not isinstance(sku, str):
            raise TypeError("Expected argument 'sku' to be a str")
        pulumi.set(__self__, "sku", sku)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def capacity(self) -> builtins.int:
        """
        The capacity of the ServiceBus Namespace.
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter(name="defaultPrimaryConnectionString")
    def default_primary_connection_string(self) -> builtins.str:
        """
        The primary connection string for the authorization
        rule `RootManageSharedAccessKey`.
        """
        return pulumi.get(self, "default_primary_connection_string")

    @property
    @pulumi.getter(name="defaultPrimaryKey")
    def default_primary_key(self) -> builtins.str:
        """
        The primary access key for the authorization rule `RootManageSharedAccessKey`.
        """
        return pulumi.get(self, "default_primary_key")

    @property
    @pulumi.getter(name="defaultSecondaryConnectionString")
    def default_secondary_connection_string(self) -> builtins.str:
        """
        The secondary connection string for the
        authorization rule `RootManageSharedAccessKey`.
        """
        return pulumi.get(self, "default_secondary_connection_string")

    @property
    @pulumi.getter(name="defaultSecondaryKey")
    def default_secondary_key(self) -> builtins.str:
        """
        The secondary access key for the authorization rule `RootManageSharedAccessKey`.
        """
        return pulumi.get(self, "default_secondary_key")

    @property
    @pulumi.getter
    def endpoint(self) -> builtins.str:
        """
        The URL to access the ServiceBus Namespace.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def location(self) -> builtins.str:
        """
        The location of the Resource Group in which the ServiceBus Namespace exists.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="premiumMessagingPartitions")
    def premium_messaging_partitions(self) -> builtins.int:
        """
        The messaging partitions of the ServiceBus Namespace.
        """
        return pulumi.get(self, "premium_messaging_partitions")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> builtins.str:
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter
    def sku(self) -> builtins.str:
        """
        The Tier used for the ServiceBus Namespace.
        """
        return pulumi.get(self, "sku")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, builtins.str]:
        """
        A mapping of tags assigned to the resource.
        """
        return pulumi.get(self, "tags")


class AwaitableGetServiceBusNamespaceResult(GetServiceBusNamespaceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetServiceBusNamespaceResult(
            capacity=self.capacity,
            default_primary_connection_string=self.default_primary_connection_string,
            default_primary_key=self.default_primary_key,
            default_secondary_connection_string=self.default_secondary_connection_string,
            default_secondary_key=self.default_secondary_key,
            endpoint=self.endpoint,
            id=self.id,
            location=self.location,
            name=self.name,
            premium_messaging_partitions=self.premium_messaging_partitions,
            resource_group_name=self.resource_group_name,
            sku=self.sku,
            tags=self.tags)


def get_service_bus_namespace(name: Optional[builtins.str] = None,
                              resource_group_name: Optional[builtins.str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetServiceBusNamespaceResult:
    """
    Use this data source to access information about an existing ServiceBus Namespace.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.servicebus.get_namespace(name="examplenamespace",
        resource_group_name="example-resources")
    pulumi.export("location", example.location)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.ServiceBus`: 2022-10-01-preview, 2021-06-01-preview


    :param builtins.str name: Specifies the name of the ServiceBus Namespace.
    :param builtins.str resource_group_name: Specifies the name of the Resource Group where the ServiceBus Namespace exists.
    """
    pulumi.log.warn("""get_service_bus_namespace is deprecated: azure.eventhub.getServiceBusNamespace has been deprecated in favor of azure.servicebus.getNamespace""")
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:eventhub/getServiceBusNamespace:getServiceBusNamespace', __args__, opts=opts, typ=GetServiceBusNamespaceResult).value

    return AwaitableGetServiceBusNamespaceResult(
        capacity=pulumi.get(__ret__, 'capacity'),
        default_primary_connection_string=pulumi.get(__ret__, 'default_primary_connection_string'),
        default_primary_key=pulumi.get(__ret__, 'default_primary_key'),
        default_secondary_connection_string=pulumi.get(__ret__, 'default_secondary_connection_string'),
        default_secondary_key=pulumi.get(__ret__, 'default_secondary_key'),
        endpoint=pulumi.get(__ret__, 'endpoint'),
        id=pulumi.get(__ret__, 'id'),
        location=pulumi.get(__ret__, 'location'),
        name=pulumi.get(__ret__, 'name'),
        premium_messaging_partitions=pulumi.get(__ret__, 'premium_messaging_partitions'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'),
        sku=pulumi.get(__ret__, 'sku'),
        tags=pulumi.get(__ret__, 'tags'))
def get_service_bus_namespace_output(name: Optional[pulumi.Input[builtins.str]] = None,
                                     resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetServiceBusNamespaceResult]:
    """
    Use this data source to access information about an existing ServiceBus Namespace.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.servicebus.get_namespace(name="examplenamespace",
        resource_group_name="example-resources")
    pulumi.export("location", example.location)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.ServiceBus`: 2022-10-01-preview, 2021-06-01-preview


    :param builtins.str name: Specifies the name of the ServiceBus Namespace.
    :param builtins.str resource_group_name: Specifies the name of the Resource Group where the ServiceBus Namespace exists.
    """
    pulumi.log.warn("""get_service_bus_namespace is deprecated: azure.eventhub.getServiceBusNamespace has been deprecated in favor of azure.servicebus.getNamespace""")
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:eventhub/getServiceBusNamespace:getServiceBusNamespace', __args__, opts=opts, typ=GetServiceBusNamespaceResult)
    return __ret__.apply(lambda __response__: GetServiceBusNamespaceResult(
        capacity=pulumi.get(__response__, 'capacity'),
        default_primary_connection_string=pulumi.get(__response__, 'default_primary_connection_string'),
        default_primary_key=pulumi.get(__response__, 'default_primary_key'),
        default_secondary_connection_string=pulumi.get(__response__, 'default_secondary_connection_string'),
        default_secondary_key=pulumi.get(__response__, 'default_secondary_key'),
        endpoint=pulumi.get(__response__, 'endpoint'),
        id=pulumi.get(__response__, 'id'),
        location=pulumi.get(__response__, 'location'),
        name=pulumi.get(__response__, 'name'),
        premium_messaging_partitions=pulumi.get(__response__, 'premium_messaging_partitions'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name'),
        sku=pulumi.get(__response__, 'sku'),
        tags=pulumi.get(__response__, 'tags')))
