# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['NamespaceCustomerManagedKeyInitArgs', 'NamespaceCustomerManagedKey']

@pulumi.input_type
class NamespaceCustomerManagedKeyInitArgs:
    def __init__(__self__, *,
                 eventhub_namespace_id: pulumi.Input[builtins.str],
                 key_vault_key_ids: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 infrastructure_encryption_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 user_assigned_identity_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a NamespaceCustomerManagedKey resource.
        :param pulumi.Input[builtins.str] eventhub_namespace_id: The ID of the EventHub Namespace. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] key_vault_key_ids: The list of keys of Key Vault.
        :param pulumi.Input[builtins.bool] infrastructure_encryption_enabled: Whether to enable Infrastructure Encryption (Double Encryption). Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] user_assigned_identity_id: The ID of a User Managed Identity that will be used to access Key Vaults that contain the encryption keys.
               
               > **Note:** If using `user_assigned_identity_id`, ensure the User Assigned Identity is also assigned to the parent Event Hub.
               
               > **Note:** If using `user_assigned_identity_id`, make sure to assign the identity the appropriate permissions to access the Key Vault key. Failure to grant `Get, UnwrapKey, and WrapKey` will cause this resource to fail to apply.
        """
        pulumi.set(__self__, "eventhub_namespace_id", eventhub_namespace_id)
        pulumi.set(__self__, "key_vault_key_ids", key_vault_key_ids)
        if infrastructure_encryption_enabled is not None:
            pulumi.set(__self__, "infrastructure_encryption_enabled", infrastructure_encryption_enabled)
        if user_assigned_identity_id is not None:
            pulumi.set(__self__, "user_assigned_identity_id", user_assigned_identity_id)

    @property
    @pulumi.getter(name="eventhubNamespaceId")
    def eventhub_namespace_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the EventHub Namespace. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "eventhub_namespace_id")

    @eventhub_namespace_id.setter
    def eventhub_namespace_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "eventhub_namespace_id", value)

    @property
    @pulumi.getter(name="keyVaultKeyIds")
    def key_vault_key_ids(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        The list of keys of Key Vault.
        """
        return pulumi.get(self, "key_vault_key_ids")

    @key_vault_key_ids.setter
    def key_vault_key_ids(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "key_vault_key_ids", value)

    @property
    @pulumi.getter(name="infrastructureEncryptionEnabled")
    def infrastructure_encryption_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to enable Infrastructure Encryption (Double Encryption). Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "infrastructure_encryption_enabled")

    @infrastructure_encryption_enabled.setter
    def infrastructure_encryption_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "infrastructure_encryption_enabled", value)

    @property
    @pulumi.getter(name="userAssignedIdentityId")
    def user_assigned_identity_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of a User Managed Identity that will be used to access Key Vaults that contain the encryption keys.

        > **Note:** If using `user_assigned_identity_id`, ensure the User Assigned Identity is also assigned to the parent Event Hub.

        > **Note:** If using `user_assigned_identity_id`, make sure to assign the identity the appropriate permissions to access the Key Vault key. Failure to grant `Get, UnwrapKey, and WrapKey` will cause this resource to fail to apply.
        """
        return pulumi.get(self, "user_assigned_identity_id")

    @user_assigned_identity_id.setter
    def user_assigned_identity_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "user_assigned_identity_id", value)


@pulumi.input_type
class _NamespaceCustomerManagedKeyState:
    def __init__(__self__, *,
                 eventhub_namespace_id: Optional[pulumi.Input[builtins.str]] = None,
                 infrastructure_encryption_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 key_vault_key_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 user_assigned_identity_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering NamespaceCustomerManagedKey resources.
        :param pulumi.Input[builtins.str] eventhub_namespace_id: The ID of the EventHub Namespace. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] infrastructure_encryption_enabled: Whether to enable Infrastructure Encryption (Double Encryption). Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] key_vault_key_ids: The list of keys of Key Vault.
        :param pulumi.Input[builtins.str] user_assigned_identity_id: The ID of a User Managed Identity that will be used to access Key Vaults that contain the encryption keys.
               
               > **Note:** If using `user_assigned_identity_id`, ensure the User Assigned Identity is also assigned to the parent Event Hub.
               
               > **Note:** If using `user_assigned_identity_id`, make sure to assign the identity the appropriate permissions to access the Key Vault key. Failure to grant `Get, UnwrapKey, and WrapKey` will cause this resource to fail to apply.
        """
        if eventhub_namespace_id is not None:
            pulumi.set(__self__, "eventhub_namespace_id", eventhub_namespace_id)
        if infrastructure_encryption_enabled is not None:
            pulumi.set(__self__, "infrastructure_encryption_enabled", infrastructure_encryption_enabled)
        if key_vault_key_ids is not None:
            pulumi.set(__self__, "key_vault_key_ids", key_vault_key_ids)
        if user_assigned_identity_id is not None:
            pulumi.set(__self__, "user_assigned_identity_id", user_assigned_identity_id)

    @property
    @pulumi.getter(name="eventhubNamespaceId")
    def eventhub_namespace_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the EventHub Namespace. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "eventhub_namespace_id")

    @eventhub_namespace_id.setter
    def eventhub_namespace_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "eventhub_namespace_id", value)

    @property
    @pulumi.getter(name="infrastructureEncryptionEnabled")
    def infrastructure_encryption_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to enable Infrastructure Encryption (Double Encryption). Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "infrastructure_encryption_enabled")

    @infrastructure_encryption_enabled.setter
    def infrastructure_encryption_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "infrastructure_encryption_enabled", value)

    @property
    @pulumi.getter(name="keyVaultKeyIds")
    def key_vault_key_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The list of keys of Key Vault.
        """
        return pulumi.get(self, "key_vault_key_ids")

    @key_vault_key_ids.setter
    def key_vault_key_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "key_vault_key_ids", value)

    @property
    @pulumi.getter(name="userAssignedIdentityId")
    def user_assigned_identity_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of a User Managed Identity that will be used to access Key Vaults that contain the encryption keys.

        > **Note:** If using `user_assigned_identity_id`, ensure the User Assigned Identity is also assigned to the parent Event Hub.

        > **Note:** If using `user_assigned_identity_id`, make sure to assign the identity the appropriate permissions to access the Key Vault key. Failure to grant `Get, UnwrapKey, and WrapKey` will cause this resource to fail to apply.
        """
        return pulumi.get(self, "user_assigned_identity_id")

    @user_assigned_identity_id.setter
    def user_assigned_identity_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "user_assigned_identity_id", value)


@pulumi.type_token("azure:eventhub/namespaceCustomerManagedKey:NamespaceCustomerManagedKey")
class NamespaceCustomerManagedKey(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 eventhub_namespace_id: Optional[pulumi.Input[builtins.str]] = None,
                 infrastructure_encryption_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 key_vault_key_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 user_assigned_identity_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages a Customer Managed Key for a EventHub Namespace.

        !> **Note:** In 2.x versions of the Azure Provider during deletion this resource will **delete and recreate the parent EventHub Namespace which may involve data loss** as it's not possible to remove the Customer Managed Key from the EventHub Namespace once it's been added. Version 3.0 of the Azure Provider will change this so that the Delete operation is a noop, requiring the parent EventHub Namespace is deleted/recreated to remove the Customer Managed Key.

        ## Example Usage

        ### With System Assigned Identity

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_cluster = azure.eventhub.Cluster("example",
            name="example-cluster",
            resource_group_name=example.name,
            location=example.location,
            sku_name="Dedicated_1")
        example_event_hub_namespace = azure.eventhub.EventHubNamespace("example",
            name="example-namespace",
            location=example.location,
            resource_group_name=example.name,
            sku="Standard",
            dedicated_cluster_id=example_cluster.id,
            identity={
                "type": "SystemAssigned",
            })
        current = azure.core.get_client_config()
        example_key_vault = azure.keyvault.KeyVault("example",
            name="examplekv",
            location=example.location,
            resource_group_name=example.name,
            tenant_id=current.tenant_id,
            sku_name="standard",
            purge_protection_enabled=True)
        example_access_policy = azure.keyvault.AccessPolicy("example",
            key_vault_id=example_key_vault.id,
            tenant_id=example_event_hub_namespace.identity.tenant_id,
            object_id=example_event_hub_namespace.identity.principal_id,
            key_permissions=[
                "Get",
                "UnwrapKey",
                "WrapKey",
            ])
        example2 = azure.keyvault.AccessPolicy("example2",
            key_vault_id=example_key_vault.id,
            tenant_id=current.tenant_id,
            object_id=current.object_id,
            key_permissions=[
                "Create",
                "Delete",
                "Get",
                "List",
                "Purge",
                "Recover",
                "GetRotationPolicy",
            ])
        example_key = azure.keyvault.Key("example",
            name="examplekvkey",
            key_vault_id=example_key_vault.id,
            key_type="RSA",
            key_size=2048,
            key_opts=[
                "decrypt",
                "encrypt",
                "sign",
                "unwrapKey",
                "verify",
                "wrapKey",
            ],
            opts = pulumi.ResourceOptions(depends_on=[
                    example_access_policy,
                    example2,
                ]))
        example_namespace_customer_managed_key = azure.eventhub.NamespaceCustomerManagedKey("example",
            eventhub_namespace_id=example_event_hub_namespace.id,
            key_vault_key_ids=[example_key.id])
        ```

        ### With User Assigned Identity

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_cluster = azure.eventhub.Cluster("example",
            name="example-cluster",
            resource_group_name=example.name,
            location=example.location,
            sku_name="Dedicated_1")
        example_user_assigned_identity = azure.authorization.UserAssignedIdentity("example",
            location=example.location,
            name="example",
            resource_group_name=example.name)
        example_event_hub_namespace = azure.eventhub.EventHubNamespace("example",
            name="example-namespace",
            location=example.location,
            resource_group_name=example.name,
            sku="Standard",
            dedicated_cluster_id=example_cluster.id,
            identity={
                "type": "UserAssigned",
                "identity_ids": [example_user_assigned_identity.id],
            })
        current = azure.core.get_client_config()
        example_key_vault = azure.keyvault.KeyVault("example",
            name="examplekv",
            location=example.location,
            resource_group_name=example.name,
            tenant_id=current.tenant_id,
            sku_name="standard",
            purge_protection_enabled=True)
        example_access_policy = azure.keyvault.AccessPolicy("example",
            key_vault_id=example_key_vault.id,
            tenant_id=test["tenantId"],
            object_id=test["principalId"],
            key_permissions=[
                "Get",
                "UnwrapKey",
                "WrapKey",
            ])
        example2 = azure.keyvault.AccessPolicy("example2",
            key_vault_id=example_key_vault.id,
            tenant_id=current.tenant_id,
            object_id=current.object_id,
            key_permissions=[
                "Create",
                "Delete",
                "Get",
                "List",
                "Purge",
                "Recover",
                "GetRotationPolicy",
            ])
        example_key = azure.keyvault.Key("example",
            name="examplekvkey",
            key_vault_id=example_key_vault.id,
            key_type="RSA",
            key_size=2048,
            key_opts=[
                "decrypt",
                "encrypt",
                "sign",
                "unwrapKey",
                "verify",
                "wrapKey",
            ],
            opts = pulumi.ResourceOptions(depends_on=[
                    example_access_policy,
                    example2,
                ]))
        example_namespace_customer_managed_key = azure.eventhub.NamespaceCustomerManagedKey("example",
            eventhub_namespace_id=example_event_hub_namespace.id,
            key_vault_key_ids=[example_key.id],
            user_assigned_identity_id=example_user_assigned_identity.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.EventHub`: 2024-01-01

        ## Import

        Customer Managed Keys for a EventHub Namespace can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:eventhub/namespaceCustomerManagedKey:NamespaceCustomerManagedKey example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.EventHub/namespaces/namespace1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] eventhub_namespace_id: The ID of the EventHub Namespace. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] infrastructure_encryption_enabled: Whether to enable Infrastructure Encryption (Double Encryption). Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] key_vault_key_ids: The list of keys of Key Vault.
        :param pulumi.Input[builtins.str] user_assigned_identity_id: The ID of a User Managed Identity that will be used to access Key Vaults that contain the encryption keys.
               
               > **Note:** If using `user_assigned_identity_id`, ensure the User Assigned Identity is also assigned to the parent Event Hub.
               
               > **Note:** If using `user_assigned_identity_id`, make sure to assign the identity the appropriate permissions to access the Key Vault key. Failure to grant `Get, UnwrapKey, and WrapKey` will cause this resource to fail to apply.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NamespaceCustomerManagedKeyInitArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Customer Managed Key for a EventHub Namespace.

        !> **Note:** In 2.x versions of the Azure Provider during deletion this resource will **delete and recreate the parent EventHub Namespace which may involve data loss** as it's not possible to remove the Customer Managed Key from the EventHub Namespace once it's been added. Version 3.0 of the Azure Provider will change this so that the Delete operation is a noop, requiring the parent EventHub Namespace is deleted/recreated to remove the Customer Managed Key.

        ## Example Usage

        ### With System Assigned Identity

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_cluster = azure.eventhub.Cluster("example",
            name="example-cluster",
            resource_group_name=example.name,
            location=example.location,
            sku_name="Dedicated_1")
        example_event_hub_namespace = azure.eventhub.EventHubNamespace("example",
            name="example-namespace",
            location=example.location,
            resource_group_name=example.name,
            sku="Standard",
            dedicated_cluster_id=example_cluster.id,
            identity={
                "type": "SystemAssigned",
            })
        current = azure.core.get_client_config()
        example_key_vault = azure.keyvault.KeyVault("example",
            name="examplekv",
            location=example.location,
            resource_group_name=example.name,
            tenant_id=current.tenant_id,
            sku_name="standard",
            purge_protection_enabled=True)
        example_access_policy = azure.keyvault.AccessPolicy("example",
            key_vault_id=example_key_vault.id,
            tenant_id=example_event_hub_namespace.identity.tenant_id,
            object_id=example_event_hub_namespace.identity.principal_id,
            key_permissions=[
                "Get",
                "UnwrapKey",
                "WrapKey",
            ])
        example2 = azure.keyvault.AccessPolicy("example2",
            key_vault_id=example_key_vault.id,
            tenant_id=current.tenant_id,
            object_id=current.object_id,
            key_permissions=[
                "Create",
                "Delete",
                "Get",
                "List",
                "Purge",
                "Recover",
                "GetRotationPolicy",
            ])
        example_key = azure.keyvault.Key("example",
            name="examplekvkey",
            key_vault_id=example_key_vault.id,
            key_type="RSA",
            key_size=2048,
            key_opts=[
                "decrypt",
                "encrypt",
                "sign",
                "unwrapKey",
                "verify",
                "wrapKey",
            ],
            opts = pulumi.ResourceOptions(depends_on=[
                    example_access_policy,
                    example2,
                ]))
        example_namespace_customer_managed_key = azure.eventhub.NamespaceCustomerManagedKey("example",
            eventhub_namespace_id=example_event_hub_namespace.id,
            key_vault_key_ids=[example_key.id])
        ```

        ### With User Assigned Identity

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_cluster = azure.eventhub.Cluster("example",
            name="example-cluster",
            resource_group_name=example.name,
            location=example.location,
            sku_name="Dedicated_1")
        example_user_assigned_identity = azure.authorization.UserAssignedIdentity("example",
            location=example.location,
            name="example",
            resource_group_name=example.name)
        example_event_hub_namespace = azure.eventhub.EventHubNamespace("example",
            name="example-namespace",
            location=example.location,
            resource_group_name=example.name,
            sku="Standard",
            dedicated_cluster_id=example_cluster.id,
            identity={
                "type": "UserAssigned",
                "identity_ids": [example_user_assigned_identity.id],
            })
        current = azure.core.get_client_config()
        example_key_vault = azure.keyvault.KeyVault("example",
            name="examplekv",
            location=example.location,
            resource_group_name=example.name,
            tenant_id=current.tenant_id,
            sku_name="standard",
            purge_protection_enabled=True)
        example_access_policy = azure.keyvault.AccessPolicy("example",
            key_vault_id=example_key_vault.id,
            tenant_id=test["tenantId"],
            object_id=test["principalId"],
            key_permissions=[
                "Get",
                "UnwrapKey",
                "WrapKey",
            ])
        example2 = azure.keyvault.AccessPolicy("example2",
            key_vault_id=example_key_vault.id,
            tenant_id=current.tenant_id,
            object_id=current.object_id,
            key_permissions=[
                "Create",
                "Delete",
                "Get",
                "List",
                "Purge",
                "Recover",
                "GetRotationPolicy",
            ])
        example_key = azure.keyvault.Key("example",
            name="examplekvkey",
            key_vault_id=example_key_vault.id,
            key_type="RSA",
            key_size=2048,
            key_opts=[
                "decrypt",
                "encrypt",
                "sign",
                "unwrapKey",
                "verify",
                "wrapKey",
            ],
            opts = pulumi.ResourceOptions(depends_on=[
                    example_access_policy,
                    example2,
                ]))
        example_namespace_customer_managed_key = azure.eventhub.NamespaceCustomerManagedKey("example",
            eventhub_namespace_id=example_event_hub_namespace.id,
            key_vault_key_ids=[example_key.id],
            user_assigned_identity_id=example_user_assigned_identity.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.EventHub`: 2024-01-01

        ## Import

        Customer Managed Keys for a EventHub Namespace can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:eventhub/namespaceCustomerManagedKey:NamespaceCustomerManagedKey example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.EventHub/namespaces/namespace1
        ```

        :param str resource_name: The name of the resource.
        :param NamespaceCustomerManagedKeyInitArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NamespaceCustomerManagedKeyInitArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 eventhub_namespace_id: Optional[pulumi.Input[builtins.str]] = None,
                 infrastructure_encryption_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 key_vault_key_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 user_assigned_identity_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NamespaceCustomerManagedKeyInitArgs.__new__(NamespaceCustomerManagedKeyInitArgs)

            if eventhub_namespace_id is None and not opts.urn:
                raise TypeError("Missing required property 'eventhub_namespace_id'")
            __props__.__dict__["eventhub_namespace_id"] = eventhub_namespace_id
            __props__.__dict__["infrastructure_encryption_enabled"] = infrastructure_encryption_enabled
            if key_vault_key_ids is None and not opts.urn:
                raise TypeError("Missing required property 'key_vault_key_ids'")
            __props__.__dict__["key_vault_key_ids"] = key_vault_key_ids
            __props__.__dict__["user_assigned_identity_id"] = user_assigned_identity_id
        super(NamespaceCustomerManagedKey, __self__).__init__(
            'azure:eventhub/namespaceCustomerManagedKey:NamespaceCustomerManagedKey',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            eventhub_namespace_id: Optional[pulumi.Input[builtins.str]] = None,
            infrastructure_encryption_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            key_vault_key_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            user_assigned_identity_id: Optional[pulumi.Input[builtins.str]] = None) -> 'NamespaceCustomerManagedKey':
        """
        Get an existing NamespaceCustomerManagedKey resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] eventhub_namespace_id: The ID of the EventHub Namespace. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] infrastructure_encryption_enabled: Whether to enable Infrastructure Encryption (Double Encryption). Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] key_vault_key_ids: The list of keys of Key Vault.
        :param pulumi.Input[builtins.str] user_assigned_identity_id: The ID of a User Managed Identity that will be used to access Key Vaults that contain the encryption keys.
               
               > **Note:** If using `user_assigned_identity_id`, ensure the User Assigned Identity is also assigned to the parent Event Hub.
               
               > **Note:** If using `user_assigned_identity_id`, make sure to assign the identity the appropriate permissions to access the Key Vault key. Failure to grant `Get, UnwrapKey, and WrapKey` will cause this resource to fail to apply.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NamespaceCustomerManagedKeyState.__new__(_NamespaceCustomerManagedKeyState)

        __props__.__dict__["eventhub_namespace_id"] = eventhub_namespace_id
        __props__.__dict__["infrastructure_encryption_enabled"] = infrastructure_encryption_enabled
        __props__.__dict__["key_vault_key_ids"] = key_vault_key_ids
        __props__.__dict__["user_assigned_identity_id"] = user_assigned_identity_id
        return NamespaceCustomerManagedKey(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="eventhubNamespaceId")
    def eventhub_namespace_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the EventHub Namespace. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "eventhub_namespace_id")

    @property
    @pulumi.getter(name="infrastructureEncryptionEnabled")
    def infrastructure_encryption_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether to enable Infrastructure Encryption (Double Encryption). Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "infrastructure_encryption_enabled")

    @property
    @pulumi.getter(name="keyVaultKeyIds")
    def key_vault_key_ids(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        The list of keys of Key Vault.
        """
        return pulumi.get(self, "key_vault_key_ids")

    @property
    @pulumi.getter(name="userAssignedIdentityId")
    def user_assigned_identity_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The ID of a User Managed Identity that will be used to access Key Vaults that contain the encryption keys.

        > **Note:** If using `user_assigned_identity_id`, ensure the User Assigned Identity is also assigned to the parent Event Hub.

        > **Note:** If using `user_assigned_identity_id`, make sure to assign the identity the appropriate permissions to access the Key Vault key. Failure to grant `Get, UnwrapKey, and WrapKey` will cause this resource to fail to apply.
        """
        return pulumi.get(self, "user_assigned_identity_id")

