# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetCircuitPeeringResult',
    'AwaitableGetCircuitPeeringResult',
    'get_circuit_peering',
    'get_circuit_peering_output',
]

@pulumi.output_type
class GetCircuitPeeringResult:
    """
    A collection of values returned by getCircuitPeering.
    """
    def __init__(__self__, azure_asn=None, express_route_circuit_name=None, gateway_manager_etag=None, id=None, ipv4_enabled=None, peer_asn=None, peering_type=None, primary_azure_port=None, primary_peer_address_prefix=None, resource_group_name=None, route_filter_id=None, secondary_azure_port=None, secondary_peer_address_prefix=None, shared_key=None, vlan_id=None):
        if azure_asn and not isinstance(azure_asn, int):
            raise TypeError("Expected argument 'azure_asn' to be a int")
        pulumi.set(__self__, "azure_asn", azure_asn)
        if express_route_circuit_name and not isinstance(express_route_circuit_name, str):
            raise TypeError("Expected argument 'express_route_circuit_name' to be a str")
        pulumi.set(__self__, "express_route_circuit_name", express_route_circuit_name)
        if gateway_manager_etag and not isinstance(gateway_manager_etag, str):
            raise TypeError("Expected argument 'gateway_manager_etag' to be a str")
        pulumi.set(__self__, "gateway_manager_etag", gateway_manager_etag)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ipv4_enabled and not isinstance(ipv4_enabled, bool):
            raise TypeError("Expected argument 'ipv4_enabled' to be a bool")
        pulumi.set(__self__, "ipv4_enabled", ipv4_enabled)
        if peer_asn and not isinstance(peer_asn, int):
            raise TypeError("Expected argument 'peer_asn' to be a int")
        pulumi.set(__self__, "peer_asn", peer_asn)
        if peering_type and not isinstance(peering_type, str):
            raise TypeError("Expected argument 'peering_type' to be a str")
        pulumi.set(__self__, "peering_type", peering_type)
        if primary_azure_port and not isinstance(primary_azure_port, str):
            raise TypeError("Expected argument 'primary_azure_port' to be a str")
        pulumi.set(__self__, "primary_azure_port", primary_azure_port)
        if primary_peer_address_prefix and not isinstance(primary_peer_address_prefix, str):
            raise TypeError("Expected argument 'primary_peer_address_prefix' to be a str")
        pulumi.set(__self__, "primary_peer_address_prefix", primary_peer_address_prefix)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if route_filter_id and not isinstance(route_filter_id, str):
            raise TypeError("Expected argument 'route_filter_id' to be a str")
        pulumi.set(__self__, "route_filter_id", route_filter_id)
        if secondary_azure_port and not isinstance(secondary_azure_port, str):
            raise TypeError("Expected argument 'secondary_azure_port' to be a str")
        pulumi.set(__self__, "secondary_azure_port", secondary_azure_port)
        if secondary_peer_address_prefix and not isinstance(secondary_peer_address_prefix, str):
            raise TypeError("Expected argument 'secondary_peer_address_prefix' to be a str")
        pulumi.set(__self__, "secondary_peer_address_prefix", secondary_peer_address_prefix)
        if shared_key and not isinstance(shared_key, str):
            raise TypeError("Expected argument 'shared_key' to be a str")
        pulumi.set(__self__, "shared_key", shared_key)
        if vlan_id and not isinstance(vlan_id, int):
            raise TypeError("Expected argument 'vlan_id' to be a int")
        pulumi.set(__self__, "vlan_id", vlan_id)

    @property
    @pulumi.getter(name="azureAsn")
    def azure_asn(self) -> builtins.int:
        """
        The ASN used by Azure for the peering.
        """
        return pulumi.get(self, "azure_asn")

    @property
    @pulumi.getter(name="expressRouteCircuitName")
    def express_route_circuit_name(self) -> builtins.str:
        return pulumi.get(self, "express_route_circuit_name")

    @property
    @pulumi.getter(name="gatewayManagerEtag")
    def gateway_manager_etag(self) -> builtins.str:
        return pulumi.get(self, "gateway_manager_etag")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipv4Enabled")
    def ipv4_enabled(self) -> builtins.bool:
        """
        Indicates if IPv4 is enabled.
        """
        return pulumi.get(self, "ipv4_enabled")

    @property
    @pulumi.getter(name="peerAsn")
    def peer_asn(self) -> builtins.int:
        return pulumi.get(self, "peer_asn")

    @property
    @pulumi.getter(name="peeringType")
    def peering_type(self) -> builtins.str:
        """
        The type of the ExpressRoute Circuit Peering.
        """
        return pulumi.get(self, "peering_type")

    @property
    @pulumi.getter(name="primaryAzurePort")
    def primary_azure_port(self) -> builtins.str:
        """
        The primary port used by Azure for this peering.
        """
        return pulumi.get(self, "primary_azure_port")

    @property
    @pulumi.getter(name="primaryPeerAddressPrefix")
    def primary_peer_address_prefix(self) -> builtins.str:
        """
        The primary peer address prefix.
        """
        return pulumi.get(self, "primary_peer_address_prefix")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> builtins.str:
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter(name="routeFilterId")
    def route_filter_id(self) -> builtins.str:
        return pulumi.get(self, "route_filter_id")

    @property
    @pulumi.getter(name="secondaryAzurePort")
    def secondary_azure_port(self) -> builtins.str:
        """
        The secondary port used by Azure for this peering.
        """
        return pulumi.get(self, "secondary_azure_port")

    @property
    @pulumi.getter(name="secondaryPeerAddressPrefix")
    def secondary_peer_address_prefix(self) -> builtins.str:
        """
        The secondary peer address prefix.
        """
        return pulumi.get(self, "secondary_peer_address_prefix")

    @property
    @pulumi.getter(name="sharedKey")
    def shared_key(self) -> builtins.str:
        return pulumi.get(self, "shared_key")

    @property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> builtins.int:
        """
        The VLAN ID used for this peering.
        """
        return pulumi.get(self, "vlan_id")


class AwaitableGetCircuitPeeringResult(GetCircuitPeeringResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCircuitPeeringResult(
            azure_asn=self.azure_asn,
            express_route_circuit_name=self.express_route_circuit_name,
            gateway_manager_etag=self.gateway_manager_etag,
            id=self.id,
            ipv4_enabled=self.ipv4_enabled,
            peer_asn=self.peer_asn,
            peering_type=self.peering_type,
            primary_azure_port=self.primary_azure_port,
            primary_peer_address_prefix=self.primary_peer_address_prefix,
            resource_group_name=self.resource_group_name,
            route_filter_id=self.route_filter_id,
            secondary_azure_port=self.secondary_azure_port,
            secondary_peer_address_prefix=self.secondary_peer_address_prefix,
            shared_key=self.shared_key,
            vlan_id=self.vlan_id)


def get_circuit_peering(express_route_circuit_name: Optional[builtins.str] = None,
                        peering_type: Optional[builtins.str] = None,
                        resource_group_name: Optional[builtins.str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCircuitPeeringResult:
    """
    Use this data source to access information about an existing ExpressRoute Circuit Peering.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.expressroute.get_circuit_peering(peering_type="example-peering",
        express_route_circuit_name="example-expressroute",
        resource_group_name="example-resources")
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Network`: 2024-05-01


    :param builtins.str express_route_circuit_name: The name of the ExpressRoute Circuit in which to create the Peering. Changing this forces a new resource to be created.
    :param builtins.str peering_type: The type of the ExpressRoute Circuit Peering. Acceptable values include `AzurePrivatePeering`, `AzurePublicPeering` and `MicrosoftPeering`.
    :param builtins.str resource_group_name: The name of the resource group in which to create the Express Route Circuit Peering. Changing this forces a new resource to be created.
    """
    __args__ = dict()
    __args__['expressRouteCircuitName'] = express_route_circuit_name
    __args__['peeringType'] = peering_type
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:expressroute/getCircuitPeering:getCircuitPeering', __args__, opts=opts, typ=GetCircuitPeeringResult).value

    return AwaitableGetCircuitPeeringResult(
        azure_asn=pulumi.get(__ret__, 'azure_asn'),
        express_route_circuit_name=pulumi.get(__ret__, 'express_route_circuit_name'),
        gateway_manager_etag=pulumi.get(__ret__, 'gateway_manager_etag'),
        id=pulumi.get(__ret__, 'id'),
        ipv4_enabled=pulumi.get(__ret__, 'ipv4_enabled'),
        peer_asn=pulumi.get(__ret__, 'peer_asn'),
        peering_type=pulumi.get(__ret__, 'peering_type'),
        primary_azure_port=pulumi.get(__ret__, 'primary_azure_port'),
        primary_peer_address_prefix=pulumi.get(__ret__, 'primary_peer_address_prefix'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'),
        route_filter_id=pulumi.get(__ret__, 'route_filter_id'),
        secondary_azure_port=pulumi.get(__ret__, 'secondary_azure_port'),
        secondary_peer_address_prefix=pulumi.get(__ret__, 'secondary_peer_address_prefix'),
        shared_key=pulumi.get(__ret__, 'shared_key'),
        vlan_id=pulumi.get(__ret__, 'vlan_id'))
def get_circuit_peering_output(express_route_circuit_name: Optional[pulumi.Input[builtins.str]] = None,
                               peering_type: Optional[pulumi.Input[builtins.str]] = None,
                               resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCircuitPeeringResult]:
    """
    Use this data source to access information about an existing ExpressRoute Circuit Peering.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.expressroute.get_circuit_peering(peering_type="example-peering",
        express_route_circuit_name="example-expressroute",
        resource_group_name="example-resources")
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Network`: 2024-05-01


    :param builtins.str express_route_circuit_name: The name of the ExpressRoute Circuit in which to create the Peering. Changing this forces a new resource to be created.
    :param builtins.str peering_type: The type of the ExpressRoute Circuit Peering. Acceptable values include `AzurePrivatePeering`, `AzurePublicPeering` and `MicrosoftPeering`.
    :param builtins.str resource_group_name: The name of the resource group in which to create the Express Route Circuit Peering. Changing this forces a new resource to be created.
    """
    __args__ = dict()
    __args__['expressRouteCircuitName'] = express_route_circuit_name
    __args__['peeringType'] = peering_type
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:expressroute/getCircuitPeering:getCircuitPeering', __args__, opts=opts, typ=GetCircuitPeeringResult)
    return __ret__.apply(lambda __response__: GetCircuitPeeringResult(
        azure_asn=pulumi.get(__response__, 'azure_asn'),
        express_route_circuit_name=pulumi.get(__response__, 'express_route_circuit_name'),
        gateway_manager_etag=pulumi.get(__response__, 'gateway_manager_etag'),
        id=pulumi.get(__response__, 'id'),
        ipv4_enabled=pulumi.get(__response__, 'ipv4_enabled'),
        peer_asn=pulumi.get(__response__, 'peer_asn'),
        peering_type=pulumi.get(__response__, 'peering_type'),
        primary_azure_port=pulumi.get(__response__, 'primary_azure_port'),
        primary_peer_address_prefix=pulumi.get(__response__, 'primary_peer_address_prefix'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name'),
        route_filter_id=pulumi.get(__response__, 'route_filter_id'),
        secondary_azure_port=pulumi.get(__response__, 'secondary_azure_port'),
        secondary_peer_address_prefix=pulumi.get(__response__, 'secondary_peer_address_prefix'),
        shared_key=pulumi.get(__response__, 'shared_key'),
        vlan_id=pulumi.get(__response__, 'vlan_id')))
