# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CustomLocationArgs', 'CustomLocation']

@pulumi.input_type
class CustomLocationArgs:
    def __init__(__self__, *,
                 cluster_extension_ids: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 host_resource_id: pulumi.Input[builtins.str],
                 namespace: pulumi.Input[builtins.str],
                 resource_group_name: pulumi.Input[builtins.str],
                 authentication: Optional[pulumi.Input['CustomLocationAuthenticationArgs']] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 host_type: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a CustomLocation resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] cluster_extension_ids: Specifies the list of Cluster Extension IDs.
        :param pulumi.Input[builtins.str] host_resource_id: Specifies the host resource ID.
        :param pulumi.Input[builtins.str] namespace: Specifies the namespace of the Custom Location. Changing this forces a new Custom Location to be created.
        :param pulumi.Input[builtins.str] resource_group_name: Specifies the name of the Resource Group where the Custom Location should exist. Changing this forces a new Custom Location to be created.
        :param pulumi.Input['CustomLocationAuthenticationArgs'] authentication: An `authentication` block as defined below.
        :param pulumi.Input[builtins.str] display_name: Specifies the display name of the Custom Location.
        :param pulumi.Input[builtins.str] host_type: Specifies the host type of the Custom Location. The only possible values is `KubernetesCluster`.
        :param pulumi.Input[builtins.str] location: Specifies the Azure location where the Custom Location should exist. Changing this forces a new Custom Location to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name which should be used for this Custom Location. Changing this forces a new Custom Location to be created.
        """
        pulumi.set(__self__, "cluster_extension_ids", cluster_extension_ids)
        pulumi.set(__self__, "host_resource_id", host_resource_id)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if authentication is not None:
            pulumi.set(__self__, "authentication", authentication)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if host_type is not None:
            pulumi.set(__self__, "host_type", host_type)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="clusterExtensionIds")
    def cluster_extension_ids(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        Specifies the list of Cluster Extension IDs.
        """
        return pulumi.get(self, "cluster_extension_ids")

    @cluster_extension_ids.setter
    def cluster_extension_ids(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "cluster_extension_ids", value)

    @property
    @pulumi.getter(name="hostResourceId")
    def host_resource_id(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the host resource ID.
        """
        return pulumi.get(self, "host_resource_id")

    @host_resource_id.setter
    def host_resource_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "host_resource_id", value)

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the namespace of the Custom Location. Changing this forces a new Custom Location to be created.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the name of the Resource Group where the Custom Location should exist. Changing this forces a new Custom Location to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter
    def authentication(self) -> Optional[pulumi.Input['CustomLocationAuthenticationArgs']]:
        """
        An `authentication` block as defined below.
        """
        return pulumi.get(self, "authentication")

    @authentication.setter
    def authentication(self, value: Optional[pulumi.Input['CustomLocationAuthenticationArgs']]):
        pulumi.set(self, "authentication", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the display name of the Custom Location.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="hostType")
    def host_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the host type of the Custom Location. The only possible values is `KubernetesCluster`.
        """
        return pulumi.get(self, "host_type")

    @host_type.setter
    def host_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "host_type", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the Azure location where the Custom Location should exist. Changing this forces a new Custom Location to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name which should be used for this Custom Location. Changing this forces a new Custom Location to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _CustomLocationState:
    def __init__(__self__, *,
                 authentication: Optional[pulumi.Input['CustomLocationAuthenticationArgs']] = None,
                 cluster_extension_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 host_resource_id: Optional[pulumi.Input[builtins.str]] = None,
                 host_type: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 namespace: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering CustomLocation resources.
        :param pulumi.Input['CustomLocationAuthenticationArgs'] authentication: An `authentication` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] cluster_extension_ids: Specifies the list of Cluster Extension IDs.
        :param pulumi.Input[builtins.str] display_name: Specifies the display name of the Custom Location.
        :param pulumi.Input[builtins.str] host_resource_id: Specifies the host resource ID.
        :param pulumi.Input[builtins.str] host_type: Specifies the host type of the Custom Location. The only possible values is `KubernetesCluster`.
        :param pulumi.Input[builtins.str] location: Specifies the Azure location where the Custom Location should exist. Changing this forces a new Custom Location to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name which should be used for this Custom Location. Changing this forces a new Custom Location to be created.
        :param pulumi.Input[builtins.str] namespace: Specifies the namespace of the Custom Location. Changing this forces a new Custom Location to be created.
        :param pulumi.Input[builtins.str] resource_group_name: Specifies the name of the Resource Group where the Custom Location should exist. Changing this forces a new Custom Location to be created.
        """
        if authentication is not None:
            pulumi.set(__self__, "authentication", authentication)
        if cluster_extension_ids is not None:
            pulumi.set(__self__, "cluster_extension_ids", cluster_extension_ids)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if host_resource_id is not None:
            pulumi.set(__self__, "host_resource_id", host_resource_id)
        if host_type is not None:
            pulumi.set(__self__, "host_type", host_type)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)

    @property
    @pulumi.getter
    def authentication(self) -> Optional[pulumi.Input['CustomLocationAuthenticationArgs']]:
        """
        An `authentication` block as defined below.
        """
        return pulumi.get(self, "authentication")

    @authentication.setter
    def authentication(self, value: Optional[pulumi.Input['CustomLocationAuthenticationArgs']]):
        pulumi.set(self, "authentication", value)

    @property
    @pulumi.getter(name="clusterExtensionIds")
    def cluster_extension_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Specifies the list of Cluster Extension IDs.
        """
        return pulumi.get(self, "cluster_extension_ids")

    @cluster_extension_ids.setter
    def cluster_extension_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "cluster_extension_ids", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the display name of the Custom Location.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="hostResourceId")
    def host_resource_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the host resource ID.
        """
        return pulumi.get(self, "host_resource_id")

    @host_resource_id.setter
    def host_resource_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "host_resource_id", value)

    @property
    @pulumi.getter(name="hostType")
    def host_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the host type of the Custom Location. The only possible values is `KubernetesCluster`.
        """
        return pulumi.get(self, "host_type")

    @host_type.setter
    def host_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "host_type", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the Azure location where the Custom Location should exist. Changing this forces a new Custom Location to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name which should be used for this Custom Location. Changing this forces a new Custom Location to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the namespace of the Custom Location. Changing this forces a new Custom Location to be created.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the Resource Group where the Custom Location should exist. Changing this forces a new Custom Location to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_group_name", value)


@pulumi.type_token("azure:extendedlocation/customLocation:CustomLocation")
class CustomLocation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authentication: Optional[pulumi.Input[Union['CustomLocationAuthenticationArgs', 'CustomLocationAuthenticationArgsDict']]] = None,
                 cluster_extension_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 host_resource_id: Optional[pulumi.Input[builtins.str]] = None,
                 host_type: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 namespace: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages a Custom Location within an Extended Location.

        > **Note:** Installing and configuring the Azure Arc Agent on your Kubernetes Cluster to establish connectivity is outside the scope of this document. For more details refer to [Deploy agents to your cluster](https://learn.microsoft.com/en-us/azure/azure-arc/kubernetes/conceptual-agent-overview#deploy-agents-to-your-cluster) and [Connect an existing Kubernetes Cluster](https://learn.microsoft.com/en-us/azure/azure-arc/kubernetes/quickstart-connect-cluster?tabs=azure-cli#connect-an-existing-kubernetes-cluster). If you encounter issues connecting your Kubernetes Cluster to Azure Arc, we'd recommend opening a ticket with Microsoft Support.

        ## Import

        Custom Locations can be imported using the resource id, e.g.

        ```sh
        $ pulumi import azure:extendedlocation/customLocation:CustomLocation example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/example-resources/providers/Microsoft.ExtendedLocation/customLocations/example-custom-location
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['CustomLocationAuthenticationArgs', 'CustomLocationAuthenticationArgsDict']] authentication: An `authentication` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] cluster_extension_ids: Specifies the list of Cluster Extension IDs.
        :param pulumi.Input[builtins.str] display_name: Specifies the display name of the Custom Location.
        :param pulumi.Input[builtins.str] host_resource_id: Specifies the host resource ID.
        :param pulumi.Input[builtins.str] host_type: Specifies the host type of the Custom Location. The only possible values is `KubernetesCluster`.
        :param pulumi.Input[builtins.str] location: Specifies the Azure location where the Custom Location should exist. Changing this forces a new Custom Location to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name which should be used for this Custom Location. Changing this forces a new Custom Location to be created.
        :param pulumi.Input[builtins.str] namespace: Specifies the namespace of the Custom Location. Changing this forces a new Custom Location to be created.
        :param pulumi.Input[builtins.str] resource_group_name: Specifies the name of the Resource Group where the Custom Location should exist. Changing this forces a new Custom Location to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CustomLocationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Custom Location within an Extended Location.

        > **Note:** Installing and configuring the Azure Arc Agent on your Kubernetes Cluster to establish connectivity is outside the scope of this document. For more details refer to [Deploy agents to your cluster](https://learn.microsoft.com/en-us/azure/azure-arc/kubernetes/conceptual-agent-overview#deploy-agents-to-your-cluster) and [Connect an existing Kubernetes Cluster](https://learn.microsoft.com/en-us/azure/azure-arc/kubernetes/quickstart-connect-cluster?tabs=azure-cli#connect-an-existing-kubernetes-cluster). If you encounter issues connecting your Kubernetes Cluster to Azure Arc, we'd recommend opening a ticket with Microsoft Support.

        ## Import

        Custom Locations can be imported using the resource id, e.g.

        ```sh
        $ pulumi import azure:extendedlocation/customLocation:CustomLocation example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/example-resources/providers/Microsoft.ExtendedLocation/customLocations/example-custom-location
        ```

        :param str resource_name: The name of the resource.
        :param CustomLocationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CustomLocationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authentication: Optional[pulumi.Input[Union['CustomLocationAuthenticationArgs', 'CustomLocationAuthenticationArgsDict']]] = None,
                 cluster_extension_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 host_resource_id: Optional[pulumi.Input[builtins.str]] = None,
                 host_type: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 namespace: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CustomLocationArgs.__new__(CustomLocationArgs)

            __props__.__dict__["authentication"] = authentication
            if cluster_extension_ids is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_extension_ids'")
            __props__.__dict__["cluster_extension_ids"] = cluster_extension_ids
            __props__.__dict__["display_name"] = display_name
            if host_resource_id is None and not opts.urn:
                raise TypeError("Missing required property 'host_resource_id'")
            __props__.__dict__["host_resource_id"] = host_resource_id
            __props__.__dict__["host_type"] = host_type
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            if namespace is None and not opts.urn:
                raise TypeError("Missing required property 'namespace'")
            __props__.__dict__["namespace"] = namespace
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
        super(CustomLocation, __self__).__init__(
            'azure:extendedlocation/customLocation:CustomLocation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            authentication: Optional[pulumi.Input[Union['CustomLocationAuthenticationArgs', 'CustomLocationAuthenticationArgsDict']]] = None,
            cluster_extension_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            host_resource_id: Optional[pulumi.Input[builtins.str]] = None,
            host_type: Optional[pulumi.Input[builtins.str]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            namespace: Optional[pulumi.Input[builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[builtins.str]] = None) -> 'CustomLocation':
        """
        Get an existing CustomLocation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['CustomLocationAuthenticationArgs', 'CustomLocationAuthenticationArgsDict']] authentication: An `authentication` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] cluster_extension_ids: Specifies the list of Cluster Extension IDs.
        :param pulumi.Input[builtins.str] display_name: Specifies the display name of the Custom Location.
        :param pulumi.Input[builtins.str] host_resource_id: Specifies the host resource ID.
        :param pulumi.Input[builtins.str] host_type: Specifies the host type of the Custom Location. The only possible values is `KubernetesCluster`.
        :param pulumi.Input[builtins.str] location: Specifies the Azure location where the Custom Location should exist. Changing this forces a new Custom Location to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name which should be used for this Custom Location. Changing this forces a new Custom Location to be created.
        :param pulumi.Input[builtins.str] namespace: Specifies the namespace of the Custom Location. Changing this forces a new Custom Location to be created.
        :param pulumi.Input[builtins.str] resource_group_name: Specifies the name of the Resource Group where the Custom Location should exist. Changing this forces a new Custom Location to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CustomLocationState.__new__(_CustomLocationState)

        __props__.__dict__["authentication"] = authentication
        __props__.__dict__["cluster_extension_ids"] = cluster_extension_ids
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["host_resource_id"] = host_resource_id
        __props__.__dict__["host_type"] = host_type
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["resource_group_name"] = resource_group_name
        return CustomLocation(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def authentication(self) -> pulumi.Output[Optional['outputs.CustomLocationAuthentication']]:
        """
        An `authentication` block as defined below.
        """
        return pulumi.get(self, "authentication")

    @property
    @pulumi.getter(name="clusterExtensionIds")
    def cluster_extension_ids(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        Specifies the list of Cluster Extension IDs.
        """
        return pulumi.get(self, "cluster_extension_ids")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies the display name of the Custom Location.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="hostResourceId")
    def host_resource_id(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the host resource ID.
        """
        return pulumi.get(self, "host_resource_id")

    @property
    @pulumi.getter(name="hostType")
    def host_type(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies the host type of the Custom Location. The only possible values is `KubernetesCluster`.
        """
        return pulumi.get(self, "host_type")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the Azure location where the Custom Location should exist. Changing this forces a new Custom Location to be created.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the name which should be used for this Custom Location. Changing this forces a new Custom Location to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the namespace of the Custom Location. Changing this forces a new Custom Location to be created.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the name of the Resource Group where the Custom Location should exist. Changing this forces a new Custom Location to be created.
        """
        return pulumi.get(self, "resource_group_name")

