# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetCustomLocationResult',
    'AwaitableGetCustomLocationResult',
    'get_custom_location',
    'get_custom_location_output',
]

@pulumi.output_type
class GetCustomLocationResult:
    """
    A collection of values returned by getCustomLocation.
    """
    def __init__(__self__, authentications=None, cluster_extension_ids=None, display_name=None, host_resource_id=None, host_type=None, id=None, location=None, name=None, namespace=None, resource_group_name=None):
        if authentications and not isinstance(authentications, list):
            raise TypeError("Expected argument 'authentications' to be a list")
        pulumi.set(__self__, "authentications", authentications)
        if cluster_extension_ids and not isinstance(cluster_extension_ids, list):
            raise TypeError("Expected argument 'cluster_extension_ids' to be a list")
        pulumi.set(__self__, "cluster_extension_ids", cluster_extension_ids)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if host_resource_id and not isinstance(host_resource_id, str):
            raise TypeError("Expected argument 'host_resource_id' to be a str")
        pulumi.set(__self__, "host_resource_id", host_resource_id)
        if host_type and not isinstance(host_type, str):
            raise TypeError("Expected argument 'host_type' to be a str")
        pulumi.set(__self__, "host_type", host_type)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if namespace and not isinstance(namespace, str):
            raise TypeError("Expected argument 'namespace' to be a str")
        pulumi.set(__self__, "namespace", namespace)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)

    @property
    @pulumi.getter
    def authentications(self) -> Sequence['outputs.GetCustomLocationAuthenticationResult']:
        """
        An `authentication` block as defined below.
        """
        return pulumi.get(self, "authentications")

    @property
    @pulumi.getter(name="clusterExtensionIds")
    def cluster_extension_ids(self) -> Sequence[builtins.str]:
        """
        The list of Cluster Extension IDs.
        """
        return pulumi.get(self, "cluster_extension_ids")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        The display name of the Custom Location.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="hostResourceId")
    def host_resource_id(self) -> builtins.str:
        """
        The host resource ID.
        """
        return pulumi.get(self, "host_resource_id")

    @property
    @pulumi.getter(name="hostType")
    def host_type(self) -> builtins.str:
        """
        The host type of the Custom Location.
        """
        return pulumi.get(self, "host_type")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def location(self) -> builtins.str:
        """
        The Azure location where the Custom Location exists.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def namespace(self) -> builtins.str:
        """
        The namespace of the Custom Location.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> builtins.str:
        return pulumi.get(self, "resource_group_name")


class AwaitableGetCustomLocationResult(GetCustomLocationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCustomLocationResult(
            authentications=self.authentications,
            cluster_extension_ids=self.cluster_extension_ids,
            display_name=self.display_name,
            host_resource_id=self.host_resource_id,
            host_type=self.host_type,
            id=self.id,
            location=self.location,
            name=self.name,
            namespace=self.namespace,
            resource_group_name=self.resource_group_name)


def get_custom_location(name: Optional[builtins.str] = None,
                        resource_group_name: Optional[builtins.str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCustomLocationResult:
    """
    Use this data source to access information about an existing Custom Location within an Extended Location.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.extendedlocation.get_custom_location(name=example_azurerm_extended_location_custom_location["name"],
        resource_group_name=example_azurerm_resource_group["name"])
    pulumi.export("customLocationId", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.ExtendedLocation`: 2021-08-15


    :param builtins.str name: The name of the Custom Location.
    :param builtins.str resource_group_name: The name of the Resource Group where the Custom Location exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:extendedlocation/getCustomLocation:getCustomLocation', __args__, opts=opts, typ=GetCustomLocationResult).value

    return AwaitableGetCustomLocationResult(
        authentications=pulumi.get(__ret__, 'authentications'),
        cluster_extension_ids=pulumi.get(__ret__, 'cluster_extension_ids'),
        display_name=pulumi.get(__ret__, 'display_name'),
        host_resource_id=pulumi.get(__ret__, 'host_resource_id'),
        host_type=pulumi.get(__ret__, 'host_type'),
        id=pulumi.get(__ret__, 'id'),
        location=pulumi.get(__ret__, 'location'),
        name=pulumi.get(__ret__, 'name'),
        namespace=pulumi.get(__ret__, 'namespace'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'))
def get_custom_location_output(name: Optional[pulumi.Input[builtins.str]] = None,
                               resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCustomLocationResult]:
    """
    Use this data source to access information about an existing Custom Location within an Extended Location.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.extendedlocation.get_custom_location(name=example_azurerm_extended_location_custom_location["name"],
        resource_group_name=example_azurerm_resource_group["name"])
    pulumi.export("customLocationId", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.ExtendedLocation`: 2021-08-15


    :param builtins.str name: The name of the Custom Location.
    :param builtins.str resource_group_name: The name of the Resource Group where the Custom Location exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:extendedlocation/getCustomLocation:getCustomLocation', __args__, opts=opts, typ=GetCustomLocationResult)
    return __ret__.apply(lambda __response__: GetCustomLocationResult(
        authentications=pulumi.get(__response__, 'authentications'),
        cluster_extension_ids=pulumi.get(__response__, 'cluster_extension_ids'),
        display_name=pulumi.get(__response__, 'display_name'),
        host_resource_id=pulumi.get(__response__, 'host_resource_id'),
        host_type=pulumi.get(__response__, 'host_type'),
        id=pulumi.get(__response__, 'id'),
        location=pulumi.get(__response__, 'location'),
        name=pulumi.get(__response__, 'name'),
        namespace=pulumi.get(__response__, 'namespace'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name')))
