# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CapacityArgs', 'Capacity']

@pulumi.input_type
class CapacityArgs:
    def __init__(__self__, *,
                 resource_group_name: pulumi.Input[builtins.str],
                 sku: pulumi.Input['CapacitySkuArgs'],
                 administration_members: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a Capacity resource.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group in which to create the Fabric Capacity. Changing this forces a new resource to be created.
        :param pulumi.Input['CapacitySkuArgs'] sku: A `sku` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] administration_members: An array of administrator user identities. The member must be an Entra user or a service principal.
               
               > **Note:** If the member is an Entra user, use user principal name (UPN) format. If the user is a service principal, use object ID.
        :param pulumi.Input[builtins.str] location: The supported Azure location where the Fabric Capacity exists. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: The name which should be used for the Fabric Capacity. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the Fabric Capacity.
        """
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "sku", sku)
        if administration_members is not None:
            pulumi.set(__self__, "administration_members", administration_members)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the Resource Group in which to create the Fabric Capacity. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter
    def sku(self) -> pulumi.Input['CapacitySkuArgs']:
        """
        A `sku` block as defined below.
        """
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: pulumi.Input['CapacitySkuArgs']):
        pulumi.set(self, "sku", value)

    @property
    @pulumi.getter(name="administrationMembers")
    def administration_members(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        An array of administrator user identities. The member must be an Entra user or a service principal.

        > **Note:** If the member is an Entra user, use user principal name (UPN) format. If the user is a service principal, use object ID.
        """
        return pulumi.get(self, "administration_members")

    @administration_members.setter
    def administration_members(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "administration_members", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The supported Azure location where the Fabric Capacity exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name which should be used for the Fabric Capacity. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags to assign to the Fabric Capacity.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _CapacityState:
    def __init__(__self__, *,
                 administration_members: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 sku: Optional[pulumi.Input['CapacitySkuArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Capacity resources.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] administration_members: An array of administrator user identities. The member must be an Entra user or a service principal.
               
               > **Note:** If the member is an Entra user, use user principal name (UPN) format. If the user is a service principal, use object ID.
        :param pulumi.Input[builtins.str] location: The supported Azure location where the Fabric Capacity exists. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: The name which should be used for the Fabric Capacity. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group in which to create the Fabric Capacity. Changing this forces a new resource to be created.
        :param pulumi.Input['CapacitySkuArgs'] sku: A `sku` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the Fabric Capacity.
        """
        if administration_members is not None:
            pulumi.set(__self__, "administration_members", administration_members)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="administrationMembers")
    def administration_members(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        An array of administrator user identities. The member must be an Entra user or a service principal.

        > **Note:** If the member is an Entra user, use user principal name (UPN) format. If the user is a service principal, use object ID.
        """
        return pulumi.get(self, "administration_members")

    @administration_members.setter
    def administration_members(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "administration_members", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The supported Azure location where the Fabric Capacity exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name which should be used for the Fabric Capacity. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Resource Group in which to create the Fabric Capacity. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter
    def sku(self) -> Optional[pulumi.Input['CapacitySkuArgs']]:
        """
        A `sku` block as defined below.
        """
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: Optional[pulumi.Input['CapacitySkuArgs']]):
        pulumi.set(self, "sku", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags to assign to the Fabric Capacity.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("azure:fabric/capacity:Capacity")
class Capacity(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 administration_members: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 sku: Optional[pulumi.Input[Union['CapacitySkuArgs', 'CapacitySkuArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        Manages a Fabric Capacity.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        current = azure.core.get_client_config()
        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_capacity = azure.fabric.Capacity("example",
            name="exampleffc",
            resource_group_name=example.name,
            location="West Europe",
            administration_members=[current.object_id],
            sku={
                "name": "F32",
                "tier": "Fabric",
            },
            tags={
                "environment": "test",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Fabric`: 2023-11-01

        ## Import

        Fabric Capacities can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:fabric/capacity:Capacity example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.Fabric/capacities/capacity1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] administration_members: An array of administrator user identities. The member must be an Entra user or a service principal.
               
               > **Note:** If the member is an Entra user, use user principal name (UPN) format. If the user is a service principal, use object ID.
        :param pulumi.Input[builtins.str] location: The supported Azure location where the Fabric Capacity exists. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: The name which should be used for the Fabric Capacity. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group in which to create the Fabric Capacity. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['CapacitySkuArgs', 'CapacitySkuArgsDict']] sku: A `sku` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the Fabric Capacity.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CapacityArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Fabric Capacity.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        current = azure.core.get_client_config()
        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_capacity = azure.fabric.Capacity("example",
            name="exampleffc",
            resource_group_name=example.name,
            location="West Europe",
            administration_members=[current.object_id],
            sku={
                "name": "F32",
                "tier": "Fabric",
            },
            tags={
                "environment": "test",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Fabric`: 2023-11-01

        ## Import

        Fabric Capacities can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:fabric/capacity:Capacity example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.Fabric/capacities/capacity1
        ```

        :param str resource_name: The name of the resource.
        :param CapacityArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CapacityArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 administration_members: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 sku: Optional[pulumi.Input[Union['CapacitySkuArgs', 'CapacitySkuArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CapacityArgs.__new__(CapacityArgs)

            __props__.__dict__["administration_members"] = administration_members
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            if sku is None and not opts.urn:
                raise TypeError("Missing required property 'sku'")
            __props__.__dict__["sku"] = sku
            __props__.__dict__["tags"] = tags
        super(Capacity, __self__).__init__(
            'azure:fabric/capacity:Capacity',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            administration_members: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
            sku: Optional[pulumi.Input[Union['CapacitySkuArgs', 'CapacitySkuArgsDict']]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None) -> 'Capacity':
        """
        Get an existing Capacity resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] administration_members: An array of administrator user identities. The member must be an Entra user or a service principal.
               
               > **Note:** If the member is an Entra user, use user principal name (UPN) format. If the user is a service principal, use object ID.
        :param pulumi.Input[builtins.str] location: The supported Azure location where the Fabric Capacity exists. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: The name which should be used for the Fabric Capacity. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group in which to create the Fabric Capacity. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['CapacitySkuArgs', 'CapacitySkuArgsDict']] sku: A `sku` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the Fabric Capacity.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CapacityState.__new__(_CapacityState)

        __props__.__dict__["administration_members"] = administration_members
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["sku"] = sku
        __props__.__dict__["tags"] = tags
        return Capacity(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="administrationMembers")
    def administration_members(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        An array of administrator user identities. The member must be an Entra user or a service principal.

        > **Note:** If the member is an Entra user, use user principal name (UPN) format. If the user is a service principal, use object ID.
        """
        return pulumi.get(self, "administration_members")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        The supported Azure location where the Fabric Capacity exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name which should be used for the Fabric Capacity. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Resource Group in which to create the Fabric Capacity. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter
    def sku(self) -> pulumi.Output['outputs.CapacitySku']:
        """
        A `sku` block as defined below.
        """
        return pulumi.get(self, "sku")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A mapping of tags to assign to the Fabric Capacity.
        """
        return pulumi.get(self, "tags")

