# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CustomHttpsConfigurationArgs', 'CustomHttpsConfiguration']

@pulumi.input_type
class CustomHttpsConfigurationArgs:
    def __init__(__self__, *,
                 custom_https_provisioning_enabled: pulumi.Input[builtins.bool],
                 frontend_endpoint_id: pulumi.Input[builtins.str],
                 custom_https_configuration: Optional[pulumi.Input['CustomHttpsConfigurationCustomHttpsConfigurationArgs']] = None):
        """
        The set of arguments for constructing a CustomHttpsConfiguration resource.
        :param pulumi.Input[builtins.bool] custom_https_provisioning_enabled: Should the HTTPS protocol be enabled for this custom domain associated with the Front Door?
        :param pulumi.Input[builtins.str] frontend_endpoint_id: The ID of the Front Door Frontend Endpoint which this configuration refers to. Changing this forces a new resource to be created.
        :param pulumi.Input['CustomHttpsConfigurationCustomHttpsConfigurationArgs'] custom_https_configuration: A `custom_https_configuration` block as defined above.
        """
        pulumi.set(__self__, "custom_https_provisioning_enabled", custom_https_provisioning_enabled)
        pulumi.set(__self__, "frontend_endpoint_id", frontend_endpoint_id)
        if custom_https_configuration is not None:
            pulumi.set(__self__, "custom_https_configuration", custom_https_configuration)

    @property
    @pulumi.getter(name="customHttpsProvisioningEnabled")
    def custom_https_provisioning_enabled(self) -> pulumi.Input[builtins.bool]:
        """
        Should the HTTPS protocol be enabled for this custom domain associated with the Front Door?
        """
        return pulumi.get(self, "custom_https_provisioning_enabled")

    @custom_https_provisioning_enabled.setter
    def custom_https_provisioning_enabled(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "custom_https_provisioning_enabled", value)

    @property
    @pulumi.getter(name="frontendEndpointId")
    def frontend_endpoint_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the Front Door Frontend Endpoint which this configuration refers to. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "frontend_endpoint_id")

    @frontend_endpoint_id.setter
    def frontend_endpoint_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "frontend_endpoint_id", value)

    @property
    @pulumi.getter(name="customHttpsConfiguration")
    def custom_https_configuration(self) -> Optional[pulumi.Input['CustomHttpsConfigurationCustomHttpsConfigurationArgs']]:
        """
        A `custom_https_configuration` block as defined above.
        """
        return pulumi.get(self, "custom_https_configuration")

    @custom_https_configuration.setter
    def custom_https_configuration(self, value: Optional[pulumi.Input['CustomHttpsConfigurationCustomHttpsConfigurationArgs']]):
        pulumi.set(self, "custom_https_configuration", value)


@pulumi.input_type
class _CustomHttpsConfigurationState:
    def __init__(__self__, *,
                 custom_https_configuration: Optional[pulumi.Input['CustomHttpsConfigurationCustomHttpsConfigurationArgs']] = None,
                 custom_https_provisioning_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 frontend_endpoint_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering CustomHttpsConfiguration resources.
        :param pulumi.Input['CustomHttpsConfigurationCustomHttpsConfigurationArgs'] custom_https_configuration: A `custom_https_configuration` block as defined above.
        :param pulumi.Input[builtins.bool] custom_https_provisioning_enabled: Should the HTTPS protocol be enabled for this custom domain associated with the Front Door?
        :param pulumi.Input[builtins.str] frontend_endpoint_id: The ID of the Front Door Frontend Endpoint which this configuration refers to. Changing this forces a new resource to be created.
        """
        if custom_https_configuration is not None:
            pulumi.set(__self__, "custom_https_configuration", custom_https_configuration)
        if custom_https_provisioning_enabled is not None:
            pulumi.set(__self__, "custom_https_provisioning_enabled", custom_https_provisioning_enabled)
        if frontend_endpoint_id is not None:
            pulumi.set(__self__, "frontend_endpoint_id", frontend_endpoint_id)

    @property
    @pulumi.getter(name="customHttpsConfiguration")
    def custom_https_configuration(self) -> Optional[pulumi.Input['CustomHttpsConfigurationCustomHttpsConfigurationArgs']]:
        """
        A `custom_https_configuration` block as defined above.
        """
        return pulumi.get(self, "custom_https_configuration")

    @custom_https_configuration.setter
    def custom_https_configuration(self, value: Optional[pulumi.Input['CustomHttpsConfigurationCustomHttpsConfigurationArgs']]):
        pulumi.set(self, "custom_https_configuration", value)

    @property
    @pulumi.getter(name="customHttpsProvisioningEnabled")
    def custom_https_provisioning_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Should the HTTPS protocol be enabled for this custom domain associated with the Front Door?
        """
        return pulumi.get(self, "custom_https_provisioning_enabled")

    @custom_https_provisioning_enabled.setter
    def custom_https_provisioning_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "custom_https_provisioning_enabled", value)

    @property
    @pulumi.getter(name="frontendEndpointId")
    def frontend_endpoint_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Front Door Frontend Endpoint which this configuration refers to. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "frontend_endpoint_id")

    @frontend_endpoint_id.setter
    def frontend_endpoint_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "frontend_endpoint_id", value)


@pulumi.type_token("azure:frontdoor/customHttpsConfiguration:CustomHttpsConfiguration")
class CustomHttpsConfiguration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_https_configuration: Optional[pulumi.Input[Union['CustomHttpsConfigurationCustomHttpsConfigurationArgs', 'CustomHttpsConfigurationCustomHttpsConfigurationArgsDict']]] = None,
                 custom_https_provisioning_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 frontend_endpoint_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        !> **Note:** This deploys an Azure Front Door (classic) resource which has been deprecated and will receive security updates only. Please migrate your existing Azure Front Door (classic) deployments to the new Azure Front Door (standard/premium) resources. For your convenience, the service team has exposed a `Front Door Classic` to `Front Door Standard/Premium` [migration tool](https://learn.microsoft.com/azure/frontdoor/tier-migration) to allow you to migrate your existing `Front Door Classic` instances to the new `Front Door Standard/Premium` product tiers.

        Manages the Custom HTTPS Configuration for an Azure Front Door (classic) Frontend Endpoint.

        > **Note:** Defining custom HTTPS configurations using a separate `frontdoor.CustomHttpsConfiguration` resource allows for parallel creation/update.

        !> **Note:** In order to address the ordering issue we have changed the design on how to retrieve existing sub resources such as frontend endpoints. Existing design will be deprecated and will result in an incorrect configuration. Please refer to the updated documentation below for more information.

        !> **Note:** The `resource_group_name` field has been removed as of the `v2.58.0` provider release. If the `resource_group_name` field has been defined in your current `frontdoor.CustomHttpsConfiguration` resource configuration file please remove it else you will receive a `An argument named "resource_group_name" is not expected here.` error. If your pre-existing Front Door instance contained inline `custom_https_configuration` blocks there are additional steps that will need to be completed to successfully migrate your Front Door onto the `v2.58.0` provider which can be found in this guide.

        !> **Note:** Azure rolled out a breaking change on Friday 9th April 2021 which may cause issues with the CDN/FrontDoor resources. More information is available in this GitHub issue - unfortunately this may necessitate a breaking change to the CDN and Front Door resources, more information will be posted in the GitHub issue as the necessary changes are identified.

        !> **Note:** On `1 April 2025`, Azure Front Door (classic) will be retired for the public cloud, existing Azure Front Door (classic) resources must be migrated out of Azure Front Door (classic) to Azure Front Door Standard/Premium before `1 October 2025` to avoid potential disruptions in service.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="FrontDoorExampleResourceGroup",
            location="West Europe")
        vault = azure.keyvault.get_key_vault(name="example-vault",
            resource_group_name="example-vault-rg")
        example_frontdoor = azure.frontdoor.Frontdoor("example",
            name="example-FrontDoor",
            resource_group_name=example.name,
            routing_rules=[{
                "name": "exampleRoutingRule1",
                "accepted_protocols": [
                    "Http",
                    "Https",
                ],
                "patterns_to_matches": ["/*"],
                "frontend_endpoints": ["exampleFrontendEndpoint1"],
                "forwarding_configuration": {
                    "forwarding_protocol": "MatchRequest",
                    "backend_pool_name": "exampleBackendBing",
                },
            }],
            backend_pool_load_balancings=[{
                "name": "exampleLoadBalancingSettings1",
            }],
            backend_pool_health_probes=[{
                "name": "exampleHealthProbeSetting1",
            }],
            backend_pools=[{
                "name": "exampleBackendBing",
                "backends": [{
                    "host_header": "www.bing.com",
                    "address": "www.bing.com",
                    "http_port": 80,
                    "https_port": 443,
                }],
                "load_balancing_name": "exampleLoadBalancingSettings1",
                "health_probe_name": "exampleHealthProbeSetting1",
            }],
            frontend_endpoints=[
                {
                    "name": "exampleFrontendEndpoint1",
                    "host_name": "example-FrontDoor.azurefd.net",
                },
                {
                    "name": "exampleFrontendEndpoint2",
                    "host_name": "examplefd1.examplefd.net",
                },
            ])
        example_custom_https0 = azure.frontdoor.CustomHttpsConfiguration("example_custom_https_0",
            frontend_endpoint_id=example_frontdoor.frontend_endpoints_map["exampleFrontendEndpoint1"],
            custom_https_provisioning_enabled=False)
        example_custom_https1 = azure.frontdoor.CustomHttpsConfiguration("example_custom_https_1",
            frontend_endpoint_id=example_frontdoor.frontend_endpoints_map["exampleFrontendEndpoint2"],
            custom_https_provisioning_enabled=True,
            custom_https_configuration={
                "certificate_source": "AzureKeyVault",
                "azure_key_vault_certificate_secret_name": "examplefd1",
                "azure_key_vault_certificate_vault_id": vault.id,
            })
        ```

        ## Import

        Front Door Custom HTTPS Configurations can be imported using the `resource id` of the Front Door Custom HTTPS Configuration, e.g.

        ```sh
        $ pulumi import azure:frontdoor/customHttpsConfiguration:CustomHttpsConfiguration example_custom_https_1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Network/frontDoors/frontdoor1/customHttpsConfiguration/endpoint1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['CustomHttpsConfigurationCustomHttpsConfigurationArgs', 'CustomHttpsConfigurationCustomHttpsConfigurationArgsDict']] custom_https_configuration: A `custom_https_configuration` block as defined above.
        :param pulumi.Input[builtins.bool] custom_https_provisioning_enabled: Should the HTTPS protocol be enabled for this custom domain associated with the Front Door?
        :param pulumi.Input[builtins.str] frontend_endpoint_id: The ID of the Front Door Frontend Endpoint which this configuration refers to. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CustomHttpsConfigurationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        !> **Note:** This deploys an Azure Front Door (classic) resource which has been deprecated and will receive security updates only. Please migrate your existing Azure Front Door (classic) deployments to the new Azure Front Door (standard/premium) resources. For your convenience, the service team has exposed a `Front Door Classic` to `Front Door Standard/Premium` [migration tool](https://learn.microsoft.com/azure/frontdoor/tier-migration) to allow you to migrate your existing `Front Door Classic` instances to the new `Front Door Standard/Premium` product tiers.

        Manages the Custom HTTPS Configuration for an Azure Front Door (classic) Frontend Endpoint.

        > **Note:** Defining custom HTTPS configurations using a separate `frontdoor.CustomHttpsConfiguration` resource allows for parallel creation/update.

        !> **Note:** In order to address the ordering issue we have changed the design on how to retrieve existing sub resources such as frontend endpoints. Existing design will be deprecated and will result in an incorrect configuration. Please refer to the updated documentation below for more information.

        !> **Note:** The `resource_group_name` field has been removed as of the `v2.58.0` provider release. If the `resource_group_name` field has been defined in your current `frontdoor.CustomHttpsConfiguration` resource configuration file please remove it else you will receive a `An argument named "resource_group_name" is not expected here.` error. If your pre-existing Front Door instance contained inline `custom_https_configuration` blocks there are additional steps that will need to be completed to successfully migrate your Front Door onto the `v2.58.0` provider which can be found in this guide.

        !> **Note:** Azure rolled out a breaking change on Friday 9th April 2021 which may cause issues with the CDN/FrontDoor resources. More information is available in this GitHub issue - unfortunately this may necessitate a breaking change to the CDN and Front Door resources, more information will be posted in the GitHub issue as the necessary changes are identified.

        !> **Note:** On `1 April 2025`, Azure Front Door (classic) will be retired for the public cloud, existing Azure Front Door (classic) resources must be migrated out of Azure Front Door (classic) to Azure Front Door Standard/Premium before `1 October 2025` to avoid potential disruptions in service.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="FrontDoorExampleResourceGroup",
            location="West Europe")
        vault = azure.keyvault.get_key_vault(name="example-vault",
            resource_group_name="example-vault-rg")
        example_frontdoor = azure.frontdoor.Frontdoor("example",
            name="example-FrontDoor",
            resource_group_name=example.name,
            routing_rules=[{
                "name": "exampleRoutingRule1",
                "accepted_protocols": [
                    "Http",
                    "Https",
                ],
                "patterns_to_matches": ["/*"],
                "frontend_endpoints": ["exampleFrontendEndpoint1"],
                "forwarding_configuration": {
                    "forwarding_protocol": "MatchRequest",
                    "backend_pool_name": "exampleBackendBing",
                },
            }],
            backend_pool_load_balancings=[{
                "name": "exampleLoadBalancingSettings1",
            }],
            backend_pool_health_probes=[{
                "name": "exampleHealthProbeSetting1",
            }],
            backend_pools=[{
                "name": "exampleBackendBing",
                "backends": [{
                    "host_header": "www.bing.com",
                    "address": "www.bing.com",
                    "http_port": 80,
                    "https_port": 443,
                }],
                "load_balancing_name": "exampleLoadBalancingSettings1",
                "health_probe_name": "exampleHealthProbeSetting1",
            }],
            frontend_endpoints=[
                {
                    "name": "exampleFrontendEndpoint1",
                    "host_name": "example-FrontDoor.azurefd.net",
                },
                {
                    "name": "exampleFrontendEndpoint2",
                    "host_name": "examplefd1.examplefd.net",
                },
            ])
        example_custom_https0 = azure.frontdoor.CustomHttpsConfiguration("example_custom_https_0",
            frontend_endpoint_id=example_frontdoor.frontend_endpoints_map["exampleFrontendEndpoint1"],
            custom_https_provisioning_enabled=False)
        example_custom_https1 = azure.frontdoor.CustomHttpsConfiguration("example_custom_https_1",
            frontend_endpoint_id=example_frontdoor.frontend_endpoints_map["exampleFrontendEndpoint2"],
            custom_https_provisioning_enabled=True,
            custom_https_configuration={
                "certificate_source": "AzureKeyVault",
                "azure_key_vault_certificate_secret_name": "examplefd1",
                "azure_key_vault_certificate_vault_id": vault.id,
            })
        ```

        ## Import

        Front Door Custom HTTPS Configurations can be imported using the `resource id` of the Front Door Custom HTTPS Configuration, e.g.

        ```sh
        $ pulumi import azure:frontdoor/customHttpsConfiguration:CustomHttpsConfiguration example_custom_https_1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Network/frontDoors/frontdoor1/customHttpsConfiguration/endpoint1
        ```

        :param str resource_name: The name of the resource.
        :param CustomHttpsConfigurationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CustomHttpsConfigurationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_https_configuration: Optional[pulumi.Input[Union['CustomHttpsConfigurationCustomHttpsConfigurationArgs', 'CustomHttpsConfigurationCustomHttpsConfigurationArgsDict']]] = None,
                 custom_https_provisioning_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 frontend_endpoint_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CustomHttpsConfigurationArgs.__new__(CustomHttpsConfigurationArgs)

            __props__.__dict__["custom_https_configuration"] = custom_https_configuration
            if custom_https_provisioning_enabled is None and not opts.urn:
                raise TypeError("Missing required property 'custom_https_provisioning_enabled'")
            __props__.__dict__["custom_https_provisioning_enabled"] = custom_https_provisioning_enabled
            if frontend_endpoint_id is None and not opts.urn:
                raise TypeError("Missing required property 'frontend_endpoint_id'")
            __props__.__dict__["frontend_endpoint_id"] = frontend_endpoint_id
        super(CustomHttpsConfiguration, __self__).__init__(
            'azure:frontdoor/customHttpsConfiguration:CustomHttpsConfiguration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            custom_https_configuration: Optional[pulumi.Input[Union['CustomHttpsConfigurationCustomHttpsConfigurationArgs', 'CustomHttpsConfigurationCustomHttpsConfigurationArgsDict']]] = None,
            custom_https_provisioning_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            frontend_endpoint_id: Optional[pulumi.Input[builtins.str]] = None) -> 'CustomHttpsConfiguration':
        """
        Get an existing CustomHttpsConfiguration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['CustomHttpsConfigurationCustomHttpsConfigurationArgs', 'CustomHttpsConfigurationCustomHttpsConfigurationArgsDict']] custom_https_configuration: A `custom_https_configuration` block as defined above.
        :param pulumi.Input[builtins.bool] custom_https_provisioning_enabled: Should the HTTPS protocol be enabled for this custom domain associated with the Front Door?
        :param pulumi.Input[builtins.str] frontend_endpoint_id: The ID of the Front Door Frontend Endpoint which this configuration refers to. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CustomHttpsConfigurationState.__new__(_CustomHttpsConfigurationState)

        __props__.__dict__["custom_https_configuration"] = custom_https_configuration
        __props__.__dict__["custom_https_provisioning_enabled"] = custom_https_provisioning_enabled
        __props__.__dict__["frontend_endpoint_id"] = frontend_endpoint_id
        return CustomHttpsConfiguration(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="customHttpsConfiguration")
    def custom_https_configuration(self) -> pulumi.Output[Optional['outputs.CustomHttpsConfigurationCustomHttpsConfiguration']]:
        """
        A `custom_https_configuration` block as defined above.
        """
        return pulumi.get(self, "custom_https_configuration")

    @property
    @pulumi.getter(name="customHttpsProvisioningEnabled")
    def custom_https_provisioning_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        Should the HTTPS protocol be enabled for this custom domain associated with the Front Door?
        """
        return pulumi.get(self, "custom_https_provisioning_enabled")

    @property
    @pulumi.getter(name="frontendEndpointId")
    def frontend_endpoint_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the Front Door Frontend Endpoint which this configuration refers to. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "frontend_endpoint_id")

