# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FrontdoorArgs', 'Frontdoor']

@pulumi.input_type
class FrontdoorArgs:
    def __init__(__self__, *,
                 backend_pool_health_probes: pulumi.Input[Sequence[pulumi.Input['FrontdoorBackendPoolHealthProbeArgs']]],
                 backend_pool_load_balancings: pulumi.Input[Sequence[pulumi.Input['FrontdoorBackendPoolLoadBalancingArgs']]],
                 backend_pools: pulumi.Input[Sequence[pulumi.Input['FrontdoorBackendPoolArgs']]],
                 frontend_endpoints: pulumi.Input[Sequence[pulumi.Input['FrontdoorFrontendEndpointArgs']]],
                 resource_group_name: pulumi.Input[builtins.str],
                 routing_rules: pulumi.Input[Sequence[pulumi.Input['FrontdoorRoutingRuleArgs']]],
                 backend_pool_settings: Optional[pulumi.Input[Sequence[pulumi.Input['FrontdoorBackendPoolSettingArgs']]]] = None,
                 friendly_name: Optional[pulumi.Input[builtins.str]] = None,
                 load_balancer_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a Frontdoor resource.
        :param pulumi.Input[Sequence[pulumi.Input['FrontdoorBackendPoolHealthProbeArgs']]] backend_pool_health_probes: A `backend_pool_health_probe` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['FrontdoorBackendPoolLoadBalancingArgs']]] backend_pool_load_balancings: A `backend_pool_load_balancing` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['FrontdoorBackendPoolArgs']]] backend_pools: A `backend_pool` block as defined below.
               
               > Azure by default allows specifying up to 50 Backend Pools - but this quota can be increased via Microsoft Support.
        :param pulumi.Input[Sequence[pulumi.Input['FrontdoorFrontendEndpointArgs']]] frontend_endpoints: A `frontend_endpoint` block as defined below.
        :param pulumi.Input[builtins.str] resource_group_name: Specifies the name of the Resource Group in which the Front Door service should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input['FrontdoorRoutingRuleArgs']]] routing_rules: A `routing_rule` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['FrontdoorBackendPoolSettingArgs']]] backend_pool_settings: A `backend_pool_settings` block as defined below.
        :param pulumi.Input[builtins.str] friendly_name: A friendly name for the Front Door service.
        :param pulumi.Input[builtins.bool] load_balancer_enabled: Should the Front Door Load Balancer be Enabled? Defaults to `true`.
        :param pulumi.Input[builtins.str] name: Specifies the name of the Front Door service. Must be globally unique. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        pulumi.set(__self__, "backend_pool_health_probes", backend_pool_health_probes)
        pulumi.set(__self__, "backend_pool_load_balancings", backend_pool_load_balancings)
        pulumi.set(__self__, "backend_pools", backend_pools)
        pulumi.set(__self__, "frontend_endpoints", frontend_endpoints)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "routing_rules", routing_rules)
        if backend_pool_settings is not None:
            pulumi.set(__self__, "backend_pool_settings", backend_pool_settings)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if load_balancer_enabled is not None:
            pulumi.set(__self__, "load_balancer_enabled", load_balancer_enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="backendPoolHealthProbes")
    def backend_pool_health_probes(self) -> pulumi.Input[Sequence[pulumi.Input['FrontdoorBackendPoolHealthProbeArgs']]]:
        """
        A `backend_pool_health_probe` block as defined below.
        """
        return pulumi.get(self, "backend_pool_health_probes")

    @backend_pool_health_probes.setter
    def backend_pool_health_probes(self, value: pulumi.Input[Sequence[pulumi.Input['FrontdoorBackendPoolHealthProbeArgs']]]):
        pulumi.set(self, "backend_pool_health_probes", value)

    @property
    @pulumi.getter(name="backendPoolLoadBalancings")
    def backend_pool_load_balancings(self) -> pulumi.Input[Sequence[pulumi.Input['FrontdoorBackendPoolLoadBalancingArgs']]]:
        """
        A `backend_pool_load_balancing` block as defined below.
        """
        return pulumi.get(self, "backend_pool_load_balancings")

    @backend_pool_load_balancings.setter
    def backend_pool_load_balancings(self, value: pulumi.Input[Sequence[pulumi.Input['FrontdoorBackendPoolLoadBalancingArgs']]]):
        pulumi.set(self, "backend_pool_load_balancings", value)

    @property
    @pulumi.getter(name="backendPools")
    def backend_pools(self) -> pulumi.Input[Sequence[pulumi.Input['FrontdoorBackendPoolArgs']]]:
        """
        A `backend_pool` block as defined below.

        > Azure by default allows specifying up to 50 Backend Pools - but this quota can be increased via Microsoft Support.
        """
        return pulumi.get(self, "backend_pools")

    @backend_pools.setter
    def backend_pools(self, value: pulumi.Input[Sequence[pulumi.Input['FrontdoorBackendPoolArgs']]]):
        pulumi.set(self, "backend_pools", value)

    @property
    @pulumi.getter(name="frontendEndpoints")
    def frontend_endpoints(self) -> pulumi.Input[Sequence[pulumi.Input['FrontdoorFrontendEndpointArgs']]]:
        """
        A `frontend_endpoint` block as defined below.
        """
        return pulumi.get(self, "frontend_endpoints")

    @frontend_endpoints.setter
    def frontend_endpoints(self, value: pulumi.Input[Sequence[pulumi.Input['FrontdoorFrontendEndpointArgs']]]):
        pulumi.set(self, "frontend_endpoints", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the name of the Resource Group in which the Front Door service should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="routingRules")
    def routing_rules(self) -> pulumi.Input[Sequence[pulumi.Input['FrontdoorRoutingRuleArgs']]]:
        """
        A `routing_rule` block as defined below.
        """
        return pulumi.get(self, "routing_rules")

    @routing_rules.setter
    def routing_rules(self, value: pulumi.Input[Sequence[pulumi.Input['FrontdoorRoutingRuleArgs']]]):
        pulumi.set(self, "routing_rules", value)

    @property
    @pulumi.getter(name="backendPoolSettings")
    def backend_pool_settings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FrontdoorBackendPoolSettingArgs']]]]:
        """
        A `backend_pool_settings` block as defined below.
        """
        return pulumi.get(self, "backend_pool_settings")

    @backend_pool_settings.setter
    def backend_pool_settings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FrontdoorBackendPoolSettingArgs']]]]):
        pulumi.set(self, "backend_pool_settings", value)

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A friendly name for the Front Door service.
        """
        return pulumi.get(self, "friendly_name")

    @friendly_name.setter
    def friendly_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "friendly_name", value)

    @property
    @pulumi.getter(name="loadBalancerEnabled")
    def load_balancer_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Should the Front Door Load Balancer be Enabled? Defaults to `true`.
        """
        return pulumi.get(self, "load_balancer_enabled")

    @load_balancer_enabled.setter
    def load_balancer_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "load_balancer_enabled", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the Front Door service. Must be globally unique. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _FrontdoorState:
    def __init__(__self__, *,
                 backend_pool_health_probes: Optional[pulumi.Input[Sequence[pulumi.Input['FrontdoorBackendPoolHealthProbeArgs']]]] = None,
                 backend_pool_health_probes_map: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 backend_pool_load_balancing_settings_map: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 backend_pool_load_balancings: Optional[pulumi.Input[Sequence[pulumi.Input['FrontdoorBackendPoolLoadBalancingArgs']]]] = None,
                 backend_pool_settings: Optional[pulumi.Input[Sequence[pulumi.Input['FrontdoorBackendPoolSettingArgs']]]] = None,
                 backend_pools: Optional[pulumi.Input[Sequence[pulumi.Input['FrontdoorBackendPoolArgs']]]] = None,
                 backend_pools_map: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 cname: Optional[pulumi.Input[builtins.str]] = None,
                 explicit_resource_orders: Optional[pulumi.Input[Sequence[pulumi.Input['FrontdoorExplicitResourceOrderArgs']]]] = None,
                 friendly_name: Optional[pulumi.Input[builtins.str]] = None,
                 frontend_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input['FrontdoorFrontendEndpointArgs']]]] = None,
                 frontend_endpoints_map: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 header_frontdoor_id: Optional[pulumi.Input[builtins.str]] = None,
                 load_balancer_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 routing_rules: Optional[pulumi.Input[Sequence[pulumi.Input['FrontdoorRoutingRuleArgs']]]] = None,
                 routing_rules_map: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Frontdoor resources.
        :param pulumi.Input[Sequence[pulumi.Input['FrontdoorBackendPoolHealthProbeArgs']]] backend_pool_health_probes: A `backend_pool_health_probe` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] backend_pool_health_probes_map: A map/dictionary of Backend Pool Health Probe Names (key) to the Backend Pool Health Probe ID (value)
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] backend_pool_load_balancing_settings_map: A map/dictionary of Backend Pool Load Balancing Setting Names (key) to the Backend Pool Load Balancing Setting ID (value)
        :param pulumi.Input[Sequence[pulumi.Input['FrontdoorBackendPoolLoadBalancingArgs']]] backend_pool_load_balancings: A `backend_pool_load_balancing` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['FrontdoorBackendPoolSettingArgs']]] backend_pool_settings: A `backend_pool_settings` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['FrontdoorBackendPoolArgs']]] backend_pools: A `backend_pool` block as defined below.
               
               > Azure by default allows specifying up to 50 Backend Pools - but this quota can be increased via Microsoft Support.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] backend_pools_map: A map/dictionary of Backend Pool Names (key) to the Backend Pool ID (value)
        :param pulumi.Input[builtins.str] cname: The host that each frontendEndpoint must CNAME to.
        :param pulumi.Input[builtins.str] friendly_name: A friendly name for the Front Door service.
        :param pulumi.Input[Sequence[pulumi.Input['FrontdoorFrontendEndpointArgs']]] frontend_endpoints: A `frontend_endpoint` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] frontend_endpoints_map: A map/dictionary of Frontend Endpoint Names (key) to the Frontend Endpoint ID (value)
        :param pulumi.Input[builtins.str] header_frontdoor_id: The unique ID of the Front Door which is embedded into the incoming headers `X-Azure-FDID` attribute and maybe used to filter traffic sent by the Front Door to your backend.
        :param pulumi.Input[builtins.bool] load_balancer_enabled: Should the Front Door Load Balancer be Enabled? Defaults to `true`.
        :param pulumi.Input[builtins.str] name: Specifies the name of the Front Door service. Must be globally unique. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] resource_group_name: Specifies the name of the Resource Group in which the Front Door service should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input['FrontdoorRoutingRuleArgs']]] routing_rules: A `routing_rule` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] routing_rules_map: A map/dictionary of Routing Rule Names (key) to the Routing Rule ID (value)
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        if backend_pool_health_probes is not None:
            pulumi.set(__self__, "backend_pool_health_probes", backend_pool_health_probes)
        if backend_pool_health_probes_map is not None:
            pulumi.set(__self__, "backend_pool_health_probes_map", backend_pool_health_probes_map)
        if backend_pool_load_balancing_settings_map is not None:
            pulumi.set(__self__, "backend_pool_load_balancing_settings_map", backend_pool_load_balancing_settings_map)
        if backend_pool_load_balancings is not None:
            pulumi.set(__self__, "backend_pool_load_balancings", backend_pool_load_balancings)
        if backend_pool_settings is not None:
            pulumi.set(__self__, "backend_pool_settings", backend_pool_settings)
        if backend_pools is not None:
            pulumi.set(__self__, "backend_pools", backend_pools)
        if backend_pools_map is not None:
            pulumi.set(__self__, "backend_pools_map", backend_pools_map)
        if cname is not None:
            pulumi.set(__self__, "cname", cname)
        if explicit_resource_orders is not None:
            pulumi.set(__self__, "explicit_resource_orders", explicit_resource_orders)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if frontend_endpoints is not None:
            pulumi.set(__self__, "frontend_endpoints", frontend_endpoints)
        if frontend_endpoints_map is not None:
            pulumi.set(__self__, "frontend_endpoints_map", frontend_endpoints_map)
        if header_frontdoor_id is not None:
            pulumi.set(__self__, "header_frontdoor_id", header_frontdoor_id)
        if load_balancer_enabled is not None:
            pulumi.set(__self__, "load_balancer_enabled", load_balancer_enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if routing_rules is not None:
            pulumi.set(__self__, "routing_rules", routing_rules)
        if routing_rules_map is not None:
            pulumi.set(__self__, "routing_rules_map", routing_rules_map)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="backendPoolHealthProbes")
    def backend_pool_health_probes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FrontdoorBackendPoolHealthProbeArgs']]]]:
        """
        A `backend_pool_health_probe` block as defined below.
        """
        return pulumi.get(self, "backend_pool_health_probes")

    @backend_pool_health_probes.setter
    def backend_pool_health_probes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FrontdoorBackendPoolHealthProbeArgs']]]]):
        pulumi.set(self, "backend_pool_health_probes", value)

    @property
    @pulumi.getter(name="backendPoolHealthProbesMap")
    def backend_pool_health_probes_map(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map/dictionary of Backend Pool Health Probe Names (key) to the Backend Pool Health Probe ID (value)
        """
        return pulumi.get(self, "backend_pool_health_probes_map")

    @backend_pool_health_probes_map.setter
    def backend_pool_health_probes_map(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "backend_pool_health_probes_map", value)

    @property
    @pulumi.getter(name="backendPoolLoadBalancingSettingsMap")
    def backend_pool_load_balancing_settings_map(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map/dictionary of Backend Pool Load Balancing Setting Names (key) to the Backend Pool Load Balancing Setting ID (value)
        """
        return pulumi.get(self, "backend_pool_load_balancing_settings_map")

    @backend_pool_load_balancing_settings_map.setter
    def backend_pool_load_balancing_settings_map(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "backend_pool_load_balancing_settings_map", value)

    @property
    @pulumi.getter(name="backendPoolLoadBalancings")
    def backend_pool_load_balancings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FrontdoorBackendPoolLoadBalancingArgs']]]]:
        """
        A `backend_pool_load_balancing` block as defined below.
        """
        return pulumi.get(self, "backend_pool_load_balancings")

    @backend_pool_load_balancings.setter
    def backend_pool_load_balancings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FrontdoorBackendPoolLoadBalancingArgs']]]]):
        pulumi.set(self, "backend_pool_load_balancings", value)

    @property
    @pulumi.getter(name="backendPoolSettings")
    def backend_pool_settings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FrontdoorBackendPoolSettingArgs']]]]:
        """
        A `backend_pool_settings` block as defined below.
        """
        return pulumi.get(self, "backend_pool_settings")

    @backend_pool_settings.setter
    def backend_pool_settings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FrontdoorBackendPoolSettingArgs']]]]):
        pulumi.set(self, "backend_pool_settings", value)

    @property
    @pulumi.getter(name="backendPools")
    def backend_pools(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FrontdoorBackendPoolArgs']]]]:
        """
        A `backend_pool` block as defined below.

        > Azure by default allows specifying up to 50 Backend Pools - but this quota can be increased via Microsoft Support.
        """
        return pulumi.get(self, "backend_pools")

    @backend_pools.setter
    def backend_pools(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FrontdoorBackendPoolArgs']]]]):
        pulumi.set(self, "backend_pools", value)

    @property
    @pulumi.getter(name="backendPoolsMap")
    def backend_pools_map(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map/dictionary of Backend Pool Names (key) to the Backend Pool ID (value)
        """
        return pulumi.get(self, "backend_pools_map")

    @backend_pools_map.setter
    def backend_pools_map(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "backend_pools_map", value)

    @property
    @pulumi.getter
    def cname(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The host that each frontendEndpoint must CNAME to.
        """
        return pulumi.get(self, "cname")

    @cname.setter
    def cname(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cname", value)

    @property
    @pulumi.getter(name="explicitResourceOrders")
    def explicit_resource_orders(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FrontdoorExplicitResourceOrderArgs']]]]:
        return pulumi.get(self, "explicit_resource_orders")

    @explicit_resource_orders.setter
    def explicit_resource_orders(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FrontdoorExplicitResourceOrderArgs']]]]):
        pulumi.set(self, "explicit_resource_orders", value)

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A friendly name for the Front Door service.
        """
        return pulumi.get(self, "friendly_name")

    @friendly_name.setter
    def friendly_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "friendly_name", value)

    @property
    @pulumi.getter(name="frontendEndpoints")
    def frontend_endpoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FrontdoorFrontendEndpointArgs']]]]:
        """
        A `frontend_endpoint` block as defined below.
        """
        return pulumi.get(self, "frontend_endpoints")

    @frontend_endpoints.setter
    def frontend_endpoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FrontdoorFrontendEndpointArgs']]]]):
        pulumi.set(self, "frontend_endpoints", value)

    @property
    @pulumi.getter(name="frontendEndpointsMap")
    def frontend_endpoints_map(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map/dictionary of Frontend Endpoint Names (key) to the Frontend Endpoint ID (value)
        """
        return pulumi.get(self, "frontend_endpoints_map")

    @frontend_endpoints_map.setter
    def frontend_endpoints_map(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "frontend_endpoints_map", value)

    @property
    @pulumi.getter(name="headerFrontdoorId")
    def header_frontdoor_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The unique ID of the Front Door which is embedded into the incoming headers `X-Azure-FDID` attribute and maybe used to filter traffic sent by the Front Door to your backend.
        """
        return pulumi.get(self, "header_frontdoor_id")

    @header_frontdoor_id.setter
    def header_frontdoor_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "header_frontdoor_id", value)

    @property
    @pulumi.getter(name="loadBalancerEnabled")
    def load_balancer_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Should the Front Door Load Balancer be Enabled? Defaults to `true`.
        """
        return pulumi.get(self, "load_balancer_enabled")

    @load_balancer_enabled.setter
    def load_balancer_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "load_balancer_enabled", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the Front Door service. Must be globally unique. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the Resource Group in which the Front Door service should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="routingRules")
    def routing_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FrontdoorRoutingRuleArgs']]]]:
        """
        A `routing_rule` block as defined below.
        """
        return pulumi.get(self, "routing_rules")

    @routing_rules.setter
    def routing_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FrontdoorRoutingRuleArgs']]]]):
        pulumi.set(self, "routing_rules", value)

    @property
    @pulumi.getter(name="routingRulesMap")
    def routing_rules_map(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map/dictionary of Routing Rule Names (key) to the Routing Rule ID (value)
        """
        return pulumi.get(self, "routing_rules_map")

    @routing_rules_map.setter
    def routing_rules_map(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "routing_rules_map", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("azure:frontdoor/frontdoor:Frontdoor")
class Frontdoor(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backend_pool_health_probes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FrontdoorBackendPoolHealthProbeArgs', 'FrontdoorBackendPoolHealthProbeArgsDict']]]]] = None,
                 backend_pool_load_balancings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FrontdoorBackendPoolLoadBalancingArgs', 'FrontdoorBackendPoolLoadBalancingArgsDict']]]]] = None,
                 backend_pool_settings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FrontdoorBackendPoolSettingArgs', 'FrontdoorBackendPoolSettingArgsDict']]]]] = None,
                 backend_pools: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FrontdoorBackendPoolArgs', 'FrontdoorBackendPoolArgsDict']]]]] = None,
                 friendly_name: Optional[pulumi.Input[builtins.str]] = None,
                 frontend_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FrontdoorFrontendEndpointArgs', 'FrontdoorFrontendEndpointArgsDict']]]]] = None,
                 load_balancer_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 routing_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FrontdoorRoutingRuleArgs', 'FrontdoorRoutingRuleArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        !> **IMPORTANT** This deploys an Azure Front Door (classic) resource which has been deprecated and will receive security updates only. Please migrate your existing Azure Front Door (classic) deployments to the new Azure Front Door (standard/premium) resources. For your convenience, the service team has exposed a `Front Door Classic` to `Front Door Standard/Premium` [migration tool](https://learn.microsoft.com/azure/frontdoor/tier-migration) to allow you to migrate your existing `Front Door Classic` instances to the new `Front Door Standard/Premium` product tiers.

        Manages an Azure Front Door (classic) instance.

        Azure Front Door Service is Microsoft's highly available and scalable web application acceleration platform and global HTTP(S) load balancer. It provides built-in DDoS protection and application layer security and caching. Front Door enables you to build applications that maximize and automate high-availability and performance for your end-users. Use Front Door with Azure services including Web/Mobile Apps, Cloud Services and Virtual Machines – or combine it with on-premises services for hybrid deployments and smooth cloud migration.

        Below are some of the key scenarios that Azure Front Door Service addresses:

        * Use Front Door to improve application scale and availability with instant multi-region failover
        * Use Front Door to improve application performance with SSL offload and routing requests to the fastest available application backend.
        * Use Front Door for application layer security and DDoS protection for your application.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="FrontDoorExampleResourceGroup",
            location="West Europe")
        example_frontdoor = azure.frontdoor.Frontdoor("example",
            name="example-FrontDoor",
            resource_group_name=example.name,
            routing_rules=[{
                "name": "exampleRoutingRule1",
                "accepted_protocols": [
                    "Http",
                    "Https",
                ],
                "patterns_to_matches": ["/*"],
                "frontend_endpoints": ["exampleFrontendEndpoint1"],
                "forwarding_configuration": {
                    "forwarding_protocol": "MatchRequest",
                    "backend_pool_name": "exampleBackendBing",
                },
            }],
            backend_pool_load_balancings=[{
                "name": "exampleLoadBalancingSettings1",
            }],
            backend_pool_health_probes=[{
                "name": "exampleHealthProbeSetting1",
            }],
            backend_pools=[{
                "name": "exampleBackendBing",
                "backends": [{
                    "host_header": "www.bing.com",
                    "address": "www.bing.com",
                    "http_port": 80,
                    "https_port": 443,
                }],
                "load_balancing_name": "exampleLoadBalancingSettings1",
                "health_probe_name": "exampleHealthProbeSetting1",
            }],
            frontend_endpoints=[{
                "name": "exampleFrontendEndpoint1",
                "host_name": "example-FrontDoor.azurefd.net",
            }])
        ```

        ## Import

        Front Doors can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:frontdoor/frontdoor:Frontdoor example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Network/frontDoors/frontdoor1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FrontdoorBackendPoolHealthProbeArgs', 'FrontdoorBackendPoolHealthProbeArgsDict']]]] backend_pool_health_probes: A `backend_pool_health_probe` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FrontdoorBackendPoolLoadBalancingArgs', 'FrontdoorBackendPoolLoadBalancingArgsDict']]]] backend_pool_load_balancings: A `backend_pool_load_balancing` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FrontdoorBackendPoolSettingArgs', 'FrontdoorBackendPoolSettingArgsDict']]]] backend_pool_settings: A `backend_pool_settings` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FrontdoorBackendPoolArgs', 'FrontdoorBackendPoolArgsDict']]]] backend_pools: A `backend_pool` block as defined below.
               
               > Azure by default allows specifying up to 50 Backend Pools - but this quota can be increased via Microsoft Support.
        :param pulumi.Input[builtins.str] friendly_name: A friendly name for the Front Door service.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FrontdoorFrontendEndpointArgs', 'FrontdoorFrontendEndpointArgsDict']]]] frontend_endpoints: A `frontend_endpoint` block as defined below.
        :param pulumi.Input[builtins.bool] load_balancer_enabled: Should the Front Door Load Balancer be Enabled? Defaults to `true`.
        :param pulumi.Input[builtins.str] name: Specifies the name of the Front Door service. Must be globally unique. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] resource_group_name: Specifies the name of the Resource Group in which the Front Door service should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FrontdoorRoutingRuleArgs', 'FrontdoorRoutingRuleArgsDict']]]] routing_rules: A `routing_rule` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FrontdoorArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        !> **IMPORTANT** This deploys an Azure Front Door (classic) resource which has been deprecated and will receive security updates only. Please migrate your existing Azure Front Door (classic) deployments to the new Azure Front Door (standard/premium) resources. For your convenience, the service team has exposed a `Front Door Classic` to `Front Door Standard/Premium` [migration tool](https://learn.microsoft.com/azure/frontdoor/tier-migration) to allow you to migrate your existing `Front Door Classic` instances to the new `Front Door Standard/Premium` product tiers.

        Manages an Azure Front Door (classic) instance.

        Azure Front Door Service is Microsoft's highly available and scalable web application acceleration platform and global HTTP(S) load balancer. It provides built-in DDoS protection and application layer security and caching. Front Door enables you to build applications that maximize and automate high-availability and performance for your end-users. Use Front Door with Azure services including Web/Mobile Apps, Cloud Services and Virtual Machines – or combine it with on-premises services for hybrid deployments and smooth cloud migration.

        Below are some of the key scenarios that Azure Front Door Service addresses:

        * Use Front Door to improve application scale and availability with instant multi-region failover
        * Use Front Door to improve application performance with SSL offload and routing requests to the fastest available application backend.
        * Use Front Door for application layer security and DDoS protection for your application.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="FrontDoorExampleResourceGroup",
            location="West Europe")
        example_frontdoor = azure.frontdoor.Frontdoor("example",
            name="example-FrontDoor",
            resource_group_name=example.name,
            routing_rules=[{
                "name": "exampleRoutingRule1",
                "accepted_protocols": [
                    "Http",
                    "Https",
                ],
                "patterns_to_matches": ["/*"],
                "frontend_endpoints": ["exampleFrontendEndpoint1"],
                "forwarding_configuration": {
                    "forwarding_protocol": "MatchRequest",
                    "backend_pool_name": "exampleBackendBing",
                },
            }],
            backend_pool_load_balancings=[{
                "name": "exampleLoadBalancingSettings1",
            }],
            backend_pool_health_probes=[{
                "name": "exampleHealthProbeSetting1",
            }],
            backend_pools=[{
                "name": "exampleBackendBing",
                "backends": [{
                    "host_header": "www.bing.com",
                    "address": "www.bing.com",
                    "http_port": 80,
                    "https_port": 443,
                }],
                "load_balancing_name": "exampleLoadBalancingSettings1",
                "health_probe_name": "exampleHealthProbeSetting1",
            }],
            frontend_endpoints=[{
                "name": "exampleFrontendEndpoint1",
                "host_name": "example-FrontDoor.azurefd.net",
            }])
        ```

        ## Import

        Front Doors can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:frontdoor/frontdoor:Frontdoor example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Network/frontDoors/frontdoor1
        ```

        :param str resource_name: The name of the resource.
        :param FrontdoorArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FrontdoorArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backend_pool_health_probes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FrontdoorBackendPoolHealthProbeArgs', 'FrontdoorBackendPoolHealthProbeArgsDict']]]]] = None,
                 backend_pool_load_balancings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FrontdoorBackendPoolLoadBalancingArgs', 'FrontdoorBackendPoolLoadBalancingArgsDict']]]]] = None,
                 backend_pool_settings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FrontdoorBackendPoolSettingArgs', 'FrontdoorBackendPoolSettingArgsDict']]]]] = None,
                 backend_pools: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FrontdoorBackendPoolArgs', 'FrontdoorBackendPoolArgsDict']]]]] = None,
                 friendly_name: Optional[pulumi.Input[builtins.str]] = None,
                 frontend_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FrontdoorFrontendEndpointArgs', 'FrontdoorFrontendEndpointArgsDict']]]]] = None,
                 load_balancer_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 routing_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FrontdoorRoutingRuleArgs', 'FrontdoorRoutingRuleArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FrontdoorArgs.__new__(FrontdoorArgs)

            if backend_pool_health_probes is None and not opts.urn:
                raise TypeError("Missing required property 'backend_pool_health_probes'")
            __props__.__dict__["backend_pool_health_probes"] = backend_pool_health_probes
            if backend_pool_load_balancings is None and not opts.urn:
                raise TypeError("Missing required property 'backend_pool_load_balancings'")
            __props__.__dict__["backend_pool_load_balancings"] = backend_pool_load_balancings
            __props__.__dict__["backend_pool_settings"] = backend_pool_settings
            if backend_pools is None and not opts.urn:
                raise TypeError("Missing required property 'backend_pools'")
            __props__.__dict__["backend_pools"] = backend_pools
            __props__.__dict__["friendly_name"] = friendly_name
            if frontend_endpoints is None and not opts.urn:
                raise TypeError("Missing required property 'frontend_endpoints'")
            __props__.__dict__["frontend_endpoints"] = frontend_endpoints
            __props__.__dict__["load_balancer_enabled"] = load_balancer_enabled
            __props__.__dict__["name"] = name
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            if routing_rules is None and not opts.urn:
                raise TypeError("Missing required property 'routing_rules'")
            __props__.__dict__["routing_rules"] = routing_rules
            __props__.__dict__["tags"] = tags
            __props__.__dict__["backend_pool_health_probes_map"] = None
            __props__.__dict__["backend_pool_load_balancing_settings_map"] = None
            __props__.__dict__["backend_pools_map"] = None
            __props__.__dict__["cname"] = None
            __props__.__dict__["explicit_resource_orders"] = None
            __props__.__dict__["frontend_endpoints_map"] = None
            __props__.__dict__["header_frontdoor_id"] = None
            __props__.__dict__["routing_rules_map"] = None
        super(Frontdoor, __self__).__init__(
            'azure:frontdoor/frontdoor:Frontdoor',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            backend_pool_health_probes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FrontdoorBackendPoolHealthProbeArgs', 'FrontdoorBackendPoolHealthProbeArgsDict']]]]] = None,
            backend_pool_health_probes_map: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            backend_pool_load_balancing_settings_map: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            backend_pool_load_balancings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FrontdoorBackendPoolLoadBalancingArgs', 'FrontdoorBackendPoolLoadBalancingArgsDict']]]]] = None,
            backend_pool_settings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FrontdoorBackendPoolSettingArgs', 'FrontdoorBackendPoolSettingArgsDict']]]]] = None,
            backend_pools: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FrontdoorBackendPoolArgs', 'FrontdoorBackendPoolArgsDict']]]]] = None,
            backend_pools_map: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            cname: Optional[pulumi.Input[builtins.str]] = None,
            explicit_resource_orders: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FrontdoorExplicitResourceOrderArgs', 'FrontdoorExplicitResourceOrderArgsDict']]]]] = None,
            friendly_name: Optional[pulumi.Input[builtins.str]] = None,
            frontend_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FrontdoorFrontendEndpointArgs', 'FrontdoorFrontendEndpointArgsDict']]]]] = None,
            frontend_endpoints_map: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            header_frontdoor_id: Optional[pulumi.Input[builtins.str]] = None,
            load_balancer_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
            routing_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FrontdoorRoutingRuleArgs', 'FrontdoorRoutingRuleArgsDict']]]]] = None,
            routing_rules_map: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None) -> 'Frontdoor':
        """
        Get an existing Frontdoor resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FrontdoorBackendPoolHealthProbeArgs', 'FrontdoorBackendPoolHealthProbeArgsDict']]]] backend_pool_health_probes: A `backend_pool_health_probe` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] backend_pool_health_probes_map: A map/dictionary of Backend Pool Health Probe Names (key) to the Backend Pool Health Probe ID (value)
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] backend_pool_load_balancing_settings_map: A map/dictionary of Backend Pool Load Balancing Setting Names (key) to the Backend Pool Load Balancing Setting ID (value)
        :param pulumi.Input[Sequence[pulumi.Input[Union['FrontdoorBackendPoolLoadBalancingArgs', 'FrontdoorBackendPoolLoadBalancingArgsDict']]]] backend_pool_load_balancings: A `backend_pool_load_balancing` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FrontdoorBackendPoolSettingArgs', 'FrontdoorBackendPoolSettingArgsDict']]]] backend_pool_settings: A `backend_pool_settings` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FrontdoorBackendPoolArgs', 'FrontdoorBackendPoolArgsDict']]]] backend_pools: A `backend_pool` block as defined below.
               
               > Azure by default allows specifying up to 50 Backend Pools - but this quota can be increased via Microsoft Support.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] backend_pools_map: A map/dictionary of Backend Pool Names (key) to the Backend Pool ID (value)
        :param pulumi.Input[builtins.str] cname: The host that each frontendEndpoint must CNAME to.
        :param pulumi.Input[builtins.str] friendly_name: A friendly name for the Front Door service.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FrontdoorFrontendEndpointArgs', 'FrontdoorFrontendEndpointArgsDict']]]] frontend_endpoints: A `frontend_endpoint` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] frontend_endpoints_map: A map/dictionary of Frontend Endpoint Names (key) to the Frontend Endpoint ID (value)
        :param pulumi.Input[builtins.str] header_frontdoor_id: The unique ID of the Front Door which is embedded into the incoming headers `X-Azure-FDID` attribute and maybe used to filter traffic sent by the Front Door to your backend.
        :param pulumi.Input[builtins.bool] load_balancer_enabled: Should the Front Door Load Balancer be Enabled? Defaults to `true`.
        :param pulumi.Input[builtins.str] name: Specifies the name of the Front Door service. Must be globally unique. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] resource_group_name: Specifies the name of the Resource Group in which the Front Door service should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FrontdoorRoutingRuleArgs', 'FrontdoorRoutingRuleArgsDict']]]] routing_rules: A `routing_rule` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] routing_rules_map: A map/dictionary of Routing Rule Names (key) to the Routing Rule ID (value)
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FrontdoorState.__new__(_FrontdoorState)

        __props__.__dict__["backend_pool_health_probes"] = backend_pool_health_probes
        __props__.__dict__["backend_pool_health_probes_map"] = backend_pool_health_probes_map
        __props__.__dict__["backend_pool_load_balancing_settings_map"] = backend_pool_load_balancing_settings_map
        __props__.__dict__["backend_pool_load_balancings"] = backend_pool_load_balancings
        __props__.__dict__["backend_pool_settings"] = backend_pool_settings
        __props__.__dict__["backend_pools"] = backend_pools
        __props__.__dict__["backend_pools_map"] = backend_pools_map
        __props__.__dict__["cname"] = cname
        __props__.__dict__["explicit_resource_orders"] = explicit_resource_orders
        __props__.__dict__["friendly_name"] = friendly_name
        __props__.__dict__["frontend_endpoints"] = frontend_endpoints
        __props__.__dict__["frontend_endpoints_map"] = frontend_endpoints_map
        __props__.__dict__["header_frontdoor_id"] = header_frontdoor_id
        __props__.__dict__["load_balancer_enabled"] = load_balancer_enabled
        __props__.__dict__["name"] = name
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["routing_rules"] = routing_rules
        __props__.__dict__["routing_rules_map"] = routing_rules_map
        __props__.__dict__["tags"] = tags
        return Frontdoor(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="backendPoolHealthProbes")
    def backend_pool_health_probes(self) -> pulumi.Output[Sequence['outputs.FrontdoorBackendPoolHealthProbe']]:
        """
        A `backend_pool_health_probe` block as defined below.
        """
        return pulumi.get(self, "backend_pool_health_probes")

    @property
    @pulumi.getter(name="backendPoolHealthProbesMap")
    def backend_pool_health_probes_map(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        A map/dictionary of Backend Pool Health Probe Names (key) to the Backend Pool Health Probe ID (value)
        """
        return pulumi.get(self, "backend_pool_health_probes_map")

    @property
    @pulumi.getter(name="backendPoolLoadBalancingSettingsMap")
    def backend_pool_load_balancing_settings_map(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        A map/dictionary of Backend Pool Load Balancing Setting Names (key) to the Backend Pool Load Balancing Setting ID (value)
        """
        return pulumi.get(self, "backend_pool_load_balancing_settings_map")

    @property
    @pulumi.getter(name="backendPoolLoadBalancings")
    def backend_pool_load_balancings(self) -> pulumi.Output[Sequence['outputs.FrontdoorBackendPoolLoadBalancing']]:
        """
        A `backend_pool_load_balancing` block as defined below.
        """
        return pulumi.get(self, "backend_pool_load_balancings")

    @property
    @pulumi.getter(name="backendPoolSettings")
    def backend_pool_settings(self) -> pulumi.Output[Sequence['outputs.FrontdoorBackendPoolSetting']]:
        """
        A `backend_pool_settings` block as defined below.
        """
        return pulumi.get(self, "backend_pool_settings")

    @property
    @pulumi.getter(name="backendPools")
    def backend_pools(self) -> pulumi.Output[Sequence['outputs.FrontdoorBackendPool']]:
        """
        A `backend_pool` block as defined below.

        > Azure by default allows specifying up to 50 Backend Pools - but this quota can be increased via Microsoft Support.
        """
        return pulumi.get(self, "backend_pools")

    @property
    @pulumi.getter(name="backendPoolsMap")
    def backend_pools_map(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        A map/dictionary of Backend Pool Names (key) to the Backend Pool ID (value)
        """
        return pulumi.get(self, "backend_pools_map")

    @property
    @pulumi.getter
    def cname(self) -> pulumi.Output[builtins.str]:
        """
        The host that each frontendEndpoint must CNAME to.
        """
        return pulumi.get(self, "cname")

    @property
    @pulumi.getter(name="explicitResourceOrders")
    def explicit_resource_orders(self) -> pulumi.Output[Sequence['outputs.FrontdoorExplicitResourceOrder']]:
        return pulumi.get(self, "explicit_resource_orders")

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A friendly name for the Front Door service.
        """
        return pulumi.get(self, "friendly_name")

    @property
    @pulumi.getter(name="frontendEndpoints")
    def frontend_endpoints(self) -> pulumi.Output[Sequence['outputs.FrontdoorFrontendEndpoint']]:
        """
        A `frontend_endpoint` block as defined below.
        """
        return pulumi.get(self, "frontend_endpoints")

    @property
    @pulumi.getter(name="frontendEndpointsMap")
    def frontend_endpoints_map(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        A map/dictionary of Frontend Endpoint Names (key) to the Frontend Endpoint ID (value)
        """
        return pulumi.get(self, "frontend_endpoints_map")

    @property
    @pulumi.getter(name="headerFrontdoorId")
    def header_frontdoor_id(self) -> pulumi.Output[builtins.str]:
        """
        The unique ID of the Front Door which is embedded into the incoming headers `X-Azure-FDID` attribute and maybe used to filter traffic sent by the Front Door to your backend.
        """
        return pulumi.get(self, "header_frontdoor_id")

    @property
    @pulumi.getter(name="loadBalancerEnabled")
    def load_balancer_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Should the Front Door Load Balancer be Enabled? Defaults to `true`.
        """
        return pulumi.get(self, "load_balancer_enabled")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the name of the Front Door service. Must be globally unique. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the name of the Resource Group in which the Front Door service should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter(name="routingRules")
    def routing_rules(self) -> pulumi.Output[Sequence['outputs.FrontdoorRoutingRule']]:
        """
        A `routing_rule` block as defined below.
        """
        return pulumi.get(self, "routing_rules")

    @property
    @pulumi.getter(name="routingRulesMap")
    def routing_rules_map(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        A map/dictionary of Routing Rule Names (key) to the Routing Rule ID (value)
        """
        return pulumi.get(self, "routing_rules_map")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

