# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RulesEngineArgs', 'RulesEngine']

@pulumi.input_type
class RulesEngineArgs:
    def __init__(__self__, *,
                 frontdoor_name: pulumi.Input[builtins.str],
                 resource_group_name: pulumi.Input[builtins.str],
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['RulesEngineRuleArgs']]]] = None):
        """
        The set of arguments for constructing a RulesEngine resource.
        :param pulumi.Input[builtins.str] frontdoor_name: The name of the Front Door instance. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] enabled: Whether this Rules engine configuration is enabled? Defaults to `true`.
        :param pulumi.Input[builtins.str] name: The name of the Rules engine configuration. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input['RulesEngineRuleArgs']]] rules: A `rule` block as defined below.
        """
        pulumi.set(__self__, "frontdoor_name", frontdoor_name)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter(name="frontdoorName")
    def frontdoor_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the Front Door instance. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "frontdoor_name")

    @frontdoor_name.setter
    def frontdoor_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "frontdoor_name", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the resource group. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether this Rules engine configuration is enabled? Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Rules engine configuration. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RulesEngineRuleArgs']]]]:
        """
        A `rule` block as defined below.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RulesEngineRuleArgs']]]]):
        pulumi.set(self, "rules", value)


@pulumi.input_type
class _RulesEngineState:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 frontdoor_name: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['RulesEngineRuleArgs']]]] = None):
        """
        Input properties used for looking up and filtering RulesEngine resources.
        :param pulumi.Input[builtins.bool] enabled: Whether this Rules engine configuration is enabled? Defaults to `true`.
        :param pulumi.Input[builtins.str] frontdoor_name: The name of the Front Door instance. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: The name of the Rules engine configuration. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input['RulesEngineRuleArgs']]] rules: A `rule` block as defined below.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if frontdoor_name is not None:
            pulumi.set(__self__, "frontdoor_name", frontdoor_name)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether this Rules engine configuration is enabled? Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="frontdoorName")
    def frontdoor_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Front Door instance. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "frontdoor_name")

    @frontdoor_name.setter
    def frontdoor_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "frontdoor_name", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Rules engine configuration. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the resource group. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RulesEngineRuleArgs']]]]:
        """
        A `rule` block as defined below.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RulesEngineRuleArgs']]]]):
        pulumi.set(self, "rules", value)


@pulumi.type_token("azure:frontdoor/rulesEngine:RulesEngine")
class RulesEngine(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 frontdoor_name: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RulesEngineRuleArgs', 'RulesEngineRuleArgsDict']]]]] = None,
                 __props__=None):
        """
        !> **Note:** This deploys an Azure Front Door (classic) resource which has been deprecated and will receive security updates only. Please migrate your existing Azure Front Door (classic) deployments to the new Azure Front Door (standard/premium) resources. For your convenience, the service team has exposed a `Front Door Classic` to `Front Door Standard/Premium` [migration tool](https://learn.microsoft.com/azure/frontdoor/tier-migration) to allow you to migrate your existing `Front Door Classic` instances to the new `Front Door Standard/Premium` product tiers.

        !> **Note:** On `1 April 2025`, Azure Front Door (classic) will be retired for the public cloud, existing Azure Front Door (classic) resources must be migrated out of Azure Front Door (classic) to Azure Front Door Standard/Premium before `1 October 2025` to avoid potential disruptions in service.

        Manages an Azure Front Door (classic) Rules Engine configuration and rules.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-rg",
            location="West Europe")
        example_frontdoor = azure.frontdoor.Frontdoor("example",
            name="example",
            resource_group_name=example.name,
            backend_pools=[{
                "name": "exampleBackendBing",
                "load_balancing_name": "exampleLoadBalancingSettings1",
                "health_probe_name": "exampleHealthProbeSetting1",
                "backends": [{
                    "host_header": "www.bing.com",
                    "address": "www.bing.com",
                    "http_port": 80,
                    "https_port": 443,
                }],
            }],
            backend_pool_health_probes=[{
                "name": "exampleHealthProbeSetting1",
            }],
            backend_pool_load_balancings=[{
                "name": "exampleLoadBalancingSettings1",
            }],
            frontend_endpoints=[{
                "name": "exampleFrontendEndpoint1",
                "host_name": "example-FrontDoor.azurefd.net",
            }],
            routing_rules=[{
                "name": "exampleRoutingRule1",
                "accepted_protocols": [
                    "Http",
                    "Https",
                ],
                "patterns_to_matches": ["/*"],
                "frontend_endpoints": ["exampleFrontendEndpoint1"],
            }])
        example_rules_engine = azure.frontdoor.RulesEngine("example_rules_engine",
            name="exampleRulesEngineConfig1",
            frontdoor_name=example_frontdoor.name,
            resource_group_name=example_frontdoor.resource_group_name,
            rules=[
                {
                    "name": "debuggingoutput",
                    "priority": 1,
                    "action": {
                        "response_headers": [{
                            "header_action_type": "Append",
                            "header_name": "X-TEST-HEADER",
                            "value": "Append Header Rule",
                        }],
                    },
                },
                {
                    "name": "overwriteorigin",
                    "priority": 2,
                    "match_conditions": [{
                        "variable": "RequestMethod",
                        "operator": "Equal",
                        "values": [
                            "GET",
                            "POST",
                        ],
                    }],
                    "action": {
                        "response_headers": [
                            {
                                "header_action_type": "Overwrite",
                                "header_name": "Access-Control-Allow-Origin",
                                "value": "*",
                            },
                            {
                                "header_action_type": "Overwrite",
                                "header_name": "Access-Control-Allow-Credentials",
                                "value": "true",
                            },
                        ],
                    },
                },
            ])
        ```

        ## Import

        Azure Front Door Rules Engine's can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:frontdoor/rulesEngine:RulesEngine example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resGroup1/providers/Microsoft.Network/frontdoors/frontdoor1/rulesEngines/rule1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] enabled: Whether this Rules engine configuration is enabled? Defaults to `true`.
        :param pulumi.Input[builtins.str] frontdoor_name: The name of the Front Door instance. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: The name of the Rules engine configuration. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RulesEngineRuleArgs', 'RulesEngineRuleArgsDict']]]] rules: A `rule` block as defined below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RulesEngineArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        !> **Note:** This deploys an Azure Front Door (classic) resource which has been deprecated and will receive security updates only. Please migrate your existing Azure Front Door (classic) deployments to the new Azure Front Door (standard/premium) resources. For your convenience, the service team has exposed a `Front Door Classic` to `Front Door Standard/Premium` [migration tool](https://learn.microsoft.com/azure/frontdoor/tier-migration) to allow you to migrate your existing `Front Door Classic` instances to the new `Front Door Standard/Premium` product tiers.

        !> **Note:** On `1 April 2025`, Azure Front Door (classic) will be retired for the public cloud, existing Azure Front Door (classic) resources must be migrated out of Azure Front Door (classic) to Azure Front Door Standard/Premium before `1 October 2025` to avoid potential disruptions in service.

        Manages an Azure Front Door (classic) Rules Engine configuration and rules.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-rg",
            location="West Europe")
        example_frontdoor = azure.frontdoor.Frontdoor("example",
            name="example",
            resource_group_name=example.name,
            backend_pools=[{
                "name": "exampleBackendBing",
                "load_balancing_name": "exampleLoadBalancingSettings1",
                "health_probe_name": "exampleHealthProbeSetting1",
                "backends": [{
                    "host_header": "www.bing.com",
                    "address": "www.bing.com",
                    "http_port": 80,
                    "https_port": 443,
                }],
            }],
            backend_pool_health_probes=[{
                "name": "exampleHealthProbeSetting1",
            }],
            backend_pool_load_balancings=[{
                "name": "exampleLoadBalancingSettings1",
            }],
            frontend_endpoints=[{
                "name": "exampleFrontendEndpoint1",
                "host_name": "example-FrontDoor.azurefd.net",
            }],
            routing_rules=[{
                "name": "exampleRoutingRule1",
                "accepted_protocols": [
                    "Http",
                    "Https",
                ],
                "patterns_to_matches": ["/*"],
                "frontend_endpoints": ["exampleFrontendEndpoint1"],
            }])
        example_rules_engine = azure.frontdoor.RulesEngine("example_rules_engine",
            name="exampleRulesEngineConfig1",
            frontdoor_name=example_frontdoor.name,
            resource_group_name=example_frontdoor.resource_group_name,
            rules=[
                {
                    "name": "debuggingoutput",
                    "priority": 1,
                    "action": {
                        "response_headers": [{
                            "header_action_type": "Append",
                            "header_name": "X-TEST-HEADER",
                            "value": "Append Header Rule",
                        }],
                    },
                },
                {
                    "name": "overwriteorigin",
                    "priority": 2,
                    "match_conditions": [{
                        "variable": "RequestMethod",
                        "operator": "Equal",
                        "values": [
                            "GET",
                            "POST",
                        ],
                    }],
                    "action": {
                        "response_headers": [
                            {
                                "header_action_type": "Overwrite",
                                "header_name": "Access-Control-Allow-Origin",
                                "value": "*",
                            },
                            {
                                "header_action_type": "Overwrite",
                                "header_name": "Access-Control-Allow-Credentials",
                                "value": "true",
                            },
                        ],
                    },
                },
            ])
        ```

        ## Import

        Azure Front Door Rules Engine's can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:frontdoor/rulesEngine:RulesEngine example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resGroup1/providers/Microsoft.Network/frontdoors/frontdoor1/rulesEngines/rule1
        ```

        :param str resource_name: The name of the resource.
        :param RulesEngineArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RulesEngineArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 frontdoor_name: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RulesEngineRuleArgs', 'RulesEngineRuleArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RulesEngineArgs.__new__(RulesEngineArgs)

            __props__.__dict__["enabled"] = enabled
            if frontdoor_name is None and not opts.urn:
                raise TypeError("Missing required property 'frontdoor_name'")
            __props__.__dict__["frontdoor_name"] = frontdoor_name
            __props__.__dict__["name"] = name
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["rules"] = rules
            __props__.__dict__["location"] = None
        super(RulesEngine, __self__).__init__(
            'azure:frontdoor/rulesEngine:RulesEngine',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            enabled: Optional[pulumi.Input[builtins.bool]] = None,
            frontdoor_name: Optional[pulumi.Input[builtins.str]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
            rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RulesEngineRuleArgs', 'RulesEngineRuleArgsDict']]]]] = None) -> 'RulesEngine':
        """
        Get an existing RulesEngine resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] enabled: Whether this Rules engine configuration is enabled? Defaults to `true`.
        :param pulumi.Input[builtins.str] frontdoor_name: The name of the Front Door instance. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: The name of the Rules engine configuration. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RulesEngineRuleArgs', 'RulesEngineRuleArgsDict']]]] rules: A `rule` block as defined below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RulesEngineState.__new__(_RulesEngineState)

        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["frontdoor_name"] = frontdoor_name
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["rules"] = rules
        return RulesEngine(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether this Rules engine configuration is enabled? Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="frontdoorName")
    def frontdoor_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Front Door instance. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "frontdoor_name")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Rules engine configuration. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the resource group. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter
    def rules(self) -> pulumi.Output[Optional[Sequence['outputs.RulesEngineRule']]]:
        """
        A `rule` block as defined below.
        """
        return pulumi.get(self, "rules")

