# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['HBaseClusterArgs', 'HBaseCluster']

@pulumi.input_type
class HBaseClusterArgs:
    def __init__(__self__, *,
                 cluster_version: pulumi.Input[builtins.str],
                 component_version: pulumi.Input['HBaseClusterComponentVersionArgs'],
                 gateway: pulumi.Input['HBaseClusterGatewayArgs'],
                 resource_group_name: pulumi.Input[builtins.str],
                 roles: pulumi.Input['HBaseClusterRolesArgs'],
                 tier: pulumi.Input[builtins.str],
                 compute_isolation: Optional[pulumi.Input['HBaseClusterComputeIsolationArgs']] = None,
                 disk_encryptions: Optional[pulumi.Input[Sequence[pulumi.Input['HBaseClusterDiskEncryptionArgs']]]] = None,
                 extension: Optional[pulumi.Input['HBaseClusterExtensionArgs']] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 metastores: Optional[pulumi.Input['HBaseClusterMetastoresArgs']] = None,
                 monitor: Optional[pulumi.Input['HBaseClusterMonitorArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network: Optional[pulumi.Input['HBaseClusterNetworkArgs']] = None,
                 private_link_configuration: Optional[pulumi.Input['HBaseClusterPrivateLinkConfigurationArgs']] = None,
                 security_profile: Optional[pulumi.Input['HBaseClusterSecurityProfileArgs']] = None,
                 storage_account_gen2: Optional[pulumi.Input['HBaseClusterStorageAccountGen2Args']] = None,
                 storage_accounts: Optional[pulumi.Input[Sequence[pulumi.Input['HBaseClusterStorageAccountArgs']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tls_min_version: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a HBaseCluster resource.
        :param pulumi.Input[builtins.str] cluster_version: Specifies the Version of HDInsights which should be used for this Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input['HBaseClusterComponentVersionArgs'] component_version: A `component_version` block as defined below.
        :param pulumi.Input['HBaseClusterGatewayArgs'] gateway: A `gateway` block as defined below.
        :param pulumi.Input[builtins.str] resource_group_name: Specifies the name of the Resource Group in which this HDInsight HBase Cluster should exist. Changing this forces a new resource to be created.
        :param pulumi.Input['HBaseClusterRolesArgs'] roles: A `roles` block as defined below.
        :param pulumi.Input[builtins.str] tier: Specifies the Tier which should be used for this HDInsight HBase Cluster. Possible values are `Standard` or `Premium`. Changing this forces a new resource to be created.
        :param pulumi.Input['HBaseClusterComputeIsolationArgs'] compute_isolation: A `compute_isolation` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['HBaseClusterDiskEncryptionArgs']]] disk_encryptions: One or more `disk_encryption` block as defined below.
        :param pulumi.Input['HBaseClusterExtensionArgs'] extension: An `extension` block as defined below.
        :param pulumi.Input[builtins.str] location: Specifies the Azure Region which this HDInsight HBase Cluster should exist. Changing this forces a new resource to be created.
        :param pulumi.Input['HBaseClusterMetastoresArgs'] metastores: A `metastores` block as defined below.
        :param pulumi.Input['HBaseClusterMonitorArgs'] monitor: A `monitor` block as defined below.
        :param pulumi.Input[builtins.str] name: Specifies the name for this HDInsight HBase Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input['HBaseClusterNetworkArgs'] network: A `network` block as defined below.
        :param pulumi.Input['HBaseClusterPrivateLinkConfigurationArgs'] private_link_configuration: A `private_link_configuration` block as defined below.
        :param pulumi.Input['HBaseClusterSecurityProfileArgs'] security_profile: A `security_profile` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input['HBaseClusterStorageAccountGen2Args'] storage_account_gen2: A `storage_account_gen2` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['HBaseClusterStorageAccountArgs']]] storage_accounts: One or more `storage_account` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A map of Tags which should be assigned to this HDInsight HBase Cluster.
        :param pulumi.Input[builtins.str] tls_min_version: The minimal supported TLS version. Possible values are 1.0, 1.1 or 1.2. Changing this forces a new resource to be created.
               
               > **Note:** Starting on June 30, 2020, Azure HDInsight will enforce TLS 1.2 or later versions for all HTTPS connections. For more information, see [Azure HDInsight TLS 1.2 Enforcement](https://azure.microsoft.com/en-us/updates/azure-hdinsight-tls-12-enforcement/).
        """
        pulumi.set(__self__, "cluster_version", cluster_version)
        pulumi.set(__self__, "component_version", component_version)
        pulumi.set(__self__, "gateway", gateway)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "roles", roles)
        pulumi.set(__self__, "tier", tier)
        if compute_isolation is not None:
            pulumi.set(__self__, "compute_isolation", compute_isolation)
        if disk_encryptions is not None:
            pulumi.set(__self__, "disk_encryptions", disk_encryptions)
        if extension is not None:
            pulumi.set(__self__, "extension", extension)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if metastores is not None:
            pulumi.set(__self__, "metastores", metastores)
        if monitor is not None:
            pulumi.set(__self__, "monitor", monitor)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if private_link_configuration is not None:
            pulumi.set(__self__, "private_link_configuration", private_link_configuration)
        if security_profile is not None:
            pulumi.set(__self__, "security_profile", security_profile)
        if storage_account_gen2 is not None:
            pulumi.set(__self__, "storage_account_gen2", storage_account_gen2)
        if storage_accounts is not None:
            pulumi.set(__self__, "storage_accounts", storage_accounts)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tls_min_version is not None:
            pulumi.set(__self__, "tls_min_version", tls_min_version)

    @property
    @pulumi.getter(name="clusterVersion")
    def cluster_version(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the Version of HDInsights which should be used for this Cluster. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "cluster_version")

    @cluster_version.setter
    def cluster_version(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "cluster_version", value)

    @property
    @pulumi.getter(name="componentVersion")
    def component_version(self) -> pulumi.Input['HBaseClusterComponentVersionArgs']:
        """
        A `component_version` block as defined below.
        """
        return pulumi.get(self, "component_version")

    @component_version.setter
    def component_version(self, value: pulumi.Input['HBaseClusterComponentVersionArgs']):
        pulumi.set(self, "component_version", value)

    @property
    @pulumi.getter
    def gateway(self) -> pulumi.Input['HBaseClusterGatewayArgs']:
        """
        A `gateway` block as defined below.
        """
        return pulumi.get(self, "gateway")

    @gateway.setter
    def gateway(self, value: pulumi.Input['HBaseClusterGatewayArgs']):
        pulumi.set(self, "gateway", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the name of the Resource Group in which this HDInsight HBase Cluster should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter
    def roles(self) -> pulumi.Input['HBaseClusterRolesArgs']:
        """
        A `roles` block as defined below.
        """
        return pulumi.get(self, "roles")

    @roles.setter
    def roles(self, value: pulumi.Input['HBaseClusterRolesArgs']):
        pulumi.set(self, "roles", value)

    @property
    @pulumi.getter
    def tier(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the Tier which should be used for this HDInsight HBase Cluster. Possible values are `Standard` or `Premium`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "tier")

    @tier.setter
    def tier(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "tier", value)

    @property
    @pulumi.getter(name="computeIsolation")
    def compute_isolation(self) -> Optional[pulumi.Input['HBaseClusterComputeIsolationArgs']]:
        """
        A `compute_isolation` block as defined below.
        """
        return pulumi.get(self, "compute_isolation")

    @compute_isolation.setter
    def compute_isolation(self, value: Optional[pulumi.Input['HBaseClusterComputeIsolationArgs']]):
        pulumi.set(self, "compute_isolation", value)

    @property
    @pulumi.getter(name="diskEncryptions")
    def disk_encryptions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['HBaseClusterDiskEncryptionArgs']]]]:
        """
        One or more `disk_encryption` block as defined below.
        """
        return pulumi.get(self, "disk_encryptions")

    @disk_encryptions.setter
    def disk_encryptions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['HBaseClusterDiskEncryptionArgs']]]]):
        pulumi.set(self, "disk_encryptions", value)

    @property
    @pulumi.getter
    def extension(self) -> Optional[pulumi.Input['HBaseClusterExtensionArgs']]:
        """
        An `extension` block as defined below.
        """
        return pulumi.get(self, "extension")

    @extension.setter
    def extension(self, value: Optional[pulumi.Input['HBaseClusterExtensionArgs']]):
        pulumi.set(self, "extension", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the Azure Region which this HDInsight HBase Cluster should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def metastores(self) -> Optional[pulumi.Input['HBaseClusterMetastoresArgs']]:
        """
        A `metastores` block as defined below.
        """
        return pulumi.get(self, "metastores")

    @metastores.setter
    def metastores(self, value: Optional[pulumi.Input['HBaseClusterMetastoresArgs']]):
        pulumi.set(self, "metastores", value)

    @property
    @pulumi.getter
    def monitor(self) -> Optional[pulumi.Input['HBaseClusterMonitorArgs']]:
        """
        A `monitor` block as defined below.
        """
        return pulumi.get(self, "monitor")

    @monitor.setter
    def monitor(self, value: Optional[pulumi.Input['HBaseClusterMonitorArgs']]):
        pulumi.set(self, "monitor", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name for this HDInsight HBase Cluster. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input['HBaseClusterNetworkArgs']]:
        """
        A `network` block as defined below.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input['HBaseClusterNetworkArgs']]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter(name="privateLinkConfiguration")
    def private_link_configuration(self) -> Optional[pulumi.Input['HBaseClusterPrivateLinkConfigurationArgs']]:
        """
        A `private_link_configuration` block as defined below.
        """
        return pulumi.get(self, "private_link_configuration")

    @private_link_configuration.setter
    def private_link_configuration(self, value: Optional[pulumi.Input['HBaseClusterPrivateLinkConfigurationArgs']]):
        pulumi.set(self, "private_link_configuration", value)

    @property
    @pulumi.getter(name="securityProfile")
    def security_profile(self) -> Optional[pulumi.Input['HBaseClusterSecurityProfileArgs']]:
        """
        A `security_profile` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "security_profile")

    @security_profile.setter
    def security_profile(self, value: Optional[pulumi.Input['HBaseClusterSecurityProfileArgs']]):
        pulumi.set(self, "security_profile", value)

    @property
    @pulumi.getter(name="storageAccountGen2")
    def storage_account_gen2(self) -> Optional[pulumi.Input['HBaseClusterStorageAccountGen2Args']]:
        """
        A `storage_account_gen2` block as defined below.
        """
        return pulumi.get(self, "storage_account_gen2")

    @storage_account_gen2.setter
    def storage_account_gen2(self, value: Optional[pulumi.Input['HBaseClusterStorageAccountGen2Args']]):
        pulumi.set(self, "storage_account_gen2", value)

    @property
    @pulumi.getter(name="storageAccounts")
    def storage_accounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['HBaseClusterStorageAccountArgs']]]]:
        """
        One or more `storage_account` block as defined below.
        """
        return pulumi.get(self, "storage_accounts")

    @storage_accounts.setter
    def storage_accounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['HBaseClusterStorageAccountArgs']]]]):
        pulumi.set(self, "storage_accounts", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of Tags which should be assigned to this HDInsight HBase Cluster.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tlsMinVersion")
    def tls_min_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The minimal supported TLS version. Possible values are 1.0, 1.1 or 1.2. Changing this forces a new resource to be created.

        > **Note:** Starting on June 30, 2020, Azure HDInsight will enforce TLS 1.2 or later versions for all HTTPS connections. For more information, see [Azure HDInsight TLS 1.2 Enforcement](https://azure.microsoft.com/en-us/updates/azure-hdinsight-tls-12-enforcement/).
        """
        return pulumi.get(self, "tls_min_version")

    @tls_min_version.setter
    def tls_min_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tls_min_version", value)


@pulumi.input_type
class _HBaseClusterState:
    def __init__(__self__, *,
                 cluster_version: Optional[pulumi.Input[builtins.str]] = None,
                 component_version: Optional[pulumi.Input['HBaseClusterComponentVersionArgs']] = None,
                 compute_isolation: Optional[pulumi.Input['HBaseClusterComputeIsolationArgs']] = None,
                 disk_encryptions: Optional[pulumi.Input[Sequence[pulumi.Input['HBaseClusterDiskEncryptionArgs']]]] = None,
                 extension: Optional[pulumi.Input['HBaseClusterExtensionArgs']] = None,
                 gateway: Optional[pulumi.Input['HBaseClusterGatewayArgs']] = None,
                 https_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 metastores: Optional[pulumi.Input['HBaseClusterMetastoresArgs']] = None,
                 monitor: Optional[pulumi.Input['HBaseClusterMonitorArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network: Optional[pulumi.Input['HBaseClusterNetworkArgs']] = None,
                 private_link_configuration: Optional[pulumi.Input['HBaseClusterPrivateLinkConfigurationArgs']] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 roles: Optional[pulumi.Input['HBaseClusterRolesArgs']] = None,
                 security_profile: Optional[pulumi.Input['HBaseClusterSecurityProfileArgs']] = None,
                 ssh_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 storage_account_gen2: Optional[pulumi.Input['HBaseClusterStorageAccountGen2Args']] = None,
                 storage_accounts: Optional[pulumi.Input[Sequence[pulumi.Input['HBaseClusterStorageAccountArgs']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tier: Optional[pulumi.Input[builtins.str]] = None,
                 tls_min_version: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering HBaseCluster resources.
        :param pulumi.Input[builtins.str] cluster_version: Specifies the Version of HDInsights which should be used for this Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input['HBaseClusterComponentVersionArgs'] component_version: A `component_version` block as defined below.
        :param pulumi.Input['HBaseClusterComputeIsolationArgs'] compute_isolation: A `compute_isolation` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['HBaseClusterDiskEncryptionArgs']]] disk_encryptions: One or more `disk_encryption` block as defined below.
        :param pulumi.Input['HBaseClusterExtensionArgs'] extension: An `extension` block as defined below.
        :param pulumi.Input['HBaseClusterGatewayArgs'] gateway: A `gateway` block as defined below.
        :param pulumi.Input[builtins.str] https_endpoint: The HTTPS Connectivity Endpoint for this HDInsight HBase Cluster.
        :param pulumi.Input[builtins.str] location: Specifies the Azure Region which this HDInsight HBase Cluster should exist. Changing this forces a new resource to be created.
        :param pulumi.Input['HBaseClusterMetastoresArgs'] metastores: A `metastores` block as defined below.
        :param pulumi.Input['HBaseClusterMonitorArgs'] monitor: A `monitor` block as defined below.
        :param pulumi.Input[builtins.str] name: Specifies the name for this HDInsight HBase Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input['HBaseClusterNetworkArgs'] network: A `network` block as defined below.
        :param pulumi.Input['HBaseClusterPrivateLinkConfigurationArgs'] private_link_configuration: A `private_link_configuration` block as defined below.
        :param pulumi.Input[builtins.str] resource_group_name: Specifies the name of the Resource Group in which this HDInsight HBase Cluster should exist. Changing this forces a new resource to be created.
        :param pulumi.Input['HBaseClusterRolesArgs'] roles: A `roles` block as defined below.
        :param pulumi.Input['HBaseClusterSecurityProfileArgs'] security_profile: A `security_profile` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] ssh_endpoint: The SSH Connectivity Endpoint for this HDInsight HBase Cluster.
        :param pulumi.Input['HBaseClusterStorageAccountGen2Args'] storage_account_gen2: A `storage_account_gen2` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['HBaseClusterStorageAccountArgs']]] storage_accounts: One or more `storage_account` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A map of Tags which should be assigned to this HDInsight HBase Cluster.
        :param pulumi.Input[builtins.str] tier: Specifies the Tier which should be used for this HDInsight HBase Cluster. Possible values are `Standard` or `Premium`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] tls_min_version: The minimal supported TLS version. Possible values are 1.0, 1.1 or 1.2. Changing this forces a new resource to be created.
               
               > **Note:** Starting on June 30, 2020, Azure HDInsight will enforce TLS 1.2 or later versions for all HTTPS connections. For more information, see [Azure HDInsight TLS 1.2 Enforcement](https://azure.microsoft.com/en-us/updates/azure-hdinsight-tls-12-enforcement/).
        """
        if cluster_version is not None:
            pulumi.set(__self__, "cluster_version", cluster_version)
        if component_version is not None:
            pulumi.set(__self__, "component_version", component_version)
        if compute_isolation is not None:
            pulumi.set(__self__, "compute_isolation", compute_isolation)
        if disk_encryptions is not None:
            pulumi.set(__self__, "disk_encryptions", disk_encryptions)
        if extension is not None:
            pulumi.set(__self__, "extension", extension)
        if gateway is not None:
            pulumi.set(__self__, "gateway", gateway)
        if https_endpoint is not None:
            pulumi.set(__self__, "https_endpoint", https_endpoint)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if metastores is not None:
            pulumi.set(__self__, "metastores", metastores)
        if monitor is not None:
            pulumi.set(__self__, "monitor", monitor)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if private_link_configuration is not None:
            pulumi.set(__self__, "private_link_configuration", private_link_configuration)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if roles is not None:
            pulumi.set(__self__, "roles", roles)
        if security_profile is not None:
            pulumi.set(__self__, "security_profile", security_profile)
        if ssh_endpoint is not None:
            pulumi.set(__self__, "ssh_endpoint", ssh_endpoint)
        if storage_account_gen2 is not None:
            pulumi.set(__self__, "storage_account_gen2", storage_account_gen2)
        if storage_accounts is not None:
            pulumi.set(__self__, "storage_accounts", storage_accounts)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)
        if tls_min_version is not None:
            pulumi.set(__self__, "tls_min_version", tls_min_version)

    @property
    @pulumi.getter(name="clusterVersion")
    def cluster_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the Version of HDInsights which should be used for this Cluster. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "cluster_version")

    @cluster_version.setter
    def cluster_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cluster_version", value)

    @property
    @pulumi.getter(name="componentVersion")
    def component_version(self) -> Optional[pulumi.Input['HBaseClusterComponentVersionArgs']]:
        """
        A `component_version` block as defined below.
        """
        return pulumi.get(self, "component_version")

    @component_version.setter
    def component_version(self, value: Optional[pulumi.Input['HBaseClusterComponentVersionArgs']]):
        pulumi.set(self, "component_version", value)

    @property
    @pulumi.getter(name="computeIsolation")
    def compute_isolation(self) -> Optional[pulumi.Input['HBaseClusterComputeIsolationArgs']]:
        """
        A `compute_isolation` block as defined below.
        """
        return pulumi.get(self, "compute_isolation")

    @compute_isolation.setter
    def compute_isolation(self, value: Optional[pulumi.Input['HBaseClusterComputeIsolationArgs']]):
        pulumi.set(self, "compute_isolation", value)

    @property
    @pulumi.getter(name="diskEncryptions")
    def disk_encryptions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['HBaseClusterDiskEncryptionArgs']]]]:
        """
        One or more `disk_encryption` block as defined below.
        """
        return pulumi.get(self, "disk_encryptions")

    @disk_encryptions.setter
    def disk_encryptions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['HBaseClusterDiskEncryptionArgs']]]]):
        pulumi.set(self, "disk_encryptions", value)

    @property
    @pulumi.getter
    def extension(self) -> Optional[pulumi.Input['HBaseClusterExtensionArgs']]:
        """
        An `extension` block as defined below.
        """
        return pulumi.get(self, "extension")

    @extension.setter
    def extension(self, value: Optional[pulumi.Input['HBaseClusterExtensionArgs']]):
        pulumi.set(self, "extension", value)

    @property
    @pulumi.getter
    def gateway(self) -> Optional[pulumi.Input['HBaseClusterGatewayArgs']]:
        """
        A `gateway` block as defined below.
        """
        return pulumi.get(self, "gateway")

    @gateway.setter
    def gateway(self, value: Optional[pulumi.Input['HBaseClusterGatewayArgs']]):
        pulumi.set(self, "gateway", value)

    @property
    @pulumi.getter(name="httpsEndpoint")
    def https_endpoint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The HTTPS Connectivity Endpoint for this HDInsight HBase Cluster.
        """
        return pulumi.get(self, "https_endpoint")

    @https_endpoint.setter
    def https_endpoint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "https_endpoint", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the Azure Region which this HDInsight HBase Cluster should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def metastores(self) -> Optional[pulumi.Input['HBaseClusterMetastoresArgs']]:
        """
        A `metastores` block as defined below.
        """
        return pulumi.get(self, "metastores")

    @metastores.setter
    def metastores(self, value: Optional[pulumi.Input['HBaseClusterMetastoresArgs']]):
        pulumi.set(self, "metastores", value)

    @property
    @pulumi.getter
    def monitor(self) -> Optional[pulumi.Input['HBaseClusterMonitorArgs']]:
        """
        A `monitor` block as defined below.
        """
        return pulumi.get(self, "monitor")

    @monitor.setter
    def monitor(self, value: Optional[pulumi.Input['HBaseClusterMonitorArgs']]):
        pulumi.set(self, "monitor", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name for this HDInsight HBase Cluster. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input['HBaseClusterNetworkArgs']]:
        """
        A `network` block as defined below.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input['HBaseClusterNetworkArgs']]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter(name="privateLinkConfiguration")
    def private_link_configuration(self) -> Optional[pulumi.Input['HBaseClusterPrivateLinkConfigurationArgs']]:
        """
        A `private_link_configuration` block as defined below.
        """
        return pulumi.get(self, "private_link_configuration")

    @private_link_configuration.setter
    def private_link_configuration(self, value: Optional[pulumi.Input['HBaseClusterPrivateLinkConfigurationArgs']]):
        pulumi.set(self, "private_link_configuration", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the Resource Group in which this HDInsight HBase Cluster should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter
    def roles(self) -> Optional[pulumi.Input['HBaseClusterRolesArgs']]:
        """
        A `roles` block as defined below.
        """
        return pulumi.get(self, "roles")

    @roles.setter
    def roles(self, value: Optional[pulumi.Input['HBaseClusterRolesArgs']]):
        pulumi.set(self, "roles", value)

    @property
    @pulumi.getter(name="securityProfile")
    def security_profile(self) -> Optional[pulumi.Input['HBaseClusterSecurityProfileArgs']]:
        """
        A `security_profile` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "security_profile")

    @security_profile.setter
    def security_profile(self, value: Optional[pulumi.Input['HBaseClusterSecurityProfileArgs']]):
        pulumi.set(self, "security_profile", value)

    @property
    @pulumi.getter(name="sshEndpoint")
    def ssh_endpoint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The SSH Connectivity Endpoint for this HDInsight HBase Cluster.
        """
        return pulumi.get(self, "ssh_endpoint")

    @ssh_endpoint.setter
    def ssh_endpoint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ssh_endpoint", value)

    @property
    @pulumi.getter(name="storageAccountGen2")
    def storage_account_gen2(self) -> Optional[pulumi.Input['HBaseClusterStorageAccountGen2Args']]:
        """
        A `storage_account_gen2` block as defined below.
        """
        return pulumi.get(self, "storage_account_gen2")

    @storage_account_gen2.setter
    def storage_account_gen2(self, value: Optional[pulumi.Input['HBaseClusterStorageAccountGen2Args']]):
        pulumi.set(self, "storage_account_gen2", value)

    @property
    @pulumi.getter(name="storageAccounts")
    def storage_accounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['HBaseClusterStorageAccountArgs']]]]:
        """
        One or more `storage_account` block as defined below.
        """
        return pulumi.get(self, "storage_accounts")

    @storage_accounts.setter
    def storage_accounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['HBaseClusterStorageAccountArgs']]]]):
        pulumi.set(self, "storage_accounts", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of Tags which should be assigned to this HDInsight HBase Cluster.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def tier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the Tier which should be used for this HDInsight HBase Cluster. Possible values are `Standard` or `Premium`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "tier")

    @tier.setter
    def tier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tier", value)

    @property
    @pulumi.getter(name="tlsMinVersion")
    def tls_min_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The minimal supported TLS version. Possible values are 1.0, 1.1 or 1.2. Changing this forces a new resource to be created.

        > **Note:** Starting on June 30, 2020, Azure HDInsight will enforce TLS 1.2 or later versions for all HTTPS connections. For more information, see [Azure HDInsight TLS 1.2 Enforcement](https://azure.microsoft.com/en-us/updates/azure-hdinsight-tls-12-enforcement/).
        """
        return pulumi.get(self, "tls_min_version")

    @tls_min_version.setter
    def tls_min_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tls_min_version", value)


@pulumi.type_token("azure:hdinsight/hBaseCluster:HBaseCluster")
class HBaseCluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_version: Optional[pulumi.Input[builtins.str]] = None,
                 component_version: Optional[pulumi.Input[Union['HBaseClusterComponentVersionArgs', 'HBaseClusterComponentVersionArgsDict']]] = None,
                 compute_isolation: Optional[pulumi.Input[Union['HBaseClusterComputeIsolationArgs', 'HBaseClusterComputeIsolationArgsDict']]] = None,
                 disk_encryptions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['HBaseClusterDiskEncryptionArgs', 'HBaseClusterDiskEncryptionArgsDict']]]]] = None,
                 extension: Optional[pulumi.Input[Union['HBaseClusterExtensionArgs', 'HBaseClusterExtensionArgsDict']]] = None,
                 gateway: Optional[pulumi.Input[Union['HBaseClusterGatewayArgs', 'HBaseClusterGatewayArgsDict']]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 metastores: Optional[pulumi.Input[Union['HBaseClusterMetastoresArgs', 'HBaseClusterMetastoresArgsDict']]] = None,
                 monitor: Optional[pulumi.Input[Union['HBaseClusterMonitorArgs', 'HBaseClusterMonitorArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network: Optional[pulumi.Input[Union['HBaseClusterNetworkArgs', 'HBaseClusterNetworkArgsDict']]] = None,
                 private_link_configuration: Optional[pulumi.Input[Union['HBaseClusterPrivateLinkConfigurationArgs', 'HBaseClusterPrivateLinkConfigurationArgsDict']]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 roles: Optional[pulumi.Input[Union['HBaseClusterRolesArgs', 'HBaseClusterRolesArgsDict']]] = None,
                 security_profile: Optional[pulumi.Input[Union['HBaseClusterSecurityProfileArgs', 'HBaseClusterSecurityProfileArgsDict']]] = None,
                 storage_account_gen2: Optional[pulumi.Input[Union['HBaseClusterStorageAccountGen2Args', 'HBaseClusterStorageAccountGen2ArgsDict']]] = None,
                 storage_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['HBaseClusterStorageAccountArgs', 'HBaseClusterStorageAccountArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tier: Optional[pulumi.Input[builtins.str]] = None,
                 tls_min_version: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages a HDInsight HBase Cluster.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_account = azure.storage.Account("example",
            name="hdinsightstor",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS")
        example_container = azure.storage.Container("example",
            name="hdinsight",
            storage_account_name=example_account.name,
            container_access_type="private")
        example_h_base_cluster = azure.hdinsight.HBaseCluster("example",
            name="example-hdicluster",
            resource_group_name=example.name,
            location=example.location,
            cluster_version="3.6",
            tier="Standard",
            component_version={
                "hbase": "1.1",
            },
            gateway={
                "username": "acctestusrgw",
                "password": "Password123!",
            },
            storage_accounts=[{
                "storage_container_id": example_container.id,
                "storage_account_key": example_account.primary_access_key,
                "is_default": True,
            }],
            roles={
                "head_node": {
                    "vm_size": "Standard_D3_V2",
                    "username": "acctestusrvm",
                    "password": "AccTestvdSC4daf986!",
                },
                "worker_node": {
                    "vm_size": "Standard_D3_V2",
                    "username": "acctestusrvm",
                    "password": "AccTestvdSC4daf986!",
                    "target_instance_count": 3,
                },
                "zookeeper_node": {
                    "vm_size": "Standard_D3_V2",
                    "username": "acctestusrvm",
                    "password": "AccTestvdSC4daf986!",
                },
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.HDInsight`: 2021-06-01

        ## Import

        HDInsight HBase Clusters can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:hdinsight/hBaseCluster:HBaseCluster example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.HDInsight/clusters/cluster1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] cluster_version: Specifies the Version of HDInsights which should be used for this Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['HBaseClusterComponentVersionArgs', 'HBaseClusterComponentVersionArgsDict']] component_version: A `component_version` block as defined below.
        :param pulumi.Input[Union['HBaseClusterComputeIsolationArgs', 'HBaseClusterComputeIsolationArgsDict']] compute_isolation: A `compute_isolation` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['HBaseClusterDiskEncryptionArgs', 'HBaseClusterDiskEncryptionArgsDict']]]] disk_encryptions: One or more `disk_encryption` block as defined below.
        :param pulumi.Input[Union['HBaseClusterExtensionArgs', 'HBaseClusterExtensionArgsDict']] extension: An `extension` block as defined below.
        :param pulumi.Input[Union['HBaseClusterGatewayArgs', 'HBaseClusterGatewayArgsDict']] gateway: A `gateway` block as defined below.
        :param pulumi.Input[builtins.str] location: Specifies the Azure Region which this HDInsight HBase Cluster should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['HBaseClusterMetastoresArgs', 'HBaseClusterMetastoresArgsDict']] metastores: A `metastores` block as defined below.
        :param pulumi.Input[Union['HBaseClusterMonitorArgs', 'HBaseClusterMonitorArgsDict']] monitor: A `monitor` block as defined below.
        :param pulumi.Input[builtins.str] name: Specifies the name for this HDInsight HBase Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['HBaseClusterNetworkArgs', 'HBaseClusterNetworkArgsDict']] network: A `network` block as defined below.
        :param pulumi.Input[Union['HBaseClusterPrivateLinkConfigurationArgs', 'HBaseClusterPrivateLinkConfigurationArgsDict']] private_link_configuration: A `private_link_configuration` block as defined below.
        :param pulumi.Input[builtins.str] resource_group_name: Specifies the name of the Resource Group in which this HDInsight HBase Cluster should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['HBaseClusterRolesArgs', 'HBaseClusterRolesArgsDict']] roles: A `roles` block as defined below.
        :param pulumi.Input[Union['HBaseClusterSecurityProfileArgs', 'HBaseClusterSecurityProfileArgsDict']] security_profile: A `security_profile` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['HBaseClusterStorageAccountGen2Args', 'HBaseClusterStorageAccountGen2ArgsDict']] storage_account_gen2: A `storage_account_gen2` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['HBaseClusterStorageAccountArgs', 'HBaseClusterStorageAccountArgsDict']]]] storage_accounts: One or more `storage_account` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A map of Tags which should be assigned to this HDInsight HBase Cluster.
        :param pulumi.Input[builtins.str] tier: Specifies the Tier which should be used for this HDInsight HBase Cluster. Possible values are `Standard` or `Premium`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] tls_min_version: The minimal supported TLS version. Possible values are 1.0, 1.1 or 1.2. Changing this forces a new resource to be created.
               
               > **Note:** Starting on June 30, 2020, Azure HDInsight will enforce TLS 1.2 or later versions for all HTTPS connections. For more information, see [Azure HDInsight TLS 1.2 Enforcement](https://azure.microsoft.com/en-us/updates/azure-hdinsight-tls-12-enforcement/).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: HBaseClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a HDInsight HBase Cluster.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_account = azure.storage.Account("example",
            name="hdinsightstor",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS")
        example_container = azure.storage.Container("example",
            name="hdinsight",
            storage_account_name=example_account.name,
            container_access_type="private")
        example_h_base_cluster = azure.hdinsight.HBaseCluster("example",
            name="example-hdicluster",
            resource_group_name=example.name,
            location=example.location,
            cluster_version="3.6",
            tier="Standard",
            component_version={
                "hbase": "1.1",
            },
            gateway={
                "username": "acctestusrgw",
                "password": "Password123!",
            },
            storage_accounts=[{
                "storage_container_id": example_container.id,
                "storage_account_key": example_account.primary_access_key,
                "is_default": True,
            }],
            roles={
                "head_node": {
                    "vm_size": "Standard_D3_V2",
                    "username": "acctestusrvm",
                    "password": "AccTestvdSC4daf986!",
                },
                "worker_node": {
                    "vm_size": "Standard_D3_V2",
                    "username": "acctestusrvm",
                    "password": "AccTestvdSC4daf986!",
                    "target_instance_count": 3,
                },
                "zookeeper_node": {
                    "vm_size": "Standard_D3_V2",
                    "username": "acctestusrvm",
                    "password": "AccTestvdSC4daf986!",
                },
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.HDInsight`: 2021-06-01

        ## Import

        HDInsight HBase Clusters can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:hdinsight/hBaseCluster:HBaseCluster example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.HDInsight/clusters/cluster1
        ```

        :param str resource_name: The name of the resource.
        :param HBaseClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(HBaseClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_version: Optional[pulumi.Input[builtins.str]] = None,
                 component_version: Optional[pulumi.Input[Union['HBaseClusterComponentVersionArgs', 'HBaseClusterComponentVersionArgsDict']]] = None,
                 compute_isolation: Optional[pulumi.Input[Union['HBaseClusterComputeIsolationArgs', 'HBaseClusterComputeIsolationArgsDict']]] = None,
                 disk_encryptions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['HBaseClusterDiskEncryptionArgs', 'HBaseClusterDiskEncryptionArgsDict']]]]] = None,
                 extension: Optional[pulumi.Input[Union['HBaseClusterExtensionArgs', 'HBaseClusterExtensionArgsDict']]] = None,
                 gateway: Optional[pulumi.Input[Union['HBaseClusterGatewayArgs', 'HBaseClusterGatewayArgsDict']]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 metastores: Optional[pulumi.Input[Union['HBaseClusterMetastoresArgs', 'HBaseClusterMetastoresArgsDict']]] = None,
                 monitor: Optional[pulumi.Input[Union['HBaseClusterMonitorArgs', 'HBaseClusterMonitorArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network: Optional[pulumi.Input[Union['HBaseClusterNetworkArgs', 'HBaseClusterNetworkArgsDict']]] = None,
                 private_link_configuration: Optional[pulumi.Input[Union['HBaseClusterPrivateLinkConfigurationArgs', 'HBaseClusterPrivateLinkConfigurationArgsDict']]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 roles: Optional[pulumi.Input[Union['HBaseClusterRolesArgs', 'HBaseClusterRolesArgsDict']]] = None,
                 security_profile: Optional[pulumi.Input[Union['HBaseClusterSecurityProfileArgs', 'HBaseClusterSecurityProfileArgsDict']]] = None,
                 storage_account_gen2: Optional[pulumi.Input[Union['HBaseClusterStorageAccountGen2Args', 'HBaseClusterStorageAccountGen2ArgsDict']]] = None,
                 storage_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['HBaseClusterStorageAccountArgs', 'HBaseClusterStorageAccountArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tier: Optional[pulumi.Input[builtins.str]] = None,
                 tls_min_version: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = HBaseClusterArgs.__new__(HBaseClusterArgs)

            if cluster_version is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_version'")
            __props__.__dict__["cluster_version"] = cluster_version
            if component_version is None and not opts.urn:
                raise TypeError("Missing required property 'component_version'")
            __props__.__dict__["component_version"] = component_version
            __props__.__dict__["compute_isolation"] = compute_isolation
            __props__.__dict__["disk_encryptions"] = disk_encryptions
            __props__.__dict__["extension"] = extension
            if gateway is None and not opts.urn:
                raise TypeError("Missing required property 'gateway'")
            __props__.__dict__["gateway"] = gateway
            __props__.__dict__["location"] = location
            __props__.__dict__["metastores"] = metastores
            __props__.__dict__["monitor"] = monitor
            __props__.__dict__["name"] = name
            __props__.__dict__["network"] = network
            __props__.__dict__["private_link_configuration"] = private_link_configuration
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            if roles is None and not opts.urn:
                raise TypeError("Missing required property 'roles'")
            __props__.__dict__["roles"] = roles
            __props__.__dict__["security_profile"] = security_profile
            __props__.__dict__["storage_account_gen2"] = storage_account_gen2
            __props__.__dict__["storage_accounts"] = storage_accounts
            __props__.__dict__["tags"] = tags
            if tier is None and not opts.urn:
                raise TypeError("Missing required property 'tier'")
            __props__.__dict__["tier"] = tier
            __props__.__dict__["tls_min_version"] = tls_min_version
            __props__.__dict__["https_endpoint"] = None
            __props__.__dict__["ssh_endpoint"] = None
        super(HBaseCluster, __self__).__init__(
            'azure:hdinsight/hBaseCluster:HBaseCluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cluster_version: Optional[pulumi.Input[builtins.str]] = None,
            component_version: Optional[pulumi.Input[Union['HBaseClusterComponentVersionArgs', 'HBaseClusterComponentVersionArgsDict']]] = None,
            compute_isolation: Optional[pulumi.Input[Union['HBaseClusterComputeIsolationArgs', 'HBaseClusterComputeIsolationArgsDict']]] = None,
            disk_encryptions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['HBaseClusterDiskEncryptionArgs', 'HBaseClusterDiskEncryptionArgsDict']]]]] = None,
            extension: Optional[pulumi.Input[Union['HBaseClusterExtensionArgs', 'HBaseClusterExtensionArgsDict']]] = None,
            gateway: Optional[pulumi.Input[Union['HBaseClusterGatewayArgs', 'HBaseClusterGatewayArgsDict']]] = None,
            https_endpoint: Optional[pulumi.Input[builtins.str]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            metastores: Optional[pulumi.Input[Union['HBaseClusterMetastoresArgs', 'HBaseClusterMetastoresArgsDict']]] = None,
            monitor: Optional[pulumi.Input[Union['HBaseClusterMonitorArgs', 'HBaseClusterMonitorArgsDict']]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            network: Optional[pulumi.Input[Union['HBaseClusterNetworkArgs', 'HBaseClusterNetworkArgsDict']]] = None,
            private_link_configuration: Optional[pulumi.Input[Union['HBaseClusterPrivateLinkConfigurationArgs', 'HBaseClusterPrivateLinkConfigurationArgsDict']]] = None,
            resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
            roles: Optional[pulumi.Input[Union['HBaseClusterRolesArgs', 'HBaseClusterRolesArgsDict']]] = None,
            security_profile: Optional[pulumi.Input[Union['HBaseClusterSecurityProfileArgs', 'HBaseClusterSecurityProfileArgsDict']]] = None,
            ssh_endpoint: Optional[pulumi.Input[builtins.str]] = None,
            storage_account_gen2: Optional[pulumi.Input[Union['HBaseClusterStorageAccountGen2Args', 'HBaseClusterStorageAccountGen2ArgsDict']]] = None,
            storage_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['HBaseClusterStorageAccountArgs', 'HBaseClusterStorageAccountArgsDict']]]]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            tier: Optional[pulumi.Input[builtins.str]] = None,
            tls_min_version: Optional[pulumi.Input[builtins.str]] = None) -> 'HBaseCluster':
        """
        Get an existing HBaseCluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] cluster_version: Specifies the Version of HDInsights which should be used for this Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['HBaseClusterComponentVersionArgs', 'HBaseClusterComponentVersionArgsDict']] component_version: A `component_version` block as defined below.
        :param pulumi.Input[Union['HBaseClusterComputeIsolationArgs', 'HBaseClusterComputeIsolationArgsDict']] compute_isolation: A `compute_isolation` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['HBaseClusterDiskEncryptionArgs', 'HBaseClusterDiskEncryptionArgsDict']]]] disk_encryptions: One or more `disk_encryption` block as defined below.
        :param pulumi.Input[Union['HBaseClusterExtensionArgs', 'HBaseClusterExtensionArgsDict']] extension: An `extension` block as defined below.
        :param pulumi.Input[Union['HBaseClusterGatewayArgs', 'HBaseClusterGatewayArgsDict']] gateway: A `gateway` block as defined below.
        :param pulumi.Input[builtins.str] https_endpoint: The HTTPS Connectivity Endpoint for this HDInsight HBase Cluster.
        :param pulumi.Input[builtins.str] location: Specifies the Azure Region which this HDInsight HBase Cluster should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['HBaseClusterMetastoresArgs', 'HBaseClusterMetastoresArgsDict']] metastores: A `metastores` block as defined below.
        :param pulumi.Input[Union['HBaseClusterMonitorArgs', 'HBaseClusterMonitorArgsDict']] monitor: A `monitor` block as defined below.
        :param pulumi.Input[builtins.str] name: Specifies the name for this HDInsight HBase Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['HBaseClusterNetworkArgs', 'HBaseClusterNetworkArgsDict']] network: A `network` block as defined below.
        :param pulumi.Input[Union['HBaseClusterPrivateLinkConfigurationArgs', 'HBaseClusterPrivateLinkConfigurationArgsDict']] private_link_configuration: A `private_link_configuration` block as defined below.
        :param pulumi.Input[builtins.str] resource_group_name: Specifies the name of the Resource Group in which this HDInsight HBase Cluster should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['HBaseClusterRolesArgs', 'HBaseClusterRolesArgsDict']] roles: A `roles` block as defined below.
        :param pulumi.Input[Union['HBaseClusterSecurityProfileArgs', 'HBaseClusterSecurityProfileArgsDict']] security_profile: A `security_profile` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] ssh_endpoint: The SSH Connectivity Endpoint for this HDInsight HBase Cluster.
        :param pulumi.Input[Union['HBaseClusterStorageAccountGen2Args', 'HBaseClusterStorageAccountGen2ArgsDict']] storage_account_gen2: A `storage_account_gen2` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['HBaseClusterStorageAccountArgs', 'HBaseClusterStorageAccountArgsDict']]]] storage_accounts: One or more `storage_account` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A map of Tags which should be assigned to this HDInsight HBase Cluster.
        :param pulumi.Input[builtins.str] tier: Specifies the Tier which should be used for this HDInsight HBase Cluster. Possible values are `Standard` or `Premium`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] tls_min_version: The minimal supported TLS version. Possible values are 1.0, 1.1 or 1.2. Changing this forces a new resource to be created.
               
               > **Note:** Starting on June 30, 2020, Azure HDInsight will enforce TLS 1.2 or later versions for all HTTPS connections. For more information, see [Azure HDInsight TLS 1.2 Enforcement](https://azure.microsoft.com/en-us/updates/azure-hdinsight-tls-12-enforcement/).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _HBaseClusterState.__new__(_HBaseClusterState)

        __props__.__dict__["cluster_version"] = cluster_version
        __props__.__dict__["component_version"] = component_version
        __props__.__dict__["compute_isolation"] = compute_isolation
        __props__.__dict__["disk_encryptions"] = disk_encryptions
        __props__.__dict__["extension"] = extension
        __props__.__dict__["gateway"] = gateway
        __props__.__dict__["https_endpoint"] = https_endpoint
        __props__.__dict__["location"] = location
        __props__.__dict__["metastores"] = metastores
        __props__.__dict__["monitor"] = monitor
        __props__.__dict__["name"] = name
        __props__.__dict__["network"] = network
        __props__.__dict__["private_link_configuration"] = private_link_configuration
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["roles"] = roles
        __props__.__dict__["security_profile"] = security_profile
        __props__.__dict__["ssh_endpoint"] = ssh_endpoint
        __props__.__dict__["storage_account_gen2"] = storage_account_gen2
        __props__.__dict__["storage_accounts"] = storage_accounts
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tier"] = tier
        __props__.__dict__["tls_min_version"] = tls_min_version
        return HBaseCluster(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="clusterVersion")
    def cluster_version(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the Version of HDInsights which should be used for this Cluster. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "cluster_version")

    @property
    @pulumi.getter(name="componentVersion")
    def component_version(self) -> pulumi.Output['outputs.HBaseClusterComponentVersion']:
        """
        A `component_version` block as defined below.
        """
        return pulumi.get(self, "component_version")

    @property
    @pulumi.getter(name="computeIsolation")
    def compute_isolation(self) -> pulumi.Output[Optional['outputs.HBaseClusterComputeIsolation']]:
        """
        A `compute_isolation` block as defined below.
        """
        return pulumi.get(self, "compute_isolation")

    @property
    @pulumi.getter(name="diskEncryptions")
    def disk_encryptions(self) -> pulumi.Output[Optional[Sequence['outputs.HBaseClusterDiskEncryption']]]:
        """
        One or more `disk_encryption` block as defined below.
        """
        return pulumi.get(self, "disk_encryptions")

    @property
    @pulumi.getter
    def extension(self) -> pulumi.Output[Optional['outputs.HBaseClusterExtension']]:
        """
        An `extension` block as defined below.
        """
        return pulumi.get(self, "extension")

    @property
    @pulumi.getter
    def gateway(self) -> pulumi.Output['outputs.HBaseClusterGateway']:
        """
        A `gateway` block as defined below.
        """
        return pulumi.get(self, "gateway")

    @property
    @pulumi.getter(name="httpsEndpoint")
    def https_endpoint(self) -> pulumi.Output[builtins.str]:
        """
        The HTTPS Connectivity Endpoint for this HDInsight HBase Cluster.
        """
        return pulumi.get(self, "https_endpoint")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the Azure Region which this HDInsight HBase Cluster should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def metastores(self) -> pulumi.Output[Optional['outputs.HBaseClusterMetastores']]:
        """
        A `metastores` block as defined below.
        """
        return pulumi.get(self, "metastores")

    @property
    @pulumi.getter
    def monitor(self) -> pulumi.Output[Optional['outputs.HBaseClusterMonitor']]:
        """
        A `monitor` block as defined below.
        """
        return pulumi.get(self, "monitor")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the name for this HDInsight HBase Cluster. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def network(self) -> pulumi.Output[Optional['outputs.HBaseClusterNetwork']]:
        """
        A `network` block as defined below.
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter(name="privateLinkConfiguration")
    def private_link_configuration(self) -> pulumi.Output[Optional['outputs.HBaseClusterPrivateLinkConfiguration']]:
        """
        A `private_link_configuration` block as defined below.
        """
        return pulumi.get(self, "private_link_configuration")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the name of the Resource Group in which this HDInsight HBase Cluster should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter
    def roles(self) -> pulumi.Output['outputs.HBaseClusterRoles']:
        """
        A `roles` block as defined below.
        """
        return pulumi.get(self, "roles")

    @property
    @pulumi.getter(name="securityProfile")
    def security_profile(self) -> pulumi.Output[Optional['outputs.HBaseClusterSecurityProfile']]:
        """
        A `security_profile` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "security_profile")

    @property
    @pulumi.getter(name="sshEndpoint")
    def ssh_endpoint(self) -> pulumi.Output[builtins.str]:
        """
        The SSH Connectivity Endpoint for this HDInsight HBase Cluster.
        """
        return pulumi.get(self, "ssh_endpoint")

    @property
    @pulumi.getter(name="storageAccountGen2")
    def storage_account_gen2(self) -> pulumi.Output[Optional['outputs.HBaseClusterStorageAccountGen2']]:
        """
        A `storage_account_gen2` block as defined below.
        """
        return pulumi.get(self, "storage_account_gen2")

    @property
    @pulumi.getter(name="storageAccounts")
    def storage_accounts(self) -> pulumi.Output[Optional[Sequence['outputs.HBaseClusterStorageAccount']]]:
        """
        One or more `storage_account` block as defined below.
        """
        return pulumi.get(self, "storage_accounts")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A map of Tags which should be assigned to this HDInsight HBase Cluster.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def tier(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the Tier which should be used for this HDInsight HBase Cluster. Possible values are `Standard` or `Premium`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "tier")

    @property
    @pulumi.getter(name="tlsMinVersion")
    def tls_min_version(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The minimal supported TLS version. Possible values are 1.0, 1.1 or 1.2. Changing this forces a new resource to be created.

        > **Note:** Starting on June 30, 2020, Azure HDInsight will enforce TLS 1.2 or later versions for all HTTPS connections. For more information, see [Azure HDInsight TLS 1.2 Enforcement](https://azure.microsoft.com/en-us/updates/azure-hdinsight-tls-12-enforcement/).
        """
        return pulumi.get(self, "tls_min_version")

