# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['KafkaClusterArgs', 'KafkaCluster']

@pulumi.input_type
class KafkaClusterArgs:
    def __init__(__self__, *,
                 cluster_version: pulumi.Input[builtins.str],
                 component_version: pulumi.Input['KafkaClusterComponentVersionArgs'],
                 gateway: pulumi.Input['KafkaClusterGatewayArgs'],
                 resource_group_name: pulumi.Input[builtins.str],
                 roles: pulumi.Input['KafkaClusterRolesArgs'],
                 tier: pulumi.Input[builtins.str],
                 compute_isolation: Optional[pulumi.Input['KafkaClusterComputeIsolationArgs']] = None,
                 disk_encryptions: Optional[pulumi.Input[Sequence[pulumi.Input['KafkaClusterDiskEncryptionArgs']]]] = None,
                 encryption_in_transit_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 extension: Optional[pulumi.Input['KafkaClusterExtensionArgs']] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 metastores: Optional[pulumi.Input['KafkaClusterMetastoresArgs']] = None,
                 monitor: Optional[pulumi.Input['KafkaClusterMonitorArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network: Optional[pulumi.Input['KafkaClusterNetworkArgs']] = None,
                 private_link_configuration: Optional[pulumi.Input['KafkaClusterPrivateLinkConfigurationArgs']] = None,
                 rest_proxy: Optional[pulumi.Input['KafkaClusterRestProxyArgs']] = None,
                 security_profile: Optional[pulumi.Input['KafkaClusterSecurityProfileArgs']] = None,
                 storage_account_gen2: Optional[pulumi.Input['KafkaClusterStorageAccountGen2Args']] = None,
                 storage_accounts: Optional[pulumi.Input[Sequence[pulumi.Input['KafkaClusterStorageAccountArgs']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tls_min_version: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a KafkaCluster resource.
        :param pulumi.Input[builtins.str] cluster_version: Specifies the Version of HDInsights which should be used for this Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input['KafkaClusterComponentVersionArgs'] component_version: A `component_version` block as defined below.
        :param pulumi.Input['KafkaClusterGatewayArgs'] gateway: A `gateway` block as defined below.
        :param pulumi.Input[builtins.str] resource_group_name: Specifies the name of the Resource Group in which this HDInsight Kafka Cluster should exist. Changing this forces a new resource to be created.
        :param pulumi.Input['KafkaClusterRolesArgs'] roles: A `roles` block as defined below.
        :param pulumi.Input[builtins.str] tier: Specifies the Tier which should be used for this HDInsight Kafka Cluster. Possible values are `Standard` or `Premium`. Changing this forces a new resource to be created.
        :param pulumi.Input['KafkaClusterComputeIsolationArgs'] compute_isolation: A `compute_isolation` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['KafkaClusterDiskEncryptionArgs']]] disk_encryptions: One or more `disk_encryption` block as defined below.
               
               > **Note:** Starting on June 30, 2020, Azure HDInsight will enforce TLS 1.2 or later versions for all HTTPS connections. For more information, see [Azure HDInsight TLS 1.2 Enforcement](https://azure.microsoft.com/en-us/updates/azure-hdinsight-tls-12-enforcement/).
        :param pulumi.Input[builtins.bool] encryption_in_transit_enabled: Whether encryption in transit is enabled for this HDInsight Kafka Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input['KafkaClusterExtensionArgs'] extension: An `extension` block as defined below.
        :param pulumi.Input[builtins.str] location: Specifies the Azure Region which this HDInsight Kafka Cluster should exist. Changing this forces a new resource to be created.
        :param pulumi.Input['KafkaClusterMetastoresArgs'] metastores: A `metastores` block as defined below.
        :param pulumi.Input['KafkaClusterMonitorArgs'] monitor: A `monitor` block as defined below.
        :param pulumi.Input[builtins.str] name: Specifies the name for this HDInsight Kafka Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input['KafkaClusterNetworkArgs'] network: A `network` block as defined below.
        :param pulumi.Input['KafkaClusterPrivateLinkConfigurationArgs'] private_link_configuration: A `private_link_configuration` block as defined below.
        :param pulumi.Input['KafkaClusterRestProxyArgs'] rest_proxy: A `rest_proxy` block as defined below.
        :param pulumi.Input['KafkaClusterSecurityProfileArgs'] security_profile: A `security_profile` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input['KafkaClusterStorageAccountGen2Args'] storage_account_gen2: A `storage_account_gen2` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['KafkaClusterStorageAccountArgs']]] storage_accounts: One or more `storage_account` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A map of Tags which should be assigned to this HDInsight Kafka Cluster.
        :param pulumi.Input[builtins.str] tls_min_version: The minimal supported TLS version. Possible values are `1.0`, `1.1` or `1.2`. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "cluster_version", cluster_version)
        pulumi.set(__self__, "component_version", component_version)
        pulumi.set(__self__, "gateway", gateway)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "roles", roles)
        pulumi.set(__self__, "tier", tier)
        if compute_isolation is not None:
            pulumi.set(__self__, "compute_isolation", compute_isolation)
        if disk_encryptions is not None:
            pulumi.set(__self__, "disk_encryptions", disk_encryptions)
        if encryption_in_transit_enabled is not None:
            pulumi.set(__self__, "encryption_in_transit_enabled", encryption_in_transit_enabled)
        if extension is not None:
            pulumi.set(__self__, "extension", extension)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if metastores is not None:
            pulumi.set(__self__, "metastores", metastores)
        if monitor is not None:
            pulumi.set(__self__, "monitor", monitor)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if private_link_configuration is not None:
            pulumi.set(__self__, "private_link_configuration", private_link_configuration)
        if rest_proxy is not None:
            pulumi.set(__self__, "rest_proxy", rest_proxy)
        if security_profile is not None:
            pulumi.set(__self__, "security_profile", security_profile)
        if storage_account_gen2 is not None:
            pulumi.set(__self__, "storage_account_gen2", storage_account_gen2)
        if storage_accounts is not None:
            pulumi.set(__self__, "storage_accounts", storage_accounts)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tls_min_version is not None:
            pulumi.set(__self__, "tls_min_version", tls_min_version)

    @property
    @pulumi.getter(name="clusterVersion")
    def cluster_version(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the Version of HDInsights which should be used for this Cluster. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "cluster_version")

    @cluster_version.setter
    def cluster_version(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "cluster_version", value)

    @property
    @pulumi.getter(name="componentVersion")
    def component_version(self) -> pulumi.Input['KafkaClusterComponentVersionArgs']:
        """
        A `component_version` block as defined below.
        """
        return pulumi.get(self, "component_version")

    @component_version.setter
    def component_version(self, value: pulumi.Input['KafkaClusterComponentVersionArgs']):
        pulumi.set(self, "component_version", value)

    @property
    @pulumi.getter
    def gateway(self) -> pulumi.Input['KafkaClusterGatewayArgs']:
        """
        A `gateway` block as defined below.
        """
        return pulumi.get(self, "gateway")

    @gateway.setter
    def gateway(self, value: pulumi.Input['KafkaClusterGatewayArgs']):
        pulumi.set(self, "gateway", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the name of the Resource Group in which this HDInsight Kafka Cluster should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter
    def roles(self) -> pulumi.Input['KafkaClusterRolesArgs']:
        """
        A `roles` block as defined below.
        """
        return pulumi.get(self, "roles")

    @roles.setter
    def roles(self, value: pulumi.Input['KafkaClusterRolesArgs']):
        pulumi.set(self, "roles", value)

    @property
    @pulumi.getter
    def tier(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the Tier which should be used for this HDInsight Kafka Cluster. Possible values are `Standard` or `Premium`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "tier")

    @tier.setter
    def tier(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "tier", value)

    @property
    @pulumi.getter(name="computeIsolation")
    def compute_isolation(self) -> Optional[pulumi.Input['KafkaClusterComputeIsolationArgs']]:
        """
        A `compute_isolation` block as defined below.
        """
        return pulumi.get(self, "compute_isolation")

    @compute_isolation.setter
    def compute_isolation(self, value: Optional[pulumi.Input['KafkaClusterComputeIsolationArgs']]):
        pulumi.set(self, "compute_isolation", value)

    @property
    @pulumi.getter(name="diskEncryptions")
    def disk_encryptions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KafkaClusterDiskEncryptionArgs']]]]:
        """
        One or more `disk_encryption` block as defined below.

        > **Note:** Starting on June 30, 2020, Azure HDInsight will enforce TLS 1.2 or later versions for all HTTPS connections. For more information, see [Azure HDInsight TLS 1.2 Enforcement](https://azure.microsoft.com/en-us/updates/azure-hdinsight-tls-12-enforcement/).
        """
        return pulumi.get(self, "disk_encryptions")

    @disk_encryptions.setter
    def disk_encryptions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KafkaClusterDiskEncryptionArgs']]]]):
        pulumi.set(self, "disk_encryptions", value)

    @property
    @pulumi.getter(name="encryptionInTransitEnabled")
    def encryption_in_transit_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether encryption in transit is enabled for this HDInsight Kafka Cluster. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "encryption_in_transit_enabled")

    @encryption_in_transit_enabled.setter
    def encryption_in_transit_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "encryption_in_transit_enabled", value)

    @property
    @pulumi.getter
    def extension(self) -> Optional[pulumi.Input['KafkaClusterExtensionArgs']]:
        """
        An `extension` block as defined below.
        """
        return pulumi.get(self, "extension")

    @extension.setter
    def extension(self, value: Optional[pulumi.Input['KafkaClusterExtensionArgs']]):
        pulumi.set(self, "extension", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the Azure Region which this HDInsight Kafka Cluster should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def metastores(self) -> Optional[pulumi.Input['KafkaClusterMetastoresArgs']]:
        """
        A `metastores` block as defined below.
        """
        return pulumi.get(self, "metastores")

    @metastores.setter
    def metastores(self, value: Optional[pulumi.Input['KafkaClusterMetastoresArgs']]):
        pulumi.set(self, "metastores", value)

    @property
    @pulumi.getter
    def monitor(self) -> Optional[pulumi.Input['KafkaClusterMonitorArgs']]:
        """
        A `monitor` block as defined below.
        """
        return pulumi.get(self, "monitor")

    @monitor.setter
    def monitor(self, value: Optional[pulumi.Input['KafkaClusterMonitorArgs']]):
        pulumi.set(self, "monitor", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name for this HDInsight Kafka Cluster. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input['KafkaClusterNetworkArgs']]:
        """
        A `network` block as defined below.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input['KafkaClusterNetworkArgs']]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter(name="privateLinkConfiguration")
    def private_link_configuration(self) -> Optional[pulumi.Input['KafkaClusterPrivateLinkConfigurationArgs']]:
        """
        A `private_link_configuration` block as defined below.
        """
        return pulumi.get(self, "private_link_configuration")

    @private_link_configuration.setter
    def private_link_configuration(self, value: Optional[pulumi.Input['KafkaClusterPrivateLinkConfigurationArgs']]):
        pulumi.set(self, "private_link_configuration", value)

    @property
    @pulumi.getter(name="restProxy")
    def rest_proxy(self) -> Optional[pulumi.Input['KafkaClusterRestProxyArgs']]:
        """
        A `rest_proxy` block as defined below.
        """
        return pulumi.get(self, "rest_proxy")

    @rest_proxy.setter
    def rest_proxy(self, value: Optional[pulumi.Input['KafkaClusterRestProxyArgs']]):
        pulumi.set(self, "rest_proxy", value)

    @property
    @pulumi.getter(name="securityProfile")
    def security_profile(self) -> Optional[pulumi.Input['KafkaClusterSecurityProfileArgs']]:
        """
        A `security_profile` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "security_profile")

    @security_profile.setter
    def security_profile(self, value: Optional[pulumi.Input['KafkaClusterSecurityProfileArgs']]):
        pulumi.set(self, "security_profile", value)

    @property
    @pulumi.getter(name="storageAccountGen2")
    def storage_account_gen2(self) -> Optional[pulumi.Input['KafkaClusterStorageAccountGen2Args']]:
        """
        A `storage_account_gen2` block as defined below.
        """
        return pulumi.get(self, "storage_account_gen2")

    @storage_account_gen2.setter
    def storage_account_gen2(self, value: Optional[pulumi.Input['KafkaClusterStorageAccountGen2Args']]):
        pulumi.set(self, "storage_account_gen2", value)

    @property
    @pulumi.getter(name="storageAccounts")
    def storage_accounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KafkaClusterStorageAccountArgs']]]]:
        """
        One or more `storage_account` block as defined below.
        """
        return pulumi.get(self, "storage_accounts")

    @storage_accounts.setter
    def storage_accounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KafkaClusterStorageAccountArgs']]]]):
        pulumi.set(self, "storage_accounts", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of Tags which should be assigned to this HDInsight Kafka Cluster.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tlsMinVersion")
    def tls_min_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The minimal supported TLS version. Possible values are `1.0`, `1.1` or `1.2`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "tls_min_version")

    @tls_min_version.setter
    def tls_min_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tls_min_version", value)


@pulumi.input_type
class _KafkaClusterState:
    def __init__(__self__, *,
                 cluster_version: Optional[pulumi.Input[builtins.str]] = None,
                 component_version: Optional[pulumi.Input['KafkaClusterComponentVersionArgs']] = None,
                 compute_isolation: Optional[pulumi.Input['KafkaClusterComputeIsolationArgs']] = None,
                 disk_encryptions: Optional[pulumi.Input[Sequence[pulumi.Input['KafkaClusterDiskEncryptionArgs']]]] = None,
                 encryption_in_transit_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 extension: Optional[pulumi.Input['KafkaClusterExtensionArgs']] = None,
                 gateway: Optional[pulumi.Input['KafkaClusterGatewayArgs']] = None,
                 https_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 kafka_rest_proxy_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 metastores: Optional[pulumi.Input['KafkaClusterMetastoresArgs']] = None,
                 monitor: Optional[pulumi.Input['KafkaClusterMonitorArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network: Optional[pulumi.Input['KafkaClusterNetworkArgs']] = None,
                 private_link_configuration: Optional[pulumi.Input['KafkaClusterPrivateLinkConfigurationArgs']] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 rest_proxy: Optional[pulumi.Input['KafkaClusterRestProxyArgs']] = None,
                 roles: Optional[pulumi.Input['KafkaClusterRolesArgs']] = None,
                 security_profile: Optional[pulumi.Input['KafkaClusterSecurityProfileArgs']] = None,
                 ssh_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 storage_account_gen2: Optional[pulumi.Input['KafkaClusterStorageAccountGen2Args']] = None,
                 storage_accounts: Optional[pulumi.Input[Sequence[pulumi.Input['KafkaClusterStorageAccountArgs']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tier: Optional[pulumi.Input[builtins.str]] = None,
                 tls_min_version: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering KafkaCluster resources.
        :param pulumi.Input[builtins.str] cluster_version: Specifies the Version of HDInsights which should be used for this Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input['KafkaClusterComponentVersionArgs'] component_version: A `component_version` block as defined below.
        :param pulumi.Input['KafkaClusterComputeIsolationArgs'] compute_isolation: A `compute_isolation` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['KafkaClusterDiskEncryptionArgs']]] disk_encryptions: One or more `disk_encryption` block as defined below.
               
               > **Note:** Starting on June 30, 2020, Azure HDInsight will enforce TLS 1.2 or later versions for all HTTPS connections. For more information, see [Azure HDInsight TLS 1.2 Enforcement](https://azure.microsoft.com/en-us/updates/azure-hdinsight-tls-12-enforcement/).
        :param pulumi.Input[builtins.bool] encryption_in_transit_enabled: Whether encryption in transit is enabled for this HDInsight Kafka Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input['KafkaClusterExtensionArgs'] extension: An `extension` block as defined below.
        :param pulumi.Input['KafkaClusterGatewayArgs'] gateway: A `gateway` block as defined below.
        :param pulumi.Input[builtins.str] https_endpoint: The HTTPS Connectivity Endpoint for this HDInsight Kafka Cluster.
        :param pulumi.Input[builtins.str] kafka_rest_proxy_endpoint: The Kafka Rest Proxy Endpoint for this HDInsight Kafka Cluster.
        :param pulumi.Input[builtins.str] location: Specifies the Azure Region which this HDInsight Kafka Cluster should exist. Changing this forces a new resource to be created.
        :param pulumi.Input['KafkaClusterMetastoresArgs'] metastores: A `metastores` block as defined below.
        :param pulumi.Input['KafkaClusterMonitorArgs'] monitor: A `monitor` block as defined below.
        :param pulumi.Input[builtins.str] name: Specifies the name for this HDInsight Kafka Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input['KafkaClusterNetworkArgs'] network: A `network` block as defined below.
        :param pulumi.Input['KafkaClusterPrivateLinkConfigurationArgs'] private_link_configuration: A `private_link_configuration` block as defined below.
        :param pulumi.Input[builtins.str] resource_group_name: Specifies the name of the Resource Group in which this HDInsight Kafka Cluster should exist. Changing this forces a new resource to be created.
        :param pulumi.Input['KafkaClusterRestProxyArgs'] rest_proxy: A `rest_proxy` block as defined below.
        :param pulumi.Input['KafkaClusterRolesArgs'] roles: A `roles` block as defined below.
        :param pulumi.Input['KafkaClusterSecurityProfileArgs'] security_profile: A `security_profile` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] ssh_endpoint: The SSH Connectivity Endpoint for this HDInsight Kafka Cluster.
        :param pulumi.Input['KafkaClusterStorageAccountGen2Args'] storage_account_gen2: A `storage_account_gen2` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['KafkaClusterStorageAccountArgs']]] storage_accounts: One or more `storage_account` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A map of Tags which should be assigned to this HDInsight Kafka Cluster.
        :param pulumi.Input[builtins.str] tier: Specifies the Tier which should be used for this HDInsight Kafka Cluster. Possible values are `Standard` or `Premium`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] tls_min_version: The minimal supported TLS version. Possible values are `1.0`, `1.1` or `1.2`. Changing this forces a new resource to be created.
        """
        if cluster_version is not None:
            pulumi.set(__self__, "cluster_version", cluster_version)
        if component_version is not None:
            pulumi.set(__self__, "component_version", component_version)
        if compute_isolation is not None:
            pulumi.set(__self__, "compute_isolation", compute_isolation)
        if disk_encryptions is not None:
            pulumi.set(__self__, "disk_encryptions", disk_encryptions)
        if encryption_in_transit_enabled is not None:
            pulumi.set(__self__, "encryption_in_transit_enabled", encryption_in_transit_enabled)
        if extension is not None:
            pulumi.set(__self__, "extension", extension)
        if gateway is not None:
            pulumi.set(__self__, "gateway", gateway)
        if https_endpoint is not None:
            pulumi.set(__self__, "https_endpoint", https_endpoint)
        if kafka_rest_proxy_endpoint is not None:
            pulumi.set(__self__, "kafka_rest_proxy_endpoint", kafka_rest_proxy_endpoint)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if metastores is not None:
            pulumi.set(__self__, "metastores", metastores)
        if monitor is not None:
            pulumi.set(__self__, "monitor", monitor)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if private_link_configuration is not None:
            pulumi.set(__self__, "private_link_configuration", private_link_configuration)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if rest_proxy is not None:
            pulumi.set(__self__, "rest_proxy", rest_proxy)
        if roles is not None:
            pulumi.set(__self__, "roles", roles)
        if security_profile is not None:
            pulumi.set(__self__, "security_profile", security_profile)
        if ssh_endpoint is not None:
            pulumi.set(__self__, "ssh_endpoint", ssh_endpoint)
        if storage_account_gen2 is not None:
            pulumi.set(__self__, "storage_account_gen2", storage_account_gen2)
        if storage_accounts is not None:
            pulumi.set(__self__, "storage_accounts", storage_accounts)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)
        if tls_min_version is not None:
            pulumi.set(__self__, "tls_min_version", tls_min_version)

    @property
    @pulumi.getter(name="clusterVersion")
    def cluster_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the Version of HDInsights which should be used for this Cluster. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "cluster_version")

    @cluster_version.setter
    def cluster_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cluster_version", value)

    @property
    @pulumi.getter(name="componentVersion")
    def component_version(self) -> Optional[pulumi.Input['KafkaClusterComponentVersionArgs']]:
        """
        A `component_version` block as defined below.
        """
        return pulumi.get(self, "component_version")

    @component_version.setter
    def component_version(self, value: Optional[pulumi.Input['KafkaClusterComponentVersionArgs']]):
        pulumi.set(self, "component_version", value)

    @property
    @pulumi.getter(name="computeIsolation")
    def compute_isolation(self) -> Optional[pulumi.Input['KafkaClusterComputeIsolationArgs']]:
        """
        A `compute_isolation` block as defined below.
        """
        return pulumi.get(self, "compute_isolation")

    @compute_isolation.setter
    def compute_isolation(self, value: Optional[pulumi.Input['KafkaClusterComputeIsolationArgs']]):
        pulumi.set(self, "compute_isolation", value)

    @property
    @pulumi.getter(name="diskEncryptions")
    def disk_encryptions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KafkaClusterDiskEncryptionArgs']]]]:
        """
        One or more `disk_encryption` block as defined below.

        > **Note:** Starting on June 30, 2020, Azure HDInsight will enforce TLS 1.2 or later versions for all HTTPS connections. For more information, see [Azure HDInsight TLS 1.2 Enforcement](https://azure.microsoft.com/en-us/updates/azure-hdinsight-tls-12-enforcement/).
        """
        return pulumi.get(self, "disk_encryptions")

    @disk_encryptions.setter
    def disk_encryptions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KafkaClusterDiskEncryptionArgs']]]]):
        pulumi.set(self, "disk_encryptions", value)

    @property
    @pulumi.getter(name="encryptionInTransitEnabled")
    def encryption_in_transit_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether encryption in transit is enabled for this HDInsight Kafka Cluster. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "encryption_in_transit_enabled")

    @encryption_in_transit_enabled.setter
    def encryption_in_transit_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "encryption_in_transit_enabled", value)

    @property
    @pulumi.getter
    def extension(self) -> Optional[pulumi.Input['KafkaClusterExtensionArgs']]:
        """
        An `extension` block as defined below.
        """
        return pulumi.get(self, "extension")

    @extension.setter
    def extension(self, value: Optional[pulumi.Input['KafkaClusterExtensionArgs']]):
        pulumi.set(self, "extension", value)

    @property
    @pulumi.getter
    def gateway(self) -> Optional[pulumi.Input['KafkaClusterGatewayArgs']]:
        """
        A `gateway` block as defined below.
        """
        return pulumi.get(self, "gateway")

    @gateway.setter
    def gateway(self, value: Optional[pulumi.Input['KafkaClusterGatewayArgs']]):
        pulumi.set(self, "gateway", value)

    @property
    @pulumi.getter(name="httpsEndpoint")
    def https_endpoint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The HTTPS Connectivity Endpoint for this HDInsight Kafka Cluster.
        """
        return pulumi.get(self, "https_endpoint")

    @https_endpoint.setter
    def https_endpoint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "https_endpoint", value)

    @property
    @pulumi.getter(name="kafkaRestProxyEndpoint")
    def kafka_rest_proxy_endpoint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Kafka Rest Proxy Endpoint for this HDInsight Kafka Cluster.
        """
        return pulumi.get(self, "kafka_rest_proxy_endpoint")

    @kafka_rest_proxy_endpoint.setter
    def kafka_rest_proxy_endpoint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kafka_rest_proxy_endpoint", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the Azure Region which this HDInsight Kafka Cluster should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def metastores(self) -> Optional[pulumi.Input['KafkaClusterMetastoresArgs']]:
        """
        A `metastores` block as defined below.
        """
        return pulumi.get(self, "metastores")

    @metastores.setter
    def metastores(self, value: Optional[pulumi.Input['KafkaClusterMetastoresArgs']]):
        pulumi.set(self, "metastores", value)

    @property
    @pulumi.getter
    def monitor(self) -> Optional[pulumi.Input['KafkaClusterMonitorArgs']]:
        """
        A `monitor` block as defined below.
        """
        return pulumi.get(self, "monitor")

    @monitor.setter
    def monitor(self, value: Optional[pulumi.Input['KafkaClusterMonitorArgs']]):
        pulumi.set(self, "monitor", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name for this HDInsight Kafka Cluster. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input['KafkaClusterNetworkArgs']]:
        """
        A `network` block as defined below.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input['KafkaClusterNetworkArgs']]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter(name="privateLinkConfiguration")
    def private_link_configuration(self) -> Optional[pulumi.Input['KafkaClusterPrivateLinkConfigurationArgs']]:
        """
        A `private_link_configuration` block as defined below.
        """
        return pulumi.get(self, "private_link_configuration")

    @private_link_configuration.setter
    def private_link_configuration(self, value: Optional[pulumi.Input['KafkaClusterPrivateLinkConfigurationArgs']]):
        pulumi.set(self, "private_link_configuration", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the Resource Group in which this HDInsight Kafka Cluster should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="restProxy")
    def rest_proxy(self) -> Optional[pulumi.Input['KafkaClusterRestProxyArgs']]:
        """
        A `rest_proxy` block as defined below.
        """
        return pulumi.get(self, "rest_proxy")

    @rest_proxy.setter
    def rest_proxy(self, value: Optional[pulumi.Input['KafkaClusterRestProxyArgs']]):
        pulumi.set(self, "rest_proxy", value)

    @property
    @pulumi.getter
    def roles(self) -> Optional[pulumi.Input['KafkaClusterRolesArgs']]:
        """
        A `roles` block as defined below.
        """
        return pulumi.get(self, "roles")

    @roles.setter
    def roles(self, value: Optional[pulumi.Input['KafkaClusterRolesArgs']]):
        pulumi.set(self, "roles", value)

    @property
    @pulumi.getter(name="securityProfile")
    def security_profile(self) -> Optional[pulumi.Input['KafkaClusterSecurityProfileArgs']]:
        """
        A `security_profile` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "security_profile")

    @security_profile.setter
    def security_profile(self, value: Optional[pulumi.Input['KafkaClusterSecurityProfileArgs']]):
        pulumi.set(self, "security_profile", value)

    @property
    @pulumi.getter(name="sshEndpoint")
    def ssh_endpoint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The SSH Connectivity Endpoint for this HDInsight Kafka Cluster.
        """
        return pulumi.get(self, "ssh_endpoint")

    @ssh_endpoint.setter
    def ssh_endpoint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ssh_endpoint", value)

    @property
    @pulumi.getter(name="storageAccountGen2")
    def storage_account_gen2(self) -> Optional[pulumi.Input['KafkaClusterStorageAccountGen2Args']]:
        """
        A `storage_account_gen2` block as defined below.
        """
        return pulumi.get(self, "storage_account_gen2")

    @storage_account_gen2.setter
    def storage_account_gen2(self, value: Optional[pulumi.Input['KafkaClusterStorageAccountGen2Args']]):
        pulumi.set(self, "storage_account_gen2", value)

    @property
    @pulumi.getter(name="storageAccounts")
    def storage_accounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KafkaClusterStorageAccountArgs']]]]:
        """
        One or more `storage_account` block as defined below.
        """
        return pulumi.get(self, "storage_accounts")

    @storage_accounts.setter
    def storage_accounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KafkaClusterStorageAccountArgs']]]]):
        pulumi.set(self, "storage_accounts", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of Tags which should be assigned to this HDInsight Kafka Cluster.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def tier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the Tier which should be used for this HDInsight Kafka Cluster. Possible values are `Standard` or `Premium`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "tier")

    @tier.setter
    def tier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tier", value)

    @property
    @pulumi.getter(name="tlsMinVersion")
    def tls_min_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The minimal supported TLS version. Possible values are `1.0`, `1.1` or `1.2`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "tls_min_version")

    @tls_min_version.setter
    def tls_min_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tls_min_version", value)


@pulumi.type_token("azure:hdinsight/kafkaCluster:KafkaCluster")
class KafkaCluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_version: Optional[pulumi.Input[builtins.str]] = None,
                 component_version: Optional[pulumi.Input[Union['KafkaClusterComponentVersionArgs', 'KafkaClusterComponentVersionArgsDict']]] = None,
                 compute_isolation: Optional[pulumi.Input[Union['KafkaClusterComputeIsolationArgs', 'KafkaClusterComputeIsolationArgsDict']]] = None,
                 disk_encryptions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['KafkaClusterDiskEncryptionArgs', 'KafkaClusterDiskEncryptionArgsDict']]]]] = None,
                 encryption_in_transit_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 extension: Optional[pulumi.Input[Union['KafkaClusterExtensionArgs', 'KafkaClusterExtensionArgsDict']]] = None,
                 gateway: Optional[pulumi.Input[Union['KafkaClusterGatewayArgs', 'KafkaClusterGatewayArgsDict']]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 metastores: Optional[pulumi.Input[Union['KafkaClusterMetastoresArgs', 'KafkaClusterMetastoresArgsDict']]] = None,
                 monitor: Optional[pulumi.Input[Union['KafkaClusterMonitorArgs', 'KafkaClusterMonitorArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network: Optional[pulumi.Input[Union['KafkaClusterNetworkArgs', 'KafkaClusterNetworkArgsDict']]] = None,
                 private_link_configuration: Optional[pulumi.Input[Union['KafkaClusterPrivateLinkConfigurationArgs', 'KafkaClusterPrivateLinkConfigurationArgsDict']]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 rest_proxy: Optional[pulumi.Input[Union['KafkaClusterRestProxyArgs', 'KafkaClusterRestProxyArgsDict']]] = None,
                 roles: Optional[pulumi.Input[Union['KafkaClusterRolesArgs', 'KafkaClusterRolesArgsDict']]] = None,
                 security_profile: Optional[pulumi.Input[Union['KafkaClusterSecurityProfileArgs', 'KafkaClusterSecurityProfileArgsDict']]] = None,
                 storage_account_gen2: Optional[pulumi.Input[Union['KafkaClusterStorageAccountGen2Args', 'KafkaClusterStorageAccountGen2ArgsDict']]] = None,
                 storage_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['KafkaClusterStorageAccountArgs', 'KafkaClusterStorageAccountArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tier: Optional[pulumi.Input[builtins.str]] = None,
                 tls_min_version: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages a HDInsight Kafka Cluster.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_account = azure.storage.Account("example",
            name="hdinsightstor",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS")
        example_container = azure.storage.Container("example",
            name="hdinsight",
            storage_account_name=example_account.name,
            container_access_type="private")
        example_kafka_cluster = azure.hdinsight.KafkaCluster("example",
            name="example-hdicluster",
            resource_group_name=example.name,
            location=example.location,
            cluster_version="4.0",
            tier="Standard",
            component_version={
                "kafka": "2.1",
            },
            gateway={
                "username": "acctestusrgw",
                "password": "Password123!",
            },
            storage_accounts=[{
                "storage_container_id": example_container.id,
                "storage_account_key": example_account.primary_access_key,
                "is_default": True,
            }],
            roles={
                "head_node": {
                    "vm_size": "Standard_D3_V2",
                    "username": "acctestusrvm",
                    "password": "AccTestvdSC4daf986!",
                },
                "worker_node": {
                    "vm_size": "Standard_D3_V2",
                    "username": "acctestusrvm",
                    "password": "AccTestvdSC4daf986!",
                    "number_of_disks_per_node": 3,
                    "target_instance_count": 3,
                },
                "zookeeper_node": {
                    "vm_size": "Standard_D3_V2",
                    "username": "acctestusrvm",
                    "password": "AccTestvdSC4daf986!",
                },
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.HDInsight`: 2021-06-01

        ## Import

        HDInsight Kafka Clusters can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:hdinsight/kafkaCluster:KafkaCluster example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.HDInsight/clusters/cluster1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] cluster_version: Specifies the Version of HDInsights which should be used for this Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['KafkaClusterComponentVersionArgs', 'KafkaClusterComponentVersionArgsDict']] component_version: A `component_version` block as defined below.
        :param pulumi.Input[Union['KafkaClusterComputeIsolationArgs', 'KafkaClusterComputeIsolationArgsDict']] compute_isolation: A `compute_isolation` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['KafkaClusterDiskEncryptionArgs', 'KafkaClusterDiskEncryptionArgsDict']]]] disk_encryptions: One or more `disk_encryption` block as defined below.
               
               > **Note:** Starting on June 30, 2020, Azure HDInsight will enforce TLS 1.2 or later versions for all HTTPS connections. For more information, see [Azure HDInsight TLS 1.2 Enforcement](https://azure.microsoft.com/en-us/updates/azure-hdinsight-tls-12-enforcement/).
        :param pulumi.Input[builtins.bool] encryption_in_transit_enabled: Whether encryption in transit is enabled for this HDInsight Kafka Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['KafkaClusterExtensionArgs', 'KafkaClusterExtensionArgsDict']] extension: An `extension` block as defined below.
        :param pulumi.Input[Union['KafkaClusterGatewayArgs', 'KafkaClusterGatewayArgsDict']] gateway: A `gateway` block as defined below.
        :param pulumi.Input[builtins.str] location: Specifies the Azure Region which this HDInsight Kafka Cluster should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['KafkaClusterMetastoresArgs', 'KafkaClusterMetastoresArgsDict']] metastores: A `metastores` block as defined below.
        :param pulumi.Input[Union['KafkaClusterMonitorArgs', 'KafkaClusterMonitorArgsDict']] monitor: A `monitor` block as defined below.
        :param pulumi.Input[builtins.str] name: Specifies the name for this HDInsight Kafka Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['KafkaClusterNetworkArgs', 'KafkaClusterNetworkArgsDict']] network: A `network` block as defined below.
        :param pulumi.Input[Union['KafkaClusterPrivateLinkConfigurationArgs', 'KafkaClusterPrivateLinkConfigurationArgsDict']] private_link_configuration: A `private_link_configuration` block as defined below.
        :param pulumi.Input[builtins.str] resource_group_name: Specifies the name of the Resource Group in which this HDInsight Kafka Cluster should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['KafkaClusterRestProxyArgs', 'KafkaClusterRestProxyArgsDict']] rest_proxy: A `rest_proxy` block as defined below.
        :param pulumi.Input[Union['KafkaClusterRolesArgs', 'KafkaClusterRolesArgsDict']] roles: A `roles` block as defined below.
        :param pulumi.Input[Union['KafkaClusterSecurityProfileArgs', 'KafkaClusterSecurityProfileArgsDict']] security_profile: A `security_profile` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['KafkaClusterStorageAccountGen2Args', 'KafkaClusterStorageAccountGen2ArgsDict']] storage_account_gen2: A `storage_account_gen2` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['KafkaClusterStorageAccountArgs', 'KafkaClusterStorageAccountArgsDict']]]] storage_accounts: One or more `storage_account` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A map of Tags which should be assigned to this HDInsight Kafka Cluster.
        :param pulumi.Input[builtins.str] tier: Specifies the Tier which should be used for this HDInsight Kafka Cluster. Possible values are `Standard` or `Premium`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] tls_min_version: The minimal supported TLS version. Possible values are `1.0`, `1.1` or `1.2`. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: KafkaClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a HDInsight Kafka Cluster.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_account = azure.storage.Account("example",
            name="hdinsightstor",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS")
        example_container = azure.storage.Container("example",
            name="hdinsight",
            storage_account_name=example_account.name,
            container_access_type="private")
        example_kafka_cluster = azure.hdinsight.KafkaCluster("example",
            name="example-hdicluster",
            resource_group_name=example.name,
            location=example.location,
            cluster_version="4.0",
            tier="Standard",
            component_version={
                "kafka": "2.1",
            },
            gateway={
                "username": "acctestusrgw",
                "password": "Password123!",
            },
            storage_accounts=[{
                "storage_container_id": example_container.id,
                "storage_account_key": example_account.primary_access_key,
                "is_default": True,
            }],
            roles={
                "head_node": {
                    "vm_size": "Standard_D3_V2",
                    "username": "acctestusrvm",
                    "password": "AccTestvdSC4daf986!",
                },
                "worker_node": {
                    "vm_size": "Standard_D3_V2",
                    "username": "acctestusrvm",
                    "password": "AccTestvdSC4daf986!",
                    "number_of_disks_per_node": 3,
                    "target_instance_count": 3,
                },
                "zookeeper_node": {
                    "vm_size": "Standard_D3_V2",
                    "username": "acctestusrvm",
                    "password": "AccTestvdSC4daf986!",
                },
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.HDInsight`: 2021-06-01

        ## Import

        HDInsight Kafka Clusters can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:hdinsight/kafkaCluster:KafkaCluster example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.HDInsight/clusters/cluster1
        ```

        :param str resource_name: The name of the resource.
        :param KafkaClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(KafkaClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_version: Optional[pulumi.Input[builtins.str]] = None,
                 component_version: Optional[pulumi.Input[Union['KafkaClusterComponentVersionArgs', 'KafkaClusterComponentVersionArgsDict']]] = None,
                 compute_isolation: Optional[pulumi.Input[Union['KafkaClusterComputeIsolationArgs', 'KafkaClusterComputeIsolationArgsDict']]] = None,
                 disk_encryptions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['KafkaClusterDiskEncryptionArgs', 'KafkaClusterDiskEncryptionArgsDict']]]]] = None,
                 encryption_in_transit_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 extension: Optional[pulumi.Input[Union['KafkaClusterExtensionArgs', 'KafkaClusterExtensionArgsDict']]] = None,
                 gateway: Optional[pulumi.Input[Union['KafkaClusterGatewayArgs', 'KafkaClusterGatewayArgsDict']]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 metastores: Optional[pulumi.Input[Union['KafkaClusterMetastoresArgs', 'KafkaClusterMetastoresArgsDict']]] = None,
                 monitor: Optional[pulumi.Input[Union['KafkaClusterMonitorArgs', 'KafkaClusterMonitorArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network: Optional[pulumi.Input[Union['KafkaClusterNetworkArgs', 'KafkaClusterNetworkArgsDict']]] = None,
                 private_link_configuration: Optional[pulumi.Input[Union['KafkaClusterPrivateLinkConfigurationArgs', 'KafkaClusterPrivateLinkConfigurationArgsDict']]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 rest_proxy: Optional[pulumi.Input[Union['KafkaClusterRestProxyArgs', 'KafkaClusterRestProxyArgsDict']]] = None,
                 roles: Optional[pulumi.Input[Union['KafkaClusterRolesArgs', 'KafkaClusterRolesArgsDict']]] = None,
                 security_profile: Optional[pulumi.Input[Union['KafkaClusterSecurityProfileArgs', 'KafkaClusterSecurityProfileArgsDict']]] = None,
                 storage_account_gen2: Optional[pulumi.Input[Union['KafkaClusterStorageAccountGen2Args', 'KafkaClusterStorageAccountGen2ArgsDict']]] = None,
                 storage_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['KafkaClusterStorageAccountArgs', 'KafkaClusterStorageAccountArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tier: Optional[pulumi.Input[builtins.str]] = None,
                 tls_min_version: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = KafkaClusterArgs.__new__(KafkaClusterArgs)

            if cluster_version is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_version'")
            __props__.__dict__["cluster_version"] = cluster_version
            if component_version is None and not opts.urn:
                raise TypeError("Missing required property 'component_version'")
            __props__.__dict__["component_version"] = component_version
            __props__.__dict__["compute_isolation"] = compute_isolation
            __props__.__dict__["disk_encryptions"] = disk_encryptions
            __props__.__dict__["encryption_in_transit_enabled"] = encryption_in_transit_enabled
            __props__.__dict__["extension"] = extension
            if gateway is None and not opts.urn:
                raise TypeError("Missing required property 'gateway'")
            __props__.__dict__["gateway"] = gateway
            __props__.__dict__["location"] = location
            __props__.__dict__["metastores"] = metastores
            __props__.__dict__["monitor"] = monitor
            __props__.__dict__["name"] = name
            __props__.__dict__["network"] = network
            __props__.__dict__["private_link_configuration"] = private_link_configuration
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["rest_proxy"] = rest_proxy
            if roles is None and not opts.urn:
                raise TypeError("Missing required property 'roles'")
            __props__.__dict__["roles"] = roles
            __props__.__dict__["security_profile"] = security_profile
            __props__.__dict__["storage_account_gen2"] = storage_account_gen2
            __props__.__dict__["storage_accounts"] = storage_accounts
            __props__.__dict__["tags"] = tags
            if tier is None and not opts.urn:
                raise TypeError("Missing required property 'tier'")
            __props__.__dict__["tier"] = tier
            __props__.__dict__["tls_min_version"] = tls_min_version
            __props__.__dict__["https_endpoint"] = None
            __props__.__dict__["kafka_rest_proxy_endpoint"] = None
            __props__.__dict__["ssh_endpoint"] = None
        super(KafkaCluster, __self__).__init__(
            'azure:hdinsight/kafkaCluster:KafkaCluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cluster_version: Optional[pulumi.Input[builtins.str]] = None,
            component_version: Optional[pulumi.Input[Union['KafkaClusterComponentVersionArgs', 'KafkaClusterComponentVersionArgsDict']]] = None,
            compute_isolation: Optional[pulumi.Input[Union['KafkaClusterComputeIsolationArgs', 'KafkaClusterComputeIsolationArgsDict']]] = None,
            disk_encryptions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['KafkaClusterDiskEncryptionArgs', 'KafkaClusterDiskEncryptionArgsDict']]]]] = None,
            encryption_in_transit_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            extension: Optional[pulumi.Input[Union['KafkaClusterExtensionArgs', 'KafkaClusterExtensionArgsDict']]] = None,
            gateway: Optional[pulumi.Input[Union['KafkaClusterGatewayArgs', 'KafkaClusterGatewayArgsDict']]] = None,
            https_endpoint: Optional[pulumi.Input[builtins.str]] = None,
            kafka_rest_proxy_endpoint: Optional[pulumi.Input[builtins.str]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            metastores: Optional[pulumi.Input[Union['KafkaClusterMetastoresArgs', 'KafkaClusterMetastoresArgsDict']]] = None,
            monitor: Optional[pulumi.Input[Union['KafkaClusterMonitorArgs', 'KafkaClusterMonitorArgsDict']]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            network: Optional[pulumi.Input[Union['KafkaClusterNetworkArgs', 'KafkaClusterNetworkArgsDict']]] = None,
            private_link_configuration: Optional[pulumi.Input[Union['KafkaClusterPrivateLinkConfigurationArgs', 'KafkaClusterPrivateLinkConfigurationArgsDict']]] = None,
            resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
            rest_proxy: Optional[pulumi.Input[Union['KafkaClusterRestProxyArgs', 'KafkaClusterRestProxyArgsDict']]] = None,
            roles: Optional[pulumi.Input[Union['KafkaClusterRolesArgs', 'KafkaClusterRolesArgsDict']]] = None,
            security_profile: Optional[pulumi.Input[Union['KafkaClusterSecurityProfileArgs', 'KafkaClusterSecurityProfileArgsDict']]] = None,
            ssh_endpoint: Optional[pulumi.Input[builtins.str]] = None,
            storage_account_gen2: Optional[pulumi.Input[Union['KafkaClusterStorageAccountGen2Args', 'KafkaClusterStorageAccountGen2ArgsDict']]] = None,
            storage_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['KafkaClusterStorageAccountArgs', 'KafkaClusterStorageAccountArgsDict']]]]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            tier: Optional[pulumi.Input[builtins.str]] = None,
            tls_min_version: Optional[pulumi.Input[builtins.str]] = None) -> 'KafkaCluster':
        """
        Get an existing KafkaCluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] cluster_version: Specifies the Version of HDInsights which should be used for this Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['KafkaClusterComponentVersionArgs', 'KafkaClusterComponentVersionArgsDict']] component_version: A `component_version` block as defined below.
        :param pulumi.Input[Union['KafkaClusterComputeIsolationArgs', 'KafkaClusterComputeIsolationArgsDict']] compute_isolation: A `compute_isolation` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['KafkaClusterDiskEncryptionArgs', 'KafkaClusterDiskEncryptionArgsDict']]]] disk_encryptions: One or more `disk_encryption` block as defined below.
               
               > **Note:** Starting on June 30, 2020, Azure HDInsight will enforce TLS 1.2 or later versions for all HTTPS connections. For more information, see [Azure HDInsight TLS 1.2 Enforcement](https://azure.microsoft.com/en-us/updates/azure-hdinsight-tls-12-enforcement/).
        :param pulumi.Input[builtins.bool] encryption_in_transit_enabled: Whether encryption in transit is enabled for this HDInsight Kafka Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['KafkaClusterExtensionArgs', 'KafkaClusterExtensionArgsDict']] extension: An `extension` block as defined below.
        :param pulumi.Input[Union['KafkaClusterGatewayArgs', 'KafkaClusterGatewayArgsDict']] gateway: A `gateway` block as defined below.
        :param pulumi.Input[builtins.str] https_endpoint: The HTTPS Connectivity Endpoint for this HDInsight Kafka Cluster.
        :param pulumi.Input[builtins.str] kafka_rest_proxy_endpoint: The Kafka Rest Proxy Endpoint for this HDInsight Kafka Cluster.
        :param pulumi.Input[builtins.str] location: Specifies the Azure Region which this HDInsight Kafka Cluster should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['KafkaClusterMetastoresArgs', 'KafkaClusterMetastoresArgsDict']] metastores: A `metastores` block as defined below.
        :param pulumi.Input[Union['KafkaClusterMonitorArgs', 'KafkaClusterMonitorArgsDict']] monitor: A `monitor` block as defined below.
        :param pulumi.Input[builtins.str] name: Specifies the name for this HDInsight Kafka Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['KafkaClusterNetworkArgs', 'KafkaClusterNetworkArgsDict']] network: A `network` block as defined below.
        :param pulumi.Input[Union['KafkaClusterPrivateLinkConfigurationArgs', 'KafkaClusterPrivateLinkConfigurationArgsDict']] private_link_configuration: A `private_link_configuration` block as defined below.
        :param pulumi.Input[builtins.str] resource_group_name: Specifies the name of the Resource Group in which this HDInsight Kafka Cluster should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['KafkaClusterRestProxyArgs', 'KafkaClusterRestProxyArgsDict']] rest_proxy: A `rest_proxy` block as defined below.
        :param pulumi.Input[Union['KafkaClusterRolesArgs', 'KafkaClusterRolesArgsDict']] roles: A `roles` block as defined below.
        :param pulumi.Input[Union['KafkaClusterSecurityProfileArgs', 'KafkaClusterSecurityProfileArgsDict']] security_profile: A `security_profile` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] ssh_endpoint: The SSH Connectivity Endpoint for this HDInsight Kafka Cluster.
        :param pulumi.Input[Union['KafkaClusterStorageAccountGen2Args', 'KafkaClusterStorageAccountGen2ArgsDict']] storage_account_gen2: A `storage_account_gen2` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['KafkaClusterStorageAccountArgs', 'KafkaClusterStorageAccountArgsDict']]]] storage_accounts: One or more `storage_account` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A map of Tags which should be assigned to this HDInsight Kafka Cluster.
        :param pulumi.Input[builtins.str] tier: Specifies the Tier which should be used for this HDInsight Kafka Cluster. Possible values are `Standard` or `Premium`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] tls_min_version: The minimal supported TLS version. Possible values are `1.0`, `1.1` or `1.2`. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _KafkaClusterState.__new__(_KafkaClusterState)

        __props__.__dict__["cluster_version"] = cluster_version
        __props__.__dict__["component_version"] = component_version
        __props__.__dict__["compute_isolation"] = compute_isolation
        __props__.__dict__["disk_encryptions"] = disk_encryptions
        __props__.__dict__["encryption_in_transit_enabled"] = encryption_in_transit_enabled
        __props__.__dict__["extension"] = extension
        __props__.__dict__["gateway"] = gateway
        __props__.__dict__["https_endpoint"] = https_endpoint
        __props__.__dict__["kafka_rest_proxy_endpoint"] = kafka_rest_proxy_endpoint
        __props__.__dict__["location"] = location
        __props__.__dict__["metastores"] = metastores
        __props__.__dict__["monitor"] = monitor
        __props__.__dict__["name"] = name
        __props__.__dict__["network"] = network
        __props__.__dict__["private_link_configuration"] = private_link_configuration
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["rest_proxy"] = rest_proxy
        __props__.__dict__["roles"] = roles
        __props__.__dict__["security_profile"] = security_profile
        __props__.__dict__["ssh_endpoint"] = ssh_endpoint
        __props__.__dict__["storage_account_gen2"] = storage_account_gen2
        __props__.__dict__["storage_accounts"] = storage_accounts
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tier"] = tier
        __props__.__dict__["tls_min_version"] = tls_min_version
        return KafkaCluster(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="clusterVersion")
    def cluster_version(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the Version of HDInsights which should be used for this Cluster. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "cluster_version")

    @property
    @pulumi.getter(name="componentVersion")
    def component_version(self) -> pulumi.Output['outputs.KafkaClusterComponentVersion']:
        """
        A `component_version` block as defined below.
        """
        return pulumi.get(self, "component_version")

    @property
    @pulumi.getter(name="computeIsolation")
    def compute_isolation(self) -> pulumi.Output[Optional['outputs.KafkaClusterComputeIsolation']]:
        """
        A `compute_isolation` block as defined below.
        """
        return pulumi.get(self, "compute_isolation")

    @property
    @pulumi.getter(name="diskEncryptions")
    def disk_encryptions(self) -> pulumi.Output[Optional[Sequence['outputs.KafkaClusterDiskEncryption']]]:
        """
        One or more `disk_encryption` block as defined below.

        > **Note:** Starting on June 30, 2020, Azure HDInsight will enforce TLS 1.2 or later versions for all HTTPS connections. For more information, see [Azure HDInsight TLS 1.2 Enforcement](https://azure.microsoft.com/en-us/updates/azure-hdinsight-tls-12-enforcement/).
        """
        return pulumi.get(self, "disk_encryptions")

    @property
    @pulumi.getter(name="encryptionInTransitEnabled")
    def encryption_in_transit_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether encryption in transit is enabled for this HDInsight Kafka Cluster. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "encryption_in_transit_enabled")

    @property
    @pulumi.getter
    def extension(self) -> pulumi.Output[Optional['outputs.KafkaClusterExtension']]:
        """
        An `extension` block as defined below.
        """
        return pulumi.get(self, "extension")

    @property
    @pulumi.getter
    def gateway(self) -> pulumi.Output['outputs.KafkaClusterGateway']:
        """
        A `gateway` block as defined below.
        """
        return pulumi.get(self, "gateway")

    @property
    @pulumi.getter(name="httpsEndpoint")
    def https_endpoint(self) -> pulumi.Output[builtins.str]:
        """
        The HTTPS Connectivity Endpoint for this HDInsight Kafka Cluster.
        """
        return pulumi.get(self, "https_endpoint")

    @property
    @pulumi.getter(name="kafkaRestProxyEndpoint")
    def kafka_rest_proxy_endpoint(self) -> pulumi.Output[builtins.str]:
        """
        The Kafka Rest Proxy Endpoint for this HDInsight Kafka Cluster.
        """
        return pulumi.get(self, "kafka_rest_proxy_endpoint")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the Azure Region which this HDInsight Kafka Cluster should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def metastores(self) -> pulumi.Output[Optional['outputs.KafkaClusterMetastores']]:
        """
        A `metastores` block as defined below.
        """
        return pulumi.get(self, "metastores")

    @property
    @pulumi.getter
    def monitor(self) -> pulumi.Output[Optional['outputs.KafkaClusterMonitor']]:
        """
        A `monitor` block as defined below.
        """
        return pulumi.get(self, "monitor")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the name for this HDInsight Kafka Cluster. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def network(self) -> pulumi.Output[Optional['outputs.KafkaClusterNetwork']]:
        """
        A `network` block as defined below.
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter(name="privateLinkConfiguration")
    def private_link_configuration(self) -> pulumi.Output[Optional['outputs.KafkaClusterPrivateLinkConfiguration']]:
        """
        A `private_link_configuration` block as defined below.
        """
        return pulumi.get(self, "private_link_configuration")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the name of the Resource Group in which this HDInsight Kafka Cluster should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter(name="restProxy")
    def rest_proxy(self) -> pulumi.Output[Optional['outputs.KafkaClusterRestProxy']]:
        """
        A `rest_proxy` block as defined below.
        """
        return pulumi.get(self, "rest_proxy")

    @property
    @pulumi.getter
    def roles(self) -> pulumi.Output['outputs.KafkaClusterRoles']:
        """
        A `roles` block as defined below.
        """
        return pulumi.get(self, "roles")

    @property
    @pulumi.getter(name="securityProfile")
    def security_profile(self) -> pulumi.Output[Optional['outputs.KafkaClusterSecurityProfile']]:
        """
        A `security_profile` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "security_profile")

    @property
    @pulumi.getter(name="sshEndpoint")
    def ssh_endpoint(self) -> pulumi.Output[builtins.str]:
        """
        The SSH Connectivity Endpoint for this HDInsight Kafka Cluster.
        """
        return pulumi.get(self, "ssh_endpoint")

    @property
    @pulumi.getter(name="storageAccountGen2")
    def storage_account_gen2(self) -> pulumi.Output[Optional['outputs.KafkaClusterStorageAccountGen2']]:
        """
        A `storage_account_gen2` block as defined below.
        """
        return pulumi.get(self, "storage_account_gen2")

    @property
    @pulumi.getter(name="storageAccounts")
    def storage_accounts(self) -> pulumi.Output[Optional[Sequence['outputs.KafkaClusterStorageAccount']]]:
        """
        One or more `storage_account` block as defined below.
        """
        return pulumi.get(self, "storage_accounts")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A map of Tags which should be assigned to this HDInsight Kafka Cluster.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def tier(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the Tier which should be used for this HDInsight Kafka Cluster. Possible values are `Standard` or `Premium`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "tier")

    @property
    @pulumi.getter(name="tlsMinVersion")
    def tls_min_version(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The minimal supported TLS version. Possible values are `1.0`, `1.1` or `1.2`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "tls_min_version")

