# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SparkClusterArgs', 'SparkCluster']

@pulumi.input_type
class SparkClusterArgs:
    def __init__(__self__, *,
                 cluster_version: pulumi.Input[builtins.str],
                 component_version: pulumi.Input['SparkClusterComponentVersionArgs'],
                 gateway: pulumi.Input['SparkClusterGatewayArgs'],
                 resource_group_name: pulumi.Input[builtins.str],
                 roles: pulumi.Input['SparkClusterRolesArgs'],
                 tier: pulumi.Input[builtins.str],
                 compute_isolation: Optional[pulumi.Input['SparkClusterComputeIsolationArgs']] = None,
                 disk_encryptions: Optional[pulumi.Input[Sequence[pulumi.Input['SparkClusterDiskEncryptionArgs']]]] = None,
                 encryption_in_transit_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 extension: Optional[pulumi.Input['SparkClusterExtensionArgs']] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 metastores: Optional[pulumi.Input['SparkClusterMetastoresArgs']] = None,
                 monitor: Optional[pulumi.Input['SparkClusterMonitorArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network: Optional[pulumi.Input['SparkClusterNetworkArgs']] = None,
                 private_link_configuration: Optional[pulumi.Input['SparkClusterPrivateLinkConfigurationArgs']] = None,
                 security_profile: Optional[pulumi.Input['SparkClusterSecurityProfileArgs']] = None,
                 storage_account_gen2: Optional[pulumi.Input['SparkClusterStorageAccountGen2Args']] = None,
                 storage_accounts: Optional[pulumi.Input[Sequence[pulumi.Input['SparkClusterStorageAccountArgs']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tls_min_version: Optional[pulumi.Input[builtins.str]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a SparkCluster resource.
        :param pulumi.Input[builtins.str] cluster_version: Specifies the Version of HDInsights which should be used for this Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input['SparkClusterComponentVersionArgs'] component_version: A `component_version` block as defined below.
        :param pulumi.Input['SparkClusterGatewayArgs'] gateway: A `gateway` block as defined below.
        :param pulumi.Input[builtins.str] resource_group_name: Specifies the name of the Resource Group in which this HDInsight Spark Cluster should exist. Changing this forces a new resource to be created.
        :param pulumi.Input['SparkClusterRolesArgs'] roles: A `roles` block as defined below.
        :param pulumi.Input[builtins.str] tier: Specifies the Tier which should be used for this HDInsight Spark Cluster. Possible values are `Standard` or `Premium`. Changing this forces a new resource to be created.
        :param pulumi.Input['SparkClusterComputeIsolationArgs'] compute_isolation: A `compute_isolation` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['SparkClusterDiskEncryptionArgs']]] disk_encryptions: One or more `disk_encryption` block as defined below.
        :param pulumi.Input[builtins.bool] encryption_in_transit_enabled: Whether encryption in transit is enabled for this Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input['SparkClusterExtensionArgs'] extension: An `extension` block as defined below.
        :param pulumi.Input[builtins.str] location: Specifies the Azure Region which this HDInsight Spark Cluster should exist. Changing this forces a new resource to be created.
        :param pulumi.Input['SparkClusterMetastoresArgs'] metastores: A `metastores` block as defined below.
        :param pulumi.Input['SparkClusterMonitorArgs'] monitor: A `monitor` block as defined below.
        :param pulumi.Input[builtins.str] name: Specifies the name for this HDInsight Spark Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input['SparkClusterNetworkArgs'] network: A `network` block as defined below.
        :param pulumi.Input['SparkClusterPrivateLinkConfigurationArgs'] private_link_configuration: A `private_link_configuration` block as defined below.
        :param pulumi.Input['SparkClusterSecurityProfileArgs'] security_profile: A `security_profile` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input['SparkClusterStorageAccountGen2Args'] storage_account_gen2: A `storage_account_gen2` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['SparkClusterStorageAccountArgs']]] storage_accounts: One or more `storage_account` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A map of Tags which should be assigned to this HDInsight Spark Cluster.
        :param pulumi.Input[builtins.str] tls_min_version: The minimal supported TLS version. Possible values are 1.0, 1.1 or 1.2. Changing this forces a new resource to be created.
               
               > **Note:** Starting on June 30, 2020, Azure HDInsight will enforce TLS 1.2 or later versions for all HTTPS connections. For more information, see [Azure HDInsight TLS 1.2 Enforcement](https://azure.microsoft.com/en-us/updates/azure-hdinsight-tls-12-enforcement/).
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] zones: A list of Availability Zones which should be used for this HDInsight Spark Cluster. Chaning this forces a new resource to be created.
        """
        pulumi.set(__self__, "cluster_version", cluster_version)
        pulumi.set(__self__, "component_version", component_version)
        pulumi.set(__self__, "gateway", gateway)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "roles", roles)
        pulumi.set(__self__, "tier", tier)
        if compute_isolation is not None:
            pulumi.set(__self__, "compute_isolation", compute_isolation)
        if disk_encryptions is not None:
            pulumi.set(__self__, "disk_encryptions", disk_encryptions)
        if encryption_in_transit_enabled is not None:
            pulumi.set(__self__, "encryption_in_transit_enabled", encryption_in_transit_enabled)
        if extension is not None:
            pulumi.set(__self__, "extension", extension)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if metastores is not None:
            pulumi.set(__self__, "metastores", metastores)
        if monitor is not None:
            pulumi.set(__self__, "monitor", monitor)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if private_link_configuration is not None:
            pulumi.set(__self__, "private_link_configuration", private_link_configuration)
        if security_profile is not None:
            pulumi.set(__self__, "security_profile", security_profile)
        if storage_account_gen2 is not None:
            pulumi.set(__self__, "storage_account_gen2", storage_account_gen2)
        if storage_accounts is not None:
            pulumi.set(__self__, "storage_accounts", storage_accounts)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tls_min_version is not None:
            pulumi.set(__self__, "tls_min_version", tls_min_version)
        if zones is not None:
            pulumi.set(__self__, "zones", zones)

    @property
    @pulumi.getter(name="clusterVersion")
    def cluster_version(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the Version of HDInsights which should be used for this Cluster. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "cluster_version")

    @cluster_version.setter
    def cluster_version(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "cluster_version", value)

    @property
    @pulumi.getter(name="componentVersion")
    def component_version(self) -> pulumi.Input['SparkClusterComponentVersionArgs']:
        """
        A `component_version` block as defined below.
        """
        return pulumi.get(self, "component_version")

    @component_version.setter
    def component_version(self, value: pulumi.Input['SparkClusterComponentVersionArgs']):
        pulumi.set(self, "component_version", value)

    @property
    @pulumi.getter
    def gateway(self) -> pulumi.Input['SparkClusterGatewayArgs']:
        """
        A `gateway` block as defined below.
        """
        return pulumi.get(self, "gateway")

    @gateway.setter
    def gateway(self, value: pulumi.Input['SparkClusterGatewayArgs']):
        pulumi.set(self, "gateway", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the name of the Resource Group in which this HDInsight Spark Cluster should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter
    def roles(self) -> pulumi.Input['SparkClusterRolesArgs']:
        """
        A `roles` block as defined below.
        """
        return pulumi.get(self, "roles")

    @roles.setter
    def roles(self, value: pulumi.Input['SparkClusterRolesArgs']):
        pulumi.set(self, "roles", value)

    @property
    @pulumi.getter
    def tier(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the Tier which should be used for this HDInsight Spark Cluster. Possible values are `Standard` or `Premium`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "tier")

    @tier.setter
    def tier(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "tier", value)

    @property
    @pulumi.getter(name="computeIsolation")
    def compute_isolation(self) -> Optional[pulumi.Input['SparkClusterComputeIsolationArgs']]:
        """
        A `compute_isolation` block as defined below.
        """
        return pulumi.get(self, "compute_isolation")

    @compute_isolation.setter
    def compute_isolation(self, value: Optional[pulumi.Input['SparkClusterComputeIsolationArgs']]):
        pulumi.set(self, "compute_isolation", value)

    @property
    @pulumi.getter(name="diskEncryptions")
    def disk_encryptions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SparkClusterDiskEncryptionArgs']]]]:
        """
        One or more `disk_encryption` block as defined below.
        """
        return pulumi.get(self, "disk_encryptions")

    @disk_encryptions.setter
    def disk_encryptions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SparkClusterDiskEncryptionArgs']]]]):
        pulumi.set(self, "disk_encryptions", value)

    @property
    @pulumi.getter(name="encryptionInTransitEnabled")
    def encryption_in_transit_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether encryption in transit is enabled for this Cluster. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "encryption_in_transit_enabled")

    @encryption_in_transit_enabled.setter
    def encryption_in_transit_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "encryption_in_transit_enabled", value)

    @property
    @pulumi.getter
    def extension(self) -> Optional[pulumi.Input['SparkClusterExtensionArgs']]:
        """
        An `extension` block as defined below.
        """
        return pulumi.get(self, "extension")

    @extension.setter
    def extension(self, value: Optional[pulumi.Input['SparkClusterExtensionArgs']]):
        pulumi.set(self, "extension", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the Azure Region which this HDInsight Spark Cluster should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def metastores(self) -> Optional[pulumi.Input['SparkClusterMetastoresArgs']]:
        """
        A `metastores` block as defined below.
        """
        return pulumi.get(self, "metastores")

    @metastores.setter
    def metastores(self, value: Optional[pulumi.Input['SparkClusterMetastoresArgs']]):
        pulumi.set(self, "metastores", value)

    @property
    @pulumi.getter
    def monitor(self) -> Optional[pulumi.Input['SparkClusterMonitorArgs']]:
        """
        A `monitor` block as defined below.
        """
        return pulumi.get(self, "monitor")

    @monitor.setter
    def monitor(self, value: Optional[pulumi.Input['SparkClusterMonitorArgs']]):
        pulumi.set(self, "monitor", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name for this HDInsight Spark Cluster. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input['SparkClusterNetworkArgs']]:
        """
        A `network` block as defined below.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input['SparkClusterNetworkArgs']]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter(name="privateLinkConfiguration")
    def private_link_configuration(self) -> Optional[pulumi.Input['SparkClusterPrivateLinkConfigurationArgs']]:
        """
        A `private_link_configuration` block as defined below.
        """
        return pulumi.get(self, "private_link_configuration")

    @private_link_configuration.setter
    def private_link_configuration(self, value: Optional[pulumi.Input['SparkClusterPrivateLinkConfigurationArgs']]):
        pulumi.set(self, "private_link_configuration", value)

    @property
    @pulumi.getter(name="securityProfile")
    def security_profile(self) -> Optional[pulumi.Input['SparkClusterSecurityProfileArgs']]:
        """
        A `security_profile` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "security_profile")

    @security_profile.setter
    def security_profile(self, value: Optional[pulumi.Input['SparkClusterSecurityProfileArgs']]):
        pulumi.set(self, "security_profile", value)

    @property
    @pulumi.getter(name="storageAccountGen2")
    def storage_account_gen2(self) -> Optional[pulumi.Input['SparkClusterStorageAccountGen2Args']]:
        """
        A `storage_account_gen2` block as defined below.
        """
        return pulumi.get(self, "storage_account_gen2")

    @storage_account_gen2.setter
    def storage_account_gen2(self, value: Optional[pulumi.Input['SparkClusterStorageAccountGen2Args']]):
        pulumi.set(self, "storage_account_gen2", value)

    @property
    @pulumi.getter(name="storageAccounts")
    def storage_accounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SparkClusterStorageAccountArgs']]]]:
        """
        One or more `storage_account` block as defined below.
        """
        return pulumi.get(self, "storage_accounts")

    @storage_accounts.setter
    def storage_accounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SparkClusterStorageAccountArgs']]]]):
        pulumi.set(self, "storage_accounts", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of Tags which should be assigned to this HDInsight Spark Cluster.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tlsMinVersion")
    def tls_min_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The minimal supported TLS version. Possible values are 1.0, 1.1 or 1.2. Changing this forces a new resource to be created.

        > **Note:** Starting on June 30, 2020, Azure HDInsight will enforce TLS 1.2 or later versions for all HTTPS connections. For more information, see [Azure HDInsight TLS 1.2 Enforcement](https://azure.microsoft.com/en-us/updates/azure-hdinsight-tls-12-enforcement/).
        """
        return pulumi.get(self, "tls_min_version")

    @tls_min_version.setter
    def tls_min_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tls_min_version", value)

    @property
    @pulumi.getter
    def zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of Availability Zones which should be used for this HDInsight Spark Cluster. Chaning this forces a new resource to be created.
        """
        return pulumi.get(self, "zones")

    @zones.setter
    def zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "zones", value)


@pulumi.input_type
class _SparkClusterState:
    def __init__(__self__, *,
                 cluster_version: Optional[pulumi.Input[builtins.str]] = None,
                 component_version: Optional[pulumi.Input['SparkClusterComponentVersionArgs']] = None,
                 compute_isolation: Optional[pulumi.Input['SparkClusterComputeIsolationArgs']] = None,
                 disk_encryptions: Optional[pulumi.Input[Sequence[pulumi.Input['SparkClusterDiskEncryptionArgs']]]] = None,
                 encryption_in_transit_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 extension: Optional[pulumi.Input['SparkClusterExtensionArgs']] = None,
                 gateway: Optional[pulumi.Input['SparkClusterGatewayArgs']] = None,
                 https_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 metastores: Optional[pulumi.Input['SparkClusterMetastoresArgs']] = None,
                 monitor: Optional[pulumi.Input['SparkClusterMonitorArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network: Optional[pulumi.Input['SparkClusterNetworkArgs']] = None,
                 private_link_configuration: Optional[pulumi.Input['SparkClusterPrivateLinkConfigurationArgs']] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 roles: Optional[pulumi.Input['SparkClusterRolesArgs']] = None,
                 security_profile: Optional[pulumi.Input['SparkClusterSecurityProfileArgs']] = None,
                 ssh_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 storage_account_gen2: Optional[pulumi.Input['SparkClusterStorageAccountGen2Args']] = None,
                 storage_accounts: Optional[pulumi.Input[Sequence[pulumi.Input['SparkClusterStorageAccountArgs']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tier: Optional[pulumi.Input[builtins.str]] = None,
                 tls_min_version: Optional[pulumi.Input[builtins.str]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering SparkCluster resources.
        :param pulumi.Input[builtins.str] cluster_version: Specifies the Version of HDInsights which should be used for this Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input['SparkClusterComponentVersionArgs'] component_version: A `component_version` block as defined below.
        :param pulumi.Input['SparkClusterComputeIsolationArgs'] compute_isolation: A `compute_isolation` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['SparkClusterDiskEncryptionArgs']]] disk_encryptions: One or more `disk_encryption` block as defined below.
        :param pulumi.Input[builtins.bool] encryption_in_transit_enabled: Whether encryption in transit is enabled for this Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input['SparkClusterExtensionArgs'] extension: An `extension` block as defined below.
        :param pulumi.Input['SparkClusterGatewayArgs'] gateway: A `gateway` block as defined below.
        :param pulumi.Input[builtins.str] https_endpoint: The HTTPS Connectivity Endpoint for this HDInsight Spark Cluster.
        :param pulumi.Input[builtins.str] location: Specifies the Azure Region which this HDInsight Spark Cluster should exist. Changing this forces a new resource to be created.
        :param pulumi.Input['SparkClusterMetastoresArgs'] metastores: A `metastores` block as defined below.
        :param pulumi.Input['SparkClusterMonitorArgs'] monitor: A `monitor` block as defined below.
        :param pulumi.Input[builtins.str] name: Specifies the name for this HDInsight Spark Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input['SparkClusterNetworkArgs'] network: A `network` block as defined below.
        :param pulumi.Input['SparkClusterPrivateLinkConfigurationArgs'] private_link_configuration: A `private_link_configuration` block as defined below.
        :param pulumi.Input[builtins.str] resource_group_name: Specifies the name of the Resource Group in which this HDInsight Spark Cluster should exist. Changing this forces a new resource to be created.
        :param pulumi.Input['SparkClusterRolesArgs'] roles: A `roles` block as defined below.
        :param pulumi.Input['SparkClusterSecurityProfileArgs'] security_profile: A `security_profile` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] ssh_endpoint: The SSH Connectivity Endpoint for this HDInsight Spark Cluster.
        :param pulumi.Input['SparkClusterStorageAccountGen2Args'] storage_account_gen2: A `storage_account_gen2` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['SparkClusterStorageAccountArgs']]] storage_accounts: One or more `storage_account` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A map of Tags which should be assigned to this HDInsight Spark Cluster.
        :param pulumi.Input[builtins.str] tier: Specifies the Tier which should be used for this HDInsight Spark Cluster. Possible values are `Standard` or `Premium`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] tls_min_version: The minimal supported TLS version. Possible values are 1.0, 1.1 or 1.2. Changing this forces a new resource to be created.
               
               > **Note:** Starting on June 30, 2020, Azure HDInsight will enforce TLS 1.2 or later versions for all HTTPS connections. For more information, see [Azure HDInsight TLS 1.2 Enforcement](https://azure.microsoft.com/en-us/updates/azure-hdinsight-tls-12-enforcement/).
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] zones: A list of Availability Zones which should be used for this HDInsight Spark Cluster. Chaning this forces a new resource to be created.
        """
        if cluster_version is not None:
            pulumi.set(__self__, "cluster_version", cluster_version)
        if component_version is not None:
            pulumi.set(__self__, "component_version", component_version)
        if compute_isolation is not None:
            pulumi.set(__self__, "compute_isolation", compute_isolation)
        if disk_encryptions is not None:
            pulumi.set(__self__, "disk_encryptions", disk_encryptions)
        if encryption_in_transit_enabled is not None:
            pulumi.set(__self__, "encryption_in_transit_enabled", encryption_in_transit_enabled)
        if extension is not None:
            pulumi.set(__self__, "extension", extension)
        if gateway is not None:
            pulumi.set(__self__, "gateway", gateway)
        if https_endpoint is not None:
            pulumi.set(__self__, "https_endpoint", https_endpoint)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if metastores is not None:
            pulumi.set(__self__, "metastores", metastores)
        if monitor is not None:
            pulumi.set(__self__, "monitor", monitor)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if private_link_configuration is not None:
            pulumi.set(__self__, "private_link_configuration", private_link_configuration)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if roles is not None:
            pulumi.set(__self__, "roles", roles)
        if security_profile is not None:
            pulumi.set(__self__, "security_profile", security_profile)
        if ssh_endpoint is not None:
            pulumi.set(__self__, "ssh_endpoint", ssh_endpoint)
        if storage_account_gen2 is not None:
            pulumi.set(__self__, "storage_account_gen2", storage_account_gen2)
        if storage_accounts is not None:
            pulumi.set(__self__, "storage_accounts", storage_accounts)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)
        if tls_min_version is not None:
            pulumi.set(__self__, "tls_min_version", tls_min_version)
        if zones is not None:
            pulumi.set(__self__, "zones", zones)

    @property
    @pulumi.getter(name="clusterVersion")
    def cluster_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the Version of HDInsights which should be used for this Cluster. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "cluster_version")

    @cluster_version.setter
    def cluster_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cluster_version", value)

    @property
    @pulumi.getter(name="componentVersion")
    def component_version(self) -> Optional[pulumi.Input['SparkClusterComponentVersionArgs']]:
        """
        A `component_version` block as defined below.
        """
        return pulumi.get(self, "component_version")

    @component_version.setter
    def component_version(self, value: Optional[pulumi.Input['SparkClusterComponentVersionArgs']]):
        pulumi.set(self, "component_version", value)

    @property
    @pulumi.getter(name="computeIsolation")
    def compute_isolation(self) -> Optional[pulumi.Input['SparkClusterComputeIsolationArgs']]:
        """
        A `compute_isolation` block as defined below.
        """
        return pulumi.get(self, "compute_isolation")

    @compute_isolation.setter
    def compute_isolation(self, value: Optional[pulumi.Input['SparkClusterComputeIsolationArgs']]):
        pulumi.set(self, "compute_isolation", value)

    @property
    @pulumi.getter(name="diskEncryptions")
    def disk_encryptions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SparkClusterDiskEncryptionArgs']]]]:
        """
        One or more `disk_encryption` block as defined below.
        """
        return pulumi.get(self, "disk_encryptions")

    @disk_encryptions.setter
    def disk_encryptions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SparkClusterDiskEncryptionArgs']]]]):
        pulumi.set(self, "disk_encryptions", value)

    @property
    @pulumi.getter(name="encryptionInTransitEnabled")
    def encryption_in_transit_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether encryption in transit is enabled for this Cluster. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "encryption_in_transit_enabled")

    @encryption_in_transit_enabled.setter
    def encryption_in_transit_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "encryption_in_transit_enabled", value)

    @property
    @pulumi.getter
    def extension(self) -> Optional[pulumi.Input['SparkClusterExtensionArgs']]:
        """
        An `extension` block as defined below.
        """
        return pulumi.get(self, "extension")

    @extension.setter
    def extension(self, value: Optional[pulumi.Input['SparkClusterExtensionArgs']]):
        pulumi.set(self, "extension", value)

    @property
    @pulumi.getter
    def gateway(self) -> Optional[pulumi.Input['SparkClusterGatewayArgs']]:
        """
        A `gateway` block as defined below.
        """
        return pulumi.get(self, "gateway")

    @gateway.setter
    def gateway(self, value: Optional[pulumi.Input['SparkClusterGatewayArgs']]):
        pulumi.set(self, "gateway", value)

    @property
    @pulumi.getter(name="httpsEndpoint")
    def https_endpoint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The HTTPS Connectivity Endpoint for this HDInsight Spark Cluster.
        """
        return pulumi.get(self, "https_endpoint")

    @https_endpoint.setter
    def https_endpoint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "https_endpoint", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the Azure Region which this HDInsight Spark Cluster should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def metastores(self) -> Optional[pulumi.Input['SparkClusterMetastoresArgs']]:
        """
        A `metastores` block as defined below.
        """
        return pulumi.get(self, "metastores")

    @metastores.setter
    def metastores(self, value: Optional[pulumi.Input['SparkClusterMetastoresArgs']]):
        pulumi.set(self, "metastores", value)

    @property
    @pulumi.getter
    def monitor(self) -> Optional[pulumi.Input['SparkClusterMonitorArgs']]:
        """
        A `monitor` block as defined below.
        """
        return pulumi.get(self, "monitor")

    @monitor.setter
    def monitor(self, value: Optional[pulumi.Input['SparkClusterMonitorArgs']]):
        pulumi.set(self, "monitor", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name for this HDInsight Spark Cluster. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input['SparkClusterNetworkArgs']]:
        """
        A `network` block as defined below.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input['SparkClusterNetworkArgs']]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter(name="privateLinkConfiguration")
    def private_link_configuration(self) -> Optional[pulumi.Input['SparkClusterPrivateLinkConfigurationArgs']]:
        """
        A `private_link_configuration` block as defined below.
        """
        return pulumi.get(self, "private_link_configuration")

    @private_link_configuration.setter
    def private_link_configuration(self, value: Optional[pulumi.Input['SparkClusterPrivateLinkConfigurationArgs']]):
        pulumi.set(self, "private_link_configuration", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the Resource Group in which this HDInsight Spark Cluster should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter
    def roles(self) -> Optional[pulumi.Input['SparkClusterRolesArgs']]:
        """
        A `roles` block as defined below.
        """
        return pulumi.get(self, "roles")

    @roles.setter
    def roles(self, value: Optional[pulumi.Input['SparkClusterRolesArgs']]):
        pulumi.set(self, "roles", value)

    @property
    @pulumi.getter(name="securityProfile")
    def security_profile(self) -> Optional[pulumi.Input['SparkClusterSecurityProfileArgs']]:
        """
        A `security_profile` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "security_profile")

    @security_profile.setter
    def security_profile(self, value: Optional[pulumi.Input['SparkClusterSecurityProfileArgs']]):
        pulumi.set(self, "security_profile", value)

    @property
    @pulumi.getter(name="sshEndpoint")
    def ssh_endpoint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The SSH Connectivity Endpoint for this HDInsight Spark Cluster.
        """
        return pulumi.get(self, "ssh_endpoint")

    @ssh_endpoint.setter
    def ssh_endpoint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ssh_endpoint", value)

    @property
    @pulumi.getter(name="storageAccountGen2")
    def storage_account_gen2(self) -> Optional[pulumi.Input['SparkClusterStorageAccountGen2Args']]:
        """
        A `storage_account_gen2` block as defined below.
        """
        return pulumi.get(self, "storage_account_gen2")

    @storage_account_gen2.setter
    def storage_account_gen2(self, value: Optional[pulumi.Input['SparkClusterStorageAccountGen2Args']]):
        pulumi.set(self, "storage_account_gen2", value)

    @property
    @pulumi.getter(name="storageAccounts")
    def storage_accounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SparkClusterStorageAccountArgs']]]]:
        """
        One or more `storage_account` block as defined below.
        """
        return pulumi.get(self, "storage_accounts")

    @storage_accounts.setter
    def storage_accounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SparkClusterStorageAccountArgs']]]]):
        pulumi.set(self, "storage_accounts", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of Tags which should be assigned to this HDInsight Spark Cluster.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def tier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the Tier which should be used for this HDInsight Spark Cluster. Possible values are `Standard` or `Premium`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "tier")

    @tier.setter
    def tier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tier", value)

    @property
    @pulumi.getter(name="tlsMinVersion")
    def tls_min_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The minimal supported TLS version. Possible values are 1.0, 1.1 or 1.2. Changing this forces a new resource to be created.

        > **Note:** Starting on June 30, 2020, Azure HDInsight will enforce TLS 1.2 or later versions for all HTTPS connections. For more information, see [Azure HDInsight TLS 1.2 Enforcement](https://azure.microsoft.com/en-us/updates/azure-hdinsight-tls-12-enforcement/).
        """
        return pulumi.get(self, "tls_min_version")

    @tls_min_version.setter
    def tls_min_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tls_min_version", value)

    @property
    @pulumi.getter
    def zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of Availability Zones which should be used for this HDInsight Spark Cluster. Chaning this forces a new resource to be created.
        """
        return pulumi.get(self, "zones")

    @zones.setter
    def zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "zones", value)


@pulumi.type_token("azure:hdinsight/sparkCluster:SparkCluster")
class SparkCluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_version: Optional[pulumi.Input[builtins.str]] = None,
                 component_version: Optional[pulumi.Input[Union['SparkClusterComponentVersionArgs', 'SparkClusterComponentVersionArgsDict']]] = None,
                 compute_isolation: Optional[pulumi.Input[Union['SparkClusterComputeIsolationArgs', 'SparkClusterComputeIsolationArgsDict']]] = None,
                 disk_encryptions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SparkClusterDiskEncryptionArgs', 'SparkClusterDiskEncryptionArgsDict']]]]] = None,
                 encryption_in_transit_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 extension: Optional[pulumi.Input[Union['SparkClusterExtensionArgs', 'SparkClusterExtensionArgsDict']]] = None,
                 gateway: Optional[pulumi.Input[Union['SparkClusterGatewayArgs', 'SparkClusterGatewayArgsDict']]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 metastores: Optional[pulumi.Input[Union['SparkClusterMetastoresArgs', 'SparkClusterMetastoresArgsDict']]] = None,
                 monitor: Optional[pulumi.Input[Union['SparkClusterMonitorArgs', 'SparkClusterMonitorArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network: Optional[pulumi.Input[Union['SparkClusterNetworkArgs', 'SparkClusterNetworkArgsDict']]] = None,
                 private_link_configuration: Optional[pulumi.Input[Union['SparkClusterPrivateLinkConfigurationArgs', 'SparkClusterPrivateLinkConfigurationArgsDict']]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 roles: Optional[pulumi.Input[Union['SparkClusterRolesArgs', 'SparkClusterRolesArgsDict']]] = None,
                 security_profile: Optional[pulumi.Input[Union['SparkClusterSecurityProfileArgs', 'SparkClusterSecurityProfileArgsDict']]] = None,
                 storage_account_gen2: Optional[pulumi.Input[Union['SparkClusterStorageAccountGen2Args', 'SparkClusterStorageAccountGen2ArgsDict']]] = None,
                 storage_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SparkClusterStorageAccountArgs', 'SparkClusterStorageAccountArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tier: Optional[pulumi.Input[builtins.str]] = None,
                 tls_min_version: Optional[pulumi.Input[builtins.str]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        Manages a HDInsight Spark Cluster.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_account = azure.storage.Account("example",
            name="hdinsightstor",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS")
        example_container = azure.storage.Container("example",
            name="hdinsight",
            storage_account_name=example_account.name,
            container_access_type="private")
        example_spark_cluster = azure.hdinsight.SparkCluster("example",
            name="example-hdicluster",
            resource_group_name=example.name,
            location=example.location,
            cluster_version="3.6",
            tier="Standard",
            component_version={
                "spark": "2.3",
            },
            gateway={
                "username": "acctestusrgw",
                "password": "Password123!",
            },
            storage_accounts=[{
                "storage_container_id": example_container.id,
                "storage_account_key": example_account.primary_access_key,
                "is_default": True,
            }],
            roles={
                "head_node": {
                    "vm_size": "Standard_A3",
                    "username": "acctestusrvm",
                    "password": "AccTestvdSC4daf986!",
                },
                "worker_node": {
                    "vm_size": "Standard_A3",
                    "username": "acctestusrvm",
                    "password": "AccTestvdSC4daf986!",
                    "target_instance_count": 3,
                },
                "zookeeper_node": {
                    "vm_size": "Medium",
                    "username": "acctestusrvm",
                    "password": "AccTestvdSC4daf986!",
                },
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.HDInsight`: 2021-06-01

        ## Import

        HDInsight Spark Clusters can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:hdinsight/sparkCluster:SparkCluster example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.HDInsight/clusters/cluster1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] cluster_version: Specifies the Version of HDInsights which should be used for this Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['SparkClusterComponentVersionArgs', 'SparkClusterComponentVersionArgsDict']] component_version: A `component_version` block as defined below.
        :param pulumi.Input[Union['SparkClusterComputeIsolationArgs', 'SparkClusterComputeIsolationArgsDict']] compute_isolation: A `compute_isolation` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SparkClusterDiskEncryptionArgs', 'SparkClusterDiskEncryptionArgsDict']]]] disk_encryptions: One or more `disk_encryption` block as defined below.
        :param pulumi.Input[builtins.bool] encryption_in_transit_enabled: Whether encryption in transit is enabled for this Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['SparkClusterExtensionArgs', 'SparkClusterExtensionArgsDict']] extension: An `extension` block as defined below.
        :param pulumi.Input[Union['SparkClusterGatewayArgs', 'SparkClusterGatewayArgsDict']] gateway: A `gateway` block as defined below.
        :param pulumi.Input[builtins.str] location: Specifies the Azure Region which this HDInsight Spark Cluster should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['SparkClusterMetastoresArgs', 'SparkClusterMetastoresArgsDict']] metastores: A `metastores` block as defined below.
        :param pulumi.Input[Union['SparkClusterMonitorArgs', 'SparkClusterMonitorArgsDict']] monitor: A `monitor` block as defined below.
        :param pulumi.Input[builtins.str] name: Specifies the name for this HDInsight Spark Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['SparkClusterNetworkArgs', 'SparkClusterNetworkArgsDict']] network: A `network` block as defined below.
        :param pulumi.Input[Union['SparkClusterPrivateLinkConfigurationArgs', 'SparkClusterPrivateLinkConfigurationArgsDict']] private_link_configuration: A `private_link_configuration` block as defined below.
        :param pulumi.Input[builtins.str] resource_group_name: Specifies the name of the Resource Group in which this HDInsight Spark Cluster should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['SparkClusterRolesArgs', 'SparkClusterRolesArgsDict']] roles: A `roles` block as defined below.
        :param pulumi.Input[Union['SparkClusterSecurityProfileArgs', 'SparkClusterSecurityProfileArgsDict']] security_profile: A `security_profile` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['SparkClusterStorageAccountGen2Args', 'SparkClusterStorageAccountGen2ArgsDict']] storage_account_gen2: A `storage_account_gen2` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SparkClusterStorageAccountArgs', 'SparkClusterStorageAccountArgsDict']]]] storage_accounts: One or more `storage_account` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A map of Tags which should be assigned to this HDInsight Spark Cluster.
        :param pulumi.Input[builtins.str] tier: Specifies the Tier which should be used for this HDInsight Spark Cluster. Possible values are `Standard` or `Premium`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] tls_min_version: The minimal supported TLS version. Possible values are 1.0, 1.1 or 1.2. Changing this forces a new resource to be created.
               
               > **Note:** Starting on June 30, 2020, Azure HDInsight will enforce TLS 1.2 or later versions for all HTTPS connections. For more information, see [Azure HDInsight TLS 1.2 Enforcement](https://azure.microsoft.com/en-us/updates/azure-hdinsight-tls-12-enforcement/).
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] zones: A list of Availability Zones which should be used for this HDInsight Spark Cluster. Chaning this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SparkClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a HDInsight Spark Cluster.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_account = azure.storage.Account("example",
            name="hdinsightstor",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS")
        example_container = azure.storage.Container("example",
            name="hdinsight",
            storage_account_name=example_account.name,
            container_access_type="private")
        example_spark_cluster = azure.hdinsight.SparkCluster("example",
            name="example-hdicluster",
            resource_group_name=example.name,
            location=example.location,
            cluster_version="3.6",
            tier="Standard",
            component_version={
                "spark": "2.3",
            },
            gateway={
                "username": "acctestusrgw",
                "password": "Password123!",
            },
            storage_accounts=[{
                "storage_container_id": example_container.id,
                "storage_account_key": example_account.primary_access_key,
                "is_default": True,
            }],
            roles={
                "head_node": {
                    "vm_size": "Standard_A3",
                    "username": "acctestusrvm",
                    "password": "AccTestvdSC4daf986!",
                },
                "worker_node": {
                    "vm_size": "Standard_A3",
                    "username": "acctestusrvm",
                    "password": "AccTestvdSC4daf986!",
                    "target_instance_count": 3,
                },
                "zookeeper_node": {
                    "vm_size": "Medium",
                    "username": "acctestusrvm",
                    "password": "AccTestvdSC4daf986!",
                },
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.HDInsight`: 2021-06-01

        ## Import

        HDInsight Spark Clusters can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:hdinsight/sparkCluster:SparkCluster example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.HDInsight/clusters/cluster1
        ```

        :param str resource_name: The name of the resource.
        :param SparkClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SparkClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_version: Optional[pulumi.Input[builtins.str]] = None,
                 component_version: Optional[pulumi.Input[Union['SparkClusterComponentVersionArgs', 'SparkClusterComponentVersionArgsDict']]] = None,
                 compute_isolation: Optional[pulumi.Input[Union['SparkClusterComputeIsolationArgs', 'SparkClusterComputeIsolationArgsDict']]] = None,
                 disk_encryptions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SparkClusterDiskEncryptionArgs', 'SparkClusterDiskEncryptionArgsDict']]]]] = None,
                 encryption_in_transit_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 extension: Optional[pulumi.Input[Union['SparkClusterExtensionArgs', 'SparkClusterExtensionArgsDict']]] = None,
                 gateway: Optional[pulumi.Input[Union['SparkClusterGatewayArgs', 'SparkClusterGatewayArgsDict']]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 metastores: Optional[pulumi.Input[Union['SparkClusterMetastoresArgs', 'SparkClusterMetastoresArgsDict']]] = None,
                 monitor: Optional[pulumi.Input[Union['SparkClusterMonitorArgs', 'SparkClusterMonitorArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network: Optional[pulumi.Input[Union['SparkClusterNetworkArgs', 'SparkClusterNetworkArgsDict']]] = None,
                 private_link_configuration: Optional[pulumi.Input[Union['SparkClusterPrivateLinkConfigurationArgs', 'SparkClusterPrivateLinkConfigurationArgsDict']]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 roles: Optional[pulumi.Input[Union['SparkClusterRolesArgs', 'SparkClusterRolesArgsDict']]] = None,
                 security_profile: Optional[pulumi.Input[Union['SparkClusterSecurityProfileArgs', 'SparkClusterSecurityProfileArgsDict']]] = None,
                 storage_account_gen2: Optional[pulumi.Input[Union['SparkClusterStorageAccountGen2Args', 'SparkClusterStorageAccountGen2ArgsDict']]] = None,
                 storage_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SparkClusterStorageAccountArgs', 'SparkClusterStorageAccountArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tier: Optional[pulumi.Input[builtins.str]] = None,
                 tls_min_version: Optional[pulumi.Input[builtins.str]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SparkClusterArgs.__new__(SparkClusterArgs)

            if cluster_version is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_version'")
            __props__.__dict__["cluster_version"] = cluster_version
            if component_version is None and not opts.urn:
                raise TypeError("Missing required property 'component_version'")
            __props__.__dict__["component_version"] = component_version
            __props__.__dict__["compute_isolation"] = compute_isolation
            __props__.__dict__["disk_encryptions"] = disk_encryptions
            __props__.__dict__["encryption_in_transit_enabled"] = encryption_in_transit_enabled
            __props__.__dict__["extension"] = extension
            if gateway is None and not opts.urn:
                raise TypeError("Missing required property 'gateway'")
            __props__.__dict__["gateway"] = gateway
            __props__.__dict__["location"] = location
            __props__.__dict__["metastores"] = metastores
            __props__.__dict__["monitor"] = monitor
            __props__.__dict__["name"] = name
            __props__.__dict__["network"] = network
            __props__.__dict__["private_link_configuration"] = private_link_configuration
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            if roles is None and not opts.urn:
                raise TypeError("Missing required property 'roles'")
            __props__.__dict__["roles"] = roles
            __props__.__dict__["security_profile"] = security_profile
            __props__.__dict__["storage_account_gen2"] = storage_account_gen2
            __props__.__dict__["storage_accounts"] = storage_accounts
            __props__.__dict__["tags"] = tags
            if tier is None and not opts.urn:
                raise TypeError("Missing required property 'tier'")
            __props__.__dict__["tier"] = tier
            __props__.__dict__["tls_min_version"] = tls_min_version
            __props__.__dict__["zones"] = zones
            __props__.__dict__["https_endpoint"] = None
            __props__.__dict__["ssh_endpoint"] = None
        super(SparkCluster, __self__).__init__(
            'azure:hdinsight/sparkCluster:SparkCluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cluster_version: Optional[pulumi.Input[builtins.str]] = None,
            component_version: Optional[pulumi.Input[Union['SparkClusterComponentVersionArgs', 'SparkClusterComponentVersionArgsDict']]] = None,
            compute_isolation: Optional[pulumi.Input[Union['SparkClusterComputeIsolationArgs', 'SparkClusterComputeIsolationArgsDict']]] = None,
            disk_encryptions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SparkClusterDiskEncryptionArgs', 'SparkClusterDiskEncryptionArgsDict']]]]] = None,
            encryption_in_transit_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            extension: Optional[pulumi.Input[Union['SparkClusterExtensionArgs', 'SparkClusterExtensionArgsDict']]] = None,
            gateway: Optional[pulumi.Input[Union['SparkClusterGatewayArgs', 'SparkClusterGatewayArgsDict']]] = None,
            https_endpoint: Optional[pulumi.Input[builtins.str]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            metastores: Optional[pulumi.Input[Union['SparkClusterMetastoresArgs', 'SparkClusterMetastoresArgsDict']]] = None,
            monitor: Optional[pulumi.Input[Union['SparkClusterMonitorArgs', 'SparkClusterMonitorArgsDict']]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            network: Optional[pulumi.Input[Union['SparkClusterNetworkArgs', 'SparkClusterNetworkArgsDict']]] = None,
            private_link_configuration: Optional[pulumi.Input[Union['SparkClusterPrivateLinkConfigurationArgs', 'SparkClusterPrivateLinkConfigurationArgsDict']]] = None,
            resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
            roles: Optional[pulumi.Input[Union['SparkClusterRolesArgs', 'SparkClusterRolesArgsDict']]] = None,
            security_profile: Optional[pulumi.Input[Union['SparkClusterSecurityProfileArgs', 'SparkClusterSecurityProfileArgsDict']]] = None,
            ssh_endpoint: Optional[pulumi.Input[builtins.str]] = None,
            storage_account_gen2: Optional[pulumi.Input[Union['SparkClusterStorageAccountGen2Args', 'SparkClusterStorageAccountGen2ArgsDict']]] = None,
            storage_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SparkClusterStorageAccountArgs', 'SparkClusterStorageAccountArgsDict']]]]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            tier: Optional[pulumi.Input[builtins.str]] = None,
            tls_min_version: Optional[pulumi.Input[builtins.str]] = None,
            zones: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None) -> 'SparkCluster':
        """
        Get an existing SparkCluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] cluster_version: Specifies the Version of HDInsights which should be used for this Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['SparkClusterComponentVersionArgs', 'SparkClusterComponentVersionArgsDict']] component_version: A `component_version` block as defined below.
        :param pulumi.Input[Union['SparkClusterComputeIsolationArgs', 'SparkClusterComputeIsolationArgsDict']] compute_isolation: A `compute_isolation` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SparkClusterDiskEncryptionArgs', 'SparkClusterDiskEncryptionArgsDict']]]] disk_encryptions: One or more `disk_encryption` block as defined below.
        :param pulumi.Input[builtins.bool] encryption_in_transit_enabled: Whether encryption in transit is enabled for this Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['SparkClusterExtensionArgs', 'SparkClusterExtensionArgsDict']] extension: An `extension` block as defined below.
        :param pulumi.Input[Union['SparkClusterGatewayArgs', 'SparkClusterGatewayArgsDict']] gateway: A `gateway` block as defined below.
        :param pulumi.Input[builtins.str] https_endpoint: The HTTPS Connectivity Endpoint for this HDInsight Spark Cluster.
        :param pulumi.Input[builtins.str] location: Specifies the Azure Region which this HDInsight Spark Cluster should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['SparkClusterMetastoresArgs', 'SparkClusterMetastoresArgsDict']] metastores: A `metastores` block as defined below.
        :param pulumi.Input[Union['SparkClusterMonitorArgs', 'SparkClusterMonitorArgsDict']] monitor: A `monitor` block as defined below.
        :param pulumi.Input[builtins.str] name: Specifies the name for this HDInsight Spark Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['SparkClusterNetworkArgs', 'SparkClusterNetworkArgsDict']] network: A `network` block as defined below.
        :param pulumi.Input[Union['SparkClusterPrivateLinkConfigurationArgs', 'SparkClusterPrivateLinkConfigurationArgsDict']] private_link_configuration: A `private_link_configuration` block as defined below.
        :param pulumi.Input[builtins.str] resource_group_name: Specifies the name of the Resource Group in which this HDInsight Spark Cluster should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['SparkClusterRolesArgs', 'SparkClusterRolesArgsDict']] roles: A `roles` block as defined below.
        :param pulumi.Input[Union['SparkClusterSecurityProfileArgs', 'SparkClusterSecurityProfileArgsDict']] security_profile: A `security_profile` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] ssh_endpoint: The SSH Connectivity Endpoint for this HDInsight Spark Cluster.
        :param pulumi.Input[Union['SparkClusterStorageAccountGen2Args', 'SparkClusterStorageAccountGen2ArgsDict']] storage_account_gen2: A `storage_account_gen2` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SparkClusterStorageAccountArgs', 'SparkClusterStorageAccountArgsDict']]]] storage_accounts: One or more `storage_account` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A map of Tags which should be assigned to this HDInsight Spark Cluster.
        :param pulumi.Input[builtins.str] tier: Specifies the Tier which should be used for this HDInsight Spark Cluster. Possible values are `Standard` or `Premium`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] tls_min_version: The minimal supported TLS version. Possible values are 1.0, 1.1 or 1.2. Changing this forces a new resource to be created.
               
               > **Note:** Starting on June 30, 2020, Azure HDInsight will enforce TLS 1.2 or later versions for all HTTPS connections. For more information, see [Azure HDInsight TLS 1.2 Enforcement](https://azure.microsoft.com/en-us/updates/azure-hdinsight-tls-12-enforcement/).
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] zones: A list of Availability Zones which should be used for this HDInsight Spark Cluster. Chaning this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SparkClusterState.__new__(_SparkClusterState)

        __props__.__dict__["cluster_version"] = cluster_version
        __props__.__dict__["component_version"] = component_version
        __props__.__dict__["compute_isolation"] = compute_isolation
        __props__.__dict__["disk_encryptions"] = disk_encryptions
        __props__.__dict__["encryption_in_transit_enabled"] = encryption_in_transit_enabled
        __props__.__dict__["extension"] = extension
        __props__.__dict__["gateway"] = gateway
        __props__.__dict__["https_endpoint"] = https_endpoint
        __props__.__dict__["location"] = location
        __props__.__dict__["metastores"] = metastores
        __props__.__dict__["monitor"] = monitor
        __props__.__dict__["name"] = name
        __props__.__dict__["network"] = network
        __props__.__dict__["private_link_configuration"] = private_link_configuration
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["roles"] = roles
        __props__.__dict__["security_profile"] = security_profile
        __props__.__dict__["ssh_endpoint"] = ssh_endpoint
        __props__.__dict__["storage_account_gen2"] = storage_account_gen2
        __props__.__dict__["storage_accounts"] = storage_accounts
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tier"] = tier
        __props__.__dict__["tls_min_version"] = tls_min_version
        __props__.__dict__["zones"] = zones
        return SparkCluster(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="clusterVersion")
    def cluster_version(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the Version of HDInsights which should be used for this Cluster. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "cluster_version")

    @property
    @pulumi.getter(name="componentVersion")
    def component_version(self) -> pulumi.Output['outputs.SparkClusterComponentVersion']:
        """
        A `component_version` block as defined below.
        """
        return pulumi.get(self, "component_version")

    @property
    @pulumi.getter(name="computeIsolation")
    def compute_isolation(self) -> pulumi.Output[Optional['outputs.SparkClusterComputeIsolation']]:
        """
        A `compute_isolation` block as defined below.
        """
        return pulumi.get(self, "compute_isolation")

    @property
    @pulumi.getter(name="diskEncryptions")
    def disk_encryptions(self) -> pulumi.Output[Optional[Sequence['outputs.SparkClusterDiskEncryption']]]:
        """
        One or more `disk_encryption` block as defined below.
        """
        return pulumi.get(self, "disk_encryptions")

    @property
    @pulumi.getter(name="encryptionInTransitEnabled")
    def encryption_in_transit_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether encryption in transit is enabled for this Cluster. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "encryption_in_transit_enabled")

    @property
    @pulumi.getter
    def extension(self) -> pulumi.Output[Optional['outputs.SparkClusterExtension']]:
        """
        An `extension` block as defined below.
        """
        return pulumi.get(self, "extension")

    @property
    @pulumi.getter
    def gateway(self) -> pulumi.Output['outputs.SparkClusterGateway']:
        """
        A `gateway` block as defined below.
        """
        return pulumi.get(self, "gateway")

    @property
    @pulumi.getter(name="httpsEndpoint")
    def https_endpoint(self) -> pulumi.Output[builtins.str]:
        """
        The HTTPS Connectivity Endpoint for this HDInsight Spark Cluster.
        """
        return pulumi.get(self, "https_endpoint")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the Azure Region which this HDInsight Spark Cluster should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def metastores(self) -> pulumi.Output[Optional['outputs.SparkClusterMetastores']]:
        """
        A `metastores` block as defined below.
        """
        return pulumi.get(self, "metastores")

    @property
    @pulumi.getter
    def monitor(self) -> pulumi.Output[Optional['outputs.SparkClusterMonitor']]:
        """
        A `monitor` block as defined below.
        """
        return pulumi.get(self, "monitor")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the name for this HDInsight Spark Cluster. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def network(self) -> pulumi.Output[Optional['outputs.SparkClusterNetwork']]:
        """
        A `network` block as defined below.
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter(name="privateLinkConfiguration")
    def private_link_configuration(self) -> pulumi.Output[Optional['outputs.SparkClusterPrivateLinkConfiguration']]:
        """
        A `private_link_configuration` block as defined below.
        """
        return pulumi.get(self, "private_link_configuration")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the name of the Resource Group in which this HDInsight Spark Cluster should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter
    def roles(self) -> pulumi.Output['outputs.SparkClusterRoles']:
        """
        A `roles` block as defined below.
        """
        return pulumi.get(self, "roles")

    @property
    @pulumi.getter(name="securityProfile")
    def security_profile(self) -> pulumi.Output[Optional['outputs.SparkClusterSecurityProfile']]:
        """
        A `security_profile` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "security_profile")

    @property
    @pulumi.getter(name="sshEndpoint")
    def ssh_endpoint(self) -> pulumi.Output[builtins.str]:
        """
        The SSH Connectivity Endpoint for this HDInsight Spark Cluster.
        """
        return pulumi.get(self, "ssh_endpoint")

    @property
    @pulumi.getter(name="storageAccountGen2")
    def storage_account_gen2(self) -> pulumi.Output[Optional['outputs.SparkClusterStorageAccountGen2']]:
        """
        A `storage_account_gen2` block as defined below.
        """
        return pulumi.get(self, "storage_account_gen2")

    @property
    @pulumi.getter(name="storageAccounts")
    def storage_accounts(self) -> pulumi.Output[Optional[Sequence['outputs.SparkClusterStorageAccount']]]:
        """
        One or more `storage_account` block as defined below.
        """
        return pulumi.get(self, "storage_accounts")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A map of Tags which should be assigned to this HDInsight Spark Cluster.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def tier(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the Tier which should be used for this HDInsight Spark Cluster. Possible values are `Standard` or `Premium`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "tier")

    @property
    @pulumi.getter(name="tlsMinVersion")
    def tls_min_version(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The minimal supported TLS version. Possible values are 1.0, 1.1 or 1.2. Changing this forces a new resource to be created.

        > **Note:** Starting on June 30, 2020, Azure HDInsight will enforce TLS 1.2 or later versions for all HTTPS connections. For more information, see [Azure HDInsight TLS 1.2 Enforcement](https://azure.microsoft.com/en-us/updates/azure-hdinsight-tls-12-enforcement/).
        """
        return pulumi.get(self, "tls_min_version")

    @property
    @pulumi.getter
    def zones(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        A list of Availability Zones which should be used for this HDInsight Spark Cluster. Chaning this forces a new resource to be created.
        """
        return pulumi.get(self, "zones")

