# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetFhirServiceResult',
    'AwaitableGetFhirServiceResult',
    'get_fhir_service',
    'get_fhir_service_output',
]

@pulumi.output_type
class GetFhirServiceResult:
    """
    A collection of values returned by getFhirService.
    """
    def __init__(__self__, access_policy_object_ids=None, authentications=None, configuration_export_storage_account_name=None, container_registry_login_server_urls=None, cors=None, id=None, identities=None, kind=None, location=None, name=None, tags=None, workspace_id=None):
        if access_policy_object_ids and not isinstance(access_policy_object_ids, list):
            raise TypeError("Expected argument 'access_policy_object_ids' to be a list")
        pulumi.set(__self__, "access_policy_object_ids", access_policy_object_ids)
        if authentications and not isinstance(authentications, list):
            raise TypeError("Expected argument 'authentications' to be a list")
        pulumi.set(__self__, "authentications", authentications)
        if configuration_export_storage_account_name and not isinstance(configuration_export_storage_account_name, str):
            raise TypeError("Expected argument 'configuration_export_storage_account_name' to be a str")
        pulumi.set(__self__, "configuration_export_storage_account_name", configuration_export_storage_account_name)
        if container_registry_login_server_urls and not isinstance(container_registry_login_server_urls, list):
            raise TypeError("Expected argument 'container_registry_login_server_urls' to be a list")
        pulumi.set(__self__, "container_registry_login_server_urls", container_registry_login_server_urls)
        if cors and not isinstance(cors, list):
            raise TypeError("Expected argument 'cors' to be a list")
        pulumi.set(__self__, "cors", cors)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identities and not isinstance(identities, list):
            raise TypeError("Expected argument 'identities' to be a list")
        pulumi.set(__self__, "identities", identities)
        if kind and not isinstance(kind, str):
            raise TypeError("Expected argument 'kind' to be a str")
        pulumi.set(__self__, "kind", kind)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if workspace_id and not isinstance(workspace_id, str):
            raise TypeError("Expected argument 'workspace_id' to be a str")
        pulumi.set(__self__, "workspace_id", workspace_id)

    @property
    @pulumi.getter(name="accessPolicyObjectIds")
    def access_policy_object_ids(self) -> Sequence[builtins.str]:
        """
        The list of the access policies of the service instance.
        """
        return pulumi.get(self, "access_policy_object_ids")

    @property
    @pulumi.getter
    def authentications(self) -> Sequence['outputs.GetFhirServiceAuthenticationResult']:
        """
        The `authentication` block as defined below.
        """
        return pulumi.get(self, "authentications")

    @property
    @pulumi.getter(name="configurationExportStorageAccountName")
    def configuration_export_storage_account_name(self) -> builtins.str:
        """
        The name of the storage account which the operation configuration information is exported to.
        """
        return pulumi.get(self, "configuration_export_storage_account_name")

    @property
    @pulumi.getter(name="containerRegistryLoginServerUrls")
    def container_registry_login_server_urls(self) -> Sequence[builtins.str]:
        """
        The list of azure container registry settings used for convert data operation of the service instance.
        """
        return pulumi.get(self, "container_registry_login_server_urls")

    @property
    @pulumi.getter
    def cors(self) -> Sequence['outputs.GetFhirServiceCorResult']:
        """
        The `cors` block as defined below.
        """
        return pulumi.get(self, "cors")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def identities(self) -> Sequence['outputs.GetFhirServiceIdentityResult']:
        """
        The `identity` block as defined below.
        """
        return pulumi.get(self, "identities")

    @property
    @pulumi.getter
    def kind(self) -> builtins.str:
        """
        The kind of the Healthcare FHIR Service.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def location(self) -> builtins.str:
        """
        The Azure Region where the Healthcare FHIR Service is located.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, builtins.str]]:
        """
        The map of tags assigned to the Healthcare FHIR Service.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> builtins.str:
        return pulumi.get(self, "workspace_id")


class AwaitableGetFhirServiceResult(GetFhirServiceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFhirServiceResult(
            access_policy_object_ids=self.access_policy_object_ids,
            authentications=self.authentications,
            configuration_export_storage_account_name=self.configuration_export_storage_account_name,
            container_registry_login_server_urls=self.container_registry_login_server_urls,
            cors=self.cors,
            id=self.id,
            identities=self.identities,
            kind=self.kind,
            location=self.location,
            name=self.name,
            tags=self.tags,
            workspace_id=self.workspace_id)


def get_fhir_service(name: Optional[builtins.str] = None,
                     tags: Optional[Mapping[str, builtins.str]] = None,
                     workspace_id: Optional[builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFhirServiceResult:
    """
    Use this data source to access information about an existing Healthcare FHIR Service(Fast Healthcare Interoperability Resources).


    :param builtins.str name: The name of the Healthcare FHIR Service.
    :param Mapping[str, builtins.str] tags: The map of tags assigned to the Healthcare FHIR Service.
    :param builtins.str workspace_id: The id of the Healthcare Workspace in which the Healthcare FHIR Service exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['tags'] = tags
    __args__['workspaceId'] = workspace_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:healthcare/getFhirService:getFhirService', __args__, opts=opts, typ=GetFhirServiceResult).value

    return AwaitableGetFhirServiceResult(
        access_policy_object_ids=pulumi.get(__ret__, 'access_policy_object_ids'),
        authentications=pulumi.get(__ret__, 'authentications'),
        configuration_export_storage_account_name=pulumi.get(__ret__, 'configuration_export_storage_account_name'),
        container_registry_login_server_urls=pulumi.get(__ret__, 'container_registry_login_server_urls'),
        cors=pulumi.get(__ret__, 'cors'),
        id=pulumi.get(__ret__, 'id'),
        identities=pulumi.get(__ret__, 'identities'),
        kind=pulumi.get(__ret__, 'kind'),
        location=pulumi.get(__ret__, 'location'),
        name=pulumi.get(__ret__, 'name'),
        tags=pulumi.get(__ret__, 'tags'),
        workspace_id=pulumi.get(__ret__, 'workspace_id'))
def get_fhir_service_output(name: Optional[pulumi.Input[builtins.str]] = None,
                            tags: Optional[pulumi.Input[Optional[Mapping[str, builtins.str]]]] = None,
                            workspace_id: Optional[pulumi.Input[builtins.str]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFhirServiceResult]:
    """
    Use this data source to access information about an existing Healthcare FHIR Service(Fast Healthcare Interoperability Resources).


    :param builtins.str name: The name of the Healthcare FHIR Service.
    :param Mapping[str, builtins.str] tags: The map of tags assigned to the Healthcare FHIR Service.
    :param builtins.str workspace_id: The id of the Healthcare Workspace in which the Healthcare FHIR Service exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['tags'] = tags
    __args__['workspaceId'] = workspace_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:healthcare/getFhirService:getFhirService', __args__, opts=opts, typ=GetFhirServiceResult)
    return __ret__.apply(lambda __response__: GetFhirServiceResult(
        access_policy_object_ids=pulumi.get(__response__, 'access_policy_object_ids'),
        authentications=pulumi.get(__response__, 'authentications'),
        configuration_export_storage_account_name=pulumi.get(__response__, 'configuration_export_storage_account_name'),
        container_registry_login_server_urls=pulumi.get(__response__, 'container_registry_login_server_urls'),
        cors=pulumi.get(__response__, 'cors'),
        id=pulumi.get(__response__, 'id'),
        identities=pulumi.get(__response__, 'identities'),
        kind=pulumi.get(__response__, 'kind'),
        location=pulumi.get(__response__, 'location'),
        name=pulumi.get(__response__, 'name'),
        tags=pulumi.get(__response__, 'tags'),
        workspace_id=pulumi.get(__response__, 'workspace_id')))
