# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetServiceResult',
    'AwaitableGetServiceResult',
    'get_service',
    'get_service_output',
]

@pulumi.output_type
class GetServiceResult:
    """
    A collection of values returned by getService.
    """
    def __init__(__self__, access_policy_object_ids=None, authentication_configurations=None, cors_configurations=None, cosmosdb_key_vault_key_versionless_id=None, cosmosdb_throughput=None, id=None, kind=None, location=None, name=None, resource_group_name=None, tags=None):
        if access_policy_object_ids and not isinstance(access_policy_object_ids, list):
            raise TypeError("Expected argument 'access_policy_object_ids' to be a list")
        pulumi.set(__self__, "access_policy_object_ids", access_policy_object_ids)
        if authentication_configurations and not isinstance(authentication_configurations, list):
            raise TypeError("Expected argument 'authentication_configurations' to be a list")
        pulumi.set(__self__, "authentication_configurations", authentication_configurations)
        if cors_configurations and not isinstance(cors_configurations, list):
            raise TypeError("Expected argument 'cors_configurations' to be a list")
        pulumi.set(__self__, "cors_configurations", cors_configurations)
        if cosmosdb_key_vault_key_versionless_id and not isinstance(cosmosdb_key_vault_key_versionless_id, str):
            raise TypeError("Expected argument 'cosmosdb_key_vault_key_versionless_id' to be a str")
        pulumi.set(__self__, "cosmosdb_key_vault_key_versionless_id", cosmosdb_key_vault_key_versionless_id)
        if cosmosdb_throughput and not isinstance(cosmosdb_throughput, int):
            raise TypeError("Expected argument 'cosmosdb_throughput' to be a int")
        pulumi.set(__self__, "cosmosdb_throughput", cosmosdb_throughput)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if kind and not isinstance(kind, str):
            raise TypeError("Expected argument 'kind' to be a str")
        pulumi.set(__self__, "kind", kind)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="accessPolicyObjectIds")
    def access_policy_object_ids(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "access_policy_object_ids")

    @property
    @pulumi.getter(name="authenticationConfigurations")
    def authentication_configurations(self) -> Sequence['outputs.GetServiceAuthenticationConfigurationResult']:
        """
        An `authentication_configuration` block as defined below.
        """
        return pulumi.get(self, "authentication_configurations")

    @property
    @pulumi.getter(name="corsConfigurations")
    def cors_configurations(self) -> Sequence['outputs.GetServiceCorsConfigurationResult']:
        """
        A `cors_configuration` block as defined below.
        """
        return pulumi.get(self, "cors_configurations")

    @property
    @pulumi.getter(name="cosmosdbKeyVaultKeyVersionlessId")
    def cosmosdb_key_vault_key_versionless_id(self) -> builtins.str:
        """
        The versionless Key Vault Key ID for CMK encryption of the backing database.
        """
        return pulumi.get(self, "cosmosdb_key_vault_key_versionless_id")

    @property
    @pulumi.getter(name="cosmosdbThroughput")
    def cosmosdb_throughput(self) -> builtins.int:
        """
        The provisioned throughput for the backing database.
        """
        return pulumi.get(self, "cosmosdb_throughput")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def kind(self) -> builtins.str:
        """
        The type of the service.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def location(self) -> builtins.str:
        """
        The Azure Region where the Service is located.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> builtins.str:
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, builtins.str]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")


class AwaitableGetServiceResult(GetServiceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetServiceResult(
            access_policy_object_ids=self.access_policy_object_ids,
            authentication_configurations=self.authentication_configurations,
            cors_configurations=self.cors_configurations,
            cosmosdb_key_vault_key_versionless_id=self.cosmosdb_key_vault_key_versionless_id,
            cosmosdb_throughput=self.cosmosdb_throughput,
            id=self.id,
            kind=self.kind,
            location=self.location,
            name=self.name,
            resource_group_name=self.resource_group_name,
            tags=self.tags)


def get_service(location: Optional[builtins.str] = None,
                name: Optional[builtins.str] = None,
                resource_group_name: Optional[builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetServiceResult:
    """
    Use this data source to access information about an existing Healthcare Service

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.healthcare.get_service(name="example-healthcare_service",
        resource_group_name="example-resources",
        location="westus2")
    pulumi.export("healthcareServiceId", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.HealthcareApis`: 2022-12-01


    :param builtins.str location: The Azure Region where the Service is located.
    :param builtins.str name: Specifies the name of the Healthcare Service.
    :param builtins.str resource_group_name: The name of the Resource Group in which the Healthcare Service exists.
    """
    __args__ = dict()
    __args__['location'] = location
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:healthcare/getService:getService', __args__, opts=opts, typ=GetServiceResult).value

    return AwaitableGetServiceResult(
        access_policy_object_ids=pulumi.get(__ret__, 'access_policy_object_ids'),
        authentication_configurations=pulumi.get(__ret__, 'authentication_configurations'),
        cors_configurations=pulumi.get(__ret__, 'cors_configurations'),
        cosmosdb_key_vault_key_versionless_id=pulumi.get(__ret__, 'cosmosdb_key_vault_key_versionless_id'),
        cosmosdb_throughput=pulumi.get(__ret__, 'cosmosdb_throughput'),
        id=pulumi.get(__ret__, 'id'),
        kind=pulumi.get(__ret__, 'kind'),
        location=pulumi.get(__ret__, 'location'),
        name=pulumi.get(__ret__, 'name'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'),
        tags=pulumi.get(__ret__, 'tags'))
def get_service_output(location: Optional[pulumi.Input[builtins.str]] = None,
                       name: Optional[pulumi.Input[builtins.str]] = None,
                       resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetServiceResult]:
    """
    Use this data source to access information about an existing Healthcare Service

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.healthcare.get_service(name="example-healthcare_service",
        resource_group_name="example-resources",
        location="westus2")
    pulumi.export("healthcareServiceId", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.HealthcareApis`: 2022-12-01


    :param builtins.str location: The Azure Region where the Service is located.
    :param builtins.str name: Specifies the name of the Healthcare Service.
    :param builtins.str resource_group_name: The name of the Resource Group in which the Healthcare Service exists.
    """
    __args__ = dict()
    __args__['location'] = location
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:healthcare/getService:getService', __args__, opts=opts, typ=GetServiceResult)
    return __ret__.apply(lambda __response__: GetServiceResult(
        access_policy_object_ids=pulumi.get(__response__, 'access_policy_object_ids'),
        authentication_configurations=pulumi.get(__response__, 'authentication_configurations'),
        cors_configurations=pulumi.get(__response__, 'cors_configurations'),
        cosmosdb_key_vault_key_versionless_id=pulumi.get(__response__, 'cosmosdb_key_vault_key_versionless_id'),
        cosmosdb_throughput=pulumi.get(__response__, 'cosmosdb_throughput'),
        id=pulumi.get(__response__, 'id'),
        kind=pulumi.get(__response__, 'kind'),
        location=pulumi.get(__response__, 'location'),
        name=pulumi.get(__response__, 'name'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name'),
        tags=pulumi.get(__response__, 'tags')))
