# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'DicomServiceAuthentication',
    'DicomServiceCors',
    'DicomServiceIdentity',
    'DicomServicePrivateEndpoint',
    'DicomServiceStorage',
    'FhirServiceAuthentication',
    'FhirServiceCors',
    'FhirServiceIdentity',
    'FhirServiceOciArtifact',
    'MedtechServiceIdentity',
    'ServiceAuthenticationConfiguration',
    'ServiceCorsConfiguration',
    'ServiceIdentity',
    'WorkspacePrivateEndpointConnection',
    'GetDicomServiceAuthenticationResult',
    'GetDicomServiceCorResult',
    'GetDicomServiceIdentityResult',
    'GetDicomServicePrivateEndpointResult',
    'GetDicomServiceStorageResult',
    'GetFhirServiceAuthenticationResult',
    'GetFhirServiceCorResult',
    'GetFhirServiceIdentityResult',
    'GetMedtechServiceIdentityResult',
    'GetServiceAuthenticationConfigurationResult',
    'GetServiceCorsConfigurationResult',
]

@pulumi.output_type
class DicomServiceAuthentication(dict):
    def __init__(__self__, *,
                 audiences: Optional[Sequence[builtins.str]] = None,
                 authority: Optional[builtins.str] = None):
        """
        :param Sequence[builtins.str] audiences: The intended audience to receive authentication tokens for the service. The default value is <https://dicom.azurehealthcareapis.azure.com>
        """
        if audiences is not None:
            pulumi.set(__self__, "audiences", audiences)
        if authority is not None:
            pulumi.set(__self__, "authority", authority)

    @property
    @pulumi.getter
    def audiences(self) -> Optional[Sequence[builtins.str]]:
        """
        The intended audience to receive authentication tokens for the service. The default value is <https://dicom.azurehealthcareapis.azure.com>
        """
        return pulumi.get(self, "audiences")

    @property
    @pulumi.getter
    def authority(self) -> Optional[builtins.str]:
        return pulumi.get(self, "authority")


@pulumi.output_type
class DicomServiceCors(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowCredentials":
            suggest = "allow_credentials"
        elif key == "allowedHeaders":
            suggest = "allowed_headers"
        elif key == "allowedMethods":
            suggest = "allowed_methods"
        elif key == "allowedOrigins":
            suggest = "allowed_origins"
        elif key == "maxAgeInSeconds":
            suggest = "max_age_in_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DicomServiceCors. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DicomServiceCors.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DicomServiceCors.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_credentials: Optional[builtins.bool] = None,
                 allowed_headers: Optional[Sequence[builtins.str]] = None,
                 allowed_methods: Optional[Sequence[builtins.str]] = None,
                 allowed_origins: Optional[Sequence[builtins.str]] = None,
                 max_age_in_seconds: Optional[builtins.int] = None):
        """
        :param builtins.bool allow_credentials: Whether to allow credentials in CORS. Defaults to `false`.
        :param Sequence[builtins.str] allowed_headers: A list of allowed headers for CORS.
        :param Sequence[builtins.str] allowed_methods: A list of allowed methods for CORS.
        :param Sequence[builtins.str] allowed_origins: A list of allowed origins for CORS.
        :param builtins.int max_age_in_seconds: The maximum age in seconds for the CORS configuration (must be between 0 and 99998 inclusive).
        """
        if allow_credentials is not None:
            pulumi.set(__self__, "allow_credentials", allow_credentials)
        if allowed_headers is not None:
            pulumi.set(__self__, "allowed_headers", allowed_headers)
        if allowed_methods is not None:
            pulumi.set(__self__, "allowed_methods", allowed_methods)
        if allowed_origins is not None:
            pulumi.set(__self__, "allowed_origins", allowed_origins)
        if max_age_in_seconds is not None:
            pulumi.set(__self__, "max_age_in_seconds", max_age_in_seconds)

    @property
    @pulumi.getter(name="allowCredentials")
    def allow_credentials(self) -> Optional[builtins.bool]:
        """
        Whether to allow credentials in CORS. Defaults to `false`.
        """
        return pulumi.get(self, "allow_credentials")

    @property
    @pulumi.getter(name="allowedHeaders")
    def allowed_headers(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of allowed headers for CORS.
        """
        return pulumi.get(self, "allowed_headers")

    @property
    @pulumi.getter(name="allowedMethods")
    def allowed_methods(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of allowed methods for CORS.
        """
        return pulumi.get(self, "allowed_methods")

    @property
    @pulumi.getter(name="allowedOrigins")
    def allowed_origins(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of allowed origins for CORS.
        """
        return pulumi.get(self, "allowed_origins")

    @property
    @pulumi.getter(name="maxAgeInSeconds")
    def max_age_in_seconds(self) -> Optional[builtins.int]:
        """
        The maximum age in seconds for the CORS configuration (must be between 0 and 99998 inclusive).
        """
        return pulumi.get(self, "max_age_in_seconds")


@pulumi.output_type
class DicomServiceIdentity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "identityIds":
            suggest = "identity_ids"
        elif key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DicomServiceIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DicomServiceIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DicomServiceIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: builtins.str,
                 identity_ids: Optional[Sequence[builtins.str]] = None,
                 principal_id: Optional[builtins.str] = None,
                 tenant_id: Optional[builtins.str] = None):
        """
        :param builtins.str type: The type of identity used for the Healthcare DICOM service. Possible values are `UserAssigned`, `SystemAssigned` and `SystemAssigned, UserAssigned`. If `UserAssigned` is set, an `identity_ids` must be set as well.
        :param Sequence[builtins.str] identity_ids: A list of User Assigned Identity IDs which should be assigned to this Healthcare DICOM service.
        """
        pulumi.set(__self__, "type", type)
        if identity_ids is not None:
            pulumi.set(__self__, "identity_ids", identity_ids)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The type of identity used for the Healthcare DICOM service. Possible values are `UserAssigned`, `SystemAssigned` and `SystemAssigned, UserAssigned`. If `UserAssigned` is set, an `identity_ids` must be set as well.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of User Assigned Identity IDs which should be assigned to this Healthcare DICOM service.
        """
        return pulumi.get(self, "identity_ids")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class DicomServicePrivateEndpoint(dict):
    def __init__(__self__, *,
                 id: Optional[builtins.str] = None,
                 name: Optional[builtins.str] = None):
        """
        :param builtins.str id: The ID of the Healthcare DICOM Service.
        :param builtins.str name: Specifies the name of the Healthcare DICOM Service. Changing this forces a new Healthcare DICOM Service to be created.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The ID of the Healthcare DICOM Service.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        Specifies the name of the Healthcare DICOM Service. Changing this forces a new Healthcare DICOM Service to be created.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class DicomServiceStorage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fileSystemName":
            suggest = "file_system_name"
        elif key == "storageAccountId":
            suggest = "storage_account_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DicomServiceStorage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DicomServiceStorage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DicomServiceStorage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 file_system_name: builtins.str,
                 storage_account_id: builtins.str):
        """
        :param builtins.str file_system_name: The filesystem name of connected storage account. Changing this forces a new Healthcare DICOM Service to be created.
        :param builtins.str storage_account_id: The resource ID of connected storage account. Changing this forces a new Healthcare DICOM Service to be created.
               
               > **Note:** The `is_hns_enabled` needs to be set to `true` for the storage account to be used with the Healthcare DICOM Service.
        """
        pulumi.set(__self__, "file_system_name", file_system_name)
        pulumi.set(__self__, "storage_account_id", storage_account_id)

    @property
    @pulumi.getter(name="fileSystemName")
    def file_system_name(self) -> builtins.str:
        """
        The filesystem name of connected storage account. Changing this forces a new Healthcare DICOM Service to be created.
        """
        return pulumi.get(self, "file_system_name")

    @property
    @pulumi.getter(name="storageAccountId")
    def storage_account_id(self) -> builtins.str:
        """
        The resource ID of connected storage account. Changing this forces a new Healthcare DICOM Service to be created.

        > **Note:** The `is_hns_enabled` needs to be set to `true` for the storage account to be used with the Healthcare DICOM Service.
        """
        return pulumi.get(self, "storage_account_id")


@pulumi.output_type
class FhirServiceAuthentication(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "smartProxyEnabled":
            suggest = "smart_proxy_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FhirServiceAuthentication. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FhirServiceAuthentication.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FhirServiceAuthentication.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 audience: builtins.str,
                 authority: builtins.str,
                 smart_proxy_enabled: Optional[builtins.bool] = None):
        """
        :param builtins.str audience: The intended audience to receive authentication tokens for the service.
        :param builtins.bool smart_proxy_enabled: Whether smart proxy is enabled.
        """
        pulumi.set(__self__, "audience", audience)
        pulumi.set(__self__, "authority", authority)
        if smart_proxy_enabled is not None:
            pulumi.set(__self__, "smart_proxy_enabled", smart_proxy_enabled)

    @property
    @pulumi.getter
    def audience(self) -> builtins.str:
        """
        The intended audience to receive authentication tokens for the service.
        """
        return pulumi.get(self, "audience")

    @property
    @pulumi.getter
    def authority(self) -> builtins.str:
        return pulumi.get(self, "authority")

    @property
    @pulumi.getter(name="smartProxyEnabled")
    def smart_proxy_enabled(self) -> Optional[builtins.bool]:
        """
        Whether smart proxy is enabled.
        """
        return pulumi.get(self, "smart_proxy_enabled")


@pulumi.output_type
class FhirServiceCors(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedHeaders":
            suggest = "allowed_headers"
        elif key == "allowedMethods":
            suggest = "allowed_methods"
        elif key == "allowedOrigins":
            suggest = "allowed_origins"
        elif key == "credentialsAllowed":
            suggest = "credentials_allowed"
        elif key == "maxAgeInSeconds":
            suggest = "max_age_in_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FhirServiceCors. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FhirServiceCors.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FhirServiceCors.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_headers: Sequence[builtins.str],
                 allowed_methods: Sequence[builtins.str],
                 allowed_origins: Sequence[builtins.str],
                 credentials_allowed: Optional[builtins.bool] = None,
                 max_age_in_seconds: Optional[builtins.int] = None):
        """
        :param Sequence[builtins.str] allowed_headers: A set of headers to be allowed via CORS.
        :param Sequence[builtins.str] allowed_methods: The methods to be allowed via CORS. Possible values are `DELETE`, `GET`, `HEAD`, `MERGE`, `POST`, `OPTIONS`, `PATCH` and `PUT`.
        :param Sequence[builtins.str] allowed_origins: A set of origins to be allowed via CORS.
        :param builtins.bool credentials_allowed: If credentials are allowed via CORS.
        :param builtins.int max_age_in_seconds: The max age to be allowed via CORS.
        """
        pulumi.set(__self__, "allowed_headers", allowed_headers)
        pulumi.set(__self__, "allowed_methods", allowed_methods)
        pulumi.set(__self__, "allowed_origins", allowed_origins)
        if credentials_allowed is not None:
            pulumi.set(__self__, "credentials_allowed", credentials_allowed)
        if max_age_in_seconds is not None:
            pulumi.set(__self__, "max_age_in_seconds", max_age_in_seconds)

    @property
    @pulumi.getter(name="allowedHeaders")
    def allowed_headers(self) -> Sequence[builtins.str]:
        """
        A set of headers to be allowed via CORS.
        """
        return pulumi.get(self, "allowed_headers")

    @property
    @pulumi.getter(name="allowedMethods")
    def allowed_methods(self) -> Sequence[builtins.str]:
        """
        The methods to be allowed via CORS. Possible values are `DELETE`, `GET`, `HEAD`, `MERGE`, `POST`, `OPTIONS`, `PATCH` and `PUT`.
        """
        return pulumi.get(self, "allowed_methods")

    @property
    @pulumi.getter(name="allowedOrigins")
    def allowed_origins(self) -> Sequence[builtins.str]:
        """
        A set of origins to be allowed via CORS.
        """
        return pulumi.get(self, "allowed_origins")

    @property
    @pulumi.getter(name="credentialsAllowed")
    def credentials_allowed(self) -> Optional[builtins.bool]:
        """
        If credentials are allowed via CORS.
        """
        return pulumi.get(self, "credentials_allowed")

    @property
    @pulumi.getter(name="maxAgeInSeconds")
    def max_age_in_seconds(self) -> Optional[builtins.int]:
        """
        The max age to be allowed via CORS.
        """
        return pulumi.get(self, "max_age_in_seconds")


@pulumi.output_type
class FhirServiceIdentity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "identityIds":
            suggest = "identity_ids"
        elif key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FhirServiceIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FhirServiceIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FhirServiceIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: builtins.str,
                 identity_ids: Optional[Sequence[builtins.str]] = None,
                 principal_id: Optional[builtins.str] = None,
                 tenant_id: Optional[builtins.str] = None):
        """
        :param builtins.str type: The type of managed identity to assign. Possible values are `UserAssigned` and `SystemAssigned`.
        :param Sequence[builtins.str] identity_ids: A list of one or more Resource IDs for User Assigned Managed identities to assign. Required when `type` is set to `UserAssigned`.
        """
        pulumi.set(__self__, "type", type)
        if identity_ids is not None:
            pulumi.set(__self__, "identity_ids", identity_ids)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The type of managed identity to assign. Possible values are `UserAssigned` and `SystemAssigned`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of one or more Resource IDs for User Assigned Managed identities to assign. Required when `type` is set to `UserAssigned`.
        """
        return pulumi.get(self, "identity_ids")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class FhirServiceOciArtifact(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "loginServer":
            suggest = "login_server"
        elif key == "imageName":
            suggest = "image_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FhirServiceOciArtifact. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FhirServiceOciArtifact.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FhirServiceOciArtifact.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 login_server: builtins.str,
                 digest: Optional[builtins.str] = None,
                 image_name: Optional[builtins.str] = None):
        """
        :param builtins.str login_server: An Azure container registry used for export operations of the service instance.
        :param builtins.str digest: A digest of an image within Azure container registry used for export operations of the service instance to narrow the artifacts down.
        :param builtins.str image_name: An image within Azure container registry used for export operations of the service instance.
        """
        pulumi.set(__self__, "login_server", login_server)
        if digest is not None:
            pulumi.set(__self__, "digest", digest)
        if image_name is not None:
            pulumi.set(__self__, "image_name", image_name)

    @property
    @pulumi.getter(name="loginServer")
    def login_server(self) -> builtins.str:
        """
        An Azure container registry used for export operations of the service instance.
        """
        return pulumi.get(self, "login_server")

    @property
    @pulumi.getter
    def digest(self) -> Optional[builtins.str]:
        """
        A digest of an image within Azure container registry used for export operations of the service instance to narrow the artifacts down.
        """
        return pulumi.get(self, "digest")

    @property
    @pulumi.getter(name="imageName")
    def image_name(self) -> Optional[builtins.str]:
        """
        An image within Azure container registry used for export operations of the service instance.
        """
        return pulumi.get(self, "image_name")


@pulumi.output_type
class MedtechServiceIdentity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "identityIds":
            suggest = "identity_ids"
        elif key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MedtechServiceIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MedtechServiceIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MedtechServiceIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: builtins.str,
                 identity_ids: Optional[Sequence[builtins.str]] = None,
                 principal_id: Optional[builtins.str] = None,
                 tenant_id: Optional[builtins.str] = None):
        """
        :param builtins.str type: Specifies the type of Managed Service Identity that should be configured on this Healthcare Med Tech Service. Possible values are `SystemAssigned`.
        :param Sequence[builtins.str] identity_ids: Specifies a list of User Assigned Managed Identity IDs to be assigned to this Healthcare Med Tech Service.
        :param builtins.str principal_id: The Principal ID associated with this System Assigned Managed Service Identity.
        :param builtins.str tenant_id: The Tenant ID associated with this System Assigned Managed Service Identity.
        """
        pulumi.set(__self__, "type", type)
        if identity_ids is not None:
            pulumi.set(__self__, "identity_ids", identity_ids)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Specifies the type of Managed Service Identity that should be configured on this Healthcare Med Tech Service. Possible values are `SystemAssigned`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        Specifies a list of User Assigned Managed Identity IDs to be assigned to this Healthcare Med Tech Service.
        """
        return pulumi.get(self, "identity_ids")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[builtins.str]:
        """
        The Principal ID associated with this System Assigned Managed Service Identity.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[builtins.str]:
        """
        The Tenant ID associated with this System Assigned Managed Service Identity.
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class ServiceAuthenticationConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "smartProxyEnabled":
            suggest = "smart_proxy_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceAuthenticationConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceAuthenticationConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceAuthenticationConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 audience: Optional[builtins.str] = None,
                 authority: Optional[builtins.str] = None,
                 smart_proxy_enabled: Optional[builtins.bool] = None):
        """
        :param builtins.str audience: The intended audience to receive authentication tokens for the service. The default value is https://azurehealthcareapis.com
        :param builtins.str authority: The Azure Active Directory (tenant) that serves as the authentication authority to access the service. The default authority is the Directory defined in the authentication scheme in use when running this provider.
               Authority must be registered to Azure AD and in the following format: https://{Azure-AD-endpoint}/{tenant-id}.
        :param builtins.bool smart_proxy_enabled: (Boolean) Enables the 'SMART on FHIR' option for mobile and web implementations.
        """
        if audience is not None:
            pulumi.set(__self__, "audience", audience)
        if authority is not None:
            pulumi.set(__self__, "authority", authority)
        if smart_proxy_enabled is not None:
            pulumi.set(__self__, "smart_proxy_enabled", smart_proxy_enabled)

    @property
    @pulumi.getter
    def audience(self) -> Optional[builtins.str]:
        """
        The intended audience to receive authentication tokens for the service. The default value is https://azurehealthcareapis.com
        """
        return pulumi.get(self, "audience")

    @property
    @pulumi.getter
    def authority(self) -> Optional[builtins.str]:
        """
        The Azure Active Directory (tenant) that serves as the authentication authority to access the service. The default authority is the Directory defined in the authentication scheme in use when running this provider.
        Authority must be registered to Azure AD and in the following format: https://{Azure-AD-endpoint}/{tenant-id}.
        """
        return pulumi.get(self, "authority")

    @property
    @pulumi.getter(name="smartProxyEnabled")
    def smart_proxy_enabled(self) -> Optional[builtins.bool]:
        """
        (Boolean) Enables the 'SMART on FHIR' option for mobile and web implementations.
        """
        return pulumi.get(self, "smart_proxy_enabled")


@pulumi.output_type
class ServiceCorsConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowCredentials":
            suggest = "allow_credentials"
        elif key == "allowedHeaders":
            suggest = "allowed_headers"
        elif key == "allowedMethods":
            suggest = "allowed_methods"
        elif key == "allowedOrigins":
            suggest = "allowed_origins"
        elif key == "maxAgeInSeconds":
            suggest = "max_age_in_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceCorsConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceCorsConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceCorsConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_credentials: Optional[builtins.bool] = None,
                 allowed_headers: Optional[Sequence[builtins.str]] = None,
                 allowed_methods: Optional[Sequence[builtins.str]] = None,
                 allowed_origins: Optional[Sequence[builtins.str]] = None,
                 max_age_in_seconds: Optional[builtins.int] = None):
        """
        :param builtins.bool allow_credentials: (Boolean) If credentials are allowed via CORS.
        :param Sequence[builtins.str] allowed_headers: A set of headers to be allowed via CORS.
        :param Sequence[builtins.str] allowed_methods: The methods to be allowed via CORS. Possible values are `DELETE`, `GET`, `HEAD`, `MERGE`, `POST`, `OPTIONS`, `PATCH` and `PUT`.
        :param Sequence[builtins.str] allowed_origins: A set of origins to be allowed via CORS.
        :param builtins.int max_age_in_seconds: The max age to be allowed via CORS.
        """
        if allow_credentials is not None:
            pulumi.set(__self__, "allow_credentials", allow_credentials)
        if allowed_headers is not None:
            pulumi.set(__self__, "allowed_headers", allowed_headers)
        if allowed_methods is not None:
            pulumi.set(__self__, "allowed_methods", allowed_methods)
        if allowed_origins is not None:
            pulumi.set(__self__, "allowed_origins", allowed_origins)
        if max_age_in_seconds is not None:
            pulumi.set(__self__, "max_age_in_seconds", max_age_in_seconds)

    @property
    @pulumi.getter(name="allowCredentials")
    def allow_credentials(self) -> Optional[builtins.bool]:
        """
        (Boolean) If credentials are allowed via CORS.
        """
        return pulumi.get(self, "allow_credentials")

    @property
    @pulumi.getter(name="allowedHeaders")
    def allowed_headers(self) -> Optional[Sequence[builtins.str]]:
        """
        A set of headers to be allowed via CORS.
        """
        return pulumi.get(self, "allowed_headers")

    @property
    @pulumi.getter(name="allowedMethods")
    def allowed_methods(self) -> Optional[Sequence[builtins.str]]:
        """
        The methods to be allowed via CORS. Possible values are `DELETE`, `GET`, `HEAD`, `MERGE`, `POST`, `OPTIONS`, `PATCH` and `PUT`.
        """
        return pulumi.get(self, "allowed_methods")

    @property
    @pulumi.getter(name="allowedOrigins")
    def allowed_origins(self) -> Optional[Sequence[builtins.str]]:
        """
        A set of origins to be allowed via CORS.
        """
        return pulumi.get(self, "allowed_origins")

    @property
    @pulumi.getter(name="maxAgeInSeconds")
    def max_age_in_seconds(self) -> Optional[builtins.int]:
        """
        The max age to be allowed via CORS.
        """
        return pulumi.get(self, "max_age_in_seconds")


@pulumi.output_type
class ServiceIdentity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: builtins.str,
                 principal_id: Optional[builtins.str] = None,
                 tenant_id: Optional[builtins.str] = None):
        """
        :param builtins.str type: The type of managed identity to assign. The only possible value is `SystemAssigned`.
        """
        pulumi.set(__self__, "type", type)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The type of managed identity to assign. The only possible value is `SystemAssigned`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class WorkspacePrivateEndpointConnection(dict):
    def __init__(__self__, *,
                 id: Optional[builtins.str] = None,
                 name: Optional[builtins.str] = None):
        """
        :param builtins.str id: The ID of the Healthcare Workspace.
        :param builtins.str name: Specifies the name of the Healthcare Workspace. Changing this forces a new Healthcare Workspace to be created.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The ID of the Healthcare Workspace.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        Specifies the name of the Healthcare Workspace. Changing this forces a new Healthcare Workspace to be created.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetDicomServiceAuthenticationResult(dict):
    def __init__(__self__, *,
                 audiences: Sequence[builtins.str],
                 authority: builtins.str):
        """
        :param Sequence[builtins.str] audiences: The intended audience to receive authentication tokens for the service. The default value is <https://dicom.azurehealthcareapis.azure.com>
        """
        pulumi.set(__self__, "audiences", audiences)
        pulumi.set(__self__, "authority", authority)

    @property
    @pulumi.getter
    def audiences(self) -> Sequence[builtins.str]:
        """
        The intended audience to receive authentication tokens for the service. The default value is <https://dicom.azurehealthcareapis.azure.com>
        """
        return pulumi.get(self, "audiences")

    @property
    @pulumi.getter
    def authority(self) -> builtins.str:
        return pulumi.get(self, "authority")


@pulumi.output_type
class GetDicomServiceCorResult(dict):
    def __init__(__self__, *,
                 allow_credentials: builtins.bool,
                 allowed_headers: Sequence[builtins.str],
                 allowed_methods: Sequence[builtins.str],
                 allowed_origins: Sequence[builtins.str],
                 max_age_in_seconds: builtins.int):
        """
        :param builtins.bool allow_credentials: Whether to allow credentials in CORS.
        :param Sequence[builtins.str] allowed_headers: A list of allowed headers for CORS.
        :param Sequence[builtins.str] allowed_methods: A list of allowed methods for CORS.
        :param Sequence[builtins.str] allowed_origins: A list of allowed origins for CORS.
        :param builtins.int max_age_in_seconds: The maximum age in seconds for the CORS configuration.
        """
        pulumi.set(__self__, "allow_credentials", allow_credentials)
        pulumi.set(__self__, "allowed_headers", allowed_headers)
        pulumi.set(__self__, "allowed_methods", allowed_methods)
        pulumi.set(__self__, "allowed_origins", allowed_origins)
        pulumi.set(__self__, "max_age_in_seconds", max_age_in_seconds)

    @property
    @pulumi.getter(name="allowCredentials")
    def allow_credentials(self) -> builtins.bool:
        """
        Whether to allow credentials in CORS.
        """
        return pulumi.get(self, "allow_credentials")

    @property
    @pulumi.getter(name="allowedHeaders")
    def allowed_headers(self) -> Sequence[builtins.str]:
        """
        A list of allowed headers for CORS.
        """
        return pulumi.get(self, "allowed_headers")

    @property
    @pulumi.getter(name="allowedMethods")
    def allowed_methods(self) -> Sequence[builtins.str]:
        """
        A list of allowed methods for CORS.
        """
        return pulumi.get(self, "allowed_methods")

    @property
    @pulumi.getter(name="allowedOrigins")
    def allowed_origins(self) -> Sequence[builtins.str]:
        """
        A list of allowed origins for CORS.
        """
        return pulumi.get(self, "allowed_origins")

    @property
    @pulumi.getter(name="maxAgeInSeconds")
    def max_age_in_seconds(self) -> builtins.int:
        """
        The maximum age in seconds for the CORS configuration.
        """
        return pulumi.get(self, "max_age_in_seconds")


@pulumi.output_type
class GetDicomServiceIdentityResult(dict):
    def __init__(__self__, *,
                 identity_ids: Sequence[builtins.str],
                 principal_id: builtins.str,
                 tenant_id: builtins.str,
                 type: builtins.str):
        pulumi.set(__self__, "identity_ids", identity_ids)
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "identity_ids")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> builtins.str:
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> builtins.str:
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        return pulumi.get(self, "type")


@pulumi.output_type
class GetDicomServicePrivateEndpointResult(dict):
    def __init__(__self__, *,
                 id: builtins.str,
                 name: builtins.str):
        """
        :param builtins.str id: The ID of the Healthcare DICOM Service.
        :param builtins.str name: The name of the Healthcare DICOM Service
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The ID of the Healthcare DICOM Service.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the Healthcare DICOM Service
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetDicomServiceStorageResult(dict):
    def __init__(__self__, *,
                 file_system_name: builtins.str,
                 storage_account_id: builtins.str):
        """
        :param builtins.str file_system_name: The filesystem name of connected storage account.
        :param builtins.str storage_account_id: The resource ID of connected storage account.
        """
        pulumi.set(__self__, "file_system_name", file_system_name)
        pulumi.set(__self__, "storage_account_id", storage_account_id)

    @property
    @pulumi.getter(name="fileSystemName")
    def file_system_name(self) -> builtins.str:
        """
        The filesystem name of connected storage account.
        """
        return pulumi.get(self, "file_system_name")

    @property
    @pulumi.getter(name="storageAccountId")
    def storage_account_id(self) -> builtins.str:
        """
        The resource ID of connected storage account.
        """
        return pulumi.get(self, "storage_account_id")


@pulumi.output_type
class GetFhirServiceAuthenticationResult(dict):
    def __init__(__self__, *,
                 audience: builtins.str,
                 authority: builtins.str,
                 smart_proxy_enabled: builtins.bool):
        """
        :param builtins.str audience: The intended audience to receive authentication tokens for the service. The default value is `https://<name>.fhir.azurehealthcareapis.com`.
        """
        pulumi.set(__self__, "audience", audience)
        pulumi.set(__self__, "authority", authority)
        pulumi.set(__self__, "smart_proxy_enabled", smart_proxy_enabled)

    @property
    @pulumi.getter
    def audience(self) -> builtins.str:
        """
        The intended audience to receive authentication tokens for the service. The default value is `https://<name>.fhir.azurehealthcareapis.com`.
        """
        return pulumi.get(self, "audience")

    @property
    @pulumi.getter
    def authority(self) -> builtins.str:
        return pulumi.get(self, "authority")

    @property
    @pulumi.getter(name="smartProxyEnabled")
    def smart_proxy_enabled(self) -> builtins.bool:
        return pulumi.get(self, "smart_proxy_enabled")


@pulumi.output_type
class GetFhirServiceCorResult(dict):
    def __init__(__self__, *,
                 allowed_headers: Sequence[builtins.str],
                 allowed_methods: Sequence[builtins.str],
                 allowed_origins: Sequence[builtins.str],
                 credentials_allowed: builtins.bool,
                 max_age_in_seconds: builtins.int):
        """
        :param Sequence[builtins.str] allowed_headers: The set of headers to be allowed via CORS.
        :param Sequence[builtins.str] allowed_methods: The methods to be allowed via CORS.
        :param Sequence[builtins.str] allowed_origins: The set of origins to be allowed via CORS.
        :param builtins.bool credentials_allowed: Are credentials allowed via CORS?
        :param builtins.int max_age_in_seconds: The max age to be allowed via CORS.
        """
        pulumi.set(__self__, "allowed_headers", allowed_headers)
        pulumi.set(__self__, "allowed_methods", allowed_methods)
        pulumi.set(__self__, "allowed_origins", allowed_origins)
        pulumi.set(__self__, "credentials_allowed", credentials_allowed)
        pulumi.set(__self__, "max_age_in_seconds", max_age_in_seconds)

    @property
    @pulumi.getter(name="allowedHeaders")
    def allowed_headers(self) -> Sequence[builtins.str]:
        """
        The set of headers to be allowed via CORS.
        """
        return pulumi.get(self, "allowed_headers")

    @property
    @pulumi.getter(name="allowedMethods")
    def allowed_methods(self) -> Sequence[builtins.str]:
        """
        The methods to be allowed via CORS.
        """
        return pulumi.get(self, "allowed_methods")

    @property
    @pulumi.getter(name="allowedOrigins")
    def allowed_origins(self) -> Sequence[builtins.str]:
        """
        The set of origins to be allowed via CORS.
        """
        return pulumi.get(self, "allowed_origins")

    @property
    @pulumi.getter(name="credentialsAllowed")
    def credentials_allowed(self) -> builtins.bool:
        """
        Are credentials allowed via CORS?
        """
        return pulumi.get(self, "credentials_allowed")

    @property
    @pulumi.getter(name="maxAgeInSeconds")
    def max_age_in_seconds(self) -> builtins.int:
        """
        The max age to be allowed via CORS.
        """
        return pulumi.get(self, "max_age_in_seconds")


@pulumi.output_type
class GetFhirServiceIdentityResult(dict):
    def __init__(__self__, *,
                 identity_ids: Sequence[builtins.str],
                 principal_id: builtins.str,
                 tenant_id: builtins.str,
                 type: builtins.str):
        """
        :param builtins.str principal_id: The Principal ID associated with this System Assigned Managed Service Identity.
        :param builtins.str tenant_id: The Tenant ID associated with this System Assigned Managed Service Identity.
        :param builtins.str type: The type of identity used for the Healthcare FHIR service.
        """
        pulumi.set(__self__, "identity_ids", identity_ids)
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "identity_ids")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> builtins.str:
        """
        The Principal ID associated with this System Assigned Managed Service Identity.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> builtins.str:
        """
        The Tenant ID associated with this System Assigned Managed Service Identity.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The type of identity used for the Healthcare FHIR service.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetMedtechServiceIdentityResult(dict):
    def __init__(__self__, *,
                 identity_ids: Sequence[builtins.str],
                 principal_id: builtins.str,
                 tenant_id: builtins.str,
                 type: builtins.str):
        """
        :param builtins.str principal_id: The Principal ID of the System Assigned Managed Service Identity that is configured on this Healthcare Med Tech Service.
        :param builtins.str tenant_id: The Tenant ID of the System Assigned Managed Service Identity that is configured on this Healthcare Med Tech Service.
        :param builtins.str type: The type of identity used for the Healthcare Med Tech Service. Possible values are `SystemAssigned`.
        """
        pulumi.set(__self__, "identity_ids", identity_ids)
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "identity_ids")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> builtins.str:
        """
        The Principal ID of the System Assigned Managed Service Identity that is configured on this Healthcare Med Tech Service.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> builtins.str:
        """
        The Tenant ID of the System Assigned Managed Service Identity that is configured on this Healthcare Med Tech Service.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The type of identity used for the Healthcare Med Tech Service. Possible values are `SystemAssigned`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetServiceAuthenticationConfigurationResult(dict):
    def __init__(__self__, *,
                 audience: builtins.str,
                 authority: builtins.str,
                 smart_proxy_enabled: builtins.bool):
        """
        :param builtins.str audience: The intended audience to receive authentication tokens for the service.
        :param builtins.str authority: The Azure Active Directory (tenant) that serves as the authentication authority to access the service.
        :param builtins.bool smart_proxy_enabled: Is the 'SMART on FHIR' option for mobile and web implementations enabled?
        """
        pulumi.set(__self__, "audience", audience)
        pulumi.set(__self__, "authority", authority)
        pulumi.set(__self__, "smart_proxy_enabled", smart_proxy_enabled)

    @property
    @pulumi.getter
    def audience(self) -> builtins.str:
        """
        The intended audience to receive authentication tokens for the service.
        """
        return pulumi.get(self, "audience")

    @property
    @pulumi.getter
    def authority(self) -> builtins.str:
        """
        The Azure Active Directory (tenant) that serves as the authentication authority to access the service.
        """
        return pulumi.get(self, "authority")

    @property
    @pulumi.getter(name="smartProxyEnabled")
    def smart_proxy_enabled(self) -> builtins.bool:
        """
        Is the 'SMART on FHIR' option for mobile and web implementations enabled?
        """
        return pulumi.get(self, "smart_proxy_enabled")


@pulumi.output_type
class GetServiceCorsConfigurationResult(dict):
    def __init__(__self__, *,
                 allow_credentials: builtins.bool,
                 allowed_headers: Sequence[builtins.str],
                 allowed_methods: Sequence[builtins.str],
                 allowed_origins: Sequence[builtins.str],
                 max_age_in_seconds: builtins.int):
        """
        :param builtins.bool allow_credentials: Are credentials are allowed via CORS?
        :param Sequence[builtins.str] allowed_headers: The set of headers to be allowed via CORS.
        :param Sequence[builtins.str] allowed_methods: The methods to be allowed via CORS.
        :param Sequence[builtins.str] allowed_origins: The set of origins to be allowed via CORS.
        :param builtins.int max_age_in_seconds: The max age to be allowed via CORS.
        """
        pulumi.set(__self__, "allow_credentials", allow_credentials)
        pulumi.set(__self__, "allowed_headers", allowed_headers)
        pulumi.set(__self__, "allowed_methods", allowed_methods)
        pulumi.set(__self__, "allowed_origins", allowed_origins)
        pulumi.set(__self__, "max_age_in_seconds", max_age_in_seconds)

    @property
    @pulumi.getter(name="allowCredentials")
    def allow_credentials(self) -> builtins.bool:
        """
        Are credentials are allowed via CORS?
        """
        return pulumi.get(self, "allow_credentials")

    @property
    @pulumi.getter(name="allowedHeaders")
    def allowed_headers(self) -> Sequence[builtins.str]:
        """
        The set of headers to be allowed via CORS.
        """
        return pulumi.get(self, "allowed_headers")

    @property
    @pulumi.getter(name="allowedMethods")
    def allowed_methods(self) -> Sequence[builtins.str]:
        """
        The methods to be allowed via CORS.
        """
        return pulumi.get(self, "allowed_methods")

    @property
    @pulumi.getter(name="allowedOrigins")
    def allowed_origins(self) -> Sequence[builtins.str]:
        """
        The set of origins to be allowed via CORS.
        """
        return pulumi.get(self, "allowed_origins")

    @property
    @pulumi.getter(name="maxAgeInSeconds")
    def max_age_in_seconds(self) -> builtins.int:
        """
        The max age to be allowed via CORS.
        """
        return pulumi.get(self, "max_age_in_seconds")


