# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'CacheAccessPolicyAccessRuleArgs',
    'CacheAccessPolicyAccessRuleArgsDict',
    'CacheDefaultAccessPolicyArgs',
    'CacheDefaultAccessPolicyArgsDict',
    'CacheDefaultAccessPolicyAccessRuleArgs',
    'CacheDefaultAccessPolicyAccessRuleArgsDict',
    'CacheDirectoryActiveDirectoryArgs',
    'CacheDirectoryActiveDirectoryArgsDict',
    'CacheDirectoryFlatFileArgs',
    'CacheDirectoryFlatFileArgsDict',
    'CacheDirectoryLdapArgs',
    'CacheDirectoryLdapArgsDict',
    'CacheDirectoryLdapBindArgs',
    'CacheDirectoryLdapBindArgsDict',
    'CacheDnsArgs',
    'CacheDnsArgsDict',
    'CacheIdentityArgs',
    'CacheIdentityArgsDict',
    'CacheNfsTargetNamespaceJunctionArgs',
    'CacheNfsTargetNamespaceJunctionArgsDict',
]

MYPY = False

if not MYPY:
    class CacheAccessPolicyAccessRuleArgsDict(TypedDict):
        access: pulumi.Input[builtins.str]
        """
        The access level for this rule. Possible values are: `rw`, `ro`, `no`.
        """
        scope: pulumi.Input[builtins.str]
        """
        The scope of this rule. The `scope` and (potentially) the `filter` determine which clients match the rule. Possible values are: `default`, `network`, `host`.

        > **Note:** Each `access_rule` should set a unique `scope`.
        """
        anonymous_gid: NotRequired[pulumi.Input[builtins.int]]
        """
        The anonymous GID used when `root_squash_enabled` is `true`.
        """
        anonymous_uid: NotRequired[pulumi.Input[builtins.int]]
        """
        The anonymous UID used when `root_squash_enabled` is `true`.
        """
        filter: NotRequired[pulumi.Input[builtins.str]]
        """
        The filter applied to the `scope` for this rule. The filter's format depends on its scope: `default` scope matches all clients and has no filter value; `network` scope takes a CIDR format; `host` takes an IP address or fully qualified domain name. If a client does not match any filter rule and there is no default rule, access is denied.
        """
        root_squash_enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        Whether to enable [root squash](https://docs.microsoft.com/azure/hpc-cache/access-policies#root-squash)?
        """
        submount_access_enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        Whether allow access to subdirectories under the root export?
        """
        suid_enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        Whether [SUID](https://docs.microsoft.com/azure/hpc-cache/access-policies#suid) is allowed?
        """
elif False:
    CacheAccessPolicyAccessRuleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CacheAccessPolicyAccessRuleArgs:
    def __init__(__self__, *,
                 access: pulumi.Input[builtins.str],
                 scope: pulumi.Input[builtins.str],
                 anonymous_gid: Optional[pulumi.Input[builtins.int]] = None,
                 anonymous_uid: Optional[pulumi.Input[builtins.int]] = None,
                 filter: Optional[pulumi.Input[builtins.str]] = None,
                 root_squash_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 submount_access_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 suid_enabled: Optional[pulumi.Input[builtins.bool]] = None):
        """
        :param pulumi.Input[builtins.str] access: The access level for this rule. Possible values are: `rw`, `ro`, `no`.
        :param pulumi.Input[builtins.str] scope: The scope of this rule. The `scope` and (potentially) the `filter` determine which clients match the rule. Possible values are: `default`, `network`, `host`.
               
               > **Note:** Each `access_rule` should set a unique `scope`.
        :param pulumi.Input[builtins.int] anonymous_gid: The anonymous GID used when `root_squash_enabled` is `true`.
        :param pulumi.Input[builtins.int] anonymous_uid: The anonymous UID used when `root_squash_enabled` is `true`.
        :param pulumi.Input[builtins.str] filter: The filter applied to the `scope` for this rule. The filter's format depends on its scope: `default` scope matches all clients and has no filter value; `network` scope takes a CIDR format; `host` takes an IP address or fully qualified domain name. If a client does not match any filter rule and there is no default rule, access is denied.
        :param pulumi.Input[builtins.bool] root_squash_enabled: Whether to enable [root squash](https://docs.microsoft.com/azure/hpc-cache/access-policies#root-squash)?
        :param pulumi.Input[builtins.bool] submount_access_enabled: Whether allow access to subdirectories under the root export?
        :param pulumi.Input[builtins.bool] suid_enabled: Whether [SUID](https://docs.microsoft.com/azure/hpc-cache/access-policies#suid) is allowed?
        """
        pulumi.set(__self__, "access", access)
        pulumi.set(__self__, "scope", scope)
        if anonymous_gid is not None:
            pulumi.set(__self__, "anonymous_gid", anonymous_gid)
        if anonymous_uid is not None:
            pulumi.set(__self__, "anonymous_uid", anonymous_uid)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)
        if root_squash_enabled is not None:
            pulumi.set(__self__, "root_squash_enabled", root_squash_enabled)
        if submount_access_enabled is not None:
            pulumi.set(__self__, "submount_access_enabled", submount_access_enabled)
        if suid_enabled is not None:
            pulumi.set(__self__, "suid_enabled", suid_enabled)

    @property
    @pulumi.getter
    def access(self) -> pulumi.Input[builtins.str]:
        """
        The access level for this rule. Possible values are: `rw`, `ro`, `no`.
        """
        return pulumi.get(self, "access")

    @access.setter
    def access(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "access", value)

    @property
    @pulumi.getter
    def scope(self) -> pulumi.Input[builtins.str]:
        """
        The scope of this rule. The `scope` and (potentially) the `filter` determine which clients match the rule. Possible values are: `default`, `network`, `host`.

        > **Note:** Each `access_rule` should set a unique `scope`.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "scope", value)

    @property
    @pulumi.getter(name="anonymousGid")
    def anonymous_gid(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The anonymous GID used when `root_squash_enabled` is `true`.
        """
        return pulumi.get(self, "anonymous_gid")

    @anonymous_gid.setter
    def anonymous_gid(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "anonymous_gid", value)

    @property
    @pulumi.getter(name="anonymousUid")
    def anonymous_uid(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The anonymous UID used when `root_squash_enabled` is `true`.
        """
        return pulumi.get(self, "anonymous_uid")

    @anonymous_uid.setter
    def anonymous_uid(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "anonymous_uid", value)

    @property
    @pulumi.getter
    def filter(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The filter applied to the `scope` for this rule. The filter's format depends on its scope: `default` scope matches all clients and has no filter value; `network` scope takes a CIDR format; `host` takes an IP address or fully qualified domain name. If a client does not match any filter rule and there is no default rule, access is denied.
        """
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "filter", value)

    @property
    @pulumi.getter(name="rootSquashEnabled")
    def root_squash_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to enable [root squash](https://docs.microsoft.com/azure/hpc-cache/access-policies#root-squash)?
        """
        return pulumi.get(self, "root_squash_enabled")

    @root_squash_enabled.setter
    def root_squash_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "root_squash_enabled", value)

    @property
    @pulumi.getter(name="submountAccessEnabled")
    def submount_access_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether allow access to subdirectories under the root export?
        """
        return pulumi.get(self, "submount_access_enabled")

    @submount_access_enabled.setter
    def submount_access_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "submount_access_enabled", value)

    @property
    @pulumi.getter(name="suidEnabled")
    def suid_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether [SUID](https://docs.microsoft.com/azure/hpc-cache/access-policies#suid) is allowed?
        """
        return pulumi.get(self, "suid_enabled")

    @suid_enabled.setter
    def suid_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "suid_enabled", value)


if not MYPY:
    class CacheDefaultAccessPolicyArgsDict(TypedDict):
        access_rules: pulumi.Input[Sequence[pulumi.Input['CacheDefaultAccessPolicyAccessRuleArgsDict']]]
        """
        One or more `access_rule` blocks (up to three) as defined above.
        """
elif False:
    CacheDefaultAccessPolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CacheDefaultAccessPolicyArgs:
    def __init__(__self__, *,
                 access_rules: pulumi.Input[Sequence[pulumi.Input['CacheDefaultAccessPolicyAccessRuleArgs']]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input['CacheDefaultAccessPolicyAccessRuleArgs']]] access_rules: One or more `access_rule` blocks (up to three) as defined above.
        """
        pulumi.set(__self__, "access_rules", access_rules)

    @property
    @pulumi.getter(name="accessRules")
    def access_rules(self) -> pulumi.Input[Sequence[pulumi.Input['CacheDefaultAccessPolicyAccessRuleArgs']]]:
        """
        One or more `access_rule` blocks (up to three) as defined above.
        """
        return pulumi.get(self, "access_rules")

    @access_rules.setter
    def access_rules(self, value: pulumi.Input[Sequence[pulumi.Input['CacheDefaultAccessPolicyAccessRuleArgs']]]):
        pulumi.set(self, "access_rules", value)


if not MYPY:
    class CacheDefaultAccessPolicyAccessRuleArgsDict(TypedDict):
        access: pulumi.Input[builtins.str]
        """
        The access level for this rule. Possible values are: `rw`, `ro`, `no`.
        """
        scope: pulumi.Input[builtins.str]
        """
        The scope of this rule. The `scope` and (potentially) the `filter` determine which clients match the rule. Possible values are: `default`, `network`, `host`.

        > **Note:** Each `access_rule` should set a unique `scope`.
        """
        anonymous_gid: NotRequired[pulumi.Input[builtins.int]]
        """
        The anonymous GID used when `root_squash_enabled` is `true`.
        """
        anonymous_uid: NotRequired[pulumi.Input[builtins.int]]
        """
        The anonymous UID used when `root_squash_enabled` is `true`.
        """
        filter: NotRequired[pulumi.Input[builtins.str]]
        """
        The filter applied to the `scope` for this rule. The filter's format depends on its scope: `default` scope matches all clients and has no filter value; `network` scope takes a CIDR format; `host` takes an IP address or fully qualified domain name. If a client does not match any filter rule and there is no default rule, access is denied.
        """
        root_squash_enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        Whether to enable [root squash](https://docs.microsoft.com/azure/hpc-cache/access-policies#root-squash)?
        """
        submount_access_enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        Whether allow access to subdirectories under the root export?
        """
        suid_enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        Whether [SUID](https://docs.microsoft.com/azure/hpc-cache/access-policies#suid) is allowed?
        """
elif False:
    CacheDefaultAccessPolicyAccessRuleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CacheDefaultAccessPolicyAccessRuleArgs:
    def __init__(__self__, *,
                 access: pulumi.Input[builtins.str],
                 scope: pulumi.Input[builtins.str],
                 anonymous_gid: Optional[pulumi.Input[builtins.int]] = None,
                 anonymous_uid: Optional[pulumi.Input[builtins.int]] = None,
                 filter: Optional[pulumi.Input[builtins.str]] = None,
                 root_squash_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 submount_access_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 suid_enabled: Optional[pulumi.Input[builtins.bool]] = None):
        """
        :param pulumi.Input[builtins.str] access: The access level for this rule. Possible values are: `rw`, `ro`, `no`.
        :param pulumi.Input[builtins.str] scope: The scope of this rule. The `scope` and (potentially) the `filter` determine which clients match the rule. Possible values are: `default`, `network`, `host`.
               
               > **Note:** Each `access_rule` should set a unique `scope`.
        :param pulumi.Input[builtins.int] anonymous_gid: The anonymous GID used when `root_squash_enabled` is `true`.
        :param pulumi.Input[builtins.int] anonymous_uid: The anonymous UID used when `root_squash_enabled` is `true`.
        :param pulumi.Input[builtins.str] filter: The filter applied to the `scope` for this rule. The filter's format depends on its scope: `default` scope matches all clients and has no filter value; `network` scope takes a CIDR format; `host` takes an IP address or fully qualified domain name. If a client does not match any filter rule and there is no default rule, access is denied.
        :param pulumi.Input[builtins.bool] root_squash_enabled: Whether to enable [root squash](https://docs.microsoft.com/azure/hpc-cache/access-policies#root-squash)?
        :param pulumi.Input[builtins.bool] submount_access_enabled: Whether allow access to subdirectories under the root export?
        :param pulumi.Input[builtins.bool] suid_enabled: Whether [SUID](https://docs.microsoft.com/azure/hpc-cache/access-policies#suid) is allowed?
        """
        pulumi.set(__self__, "access", access)
        pulumi.set(__self__, "scope", scope)
        if anonymous_gid is not None:
            pulumi.set(__self__, "anonymous_gid", anonymous_gid)
        if anonymous_uid is not None:
            pulumi.set(__self__, "anonymous_uid", anonymous_uid)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)
        if root_squash_enabled is not None:
            pulumi.set(__self__, "root_squash_enabled", root_squash_enabled)
        if submount_access_enabled is not None:
            pulumi.set(__self__, "submount_access_enabled", submount_access_enabled)
        if suid_enabled is not None:
            pulumi.set(__self__, "suid_enabled", suid_enabled)

    @property
    @pulumi.getter
    def access(self) -> pulumi.Input[builtins.str]:
        """
        The access level for this rule. Possible values are: `rw`, `ro`, `no`.
        """
        return pulumi.get(self, "access")

    @access.setter
    def access(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "access", value)

    @property
    @pulumi.getter
    def scope(self) -> pulumi.Input[builtins.str]:
        """
        The scope of this rule. The `scope` and (potentially) the `filter` determine which clients match the rule. Possible values are: `default`, `network`, `host`.

        > **Note:** Each `access_rule` should set a unique `scope`.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "scope", value)

    @property
    @pulumi.getter(name="anonymousGid")
    def anonymous_gid(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The anonymous GID used when `root_squash_enabled` is `true`.
        """
        return pulumi.get(self, "anonymous_gid")

    @anonymous_gid.setter
    def anonymous_gid(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "anonymous_gid", value)

    @property
    @pulumi.getter(name="anonymousUid")
    def anonymous_uid(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The anonymous UID used when `root_squash_enabled` is `true`.
        """
        return pulumi.get(self, "anonymous_uid")

    @anonymous_uid.setter
    def anonymous_uid(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "anonymous_uid", value)

    @property
    @pulumi.getter
    def filter(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The filter applied to the `scope` for this rule. The filter's format depends on its scope: `default` scope matches all clients and has no filter value; `network` scope takes a CIDR format; `host` takes an IP address or fully qualified domain name. If a client does not match any filter rule and there is no default rule, access is denied.
        """
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "filter", value)

    @property
    @pulumi.getter(name="rootSquashEnabled")
    def root_squash_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to enable [root squash](https://docs.microsoft.com/azure/hpc-cache/access-policies#root-squash)?
        """
        return pulumi.get(self, "root_squash_enabled")

    @root_squash_enabled.setter
    def root_squash_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "root_squash_enabled", value)

    @property
    @pulumi.getter(name="submountAccessEnabled")
    def submount_access_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether allow access to subdirectories under the root export?
        """
        return pulumi.get(self, "submount_access_enabled")

    @submount_access_enabled.setter
    def submount_access_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "submount_access_enabled", value)

    @property
    @pulumi.getter(name="suidEnabled")
    def suid_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether [SUID](https://docs.microsoft.com/azure/hpc-cache/access-policies#suid) is allowed?
        """
        return pulumi.get(self, "suid_enabled")

    @suid_enabled.setter
    def suid_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "suid_enabled", value)


if not MYPY:
    class CacheDirectoryActiveDirectoryArgsDict(TypedDict):
        cache_netbios_name: pulumi.Input[builtins.str]
        """
        The NetBIOS name to assign to the HPC Cache when it joins the Active Directory domain as a server.
        """
        dns_primary_ip: pulumi.Input[builtins.str]
        """
        The primary DNS IP address used to resolve the Active Directory domain controller's FQDN.
        """
        domain_name: pulumi.Input[builtins.str]
        """
        The fully qualified domain name of the Active Directory domain controller.
        """
        domain_netbios_name: pulumi.Input[builtins.str]
        """
        The Active Directory domain's NetBIOS name.
        """
        password: pulumi.Input[builtins.str]
        """
        The password of the Active Directory domain administrator.
        """
        username: pulumi.Input[builtins.str]
        """
        The username of the Active Directory domain administrator.
        """
        dns_secondary_ip: NotRequired[pulumi.Input[builtins.str]]
        """
        The secondary DNS IP address used to resolve the Active Directory domain controller's FQDN.
        """
elif False:
    CacheDirectoryActiveDirectoryArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CacheDirectoryActiveDirectoryArgs:
    def __init__(__self__, *,
                 cache_netbios_name: pulumi.Input[builtins.str],
                 dns_primary_ip: pulumi.Input[builtins.str],
                 domain_name: pulumi.Input[builtins.str],
                 domain_netbios_name: pulumi.Input[builtins.str],
                 password: pulumi.Input[builtins.str],
                 username: pulumi.Input[builtins.str],
                 dns_secondary_ip: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] cache_netbios_name: The NetBIOS name to assign to the HPC Cache when it joins the Active Directory domain as a server.
        :param pulumi.Input[builtins.str] dns_primary_ip: The primary DNS IP address used to resolve the Active Directory domain controller's FQDN.
        :param pulumi.Input[builtins.str] domain_name: The fully qualified domain name of the Active Directory domain controller.
        :param pulumi.Input[builtins.str] domain_netbios_name: The Active Directory domain's NetBIOS name.
        :param pulumi.Input[builtins.str] password: The password of the Active Directory domain administrator.
        :param pulumi.Input[builtins.str] username: The username of the Active Directory domain administrator.
        :param pulumi.Input[builtins.str] dns_secondary_ip: The secondary DNS IP address used to resolve the Active Directory domain controller's FQDN.
        """
        pulumi.set(__self__, "cache_netbios_name", cache_netbios_name)
        pulumi.set(__self__, "dns_primary_ip", dns_primary_ip)
        pulumi.set(__self__, "domain_name", domain_name)
        pulumi.set(__self__, "domain_netbios_name", domain_netbios_name)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)
        if dns_secondary_ip is not None:
            pulumi.set(__self__, "dns_secondary_ip", dns_secondary_ip)

    @property
    @pulumi.getter(name="cacheNetbiosName")
    def cache_netbios_name(self) -> pulumi.Input[builtins.str]:
        """
        The NetBIOS name to assign to the HPC Cache when it joins the Active Directory domain as a server.
        """
        return pulumi.get(self, "cache_netbios_name")

    @cache_netbios_name.setter
    def cache_netbios_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "cache_netbios_name", value)

    @property
    @pulumi.getter(name="dnsPrimaryIp")
    def dns_primary_ip(self) -> pulumi.Input[builtins.str]:
        """
        The primary DNS IP address used to resolve the Active Directory domain controller's FQDN.
        """
        return pulumi.get(self, "dns_primary_ip")

    @dns_primary_ip.setter
    def dns_primary_ip(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "dns_primary_ip", value)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Input[builtins.str]:
        """
        The fully qualified domain name of the Active Directory domain controller.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "domain_name", value)

    @property
    @pulumi.getter(name="domainNetbiosName")
    def domain_netbios_name(self) -> pulumi.Input[builtins.str]:
        """
        The Active Directory domain's NetBIOS name.
        """
        return pulumi.get(self, "domain_netbios_name")

    @domain_netbios_name.setter
    def domain_netbios_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "domain_netbios_name", value)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input[builtins.str]:
        """
        The password of the Active Directory domain administrator.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def username(self) -> pulumi.Input[builtins.str]:
        """
        The username of the Active Directory domain administrator.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "username", value)

    @property
    @pulumi.getter(name="dnsSecondaryIp")
    def dns_secondary_ip(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The secondary DNS IP address used to resolve the Active Directory domain controller's FQDN.
        """
        return pulumi.get(self, "dns_secondary_ip")

    @dns_secondary_ip.setter
    def dns_secondary_ip(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "dns_secondary_ip", value)


if not MYPY:
    class CacheDirectoryFlatFileArgsDict(TypedDict):
        group_file_uri: pulumi.Input[builtins.str]
        """
        The URI of the file containing group information (`/etc/group` file format in Unix-like OS).
        """
        password_file_uri: pulumi.Input[builtins.str]
        """
        The URI of the file containing user information (`/etc/passwd` file format in Unix-like OS).
        """
elif False:
    CacheDirectoryFlatFileArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CacheDirectoryFlatFileArgs:
    def __init__(__self__, *,
                 group_file_uri: pulumi.Input[builtins.str],
                 password_file_uri: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] group_file_uri: The URI of the file containing group information (`/etc/group` file format in Unix-like OS).
        :param pulumi.Input[builtins.str] password_file_uri: The URI of the file containing user information (`/etc/passwd` file format in Unix-like OS).
        """
        pulumi.set(__self__, "group_file_uri", group_file_uri)
        pulumi.set(__self__, "password_file_uri", password_file_uri)

    @property
    @pulumi.getter(name="groupFileUri")
    def group_file_uri(self) -> pulumi.Input[builtins.str]:
        """
        The URI of the file containing group information (`/etc/group` file format in Unix-like OS).
        """
        return pulumi.get(self, "group_file_uri")

    @group_file_uri.setter
    def group_file_uri(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "group_file_uri", value)

    @property
    @pulumi.getter(name="passwordFileUri")
    def password_file_uri(self) -> pulumi.Input[builtins.str]:
        """
        The URI of the file containing user information (`/etc/passwd` file format in Unix-like OS).
        """
        return pulumi.get(self, "password_file_uri")

    @password_file_uri.setter
    def password_file_uri(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "password_file_uri", value)


if not MYPY:
    class CacheDirectoryLdapArgsDict(TypedDict):
        base_dn: pulumi.Input[builtins.str]
        """
        The base distinguished name (DN) for the LDAP domain.
        """
        server: pulumi.Input[builtins.str]
        """
        The FQDN or IP address of the LDAP server.
        """
        bind: NotRequired[pulumi.Input['CacheDirectoryLdapBindArgsDict']]
        """
        A `bind` block as defined above.
        """
        certificate_validation_uri: NotRequired[pulumi.Input[builtins.str]]
        """
        The URI of the CA certificate to validate the LDAP secure connection.
        """
        download_certificate_automatically: NotRequired[pulumi.Input[builtins.bool]]
        """
        Whether the certificate should be automatically downloaded. This can be set to `true` only when `certificate_validation_uri` is provided.
        """
        encrypted: NotRequired[pulumi.Input[builtins.bool]]
        """
        Whether the LDAP connection should be encrypted?
        """
elif False:
    CacheDirectoryLdapArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CacheDirectoryLdapArgs:
    def __init__(__self__, *,
                 base_dn: pulumi.Input[builtins.str],
                 server: pulumi.Input[builtins.str],
                 bind: Optional[pulumi.Input['CacheDirectoryLdapBindArgs']] = None,
                 certificate_validation_uri: Optional[pulumi.Input[builtins.str]] = None,
                 download_certificate_automatically: Optional[pulumi.Input[builtins.bool]] = None,
                 encrypted: Optional[pulumi.Input[builtins.bool]] = None):
        """
        :param pulumi.Input[builtins.str] base_dn: The base distinguished name (DN) for the LDAP domain.
        :param pulumi.Input[builtins.str] server: The FQDN or IP address of the LDAP server.
        :param pulumi.Input['CacheDirectoryLdapBindArgs'] bind: A `bind` block as defined above.
        :param pulumi.Input[builtins.str] certificate_validation_uri: The URI of the CA certificate to validate the LDAP secure connection.
        :param pulumi.Input[builtins.bool] download_certificate_automatically: Whether the certificate should be automatically downloaded. This can be set to `true` only when `certificate_validation_uri` is provided.
        :param pulumi.Input[builtins.bool] encrypted: Whether the LDAP connection should be encrypted?
        """
        pulumi.set(__self__, "base_dn", base_dn)
        pulumi.set(__self__, "server", server)
        if bind is not None:
            pulumi.set(__self__, "bind", bind)
        if certificate_validation_uri is not None:
            pulumi.set(__self__, "certificate_validation_uri", certificate_validation_uri)
        if download_certificate_automatically is not None:
            pulumi.set(__self__, "download_certificate_automatically", download_certificate_automatically)
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)

    @property
    @pulumi.getter(name="baseDn")
    def base_dn(self) -> pulumi.Input[builtins.str]:
        """
        The base distinguished name (DN) for the LDAP domain.
        """
        return pulumi.get(self, "base_dn")

    @base_dn.setter
    def base_dn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "base_dn", value)

    @property
    @pulumi.getter
    def server(self) -> pulumi.Input[builtins.str]:
        """
        The FQDN or IP address of the LDAP server.
        """
        return pulumi.get(self, "server")

    @server.setter
    def server(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "server", value)

    @property
    @pulumi.getter
    def bind(self) -> Optional[pulumi.Input['CacheDirectoryLdapBindArgs']]:
        """
        A `bind` block as defined above.
        """
        return pulumi.get(self, "bind")

    @bind.setter
    def bind(self, value: Optional[pulumi.Input['CacheDirectoryLdapBindArgs']]):
        pulumi.set(self, "bind", value)

    @property
    @pulumi.getter(name="certificateValidationUri")
    def certificate_validation_uri(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The URI of the CA certificate to validate the LDAP secure connection.
        """
        return pulumi.get(self, "certificate_validation_uri")

    @certificate_validation_uri.setter
    def certificate_validation_uri(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "certificate_validation_uri", value)

    @property
    @pulumi.getter(name="downloadCertificateAutomatically")
    def download_certificate_automatically(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the certificate should be automatically downloaded. This can be set to `true` only when `certificate_validation_uri` is provided.
        """
        return pulumi.get(self, "download_certificate_automatically")

    @download_certificate_automatically.setter
    def download_certificate_automatically(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "download_certificate_automatically", value)

    @property
    @pulumi.getter
    def encrypted(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the LDAP connection should be encrypted?
        """
        return pulumi.get(self, "encrypted")

    @encrypted.setter
    def encrypted(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "encrypted", value)


if not MYPY:
    class CacheDirectoryLdapBindArgsDict(TypedDict):
        dn: pulumi.Input[builtins.str]
        """
        The Bind Distinguished Name (DN) identity to be used in the secure LDAP connection.
        """
        password: pulumi.Input[builtins.str]
        """
        The Bind password to be used in the secure LDAP connection.
        """
elif False:
    CacheDirectoryLdapBindArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CacheDirectoryLdapBindArgs:
    def __init__(__self__, *,
                 dn: pulumi.Input[builtins.str],
                 password: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] dn: The Bind Distinguished Name (DN) identity to be used in the secure LDAP connection.
        :param pulumi.Input[builtins.str] password: The Bind password to be used in the secure LDAP connection.
        """
        pulumi.set(__self__, "dn", dn)
        pulumi.set(__self__, "password", password)

    @property
    @pulumi.getter
    def dn(self) -> pulumi.Input[builtins.str]:
        """
        The Bind Distinguished Name (DN) identity to be used in the secure LDAP connection.
        """
        return pulumi.get(self, "dn")

    @dn.setter
    def dn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "dn", value)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input[builtins.str]:
        """
        The Bind password to be used in the secure LDAP connection.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "password", value)


if not MYPY:
    class CacheDnsArgsDict(TypedDict):
        servers: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]
        """
        A list of DNS servers for the HPC Cache. At most three IP(s) are allowed to set.
        """
        search_domain: NotRequired[pulumi.Input[builtins.str]]
        """
        The DNS search domain for the HPC Cache.
        """
elif False:
    CacheDnsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CacheDnsArgs:
    def __init__(__self__, *,
                 servers: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 search_domain: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] servers: A list of DNS servers for the HPC Cache. At most three IP(s) are allowed to set.
        :param pulumi.Input[builtins.str] search_domain: The DNS search domain for the HPC Cache.
        """
        pulumi.set(__self__, "servers", servers)
        if search_domain is not None:
            pulumi.set(__self__, "search_domain", search_domain)

    @property
    @pulumi.getter
    def servers(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        A list of DNS servers for the HPC Cache. At most three IP(s) are allowed to set.
        """
        return pulumi.get(self, "servers")

    @servers.setter
    def servers(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "servers", value)

    @property
    @pulumi.getter(name="searchDomain")
    def search_domain(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The DNS search domain for the HPC Cache.
        """
        return pulumi.get(self, "search_domain")

    @search_domain.setter
    def search_domain(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "search_domain", value)


if not MYPY:
    class CacheIdentityArgsDict(TypedDict):
        type: pulumi.Input[builtins.str]
        """
        Specifies the type of Managed Service Identity that should be configured on this HPC Cache. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned` (to enable both). Changing this forces a new resource to be created.
        """
        identity_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        Specifies a list of User Assigned Managed Identity IDs to be assigned to this HPC Cache. Changing this forces a new resource to be created.

        > **Note:** This is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        """
        principal_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The Principal ID associated with this Managed Service Identity.
        """
        tenant_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The Tenant ID associated with this Managed Service Identity.
        """
elif False:
    CacheIdentityArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CacheIdentityArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[builtins.str],
                 identity_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 principal_id: Optional[pulumi.Input[builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] type: Specifies the type of Managed Service Identity that should be configured on this HPC Cache. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned` (to enable both). Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] identity_ids: Specifies a list of User Assigned Managed Identity IDs to be assigned to this HPC Cache. Changing this forces a new resource to be created.
               
               > **Note:** This is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        :param pulumi.Input[builtins.str] principal_id: The Principal ID associated with this Managed Service Identity.
        :param pulumi.Input[builtins.str] tenant_id: The Tenant ID associated with this Managed Service Identity.
        """
        pulumi.set(__self__, "type", type)
        if identity_ids is not None:
            pulumi.set(__self__, "identity_ids", identity_ids)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the type of Managed Service Identity that should be configured on this HPC Cache. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned` (to enable both). Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Specifies a list of User Assigned Managed Identity IDs to be assigned to this HPC Cache. Changing this forces a new resource to be created.

        > **Note:** This is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        """
        return pulumi.get(self, "identity_ids")

    @identity_ids.setter
    def identity_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "identity_ids", value)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Principal ID associated with this Managed Service Identity.
        """
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "principal_id", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Tenant ID associated with this Managed Service Identity.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tenant_id", value)


if not MYPY:
    class CacheNfsTargetNamespaceJunctionArgsDict(TypedDict):
        namespace_path: pulumi.Input[builtins.str]
        """
        The client-facing file path of this NFS target within the HPC Cache NFS Target.
        """
        nfs_export: pulumi.Input[builtins.str]
        """
        The NFS export of this NFS target within the HPC Cache NFS Target.
        """
        access_policy_name: NotRequired[pulumi.Input[builtins.str]]
        """
        The name of the access policy applied to this target. Defaults to `default`.
        """
        target_path: NotRequired[pulumi.Input[builtins.str]]
        """
        The relative subdirectory path from the `nfs_export` to map to the `namespace_path`. Defaults to `""`, in which case the whole `nfs_export` is exported.
        """
elif False:
    CacheNfsTargetNamespaceJunctionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CacheNfsTargetNamespaceJunctionArgs:
    def __init__(__self__, *,
                 namespace_path: pulumi.Input[builtins.str],
                 nfs_export: pulumi.Input[builtins.str],
                 access_policy_name: Optional[pulumi.Input[builtins.str]] = None,
                 target_path: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] namespace_path: The client-facing file path of this NFS target within the HPC Cache NFS Target.
        :param pulumi.Input[builtins.str] nfs_export: The NFS export of this NFS target within the HPC Cache NFS Target.
        :param pulumi.Input[builtins.str] access_policy_name: The name of the access policy applied to this target. Defaults to `default`.
        :param pulumi.Input[builtins.str] target_path: The relative subdirectory path from the `nfs_export` to map to the `namespace_path`. Defaults to `""`, in which case the whole `nfs_export` is exported.
        """
        pulumi.set(__self__, "namespace_path", namespace_path)
        pulumi.set(__self__, "nfs_export", nfs_export)
        if access_policy_name is not None:
            pulumi.set(__self__, "access_policy_name", access_policy_name)
        if target_path is not None:
            pulumi.set(__self__, "target_path", target_path)

    @property
    @pulumi.getter(name="namespacePath")
    def namespace_path(self) -> pulumi.Input[builtins.str]:
        """
        The client-facing file path of this NFS target within the HPC Cache NFS Target.
        """
        return pulumi.get(self, "namespace_path")

    @namespace_path.setter
    def namespace_path(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "namespace_path", value)

    @property
    @pulumi.getter(name="nfsExport")
    def nfs_export(self) -> pulumi.Input[builtins.str]:
        """
        The NFS export of this NFS target within the HPC Cache NFS Target.
        """
        return pulumi.get(self, "nfs_export")

    @nfs_export.setter
    def nfs_export(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "nfs_export", value)

    @property
    @pulumi.getter(name="accessPolicyName")
    def access_policy_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the access policy applied to this target. Defaults to `default`.
        """
        return pulumi.get(self, "access_policy_name")

    @access_policy_name.setter
    def access_policy_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "access_policy_name", value)

    @property
    @pulumi.getter(name="targetPath")
    def target_path(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The relative subdirectory path from the `nfs_export` to map to the `namespace_path`. Defaults to `""`, in which case the whole `nfs_export` is exported.
        """
        return pulumi.get(self, "target_path")

    @target_path.setter
    def target_path(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "target_path", value)


